package Beam::Minion;
our $VERSION = '0.001';
# ABSTRACT: A distributed task runner for Beam::Wire containers

#pod =head1 SYNOPSIS
#pod
#pod     beam minion worker <container>...
#pod     beam minion run <container> <service> [<args>...]
#pod     beam minion help
#pod
#pod =head1 DESCRIPTION
#pod
#pod L<Beam::Minion> is a distributed task runner. One or more workers are
#pod created to run tasks, and then each task is sent to a worker to be run.
#pod Tasks are configured by L<Beam::Wire> container files.
#pod
#pod =head1 SEE ALSO
#pod
#pod L<Beam::Wire>, L<Beam::Runner>, L<Minion>
#pod
#pod =cut

use strict;
use warnings;



1;

__END__

=pod

=head1 NAME

Beam::Minion - A distributed task runner for Beam::Wire containers

=head1 VERSION

version 0.001

=head1 SYNOPSIS

    beam minion worker <container>...
    beam minion run <container> <service> [<args>...]
    beam minion help

=head1 DESCRIPTION

L<Beam::Minion> is a distributed task runner. One or more workers are
created to run tasks, and then each task is sent to a worker to be run.
Tasks are configured by L<Beam::Wire> container files.

=head1 SEE ALSO

L<Beam::Wire>, L<Beam::Runner>, L<Minion>

=head1 AUTHOR

Doug Bell <preaction@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Doug Bell.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
