package Beam::Minion::Command::run;
our $VERSION = '0.001';
# ABSTRACT: Command to enqueue a job on Beam::Minion job queue

#pod =head1 SYNOPSIS
#pod
#pod     beam minion run <container> <service> [<args>...]
#pod
#pod =head1 DESCRIPTION
#pod
#pod This command adds a job to the L<Minion> queue to execute the given
#pod C<service> from the given C<container>.
#pod
#pod In order for the job to run, you must run a Minion worker using the
#pod L<beam minion worker command|Beam::Minion::Command::worker>.
#pod
#pod =head1 SEE ALSO
#pod
#pod L<Beam::Minion>, L<Minion>
#pod
#pod =cut

use strict;
use warnings;
use Beam::Minion::Util qw( minion );

sub run {
    my ( $class, $container, $service_name, @args ) = @_;
    my $minion = minion();
    $minion->enqueue( $service_name, \@args, { queue => $container } );
}

1;

__END__

=pod

=head1 NAME

Beam::Minion::Command::run - Command to enqueue a job on Beam::Minion job queue

=head1 VERSION

version 0.001

=head1 SYNOPSIS

    beam minion run <container> <service> [<args>...]

=head1 DESCRIPTION

This command adds a job to the L<Minion> queue to execute the given
C<service> from the given C<container>.

In order for the job to run, you must run a Minion worker using the
L<beam minion worker command|Beam::Minion::Command::worker>.

=head1 SEE ALSO

L<Beam::Minion>, L<Minion>

=head1 AUTHOR

Doug Bell <preaction@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Doug Bell.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
