#!/usr/bin/perl

# Copyright 2007 Kevin Ryde

# This file is part of Devel::Mallinfo.

# Devel::Mallinfo is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 3, or (at your option) any later
# version.

# Devel::Mallinfo is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.

# You should have received a copy of the GNU General Public License along
# with Devel::Mallinfo.  If not, see <http://www.gnu.org/licenses/>.


use strict;
use warnings;

if ($ARGV[0] eq '--generate') {
  open OUT, '>conftest.c' or die;
  print OUT <<EOF;
/* generated by config.pl */
#include <stdlib.h>
#include <malloc.h>
int
main (void)
{
  struct mallinfo m;
  m = mallinfo ();
  return (m.arena != 0);\n
}
EOF
  close OUT or die;
  exit 0;
}


my $conftest_exe = $ARGV[1];

sub have_mallinfo {
  if (-f $conftest_exe) {
    return 1;
  } else {
    print <<EOF;
+--------------------------------------+
+ WARNING:                             |
+ WARNING: mallinfo() not available    |
+ WARNING: this module will do nothing |
+ WARNING:                             |
+--------------------------------------+
EOF
    return 0;
  }
}

sub mallinfo_fields {
  open IN, '<conftest.i' or die;
  my $preproc = do { local $/ = undef; <IN> };
  close IN or die;
  
  if (! ($preproc =~ /struct\s+mallinfo\s*\{(.*?)}/s)) {
    print "\"struct mallinfo\" not found in conftest.i preprocessed output\n";
    return ();
  }

  my $body = $1;
  my @fields;
  while ($body =~ /([A-Za-z0-9_]+)\s*;/g) {
    push @fields, $1;
  }
  if (@fields) {
    print "struct mallinfo fields found:\n  ", join(' ', @fields), "\n";
  } else {
    print "no fields matched in \"struct mallinfo\" body\n";
  }
  return @fields;
}

my $have_mallinfo = have_mallinfo();
my @fields = ();
if ($have_mallinfo) {
  @fields = mallinfo_fields();
  if (! @fields) {
    print <<EOF;
+----------------------------------------------+
+ WARNING:                                     |
+ WARNING: cannot grep struct mallinfo fields, |
+ WARNING: using default fallbacks             |
+ WARNING:                                     |
+----------------------------------------------+
EOF
    @fields = qw(arena ordblks smblks hblks hblkhd
                 usmblks fsmblks uordblks fordblks keepcost);
  }
}

open OUT, '>config.h' or die;
print OUT "
/* generated by config.pl */

#define HAVE_MALLINFO $have_mallinfo

#define STRUCT_MALLINFO_FIELDS \\
";
foreach my $field (@fields) {
  print OUT "  FIELD($field); \\\n";
}
print OUT "  /*end*/\n";
close OUT or die;

exit 0;
