#!/usr/bin/env perl
################################################################################
# Simple usage example.
################################################################################
use strict;
use warnings;
use FindBin qw/$Bin/;
use lib "$Bin/../lib";

our $VERSION = 0.01;

use DateTime;
use Astro::Montenbruck::Ephemeris qw/iterator/;
use Astro::Montenbruck::Ephemeris::Planet qw/@PLANETS/;
use Data::Dumper;

my $jd = DateTime->now->jd; # Standard Julian date for current moment
my $t  = ($jd - 2451545) / 36525; # Convert Julian date in centuries
# for more accuracy t should be converted to Ephemeris time.

my $iter = iterator($t, \@PLANETS); # get iterator function

while ( my $result = $iter->() ) {
    my ($id, $co) = @$result;
    print $id, "\n", Dumper($co), "\n"; # geocentric longitude, latitude and distance from Earth
}
