
use strict;
use warnings;



use ExtUtils::MakeMaker 6.31;



my %WriteMakefileArgs = (
  'ABSTRACT' => 'MARC bibliographic records set of tools',
  'AUTHOR' => 'Frédéric Demians <f.demians@tamil.fr>',
  'BUILD_REQUIRES' => {
    'FindBin' => '0',
    'Test::More' => '0'
  },
  'CONFIGURE_REQUIRES' => {
    'ExtUtils::MakeMaker' => '6.31'
  },
  'DISTNAME' => 'Marc',
  'EXE_FILES' => [],
  'LICENSE' => 'perl',
  'NAME' => 'Marc',
  'PREREQ_PM' => {
    'Carp' => '0',
    'Moose' => '1.00',
    'Moose::Util::TypeConstraints' => '0',
    'Text::Iconv' => '1.7',
    'XML::Writer' => '0.606',
    'YAML' => '0',
    'namespace::autoclean' => '0',
    'overload' => '0'
  },
  'VERSION' => '0.001',
  'test' => {
    'TESTS' => 't/*.t'
  }
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



