/*
 * url.c: deal with URLs
 *
 * Copyright(c) 1997-2000 - All Rights Reserved
 *
 * See the COPYRIGHT file.
 */

#ifndef lint
static char rcsid[] = "@(#)$Id: url.c,v 1.4 2000/07/31 22:33:56 kalt Exp $";
#endif

#include "os.h"

#include "struct.h"
#include "utils.h"
#include "window.h"

char urlf[255];

void
url_init(cf_dir)
char *cf_dir;
{
  strcpy(urlf, cf_dir);
  strcat(urlf, "URLs");
}

void
url_find(sender, target, text)
char *sender, *target, *text;
{
  char *url = text;
  char tbuf[15];
  FILE *lf = NULL;

  while (url = strstr(url, "://"))
    {
      char *end = url, bk;
      
      lf = fopen(urlf, "a");
      if (lf == NULL)
	  return;

      while (url > text && isalpha((int) *(url-1))) url -= 1;
      while (*end && !isspace((int) *end)) end += 1;
      bk = *end;
      *end = '\0';
      vsic_slog(LOG_DEBUG, "Logging URL: %s", url);
      fprintf(lf, "%s %s %s\n\t%s\n", my_strftime(tbuf, 15, "%y/%m/%d %R"),
	      sender, (target) ? target : "private", url);

      *end = bk;
      url = end;
    }
  if (lf)
      fclose(lf);
}

