(* Copyright (C) 1989, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Mon Jul  6 16:43:19 PDT 1992 by muller         *)
(*      modified on Thu Jan 30 09:19:10 PST 1992 by kalsow         *)

INTERFACE ThreadF;

IMPORT FloatMode, Thread;

(*------------------------------------------------------ compiler support ---*)

<*EXTERNAL "_M3__bottom_of_stack"*> VAR bottom_of_stack: ADDRESS;
<*EXTERNAL "_M3__stack_grows_down"*>VAR stack_grows_down: INTEGER;
<*EXTERNAL "_M3__handlers"*>        VAR currentHandlers: ADDRESS;
<*EXTERNAL "_M3__stackLimit"*>      VAR currentStackLimit: ADDRESS;

(* these variables are read and written directly by compiler generated code.
   Changing their names, types or values is very dangerous. *)

(*--------------------------------------------- garbage collector support ---*)

PROCEDURE ProcessStacks (p: PROCEDURE (start, stop: ADDRESS));
(* This procedure apply p to each stack, with start and stop being the limits
   of the stack. It is there mainly for the benefit of the garbage collector.
   *)

(*------------------------------------------------ floating point support ---*)

PROCEDURE MyFPState (): UNTRACED REF FloatMode.ThreadState;
(* returns the saved floating point state for the current thread.
   WARNING: the return value is an untraced pointer to a traced Thread.T!!  *)

(*-------------------------------------------------- showthreads support ---*)

TYPE
  State = {
        alive    (* can run *),
        waiting  (* waiting for a condition via Wait *),
        locking  (* waiting for a mutex to be unlocked *),
        pausing  (* waiting until some time is arrived *),
        blocking (* waiting for some IO *),
        dying    (* done, but not yet joined *),
        dead     (* done and joined *)
	};

TYPE
  Id = INTEGER;

(*--------------------------------------------------------- hooks support ---*)

(* PRIVATE VAR hooks: Hooks := NIL *)

TYPE
  Hooks = OBJECT METHODS
    fork (t: Thread.T);  (* called with RT0u.inCritical > 0 *)
    die  (t: Thread.T);  (* called with RT0u.inCritical > 0 *)
  END;

PROCEDURE RegisterHooks (h: Hooks; init := TRUE): Hooks RAISES {};
(* return current hooks and set hooks := h.   If init is true, 
   call hooks.fork (t) for every thread t in the ring in a single
   critical section. *)

PROCEDURE MyId(): Id RAISES {};
(* return Id of caller *)


END ThreadF.
