(* Copyright (C) 1989, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Mon Mar 23 10:28:06 PST 1992 by kalsow     *)
(*      modified on Thu Nov  2 18:13:34 1989 by muller         *)


(* As an example of a writer class implementation, this section
describes a simplified version of text writers.
   
The target of a text writer is an internal buffer whose contents can
be retrieved as a TEXT.  Retrieving the buffer resets the target to be
empty.

Text writers are buffered, seekable, and never raise Failure or
Alerted.  The fact that they are buffered is essentially unobservable,
since there is no way for the client to access the target except
through the text writer.  The interface is: *)

INTERFACE TextWr;
IMPORT Wr;

TYPE T <: Wr.T;


PROCEDURE New(): T;
(* Return a new text writer with c = "", cur = 0. *)

PROCEDURE ToText(wr: T): TEXT;
(* Return c(wr), resetting c(wr) to "" and cur(wr) to zero. *)

END TextWr.

