(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Tue Jun 16 13:16:21 PDT 1992 by muller *)
(*      modified on Fri Nov  1 23:17:53 PST 1991 by meehan *)

MODULE Range;

PROCEDURE End (    start       : CARDINAL;
               VAR length      : CARDINAL;
                   actualLength: CARDINAL  ): CARDINAL RAISES {Error} =
  BEGIN
    IF start > actualLength THEN
      RAISE Error (ErrorCode.StartTooBig)
    ELSIF length = LAST (CARDINAL) THEN
      length := actualLength - start;
      RETURN actualLength
    ELSIF start > actualLength - length THEN
      (* i.e., if start+length > actualLength, but avoiding possible
         overflow *)
      RAISE Error (ErrorCode.EndTooBig)
    ELSE
      RETURN start + length
    END
  END End;

BEGIN END Range.



