(* Copyright (C) 1989, 1992, Digital Equipment Corporation                   *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)

(* Last modified on Mon Feb 24 11:32:41 PST 1992 by muller                   *)
(*      modified on Sat Aug  3 00:45:49 1991 by kalsow                       *)


(* The FileStream interface provides simple routines for opening
files.  The detailed semantics of the file system vary greatly from
system to system, so it is to be expected that this interface will
grow in different directions in different systems.  But all systems
should be able to implement the following very weakly-specified
interface, and thereby provide a measure of portability for simple
clients.

The interface doesn't specify whether the readers and writers returned
by the procedures are seekable or buffered.  Probably readers and
writers to disk files are seekable and buffered, but in general this
depends on the system.  

Closing a file reader or writer closes the underlying file.  *)
     
INTERFACE FileStream;
IMPORT Rd, Wr, IOFailure;

(* The failures returned by file readers and writers are
   errors occurring during calls to the operating system.
   {Rd,Wr}.Failure exceptions return a Failure, which indicates the
   operation during which the error occurred and the exact error can
   be found by looking at Cerrno.errno *)

TYPE
  FailureKind = IOFailure.Kind;
  Failure = IOFailure.T;
 

PROCEDURE OpenRead (n: TEXT): Rd.T RAISES {Rd.Failure};
(* Return a reader whose source is the contents of the file named n. *)

PROCEDURE OpenWrite(n: TEXT): Wr.T RAISES {Wr.Failure};
(* Return a writer whose target is the contents of the file named n.
If the file does not exist it will be created; if it does exist it
will be truncated to length zero. *)

PROCEDURE OpenAppend(n: TEXT): Wr.T RAISES {Wr.Failure};
(* Return a writer whose target is the contents of the file named n.
If the file does not exist it will be created; if it does exist then
the writer will be positioned to append to the existing contents of
the file. *)

END FileStream.
