(* Copyright (C) 1989, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: M3Lninker.m3                                          *)
(* Last Modified On Wed Feb 12 08:53:24 PST 1992 By kalsow     *)

MODULE M3Linker EXPORTS M3Linker, M3LinkerRep;

IMPORT Wr, Word, Thread;

PROCEDURE Contents (base: LinkSet): UnitList =
  VAR units: UnitList := NIL;
  BEGIN
    IF (base # NIL) THEN
      VAR ui := base.all_units; BEGIN
        WHILE (ui # NIL) DO
          units := NEW (UnitList, next := units, unit := ui.unit);
          ui := ui.next;
        END;
      END;
    END;
    RETURN units;
  END Contents;

PROCEDURE TypeName (t: Type): TEXT =
  VAR x := "type";
  BEGIN
    IF (t = NIL) THEN RETURN "<NIL>" END;
    IF (t.name # NIL) THEN x := x & " " & t.name END;
    IF (t.uid.text # NIL) THEN x := x & " (" & t.uid.text & ")" END;
    IF (t.unit # NIL) THEN x := x & " in " & UnitName (t.unit) END; 
    RETURN x;
  END TypeName;

PROCEDURE UTypeName (t: UndefinedType): TEXT =
  VAR x := "type";
  BEGIN
    IF (t = NIL) THEN RETURN "<NIL>" END;
    IF (t.name # NIL) THEN x := x & " " & t.name END;
    IF (t.uid.text # NIL) THEN x := x & " (" & t.uid.text & ")" END;
    RETURN x;
  END UTypeName;

PROCEDURE UnitName (u: Unit): TEXT =
  CONST Tag = ARRAY BOOLEAN OF TEXT { ".m3", ".i3" };
  BEGIN
    IF (u = NIL) THEN RETURN "<NIL>" END;
    RETURN u.name.text & Tag [u.interface];
  END UnitName;

PROCEDURE WriteStamp (wr: Wr.T;  READONLY x: StampData) =
  BEGIN
    FOR i := FIRST (x) TO LAST (x) DO OutHex (wr, x[i]) END;
  END WriteStamp;

CONST
  HexDigit = ARRAY [0..15] OF CHAR {
                 '0','1','2','3','4','5','6','7',
                 '8','9','a','b','c','d','e','f' };

PROCEDURE OutHex (wr: Wr.T;  x: INTEGER) =
  <*FATAL Wr.Failure, Thread.Alerted*>
  VAR buf: ARRAY [0..7] OF CHAR;
  BEGIN
    FOR j := 7 TO 0 BY -1 DO
      buf[j] := HexDigit [Word.Mod (x, 16)];
      x := Word.Divide (x, 16);
    END;
    FOR j := 0 TO 7 DO Wr.PutChar (wr, buf[j]) END;
  END OutHex;

BEGIN
END M3Linker.
