(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: RecordType.i3                                         *)
(* Last Modified On Mon Jun  8 08:20:47 PDT 1992 By kalsow     *)
(*      Modified On Sun Sep  9 06:32:29 1990 By muller         *)

INTERFACE RecordType;

IMPORT Type, String, Scope, Token, Value;

PROCEDURE Parse (READONLY fail: Token.Set): Type.T;
PROCEDURE ParseFieldList (READONLY fail: Token.Set);

PROCEDURE New (fields: Scope.T): Type.T;

PROCEDURE Split (t: Type.T;  VAR fields: Scope.T): BOOLEAN;

PROCEDURE LookUp (t: Type.T;  name: String.T;  VAR field: Value.T): BOOLEAN;

PROCEDURE SizeAndAlignment (fields: Scope.T;  VAR recSize, recAlign: INTEGER);

PROCEDURE RoundUp (size, alignment: INTEGER): INTEGER;

END RecordType.
