(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Enum.i3                                               *)
(* Last Modified On Wed Aug  7 18:22:04 1991 By kalsow         *)
(*      Modified On Fri Feb  9 07:38:15 1990 By muller         *)

INTERFACE EnumType;

IMPORT Type, Scope, String, Value, Token;

PROCEDURE Parse (READONLY fail: Token.Set): Type.T;

PROCEDURE New (nElts: INTEGER; elts: Scope.T): Type.T;

PROCEDURE Is (t: Type.T): BOOLEAN;

PROCEDURE LookUp (t: Type.T;  name: String.T;  VAR value: Value.T): BOOLEAN;

PROCEDURE Split (t: Type.T; nElts: INTEGER; elts: Scope.T): BOOLEAN;
PROCEDURE SetSize (t: Type.T; size: INTEGER);

END EnumType.
