#
# site.pl -- Site dependent code (mostly defining system params)
#
# site.pl,v 2.10 1993/09/26 02:48:27 sanders Exp
#
# by Tony Sanders <sanders@bsdi.com>, July 1993
#

# Configure logger: select one or the other
require 'log-simple.pl'; &logger'init('log');
# require 'log-syslog.pl'; &logger'init();

# This sample net_filter would restrict access to only your local network.
#
# sub net_filter {
#     local($fromfd, $peeraddr, $action, $path, $version) = @_;
#     local($mynet) = pack("C4", 128, 46, 0 0);		# your Class B network
#     local($mymask) = 0xffff0000;			# mask for Class B
#     # If you are doing finer control you might be returning
#     # errors like unauthorized or payment_required and fixing
#     # %out_headers to include the relavent information.
#     &error('bad_request', "$action $path invalid") unless
#         (((unpack($main'sockaddr, $peeraddr))[2] & $mymask) == $mynet);
# }

#
# Error codes
#
do 'errno.ph';
eval 'sub ENOENT {2;}'		unless defined &ENOENT;
eval 'sub EINTR {4;}'		unless defined &EINTR;
eval 'sub EINVAL {22;}'		unless defined &EINVAL;

#
# Socket/Networking support
#
do 'sys/socket.ph';
eval 'sub AF_INET {2;}'		unless defined &AF_INET;
eval 'sub SOCK_STREAM {1;}'	unless defined &SOCK_STREAM;
eval 'sub SOMAXCONN {5;}'	unless defined &SOMAXCONN;
eval 'sub SOL_SOCKET {0xffff;}'	unless defined &SOL_SOCKET;
eval 'sub SO_REUSEADDR {0x04;}' unless defined &SO_REUSEADDR;
$sockaddr = 'S n a4 x8';	# socket structure format

#
# File locking
#
do 'sys/unistd.ph';
eval 'sub SEEK_SET {0;}'	unless defined &SEEK_SET;

do 'sys/file.ph';
eval 'sub LOCK_SH {0x01;}'	unless defined &LOCK_SH;
eval 'sub LOCK_EX {0x02;}'	unless defined &LOCK_EX;
eval 'sub LOCK_NB {0x04;}'	unless defined &LOCK_NB;
eval 'sub LOCK_UN {0x08;}'	unless defined &LOCK_UN;

do 'fcntl.ph';
eval 'sub F_RDLCK {1;}'		unless defined &F_RDLCK;
eval 'sub F_UNLCK {2;}'		unless defined &F_UNLCK;
eval 'sub F_WRLCK {3;}'		unless defined &F_WRLCK;
eval 'sub F_SETLK {8;}'		unless defined &F_SETLK;
eval 'sub F_SETLKW {9;}'	unless defined &F_SETLKW;
eval 'sub F_SETFD {2;}'		unless defined &F_SETFD;	# close-on-exec
$s_flock = "sslll";		# struct flock {type, whence, start, len, pid}

sub seize {
    local ($FH, $lock) = @_;
    if ($plexus{'locking'} eq "flock") {
        flock($FH, $lock);
    } else {
	local ($flock, $type) = 0;
	if ($lock & &LOCK_SH) { $type = &F_RDLCK; }
	elsif ($lock & &LOCK_EX) { $type = &F_WRLCK; }
	elsif ($lock & &LOCK_UN) { $type = &F_UNLCK; }
	else { $! = &EINVAL; return undef; }
	$flock = pack($s_flock, $type, &SEEK_SET, 0, 0, 0);
	fcntl($FH, ($lock & &LOCK_NB) ? &F_SETLK : &F_SETLKW, $flock);
    }
}

sub setfd {
    local($flag, $_) = shift @_;
    while ($_ = shift @_) {
        fcntl($_, &F_SETFD, $flag);		# set/clear close-on-exec
    }
}

#
# File/Directory support
#
do 'sys/stat.ph';
eval 'sub S_ISDIR {
    local($m) = @_;
    eval "(($m & 0170000) == 0040000)";
}'				unless defined &S_ISDIR;

#
# Processes
#
do 'sys/wait.ph';
eval 'sub WNOHANG {1;}'		unless defined &WNOHANG;

1;
