# mime.pl -- handle MIME headers
#
# mime.pl,v 2.7 1993/10/02 07:13:14 sanders Exp
#
# by Tony Sanders <sanders@bsdi.com>, April 1993
#

#
# Any additional headers are expected in %out_headers
#
sub MIME_header {
    local($status, $content) = @_;
    &main'set_timeout();
    return 0 unless $version;       # if $version !~ m/$htrq_version/i;
    $status = 'internal_error' unless defined($main'code{$status});
    printf("%s %s\n", $http_version, $main'code{$status});
    &unparse_headers(*out_headers);
    printf("MIME-version: 1.0\n");
    printf("Content-type: $content\n\n");
    exit 0 if $main'access_via_head == 1;	# using HEAD method.
    1;
}

sub fmt_date {
    local($time) = @_;
    local(@DoW) = ('Sunday','Monday','Tuesday','Wednesday',
                   'Thursday','Friday','Saturday');
    local(@MoY) = ('Jan','Feb','Mar','Apr','May','Jun',
		   'Jul','Aug','Sep','Oct','Nov','Dec');
    local($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) =
        gmtime($time);
    sprintf("%s, %02d-%s-%02d %02d:%02d:%02d GMT",
        $DoW[$wday], $mday, $MoY[$mon], $year, $hour, $min, $sec);
}

sub parse_headers {
    local(*headers) = @_;
    local($_, $field);
    while ($_ = <STDIN>) {
	s/[ \t\r\n]*$//;
	last if /^$/;		# leave the body of the message for whomever
	# &debug("header: $_"); # DEBUG: XXX: FIXME
        if (/^[ \t]/) {
	    # continuation line
            last unless $field;
            s/^[ \t]*/ /;
            $headers{$field} .= $_;
        } else {
	    $field = &add_header(*headers, $_);
	}
    }
}

sub add_header {
    local(*headers, $_) = @_;
    local($field, $data) = split(/\s*:\s*/, $_, 2);
    $field =~ y/A-Z/a-z/; substr($field,0,1) =~ y/a-z/A-Z/;
    $headers{$field} .= "\377" if defined $headers{$field};
    $headers{$field} .= $data;
    return $field;
}

#
# Spit headers back out from internal format
#
sub unparse_headers {
    local(*headers, @list, $i) = @_;
    local($,);
    foreach $i (keys %headers) {
        @list = grep($_ .= "\n", split("\377", $headers{$i}));
        $, = "$i: "; print "",@list;
    }
}

#
# Read input using either Length: or Message-Boundry:
#
sub parse_body {
    local($FROM) = @_;
    local($_, $buf, $len, $length, $boundary);
    $length = $main'in_headers{'Length'} if defined $main'in_headers{'Length'};
    $length = $main'in_headers{'Content-length'} if defined $main'in_headers{'Content-length'};
    $boundary = $main'in_headers{'Message-boundary'} if defined $main'in_headers{'Message-boundary'};
    if (defined $length) {
	&debug("parse_body: length $length");
	while (($length > 0) && (($len = read($FROM, $_, $length)) != 0)) {
	    &main'set_timeout() if defined &main'set_timeout;
	    if (!defined $len) {
		next if $! =~ /^Interrupted/;
		&main'error('internal_error', "System read error: $!");
	    }
	    $buf .= $_;
	    $length -= $len;
	}
    } elsif (defined $boundary) {
	&debug("parse_body: boundary");
        $boundary = "--" . $boundary;
        while (<$FROM>) { chop; next if $_ eq $boundary; }
        while (<$FROM>) { chop; last if $_ eq $boundary; print $_, "\n"; }
    } else {
        &debug("parse_body: error, no body found");
    }
    $buf;	# returns undef if neither length nor bounary found
}

1;
