.TH FTW 3
.\" $Header: /home-local/pfeifer/CVS/freeWAIS-sf/lib/ftw.man,v 2.2 1997/02/04 17:13:56 pfeifer Exp $
.SH NAME
ftw \- walk a file tree
.SH SYNOPSIS
.ft B
.nf
#include <ftw.h>

int
ftw(directory, funcptr, depth)
	char *directory;
	int (*funcptr)();
	int depth;

#include <sys/stat.h>

int
funcptr(item, sb, flag)
	char *item;
	struct stat *sb;
	int flag;
.fi
.ft R
.SH DESCRIPTION
.I Ftw
walks through the directory tree starting from the indicated
.IR path .
For every entry it finds in the tree, it calls the user-supplied
.I funcptr
with the calling sequence given in the synopsis above.
The first argument is the full pathname of the entry (rooted from
the
.I directory
parameter given to
.IR ftw );
the second argument is a pointer to the
.IR stat (2)
structure for the entry;
and the third argument is one of the #define's in the header file.
This value will be one of the following:
.RS
.ta \w'FTW_DNR  'u
.nf
FTW_F	Item is a normal file
FTW_D	Item is a directory
FTW_NS	The stat failed on the item
FTW_DNR	Item is a directory which can't be read
.fi
.RE
Note, however, that FTW_F is a misnomer; anything other than directories
are (e.g., symbolic links) get the FTW_F tag.
.PP
.I Ftw
recursively calls itself when it encounters a directory.
To avoid using up all a program's file descriptors, the
.I depth
argument specifies the number of simultaneous open directories to maintain.
When the depth is exceeded, the routine will become noticeably
slower because directories are closed in ``most-recently-used'' order.
.PP
To stop the tree walk, the user-supplied function should return a
non\-zero value; this value will become the return value of
.IR ftw .
Otherwise,
.I ftw
will continue until it has scanned the entire tree, in which case it will
return zero, or until it hits an error such as a
.IR malloc (3)
failure, in which case it will return \-1.
.PP
Because
.I ftw
uses dynamic data structures, the only safe way to exit out of a tree
walk is to return a non-zero value.
To handle interrupts, for example, mark that the interrupt occured
and return a non\-zero value\(em don't use
.I longjmp (3)
unless the program is going to terminate.
.SH SEE ALSO
stat(2)
