.\"Copyright 1990 GROUPE BULL -- See licence conditions in file COPYRIGHT
.TH SXPM 1
.PD
.ad b
.SH NAME
sxpm \- Show an XPM (X PixMap) file and/or convert XPM2 files to XPM version 3.
.SH SYNOPSIS
\fBsxpm\fR
[\|\fB-d\fR displayname\|] 
[\|\fB-g\fR geometry\|] 
[\|\fB-s\fR symbol color_name\|] 
[\|\fB-p\fR symbol pixel_value\|] 
[\|\fB-in\fR filename\|] 
[\|\fB-out\fR filename\|] 
[\|\fB-stdin\fR\|] 
[\|\fB-stdout\fR\|] 
[\|\fB-nod\fR\|] 
[\|\fB-rgb\fR filename\|] 
.SH DESCRIPTION
.PP
The \fIsxpm\fP program can be used to view any XPM (version 2 or 3) file and/or
to convert a file from XPM2 to XPM version 3. If \fIsxpm\fP is run without any
option specified, the plaid pixmap which is stored as data will be shown. If
no geometry is specified, the show window will have the size of the read
pixmap.
Pressing the key Q in the window will quit the program.
.SH OPTIONS
.TP 8
.B \-d \fIdisplay\fP
Specifies the display to connect to.
.TP 8
.B \-g \fIgeom\fP
Window geometry (default is pixmap's size).
.TP 8
.B \-s \fIsymbol colorname\fP
Overwrite default color to \fIsymbol\fP to \fIcolorname\fp.
.TP 8
.B \-p \fIsymbol pixelvalue\fP
Overwrite default color to \fIsymbol\fP to \fIpixelvalue\fp.
.TP 8
.B \-in \fIfilename\fP
Read the input from the file \fIfilename\fP.
.TP 8
.B \-out \fIfilename\fP
Write the output to the file \fIfilename\fP.  Overwrite if it already exists.
.TP 8
.B \-stdin
Read the input from the standard input.
.TP 8
.B \-stdout
Write the output to the standard output.
.TP 8
.B \-nod
Do not display the pixmap in a window.  (Useful when using as converter)
.TP 8
.B \-rgb \fIfilename\fP
Search color names in the file \fIfilename\fP and write them out instead of
the rgb values.

.SH KNOWN BUGS
When converting a file from XPM2 to XPM version 3, if several pixels (symbols)
get the same color only one will be in the file written out.

.SH AUTHOR
Arnaud Le Hors    (lehors@mirsa.inria.fr)
.br
Bull Research France
.br
Copyright (C) 1990 by Groupe Bull.
