#include <stdio.h>
#include <sys/types.h>
#include <sys/types.h>
#include <sys/statvfs.h>
#include "configdata.h"
#include "clibrary.h"
#include "innd.h"
#include "dbz.h"
#include "art.h"
#include <sys/uio.h>

#include "mydir.h"
#include "tree.h"
#include "can.h"


#define STATFS statvfs 


void
ARTsetupCan()
{
    DIR		*dirp, *shelfDirp;
    ARTCAN	*newCan, *foundCan;
    DIRENTRY	*dp, *shelfDp;
    time_t	delete;
    char	*name;
    int		fd;
    BOOL	failed=FALSE;
    
    CANsetup();
    
    dirp=opendir(".");
    for( dp=readdir(dirp); dp!=NULL; dp=readdir(dirp) )
    {	if( !strncmp(dp->d_name, "shelf.", 6))
	{   shelfDirp=opendir(dp->d_name);
	
	    for(shelfDp=readdir(shelfDirp);shelfDp;shelfDp=readdir(shelfDirp) )
	    {	if( strlen(shelfDp->d_name)!=strlen("yyyymmddhhxx") )
		    continue;
		
		if( (delete=CANdelete(shelfDp->d_name))==0 )
		    continue;

		if( (delete%CANTIME)!=0 )
		{   syslog(L_NOTICE, 
			"%s problem with CANdelete() of %s/%s",
			LogName, dp->d_name, shelfDp->d_name);
		    syslog(L_NOTICE, "%s delete=%d (%.2f), fixing", 
		    	LogName, delete, (float)delete/CANTIME);
		    
		    syslog(L_NOTICE, "1. %.2f", ((float)delete/CANTIME+0.5));
		    syslog(L_NOTICE, "2. %d", ((time_t) 
		    				((float)delete/CANTIME+0.5)));
		    syslog(L_NOTICE, "3. %d", ((time_t)((float) 
		    				delete/CANTIME+0.5))*CANTIME);
		    
		    delete=((time_t)((float)delete/CANTIME+0.5))*CANTIME;
		}   

	    	name=calloc(strlen(dp->d_name)+1+strlen(shelfDp->d_name)+1,
								sizeof(char));
		sprintf(name, "%s/%s", dp->d_name, shelfDp->d_name);

		if( (fd=open(name, O_RDWR, 0666))<0 )
		{   syslog(L_FATAL, "%s cant open %s %m", LogName, name);
		    failed=TRUE;
		}
		
		if( CANcheck(fd)!=0 )
		{   if( CANrecover(fd)!=0 )
		    {   syslog(L_FATAL,"%s cant recover can %s", LogName,name);
		    	failed=TRUE;
		    }
		    syslog(L_ERROR, "%s check history for entries of can %s!", 
		    						LogName, name);
		}
		
		close(fd);
  
		newCan=(ARTCAN *)calloc(1, sizeof(ARTCAN));
		newCan->Name=name;
		newCan->Version=1;
		newCan->Number=atoi(&shelfDp->d_name[10]);
		newCan->Delete=delete;
		
		if((foundCan=tree_srch(&canTree[WRITE],compareWriteCan,newCan))
		&&  foundCan->Number>newCan->Number )
		{   syslog(L_TRACE, "%s found %s, but still have #%d", 
				LogName, newCan->Name, foundCan->Number);
		}
		else if( foundCan && foundCan->Number==newCan->Number )
		{   syslog(L_ERROR, "%s found %s, still have %s in saveTree!", 
				LogName, newCan->Name, foundCan->Name);
		    failed=TRUE;
		}
		else
		{   syslog(L_TRACE,"%s found %s, delete=%d (%.2f)", LogName,
		    newCan->Name,newCan->Delete,(float)newCan->Delete/CANTIME);
		    tree_add(&canTree[WRITE],compareWriteCan,newCan,CANnop);
		}
		
		if(foundCan=tree_srch(&canTree[READ], compareReadCan, newCan) )
		{   syslog(L_ERROR, "%s found %s, still have %s in readTree!", 
					LogName, newCan->Name, foundCan->Name);
		    failed=TRUE;
		}
		else
		    tree_add(&canTree[READ], compareReadCan, newCan,CANnop);
	    }
	    
	    closedir(shelfDirp);
	}
    }
    closedir(dirp);
    
    if( failed )
    	exit(-1);
}


ARTCAN
*CANcreate(can, Delete)
    ARTCAN	*can;
    time_t	Delete;
{
    ARTCAN		*newCan;
    DIR			*dirp;
    DIRENTRY		*dp;
    struct STATFS 	statfsbuf;
    struct tm		*tmp;
    long		maxAvail;
    char		newCanPath[SPOOLNAMEBUFF];
    
    if( can )
    {	if( can->fd[WRITE] )
    	    CANcloseCan(WRITE, can);
	
	newCan=malloc(sizeof(ARTCAN));
	memcpy(newCan, can, sizeof(ARTCAN));
	can=newCan;
    }
    else
	can=(ARTCAN *)calloc(1, sizeof(ARTCAN));
    
    /* looking for shelf with most available space */
    
    maxAvail=0;

    dirp=opendir(".");
    for( dp=readdir(dirp); dp!=NULL; dp=readdir(dirp) )
    {   if( !strncmp(dp->d_name, "shelf.", 6) )
	{   STATFS(dp->d_name, &statfsbuf);
	
	    if( statfsbuf.f_bavail>maxAvail )
	    {   maxAvail=statfsbuf.f_bavail;
		strcpy(newCanPath, dp->d_name);
	    }
	}
    }
    closedir(dirp);

    if( maxAvail<1000 )
    {   ThrottleIOError("new can");

	return NULL;
    }
    
    (can->Number)++;
    tmp=localtime(&Delete);    
    can->Name=malloc(strlen(newCanPath)+1+strlen("yyyymmddhhxx")+1);
    sprintf(can->Name, "%s/%04d%02d%02d%02d%02d", newCanPath,
    	1900+tmp->tm_year, tmp->tm_mon+1, tmp->tm_mday, tmp->tm_hour, 
	can->Number);
    
    if( (can->fd[WRITE]=open(can->Name, O_CREAT|O_EXCL|O_WRONLY, 0666))<0 )
    {   syslog(L_ERROR, "cant open %s %m", can->Name);
	exit(-1);
    }

/*    if (AmRoot)
	xchown(can->Name);
*/
    if( write(can->fd[WRITE], 
    	"Hennerich's articleCan\nVersion 1.0\n+0000000047\n",23+12+12)!=
								23+12+12)
    {   syslog(L_ERROR, "%s cant write header of %s %m", can->Name);
	close(can->fd[WRITE]);
	exit(-1);
    }
    if( close(can->fd[WRITE])<0 )
    {   syslog(L_ERROR, "%s cant close %s %m", can->Name);
	exit(-1);
    }
    
    can->Version=1;
    can->Delete=Delete;
    can->Bytepos[READ]=0;
    can->Bytepos[WRITE]=23+12+12;
    can->fd[READ]=0;
    can->fd[WRITE]=0;
    can->AccessFlag[READ]=FALSE;
    can->AccessFlag[WRITE]=FALSE;
    can->dirty=FALSE;

    tree_add(&canTree[WRITE], compareWriteCan, can, CANnop);

    syslog(L_TRACE, "creating new can %s", can->Name);
    
    return can;
}

ARTCAN *
CANopenForWrite(DeleteOfCan,SizeOfArticle)
    time_t	DeleteOfCan;
    long	SizeOfArticle;
{
    ARTCAN		*can;
    ARTCAN		canWOD;			/* can With Only Delete */
    struct STATFS 	statfsbuf;

    canWOD.Delete=DeleteOfCan;
        
    if( (can=tree_srch(&canTree[WRITE], compareWriteCan, &canWOD))==NULL )
    {	if( (can=CANcreate(can, canWOD.Delete))==NULL )
	    return NULL;
    }
    else if( can->Name==NULL )			/* already expired */
    	return NULL;

    if( can->Bytepos[WRITE]+SizeOfArticle>MAXCANSIZE )
    	can=CANcreate(can, canWOD.Delete);
    
    if( can->fd[WRITE]==0 )
    {	STATFS(can->Name, &statfsbuf);
	    
	if( statfsbuf.f_bavail<10000 )
	{   if( (can=CANcreate(can, canWOD.Delete))==NULL )
		return NULL;
	}

    	CANdescriptorCycle(WRITE, can);
    }
    
    can->AccessFlag[WRITE]=TRUE;
    can->dirty=TRUE;

    return can;
}
