# rfc822.pl -- RFC822 support
# SCCS Status     : @(#)@ rfc822	2.2
# Author          : Johan Vromans
# Created On      : Oct 26 20:39:18 1989
# Last Modified By: Johan Vromans
# Last Modified On: Thu Apr 30 14:56:44 1992
# Update Count    : 29
# Status          : OK
#
# Copyright 1989, 1992 Johan Vromans
#
# This software may be redistributed on the same terms as the 
# GNU Public Licence.

# Exported routines
#
#   start_read -- initializes this module
#
#	must be passed the filename to read from
#
#   read_header -- reads, and parses RFC822 header
#
#	returns $VALID_HEADER if a valid RFC822 header was found.
#	$header and $contents contain the header and contents.
#	$line contains the normalized header.
#
#   read_body -- reads a line from the message body
#
#	returns $EMPTY_LINE if an empty line was read.
#
#	returns $DATA_LINE otherwise.
#	$line contains the contents of the line.
#
#   parse_addresses -- parses an address specification.
#
#	return addresses in @addresses, the address
#	comments in %addr_comments.
#

# Export the routines in the requiring package.
*start_read = *rfc822'start_read;
*read_header = *rfc822'read_header;
*read_body = *rfc822'read_body;
*parse_addresses = *rfc822'parse_addresses;

# Switch to package context.
package rfc822;

$[ = 0;				# let arrays start at 0 ];

################ Global constants ################
$EOF = 0;
$VALID_HEADER = 1;
$EMPTY_LINE = 2;
$DATA_LINE = 3;

################ Variables ################
$version = "@(#)@ rfc822	2.2 - rfc822.pl";
undef $line_in_cache;
$have_input_stream = 0;
$line = "";
$header = "";
$contents = "";
@addresses = ();
%addr_comments = ();
local (*INPUT);

################ Subroutines ################

sub start_read {
    local ($file) = @_;

    close (INPUT) if $have_input_stream;

    return 0 unless open (INPUT, $file);

    # Initialize the read ahead system.
    $line_in_cache = <INPUT>;

    # Will supply return value.
    $have_input_stream = 1;
}

sub read_body {

    if ( defined $line_in_cache ) {
	$line = $line_in_cache;
	undef $line_in_cache;
    } 
    else {
	return $EOF if eof(INPUT);
	$line = <INPUT>;
    }

    chop ($line);
    $header = $contents = undef;
    return ($line eq "") ? $EMPTY_LINE : $DATA_LINE;
}

sub read_header {

    if ( defined $line_in_cache ) {
	$line = $line_in_cache;
	undef $line_in_cache;
    } 
    else {
	return $EOF if eof(INPUT);
	$line = <INPUT>;
    }

    chop ($line);
    if ( $line =~ /^([-\w]+)\s*:\s*/ ) {
	$header = $1;
	$contents = $';			#';
    } 
    else {
	$header = $contents = undef;
	return ($line eq "") ? $EMPTY_LINE : $DATA_LINE;
    }

    # Handle continuation lines.
    while ( ! eof(INPUT) ) {
	chop ($line = <INPUT>);
	if ( $line =~ /^\s+/ ) {
	    # Append.
	    $contents .= " " . $';		#';
	}
	else {
	    # Too far.
	    $line_in_cache = $line . "\n";
	    last;
	}
    }

    $line = $header . ": " . $contents;
    return $VALID_HEADER;
}

sub parse_addresses {

    # Given an RFC822 compliant series of addresses, parse them, and
    # return:
    #    @addresses -- array with parsed addresses.
    #    %addr_comments -- the comments for each of the addresses.
    #
    # RFC822 syntax:
    #    address [, address ...]
    #    address: addr [ ( comment ) ] | [ comment ] <addr>

    local ($addr) = shift (@_);
    local ($left);
    local (@left);
    local ($right);
    local ($comment);

    @addresses = ();
    %addr_comments = ();

    # First break out the (...) comments.
    while ( $addr =~ /\(([^)]*)\)/ ) {
	$right = $';
	$comment = $1;
	@left = split (/[ \t]+/, $`);
	if ( $#left >= 0 ) {
	    # print "() match: \"", $left[$#left], "\" -> \"$1\"\n";
	    unshift (@addresses, pop (@left));
	    $addr_comments{$addresses[0]} = $1;
	}
	if ( $right =~ /^\s*,\s*/ ) {
	    $right = $';
	}
	$addr = join (" ", @left) . " " . $right;
	# print "todo: $addr\n";
    }

    # Then split on commas, and handle each part separately.
    @addr = split (/,/, $addr);

    while ( $#addr >= 0 ) {
	$addr = shift (@addr);
	# print "doing: \"$addr\"\n";
	$addr = $' if $addr =~ /^\s+/ ;
	$addr = $` if $addr =~ /\s+$/ ;
	next if $addr eq "";
	if ( $addr =~ /<([^>]+)>/ ) {
	    # print "\"$addr\" matched: \"$`\"-\"$+\"-\"$'\"\n";
	    unshift (@addresses, $1);
	    $addr_comments{$1} = join (" ", split (/[ \t]+/, "$` $'"));
	}
	else {
	    unshift (@addresses, $addr);
	    $addr_comments{$addr} = "";
	    # print "did: \"$addr\"\n";
	}
    }
}

1;
