# pr_parse.pl -- 
# SCCS Status     : @(#)@ pr_parse.pl	1.7
# Author          : Johan Vromans
# Created On      : Fri Dec 18 21:03:34 1992
# Last Modified By: Johan Vromans
# Last Modified On: Fri Jan  1 15:10:55 1993
# Update Count    : 97
# Status          : Unknown, Use with caution!

$cmd_tbl{'END'}      = 'cmd_end';
$cmd_tbl{'EXIT'}     = $cmd_tbl{'END'};
$cmd_tbl{'QUIT'}     = $cmd_tbl{'END'};
$cmd_tbl{'BEGIN'}    = $interactive ? 'cmd_ignore' : 'cmd_begin';
$cmd_tbl{'RESET'}    = $cmd_tbl{'BEGIN'};
$cmd_tbl{'REPLY'}    = $interactive ? 'cmd_ignore' : 'cmd_reply';
$cmd_tbl{'PATH'}     = $cmd_tbl{'REPLY'};
$cmd_tbl{'MAIL'}     = 'cmd_mail' if defined $email;
$cmd_tbl{'UUCP'}     = 'cmd_uucp' if defined $uucp;
$cmd_tbl{'LIMIT'}    = 'cmd_limit';
$cmd_tbl{'UUENCODE'} = 'cmd_uuencode';
$cmd_tbl{'UUDECODE'} = $cmd_tbl{'UUENCODE'};
$cmd_tbl{'UU'}       = $cmd_tbl{'UUENCODE'};
$cmd_tbl{'XXENCODE'} = 'cmd_xxencode';
$cmd_tbl{'XXDECODE'} = $cmd_tbl{'XXENCODE'};
$cmd_tbl{'XX'}       = $cmd_tbl{'XXENCODE'};
$cmd_tbl{'UUE'}      = 'cmd_uue';
$cmd_tbl{'UUD'}      = $cmd_tbl{'UUE'};
$cmd_tbl{'BTOA'}     = 'cmd_btoa';
$cmd_tbl{'ATOB'}     = $cmd_tbl{'BTOA'};
$cmd_tbl{'ENCODE'}   = 'cmd_encode';
$cmd_tbl{'ENCODING'} = $cmd_tbl{'ENCODE'};
$cmd_tbl{'COMPRESS'} = 'cmd_compress';
$cmd_tbl{'SEND'}     = 'cmd_send';
$cmd_tbl{'TOPIC'}    = $cmd_tbl{'SEND'};
$cmd_tbl{'GET'}      = $cmd_tbl{'SEND'};
$cmd_tbl{'RESEND'}   = 'cmd_resend';
$cmd_tbl{'PACK'}     = 'cmd_pack' if defined $packing_limit && $packing_limit;
$cmd_tbl{'SEARCH'}   = 'cmd_search';
$cmd_tbl{'INDEX'}    = 'cmd_index';
$cmd_tbl{'HELP'}     = 'cmd_help';
$cmd_tbl{'REQUEST'}  = 'cmd_request';
$cmd_tbl{'DIR'}      = 'cmd_dir';
$cmd_tbl{'LIST'}     = $cmd_tbl{'DIR'};
$cmd_tbl{'LS'}       = $cmd_tbl{'DIR'};
$cmd_tbl{'CWD'}      = 'cmd_cwd';
$cmd_tbl{'FTP'}      = 'cmd_ftp' if $ftp;
$cmd_tbl{'ARCHIE'}   = 'cmd_archie' if $archie;
$cmd_tbl{'TEST'}     = 'cmd_test';

# Add user commands...
do $cmd_extend if $cmd_extend && -r $cmd_extend;

sub command_loop {

    local ($res, $cmd, @cmd);
    local ($curdir) = "";	# track current directory
    local ($ftphost);		# empty -> no FTP, otherwise -> FTP
    local (*line, *DATA_LINE) = (*rfc822'line, *rfc822'DATA_LINE);
    local (*line_in_cache) = (*rfc822'line_in_cache);
    local ($tmp, $proc, $result);

    while ( $res = &read_body ) {

	next if $res != $DATA_LINE;

	# Allow continuation lines.
	$tmp = '';
	while ( $line =~ /\\$/ && $res == $DATA_LINE ) {
	    $tmp .= $line;	# Append w/o intervening space
	    chop ($tmp);	# Get rid of \
	    if (  ($res = &read_body) == $DATA_LINE ) {
		$line =~ s/^\s+//; # Strip leading spaces.
	    }
	}
	$line = $tmp . $line;

	last unless &split_and_exec_line;

	print STDOUT ("\n");
    }
    print STDOUT ("\n");
}

sub interactive_loop {
    # Yes, this is almost a copy of command_loop.

    local ($cmd, @cmd);
    local ($curdir) = "";	# track current directory
    local ($ftphost);		# empty -> no FTP, otherwise -> FTP
    local ($line, $line_in_cache);
    local ($tmp, $proc, $result);

    print STDOUT ("Enter HELP for a list of commands.\n\n");
    print STDOUT ("Command> ");

    while ( $line = $line_in_cache ? $line_in_cache : scalar(<STDIN>) ) {

	chop ($line);
	undef $line_in_cache;
	next unless $line =~ /\S/;

	# Allow continuation lines.
	$tmp = '';
	while ( $line =~ /\\$/ ) {
	    $tmp .= $line;	# Append w/o intervening space
	    chop ($tmp);	# Get rid of \
	    print STDOUT ("       > ");
	    if (  ($line = <STDIN> ) ) {
		$line =~ s/^\s+//; # Strip leading spaces.
	    }
	}
	$line = $tmp . $line;

	last unless &split_and_exec_line;

	print STDOUT ("\nCommand> ") unless $line_in_cache;
    }

    if ( $ftphost ) {
	push (@workq, &zp ('G', 'C'));
	require "$libdir/pr_dowork.pl";
	&work_loop;
    }

    print STDOUT ("\n");
    $errflag = 0;
}

sub split_and_exec_line {

    # Allow multiple commands on a line.
    if ( $line =~ /\s*;\s*/ ) {
	$line_in_cache = "$'\n";
	$line = $`;
    }

    $line =~ s/\s+/ /g;
    $commands++;
    print STDOUT "Command: $line\n";

    # Try to handle "REQUEST: foo" neatly
    $line =~ s/(\s+:|:\s+)/ /g;

    @cmd = split (/[\t ,=]+/, $line);
    @cmd = grep ( $_ ne "", @cmd);

    # Get command verb, shifting leading "set" verb.
    do {
	$cmd = shift (@cmd);
	last unless $cmd;
	$cmd  =~ tr/[a-z]/[A-Z]/;
    } while ( $cmd eq "SET" );

    # Execute command parsing procedure.
    # A command parsing procedure may return one of the following values:
    #  > 0 : command parsed (either OK or in error)
    #   0  : pretend that command does not exist
    #  < 0 : terminate processing

    if ( defined ( $proc = $cmd_tbl{$cmd} ) &&
	( $result = &$proc ) != 0 ) {

	# This is to implement the END command...
	return 0 if $result < 0;

	# And this is for interactive use.
	return 1 unless $interactive;

	if ( @indexq > 0 ) {
	    require "$libdir/pr_doindex.pl";
	    &index_loop;
	}
	if ( @searchq > 0 ) {
	    &search_loop;
	}
	if ( @workq > 0 ) {
	    require "$libdir/pr_dowork.pl";
	    &work_loop;
	}
    }
    else {
	# Unknown, or &$proc returned zero.
	&errmsg ("Command $cmd unknown");
    }
    1;
}

sub cmd_ignore {
    &warning ("$cmd command ignored");
}

################ exit | end ################

sub cmd_end {
    print STDOUT ("=> Okay");
    print STDOUT (" (rest of command ignored)") if @cmd;
    print STDOUT ("\n");

    # Terminate outer loop.
    return -1;
}

################ begin ################

sub cmd_begin {
    return &errmsg ("Usage: $cmd") if @cmd != 0;

    print STDOUT "=> Resetting\n";
    &reset;
    1;
}

################ reply <address> ################

sub cmd_reply {
    return &errmsg ("$cmd command must precede all other commands")
	if @workq + @searchq + @indexq;

    shift (@cmd) if $cmd[0] =~ /^to$/i;

    return &errmsg ("Usage: $cmd email-address") if @cmd != 1;

    &parse_addresses ($cmd[0]);
    return &errmsg ("Invalid return address: \"$cmd[0]\"")
	if @rfc822'addresses != 1;	#';

    $recipient = shift (@rfc822'addresses);	#');
    push (@workq, &zp ("M", $recipient));
    print STDOUT "=> Return address: \"$recipient\"\n";
    1;
}

################ mail <address> ################

sub cmd_mail {
    if ( @cmd == 0 && $interactive && $method ) {
	&method_msg;
	return 1;
    }

    return &errmsg ("$cmd command must precede other commands")
	if $method && !$interactive;

    shift (@cmd) if $cmd[0] =~ /^to$/i;

    return &errmsg ("Usage: $cmd email-address") if @cmd != 1;

    &parse_addresses ($cmd[0]);
    return &errmsg ("Invalid return address: \"$sender\"")
	if @rfc822'addresses != 1;	#';

    &email_defaults ($rfc822'addresses[0]);	#');
    1;
}

################ uucp <path> ################

sub cmd_uucp {
    if ( @cmd == 0 && $interactive && $method ) {
	&method_msg;
	return 1;
    }

    return &errmsg ("$cmd command must precede other commands")
	if $method && !$interactive;

    local ($msg) = "Usage: $cmd host!path user";

    shift (@cmd) if $cmd[0] =~ /^to$/i;

    if ( @cmd < 2 && $h_uufrom && $h_uuhost ) {
	if ( @cmd == 0 ) {
	    @cmd = ('!', '');
	}
	elsif ( @cmd == 1 ) {
	    if ($cmd[0] =~ /^\w[-\w]*$/ ) {
		unshift (@cmd, '!');
	    }
	    else {
		push (@cmd, '');
	    }
	}
    }

    return &errmsg ($msg) unless @cmd == 2;

    local ($uupath, $uunote) = @cmd;

    if ( $uupath !~ /!/ && $h_uuhost ) {
	$uupath = $h_uuhost . '!' . $uupath;
    }

    if ( $uupath =~ /!/ ) {
	&uucp_defaults ($`, $', $uunote);
    }
    else {
	return &errmsg ($msg);
    }
    1;
}

################ limit [ <number>[K] ] ################

sub cmd_limit {
    if ( @cmd == 0 ) {
	push (@workq, &zp ("L", $limits[1]));
	print STDOUT "=> Limit = $limits[1]K (default)\n";
    }
    elsif ( $cmd[0] =~ /^(\d+)K?$/i ) {
	local ($new) = $1;
	local ($msg) = "LIMIT must be between ".
	    "$limits[0]K and $limits[2]K";

	if ( $new < $limits[0] ) {
	    $new = $limits[0];
	    &warning ($msg);
	}
	elsif ( $new > $limits[2] ) {
	    $new = $limits[2];
	    &warning ($msg);
	}
	push (@workq, &zp ("L", $new));
	print STDOUT "=> Limit = ${new}K\n";
    }
    else {
	return &errmsg ("Usage: $cmd [ number[K] ]");
    }
    1;
}

################ various encoders ################

sub cmd_encode {
    if (  @cmd == 1 ) {
	local ($tag) = shift (@cmd);
	return &cmd_uuencode
	    if $tag =~ /^uu(en|de)cod(e|ing)$/i;
	return &cmd_xxencode
	    if $tag =~ /^xx(en|de)cod(e|ing)$/i;
	return &cmd_uue
	    if $tag =~ /^uu(e|d)$/i;
	return &cmd_btoa
	    if $tag =~ /^(btoa|atob)$/i;
    }
    return &errmsg ("Usage: $cmd [ uuencode | xxencode | uue | btoa ]")
}
sub cmd_uuencode {
    &setencoding ("uuencoding", $uuencode, "U");
}
sub cmd_xxencode {
    &setencoding ("xxencoding", $xxencode, "X");
}
sub cmd_uue {
    &setencoding ("uue", $uue, "D");
}
sub cmd_btoa {
    &setencoding ("btoa", $btoa, "B");
}

sub setencoding {
    local ($tag, $encoder, $encoding) = @_;
    if ( @cmd == 0 ) {
	if ( -x $encoder ) {
	    push (@workq, &zp ("E", $encoding));
	    print STDOUT "=> Encoding = $encoding ($tag)\n";
	}
	else {
	    print STDOUT "=> Encoding '$tag' not available\n";
	}
    }
    else {
	$tag =~ tr/a-z/A-Z/;
	&errmsg ("$tag does not take any arguments");
    }
}

sub cmd_compress {
    &cmd_ignore;
    print STDOUT <<EOD if $auto_compress;
=> If you request 'file.Z' I'll compress it automatically if I find
   an uncompressed version of it.
EOD
    1;
}

################ send <item> [ <item>...] ################

sub cmd_send {
    return &errmsg ("Usage: $cmd item [ item ... ]") unless @cmd > 0;

    local ($ftphost) = $ftphost;
    foreach $item ( @cmd ) {
	if ( $item =~ m:(^\.|/\.|[*?%]): ) {
	    return &errmsg ("Illegal request");
	}
	if ( $item =~ /:/ || $ftphost ) {
	    return 1 unless &check_ftp;
	    push (@workq, &zp ('G', 'G', $curdir.$item)); 
	    print STDOUT "=> Send: $curdir$item\n";
	}
	else {
	    return 1 unless &setdefaults;
	    push (@workq, &zp ("S", $curdir.$item)); 
	    print STDOUT "=> Send: $curdir$item\n";
	}
    }
    1;
}

################ resend <item> <number> [ <number>...] ################

sub cmd_resend {
    local ($msg) = "Usage: $cmd item part# [ part# ... ]";

    return &errmsg ($msg) unless @cmd > 1;

    local ($item) = shift (@cmd);
    local ($plist) = "";
    local ($ftphost) = $ftphost;

    if ( $item =~ m:(^\.|/\.|[*?%]): ) {
	return &errmsg ("Illegal request");
    }
    foreach $num (@cmd) {
	if ( $num =~ /^\d+$/ ) {
	    $plist .= 0+$num . ",";
	}
	else {
	    return &errmsg ($msg);
	}
    }
    if ( $item =~ /:/ || $ftphost ) {
	return 1 unless &check_ftp;
	chop ($plist);
	push (@workq, &zp ('G', 'G', $curdir.$item, $plist));
	print STDOUT ("=> Resend: $curdir$item, part",
		      (@plist > 0) ? "s " : " ",
		      $plist, "\n");
    }
    else {
	return 1 unless &setdefaults;
	chop ($plist);
	push (@workq, &zp ("S", $curdir.$item, $plist));
	print STDOUT ("=> Resend: $curdir$item, part",
		      (@plist > 0) ? "s " : " ",
		      $plist, "\n");
    }
    1;
}

################ pack ################

sub cmd_pack {
    if ( @cmd != 1 ) {
	return 	&errmsg ("Usage: $cmd { ".
		 (-x $tar ? "tar | " : "").
		 (-x $zip ? "zip | " : "").
		 (-x $zoo ? "zoo | " : "").
		 "off }");
    }

    local ($packing);

    ($packing = $cmd[0]) =~ tr/[A-Z]/[a-z]/;
    if ( ($packing eq "tar" && (-x $tar || -x $pdtar)) ||
	 ($packing eq "zip" && -x $zip) ||
	 ($packing eq "zoo" && -x $zoo) ) {
	push (@workq, &zp ("P", $packing));
	print STDOUT ("=> Subsequent requests must be directories",
		      " that will be ",
		      "packed using '$packing'.\n",
		      "   Note that a limit of ",
		      int ($packing_limit/2), 
		      " Kbytes applies to each request.\n",
		      "   Requests exceeding this limit ",
		      "will be discarded.\n");
    } 
    elsif ( $packing eq "off" ) {
	push (@workq, &zp ("P"));
	print STDOUT "=> No more packing\n";
    }
    else {
	return &errmsg ("Wrong argument for PACK");
    }
    1;
}

################ search <item> [ <item>...] ################

sub cmd_search {
    return &errmsg ("Usage: $cmd item [ item ... ]") unless @cmd > 0;

    foreach $item ( @cmd ) {
	if ( $item =~ m:(^\.|/\.|[*?%]): ) {
	    return &errmsg ("Illegal request");
	}
	push (@searchq, $curdir.$item);
	print STDOUT "=> Search: $curdir$item\n";
    }
    1;
}

################ index ################

sub cmd_index {
    return 0 unless @cmd == 0 || defined $indexfile;

    if ( @cmd == 0 ) {
	return 1 unless &setdefaults;
	push (@workq, &zp ("S", $curdir."INDEX")); 
	print STDOUT "=> Send: ${curdir}INDEX\n";
    }
    elsif ( @cmd > 0 ) {
	foreach $item ( @cmd ) {
	    if ( $item =~ m:(^\.|/\.|[*?%]): ) {
		return &errmsg ("Illegal request");
	    }
	    push (@indexq, $curdir.$item);
	    print STDOUT "=> Index: $curdir$item\n";
	}
    }
    else {
	return &errmsg ("Usage: $cmd item [ item ... ]");
    }
    1;
}

################ help ################

sub cmd_help {
    return &errmsg ("HELP does not take any arguments ".
		    "(but you'll get help anyway)")
	if @cmd != 0;

    if ( $interactive ) {
	&help;
    }
    else {
	print STDOUT ("=> Okay, I'll append some help ".
		      "at the end of this message\n");
	$needhelp = 1;
    }
    1;
}

################ CWD ################

sub cmd_request {
    if ( $cmd[0] =~ /^end$/i ) {
	shift @cmd;
	return &cmd_end;
    }
    &cmd_cwd;
}

sub cmd_cwd {
    if ( @cmd == 0 ) {
	print STDOUT ("=> No current directory\n");
	$curdir = "";
	return 1;
    }
    elsif ( @cmd == 1 ) {
	if ( $cmd[0] =~ m:(^\.|/\.|[*?%]): ) {
	    return &errmsg ("Illegal directory");
	}

	$curdir = $cmd[0];
	print STDOUT ("=> Current directory = $curdir\n");
	$curdir .= "/" 
	    unless $curdir =~ m|/$| || $curdir =~ /^\[.*\]$/;
    }
    else {
	return &errmsg ("Usage: $cmd [ path ]");
    }
    1;
}

################ DIR ################

sub cmd_dir {
    return &errmsg ("Usage: $cmd [filename]") if @cmd > 1;

    local ($item) = $curdir . shift (@cmd);
    if ( $item eq '' && $ftphost eq '' ) {
	return &errmsg ("No current directory");
    }

    if ( $item =~ m:(^\.|/\.|[\047]): ) {
	return &errmsg ("Illegal directory");
    }

    local ($ftphost) = $ftphost;
    if ( $item =~ /:/ || $ftphost ) {
	&check_ftp || return 1;
	push (@workq, &zp ('G', 'O', $ftphost));
	push (@workq, &zp ('G', 'D', $item));
    }
    else {
	return 1 unless &setdefaults;
	$item = $` if $item =~ m|/+$|;
	push (@workq, &zp ('D', $item));
    }

    print STDOUT ("=> Dir: $item\n");
    1;
}

################ FTP ################

sub cmd_ftp {
    local ($subcmd);
    ($subcmd = shift (@cmd)) =~ tr/A-Z/a-z/;

    if ( $subcmd =~ /^[-\w]+\.[-\w.]*$/ ) {
	unshift (@cmd, $subcmd);
	$subcmd = "open";
    }

    if ( $subcmd eq "open" ) {
	if ( @cmd != 1 ) {
	    return &errmsg ("Usage: $cmd $subcmd hostname");
	}
	&ftp_defaults (shift (@cmd)) || return 1;
    }
    elsif ( $subcmd eq "close" ) {
	if ( @cmd > 0 ) {
	    return &errmsg ("Usage: $cmd $subcmd");
	}
	$ftphost = '';
	push (@workq, &zp ('G', 'C'));
	print STDOUT ("=> Okay\n");
    }
    elsif ( $subcmd eq "user" ) {
	if ( @cmd == 0 || $cmd > 2 ) {
	    return &errmsg ("Usage: $cmd $subcmd login [password]");
	}
	push (@cmd, $recipient) if @cmd == 1;
	push (@workq, &zp ('G', 'U', @cmd));
	print STDOUT ("=> FTP Login: @cmd\n");
    }
    else {
	return &errmsg ("Invalid $cmd subcommand: \"$subcmd\"");
    }
    1;
}

################ ARCHIE ################


#	    local ($flags) = '';
#	    local ($subcmd);
#	    local ($usage) = "Usage: archie [-cersl] [-mNN] arg";
#	    local ($arg) = pop (@cmd);
#
#	    while ( @cmd ) {
#		$subcmd = shift (@cmd);
#		if ( $subcmd !~ /^-/ ) {
#		    &errmsg ($usage.1);
#		    next COMMAND_LOOP;
#		}
#		$subcmd = $';
#		while ( $subcmd ) {
#		    if ( $subcmd =~ /^[cersl]/i ) {
#			$flags .= " -\l$+";
#			$subcmd = $';
#		    }
#		    elsif ( $subcmd =~ /^m\d+/i ) {
#			$subcmd = $';
#			$flags .= " -\l$+";
#		    }
#		    else {
#			&errmsg ($usage.2);
#			next COMMAND_LOOP;
#		    }
#		}
#	    }
#
#	    if ( $arg =~ /'";\\\s/ ) {
#		&errmsg ("Invalid argument to Archie");
#		next COMMAND_LOOP;
#	    }
#	    $flags =~ s/^\s+//;
#	    return 1 unless &setdefaults;
#	    push (@workq, &zp ('A', $arg, $flags));
#	    print STDOUT ("=> Archie: $flags $arg\n");
#	}

sub cmd_archie {
    local ($subtype);
    local ($subcmd) = shift (@cmd);
    local ($arg) = shift (@cmd);
    local ($usage) = "Usage: ARCHIE PROG regexp";

    if ( $subcmd =~ /^prog$/i ) {
	$subtype = 'P';
    }
    else {
	return &errmsg ($usage);
    }

#    if ( $arg =~ /'";\\\s/ ) {
#	return &errmsg ("Invalid argument to Archie");
#    }

    return 1 unless &setdefaults;
    push (@workq, &zp ('A', $subtype, $arg));
    print STDOUT ("=> Archie: \L$subcmd\E $arg\n");
    1;
}

################ test ################

sub cmd_test {
    return 0 unless @cmd == 0;

    $opt_noqueue = 1;
    $didhelp = 1;
    print STDOUT "=> Okay\n";
    1;
}

################ subroutines ################

sub check_ftp {

    # Check for implicit FTP in $item.
    # Sets up FTP if allowed.
    # Modifies $item if needed.

    unless ( $ftp ) {
	&errmsg ("Illegal request");
	return 0;
    }

    if ( $ftphost ) {
	if ( $item =~ /:/ ) {
	    if ( $` ne $ftphost) {
		&errmsg ("Use FTP CLOSE before " .
			 "connecting to another host");
		return 0;
	    }
	    $item = $';
	}
	return 1;
    }

    $item = $';
    return &ftp_defaults ($`);
}

################ 1 ################
1;
