# pr_ftp.pl -- mail server support for FTP
# SCCS Status     : @(#)@ pr_ftp.pl	1.6
# Author          : Johan Vromans
# Created On      : Sat Dec  5 01:06:44 1992
# Last Modified By: Johan Vromans
# Last Modified On: Thu Dec 31 16:23:04 1992
# Update Count    : 35
# Status          : Unknown, Use with caution!

# This is the Squirrel Mail Server interface to the ftp.pl package.

require "$libdir/ftp.pl";

&ftp'debug (1);		#';

sub ftp_connect {
    local ($host, $user, $pass) = @_;

    print STDOUT ("FTP Command execution:\n",
		  "    OPEN $host\n");

    &ftp'close if $ftphost;			#';
    &ftp'open ($host, 21, 0, 2);		#';
    &ftp'login ($user, $pass);			#';
    $ftphost = $host;
}

sub ftp_get {
    local ($file) = @_;

    # See if a given file exists on the FTP site, and if a valid
    # copy exists in the local ftp cache.
    # Returns 
    #   the name of the file in the cache, if it is valid
    #   tmpname	if no valid file in cache, or the cache could not
    #		be updated.

    local ($faf);		# file name in cache
    local ($time) = 0;		# timestamp

    print STDOUT ("FTP Command execution:\n",
		  "    GET $file\n");

    unless ( -d $ftp_cache && -w _ ) {
	# No cache....
	$faf = &fttemp;
    }
    else {

	local ($rf, $rf_size, $rf_mtime) = &get_file_and_date ($file);

	# Got it?
	if ( $rf eq '' ) {
	    # No info, cannot use cache.
	    $faf = &fttemp;
	}
	else {
	    local ($af, $af_mtime, $tdiff);

	    # Look it up in the local ftp cache.
	    $af = &ftp_archname ($ftphost, $rf);
	    $faf = $ftp_cache . '/' . $af;

	    # Check size and timestamp.
	    if ( $rf_size == ( -s $faf ) ) {
		$af_mtime = (stat(_))[9];
		$tdiff = $af_mtime - $rf_mtime;
		# Allow one hour difference (daylight savings).
		if ( $tdiff == 0 || $tdiff == 3600 || $tdiff == -3600 ) {
		    # We have a valid file in the cache, return it.
		    print STDOUT "    [File found in local FTP cache]\n";
		    return $faf;
		}
	    }

	    # Note the timestamp.
	    $time = $rf_mtime;

	    # Prepare to copy the file into the cache.
	    local ($tmp, @tmp);
	    $tmp = $ftp_cache;
	    @tmp = split (/\/+/, $af);
	    pop (@tmp);
	    foreach $dir ( @tmp ) {
		$tmp .= '/' . $dir;
		next if -d $tmp;
		print STDOUT ("=> creating dir $tmp\n") if $opt_debug;
		mkdir ($tmp, 0755) || print STDOUT ("    [mkdir $tmp: $!]\n");
	    }

	    if ( -d $tmp && -w $tmp ) {
		unlink ($faf);
	    }
	    else {
		local ($msg) = "No ftp cache for $af";
		print STDOUT ("    [$msg]\n\n");
		&writelog ("F $msg");
		$faf = &fttemp;
	    }
	}
    }

    # Fetch...
    &ftp_type ('I');
    if ( &ftp'get ($file, $faf, 0) ) {	#'){
	# Set times to match the server.
	utime (time, $time, $faf) if $time;
    }

    # Return the full name of the file.
    $faf;
}

sub ftp_dir {
    local ($dir, $thefile) = @_;

    local ($ret, *F);
    open (F, '>' . $thefile);
    print STDOUT ("FTP Command execution:\n",
		  "    DIR $dir\n");
    &ftp_type ('A');
    &ftp'dir_open ($dir);			#';
    while ( $ret = &ftp'read ) {		#'){
	$ftp'buf =~ s/\r\n/\n/g;		#';
	print F $ftp'buf;			#';
    }
    &ftp'dir_close;				#';
    close (F);
}

sub ftp_type {
    local ($type) = @_;
    $current_ftp_type = '' unless defined $current_ftp_type;
    unless ( $current_ftp_type eq $type ) {
	&ftp'type ($type);		#';
	$current_ftp_type = $type;
    }
}

sub get_file_and_date {
    local ($file) = @_;		# returns (remote file name, size, date)

    print STDOUT ("=> get_file_and_date ($file)\n") if $opt_debug;

    local (@res, $result);

    # Retrieve ls info from FTP server.
    &ftp_type ('A');
    &ftp'dir_open ($file);		#';
    if ( $ret = &ftp'read ) {		#'){
	($result = $ftp'buf) =~ s/\r\n/\n/g;		#');
    }
    &ftp'dir_close;		#';
    $result = $' if $result =~ /^total.*\n/i;
    $result = $1 if $result =~ /^(.+)\n/i;
    print STDOUT ("    ", $result, "\n");
    # &ftp'type ('I');		#';
    print STDOUT ("\n");

    # Only the last few fields are relevant.
    @res = split (' ', $result);

    # Check for symlink.
    if ( $res[$#res-1] eq '->' ) {
	return ('', 0, 0)
	    unless $file = &resolve_symlink ($res[$#res-2], $res[$#res]);
	return (&get_file_and_date ($file));
    }

    local ($size, $mon, $day, $year, $fn) = splice(@res,$#res-4, 5);
    print STDOUT ("=> file = $file, size  = $size, Y/M/D = $year/$mon/$day\n")
	if $opt_debug;

    # Got it?
    return ('', 0, 0) if $fn ne $file;

    # Convert and return date.
    require 'dateconv.pl';
    return ($file, $size, &lstime_to_time ("$mon $day $year"));
}

sub resolve_symlink {
    local ($file, $link) = @_;

    # This routine does a reasonable job on resolving symlinks.
    # Since the symlinks we'll be resolving point to files on a
    # remote system, we can hardly do better than this.

    return $file unless $link;		# not a symlink

    print STDOUT ("=> resolve_symlink ($file, $link)\n") if $opt_debug;

    return $link if $link =~ m|^/|;	# absolute path
    return undef if $link =~ m|^~|;	# cannot resolve

    local (@file) = split (m|/+|, $file);
    local (@link) = split (m|/+|, $link);
    local ($result, $t) = ('','');
    local ($skip) = 0;			# updir (..) skip count

    pop (@file) if @file > 0;		# remove final component
    push (@file, @link);		# add symlink value

    # Normalize filename.
    while ( @file ) {
	$t = pop (@file);
	next if $t eq '.';		# ignore
	$skip++, next if $t eq '..';	# skip this and predecessor
	$skip--, next if $skip;		# skip this
	$result = $t . '/' . $result;	# prepend to result
    }
    chop ($result);		# chop trailing slash

    print STDOUT ("=> resolved: $result\n") if $opt_debug;
    $result;
}

1;
