# pr_dsearch.pl -- directory search
# SCCS Status     : @(#)@ pr_dsearch.pl	3.1
# Author          : Johan Vromans
# Created On      : Thu Jun  4 22:13:23 1992
# Last Modified By: Johan Vromans
# Last Modified On: Thu Jun  4 23:05:39 1992
# Update Count    : 4
# Status          : OK

sub dirsearch {

    local ($libdir, $request) = @_;

    # Locate an archive item $request in library $libdir by
    # performing a directory lookup.
    # Eligible items are in the format XXX.EXT, or XXX-VVV.EXT, where
    # VVV is assumed to be a version indicator (and must start with a digit).
    # If an eligible item appears to be a directory, the search continues
    # recursively.
    #
    # See "sub search" for a description of the return values.

    local ($size);
    local (@retval);		# return value
    local (@a);			# to hold stat() result

    # Normalize the request. 
    # $tryfile will be the basename of the request.
    # $subdir holds the part between $libdir and $tryfile.
    local ($subdir, $tryfile) = &fnsplit ($request);

    print STDOUT ("Search $libdir$subdir for $tryfile...\n") if $opt_debug;

    $subdir .= "/" if $subdir && $subdir !~ m|/$|;
    $libdir .= "/" if $libdir && $libdir !~ m|/$|;

    # Gather files info for the lib dir.
    local (@files, @found, $pat);

    # Get all filenames.
    opendir (DIR, $libdir.$subdir);
    @files = readdir (DIR);
    closedir (DIR);
    local ($tmp) = 0+@files if $opt_debug;
    return @retval unless @files > 0;	# No need to proceed.

    # Form pattern to match search arg.
    ($pat = $tryfile) =~ s/(\W)/\\\1/g;

    # Extract valid items.
    @found = grep(/^$pat/, @files);
    print STDOUT ("Found ", 0+@found, " candidates out of ", $tmp, " files.\n")
	if $opt_debug;
    @files = ();		# Deallocate.

    return @retval unless @found > 0;	# No need to proceed.

    foreach $file ( @found ) {

	local ($base, $version, $extension);

	(($base, $version, $extension) =
	 $file =~ /^($pat)(-\d.*|)$extpat$/)
	    || (($base, $version, $extension) =
		$file =~ /^($pat)(-\d.*|)$/);

	# Nope.
	next unless defined $base;

	$extension = "" unless defined $extension;

	# Recurse if directory.
	if ( -d $libdir.$subdir.$file && -r _ ) {
	    print STDOUT ("File $libdir$subdir$file (directory)\n")
		if $opt_debug;
	    push (@retval, 
		  &dirsearch ($libdir, "$subdir$file/$tryfile"));
	    next;
	}

	# Try file.
	next unless -f _ && -r _ ;

	# We have a file.
	@a = stat(_);
	print STDOUT ("File $libdir$subdir$file (known)\n")
	    if $opt_debug;
	push (@retval, 
	      &zp ($base.$version.$extension, $a[7], $a[9], $libdir, $subdir));
    }

    return @retval;
}

1;
