#!/usr/local/bin/perl
# do_report.pl -- run mail server report
# SCCS Status     : @(#)@ do_report	1.13
# Author          : Johan Vromans
# Created On      : Sat May  2 14:15:16 1992
# Last Modified By: Johan Vromans
# Last Modified On: Fri Dec 25 16:23:12 1992
# Update Count    : 82
# Status          : OK

$my_name = "do_report";
$my_version = "1.13";
#
################ Common stuff ################

$libdir = $ENV{"MSERVLIB"} || "/usr/local/lib/mserv";
unshift (@INC, $libdir);

################ Presets ################

@args = ();

################ Options handling ################

&options if @ARGV > 0 && $ARGV[0] =~ /^-+[^-]+/;
require "ms_common.pl";
print ($my_package, " [", $my_name, " ", $my_version, "]\n")
    if $opt_ident;
if ( @ARGV > 0 ) {
    @dest = @ARGV;
}
else {
    @dest = ( $mserv_owner );
}

################ Main ################

$tmpfile_prefix = $tmpdir . "/rpt$$.";
$rpt = $tmpfile_prefix . "rpt";
$err = $tmpfile_prefix . "err";
$tmp = $tmpfile_prefix . "tmp";
$oldlog = $logfile . ".o";

if ( $opt_collect ) {
    # Seize logfile.
    &die ("Found $oldlog, will not proceed") if -s $oldlog;
    &unlink ($oldlog);

    if ( &rename ($logfile, $oldlog) ) {
	open (LOG, ">".$logfile) && close (LOG);
    }
    else {
	&die ("Cannot rename $logfile to $oldlog [$!]");
    }

    # Run report.
    &system ("$libdir/report @args $oldlog >$rpt 2>$err")
	if $opt_usage || $opt_errors;
}
else {
    &system ("$libdir/report @args >$rpt 2>$err")
	if $opt_usage || $opt_errors;
}

open (RPT, ">>$rpt");
print RPT ($^L) if -s RPT;	# Insert form-feed if needed.

if ( $opt_collect ) {

    # Append to accumulating data and compress (again).
    if ( -f $logfile . ".cum.Z") {
	&system ("uncompress $logfile.cum");
	&system ("cat $oldlog >> $logfile.cum");
	&unlink ($oldlog);
	&system ("compress $logfile.cum");
    }
    else {
	&system ("cat $oldlog >> $logfile.cum");
	&unlink ($oldlog);
	# &system ("compress $logfile.cum");
    }
}

if ( ($opt_ftp || $opt_ftpclean) && $ftp && $ftp_cache ) {

    require 'find.pl';

    $ftp_keep = $opt_ftpkeep if defined $opt_ftpkeep;
    $files = 0;
    $preflen = length ($ftp_cache) + 1;
    *wanted = *ftw_ftp;
    select (RPT);
    $^ = 'FTP_TOP';
    $~ = 'FTP_OUT';
    $: = " /";
    &find ($ftp_cache);
}

close (RPT);

&cleanup;

################ Subroutines ################

sub cleanup {
    &mail ($err, "ERRORS from Mail Server") if -s $err;
    &mail ($rpt, "Mail Server Report") if -s $rpt;
    &unlink ($rpt, $err, $tmp);
}

sub unlink {
    local (@files) = @_;
    print STDERR ("+ unlink @files\n") if $opt_trace;
    unlink (@files);
}

sub rename {
    local ($old, $new) = @_;
    print STDERR ("+ rename $old $new\n") if $opt_trace;
    rename ($old, $new);
}

sub system {
    local ($cmd) = (@_);
    local ($ret);
    print STDERR ("+ $cmd\n") if $opt_trace;
    $ret = system ($cmd);
    &die (sprintf ("Return 0x%x from \"$cmd\"", $ret))
	unless $ret == 0;
    $ret;
}

format FTP_TOP =
Files in FTP cache @<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
$ftp_cache

  Timestamp     Age*  Size  Filename   (* means: file has been removed)
--------------  ----  ----  -------------------------------------------
.
format FTP_OUT =
@<<<<<<<<<<<<< @>>@@>>>>>K  ^<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
$timestamp, $age, $tag, $size, $fname
~~                            ^<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
$fname
.

sub ftw_ftp {
    @st = stat ($_);
    if ( @st[2] & 0100000 ) {
	$size = int (($st[7] + 1023) / 1024);
	$age = int (-A _ );
	@tm = localtime ($st[9]);
	$tag = '';
	if ( $opt_ftpclean && $ftp_keep > 0 && ( $age > $ftp_keep ) ) {
	    if (unlink($_)) {
		$tag = '*';
	    }
	    else {
		$_ .= " (not removed: $!)";
	    }
	}
	$timestamp = sprintf ("%02d/%02d/%02d %02d:%02d", 
			      $tm[5], 1+$tm[4], $tm[3], $tm[2], $tm[1]);
	$fname = substr($dir,$preflen) . '/' . $_;
	write;
    }
}

sub warn {
    local ($msg) = (@_);
    warn ($my_name . ": " . $msg . "\n");
}

sub die {
    &warn;
    &cleanup;
    exit (1);
}

sub mail {
    local ($file, $subj) = @_;
    local ($cmd) = "$sendmail '" . join("' '", @dest) . "'";

    # DO NOT USE '&die' in this routine.

    print STDERR ("+ |", $cmd, "\n") if $opt_trace;

    open (MAIL, "|" . $cmd)
	|| die ("$my_name: Cannot invoke $cmd [$!]\n");
    print MAIL ("To: ", join(", ", @dest), "\n",
		"Subject: $subj\n",
		"\n");
    if ( open (FILE, $file) ) {
	while ( <FILE> ) {
	    print MAIL $_;
	}
	close (FILE);
    }
    close (MAIL);
    die ("$my_name: Mail error $?\n") if $?;
}

sub options {
    require "newgetopt.pl";
    $opt_ident = $opt_help = 0;
    $opt_errors = $opt_usage = $opt_full = 0;
    $opt_collect = $opt_trace = $opt_noupdate = 0;
    if ( !&NGetOpt ("ident", "errors", "usage", "full", "collect",
		    "config=s", "since=s", "noupdate",
		    "ftp", "ftpclean", "ftpkeep=i",
		    "trace", "help")
	|| $opt_help ) {
	&usage;
    }
    $opt_errors |= $opt_full;
    $opt_usage |= $opt_full;
    $opt_ftp |= $opt_full;
    $opt_usage = 1 unless $opt_errors || $opt_ftp || $opt_ftpclean;
    unshift (@args, "-full") if $opt_usage && $opt_errors;
    unshift (@args, "-errors") if $opt_errors && !$opt_usage;
    unshift (@args, "-since", $opt_since) if defined $opt_since;
    unshift (@args, "-noupdate") if $opt_noupdate;
    unshift (@args, "-usage") if $opt_usage && !$opt_errors;
    undef $opt_errors, $opt_full, $opt_usage;
    $config_file = $opt_config if defined $opt_config;
}

sub usage {
    require "ms_common.pl";
    print STDERR <<EndOfUsage;
$my_package [$my_name $my_version]

Usage: $my_name [options] [ recipients... ]

Options:
    -config XX	use alternate config file
    -usage	generate usage report
    -ftp	show files in FTP cache
    -full	generate report for usage, errors and ftp
    -ftpclean	cleanup old files in FTP cache (implies -ftp)
    -ftpkeep NN number of days a file is to be kept in the FTP cache (default: $ftp_keep)
    -since FILE	only error messages newer than FILE
		(FILE date will be updated upon successful completion)
    -noupdate	do not update FILE date
    -collect	collect and cleanup logfile data
    -help	this message
    -trace	show commands
    -ident	print identification

Default action is to generate a usage report, and to mail it to the
recipients (default: $mserv_owner).
EndOfUsage
    exit (1);
}
