/*
 *  Replacement  getpass()  which reads in LONGER passwords.
 *  (up to 130 chars...)
 *  A complete independent writeup according to  getpass.3 (well,
 *  allowing `a bit' larger passwords...)
 *	/Matti Aarnio <mea@utu.fi>  23-Oct-1990
 */

#include <stdio.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/ioctl.h>
#include <sys/termio.h>

static char passwd[133] = "";
static int killmyself = 0;

static
void
sigcatch()
{
	++killmyself;
}

char *
getpass(prompt)
     char *prompt;
{
	register FILE	*tty = NULL;
	register char	*s;
	register int	c;
	register int	out = 0;
	register int	cnt = 0;
	unsigned short	c_lflag;
	void	(*sigint)();
	struct termio	termios;

	if (!(tty = fopen("/dev/tty","r"))) {
	  tty = fdopen(dup(fileno(stdin)),"r");
	  /* Right, old file dupped etc.. */
	  if (!tty) return NULL;	/* I give up ! */
	}

	setbuf(tty,NULL);		/* Non-buffered ! */

	sigint = signal(SIGINT,sigcatch);
	killmyself = 0;
	
	ioctl(fileno(tty),TCGETA,&termios);
	c_lflag = termios.c_lflag;
	termios.c_lflag &= ~(ECHO|ECHOE|ECHOK);
	ioctl(fileno(tty),TCSETAF,&termios);

	fputs(prompt,stdout);
	fflush(stdout);

	s = passwd;
	while (!killmyself && !out) {
	  c = fgetc(tty);
	  switch (c) {
	    case 8:		/* BS */
	    case 127:		/* DEL */
		if (cnt) {	/* Pull back ! */
		  --cnt; --s;
		}
		break;
	    case 0:		/* Reasons to quit:  NULL */
	    case -1:		/* EOF or ERROR */
	    case '\r':		/* CR */
	    case '\n':		/* NL */
		out = 1;
		break;
	    default:		/* Any other characters */
		if (cnt < sizeof(passwd)) {
		  *s++ = c;
		  ++cnt;
		}
	  }
	}
	*s = 0;

	termios.c_lflag = c_lflag;
	ioctl(fileno(tty),TCSETAW,&termios);

	fclose(tty);

	fputc('\n',stdout);
	fflush(stdout);

	signal(SIGINT,sigint);

	if (killmyself)
	  kill( SIGINT,getpid() );

	return passwd;
}
