/* finder() -- a module into the  ftp  client program

   Runs  FIND  primitive in the remote system.

   Uses  "get"-command  syntax for sending the regexpr into
   the remote end, while still being able to direct data
   elsewere.

   [mea@nic.funet.fi]  Dec-1991

*/

#include <stdio.h>

extern int code;

finder(argc, argv)
	char *argv[];
{
	char *cmd;

	if (argc < 2)
		argc++, argv[1] = NULL;
	if (argc < 3)
		argc++, argv[2] = "-";
	if (argc > 3) {
		printf("usage: %s remote-directory local-file\n", argv[0]);
		code = -1;
		return;
	}
	cmd = "SITE FIND";
	if (strcmp(argv[2], "-") && !globulize(&argv[2])) {
		code = -1;
		return;
	}
	if (strcmp(argv[2], "-") && *argv[2] != '|')
		if (!globulize(&argv[2]) || !confirm("output to local-file:", argv[2])) {
			code = -1;
			return;
	}
	recvrequest(cmd, argv[2], argv[1], "w", 0);
}
