/* WB-tree File Based Associative String Data Base System.
   Copyright (c) 1991, 1992, 1993 Holland Mark Martin

Permission to use, copy, modify, and distribute this software and its
documentation for educational, research, and non-profit purposes and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of Holland Mark Martin not be used in advertising or
publicity pertaining to distribution of the software without specific,
written prior consent in each case.  Permission to incorporate this
software into commercial products can be obtained from Jonathan
Finger, Holland Mark Martin, 174 Middlesex Turnpike, Burlington, MA,
01803-4467, USA.  Holland Mark Martin makes no representations about
the suitability or correctness of this software for any purpose.  It
is provided "as is" without express or implied warranty.  Holland Mark
Martin is under no obligation to provide any services, by way of
maintenance, update, or otherwise. */

#ifdef __STDC__
#define STDC_INCLUDES
#endif
#ifdef __TURBOC__
#define MSDOS
#endif
#ifdef MSDOS
#define STDC_INCLUDES
#endif
#ifdef VMS
#define STDC_INCLUDES
#endif

#ifdef STDC_INCLUDES
#include <stdlib.h>
#include <string.h>
#else
	unsigned char *malloc();
	unsigned char *realloc();
#endif

#ifdef MSDOS
#include <sys\types.h>
#include <sys\stat.h>
#include <io.h>
#include <errno.h>
#include <fcntl.h>
# define open_input_file(name) (open(name,O_BINARY | O_RDONLY))
# define open_output_file(name) (open(name,O_BINARY | O_WRONLY | O_CREAT, S_IWRITE | S_IREAD))
# define open_io_file(name) (open(name,O_BINARY | O_RDWR))
#else /* MSDOS */
/* #include <sys/stat.h> */
# define max(a,b) 		(a<b ? b : a)
# define min(a,b) 		(a>b ? b : a)
extern int errno;
# define open_input_file(name) (open(name,0))
# define open_output_file(name) (creat(name, 0666)) /* was S_IWRITE | S_IREAD */
# define open_io_file(name) (open(name,2))
#endif

#include <time.h>
#define get_universal_time() time(0L)

#define substring_move_left(src,start,end,dst,dstart) (memmove(&dst[dstart],&src[start],(end)-(start)))

#define substring_move_right substring_move_left

#define substring_move(src,start,end,dst,dstart) (memcpy(&dst[dstart],&src[start],(end)-(start)))

/* these are only used in blkio.scm, but are here for their SCM equivalents. */

#define file_position(fildes) (tell(fildes))
#define file_set_position(fildes,offset) (lseek(fildes,offset,0))
#define write_string(fildes,buffer,nbytes) (write(fildes,(char *)buffer,nbytes))
#define read_string(fildes,buffer,nbytes) (read(fildes,(char *)buffer,nbytes))

#define close_io_port(fildes) (close(fildes))

#define close_output_port(fildes) (close(fildes))

#define close_input_port(fildes) (close(fildes))

#define output_port_P(fildes) ((fildes)>=0)

#define input_port_P(fildes) ((fildes)>=0)


struct slck {struct slck *NEXT; int FLG; int NAME;};

typedef struct slck LCK;

extern LCK *last_lck;

LCK *make_lck();

int try_lck();

void lck();

void unlck();

void check_lcks();

struct entry {struct entry *NEXT;long ID;unsigned char *BLK;int TAG, AGE, DTY, PUS, ACC, REF, SEG;};

typedef struct entry ENTRY;

typedef int (*int_function)();

ENTRY *make_ent();

#define ent_tag(ent) ((ent)->TAG)
#define ent_next(ent) ((ent)->NEXT)
#define ent_seg(ent) ((ent)->SEG)
#define ent_id(ent) ((ent)->ID)
#define ent_blk(ent) ((ent)->BLK)
#define ent_age(ent) ((ent)->AGE)
#define ent_dty_P(ent) ((ent)->DTY)
#define ent_pus(ent) ((ent->PUS))
#define ent_acc(ent) ((ent)->ACC)
#define ent_ref(ent) ((ent)->REF)

#define ent_set_tag(ent, tag) {(ent)->TAG = tag;}
#define ent_set_next(ent, next) {(ent)->NEXT = next;}
#define ent_set_seg(ent, seg) {(ent)->SEG = seg;}
#define ent_set_id(ent, num) {(ent)->ID = num;}
#define ent_set_age(ent, age) {(ent)->AGE = age;}
#define ent_set_dty(ent, dty) {(ent)->DTY = dty;}
#define ent_set_pus(ent, pus) {(ent)->PUS = pus;}
#define ent_set_acc(ent, acc) {(ent)->ACC = acc;}
#define ent_set_ref(ent, ref) {(ent)->REF = ref;}

typedef struct {int SEG, TYP;long ID, LAST; int WCB, SPARE;} HAND;

HAND *make_han();

#define han_id(han) (((HAND *)(han))->ID)
#define han_seg(han) (((HAND *)(han))->SEG)
#define han_typ(han) (((HAND *)(han))->TYP)
#define han_last(han) (((HAND *)(han))->LAST)
#define han_wcb(han) (((HAND *)(han))->WCB)

#define han_set_num(han,num) {((HAND *)(han))->ID = num;}
#define han_set_seg(han,seg) {((HAND *)(han))->SEG = seg;}
#define han_set_typ(han,typ) {((HAND *)(han))->TYP = typ;}
#define han_set_last(han,last) {((HAND *)(han))->LAST = last;}
#define han_set_wcb(han,wcb) {((HAND *)(han))->WCB = wcb;}

typedef struct {
  int PORT, BSIZ;
  long USED;
  unsigned char *STRN;
  HAND RT_HAN, FL_HAN;
  LCK FLCK;
  LCK FFCK;
  int FLC_LEN;
  long *FLC;
} SEGD;

extern SEGD segd_tab[];

#define segd_port(segd) ((segd).PORT)
#define segd_bsiz(segd) ((segd).BSIZ)
#define segd_used(segd) ((segd).USED)
#define segd_str(segd) ((segd).STRN)
#define segd_rt_han(segd) (&((segd).RT_HAN))
#define segd_fl_han(segd) (&((segd).FL_HAN))
#define segd_lck(segd) (&((segd).FLCK))
#define segd_fck(segd) (&((segd).FFCK))
#define segd_flc_len(segd) ((segd).FLC_LEN)
#define segd_flc(segd) ((segd).FLC)

#define segd_set_port(segd,port) {(segd).PORT = port;}
#define segd_set_bsiz(segd,bsiz) {(segd).BSIZ = bsiz;}
#define segd_set_used(segd,used) {(segd).USED = used;}
#define segd_set_str(segd,strn) {(segd).STRN = strn;}
#define segd_set_flc_len(segd,len) {(segd).FLC_LEN = len;}
#define segd_set_flc(segd,flc) {(segd).FLC = flc;}

#include <stdio.h>

extern FILE *diagout;

#include "../wb/defs.h"
#include "../wb/ent.h"
#include "../wb/blink.h"
#include "../wb/handle.h"
#include "../wb/prev.h"
#include "../wb/del.h"
#include "../wb/stats.h"
#include "../wb/blkio.h"
#include "../wb/scan.h"

/* BLK predicates */

#define root_P(blk) (*(long *)&blk[blk_id_pos] == *(long *)&blk[blk_top_id_pos])

#define end_of_chain_P(blk) (*(long *)&blk[blk_nxt_id_pos] == 0L)
