use strict;
use ExtUtils::MakeMaker;
use ExtUtils::PkgConfig;

# minimum required version of dependencies we need to build
our %build_reqs = (
	'rpm' => '4.12.0',
);
our %PREREQ_PM = (
	'ExtUtils::Depends'   => '0.300',
	'ExtUtils::PkgConfig' => '1.00', # for finding rpm-devel
	'MDV::Packdrakeng' => '1.00', # for URPM::Build
	'Test::Pod' => '1.00',
);

# Writing a fake Makefile ensures that CPAN will pick up the correct
# dependencies and install them.
unless (eval "use ExtUtils::Depends '$PREREQ_PM{'ExtUtils::Depends'}';"
           . "use ExtUtils::PkgConfig '$PREREQ_PM{'ExtUtils::PkgConfig'}';"
           . "1") {
   warn "$@\n";
   WriteMakefile(
         NAME         => 'URPM',
         PREREQ_FATAL => 1,
         PREREQ_PM    => \%PREREQ_PM,
   );
   exit 1; # not reached
}

my %cfg;
unless (eval { %cfg = ExtUtils::PkgConfig->find("rpm >= $build_reqs{rpm}"); 1 })
{
	warn $@;
	exit 0;
}


sub hexversion {
	my ($major, $minor, $micro) = (@_[0] =~ /(\d+)\.(\d+)\.?(\d+)?/);
	return int($major<<16) + int($minor<<8) + int($micro<<0);
}


my @rpmflags;
#if ($hversion ge hexversion("4.13.0") && $hversion lt hexversion("5.0")) {
#    # rpm.org version 4.13.0
#    push @rpmflags, "-DRPM4140";
#}

my $ccflags = join(' ', '-Wall -Wextra -fno-strict-aliasing', @rpmflags);

#print "Found RPM version $version (compiling with flags: $ccflags)\n";

WriteMakefile(
    NAME	=> 'URPM',
    ABSTRACT_FROM => 'URPM.pm',
    AUTHOR	=> 'Thierry Vignaud',
    LICENSE     => 'perl_5',
    PREREQ_FATAL => 1,
    PREREQ_PM    => \%PREREQ_PM,
    META_MERGE => {
	'meta-spec' => { version => 2 },
        resources => {
            repository  => {
		type => 'git',
		url => 'git://git.mageia.org/software/rpm/perl-URPM/',
		web =>  'http://gitweb.mageia.org/software/rpm/perl-URPM/',
	    },
        },
	release_status => 'testing'
    },
    MIN_PERL_VERSION => '5.008001',
    CCFLAGS	=> $ccflags,
    VERSION_FROM	=> 'URPM.pm',
    LIBS	=> [ $cfg{libs}, "-lrpmbuild" ],
    INC		=> '-I/usr/include/rpm',
    dist	=> { COMPRESS => "xz -f", SUFFIX => ".xz" },
    realclean	=> { FILES => "t/RPMS/noarch/*" },
);
