#!/usr/bin/perl

# $Id: 03general.t,v 1.1 2001/12/13 23:57:13 piers Exp $

use lib qw(../lib ./lib);
use Test;
BEGIN { plan test => 16 }

use Net::Nsca;

ok( $Net::Nsca::VERSION ); # module loaded OK

my $crctable = Net::Nsca::_generate_crc32_table();
ok( $crctable->[255] == 755167117 );
ok( $crctable->[0] == 0 );
ok( $crctable->[32] == 997073096 );
ok( $crctable->[59] == 2970347812 );
ok( $crctable->[94] == 2362670323 );
ok( $crctable->[128] == 3988292384 );
ok( $crctable->[164] == 3518719985 );
ok( $crctable->[200] == 2512341634 );

my $crc;
$crc = Net::Nsca::_calculate_crc32('hello');
ok( $crc == 907060870 );

$crc = Net::Nsca::_calculate_crc32('');
ok( $crc == 0 );

$crc = Net::Nsca::_calculate_crc32('0');
ok( $crc == 4108050209 );

$crc = Net::Nsca::_calculate_crc32("\x00");
ok( $crc == 3523407757 );

$crc = Net::Nsca::_calculate_crc32('This is a typical ascii \xE3 test \n with some \t binary chars too');
ok( $crc == 2277904517 );

my $packet = 'x' x Net::Nsca::SIZEOF_DATA_PACKET;
my $crypted;

$crypted = Net::Nsca::_encrypt_xor( $packet, 2112, 'satsuma' );
ok( $crypted eq '9(=9?$(9+=:?\'(:+>:<\'+:(>9<$+9(=9?$(9+=:?\'(:+>:<\'+:(>9<$+9(=9?$(9+=:?\'(:+>:<\'+:(>9<$+9(=9?$(9+=:?\'(:+>:<\'+:(>9<$+9(=9?$(9+=:?\'(:+>:<\'+:(>9<$+9(=9?$(9+=:?\'(:+>:<\'+:(>9<$+9(=9?$(9+=:?\'(:+>:<\'+:(>9<$+9(=9?$(9+=:?\'(:+>:<\'+:(>9<$+9(=9?$(9+=:?\'(:+>:<\'+:(>9<$+9(=9?$(9+=:?\'(:+>:<\'+:(>9<$+9(=9?$(9+=:?\'(:+>:<\'+:(>9<$+9(=9?$(9+=:?\'(:+>:<\'+:(>9<$+9(=9?$(9+=:?\'(:+>:<\'+:(>9<$+9(=9?$(9+=:?\'(:+>:<\'+:(>9<$+9(=9?$(9+=:?\'(:+>:<\'+:(>9<$+9(=9?$(9+=:?\'(:+>:<\'+:(>9<$+9(=9?$(9+=:?\'(:+>:<\'+:(>9<$+9(=9?$(9+=:?\'(:+>:<\'+:(>9<$+9(=9?$(9+=:?\'(:+>:<\'+:(>9<$+9(=9?$(9+=:?\'(:+>:<\'+:(>9<$+9(=9?$(9+=:?\'(:+>:<\'+:(>9<$+9(=9?$(9+=:?\'(:+>:<\'+:(>9<$+9(=9?$(9+=:?\'(:+>:<\'+:(>9<$+9(=9?$(9+=:?\'(:+>:<\'+:(>9<$+9(=9?$(9+=:?\'(:+>:<\'+:(>9<$+9(=9?$(9+=:?\'(:+>:<\'' );

$crypted = Net::Nsca::_encrypt_xor( $packet, 21129084704, 'satsumasarefruitthatisorange' );
ok( $crypted eq '9(=94%!?.:),;<#5<(-;!?%;($&-3-;;9\'(:+3-&>:!8>!(>(;/>.&+/:(>2=--<)>//;?(<4$.<%9&;+//%?.<??$(9 :%*==%>=!+5!3#=)"-,:+5;5!.;-8,/84!48\')8#:&8 &\')<)89<$+2)2)):9#==" <)? :-$.,9 <39")?+;,,3=)8; -> :%3).+*;->:<\' ;!>*.>? =>))4%<\'>+\'./2)4?:%-9(;/\':5%;<$+= 9.:!"(-?+=:?,)3-=-*8< >5 !8&;#8(\'-$;!8<=!+:(8$.29&<8"(=#2\'2-!/)9(=94%!?.:),;<#5<(-;!?%;($&-3-;;9\'(:+3-&>:!8>!(>(;/>.&+/:(>2=--<)>//;?(<4$.<%9&;+//%?.<??$(9 :%*==%>=!+5!3#=)"-,:+5;5!.;-8,/84!48\')8#:&8 &\')<)89<$+2)2)):9#==" <)? :-$.,9 <39")?+;,,3=)8; -> :%3).+*;->:<\' ;!>*.>? =>))4%<\'>+\'./2)4?:%-9(;/\':5%;<$+= 9.:!"(-?+=:?,)3-=-*8< >5 !8&;#8(\'-$;!8<=!+:(8$.29&<8"(=#2\'2-!/)9(=94%!?.:),;<#5<(-;!?%;($&-3-;;9\'(:+3-&>:!8>!(>(;/>.&+/:(>2=--<)>//;?(<4$.<%9&;+//%?.<??$(9 :%*==%>=!+5' );

