package Bencher::Scenario::URI::Info::info;

use 5.010001;
use strict;
use warnings;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2021-10-08'; # DATE
our $DIST = 'Bencher-Scenarios-URI-Info'; # DIST
our $VERSION = '0.001'; # VERSION

our $scenario = {
    summary => 'Benchmark info()',
    participants => [],
    datasets => [
        {args=>{url=>'https://www.google.com/search?client=firefox&q=foo+bar'}},
    ],
};

my $ui;
{
    require URI::Info;
    local $ENV{URI_INFO_PLUGINS};
    $ui = URI::Info->new;
}

push @{$scenario->{participants}}, {
    name => 'URI::Info (all '.(scalar @{ $ui->{include_plugins} }).' plugins)',
    module => 'URI::Info',
    code_template => 'state $ui = URI::Info->new(); $ui->info(<url>)',
};

push @{$scenario->{participants}}, {
    name => 'URI::Info (google plugin only)',
    module => 'URI::Info',
    code_template => 'state $ui = URI::Info->new(include_plugins=>["SearchQuery::google"]); $ui->info(<url>)',
};

1;
# ABSTRACT: Benchmark info()

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::URI::Info::info - Benchmark info()

=head1 VERSION

This document describes version 0.001 of Bencher::Scenario::URI::Info::info (from Perl distribution Bencher-Scenarios-URI-Info), released on 2021-10-08.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m URI::Info::info

To run module startup overhead benchmark:

 % bencher --module-startup -m URI::Info::info

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<URI::Info> 0.001

=head1 BENCHMARK PARTICIPANTS

=over

=item * URI::Info (all 3 plugins) (perl_code)

Code template:

 state $ui = URI::Info->new(); $ui->info(<url>)



=item * URI::Info (google plugin only) (perl_code)

Code template:

 state $ui = URI::Info->new(include_plugins=>["SearchQuery::google"]); $ui->info(<url>)



=back

=head1 BENCHMARK DATASETS

=over

=item * https://www.google.com/search?client=firefox&q=foo+bar

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.34.0 >>, CPU: I<< Intel(R) Core(TM) i5-7200U CPU @ 2.50GHz (2 cores) >>, OS: I<< GNU/Linux Ubuntu version 20.04 >>, OS kernel: I<< Linux version 5.3.0-64-generic >>.

Benchmark with default options (C<< bencher -m URI::Info::info >>):

 #table1#
 +--------------------------------+-----------+-----------+-----------------------+-----------------------+---------+---------+
 | participant                    | rate (/s) | time (μs) | pct_faster_vs_slowest | pct_slower_vs_fastest |  errors | samples |
 +--------------------------------+-----------+-----------+-----------------------+-----------------------+---------+---------+
 | URI::Info (all 3 plugins)      |     24000 |        41 |                 0.00% |                 1.69% | 4.7e-08 |      26 |
 | URI::Info (google plugin only) |     25000 |        40 |                 1.69% |                 0.00% | 5.3e-08 |      20 |
 +--------------------------------+-----------+-----------+-----------------------+-----------------------+---------+---------+


Formatted as L<Benchmark.pm|Benchmark> result:

                                     Rate  URI::Info (all 3 plugins)  URI::Info (google plugin only) 
  URI::Info (all 3 plugins)       24000/s                         --                             -2% 
  URI::Info (google plugin only)  25000/s                         2%                              -- 
 
 Legends:
   URI::Info (all 3 plugins): participant=URI::Info (all 3 plugins)
   URI::Info (google plugin only): participant=URI::Info (google plugin only)

=for html <img src="data:image/png;base64,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" />


To display as an interactive HTML table on a browser, you can add option C<--format html+datatables>.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-URI-Info>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-URI-Info>.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla plugin and/or Pod::Weaver::Plugin. Any additional steps required
beyond that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-URI-Info>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
