package Bencher::Scenario::BagComparison;

our $DATE = '2016-10-19'; # DATE
our $VERSION = '0.001'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark bag comparison',
    participants => [
        {
            module => 'Test::Deep', # Test::Deep::NoTest is useless without importing
            code_template=>'state $bag = Test::Deep::bag(@{<bag>}); Test::Deep::eq_deeply(<array>, $bag)',
        },
    ],
    datasets => [
        {name=>'elems=10num' , args=>{array=>[1..10] , bag=>[reverse 1..10] }},
        {name=>'elems=100num', args=>{array=>[1..100], bag=>[reverse 1..100]}},
        {name=>'elems=200num', args=>{array=>[1..200], bag=>[reverse 1..200]}},
    ],
};

1;
# ABSTRACT: Benchmark bag comparison

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::BagComparison - Benchmark bag comparison

=head1 VERSION

This document describes version 0.001 of Bencher::Scenario::BagComparison (from Perl distribution Bencher-Scenario-BagComparison), released on 2016-10-19.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m BagComparison

To run module startup overhead benchmark:

 % bencher --module-startup -m BagComparison

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 DESCRIPTION

TODO: find another bag comparison module.

TODO: compare complex elements.

TODO: compare with Data::Compare + sorting.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Test::Deep> 1.120

=head1 BENCHMARK PARTICIPANTS

=over

=item * Test::Deep (perl_code)

Code template:

 state $bag = Test::Deep::bag(@{<bag>}); Test::Deep::eq_deeply(<array>, $bag)



=back

=head1 BENCHMARK DATASETS

=over

=item * elems=10num

=item * elems=100num

=item * elems=200num

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.24.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m BagComparison >>):

 #table1#
 +--------------+-----------+-----------+------------+-----------+---------+
 | dataset      | rate (/s) | time (ms) | vs_slowest |  errors   | samples |
 +--------------+-----------+-----------+------------+-----------+---------+
 | elems=200num |      7.88 |    127    |       1    |   0.00011 |      20 |
 | elems=100num |     18    |     55.6  |       2.28 | 2.2e-05   |      20 |
 | elems=10num  |   1750    |      0.57 |     222    | 4.2e-07   |      21 |
 +--------------+-----------+-----------+------------+-----------+---------+


Benchmark module startup overhead (C<< bencher -m BagComparison --module-startup >>):

 #table2#
 +---------------------+-----------+------------------------+------------+---------+---------+
 | participant         | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors | samples |
 +---------------------+-----------+------------------------+------------+---------+---------+
 | Test::Deep          |        30 |                     25 |          1 | 0.00043 |      20 |
 | perl -e1 (baseline) |         5 |                      0 |          5 | 7e-05   |      20 |
 +---------------------+-----------+------------------------+------------+---------+---------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-BagComparison>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-BagComparison>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-BagComparison>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<Bencher::Scenario::SetComparison>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
