use Test::More qw(no_plan);
use Date::Range;
use Data::Dumper;
use CodeRyte::DateRange;
use strict;


my $ref_date = '2016-12-28';

my $crdr = CodeRyte::DateRange->new(today_override => $ref_date);
my $dr = Date::Range->new(today_date => $ref_date);

while (my $line = <main::DATA>) {
    chomp $line;
    my ($type,$intervals,$span,$sliding_window,$direction,$test_start,$test_end,$test_last) = split /,/, $line;
    $dr->set_type($type);
    $dr->set_intervals($intervals);
    $dr->set_span($span);
    $dr->set_sliding_window($sliding_window);
    $dr->set_direction($direction);
    my $atts = "I=$intervals | S=$span | W=$sliding_window | D=$direction";

    my ($start,$end,$last) = $dr->get_dates;
    cmp_ok($start,'eq',$test_start,"$type START $atts") or BAIL_OUT("Fail");
    cmp_ok($end,'eq',$test_end,"$type END $atts") or BAIL_OUT("Fail");
    cmp_ok($last,'eq',$test_last,"$type LAST $atts") or BAIL_OUT("Fail");

}

__END__
YEAR,-3,1,0,-,2019-01-01,2020-01-01,2019-12-31
YEAR,-2,1,0,-,2018-01-01,2019-01-01,2018-12-31
YEAR,-1,1,0,-,2017-01-01,2018-01-01,2017-12-31
YEAR,0,1,0,-,2016-01-01,2017-01-01,2016-12-31
YEAR,1,1,0,-,2015-01-01,2016-01-01,2015-12-31
YEAR,2,1,0,-,2014-01-01,2015-01-01,2014-12-31
YEAR,3,1,0,-,2013-01-01,2014-01-01,2013-12-31
YEAR,-3,5,0,-,2031-01-01,2036-01-01,2035-12-31
YEAR,-2,5,0,-,2026-01-01,2031-01-01,2030-12-31
YEAR,-1,5,0,-,2021-01-01,2026-01-01,2025-12-31
YEAR,0,5,0,-,2016-01-01,2021-01-01,2020-12-31
YEAR,1,5,0,-,2011-01-01,2016-01-01,2015-12-31
YEAR,2,5,0,-,2006-01-01,2011-01-01,2010-12-31
YEAR,3,5,0,-,2001-01-01,2006-01-01,2005-12-31
YEAR,-3,5,1,-,2015-01-01,2020-01-01,2019-12-31
YEAR,-2,5,1,-,2014-01-01,2019-01-01,2018-12-31
YEAR,-1,5,1,-,2013-01-01,2018-01-01,2017-12-31
YEAR,0,5,1,-,2012-01-01,2017-01-01,2016-12-31
YEAR,1,5,1,-,2011-01-01,2016-01-01,2015-12-31
YEAR,2,5,1,-,2010-01-01,2015-01-01,2014-12-31
YEAR,3,5,1,-,2009-01-01,2014-01-01,2013-12-31
QUARTER,-3,1,0,-,2017-07-01,2017-10-01,2017-09-30
QUARTER,-2,1,0,-,2017-04-01,2017-07-01,2017-06-30
QUARTER,-1,1,0,-,2017-01-01,2017-04-01,2017-03-31
QUARTER,0,1,0,-,2016-10-01,2017-01-01,2016-12-31
QUARTER,1,1,0,-,2016-07-01,2016-10-01,2016-09-30
QUARTER,2,1,0,-,2016-04-01,2016-07-01,2016-06-30
QUARTER,3,1,0,-,2016-01-01,2016-04-01,2016-03-31
QUARTER,-3,5,0,-,2020-07-01,2021-10-01,2021-09-30
QUARTER,-2,5,0,-,2019-04-01,2020-07-01,2020-06-30
QUARTER,-1,5,0,-,2018-01-01,2019-04-01,2019-03-31
QUARTER,0,5,0,-,2016-10-01,2018-01-01,2017-12-31
QUARTER,1,5,0,-,2015-07-01,2016-10-01,2016-09-30
QUARTER,2,5,0,-,2014-04-01,2015-07-01,2015-06-30
QUARTER,3,5,0,-,2013-01-01,2014-04-01,2014-03-31
QUARTER,-3,5,1,-,2016-07-01,2017-10-01,2017-09-30
QUARTER,-2,5,1,-,2016-04-01,2017-07-01,2017-06-30
QUARTER,-1,5,1,-,2016-01-01,2017-04-01,2017-03-31
QUARTER,0,5,1,-,2015-10-01,2017-01-01,2016-12-31
QUARTER,1,5,1,-,2015-07-01,2016-10-01,2016-09-30
QUARTER,2,5,1,-,2015-04-01,2016-07-01,2016-06-30
QUARTER,3,5,1,-,2015-01-01,2016-04-01,2016-03-31
MONTH,-3,1,0,-,2017-03-01,2017-04-01,2017-03-31
MONTH,-2,1,0,-,2017-02-01,2017-03-01,2017-02-28
MONTH,-1,1,0,-,2017-01-01,2017-02-01,2017-01-31
MONTH,0,1,0,-,2016-12-01,2017-01-01,2016-12-31
MONTH,1,1,0,-,2016-11-01,2016-12-01,2016-11-30
MONTH,2,1,0,-,2016-10-01,2016-11-01,2016-10-31
MONTH,3,1,0,-,2016-09-01,2016-10-01,2016-09-30
MONTH,-3,5,0,-,2018-03-01,2018-08-01,2018-07-31
MONTH,-2,5,0,-,2017-10-01,2018-03-01,2018-02-28
MONTH,-1,5,0,-,2017-05-01,2017-10-01,2017-09-30
MONTH,0,5,0,-,2016-12-01,2017-05-01,2017-04-30
MONTH,1,5,0,-,2016-07-01,2016-12-01,2016-11-30
MONTH,2,5,0,-,2016-02-01,2016-07-01,2016-06-30
MONTH,3,5,0,-,2015-09-01,2016-02-01,2016-01-31
MONTH,-3,5,1,-,2016-11-01,2017-04-01,2017-03-31
MONTH,-2,5,1,-,2016-10-01,2017-03-01,2017-02-28
MONTH,-1,5,1,-,2016-09-01,2017-02-01,2017-01-31
MONTH,0,5,1,-,2016-08-01,2017-01-01,2016-12-31
MONTH,1,5,1,-,2016-07-01,2016-12-01,2016-11-30
MONTH,2,5,1,-,2016-06-01,2016-11-01,2016-10-31
MONTH,3,5,1,-,2016-05-01,2016-10-01,2016-09-30
DAY,-3,1,0,-,2016-12-31,2017-01-01,2016-12-31
DAY,-2,1,0,-,2016-12-30,2016-12-31,2016-12-30
DAY,-1,1,0,-,2016-12-29,2016-12-30,2016-12-29
DAY,0,1,0,-,2016-12-28,2016-12-29,2016-12-28
DAY,1,1,0,-,2016-12-27,2016-12-28,2016-12-27
DAY,2,1,0,-,2016-12-26,2016-12-27,2016-12-26
DAY,3,1,0,-,2016-12-25,2016-12-26,2016-12-25
DAY,-3,5,0,-,2017-01-12,2017-01-17,2017-01-16
DAY,-2,5,0,-,2017-01-07,2017-01-12,2017-01-11
DAY,-1,5,0,-,2017-01-02,2017-01-07,2017-01-06
DAY,0,5,0,-,2016-12-28,2017-01-02,2017-01-01
DAY,1,5,0,-,2016-12-23,2016-12-28,2016-12-27
DAY,2,5,0,-,2016-12-18,2016-12-23,2016-12-22
DAY,3,5,0,-,2016-12-13,2016-12-18,2016-12-17
DAY,-3,5,1,-,2016-12-27,2017-01-01,2016-12-31
DAY,-2,5,1,-,2016-12-26,2016-12-31,2016-12-30
DAY,-1,5,1,-,2016-12-25,2016-12-30,2016-12-29
DAY,0,5,1,-,2016-12-24,2016-12-29,2016-12-28
DAY,1,5,1,-,2016-12-23,2016-12-28,2016-12-27
DAY,2,5,1,-,2016-12-22,2016-12-27,2016-12-26
DAY,3,5,1,-,2016-12-21,2016-12-26,2016-12-25
YEAR,-3,1,0,+,2013-01-01,2014-01-01,2013-12-31
YEAR,-2,1,0,+,2014-01-01,2015-01-01,2014-12-31
YEAR,-1,1,0,+,2015-01-01,2016-01-01,2015-12-31
YEAR,0,1,0,+,2016-01-01,2017-01-01,2016-12-31
YEAR,1,1,0,+,2017-01-01,2018-01-01,2017-12-31
YEAR,2,1,0,+,2018-01-01,2019-01-01,2018-12-31
YEAR,3,1,0,+,2019-01-01,2020-01-01,2019-12-31
YEAR,-3,5,0,+,2001-01-01,2006-01-01,2005-12-31
YEAR,-2,5,0,+,2006-01-01,2011-01-01,2010-12-31
YEAR,-1,5,0,+,2011-01-01,2016-01-01,2015-12-31
YEAR,0,5,0,+,2016-01-01,2021-01-01,2020-12-31
YEAR,1,5,0,+,2021-01-01,2026-01-01,2025-12-31
YEAR,2,5,0,+,2026-01-01,2031-01-01,2030-12-31
YEAR,3,5,0,+,2031-01-01,2036-01-01,2035-12-31
YEAR,-3,5,1,+,2013-01-01,2018-01-01,2017-12-31
YEAR,-2,5,1,+,2014-01-01,2019-01-01,2018-12-31
YEAR,-1,5,1,+,2015-01-01,2020-01-01,2019-12-31
YEAR,0,5,1,+,2016-01-01,2021-01-01,2020-12-31
YEAR,1,5,1,+,2017-01-01,2022-01-01,2021-12-31
YEAR,2,5,1,+,2018-01-01,2023-01-01,2022-12-31
YEAR,3,5,1,+,2019-01-01,2024-01-01,2023-12-31
QUARTER,-3,1,0,+,2016-01-01,2016-04-01,2016-03-31
QUARTER,-2,1,0,+,2016-04-01,2016-07-01,2016-06-30
QUARTER,-1,1,0,+,2016-07-01,2016-10-01,2016-09-30
QUARTER,0,1,0,+,2016-10-01,2017-01-01,2016-12-31
QUARTER,1,1,0,+,2017-01-01,2017-04-01,2017-03-31
QUARTER,2,1,0,+,2017-04-01,2017-07-01,2017-06-30
QUARTER,3,1,0,+,2017-07-01,2017-10-01,2017-09-30
QUARTER,-3,5,0,+,2013-01-01,2014-04-01,2014-03-31
QUARTER,-2,5,0,+,2014-04-01,2015-07-01,2015-06-30
QUARTER,-1,5,0,+,2015-07-01,2016-10-01,2016-09-30
QUARTER,0,5,0,+,2016-10-01,2018-01-01,2017-12-31
QUARTER,1,5,0,+,2018-01-01,2019-04-01,2019-03-31
QUARTER,2,5,0,+,2019-04-01,2020-07-01,2020-06-30
QUARTER,3,5,0,+,2020-07-01,2021-10-01,2021-09-30
QUARTER,-3,5,1,+,2016-01-01,2017-04-01,2017-03-31
QUARTER,-2,5,1,+,2016-04-01,2017-07-01,2017-06-30
QUARTER,-1,5,1,+,2016-07-01,2017-10-01,2017-09-30
QUARTER,0,5,1,+,2016-10-01,2018-01-01,2017-12-31
QUARTER,1,5,1,+,2017-01-01,2018-04-01,2018-03-31
QUARTER,2,5,1,+,2017-04-01,2018-07-01,2018-06-30
QUARTER,3,5,1,+,2017-07-01,2018-10-01,2018-09-30
MONTH,-3,1,0,+,2016-09-01,2016-10-01,2016-09-30
MONTH,-2,1,0,+,2016-10-01,2016-11-01,2016-10-31
MONTH,-1,1,0,+,2016-11-01,2016-12-01,2016-11-30
MONTH,0,1,0,+,2016-12-01,2017-01-01,2016-12-31
MONTH,1,1,0,+,2017-01-01,2017-02-01,2017-01-31
MONTH,2,1,0,+,2017-02-01,2017-03-01,2017-02-28
MONTH,3,1,0,+,2017-03-01,2017-04-01,2017-03-31
MONTH,-3,5,0,+,2015-09-01,2016-02-01,2016-01-31
MONTH,-2,5,0,+,2016-02-01,2016-07-01,2016-06-30
MONTH,-1,5,0,+,2016-07-01,2016-12-01,2016-11-30
MONTH,0,5,0,+,2016-12-01,2017-05-01,2017-04-30
MONTH,1,5,0,+,2017-05-01,2017-10-01,2017-09-30
MONTH,2,5,0,+,2017-10-01,2018-03-01,2018-02-28
MONTH,3,5,0,+,2018-03-01,2018-08-01,2018-07-31
MONTH,-3,5,1,+,2016-09-01,2017-02-01,2017-01-31
MONTH,-2,5,1,+,2016-10-01,2017-03-01,2017-02-28
MONTH,-1,5,1,+,2016-11-01,2017-04-01,2017-03-31
MONTH,0,5,1,+,2016-12-01,2017-05-01,2017-04-30
MONTH,1,5,1,+,2017-01-01,2017-06-01,2017-05-31
MONTH,2,5,1,+,2017-02-01,2017-07-01,2017-06-30
MONTH,3,5,1,+,2017-03-01,2017-08-01,2017-07-31
DAY,-3,1,0,+,2016-12-25,2016-12-26,2016-12-25
DAY,-2,1,0,+,2016-12-26,2016-12-27,2016-12-26
DAY,-1,1,0,+,2016-12-27,2016-12-28,2016-12-27
DAY,0,1,0,+,2016-12-28,2016-12-29,2016-12-28
DAY,1,1,0,+,2016-12-29,2016-12-30,2016-12-29
DAY,2,1,0,+,2016-12-30,2016-12-31,2016-12-30
DAY,3,1,0,+,2016-12-31,2017-01-01,2016-12-31
DAY,-3,5,0,+,2016-12-13,2016-12-18,2016-12-17
DAY,-2,5,0,+,2016-12-18,2016-12-23,2016-12-22
DAY,-1,5,0,+,2016-12-23,2016-12-28,2016-12-27
DAY,0,5,0,+,2016-12-28,2017-01-02,2017-01-01
DAY,1,5,0,+,2017-01-02,2017-01-07,2017-01-06
DAY,2,5,0,+,2017-01-07,2017-01-12,2017-01-11
DAY,3,5,0,+,2017-01-12,2017-01-17,2017-01-16
DAY,-3,5,1,+,2016-12-25,2016-12-30,2016-12-29
DAY,-2,5,1,+,2016-12-26,2016-12-31,2016-12-30
DAY,-1,5,1,+,2016-12-27,2017-01-01,2016-12-31
DAY,0,5,1,+,2016-12-28,2017-01-02,2017-01-01
DAY,1,5,1,+,2016-12-29,2017-01-03,2017-01-02
DAY,2,5,1,+,2016-12-30,2017-01-04,2017-01-03
DAY,3,5,1,+,2016-12-31,2017-01-05,2017-01-04
