#define PERL_NO_GET_CONTEXT
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "ppport.h"

/* op_free is both Perl_op_free and a function in opusfile */
#undef op_free
#include <opus/opusfile.h>

#include "const-c.inc"

MODULE = Audio::Opusfile		PACKAGE = Audio::Opusfile		PREFIX = op_

PROTOTYPES: ENABLE
INCLUDE: const-xs.inc

OggOpusFile*
op_open_file(path)
	const char *path;
PREINIT:
	int err;
CODE:
	RETVAL = op_open_file(path, &err);
	if(err)
		croak("op_open_file returned error %d\n", err);
OUTPUT:
	RETVAL

void
DESTROY(of)
	OggOpusFile *of;
CODE:
	op_free(of);

const OpusHead*
op_head(of, li = -1)
	OggOpusFile *of;
	int li;

const OpusTags*
op_tags(of, li = -1)
	OggOpusFile *of;
	int li;

MODULE = Audio::Opusfile		PACKAGE = Audio::Opusfile::Tags		PREFIX = opus_tags_

int
opus_tags_query_count(tags, tag)
	const OpusTags* tags;
	const char* tag;

const char*
opus_tags_query(tags, tag, count = 0)
	const OpusTags* tags;
	const char* tag;
	int count;
