#!/usr/bin/env perl

use v5.14;
use warnings FATAL => 'all';

package Term::Table2;

use Clone qw(clone);
use Test2::V0 -target => 'Term::Table2';
use Test2::Mock;

my $mockThis = Test2::Mock->new(
  class    => $CLASS,
  override => [
    GetTerminalSize => sub { return (20, 10) },
  ]
);

my $table;
my $expected;

$table    = bless({':numberOfColumns' => 2}, $CLASS);
$expected = bless(
  {
    ':numberOfColumns' => 2,
    'broadColumn'      => [WRAP, WRAP],
    'broadHeader'      => [WRAP, WRAP],
    'broadRow'         => WRAP,
    'collapse'         => [FALSE, FALSE],
    'columnWidth'      => [ADJUST, ADJUST],
    'header'           => [],
    'pad'              => 1,
    'pageHeight'       => 10,
    'rows'             => [],
    'separateRows'     => FALSE,
    'tableWidth'       => 20,
  },
  $CLASS,
);
is($table->_setDefaults(), $expected, 'No option supplied');

$table = bless(
  {
    ':numberOfColumns' => 2,
    'broadColumn'      => CUT,
    'broadHeader'      => [CUT, WRAP],
    'broadRow'         => SPLIT,
    'collapse'         => [FALSE, TRUE],
    'columnWidth'      => [ADJUST, 10],
    'pad'              => 2,
    'pageHeight'       => 30,
    'rows'             => [],
    'separateRows'     => FALSE,
    'tableWidth'       => 40,
  },
  $CLASS,
);
$expected                  = clone($table);
$expected->{'broadColumn'} = [CUT, CUT];
$expected->{'header'}      = [];
$expected->{'rows'}        = [];
is($table->_setDefaults(), $expected, 'All option supplied');

done_testing();