use strict;
use warnings;
use utf8;

use Test::More;
use WWW::YahooJapan::KanaAddress;

#===============================================================================
# Constants
#===============================================================================
my @addresses = (
[
  ['京都府', '京都市中京区', '三本木5丁目'],
  ['きょうとふ', 'きょうとしなかぎょうく', 'さんぼんぎ５ちょうめ'],
],
[
  ['岩手県', '矢巾町', '大字南矢幅第１１地割'],
  ['いわてけん', 'やはばちょう', 'みなみやはばだい１１ちわり'],
],
[
  ['北海道', '札幌市中央区', '南3条西2丁目'],
  ['ほっかいどう', 'さっぽろしちゅうおうく', 'みなみさんじょうにし'],
],
);

#===============================================================================
# Main
#===============================================================================

plan tests => scalar(@addresses);
     
my $yahoo = WWW::YahooJapan::KanaAddress->new();
foreach my $r (@addresses){
	ok(eq_array([ $yahoo->search(@{ $r->[0] }) ], $r->[1]));
}
