#
# TODO:
#  probably should export ioctl constants
#  pod
#

package IO::Tty;

use IO::Handle;
use IO::File;

require DynaLoader;

use vars qw(@ISA $VERSION $XS_VERSION);

$VERSION = $XS_VERSION = "0.03";
@ISA = qw(IO::Handle);

BOOT_XS: {
    # If I inherit DynaLoader then I inherit AutoLoader and I DON'T WANT TO
    require DynaLoader;

    # DynaLoader calls dl_load_flags as a static method.
    *dl_load_flags = DynaLoader->can('dl_load_flags');

    do {
	defined(&bootstrap)
		? \&bootstrap
		: \&DynaLoader::bootstrap
    }->(__PACKAGE__);
}

sub import {
    my $this = shift;
    local $Exporter::ExportLevel = 1;
    
    import IO::Tty::Constant @_;
}

sub open {
    my($tty,$dev,$mode) = @_;

    IO::File::open($tty,$dev,$mode) or
	return undef;

    _InitSlave($tty,$dev);

    $tty->autoflush;

    1;
}

package IO::Tty::Constant;

use vars qw(@ISA @EXPORT);
require Exporter;

@ISA = qw(Exporter);

@EXPORT_OK = qw(
	B0 B110 B115200 B1200 B134 B150 B153600 B1800 B19200 B200 B230400
	B2400 B300 B307200 B38400 B460800 B4800 B50 B57600 B600 B75 B76800
	B9600 BRKINT BS0 BS1 BSDLY CBAUD CBAUDEXT CBRK CCTS_OFLOW CDEL
	CDSUSP CEOF CEOL CEOL2 CEOT CERASE CESC CFLUSH CIBAUD CIBAUDEXT
	CINTR CKILL CLNEXT CLOCAL CNSWTCH CNUL CQUIT CR0 CR1 CR2 CR3 CRDLY
	CREAD CRPRNT CRTSCTS CRTSXOFF CRTS_IFLOW CS5 CS6 CS7 CS8 CSIZE
	CSTART CSTOP CSTOPB CSUSP CSWTCH CWERASE DEFECHO DIOC DIOCGETP
	DIOCSETP DOSMODE ECHO ECHOCTL ECHOE ECHOK ECHOKE ECHONL ECHOPRT
	EXTA EXTB FF0 FF1 FFDLY FIORDCHK FLUSHO HUPCL ICANON ICRNL IEXTEN
	IGNBRK IGNCR IGNPAR IMAXBEL INLCR INPCK ISIG ISTRIP IUCLC IXANY
	IXOFF IXON KBENABLED LDCHG LDCLOSE LDDMAP LDEMAP LDGETT LDGMAP
	LDIOC LDNMAP LDOPEN LDSETT LDSMAP LOBLK NCCS NL0 NL1 NLDLY NOFLSH
	OCRNL OFDEL OFILL OLCUC ONLCR ONLRET ONOCR OPOST PAGEOUT PARENB
	PAREXT PARMRK PARODD PENDIN RCV1EN RTS_TOG TAB0 TAB1 TAB2 TAB3
	TABDLY TCDSET TCFLSH TCGETA TCGETS TCIFLUSH TCIOFF TCIOFLUSH TCION
	TCOFLUSH TCOOFF TCOON TCSADRAIN TCSAFLUSH TCSANOW TCSBRK TCSETA
	TCSETAF TCSETAW TCSETS TCSETSF TCSETSW TCXONC TERM_D40 TERM_D42
	TERM_H45 TERM_NONE TERM_TEC TERM_TEX TERM_V10 TERM_V61 TIOCCBRK
	TIOCCDTR TIOCEXCL TIOCFLUSH TIOCGETC TIOCGETD TIOCGETP TIOCGLTC
	TIOCGPGRP TIOCGSID TIOCGSOFTCAR TIOCGWINSZ TIOCHPCL TIOCKBOF
	TIOCKBON TIOCLBIC TIOCLBIS TIOCLGET TIOCLSET TIOCMBIC TIOCMBIS
	TIOCMGET TIOCMSET TIOCM_CAR TIOCM_CD TIOCM_CTS TIOCM_DSR TIOCM_DTR
	TIOCM_LE TIOCM_RI TIOCM_RNG TIOCM_RTS TIOCM_SR TIOCM_ST TIOCNOTTY
	TIOCNXCL TIOCOUTQ TIOCREMOTE TIOCSBRK TIOCSDTR TIOCSETC TIOCSETDTI
	OCSETN TIOCSETP TIOCSIGNAL TIOCSLTC TIOCSPGRP TIOCSSID TIOCSSOFTCAR
	TIOCSTART TIOCSTI TIOCSTOP TIOCSWINSZ TM_ANL TM_CECHO TM_CINVIS
	TM_LCF TM_NONE TM_SET TM_SNL TOSTOP VCEOF VCEOL VDISCARD VDSUSP
	VEOF VEOL VEOL2 VERASE VINTR VKILL VLNEXT VMIN VQUIT VREPRINT
	VSTART VSTOP VSUSP VSWTCH VT0 VT1 VTDLY VTIME VWERASE WRAP
	XCASE XCLUDE XMT1EN XTABS
);

1;
