package Travel::Status::DE::IRIS::Stations;

use strict;
use warnings;
use 5.014;
use utf8;

use List::Util qw(min);
use List::UtilsBy qw(uniq_by);
use List::MoreUtils qw(firstval pairwise);
use Text::LevenshteinXS qw(distance);

# TODO switch to Text::Levenshtein::XS once AUR/Debian packages become available

our $VERSION = '1.03';

my @stations = (

	[ 'XNTH',  '`t Harde' ],
	[ 'YMMBM', '6,1/60,3 Bad MGH' ],
	[ 'KA',    'Aachen Hbf' ],
	[ 'KASZ',  'Aachen Schanz' ],
	[ 'KAS',   'Aachen Süd' ],
	[ 'KXA',   'Aachen Süd Gr' ],
	[ 'KAW',   'Aachen West' ],
	[ 'KAW G', 'Aachen West Gbf' ],
	[ 'KXAW',  'Aachen West Gr' ],
	[ 'KAW P', 'Aachen West Pbf' ],
	[ 'KAW W', 'Aachen West Wk' ],
	[ 'KAG',   'Aachen-Gemmenich' ],
	[ 'XDA',   'Aalborg' ],
	[ 'TA',    'Aalen' ],
	[ 'XBAAL', 'Aalter' ],
	[ 'XSA',   'Aarau' ],
	[ 'XSABO', 'Aarburg-Oftring' ],
	[ 'XDAR',  'Aarhus H' ],
	[ 'XDARH', 'Aarhus Havn' ],
	[ 'XMAA',  'Abaliget' ],
	[ 'XCAB',  'Abdulino' ],
	[ 'HABZ',  'Abelitz' ],
	[ 'KAB',   'Abenden' ],
	[ 'MABG',  'Abensberg' ],
	[ 'XMAH',  'Abrahamhegy' ],
	[ 'NAHF',  'Aburg Hochschule' ],
	[ 'EDOBZ', 'Abzw Dbw' ],
	[ 'HACC',  'Accum' ],
	[ 'XFAC',  'Acheres Triage' ],
	[ 'RAH',   'Achern' ],
	[ 'RAH H', 'Achern Bstg' ],
	[ 'RAH F', 'Achern (F)' ],
	[ 'RAHG',  'Achern DB/SWEG' ],
	[ 'XFAH',  'Achiet' ],
	[ 'HACH',  'Achim' ],
	[ 'HQAC',  'Achim NI/HB' ],
	[ 'RAK',   'Achkarren' ],
	[ 'HAMR',  'Achmer' ],
	[ 'HQAM',  'Achmer NI/NRW' ],
	[ 'XNAT',  'Acht' ],
	[ 'AACW',  'Achterwehr' ],
	[ 'XIAA',  'Acireale' ],
	[ 'XIAQT', 'Acqui Terme' ],
	[ 'KAREG', 'Ac-Rothe E Gbf' ],
	[ 'KAREP', 'Ac-Rothe E Pbf' ],
	[ 'KARE',  'Ac-Rothe Erde' ],
	[ 'XFAD',  'Adamswiller' ],
	[ 'HADB',  'Adelebsen' ],
	[ 'HADH',  'Adelheide' ],
	[ 'MAD',   'Adelschlag' ],
	[ 'NADM',  'Adelsdf/Mittelfr' ],
	[ 'RADN',  'Adelsheim Nord' ],
	[ 'TAD',   'Adelsheim Ost' ],
	[ 'AADF',  'Adendorf' ],
	[ 'XUAJ',  'Adjud' ],
	[ 'XCAD',  'Adler' ],
	[ 'DADO',  'Adorf (Erzg)' ],
	[ 'DADG',  'Adorf (V) DB-Gr' ],
	[ 'DAD',   'Adorf (Vogtl)' ],
	[ 'TAF',   'Affaltrach' ],
	[ 'XSAA',  'Affoltern Albis' ],
	[ 'XSAW',  'Affoltern-Weier' ],
	[ 'MAGD',  'Agatharied' ],
	[ 'AABG',  'Agathenburg' ],
	[ 'XFAG',  'Agde' ],
	[ 'RAG',   'Aglasterhausen' ],
	[ 'XIACC', 'Agliano-C C' ],
	[ 'XIAG',  'Agrigento Centr.' ],
	[ 'RA',    'Aha' ],
	[ 'EAHS',  'Ahaus' ],
	[ 'HAHN',  'Ahausen' ],
	[ 'WABG',  'Ahlbeck Grenze' ],
	[ 'WABO',  'Ahlbeck Ostseeth' ],
	[ 'HAHM',  'Ahlem' ],
	[ 'EAHL',  'Ahlen (Westf)' ],
	[ 'EAHLG', 'Ahlen Gbf' ],
	[ 'EAHLH', 'Ahlen Notbstg' ],
	[ 'HAHO',  'Ahlhorn' ],
	[ 'HAH',   'Ahlshausen' ],
	[ 'HALT',  'Ahlten' ],
	[ 'FATC',  'Ahnatal-Casselbr' ],
	[ 'FHEH',  'Ahnatal-Heckersh' ],
	[ 'FWEI',  'Ahnatal-Weimar' ],
	[ 'MAHN',  'Ahrain' ],
	[ 'KBRU',  'Ahrbrück' ],
	[ 'AAHR',  'Ahrensburg' ],
	[ 'AAHN',  'Ahrensburg Nord' ],
	[ 'AQAH',  'Ahrensburg SH/HH' ],
	[ 'AAHG',  'Ahrensburg-Gh' ],
	[ 'BAFR',  'Ahrensf Friedhof' ],
	[ 'BAFN',  'Ahrensf Nord' ],
	[ 'BAHR',  'Ahrensfelde' ],
	[ 'BAF',   'Ahrensfelde S-B' ],
	[ 'BQAH',  'Ahrensfelde LGr' ],
	[ 'AARF',  'Ahrensfelde/Brm' ],
	[ 'KAH',   'Ahrweiler' ],
	[ 'KAHM',  'Ahrweiler Markt' ],
	[ 'MAIC',  'Aich/Nbay' ],
	[ 'MAI',   'Aichach' ],
	[ 'TAI',   'Aichstetten' ],
	[ 'XCAI',  'Aidyrlia' ],
	[ 'XSAL',  'Aigle' ],
	[ 'XFAB',  'Aigueblanche' ],
	[ 'XFAM',  'Aime-la-Plagne' ],
	[ 'MAIN',  'Ainring' ],
	[ 'MAIL',  'Aipl' ],
	[ 'XIAE',  'Airole' ],
	[ 'XSAI',  'Airolo' ],
	[ 'TAIB',  'Aischbach' ],
	[ 'MAIT',  'Aitrang' ],
	[ 'XFAX',  'Aix-en-Prov TGV' ],
	[ 'XFAI',  'Aix-les-Bains' ],
	[ 'XMAJ',  'Ajka' ],
	[ 'XMAG',  'Ajka-Gyartelep' ],
	[ 'LAK',   'Aken (Elbe)' ],
	[ 'XOA',   'Al' ],
	[ 'XIAL',  'Ala' ],
	[ 'XIAO',  'Alassio' ],
	[ 'XIALB', 'Alba' ],
	[ 'XIALA', 'Alba Adriatica' ],
	[ 'XUAI',  'Alba Iulia' ],
	[ 'XIAT',  'Albate Camerlata' ],
	[ 'RAL',   'Albbruck' ],
	[ 'XIAB',  'Albenga' ],
	[ 'AAL',   'Albersdorf' ],
	[ 'EABL',  'Albersloh' ],
	[ 'RAR',   'Albersweiler(Pf)' ],
	[ 'XFAL',  'Albertville' ],
	[ 'FAG',   'Albig' ],
	[ 'LALB',  'Albrechtshaus' ],
	[ 'FALS',  'Albshausen' ],
	[ 'RAM',   'Albsheim(Eis)' ],
	[ 'TAOM',  'Albst.-Onstmett.' ],
	[ 'TATA',  'Albst.-Tailfing.' ],
	[ 'TATR',  'Albst.-Truchtel.' ],
	[ 'TAE',   'Albstadt-Ebingen' ],
	[ 'TAL',   'Albstadt-Laufen' ],
	[ 'TAEW',  'Albst-Ebing West' ],
	[ 'TALO',  'Albst-Laufen Ort' ],
	[ 'TALT',  'Albst-Lautlingen' ],
	[ 'KALK',  'Aldekerk' ],
	[ 'TALD',  'Aldingen b Spai' ],
	[ 'ZUAL',  'Aleksandriia' ],
	[ 'XPAK',  'Aleksandrow Ku' ],
	[ 'XJA',   'Aleksinac' ],
	[ 'XOAN',  'Alen' ],
	[ 'XFALN', 'Alencon' ],
	[ 'XFALE', 'Ales' ],
	[ 'XUAE',  'Alesd' ],
	[ 'XIAS',  'Alessandria' ],
	[ 'MALH',  'Aletshausen' ],
	[ 'BALX',  'Alexanderplatz' ],
	[ 'XGAX',  'Alexandroupolis' ],
	[ 'LAX',   'Alexisbad' ],
	[ 'HALF',  'Alfeld (Leine)' ],
	[ 'HAHS',  'Alfhausen' ],
	[ 'KALF',  'Alfter' ],
	[ 'KALI',  'Alfter-Impekoven' ],
	[ 'HALG',  'Algermissen' ],
	[ 'XMAY',  'Algyö' ],
	[ 'XIAI',  'Ali Terme' ],
	[ 'XIABC', 'Alice Belcolle' ],
	[ 'HALI',  'Aligse' ],
	[ 'XVAS',  'Alingsas' ],
	[ 'NALI',  'Alitzheim' ],
	[ 'XDAK',  'Alken' ],
	[ 'XBAE',  'Alken BE' ],
	[ 'XNAL',  'Alkmaar' ],
	[ 'LSTG',  'Allee Center' ],
	[ 'FALD',  'Allendorf (Eder)' ],
	[ 'FADD',  'Allendorf/Dillkr' ],
	[ 'RAB',   'Allensbach' ],
	[ 'XAAH',  'Allerheiligenh' ],
	[ 'AALH',  'Allermöhe' ],
	[ 'AALM',  'Allermöhe' ],
	[ 'NALB',  'Allersb(Rothsee)' ],
	[ 'TALL',  'Allmendingen' ],
	[ 'RDOA',  'Allmendshofen' ],
	[ 'XMAL',  'Almasfüzitö' ],
	[ 'XNAO',  'Almelo' ],
	[ 'HARB',  'Almena-Rickbruch' ],
	[ 'XNAOO', 'Almere Oostvaard' ],
	[ 'XVAH',  'Almhult' ],
	[ 'HAL',   'Almstedt' ],
	[ 'XOAL',  'Alnabru' ],
	[ 'KALP',  'Alpen' ],
	[ 'KALA',  'Alpen Awanst' ],
	[ 'XNAR',  'Alphen a d Rijn' ],
	[ 'RALP',  'Alpirsbach' ],
	[ 'XQA',   'Alsancak' ],
	[ 'EGNP',  'Alsdorf (Sieg)' ],
	[ 'KADA',  'Alsdorf-Annapark' ],
	[ 'KADB',  'Alsdorf-Busch' ],
	[ 'KKEL',  'Alsdorf-Kellersb' ],
	[ 'KMAD',  'Alsdorf-Mariadf' ],
	[ 'KADP',  'Alsdorf-Poststr' ],
	[ 'AALS',  'Alsen' ],
	[ 'AALG',  'Alsen DB-Gr' ],
	[ 'SAZ',   'Alsenz' ],
	[ 'FAFD',  'Alsfeld/Oberhess' ],
	[ 'FAHM',  'Alsheim' ],
	[ 'XMAB',  'Alsobelatelep' ],
	[ 'XMAO',  'Alsogyenes' ],
	[ 'BAHZ',  'Alt Herzberg' ],
	[ 'WAHU',  'Alt Hüttendorf' ],
	[ 'KMKW',  'Alt Merkstein' ],
	[ 'BARF',  'Alt Reinickend' ],
	[ 'BARO',  'Alt Rosenthal' ],
	[ 'WAS',   'Alt Schwerin' ],
	[ 'XIALT', 'Altare' ],
	[ 'XCAL',  'Altata' ],
	[ 'TACH',  'Altbach' ],
	[ 'TACHF', 'Altbach F' ],
	[ 'BAD',   'Altdöbern' ],
	[ 'BADS',  'Altdöbern Süd' ],
	[ 'NAD',   'Altdorf (b Nür)' ],
	[ 'NADW',  'Altdorf West' ],
	[ 'AWHOS', 'Alte Süderelbe' ],
	[ 'NAVE',  'Alte Veste' ],
	[ 'AAW',   'Alte Wöhr' ],
	[ 'XFAT',  'Alteckendorf' ],
	[ 'WAF',   'Altefähr' ],
	[ 'EALN',  'Altena' ],
	[ 'KALT',  'Altenahr' ],
	[ 'MALT',  'Altenau (Bay)' ],
	[ 'XSAR',  'Altenb.-Rheinau' ],
	[ 'LALT',  'Altenbach' ],
	[ 'SAB',   'Altenbamberg' ],
	[ 'HAAT',  'Altenbek./Tunnel' ],
	[ 'HA',    'Altenbeken' ],
	[ 'HAAK',  'Altenbeken/Kurve' ],
	[ 'DAG',   'Altenberg (Erzg)' ],
	[ 'EABG',  'Altenberge' ],
	[ 'HATB',  'Altenboitzen' ],
	[ 'LA',    'Altenburg' ],
	[ 'LA W',  'Altenburg Pbf W1' ],
	[ 'XSAD',  'Altendorf' ],
	[ 'MANE',  'Altenerding' ],
	[ 'HALE',  'Altenesch' ],
	[ 'FATF',  'Altenfeld (Rhön)' ],
	[ 'SALG',  'Altenglan' ],
	[ 'AAT',   'Altengörs' ],
	[ 'LAGR',  'Altengrabow' ],
	[ 'NAG',   'Altengronau' ],
	[ 'LALH',  'Altenhain' ],
	[ 'FAHN',  'Altenhasungen' ],
	[ 'LANH',  'Altenhausen(Hdl)' ],
	[ 'HAHG',  'Altenhgn (Celle)' ],
	[ 'EA',    'Altenhundem' ],
	[ 'KAKG',  'Altenkirchen Gr' ],
	[ 'KAK',   'Altenkirchen(Ww)' ],
	[ 'XAAL',  'Altenmarkt i.P.' ],
	[ 'MATM',  'Altenmarkt/Alz' ],
	[ 'XSAF',  'Altenrhein Flugz' ],
	[ 'HALR',  'Altenrheine' ],
	[ 'HASK',  'Altensalzkoth' ],
	[ 'NAS',   'Altenschwand' ],
	[ 'EASE',  'Altenseelbach' ],
	[ 'NALW',  'Altenstadt (W)' ],
	[ 'FAST',  'Altenstadt/Hess' ],
	[ 'MASI',  'Altenstadt/Iller' ],
	[ 'FHTN',  'Altenst-Höchst' ],
	[ 'FLIN',  'Altenst-Lindheim' ],
	[ 'WATR',  'Altentreptow' ],
	[ 'AWHOO', 'Altenwerder Ost' ],
	[ 'WALW',  'Altenwillershgn' ],
	[ 'UACH',  'Altersbach' ],
	[ 'BJA',   'Altes Lager' ],
	[ 'EATF',  'Altfeld' ],
	[ 'RAT',   'Altglash-Falkau' ],
	[ 'BAGL',  'Altglienicke' ],
	[ 'MAHB',  'Althegnenberg' ],
	[ 'FAT',   'Altheim (Hess)' ],
	[ 'MATH',  'Altheim/Nbay' ],
	[ 'WAH',   'Althof' ],
	[ 'TAG',   'Altingen (Württ)' ],
	[ 'XSAH',  'Altishausen' ],
	[ 'MASN',  'Altmannstein' ],
	[ 'FKALR', 'Altmarkt/Regpräs' ],
	[ 'DAMD',  'Altmittweida' ],
	[ 'DAMG',  'Altmügeln' ],
	[ 'XSAT',  'Altnau' ],
	[ 'MAMT',  'Altomünster' ],
	[ 'AAS',   'Altona (S-Bahn)' ],
	[ 'DAOR',  'Altoschatz-Rosen' ],
	[ 'MAT',   'Altötting' ],
	[ 'BART',  'Altranft' ],
	[ 'WAR',   'Altruppin' ],
	[ 'TASF',  'Altschmiedelfeld' ],
	[ 'TAT',   'Altshausen' ],
	[ 'TATG',  'Altshsn DB/RöBSP' ],
	[ 'MATS',  'Altstädten/Allg' ],
	[ 'XSAS',  'Altstätten SG' ],
	[ 'TATN',  'Alttann' ],
	[ 'XVAA',  'Älvängen' ],
	[ 'XOAV',  'Alvdal' ],
	[ 'HAVD',  'Alverdissen' ],
	[ 'AAV',   'Alvesloe' ],
	[ 'XVAL',  'Alvesta' ],
	[ 'FAZB',  'Alzenau Burg' ],
	[ 'FAZUN', 'Alzenau Nord' ],
	[ 'FAZU',  'Alzenau(Unterfr)' ],
	[ 'FALZ',  'Alzey' ],
	[ 'FAZG',  'Alzey DB-Grenze' ],
	[ 'FAZS',  'Alzey Süd' ],
	[ 'XLAL',  'Alzingen' ],
	[ 'FKBHA', 'Am Kupferhammer' ],
	[ 'EAOH',  'Am Obsthof' ],
	[ 'FKASA', 'Am Stern v Altm' ],
	[ 'FKASK', 'Am Stern v Köpl' ],
	[ 'FKASL', 'Am Stern v Lupl' ],
	[ 'FKNZW', 'Am Weinberg' ],
	[ 'XVAM',  'Amal' ],
	[ 'NAM',   'Amberg' ],
	[ 'NAMD',  'Amberg Dorfner' ],
	[ 'NAKW',  'Amberg Kaolin 1' ],
	[ 'NLAH',  'Amberg Lagerh Sb' ],
	[ 'NSTL',  'Amberg Stöllger' ],
	[ 'XFAE',  'Amberieu' ],
	[ 'HALS',  'Amelingh Sottorf' ],
	[ 'MAMG',  'Amerang' ],
	[ 'XNAMV', 'Amersf Vathorst' ],
	[ 'XNAM',  'Amersfoort' ],
	[ 'LAMH',  'Ammelshain' ],
	[ 'UAMM',  'Ammern' ],
	[ 'NAMB',  'Amorbach' ],
	[ 'MAPF',  'Ampfing' ],
	[ 'LAMS',  'Amsdorf' ],
	[ 'XNAS',  'Amst Sloterdijk' ],
	[ 'XNAV',  'Amstd Westhaven' ],
	[ 'XNAB',  'Amsterd Bijlmer' ],
	[ 'XNAHP', 'Amsterd Houtrakp' ],
	[ 'XNAC',  'Amsterdam C' ],
	[ 'XNAW',  'Amsterdam WGM' ],
	[ 'XNAWZ', 'Amsterdam WZ' ],
	[ 'XNAZ',  'Amsterdam Zuid' ],
	[ 'XNAA',  'Amsterdam-Amstel' ],
	[ 'XAAS',  'Amstetten' ],
	[ 'TAM S', 'Amstetten SM' ],
	[ 'TAM',   'Amstetten(Württ)' ],
	[ 'DAMH',  'Amtshainersdf' ],
	[ 'XIANI', 'Anagni' ],
	[ 'AAMP',  'Anckelmannsplatz' ],
	[ 'XIA',   'Ancona' ],
	[ 'XOAD',  'Andalsnes' ],
	[ 'XSANF', 'Andelfingen' ],
	[ 'XSAN',  'Andermatt' ],
	[ 'KAND',  'Andernach' ],
	[ 'XAAD',  'Andorf' ],
	[ 'XRAJ',  'Andrijevci' ],
	[ 'XVAY',  'Aneby' ],
	[ 'XOAB',  'Aneby NO' ],
	[ 'XVAG',  'Äng' ],
	[ 'XVA',   'Angelholm' ],
	[ 'LACF',  'Anger-Crottendf' ],
	[ 'WA',    'Angermünde' ],
	[ 'KANM',  'Angermund' ],
	[ 'LANG',  'Angern-Rogätz' ],
	[ 'FANG',  'Angersbach' ],
	[ 'LAG',   'Angersdorf' ],
	[ 'LAG O', 'Angersdorf Awo' ],
	[ 'XAAG',  'Angertal' ],
	[ 'MAGB',  'Anglberg' ],
	[ 'XBAL',  'Angleur' ],
	[ 'XFANG', 'Angouleme' ],
	[ 'WAK',   'Anklam' ],
	[ 'HANK',  'Ankum' ],
	[ 'DABM',  'Annab-Buch Mi' ],
	[ 'DAB',   'Annab-Buchh Süd' ],
	[ 'DABU',  'Annab-Buchh unt' ],
	[ 'XVAN',  'Annaberg' ],
	[ 'LAB',   'Annaburg' ],
	[ 'KDNS',  'Annakirmesplatz' ],
	[ 'EANN',  'Anneliese' ],
	[ 'HAHD',  'Annenheide' ],
	[ 'RAN',   'Annweiler a Tri' ],
	[ 'KANR',  'Anrath' ],
	[ 'EART',  'Anröchte' ],
	[ 'XBANS', 'Ans' ],
	[ 'NAN',   'Ansbach' ],
	[ 'NANS',  'Ansbach Stadt' ],
	[ 'XEAS',  'Antequera-S A' ],
	[ 'XFAN',  'Antibes' ],
	[ 'DATL',  'Antonsthal' ],
	[ 'XBAWC', 'Antw Cirkeldijk' ],
	[ 'XBAWA', 'Antw DS Angola' ],
	[ 'XBAM',  'Antw Main Hub' ],
	[ 'XBAWB', 'Antw-DS Berendr' ],
	[ 'XBAWZ', 'Antw-DS Zandvl' ],
	[ 'XBAKB', 'Antwerp DS BASF' ],
	[ 'XBAWO', 'Antwerp-DS Oord' ],
	[ 'XBAW',  'Antwerpen DS' ],
	[ 'XBAC',  'Antwerpen-Centr' ],
	[ 'XBAD',  'Antwerpen-Dam' ],
	[ 'XBAK',  'Antwerpen-Kiel' ],
	[ 'XBAN',  'Antwerpen-Noord' ],
	[ 'XBAZ',  'Antwerpen-Zuid' ],
	[ 'XBAS',  'Antwerp-Schijnp' ],
	[ 'XBAAN', 'Antw-Waaslhvn No' ],
	[ 'XBAA',  'Antw-Waaslhvn Zu' ],
	[ 'NAWN',  'Anwanden' ],
	[ 'FAZ',   'Anzefahr' ],
	[ 'MAK',   'Anzenkirchen' ],
	[ 'XFAP',  'Apach' ],
	[ 'XMAF',  'Apafa' ],
	[ 'XNAE',  'Apeldoorn' ],
	[ 'AAPL',  'Apeler' ],
	[ 'AAPS',  'Apensen' ],
	[ 'UAP',   'Apolda' ],
	[ 'RAP',   'Appenweier' ],
	[ 'RAPP',  'Appenweier Hp' ],
	[ 'RAPK',  'Appenweier Kurve' ],
	[ 'RAPR',  'Appenweier Nord' ],
	[ 'XNAP',  'Appingedam' ],
	[ 'XUA',   'Arad' ],
	[ 'XUAN',  'Aradu Nou' ],
	[ 'XCAM',  'Aramil' ],
	[ 'XSAB',  'Arbon' ],
	[ 'XSABS', 'Arbon S' ],
	[ 'XEAF',  'Archena-Fortuna' ],
	[ 'XFAA',  'Arcis-sur-Aube' ],
	[ 'EARE',  'Ardey' ],
	[ 'XIAR',  'Arena Po' ],
	[ 'LAS',   'Arendsee (Altm)' ],
	[ 'LAF',   'Arensdorf' ],
	[ 'UAR',   'Arenshausen' ],
	[ 'UQAR',  'Arenshausen 6343' ],
	[ 'XIAZ',  'Arezzo' ],
	[ 'FAF',   'Arfurt (Lahn)' ],
	[ 'XFAR',  'Argeles sur Mer' ],
	[ 'BARK',  'Arkenberge' ],
	[ 'ZIA',   'Arklow' ],
	[ 'XFARL', 'Arles' ],
	[ 'KARL',  'Arloff' ],
	[ 'XBAR',  'Arlon' ],
	[ 'HARS',  'Armsen' ],
	[ 'FARM',  'Armsheim' ],
	[ 'XOAR',  'Arna' ],
	[ 'MANB',  'Arnbach' ],
	[ 'XDAB',  'Arnbjerg' ],
	[ 'TAR',   'Arnegg' ],
	[ 'XOAE',  'Arnes' ],
	[ 'XNAH',  'Arnhem' ],
	[ 'XNAHG', 'Arnhem GS' ],
	[ 'XAAR',  'Arnoldstein' ],
	[ 'EARB',  'Arnsberg' ],
	[ 'EARS',  'Arnsberg Süd' ],
	[ 'EARJ',  'Arnsbg Jägerbr' ],
	[ 'NARG',  'Arnschwang' ],
	[ 'DAF',   'Arnsdorf (b Dre)' ],
	[ 'DAF N', 'Arnsdorf Nord' ],
	[ 'DAF W', 'Arnsdorf West' ],
	[ 'UA',    'Arnstadt Hbf' ],
	[ 'UASD',  'Arnstadt Süd' ],
	[ 'NARN',  'Arnstein (Ufr)' ],
	[ 'XIAN',  'Arona' ],
	[ 'XSAO',  'Arosa' ],
	[ 'XIAQ',  'Arquata Scrivia' ],
	[ 'NARR',  'Arrach' ],
	[ 'XFAS',  'Arras' ],
	[ 'KARS',  'Arsbeck' ],
	[ 'XFAY',  'Artenay' ],
	[ 'UAT',   'Artern' ],
	[ 'UATG',  'Artern DB-Gr' ],
	[ 'XSAG',  'Arth-Goldau' ],
	[ 'XFARV', 'Arvant' ],
	[ 'XCAZ',  'Arzamas 2' ],
	[ 'NAZ',   'Arzberg (Oberfr)' ],
	[ 'XFARZ', 'Arzviller' ],
	[ 'XTAS',  'As' ],
	[ 'XOAS',  'As NO' ],
	[ 'NAH A', 'Aschaff Hbf Ausf' ],
	[ 'NAH E', 'Aschaff Hbf Einf' ],
	[ 'NAH',   'Aschaffenbg Hbf' ],
	[ 'NAHA',  'Aschaffenbg Hfn' ],
	[ 'NASU',  'Aschaffenbg Süd' ],
	[ 'NANI',  'Aschaff-Nilkheim' ],
	[ 'MASC',  'Aschau/Chiemgau' ],
	[ 'NAH G', 'Aschbg - Goldb' ],
	[ 'EASB',  'Ascheberg' ],
	[ 'AAG',   'Ascheberg/Holst' ],
	[ 'HASD',  'Aschendorf' ],
	[ 'LAL',   'Aschersleben' ],
	[ 'MASL',  'Asch-Leeder' ],
	[ 'AASN',  'Ashausen' ],
	[ 'AASA',  'Ashausen Abzw' ],
	[ 'XKA',   'Ashford' ],
	[ 'XKAI',  'Ashford Int' ],
	[ 'XOAK',  'Asker' ],
	[ 'XIASO', 'Asola' ],
	[ 'XVAD',  'Aspedalen' ],
	[ 'XVAP',  'Aspen' ],
	[ 'TAX',   'Asperg' ],
	[ 'XVAB',  'Assberg' ],
	[ 'XBASS', 'Asse' ],
	[ 'RASH',  'Asselheim' ],
	[ 'FAS',   'Assenheim/Oberh' ],
	[ 'XIASI', 'Assisi' ],
	[ 'FAL',   'Aßlar' ],
	[ 'MAG',   'Aßling/Obb' ],
	[ 'FAH',   'Assmannshausen' ],
	[ 'ZKAK',  'Astana' ],
	[ 'XBA',   'Astene' ],
	[ 'XAAF',  'Asten-St Florian' ],
	[ 'XIAST', 'Asti' ],
	[ 'XMAD',  'Aszod' ],
	[ 'XMAZ',  'Aszofö' ],
	[ 'XCAR',  'Atbassar' ],
	[ 'XGA',   'Athenes' ],
	[ 'XCAT',  'Atkarsk' ],
	[ 'XOAT',  'Atna' ],
	[ 'EAT',   'Attendorn' ],
	[ 'BATS',  'Attilastraße' ],
	[ 'XAAT',  'Attnang-Puchheim' ],
	[ 'XVAT',  'Atvidaberg' ],
	[ 'MAAU',  'Au (Illertissen)' ],
	[ 'KAU',   'Au (Sieg)' ],
	[ 'KQAU',  'Au (Sieg) NRW/RP' ],
	[ 'RWSA',  'Au im Murgtal' ],
	[ 'XSAU',  'Au SG' ],
	[ 'XSAZ',  'Au ZH' ],
	[ 'TBFA',  'Audi' ],
	[ 'XOAU',  'Audnedal' ],
	[ 'XLAT',  'Audun-le-Tiche' ],
	[ 'DAU',   'Aue (Sachs)' ],
	[ 'DAUS',  'Aue E-Stadion' ],
	[ 'UAE',   'Auehütte' ],
	[ 'DAUO',  'Auerb (V) ob Bf' ],
	[ 'DAUU',  'Auerb (V) unt Bf' ],
	[ 'DAUW',  'Auerb (V) West' ],
	[ 'DAUH',  'Auerbach (Vogtl)' ],
	[ 'RACH',  'Auerbach/Mosb B' ],
	[ 'SAM',   'Auersmacher' ],
	[ 'UAS',   'Auerstedt' ],
	[ 'FKNZA', 'Auestadion' ],
	[ 'EAWN',  'Aue-Wingeshausen' ],
	[ 'RDOF',  'Aufen' ],
	[ 'MAFE',  'Aufhausen' ],
	[ 'TAUF',  'Aufhausen(Württ)' ],
	[ 'RAUG',  'Auggen' ],
	[ 'NAUG',  'Augrabenbrücke' ],
	[ 'MAHA',  'Augsb Haunst str' ],
	[ 'MA B',  'Augsb Hbf/Bbf S' ],
	[ 'MAHI',  'Augsb Hirbl Str' ],
	[ 'MAMS',  'Augsb Morellstr' ],
	[ 'MA M',  'Augsb Rbf Mitte' ],
	[ 'MA N',  'Augsb Rbf Nord' ],
	[ 'MAHZF', 'Augsb-Hochz Abzw' ],
	[ 'MAHZH', 'Augsb-Hochz Hp' ],
	[ 'MAHZ',  'Augsb-Hochzoll' ],
	[ 'MAOB',  'Augsb-Oberhausen' ],
	[ 'MA',    'Augsburg Hbf' ],
	[ 'MAGM',  'Augsburg Messe' ],
	[ 'MA S',  'Augsburg Rbf Süd' ],
	[ 'MAR',   'Augsburg Ring' ],
	[ 'MAW',   'Augsburg West' ],
	[ 'KMK',   'Aug-Schmidt-Pl' ],
	[ 'HAUG',  'Augustfehn' ],
	[ 'MAUH',  'Auhausen' ],
	[ 'AAU',   'Aukrug' ],
	[ 'TAU',   'Aulendorf' ],
	[ 'XFAU',  'Aulnoye' ],
	[ 'XOAM',  'Auma NO' ],
	[ 'XFAUM', 'Aumale' ],
	[ 'FAUM',  'Aumenau' ],
	[ 'AAH',   'Aumühle' ],
	[ 'AAH A', 'Aumühle Bft+Abzw' ],
	[ 'XFAUN', 'Auneau' ],
	[ 'FAM',   'Auringen-Medenb' ],
	[ 'NAUR',  'Außenried' ],
	[ 'EAU',   'Autobahn' ],
	[ 'XBAU',  'auvelais' ],
	[ 'SAUW',  'Auw an der Kyll' ],
	[ 'XIAV',  'Aversa' ],
	[ 'XFAVN', 'Avesnes' ],
	[ 'XVAV',  'Avesta-Krylbo' ],
	[ 'XFAV',  'Avignon Centre' ],
	[ 'XFAVS', 'Avignon Sud' ],
	[ 'XFAVC', 'Avignon-Fontcouv' ],
	[ 'XFAVV', 'Avignon-TGV' ],
	[ 'EPDW',  'AW Paderborn' ],
	[ 'MAY',   'Aying' ],
	[ 'XKAF',  'Aylesford' ],
	[ 'DAZ',   'Az' ],
	[ 'XUAZ',  'Azuga' ],
	[ 'MBAK',  'B Aibl Kurpark' ],
	[ 'WDOG',  'B Doberan Goethe' ],
	[ 'WDOS',  'B Doberan Stadtm' ],
	[ 'NXBE',  'B Eisenst Grenze' ],
	[ 'AMAG',  'B Malente-Gremsm' ],
	[ 'BPFG',  'B Saarow-Pies Gr' ],
	[ 'ASCA',  'B Schwart Abzw' ],
	[ 'TBSB',  'B Sebastw-Belsen' ],
	[ 'TUCW',  'B Urach Wasserf' ],
	[ 'WBA',   'Baabe' ],
	[ 'KBA',   'Baal' ],
	[ 'KBAG',  'Baal Gbf' ],
	[ 'LBB',   'Baalberge' ],
	[ 'MBAE',  'Baar-Ebenhausen' ],
	[ 'BBAB',  'Babelsberg' ],
	[ 'FBA',   'Babenhausen' ],
	[ 'FQBA',  'Babenhausen LGr' ],
	[ 'RBST',  'Babstadt' ],
	[ 'XTBY',  'Babylon' ],
	[ 'XSBAE', 'Bäch' ],
	[ 'FBCH',  'Bacharach' ],
	[ 'MBCN',  'Bachern' ],
	[ 'UB',    'Bachfeld' ],
	[ 'RBH',   'Bachheim' ],
	[ 'TB',    'Backnang' ],
	[ 'NBAB',  'Bad Abbach' ],
	[ 'MBAI',  'Bad Aibling' ],
	[ 'FAR',   'Bad Arolsen' ],
	[ 'XABA',  'Bad Aussee' ],
	[ 'HBED',  'Bad Bederkesa' ],
	[ 'RBEL',  'Bad Bellingen' ],
	[ 'BBIG',  'Bad Belzig' ],
	[ 'HBTH',  'Bad Bentheim' ],
	[ 'HXB',   'Bad Bentheim Gr' ],
	[ 'HBTN',  'Bad Bentheim Nrd' ],
	[ 'RBZB',  'Bad Bergzabern' ],
	[ 'UBB',   'Bad Berka' ],
	[ 'UBBZ',  'Bad Berka Zeugh' ],
	[ 'EBLB',  'Bad Berleburg' ],
	[ 'ABVS',  'Bad Bevensen' ],
	[ 'MBIB',  'Bad Birnbach' ],
	[ 'UBL',   'Bad Blankenburg' ],
	[ 'XABB',  'Bad Blumau' ],
	[ 'KBOD',  'Bad Bodendorf' ],
	[ 'DXBB',  'Bad Bramb Gr 2' ],
	[ 'DXBC',  'Bad Bramb Gr 3' ],
	[ 'DBM',   'Bad Brambach' ],
	[ 'DXB',   'Bad Brambach Gr' ],
	[ 'ABSK',  'Bad Bramst Kurh' ],
	[ 'ABSD',  'Bad Bramstedt' ],
	[ 'KBRE',  'Bad Breisig' ],
	[ 'FCA',   'Bad Camberg' ],
	[ 'WDO',   'Bad Doberan' ],
	[ 'HBDG',  'Bad Driburg' ],
	[ 'LDU',   'Bad Düben(Mulde)' ],
	[ 'RBDK',  'Bad Dürkh. (RHB)' ],
	[ 'RBDO',  'Bad Dürkh. Ost' ],
	[ 'RBDH',  'Bad Dürkheim' ],
	[ 'RBDT',  'Bad Dürkhm-Trift' ],
	[ 'LDBG',  'Bad Dürrenberg' ],
	[ 'HBEI',  'Bad Eilsen' ],
	[ 'DBEL',  'Bad Elster' ],
	[ 'MBEP',  'Bad Empfing' ],
	[ 'MAKR',  'Bad Empfing Kr' ],
	[ 'FEMS',  'Bad Ems' ],
	[ 'FEMW',  'Bad Ems West' ],
	[ 'MBEF',  'Bad Endorf (Obb)' ],
	[ 'HENE',  'Bad Essen' ],
	[ 'HFAL',  'Bad Fallingb' ],
	[ 'WFW',   'Bad Freienw (O)' ],
	[ 'TBF',   'Bad Fr-Jagstfeld' ],
	[ 'HGMGA', 'Bad Gandersh Abz' ],
	[ 'HGMG',  'Bad Gandersh Gbf' ],
	[ 'HBGM',  'Bad Gandersheim' ],
	[ 'XABG',  'Bad Gastein' ],
	[ 'RBGR',  'Bad Griesbach' ],
	[ 'MGNB',  'Bad Grönenbach' ],
	[ 'HBHA',  'Bad Harzburg' ],
	[ 'RHLB',  'Bad Herrenalb' ],
	[ 'FBHF',  'Bad Hersfeld' ],
	[ 'XABH',  'Bad Hofgastein' ],
	[ 'MBHT',  'Bad Höhenstadt' ],
	[ 'FHO',   'Bad Homburg' ],
	[ 'KHBD',  'Bad Honnef (Rh)' ],
	[ 'KQHB',  'Bad Honnef LGr' ],
	[ 'KHGB',  'Bad Hönningen' ],
	[ 'HIBG',  'Bad Iburg' ],
	[ 'TIMN',  'Bad Imnau' ],
	[ 'XAIS',  'Bad Ischl' ],
	[ 'HKRF',  'Bad Karlshafen' ],
	[ 'HQKR',  'Bad Karlshf LGr' ],
	[ 'NBKI',  'Bad Kissingen' ],
	[ 'WK',    'Bad Kleinen' ],
	[ 'MBKG',  'Bad Kohlgrub' ],
	[ 'MBKK',  'Bad Kohlgrub Kur' ],
	[ 'FKI',   'Bad König' ],
	[ 'FZK',   'Bad König-Zell' ],
	[ 'UKO',   'Bad Kösen' ],
	[ 'UBKZ',  'Bad Köstritz' ],
	[ 'NKZ',   'Bad Kötzting' ],
	[ 'XABKR', 'Bad Kreckelmoos' ],
	[ 'SBKNG', 'Bad Kreuzn Gbf' ],
	[ 'SBKN',  'Bad Kreuznach' ],
	[ 'RBKR',  'Bad Krozingen' ],
	[ 'RBKO',  'Bad Krozingen O.' ],
	[ 'ELSP',  'Bad Laasphe' ],
	[ 'EQLS',  'Bad Laasphe LGr' ],
	[ 'HLAR',  'Bad Laer' ],
	[ 'ULS',   'Bad Langensalza' ],
	[ 'LLAW',  'Bad Lauchst West' ],
	[ 'LLAU',  'Bad Lauchstädt' ],
	[ 'LBLS',  'Bad Lausick' ],
	[ 'BBLW',  'Bad Liebenwerda' ],
	[ 'TBLI',  'Bad Liebenzell' ],
	[ 'TBMR',  'Bad Mergentheim' ],
	[ 'HMDD',  'Bad Münder/Deis' ],
	[ 'SBMS',  'Bad Münster a St' ],
	[ 'KMUE',  'Bad Münstereifel' ],
	[ 'FBNA',  'Bad Nauheim' ],
	[ 'FBNN',  'Bad Nauheim Nord' ],
	[ 'HNDF',  'Bad Nenndorf' ],
	[ 'KNEB',  'Bad Neuenahr' ],
	[ 'NBNE',  'Bad Neust/Saale' ],
	[ 'TBN',   'Bad Niedernau' ],
	[ 'HOY',   'Bad Oeynhausen' ],
	[ 'HOYG',  'Bad Oeynhsn Gbf' ],
	[ 'HBOE',  'Bad Oeynhsn Süd' ],
	[ 'AO',    'Bad Oldesloe' ],
	[ 'RBPL',  'Bad Peterstal' ],
	[ 'HPRT',  'Bad Pyrmont' ],
	[ 'HQPR',  'Bad Pyrmont LGr' ],
	[ 'XSRA',  'Bad Ragaz' ],
	[ 'RBPK',  'Bad Rapp Kurpark' ],
	[ 'RBRA',  'Bad Rappenau' ],
	[ 'MBRL',  'Bad Reichenhall' ],
	[ 'MBRK',  'Bad Reichenh-Kir' ],
	[ 'NRC',   'Bad Rodach' ],
	[ 'RRO',   'Bad Rotenfels' ],
	[ 'RROG',  'Bad Rotenfels S' ],
	[ 'RROW',  'Bad Rotenfels W' ],
	[ 'BBSK',  'Bad Saarow Kl' ],
	[ 'BBSP',  'Bad Saarow-Piesk' ],
	[ 'HSCH',  'Bad Sachsa' ],
	[ 'RSAE',  'Bad Säckingen' ],
	[ 'HBSA',  'Bad Salzdetfurth' ],
	[ 'FBSH',  'Bad Salzhausen' ],
	[ 'FSF',   'Bad Salzschlirf' ],
	[ 'EBSU',  'Bad Salzuflen' ],
	[ 'USZ',   'Bad Salzungen' ],
	[ 'EBSA',  'Bad Sassendorf' ],
	[ 'XASBW', 'Bad Schall-Wall' ],
	[ 'DSA',   'Bad Schandau' ],
	[ 'DXS',   'Bad Schandau Gr' ],
	[ 'DSO',   'Bad Schandau Ost' ],
	[ 'DSUB',  'Bad Schlema' ],
	[ 'LBSB',  'Bad Schmiedeberg' ],
	[ 'RBS',   'Bad Schönborn S' ],
	[ 'RBSK',  'Bad Schönborn-Kr' ],
	[ 'TBSC',  'Bad Schussenried' ],
	[ 'ASCH',  'Bad Schwartau' ],
	[ 'ASB',   'Bad Segeberg' ],
	[ 'SSOB',  'Bad Sobernheim' ],
	[ 'FBSO',  'Bad Soden (Ts)' ],
	[ 'FBSS',  'Bad Soden-Salm' ],
	[ 'FBSD',  'Bad Sooden-Alldf' ],
	[ 'BBSS',  'Bad S-Piesk Süd' ],
	[ 'APSD',  'Bad St Peter Süd' ],
	[ 'NSFN',  'Bad Staffelstein' ],
	[ 'NBST',  'Bad Steben' ],
	[ 'UBS',   'Bad Sulza' ],
	[ 'UBSN',  'Bad Sulza Nord' ],
	[ 'TBT',   'Bad Teinach/Neub' ],
	[ 'MBT',   'Bad Tölz' ],
	[ 'TUC',   'Bad Urach' ],
	[ 'TUCK',  'Bad Urach Klinik' ],
	[ 'XAVN',  'Bad Vigaun' ],
	[ 'FVL',   'Bad Vilbel' ],
	[ 'FVLS',  'Bad Vilbel Süd' ],
	[ 'FGRN',  'Bad Vilb-Gronau' ],
	[ 'TBWA',  'Bad Waldsee' ],
	[ 'TWB',   'Bad Wildbad' ],
	[ 'TWBN',  'Bad Wildbad Nord' ],
	[ 'FBWD',  'Bad Wildungen' ],
	[ 'WWIL',  'Bad Wilsnack' ],
	[ 'RBWF',  'Bad Wimpfen' ],
	[ 'TBWT',  'Bad Wimpfen Tal' ],
	[ 'RBWH',  'Bad Wimpfen-Hoh' ],
	[ 'NGTR',  'Bad Windsh Getr' ],
	[ 'NBWI',  'Bad Windsheim' ],
	[ 'MBWH',  'Bad Wörishofen' ],
	[ 'TBW',   'Bad Wurzach' ],
	[ 'XSZZ',  'Bad Zurzach' ],
	[ 'HZWI',  'Bad Zwischenahn' ],
	[ 'XMBY',  'Badacsony' ],
	[ 'XMBYH', 'Badacsonylabdih' ],
	[ 'XMBYO', 'Badacsonyörs' ],
	[ 'XMBYJ', 'Badacsonytomaj' ],
	[ 'XMBYS', 'Badacstörd-Sz' ],
	[ 'HBAD',  'Baddeckenstedt' ],
	[ 'XSBA',  'Baden CH' ],
	[ 'HBDV',  'Baden /Kr Verden' ],
	[ 'RBB',   'Baden-Baden' ],
	[ 'KBAD',  'Badorf' ],
	[ 'KBRK',  'Baerl Kreisb' ],
	[ 'BBG',   'Bagenz' ],
	[ 'RBAL',  'Bahlingen a K' ],
	[ 'RBAR',  'Bahlingen Riedl' ],
	[ 'RBBR',  'Bahnbrücken' ],
	[ 'BBO',   'Bahnsdorf' ],
	[ 'ABAF',  'Bahrenf (S-Bahn)' ],
	[ 'ABAH',  'Bahrenfeld Abzw' ],
	[ 'TBAG',  'Baienfurt' ],
	[ 'MBAB',  'Baierbrunn' ],
	[ 'RBSS',  'Baiersbr Schule' ],
	[ 'RBSN',  'Baiersbronn' ],
	[ 'NBD',   'Baiersdorf' ],
	[ 'XUBH',  'Baile Herculane' ],
	[ 'XUBT',  'Baile Tusnad' ],
	[ 'XFBX',  'Baisieux' ],
	[ 'BBAI',  'Baitz' ],
	[ 'XCBP',  'Balashov-Pass' ],
	[ 'XMBG',  'Balassagyarmat' ],
	[ 'XMBKD', 'Balatonakali-Dör' ],
	[ 'XMBAY', 'Balatonakarattya' ],
	[ 'XMBAA', 'Balatonaliga' ],
	[ 'XMBAM', 'Balatonalmadi' ],
	[ 'XMBB',  'Balatonbereny' ],
	[ 'XMBBR', 'Balatonboglar' ],
	[ 'XMBED', 'Balatonederics' ],
	[ 'XMBFA', 'Balatonfenyves a' ],
	[ 'XMBFV', 'Balatonföldvar' ],
	[ 'XMBFD', 'Balatonfüred' ],
	[ 'XMBGY', 'Balatongyörök' ],
	[ 'XMBKE', 'Balatonkenese' ],
	[ 'XMBLE', 'Balatonlelle' ],
	[ 'XMBLF', 'Balatonlelle f' ],
	[ 'XMBM',  'Balatonmariafürd' ],
	[ 'XMBRS', 'Balatonrendes' ],
	[ 'XMBSO', 'Balatonszarszo' ],
	[ 'XMBSS', 'Balatonszemes' ],
	[ 'XMBSZ', 'Balatonszepezd' ],
	[ 'XMBZA', 'Balatonszeplak a' ],
	[ 'XMBZF', 'Balatonszeplak f' ],
	[ 'XMBUV', 'Balatonudvari' ],
	[ 'XMBV',  'Balatonvilagos' ],
	[ 'NBAF',  'Balbersdorf' ],
	[ 'MBDH',  'Baldham' ],
	[ 'XIBH',  'Baldichieri-T' ],
	[ 'FBAD',  'Balduinstein' ],
	[ 'XSBAL', 'Balerna' ],
	[ 'XCBL',  'Balezino' ],
	[ 'TBLH',  'Balgheim' ],
	[ 'UBGS',  'Balgstädt' ],
	[ 'FBAH',  'Balhorn' ],
	[ 'TBG',   'Balingen (Württ)' ],
	[ 'TBGH',  'Balingen DB/HZL' ],
	[ 'TBGS',  'Balingen Süd' ],
	[ 'UBAS',  'Ballstädt Kr Go' ],
	[ 'ZIBB',  'Ballybrophy' ],
	[ 'XUBO',  'Balota' ],
	[ 'XUBA',  'Bals' ],
	[ 'SBAL',  'Baltersweiler' ],
	[ 'XCB',   'Baltiisk' ],
	[ 'EBAV',  'Balve' ],
	[ 'XIBLZ', 'Balzola' ],
	[ 'NBA',   'Bamberg' ],
	[ 'LBM',   'Bamme' ],
	[ 'RBAM',  'Bammental' ],
	[ 'ZBBL',  'Banja Luka' ],
	[ 'XVBY',  'Bankeryd' ],
	[ 'FBAN',  'Bannberschd-St' ],
	[ 'WBAM',  'Bannemin-Mölsch' ],
	[ 'XRBJ',  'Banova Jaruga' ],
	[ 'WBN',   'Bansin Seebad' ],
	[ 'HBAN',  'Banteln' ],
	[ 'HBTF',  'Bantorf' ],
	[ 'XFBH',  'Bantzenheim' ],
	[ 'XFBAY', 'Banyuls sur Mer' ],
	[ 'XJBA',  'Bar' ],
	[ 'XCBB',  'Barabinsk' ],
	[ 'XIBRU', 'Baragiano Ruoti' ],
	[ 'XMBAD', 'Barand' ],
	[ 'ZWBA',  'Baranovichi-C' ],
	[ 'ZWBP',  'Baranovichi-P' ],
	[ 'RBRT',  'Barbelroth' ],
	[ 'XUBI',  'Barbosi' ],
	[ 'LBY',   'Barby' ],
	[ 'XEB',   'Barcelona Centr' ],
	[ 'XEBS',  'Barcelona-S Andr' ],
	[ 'XEBT',  'Barcelona-T.' ],
	[ 'ABCL',  'Barchel' ],
	[ 'ABAD',  'Bardowick' ],
	[ 'ABAW',  'Bardowick Hp' ],
	[ 'HBAG',  'Barenburg' ],
	[ 'XNBA',  'Barendrecht' ],
	[ 'DBJ',   'Bärenh-Johns' ],
	[ 'BBKL',  'Bärenklau' ],
	[ 'DBS',   'Bärenstein (Abg)' ],
	[ 'DBAG',  'Bärenstein (bGl)' ],
	[ 'DXBA',  'Bärenstein Gr' ],
	[ 'ABAT',  'Bargstedt' ],
	[ 'ABAE',  'Bargteheide' ],
	[ 'BBAE',  'Bärhaus' ],
	[ 'XIBA',  'Bari C' ],
	[ 'XIBAP', 'Bari P.M.' ],
	[ 'XIBPS', 'Bari Parco Sud' ],
	[ 'XKB',   'Barking' ],
	[ 'XKBR',  'Barking Ripple L' ],
	[ 'XKBS',  'Barkingstora' ],
	[ 'LBAR',  'Barleben' ],
	[ 'LBAS',  'Barleber See' ],
	[ 'XFBD',  'Bar-le-Duc' ],
	[ 'XIBL',  'Barletta' ],
	[ 'ABMB',  'Barm Brunnenstr' ],
	[ 'ABAP',  'Barmbek (S-Bahn)' ],
	[ 'ABMS',  'Barmstedt' ],
	[ 'HBNF',  'Barnstorf (Han)' ],
	[ 'HBNT',  'Barnten' ],
	[ 'HBTE',  'Barntrup (Exter)' ],
	[ 'HQBT',  'Barntrup NRW/NI' ],
	[ 'HBAR',  'Barrien' ],
	[ 'HBGH',  'Barsinghausen' ],
	[ 'FMBB',  'Bartenwetzbrücke' ],
	[ 'WBH',   'Barth' ],
	[ 'DBAM',  'Barthmühle' ],
	[ 'HBMA',  'Bartmannsholte' ],
	[ 'BBA',   'Baruth (Mark)' ],
	[ 'HBAV',  'Barver' ],
	[ 'XLBA',  'Bascharange-San' ],
	[ 'ABAA',  'Basdahl' ],
	[ 'ABAAK', 'Basdahl-Kluste' ],
	[ 'BBAS',  'Basdorf' ],
	[ 'RB',    'Basel Bad Bf' ],
	[ 'RQB',   'Basel Bad Bf LGr' ],
	[ 'RQBA',  'Basel Bad R 4405' ],
	[ 'RBA',   'Basel Bad Rbf' ],
	[ 'RBA A', 'Basel Bad Rbf A' ],
	[ 'RBA C', 'Basel Bad Rbf C' ],
	[ 'RXBH',  'Basel Gr/Kl Hün' ],
	[ 'RXBR',  'Basel Gr/Muttenz' ],
	[ 'RXBA',  'Basel Grenze' ],
	[ 'RBA G', 'Basel Rbf -Gr L-' ],
	[ 'XSB',   'Basel SBB' ],
	[ 'XSBO',  'Basel SBB Cargo' ],
	[ 'XSBP',  'Basel SBB Dreisp' ],
	[ 'XSBR',  'Basel SBB Rb' ],
	[ 'XSBJH', 'Basel St Joh Hf' ],
	[ 'XSBJ',  'Basel St Johann' ],
	[ 'RBAS',  'Bashaide' ],
	[ 'XSBK',  'Bas-Kleinhüng Hf' ],
	[ 'HBA',   'Bassel' ],
	[ 'XSBD',  'Bassersdorf' ],
	[ 'HBAS',  'Bassum' ],
	[ 'XVBA',  'Bastad' ],
	[ 'XVBAH', 'Basthagen' ],
	[ 'XMBTK', 'Bataszek' ],
	[ 'XMBT',  'Bate' ],
	[ 'XCBA',  'Bateckaia' ],
	[ 'ZUBT',  'Batevo' ],
	[ 'FBTV',  'Battbg Viessmann' ],
	[ 'FBTG',  'Battenberg' ],
	[ 'XIBT',  'Battipaglia' ],
	[ 'RBZE',  'Batzenhäusle' ],
	[ 'NBH',   'Batzhausen' ],
	[ 'XFBDC', 'Baudrecourt' ],
	[ 'XFBDN', 'Baudrecourt Racc' ],
	[ 'RBBC',  'Bauerbach' ],
	[ 'EBAU',  'Baukau' ],
	[ 'MBHM',  'Bäumenheim' ],
	[ 'SBH',   'Baumholder' ],
	[ 'BBMW',  'Baumschulenw S-B' ],
	[ 'BBW',   'Baumschulenweg' ],
	[ 'NBAU',  'Baunach' ],
	[ 'NBFL',  'Baunach Flüssigg' ],
	[ 'FBTL',  'Baunatal' ],
	[ 'FBGR',  'Baunat-Gr ritte' ],
	[ 'XDBH',  'Baunhoej' ],
	[ 'DBZ',   'Bautzen' ],
	[ 'ABF',   'Bavendorf' ],
	[ 'XIBV',  'Baveno' ],
	[ 'NBEI',  'Bay Eisenstein' ],
	[ 'MBYB',  'Bayerbach' ],
	[ 'MBGM',  'Bayerisch Gmain' ],
	[ 'NBAW',  'Bayernw Weiden' ],
	[ 'MABY',  'Bayernw/M Schwab' ],
	[ 'MABI',  'Bayernwerk/b Ing' ],
	[ 'XFBY',  'Bayonne' ],
	[ 'NBYD',  'Bayreuth DB-Gr' ],
	[ 'NBY',   'Bayreuth Hbf' ],
	[ 'NBHG',  'Bayreuth-SG BHG' ],
	[ 'NBSI',  'Bayreuth-SG Sigu' ],
	[ 'NEVO',  'Bayreuth-St EVO' ],
	[ 'NBYG',  'Bayreuth-St G' ],
	[ 'MBZ',   'Bayrischzell' ],
	[ 'DGSM',  'Baywa Großschirm' ],
	[ 'XIBZZ', 'Bazzana' ],
	[ 'BRB',   'Bbf Bln-Rummelsb' ],
	[ 'BSCF',  'Bbf Bln-Schönwd' ],
	[ 'LBGF',  'Bbg-Friedenshall' ],
	[ 'XFBEM', 'Beaucaire-March' ],
	[ 'FBRT',  'Bebenroth' ],
	[ 'LBBZ',  'Bebitz' ],
	[ 'FB',    'Bebra' ],
	[ 'FB S',  'Bebra Berg Gl132' ],
	[ 'FB O',  'Bebra Ost' ],
	[ 'FB A',  'Bebra Pbf/Rbf Ül' ],
	[ 'FB R',  'Bebra Rbf' ],
	[ 'FB B',  'Bebra Rbf Berg' ],
	[ 'FBT',   'Bebra Tunnel' ],
	[ 'FBU',   'Bebra Umladebf' ],
	[ 'XMBE',  'Becehegy' ],
	[ 'UBET',  'Bechstedt-Tripp' ],
	[ 'HBKD',  'Beckedorf' ],
	[ 'SBE',   'Beckingen (Saar)' ],
	[ 'HBKG',  'Becklingen' ],
	[ 'EBEK',  'Beckum' ],
	[ 'EBET',  'Beckum Ost' ],
	[ 'XUBP',  'Beclean pe Somes' ],
	[ 'KBE',   'Bedburg (Erft)' ],
	[ 'KBH',   'Bedburg-Hau' ],
	[ 'HBDDN', 'Bedding Nordkopf' ],
	[ 'HBDD',  'Beddingen' ],
	[ 'HSVG',  'Beddingen DB-Gr' ],
	[ 'HBDDV', 'Beddingen VPS' ],
	[ 'XDBT',  'Bedsted Thy' ],
	[ 'HBBT',  'Beedenbostel' ],
	[ 'EBEE',  'Beelen' ],
	[ 'BBEA',  'Beelitz Bea Strw' ],
	[ 'BBEL',  'Beelitz Heilst' ],
	[ 'BBZS',  'Beelitz Stadt' ],
	[ 'WBNZ',  'Beenz' ],
	[ 'FHZ',   'Beerf-Hetzbach' ],
	[ 'XBBE',  'Beernem' ],
	[ 'DBEW',  'Beerwalde KrSchm' ],
	[ 'BBES',  'Beeskow' ],
	[ 'BBEG',  'Beeskow DB Gr' ],
	[ 'BBEW',  'Beeskow West' ],
	[ 'WBES',  'Beetz-Sommerfeld' ],
	[ 'LBDF',  'Behnsdorf' ],
	[ 'NBEH',  'Behringersdorf' ],
	[ 'NBER',  'Behringersmühle' ],
	[ 'FBEI',  'Beienheim' ],
	[ 'LBEI',  'Beilrode' ],
	[ 'LQBE',  'Beilrode SN/BB' ],
	[ 'TBS',   'Beimerstetten' ],
	[ 'XCBS',  'Bekasovo' ],
	[ 'XMBS',  'Bekescsaba' ],
	[ 'XTBPB', 'Bela p Bezdezem' ],
	[ 'XJBP',  'Bela Palanka' ],
	[ 'XMBP',  'Belatelep' ],
	[ 'ABE',   'Beldorf' ],
	[ 'EBLK',  'Belecke' ],
	[ 'XFBF',  'Belfort' ],
	[ 'LBGH',  'Belgershain' ],
	[ 'XIBGT', 'Belgirate' ],
	[ 'XLBL',  'Bellain' ],
	[ 'LBLL',  'Belleben' ],
	[ 'XFBA',  'Bellegarde (Ain)' ],
	[ 'MBNB',  'Bellenberg' ],
	[ 'XFBV',  'Belleville' ],
	[ 'BBEV',  'Bellevue' ],
	[ 'RBLN',  'Bellh Mühlbuckel' ],
	[ 'RBLH',  'Bellheim Bf' ],
	[ 'XOBM',  'Bellingmo' ],
	[ 'XSBZ',  'Bellinzona' ],
	[ 'HBEM',  'Belm' ],
	[ 'XSBEP', 'Belp' ],
	[ 'XZBT',  'Beltinci' ],
	[ 'XLBUL', 'Belval-Lycee' ],
	[ 'XLBR',  'Belval-Redange' ],
	[ 'XLBUN', 'Belval-Universit' ],
	[ 'XLBU',  'Belval-Usines' ],
	[ 'XLBS',  'Belvaux-Soleuvre' ],
	[ 'BBGG',  'Belzig DB-Gr' ],
	[ 'TBEM',  'Bempflingen' ],
	[ 'ZMBZ',  'Bendery 2' ],
	[ 'KBEN',  'Bendorf (Rhein)' ],
	[ 'MBEN',  'Benediktbeuern' ],
	[ 'XTBP',  'Benesov n Plouc' ],
	[ 'XTBN',  'Benesov nad Lipo' ],
	[ 'XFBTR', 'Benestroff' ],
	[ 'XFBEF', 'Benfeld' ],
	[ 'SBG',   'Bengel' ],
	[ 'HBNS',  'Benhausen' ],
	[ 'XFBE',  'Bening' ],
	[ 'HBWW',  'Benitz-Wiswedel' ],
	[ 'LBEK',  'Benneckenstein' ],
	[ 'HBML',  'Bennemühlen' ],
	[ 'LWZW',  'Bennewitz' ],
	[ 'HBEN',  'Bennigsen' ],
	[ 'TBEN',  'Benningen (N)' ],
	[ 'EBEH',  'Benninghausen' ],
	[ 'UBEN',  'Bennungen' ],
	[ 'XFBW',  'Bennwihr' ],
	[ 'UBH',   'Benshausen' ],
	[ 'FBH',   'Bensheim' ],
	[ 'FBAU',  'Bensheim-Auerb' ],
	[ 'EBTT',  'Benteler-Talle' ],
	[ 'WBE',   'Bentwisch' ],
	[ 'KBZR',  'Benzelrath' ],
	[ 'HBEZ',  'Benzen' ],
	[ 'XJB',   'Beograd' ],
	[ 'XJBC',  'Beograd Centar' ],
	[ 'XJBR',  'Beograd Ranzirna' ],
	[ 'NBE',   'Beratzhausen' ],
	[ 'XBBC',  'Berchem' ],
	[ 'XLBC',  'Berchem Hp LU' ],
	[ 'XLBN',  'Berchem Nord' ],
	[ 'MBG',   'Berchtesgad Hbf' ],
	[ 'ZUB',   'Berdichev' ],
	[ 'XMBTU', 'Berettyoujfalu' ],
	[ 'KBEG',  'Berg' ],
	[ 'XSBRG', 'Berg CH' ],
	[ 'XOB',   'Berg NO' ],
	[ 'RBRG',  'Berg (Pfalz)' ],
	[ 'RXBP',  'Berg (Pfalz) Gr.' ],
	[ 'KBGG',  'Berg Gladbach' ],
	[ 'XVBE',  'Berga SE' ],
	[ 'UBGE',  'Berga (Elster)' ],
	[ 'UBK',   'Berga-Kelbra' ],
	[ 'UQBK',  'Berga-Kelbra LGr' ],
	[ 'XIBGM', 'Bergamasco' ],
	[ 'XIBE',  'Bergamo' ],
	[ 'XOBG',  'Bergen NO' ],
	[ 'HBEC',  'Bergen (b Celle)' ],
	[ 'MBE',   'Bergen (Oberbay)' ],
	[ 'WBG',   'Bergen auf Rügen' ],
	[ 'XNBZ',  'Bergen op Zoom' ],
	[ 'HCB',   'Bergen(b C)Lager' ],
	[ 'TBER',  'Bergenweiler' ],
	[ 'BBFE',  'Bergfelde b Bln' ],
	[ 'BABO',  'Bergfelde Ost' ],
	[ 'YBBFE', 'Bergfelde Strw' ],
	[ 'TBH',   'Berghau' ],
	[ 'EBGA',  'Berghausen' ],
	[ 'RBGBP', 'Berghausen Pfinz' ],
	[ 'RBGBS', 'Berghausen Stad' ],
	[ 'KBEE',  'Bergheim (Erft)' ],
	[ 'HBHE',  'Bergheim (Westf)' ],
	[ 'XVBH',  'Berghem' ],
	[ 'RBGB',  'Berghs (Baden)' ],
	[ 'RBGP',  'Berghs (Pfalz)' ],
	[ 'RHUM',  'Berghsn Hummelbg' ],
	[ 'EBKM',  'Bergkamen' ],
	[ 'NBR',   'Bergrheinfeld' ],
	[ 'FBSN',  'Bergschneise' ],
	[ 'WBER',  'Bergsdorf' ],
	[ 'NBHM',  'Bergtheim' ],
	[ 'XSBN',  'Bergün/Bravuogn' ],
	[ 'XFBER', 'Bergues' ],
	[ 'LBWZ',  'Bergwitz' ],
	[ 'LBWU',  'Bergwitz Üst' ],
	[ 'RBE',   'Beringen Bad Bf' ],
	[ 'RBEF',  'Beringerfeld' ],
	[ 'EBRH',  'Beringhausen' ],
	[ 'ABGS',  'Beringstedt' ],
	[ 'XOBK',  'Berkak' ],
	[ 'BBKR',  'Berkenbrück' ],
	[ 'TBLG',  'Berlichingen' ],
	[ 'BAHU',  'Berlin Anhalt.Bf' ],
	[ 'BL',    'Berlin Hbf-Le Bf' ],
	[ 'BPAF',  'Berlin Südkreuz' ],
	[ 'KKMN',  'Berliner Str' ],
	[ 'ABTSB', 'Berliner Tor B' ],
	[ 'ABTSL', 'Berliner Tor L' ],
	[ 'XSBLG', 'Berlingen' ],
	[ 'XSBLS', 'Berlingen S' ],
	[ 'BHED',  'Berlin-Hermsdorf' ],
	[ 'BSTA',  'Berlin-Staaken' ],
	[ 'RBAH',  'Bermatingen-Ahs' ],
	[ 'XSBE',  'Bern' ],
	[ 'BBRN',  'Bernau (b Bln)' ],
	[ 'MBN',   'Bernau a Ch' ],
	[ 'BBER',  'Bernau S-B' ],
	[ 'BBRF',  'Bernau-Friedenst' ],
	[ 'XFBEY', 'Bernay' ],
	[ 'LBWD',  'Bernbg-Waldau Hp' ],
	[ 'LBGS',  'Bernb-Strenzfeld' ],
	[ 'LBG',   'Bernburg' ],
	[ 'LBGZ',  'Bernburg Zementw' ],
	[ 'LBGW',  'Bernburg-Waldau' ],
	[ 'HBER',  'Berne' ],
	[ 'MBER',  'Bernried' ],
	[ 'UBGN',  'Bernsgrün' ],
	[ 'UQBG',  'Bernsgrün TH/SN' ],
	[ 'UBE',   'Bernterode' ],
	[ 'UBEW',  'Bernterode West' ],
	[ 'XTBU',  'Beroun' ],
	[ 'XFBRE', 'Berre' ],
	[ 'HBBR',  'Bersenbrück' ],
	[ 'XFBTM', 'Berthelming' ],
	[ 'DBF',   'Berthelsdorf (E)' ],
	[ 'DBFO',  'Berthelsdorf Ort' ],
	[ 'XLBG',  'Bertrange-Strass' ],
	[ 'XBBX',  'Bertrix' ],
	[ 'DBTS',  'Bertsdorf' ],
	[ 'HBEX',  'Berxen' ],
	[ 'KBZN',  'Berzdorf Nord' ],
	[ 'FBEZ',  'Berzhahn' ],
	[ 'XFB',   'Besancon' ],
	[ 'XFBI',  'Besancon Viotte' ],
	[ 'SBS',   'Besch' ],
	[ 'ABDF',  'Beschendorf' ],
	[ 'TBE',   'Besigheim' ],
	[ 'TBEA',  'Besigheim BASF' ],
	[ 'SBES',  'Besseringen' ],
	[ 'HBES',  'Besta' ],
	[ 'BBST',  'Bestensee' ],
	[ 'EBWG',  'Bestwig' ],
	[ 'DNOB',  'Betonwerk Oeton' ],
	[ 'FKBH1', 'Betrh Sandh Str' ],
	[ 'XLXBB', 'Bettembg Gr FR' ],
	[ 'XLB',   'Bettembourg' ],
	[ 'NBMS',  'Bettmannsäge' ],
	[ 'XSBW',  'Bettwiesen' ],
	[ 'XLBZ',  'Betzdorf (LUX)' ],
	[ 'EBZ',   'Betzdorf (Sieg)' ],
	[ 'LBEU',  'Beucha' ],
	[ 'LBRG',  'Beucha DB-Gr' ],
	[ 'LBEO',  'Beucha Ost' ],
	[ 'WBEU',  'Beuchow' ],
	[ 'RBEU',  'Beuggen' ],
	[ 'LBEN',  'Beuna(Geiseltal)' ],
	[ 'UBEU',  'Beuren' ],
	[ 'TBEU',  'Beuron' ],
	[ 'BBEU',  'Beusselstraße' ],
	[ 'TBTB',  'Beutelsbach' ],
	[ 'BBE',   'Beutersitz' ],
	[ 'XIBVA', 'Bevera' ],
	[ 'ABEV',  'Bevern' ],
	[ 'XNBH',  'Beverw Hoogov Z' ],
	[ 'XNBK',  'Beverwijk' ],
	[ 'SBEW',  'Bewingen' ],
	[ 'XSBX',  'Bex' ],
	[ 'SBX',   'Bexbach' ],
	[ 'LBYD',  'Beyendorf' ],
	[ 'XFBZ',  'Beziers' ],
	[ 'KHIR',  'Bft Hirzenach' ],
	[ 'FGTH',  'B-Guntershausen' ],
	[ 'XPBP',  'Biala Podlaska' ],
	[ 'XPBI',  'Bialogard' ],
	[ 'XPBA',  'Bialystok' ],
	[ 'XIBIZ', 'Bianze' ],
	[ 'XFBR',  'Biarritz' ],
	[ 'XSBC',  'Biasca' ],
	[ 'MBID',  'Bibelöd' ],
	[ 'RBI',   'Biberach (Baden)' ],
	[ 'TBI',   'Biberach (Riß)' ],
	[ 'RBIG',  'Biberach Em SWEG' ],
	[ 'TBIB',  'Biberach Süd' ],
	[ 'XSBBS', 'Biberist RBS' ],
	[ 'XSBB',  'Biberist RM' ],
	[ 'FBL',   'Biblis' ],
	[ 'UBA',   'Bibra' ],
	[ 'XUBC',  'Bicaz' ],
	[ 'MBIC',  'Bichl' ],
	[ 'XABIA', 'Bichlbach-Almk' ],
	[ 'XABI',  'Bichlbach-Berw.' ],
	[ 'ABB',   'Bickbargen' ],
	[ 'FBI',   'Bickenbach' ],
	[ 'FBI N', 'Bickenbach Nord' ],
	[ 'XMBA',  'Bicske Also' ],
	[ 'FEKB',  'Bieber' ],
	[ 'FBBM',  'Biebesheim' ],
	[ 'FBIK',  'Biedenkopf' ],
	[ 'LBZ',   'Biederitz' ],
	[ 'LBZV',  'Biederitz DB-Gr' ],
	[ 'FBIZ',  'Biedk Schulzentr' ],
	[ 'XSBL',  'Biel/Bienne' ],
	[ 'XPBL',  'Bielawa Dolna' ],
	[ 'EBIL',  'Bielefeld Hbf' ],
	[ 'EBILP', 'Bielefeld Hbf' ],
	[ 'EBIO',  'Bielefeld Ost' ],
	[ 'EBILG', 'Bielefeld Vorbf' ],
	[ 'ESBS',  'Bielefelder Str' ],
	[ 'EBIS',  'Bielefeld-Senne' ],
	[ 'LBF',   'Biendorf' ],
	[ 'ABIL',  'Bienenbüttel' ],
	[ 'DBIE',  'Bienenmühle' ],
	[ 'XPB',   'Bierawa' ],
	[ 'SBI',   'Bierbach' ],
	[ 'HROE',  'Bieren-Rödinghsn' ],
	[ 'TBIE',  'Bieringen b Horb' ],
	[ 'TBRJ',  'Bieringen(Jagst)' ],
	[ 'EBID',  'Biersdorf Bf /Ww' ],
	[ 'EBDO',  'Biersdorf(Ww)Ort' ],
	[ 'XBBA',  'Bierset-Awans' ],
	[ 'BBIKM', 'Biesdf Kr Mitte' ],
	[ 'YBBIK', 'Biesdf Kr N Strw' ],
	[ 'BBKN',  'Biesdf Kr Nord' ],
	[ 'BBIKO', 'Biesdf Kr Ost' ],
	[ 'BBKS',  'Biesdf Kr S-Bahn' ],
	[ 'BBIKL', 'Biesdf Kr SO' ],
	[ 'BBIKS', 'Biesdf Kr Süd' ],
	[ 'BBIKV', 'Biesdf Kr SW' ],
	[ 'BBIKW', 'Biesdf Kr West' ],
	[ 'BBDF',  'Biesdorf' ],
	[ 'LBSR',  'Biesenrode' ],
	[ 'WBT',   'Biesenthal' ],
	[ 'MBIH',  'Biessenhofen' ],
	[ 'MBIHA', 'Biessenhofen Abz' ],
	[ 'MBIHH', 'Biessenhofen Hp' ],
	[ 'TBM',   'Bietigheim-Biss' ],
	[ 'RBIE',  'Bietighm(Baden)' ],
	[ 'RBGN',  'Bietingen' ],
	[ 'EBIG',  'Bigge' ],
	[ 'ZBB',   'Bihac' ],
	[ 'XMBH',  'Biharkeresztes' ],
	[ 'SBDS',  'Bildstock' ],
	[ 'TBIL',  'Bilfingen' ],
	[ 'XTBI',  'Bilina' ],
	[ 'XMBI',  'BILK Kombiterm' ],
	[ 'MBIN',  'Billenhausen' ],
	[ 'EBB',   'Billerbeck' ],
	[ 'XDBL',  'Billum' ],
	[ 'ABS',   'Billwerder' ],
	[ 'AHBIA', 'Billwerder-Moorf' ],
	[ 'ABWM',  'Billw-Moorfl' ],
	[ 'EBST',  'Bilstein' ],
	[ 'XSBT',  'Bilten' ],
	[ 'XTBKN', 'Bily Kostel n.N.' ],
	[ 'RBIN',  'Binau' ],
	[ 'LBIK',  'Binde-Kaulitz' ],
	[ 'LBIF',  'Bindfelde' ],
	[ 'LBIN',  'Bindfelde Abzw' ],
	[ 'NBI',   'Bindlach' ],
	[ 'EBDW',  'Bindweide' ],
	[ 'TBGN',  'Bingen (Hohenz)' ],
	[ 'FBGK',  'Bingen (Rh) Hbf' ],
	[ 'FBGO',  'Bingen (Rh) Ost' ],
	[ 'FBGU',  'Bingen (Rh) Uwk' ],
	[ 'FBGKV', 'Bingen (Rh) Vbf' ],
	[ 'FBGN',  'Bingen(Rh) Stadt' ],
	[ 'FBGG',  'Bingen-Gaulsheim' ],
	[ 'EBIN',  'Binolen' ],
	[ 'WBIO',  'Binz LB' ],
	[ 'RBCH',  'Birach' ],
	[ 'XDBI',  'Birk Centerpark' ],
	[ 'EBKB',  'Birkelbach' ],
	[ 'RBRK',  'Birkenau' ],
	[ 'FBBH',  'Birkenbringhsn' ],
	[ 'SBKF',  'Birkenfeld/Nahe' ],
	[ 'TBIR',  'Birkenfeld/Württ' ],
	[ 'BBSH',  'Birkengr Süd Hp' ],
	[ 'BBGN',  'Birkengrund' ],
	[ 'BBGS',  'Birkengrund Süd' ],
	[ 'LBIM',  'Birkenmoor' ],
	[ 'BBIS',  'Birkenstein' ],
	[ 'BBI',   'Birkenwerd b Bln' ],
	[ 'BBI N', 'Birkenwerder N' ],
	[ 'BBIW',  'Birkenwerder S-B' ],
	[ 'UBKN',  'Birkungen' ],
	[ 'XUBD',  'Birlad' ],
	[ 'XSBM',  'Birmensdorf' ],
	[ 'XUBV',  'Birnova' ],
	[ 'SBRB',  'Birresborn' ],
	[ 'XSBI',  'Birrfeld' ],
	[ 'XSBF',  'Birsfelden Hafen' ],
	[ 'XIBG',  'Bisceglie' ],
	[ 'BBSD',  'Bischdorf (L)' ],
	[ 'DBH',   'Bischheim-Gersd' ],
	[ 'XABO',  'Bischofshofen' ],
	[ 'LBIW',  'Bischofswald' ],
	[ 'DBW',   'Bischofswerda' ],
	[ 'MBI',   'Bischofswiesen' ],
	[ 'RBIS',  'Bischweier/Baden' ],
	[ 'TBIS',  'Bisingen' ],
	[ 'XPBIR', 'Biskupiec Resz' ],
	[ 'HBIP',  'Bispingen' ],
	[ 'XLBI',  'Bissen' ],
	[ 'HBSS',  'Bissendorf' ],
	[ 'XIBTG', 'Bistagno' ],
	[ 'XUBSN', 'Bistrita Nord' ],
	[ 'SBIT',  'Bitburg' ],
	[ 'SED',   'Bitburg-Erdorf' ],
	[ 'TBIT',  'Bittelbronn' ],
	[ 'LBT',   'Bitterfeld' ],
	[ 'LBTN',  'Bitterfeld Nord' ],
	[ 'TBIF',  'Bitzfeld' ],
	[ 'XFBIZ', 'Bize' ],
	[ 'ZWBG',  'Bjaroza Gorod' ],
	[ 'XRBV',  'Bjelovar' ],
	[ 'XOBJ',  'Bjerka' ],
	[ 'XDBJ',  'Bjerringbro' ],
	[ 'XVBJ',  'Björketorp' ],
	[ 'XVBK',  'Björköby' ],
	[ 'XOBR',  'Bjorli' ],
	[ 'HBUA',  'BKB' ],
	[ 'XWBL',  'Blagoevgrad' ],
	[ 'NBLA',  'Blaibach(Oberpf)' ],
	[ 'MBLH',  'Blaichach/Allgäu' ],
	[ 'XFBLV', 'Blainville-D' ],
	[ 'XUBL',  'Blaj' ],
	[ 'XFBLM', 'Blanc Mesnil' ],
	[ 'XEBL',  'Blanes' ],
	[ 'LBKW',  'Blankenb Westend' ],
	[ 'FBLK',  'Blankenbach' ],
	[ 'WBL',   'Blankenberg (M)' ],
	[ 'KBLB',  'Blankenberg/Sieg' ],
	[ 'LBKG',  'Blankenbg DB-Gr' ],
	[ 'WDLG',  'Blankenbg DB-Gr' ],
	[ 'LBK',   'Blankenburg (H)' ],
	[ 'LBK N', 'Blankenburg Nord' ],
	[ 'AB',    'Blankenese' ],
	[ 'BBF',   'Blankenfelde' ],
	[ 'BBFD',  'Blankenfelde S-B' ],
	[ 'KBLH',  'Blankenh(Wald)' ],
	[ 'EBKH',  'Blankenhagen' ],
	[ 'FBLA',  'Blankenheim' ],
	[ 'UBT',   'Blankenheim Trbf' ],
	[ 'UBM',   'Blankenheim(Sgh)' ],
	[ 'WBLH',  'Blankenhof' ],
	[ 'RBANK', 'Blankenl Kirche' ],
	[ 'RBAN',  'Blankenloch' ],
	[ 'RBANN', 'Blankenloch Nord' ],
	[ 'WBLS',  'Blankensee (M)' ],
	[ 'EBLS',  'Blankenstein' ],
	[ 'UBN',   'Blankenstein (S)' ],
	[ 'XTBA',  'Blansko' ],
	[ 'TBL',   'Blaubeuren' ],
	[ 'TBLF',  'Blaufelden' ],
	[ 'XSBS',  'Blausee-Mitholz' ],
	[ 'TBLS',  'Blaustein' ],
	[ 'XTBL',  'Blazovice' ],
	[ 'UBHA',  'Blechhammer(Thü)' ],
	[ 'HBEK',  'Bleckede' ],
	[ 'HBKR',  'Bleckmar' ],
	[ 'RBLB',  'Bleibach' ],
	[ 'FBLH',  'Bleichenb (Obh)' ],
	[ 'UBD',   'Bleicherode Ost' ],
	[ 'XOBI',  'Bleiken' ],
	[ 'KBLE',  'Blens' ],
	[ 'XNBL',  'Blerick' ],
	[ 'XNBE',  'Blerick ECT' ],
	[ 'XFBLH', 'Blesme Haussig' ],
	[ 'SBKL',  'Bliesk-Lautzk' ],
	[ 'XABD',  'Blindenmarkt' ],
	[ 'MBLM',  'Blindheim' ],
	[ 'BALE',  'Bln Alex Hp' ],
	[ 'BBOF',  'Bln Bornholm Str' ],
	[ 'BFBI',  'Bln Flugh BER' ],
	[ 'BFBB',  'Bln Flughf S-B' ],
	[ 'BFAL',  'Bln Frankf Allee' ],
	[ 'BFRI',  'Bln Friedrichstr' ],
	[ 'BGFB',  'Bln Greifsw Str' ],
	[ 'BGSS',  'Bln Greifsw.Str.' ],
	[ 'BQFLH', 'Bln Grünbga LGR' ],
	[ 'BHUL',  'Bln Hamb u Lehrt' ],
	[ 'BHBF',  'Bln Hbf Lehrt Bf' ],
	[ 'BL N',  'Bln Hbf-Le Bf N' ],
	[ 'BLS',   'Bln Hbf-Le Bf(S)' ],
	[ 'BNDM',  'Bln Nennh Damm' ],
	[ 'BNB',   'Bln Nordbahnhof' ],
	[ 'BNO',   'Bln Nordost' ],
	[ 'BHF',   'Bln Ostbahnhof' ],
	[ 'BOSB',  'Bln Ostbf S-B' ],
	[ 'BOSGA', 'Bln Ostgbf (B7)' ],
	[ 'BPOG',  'Bln Potsd Gbf' ],
	[ 'BPOF',  'Bln Potsdamer Pl' ],
	[ 'BQFH',  'Bln Schönefd LGr' ],
	[ 'BSHA',  'Bln Schönh Allee' ],
	[ 'BPAFS', 'Bln Südende' ],
	[ 'BTK',   'Bln Teltowkanal' ],
	[ 'BWDH',  'Bln Wendenh' ],
	[ 'BWF',   'Bln Westhafen' ],
	[ 'BWRG',  'Bln Wriezener Bf' ],
	[ 'BZOS',  'Bln Zool G S-B' ],
	[ 'BZOO',  'Bln Zool Garten' ],
	[ 'BADL',  'Bln-Adlershof' ],
	[ 'BAS',   'Bln-Albrechtshof' ],
	[ 'BQAS',  'Bln-Albrhof LGr' ],
	[ 'BBLB',  'Bln-Blankenb S-B' ],
	[ 'BBKB',  'Bln-Blankenburg' ],
	[ 'BBTZ',  'Bln-Britz' ],
	[ 'BBU',   'Bln-Buch' ],
	[ 'BQBUS', 'Bln-Buch 6002' ],
	[ 'BQBU',  'Bln-Buch 6081' ],
	[ 'BCHB',  'Bln-Charlottenbg' ],
	[ 'BFRH',  'Bln-Friedrichshg' ],
	[ 'BQFOH', 'Bln-Frohn 6030' ],
	[ 'BQFO',  'Bln-Frohn 6088' ],
	[ 'BFOH',  'Bln-Frohnau' ],
	[ 'BGS',   'Bln-Gesundbr' ],
	[ 'BGA',   'Bln-Grünau' ],
	[ 'BQGAS', 'Bln-Grünau 6007' ],
	[ 'BQGA',  'Bln-Grünau 6142' ],
	[ 'BQGAF', 'Bln-Grünau 6519' ],
	[ 'BGAS',  'Bln-Grünau S-B' ],
	[ 'BGD N', 'Bln-Grunew Gdn' ],
	[ 'BGD R', 'Bln-Grunew Gdr' ],
	[ 'BGD S', 'Bln-Grunew Gds' ],
	[ 'BGD',   'Bln-Grunewald' ],
	[ 'BHLR',  'Bln-Halens' ],
	[ 'BHLRN', 'Bln-Halens N' ],
	[ 'BHLRS', 'Bln-Halens S' ],
	[ 'BHAL',  'Bln-Halensee S-B' ],
	[ 'BHLS',  'Bln-Heiligensee' ],
	[ 'BQHL',  'Bln-Heiligs LGr' ],
	[ 'BHSH',  'Bln-Hohenschhsn' ],
	[ 'BQAKS', 'Bln-Kar W 6009' ],
	[ 'BQAK',  'Bln-Kar W 6087' ],
	[ 'BKH',   'Bln-Karlshorst' ],
	[ 'BKAR',  'Bln-Karow' ],
	[ 'BQKA',  'Bln-Karow BE/BB' ],
	[ 'BKAG',  'Bln-Karow DB-Gr' ],
	[ 'BAKO',  'Bln-Karow Ost' ],
	[ 'BKRW',  'Bln-Karow S-B' ],
	[ 'BAKS',  'Bln-Karow W S-B' ],
	[ 'BAKW',  'Bln-Karow West' ],
	[ 'BKD',   'Bln-Kaulsdorf' ],
	[ 'BKP',   'Bln-Köpenick' ],
	[ 'BKPK',  'Bln-Köpenick S-B' ],
	[ 'BLO',   'Bln-Lichtenberg' ],
	[ 'BLO G', 'Bln-Lichtenbg B1' ],
	[ 'BLO A', 'Bln-Lichtenbg W3' ],
	[ 'BLIO',  'Bln-Lichterf Ost' ],
	[ 'BLIW',  'Bln-Lichterf W' ],
	[ 'BQLI',  'Bln-Lifde S LGr' ],
	[ 'BQLR',  'Bln-Li-rade Lgr' ],
	[ 'BQMDF', 'Bln-Mahlsdf 6006' ],
	[ 'BQMD',  'Bln-Mahlsdf 6078' ],
	[ 'BMDF',  'Bln-Mahlsdorf' ],
	[ 'BMD',   'Bln-Mariendorf' ],
	[ 'BMAF',  'Bln-Marienf Gbf' ],
	[ 'BMF',   'Bln-Marienfelde' ],
	[ 'BMAR',  'Bln-Marzahn' ],
	[ 'BMAZ',  'Bln-Marzahn S-B' ],
	[ 'BMOA',  'Bln-Moabit' ],
	[ 'YBBMO', 'Bln-Moabit Strw' ],
	[ 'BNKN',  'Bln-Neukölln' ],
	[ 'BPKW',  'Bln-Pankow S-B' ],
	[ 'BRKD',  'Bln-Reinickendf' ],
	[ 'BRUN',  'Bln-Rudow Nord' ],
	[ 'BRUH',  'Bln-Ruhleben' ],
	[ 'BRGBB', 'Bln-Rummels BZ' ],
	[ 'BRGBR', 'Bln-Rummels Ra' ],
	[ 'BRGBA', 'Bln-Rummels Rga' ],
	[ 'BRGBO', 'Bln-Rummels Rgo' ],
	[ 'BRGBW', 'Bln-Rummels Rgw' ],
	[ 'BRGBT', 'Bln-Rummels Tanl' ],
	[ 'BRGBV', 'Bln-Rummels Vnk' ],
	[ 'BRH',   'Bln-Rummelsb SB' ],
	[ 'BRGB',  'Bln-Rummelsburg' ],
	[ 'BSLS',  'Bln-Schlacht.see' ],
	[ 'BSGR',  'Bln-Schönebg R-B' ],
	[ 'BSGV',  'Bln-Schönebg V-B' ],
	[ 'BSWP',  'Bln-Schönew Pbf' ],
	[ 'BSNL',  'Bln-Schönholz' ],
	[ 'BSAD',  'Bln-Schwde Sad' ],
	[ 'BSPD',  'Bln-Spandau' ],
	[ 'BSPA',  'Bln-Spandau S-B' ],
	[ 'BSPG',  'Bln-Spandau Gbf' ],
	[ 'BSPJ',  'Bln-Spandau Joh' ],
	[ 'BSPDM', 'Bln-Spandau Mit' ],
	[ 'BSPDO', 'Bln-Spandau Ost' ],
	[ 'BSPO',  'Bln-Spandau Osth' ],
	[ 'BSPDW', 'Bln-Spandau West' ],
	[ 'BSPF',  'Bln-Spindlersfd' ],
	[ 'BQST',  'Bln-Staaken 6107' ],
	[ 'BQSTG', 'Bln-Staaken 6179' ],
	[ 'BQSTA', 'Bln-Staaken 6185' ],
	[ 'BSTAB', 'Bln-Staaken Bstg' ],
	[ 'BTG',   'Bln-Tegel' ],
	[ 'BTF',   'Bln-Tempelhof' ],
	[ 'BWS',   'Bln-Wannsee' ],
	[ 'BWSS',  'Bln-Wannsee S-B' ],
	[ 'BQWS',  'Bln-Wannsee LGr' ],
	[ 'BWDG',  'Bln-Wedding Abzw' ],
	[ 'BWM',   'Bln-Wilhelmsruh' ],
	[ 'BQWI',  'Bln-Wilhhg Lgr' ],
	[ 'BWL',   'Bln-Wilmersdorf' ],
	[ 'BZD',   'Bln-Zehlendorf' ],
	[ 'ABBG',  'Blocksberg' ],
	[ 'XVBL',  'Blomstermala' ],
	[ 'LBD',   'Blönsdorf' ],
	[ 'LQBD',  'Blönsdorf BB/ST' ],
	[ 'XABL',  'Bludenz' ],
	[ 'BBLU',  'Blumberg(b Bln)' ],
	[ 'BAHH',  'Blumberg-Rehhahn' ],
	[ 'RZS',   'Blumberg-Zollhs' ],
	[ 'DBLU',  'Blumenau' ],
	[ 'LBLG',  'Blumenberg' ],
	[ 'WBLK',  'Blumenhagen' ],
	[ 'EBKP',  'Blumenkamp' ],
	[ 'EBLT',  'Blumenthal' ],
	[ 'WBMT',  'Blumenthal(Mark)' ],
	[ 'KBLU',  'Blumenthal/Eifel' ],
	[ 'KBMW',  'BMW /Krefeld' ],
	[ 'MADF',  'BMW Dynamikzentr' ],
	[ 'LSWQ',  'Bn Alt Sww Quenz' ],
	[ 'KBBN',  'Bn-Bad Gobg Nord' ],
	[ 'KBBG',  'Bn-Bad Godesberg' ],
	[ 'KBBI',  'Bn-Beuel Ind Bf' ],
	[ 'KBHK',  'Bn-Holzlar Kaut' ],
	[ 'KBTS',  'Bn-Tannenb Süd' ],
	[ 'XOBO',  'Bo' ],
	[ 'YEEBP', 'BO Präsident Stw' ],
	[ 'TBCS',  'Bö Sonnenbrunnen' ],
	[ 'XMB',   'Boba' ],
	[ 'RBOB',  'Bobenheim' ],
	[ 'MBOB',  'Bobingen' ],
	[ 'TBB',   'Böbingen (Rems)' ],
	[ 'WBO',   'Bobitz' ],
	[ 'TBO T', 'Böbl. Danziger S' ],
	[ 'TBO Z', 'Böbl. Zimmersch' ],
	[ 'TBO H', 'Böbl.Heusteigstr' ],
	[ 'TBO',   'Böblingen' ],
	[ 'TBO F', 'Böblingen Em WEG' ],
	[ 'TBOS',  'Böblingen Südbf' ],
	[ 'NBOB',  'Böbrach' ],
	[ 'FBST',  'Bobstadt' ],
	[ 'XPBO',  'Bochnia' ],
	[ 'EBCH',  'Bocholt' ],
	[ 'YEEDB', 'Bocholt Strw' ],
	[ 'EBO',   'Bochum Hbf' ],
	[ 'EBNO',  'Bochum Nord' ],
	[ 'EBOW',  'Bochum West' ],
	[ 'EBOE',  'Bochum-Ehrenfeld' ],
	[ 'EBOH',  'Bochum-Hamme' ],
	[ 'EBRI',  'Bochum-Riemke' ],
	[ 'EBGZ',  'Bochum-Riemke Hp' ],
	[ 'RBOK',  'Bockenh-Kindenhm' ],
	[ 'HBTV',  'Bocketal' ],
	[ 'TBCB',  'Böckingen Berufs' ],
	[ 'TBCW',  'Böckingen West' ],
	[ 'XABS',  'Böckstein' ],
	[ 'EBCK',  'Bockum-Hövel' ],
	[ 'XFBCC', 'Bocognano' ],
	[ 'XMBC',  'Bocskaikert' ],
	[ 'XPBW',  'Boczow' ],
	[ 'XVBF',  'Bodafors' ],
	[ 'EBDAB', 'Bo-Dahlh Bz West' ],
	[ 'EBDA',  'Bo-Dahlhausen' ],
	[ 'EBDAM', 'Bo-Dahlhsn EBM' ],
	[ 'XMBOD', 'Bodajk' ],
	[ 'XVBD',  'Bodarne' ],
	[ 'XNBD',  'Bodegraven' ],
	[ 'MBOD',  'Bodelsberg' ],
	[ 'TBOD',  'Bodelshausen' ],
	[ 'HBBU',  'Bodenburg' ],
	[ 'LBOA',  'Bodendorf Anst' ],
	[ 'LBOF',  'Bodendorf(Kr Hd)' ],
	[ 'HBOF',  'Bodenfelde' ],
	[ 'FBOD',  'Bodenheim' ],
	[ 'NBMA',  'Bodenmais' ],
	[ 'UBOD',  'Bodenrode' ],
	[ 'HBOD',  'Bodenteich' ],
	[ 'NBOE',  'Bodenwöhr Nord' ],
	[ 'RBGH',  'Bödigheim' ],
	[ 'XSBOD', 'Bodio' ],
	[ 'XOBD',  'Bodo' ],
	[ 'XFBN',  'Boen' ],
	[ 'NBO',   'Bogen' ],
	[ 'XCBJ',  'Bogoiavlensk' ],
	[ 'XCBO',  'Bogushewskaia' ],
	[ 'XABC',  'Böheimkirchen' ],
	[ 'LBO',   'Böhlen (b Lpz)' ],
	[ 'LBWE',  'Böhlen Werke' ],
	[ 'RBOA',  'Böhl-Iggelh Abzw' ],
	[ 'RBOE',  'Böhl-Iggelheim' ],
	[ 'HBME',  'Böhme' ],
	[ 'NBHF',  'Böhmhof' ],
	[ 'HBOM',  'Bohmte' ],
	[ 'HQBO',  'Bohmte NI/NRW' ],
	[ 'HBOO',  'Bohmte VLO' ],
	[ 'BQBD',  'Bohnsdorf 6151' ],
	[ 'BBDS',  'Bohnsdorf Süd' ],
	[ 'BBDW',  'Bohnsdorf West' ],
	[ 'XTBH',  'Bohousova' ],
	[ 'RBER',  'Böhringen-Rick' ],
	[ 'XTBO',  'Bohumin' ],
	[ 'XVBO',  'Bohus' ],
	[ 'KBOI',  'Boisheim' ],
	[ 'WBZ',   'Boizenburg(Elbe)' ],
	[ 'ABM N', 'Bokelholm N' ],
	[ 'ABM S', 'Bokelholm Süd' ],
	[ 'HKM',   'Bokeloh (Meppen)' ],
	[ 'HBKN',  'Bokeloh(b Wunst)' ],
	[ 'ABHT',  'Bokholt' ],
	[ 'EBLAZ', 'Bo-Langend Kreuz' ],
	[ 'EBLAM', 'Bo-Langend Mitte' ],
	[ 'EBLAO', 'Bo-Langend Ostbg' ],
	[ 'EBLAP', 'Bo-Langend Pbf' ],
	[ 'EBLAG', 'Bo-Langendr Lgf' ],
	[ 'EBLAB', 'Bo-Langendr Ost' ],
	[ 'EBLAS', 'Bo-Langendr Süd' ],
	[ 'EBLAI', 'Bo-Langendr West' ],
	[ 'EBW',   'Bo-Langendr West' ],
	[ 'EBLA',  'Bo-Langendreer' ],
	[ 'EBP',   'Bo-Langendreer S' ],
	[ 'XPBOL', 'Boleslawiec' ],
	[ 'XVBG',  'Bollebygd' ],
	[ 'XFBOW', 'Bollwiller' ],
	[ 'XIBAR', 'Bologna Arcoveg.' ],
	[ 'XIBC',  'Bologna C' ],
	[ 'XIBCO', 'Bologna Cortic' ],
	[ 'XIBP',  'Bologna Interpor' ],
	[ 'XIBR',  'Bologna Ravone' ],
	[ 'XIBS',  'Bologna S Donato' ],
	[ 'XIBSR', 'Bologna s Ruff' ],
	[ 'HBT',   'Boltersen' ],
	[ 'XIBZ',  'Bolzano/Bozen' ],
	[ 'WBOE',  'Bölzke' ],
	[ 'WBOG',  'Bölzke DB-Gr' ],
	[ 'HBOZ',  'Bomlitz' ],
	[ 'LBOM',  'Bomsdorf' ],
	[ 'FBOF',  'Bonaforth' ],
	[ 'TBD',   'Bondorf b Herrbg' ],
	[ 'XFBDY', 'Bondy' ],
	[ 'EBEO',  'Bönen' ],
	[ 'HBNB',  'Bonenburg' ],
	[ 'KBBS',  'Bonn Brühler Str' ],
	[ 'KB G',  'Bonn Gbf' ],
	[ 'KB',    'Bonn Hbf' ],
	[ 'KBRH',  'Bonn RheinuferBF' ],
	[ 'KBWS',  'Bonn West' ],
	[ 'KBBF',  'Bonn-Bendenfeld' ],
	[ 'KBB',   'Bonn-Beuel' ],
	[ 'KBBO',  'Bonn-Beuel Ost' ],
	[ 'KBBDG', 'Bonn-Buschdf Gbf' ],
	[ 'KBBDV', 'Bonn-Buschdf VAW' ],
	[ 'KBBD',  'Bonn-Buschdorf' ],
	[ 'KBDF',  'Bonn-Dransdorf' ],
	[ 'KBD',   'Bonn-Duisdorf' ],
	[ 'KBEC',  'Bonn-Endenich N' ],
	[ 'ABNS',  'Bönningstedt' ],
	[ 'KBM',   'Bonn-Mehlem' ],
	[ 'KBO',   'Bonn-Oberkassel' ],
	[ 'HBHB',  'Bookholzberg' ],
	[ 'ABOS',  'Boostedt' ],
	[ 'TBP',   'Bopfingen' ],
	[ 'KBOP',  'Boppard Hbf' ],
	[ 'KBPS',  'Boppard Süd' ],
	[ 'XVBR',  'Bor' ],
	[ 'XVBS',  'Boras C' ],
	[ 'XFBJ',  'Bordeaux-St-J' ],
	[ 'ABRD',  'Bordesholm' ],
	[ 'XIBD',  'Bordighera' ],
	[ 'XDBD',  'Bording' ],
	[ 'XFHO',  'Bordx Hourcade' ],
	[ 'EBOR',  'Borgeln' ],
	[ 'EBHS',  'Borgholzhausen' ],
	[ 'XIBOF', 'Borgo Fornari' ],
	[ 'XIBOR', 'Borgo Revel' ],
	[ 'XIBOD', 'Borgo S Dalmazzo' ],
	[ 'XIBOM', 'Borgo S Martino' ],
	[ 'XIBOV', 'Borgo Vercelli' ],
	[ 'XIBO',  'Borgomanero' ],
	[ 'XIBOG', 'Borgoratto' ],
	[ 'BBOR',  'Borgsdorf' ],
	[ 'BBOD',  'Borgsdorf Bk' ],
	[ 'XVBT',  'Borgstena' ],
	[ 'ZWBO',  'Borisov' ],
	[ 'EBOK',  'Bork (Westf)' ],
	[ 'FBOK',  'Borken (Hess)' ],
	[ 'EBK',   'Borken (Westf)' ],
	[ 'BBK',   'Borkheide' ],
	[ 'XVB',   'Borlänge' ],
	[ 'XNBO',  'Born' ],
	[ 'LBL',   'Borna(b Leipzig)' ],
	[ 'LBOK',  'Börnecke (Harz)' ],
	[ 'KBHS',  'Bornheim Rathaus' ],
	[ 'KBHG',  'Bornheim(Bn) Gbf' ],
	[ 'KBHP',  'Bornheim(BN) Pbf' ],
	[ 'KDDF',  'Bornheim-Dersdf' ],
	[ 'KHRS',  'Bornheim-Hersel' ],
	[ 'BBOS',  'Bornholmer Str' ],
	[ 'EBHT',  'Bornholte' ],
	[ 'BBSL',  'Börnichen-Schl' ],
	[ 'DBT',   'Bornitz (b Osch)' ],
	[ 'LBIZ',  'Bornitz(b Zeitz)' ],
	[ 'ABSF',  'Börnsen' ],
	[ 'XZBO',  'Borovnica' ],
	[ 'XDBO',  'Borris' ],
	[ 'FBO',   'Borsdorf (Hess)' ],
	[ 'LBOR',  'Borsdorf (Sachs)' ],
	[ 'HBSM',  'Börßum' ],
	[ 'LBOL',  'Borstel (Kr St)' ],
	[ 'XDBOP', 'Borup' ],
	[ 'ZBBN',  'Bosanski Novi' ],
	[ 'TKTB',  'Bosch' ],
	[ 'LBOE',  'Bösdorf (Sa-Anh)' ],
	[ 'HBSL',  'Bösel' ],
	[ 'EBSL',  'Bösensell' ],
	[ 'HBSG',  'Bösingfeld' ],
	[ 'EBSP',  'Bösperde' ],
	[ 'BBGT',  'Botanisch.Garten' ],
	[ 'ABOE',  'Bötersen' ],
	[ 'XUBOT', 'Botosani' ],
	[ 'XSBOH', 'Bottighofen' ],
	[ 'EVEG',  'Bottr VEBA DB-Gr' ],
	[ 'EBTH',  'Bottrop Hbf' ],
	[ 'EBTHG', 'Bottrop Hbf-Gbf' ],
	[ 'EBTHP', 'Bottrop Hbf-Pbf' ],
	[ 'EBTN',  'Bottrop Nord' ],
	[ 'EBTS',  'Bottrop Süd' ],
	[ 'EBTB',  'Bottrop-Boy' ],
	[ 'EBTV',  'Bot-Vonderort' ],
	[ 'RBTZ',  'Bötzingen' ],
	[ 'RBTU',  'Bötzingen Mühle' ],
	[ 'XFBO',  'Boulange I T' ],
	[ 'XDBV',  'Boulevarden' ],
	[ 'XFBUA', 'Bouligny Aerogl' ],
	[ 'XFBL',  'Bouligny Centre' ],
	[ 'XFBUM', 'Bouligny Marit' ],
	[ 'XFBB',  'Bourg-en-Bresse' ],
	[ 'XFBGS', 'Bourges' ],
	[ 'XFBLT', 'Bourget I T' ],
	[ 'XFBM',  'Bourg-St Maurice' ],
	[ 'SBO',   'Bous (Saar)' ],
	[ 'SBOG',  'Bous DB/Walzw' ],
	[ 'XFBZV', 'Bouzonville' ],
	[ 'TBOX',  'Boxberg-Wölchign' ],
	[ 'XVBX',  'Boxholm' ],
	[ 'KSAL',  'Bp-Bad Salzig' ],
	[ 'KBZ',   'Bp-Buchholz' ],
	[ 'KFLH',  'Bp-Fleckertshöhe' ],
	[ 'KHIRW', 'Bp-Hirzenach' ],
	[ 'XIB',   'Bra' ],
	[ 'XDBB',  'Brabrand' ],
	[ 'EBRB',  'Brachbach' ],
	[ 'KBRC',  'Brachelen' ],
	[ 'EBWE',  'Brackwede' ],
	[ 'EBWEG', 'Brackwede Gbf' ],
	[ 'EBWS',  'Brackwede Süd' ],
	[ 'XUBR',  'Bradu de Sus' ],
	[ 'XIBRA', 'Bragno' ],
	[ 'WBRH',  'Brahlstorf' ],
	[ 'XUBRA', 'Braila' ],
	[ 'EBRA',  'Brake (b Bielef)' ],
	[ 'EBRAH', 'Brake Hp' ],
	[ 'HBKE',  'Brake/Unterweser' ],
	[ 'HBKH',  'Brakel' ],
	[ 'HBKL',  'Brakel/Kr Höxter' ],
	[ 'XDBM',  'Bramming' ],
	[ 'HBRM',  'Bramsche' ],
	[ 'HBRA',  'Bramstedt/b Syke' ],
	[ 'BBRA',  'Brand (Niederl)' ],
	[ 'LB G',  'Brandbg Hbf Gbf' ],
	[ 'RBBO',  'Brandbühl Ost' ],
	[ 'RBBW',  'Brandbühl West' ],
	[ 'ABRM',  'Brandenbaum' ],
	[ 'LRCG',  'Brandenbg DB-Gr' ],
	[ 'LB',    'Brandenburg Hbf' ],
	[ 'LBA',   'Brandenburg-Alt' ],
	[ 'BTOR',  'BrandenburgerTor' ],
	[ 'DBE',   'Brand-Erbisdorf' ],
	[ 'LBRA',  'Brandis' ],
	[ 'XIBRZ', 'Brandizzo' ],
	[ 'FBRD',  'Brandoberndorf' ],
	[ 'MBRS',  'Brandstätt' ],
	[ 'XPBR',  'Braniewo' ],
	[ 'MBB',   'Brannenburg' ],
	[ 'LBI',   'Braschwitz' ],
	[ 'XJBS',  'Brasina' ],
	[ 'XUBS',  'Brasov' ],
	[ 'XYBU',  'Bratisl ustredna' ],
	[ 'XYBA',  'Bratisl Vajnory' ],
	[ 'XYBV',  'Bratisl Vinohrad' ],
	[ 'XYB',   'Bratislava hl.st' ],
	[ 'XYBN',  'Bratislava N.M.' ],
	[ 'XYBP',  'Bratislava Palen' ],
	[ 'XYBY',  'Bratislava Vych' ],
	[ 'XYBZ',  'Bratislava-Petra' ],
	[ 'XYBR',  'Bratislava-Raca' ],
	[ 'XVBB',  'Bratteborg' ],
	[ 'KBRB',  'Braubach' ],
	[ 'EBKR',  'Bräuckerstr' ],
	[ 'XABR',  'Braunau a Inn' ],
	[ 'LBRS',  'Braunesumpf' ],
	[ 'DBR',   'Braunichswalde' ],
	[ 'RBRI',  'Bräunl Industrie' ],
	[ 'RBRN',  'Bräunlingen Bf' ],
	[ 'LBS',   'Braunsbedra' ],
	[ 'LBSO',  'Braunsbedra Ost' ],
	[ 'HBGA',  'Braunschw RAUA' ],
	[ 'HBS',   'Braunschweig Hbf' ],
	[ 'HBSR',  'Braunschweig Rbf' ],
	[ 'DBDL',  'Braunsdorf-Licht' ],
	[ 'ZIB',   'Bray' ],
	[ 'XABZ',  'Braz' ],
	[ 'XUBZ',  'Brazi' ],
	[ 'SBA',   'Brebach' ],
	[ 'SBAG',  'Brebach DB/Saarb' ],
	[ 'FBRM',  'Breckenheim' ],
	[ 'XTBE',  'Breclav' ],
	[ 'XTXBE', 'Breclav Gr AT' ],
	[ 'XNBR',  'Breda' ],
	[ 'XVBRY', 'Bredaryd' ],
	[ 'WBDN',  'Breddin' ],
	[ 'XDBR',  'Bredebro' ],
	[ 'EBDL',  'Bredelar' ],
	[ 'ABRB',  'Bredenbek' ],
	[ 'ABST',  'Bredstedt' ],
	[ 'XCBR',  'Bredy' ],
	[ 'XAB',   'Bregenz' ],
	[ 'XABHF', 'Bregenz See' ],
	[ 'LBN',   'Brehna' ],
	[ 'XFBRY', 'Breil sur Roya' ],
	[ 'RBRS',  'Breisach' ],
	[ 'RAKG',  'Breisach DB/SWEG' ],
	[ 'MBRT',  'Breitenau' ],
	[ 'FBTB',  'Breitenb (Herzb)' ],
	[ 'FBRB',  'Breitenbach(Ksl)' ],
	[ 'DBRE',  'Breitenbrunn' ],
	[ 'MBRN',  'Breitenbrunn/Sch' ],
	[ 'NBRE',  'Breitendiel' ],
	[ 'DBTD',  'Breitendorf' ],
	[ 'TBRF',  'Breitenfürst' ],
	[ 'NBG',   'Breitengüßbach' ],
	[ 'KBRS',  'Breitscheidt' ],
	[ 'UBRT',  'Breitungen/Werra' ],
	[ 'XOBL',  'Breland' ],
	[ 'HB',    'Bremen Hbf' ],
	[ 'HBR',   'Bremen Rbf' ],
	[ 'HBR V', 'Bremen Rbf Abzw' ],
	[ 'HBR A', 'Bremen Rbf Baf' ],
	[ 'HBR E', 'Bremen Rbf Bve' ],
	[ 'HBR F', 'Bremen Rbf Bvf' ],
	[ 'HBR L', 'Bremen Rbf Bvl' ],
	[ 'HBR M', 'Bremen Rbf Bvm' ],
	[ 'HBR P', 'Bremen Rbf Bvp' ],
	[ 'HBR W', 'Bremen Rbf Bvw' ],
	[ 'HBRN',  'Bremen-Aumund' ],
	[ 'HBRB',  'Bremen-Blumenth' ],
	[ 'HBB',   'Bremen-Burg' ],
	[ 'HBRF',  'Bremen-Farge' ],
	[ 'HBFO',  'Bremen-Farge Ost' ],
	[ 'HBG',   'Bremen-Grolland' ],
	[ 'HBHI',  'Bremen-Hucht BTE' ],
	[ 'HBHU',  'Bremen-Huchting' ],
	[ 'HBL',   'Bremen-Lesum' ],
	[ 'HBM',   'Bremen-Mahndorf' ],
	[ 'HBN',   'Bremen-Neustadt' ],
	[ 'HBRR',  'Bremen-Rönnebeck' ],
	[ 'HBMG',  'Bremen-St Magnus' ],
	[ 'HBV',   'Bremen-Vegesack' ],
	[ 'HBWA',  'Bremen-Walle' ],
	[ 'HBH',   'Bremerhaven Hbf' ],
	[ 'ABV',   'Bremervörde' ],
	[ 'ABVD',  'Bremervörde Süd' ],
	[ 'FREH',  'B-Rengershausen' ],
	[ 'BBRS',  'Brenitz-Sonnew' ],
	[ 'KBK',   'Brenk' ],
	[ 'XIBN',  'Brennero/Brenner' ],
	[ 'XABE',  'Brennersee' ],
	[ 'XAXBE', 'Brennersee Gr IT' ],
	[ 'XIBCA', 'Brescia' ],
	[ 'XIBCS', 'Brescia Scalo' ],
	[ 'XIBX',  'Bressan./Brixen' ],
	[ 'XIBRB', 'Bressana Bott' ],
	[ 'XBBS',  'Bressoux' ],
	[ 'XFBRT', 'Brest FR' ],
	[ 'AAE',   'Brest-Aspe' ],
	[ 'ZWB',   'Brest-Centralnyi' ],
	[ 'XYBT',  'Brestovany' ],
	[ 'UBZ',   'Breternitz' ],
	[ 'UBR',   'Bretleben' ],
	[ 'RBT',   'Bretten' ],
	[ 'RBTN',  'Bretten Rechberg' ],
	[ 'RBTI',  'Bretten-Ruit' ],
	[ 'HBRT',  'Brettorf' ],
	[ 'SBRH',  'Bretzenheim' ],
	[ 'TBZ',   'Bretzfeld' ],
	[ 'KBRY',  'Breyell' ],
	[ 'XTBJ',  'Brezina nad Jize' ],
	[ 'XTBD',  'Breziny u Decina' ],
	[ 'XTBC',  'Brezno u Chomuto' ],
	[ 'HBSH',  'Brg Hafen' ],
	[ 'HBSN',  'Brg Nordkurve' ],
	[ 'HGLI',  'Brg-Gliesmarode' ],
	[ 'HBSU',  'Brg-Querum' ],
	[ 'HBSE',  'Brg-Rühme' ],
	[ 'HBHC',  'Brh Columbusbf' ],
	[ 'HBHSK', 'Brh Kaiserhafen' ],
	[ 'HBHNH', 'Brh Nordhafen' ],
	[ 'HBHS',  'Brh Seehafen' ],
	[ 'HBIG',  'Brh-Imsum DB-Gr' ],
	[ 'HBHLA', 'Brh-L Abstellbf' ],
	[ 'HBHL',  'Brh-Lehe Pbf' ],
	[ 'HBHK',  'Brh-Seehf DB-Gr' ],
	[ 'HSPG',  'Brh-Speck DB-Gr' ],
	[ 'HBHP',  'Brh-Speckenbütt' ],
	[ 'HBHF',  'Brhv Fischereihf' ],
	[ 'HBWG',  'Brh-Wulsdf DB-Gr' ],
	[ 'HBWU',  'Brh-Wulsdorf' ],
	[ 'BBRT',  'Briescht' ],
	[ 'BBRI',  'Brieselang' ],
	[ 'BBSN',  'Briesen (Mark)' ],
	[ 'BBS',   'Brieske' ],
	[ 'XSBG',  'Brig' ],
	[ 'XSXBG', 'Brig Gr IT' ],
	[ 'ABRI',  'Brillit' ],
	[ 'EBRS',  'Brilon Stadt' ],
	[ 'EBRW',  'Brilon Wald' ],
	[ 'XIBI',  'Brindisi' ],
	[ 'XIBIM', 'Brindisi Maritt' ],
	[ 'XVBRS', 'Brinellskolan' ],
	[ 'HBIK',  'Brinkum (b Brm)' ],
	[ 'WBR',   'Britz' ],
	[ 'XABT',  'Brixen im Thale' ],
	[ 'XABX',  'Brixlegg' ],
	[ 'HB W',  'Brm Hbf ehem Bwn' ],
	[ 'HBLG',  'Brm Inland DB-Gr' ],
	[ 'HBI',   'Brm Inlandshafen' ],
	[ 'HBRS',  'Brm Stahlwerke' ],
	[ 'HBRV',  'Brm-Aumund Vulk' ],
	[ 'HBGU',  'Brm-Groll GVZUbf' ],
	[ 'YHHBG', 'Brm-Grolland SW' ],
	[ 'HBHM',  'Brm-Hemelingen' ],
	[ 'HBI F', 'Brm-Inlandshf If' ],
	[ 'HBRK',  'Brm-Kirchhuchtg.' ],
	[ 'HBKO',  'Brm-Kreinsloger' ],
	[ 'HBMU',  'Brm-Mühlenstr' ],
	[ 'HBNG',  'Brm-Neust DB-Gr' ],
	[ 'HBON',  'Brm-Oberneuland' ],
	[ 'HBOS',  'Brm-Oslebshausen' ],
	[ 'HBSC',  'Brm-Schönebeck' ],
	[ 'HBAW',  'Brm-Sebaldsb Wbf' ],
	[ 'HBSB',  'Brm-Sebaldsbrück' ],
	[ 'HBTU',  'Brm-Turnerstr' ],
	[ 'HBVG',  'Brm-Veges DB-Gr' ],
	[ 'XTBDN', 'Brno dol Nadrazi' ],
	[ 'XTBR',  'Brno hl.n.' ],
	[ 'XTBK',  'Brno Kralovo P' ],
	[ 'HBTB',  'Brochterbeck' ],
	[ 'ABRO',  'Brockel' ],
	[ 'ABRG',  'Brockel DB-Gr' ],
	[ 'LBRO',  'Brocken' ],
	[ 'HBRO',  'Brockhöfe' ],
	[ 'TBRK',  'Bröckingen' ],
	[ 'WBTF',  'Broderstorf' ],
	[ 'ZUBR',  'Brodi' ],
	[ 'XPBN',  'Brodnica' ],
	[ 'XYBO',  'Brodske' ],
	[ 'XYXBO', 'Brodske Gr CZ' ],
	[ 'XDB',   'Broenderslev' ],
	[ 'XDBN',  'Broens' ],
	[ 'KBRO',  'Brohl' ],
	[ 'KBROB', 'Brohl (Brohltb)' ],
	[ 'KBHU',  'Brohl Hfn Umschl' ],
	[ 'KBUM',  'Brohl Umladebf' ],
	[ 'HBVP',  'Broistedt Awanst' ],
	[ 'HBOI',  'Broistedt Nord' ],
	[ 'ABRS',  'Brokstedt' ],
	[ 'HBNE',  'Brome' ],
	[ 'XIBNI', 'Broni' ],
	[ 'ZWBN',  'Bronnaya Gora' ],
	[ 'TBR',   'Bronnbach' ],
	[ 'TBNL',  'Bronnen/Lauchert' ],
	[ 'XSBRH', 'Bronschhofen' ],
	[ 'LBRZ',  'Brottew Zuckerfa' ],
	[ 'TPBS',  'Brötz Sandweg' ],
	[ 'TPBW',  'Brötz Wohnlich' ],
	[ 'TPBG',  'Brötzing DB/AVG' ],
	[ 'TPB',   'Brötzingen Mitte' ],
	[ 'XIBZO', 'Brozolo' ],
	[ 'FBB',   'Bruchenbrücken' ],
	[ 'XLBB',  'Brucherberg' ],
	[ 'EBHW',  'Bruchhausen' ],
	[ 'HBHO',  'Bruchhausen Ost' ],
	[ 'RBRH',  'Bruchhsn/Ettl' ],
	[ 'HBUM',  'Bruchhsn-Marktpl' ],
	[ 'HBHV',  'Bruchhsn-Vilsen' ],
	[ 'FBK',   'Bruchköbel' ],
	[ 'HQBU',  'Bruchmühl NRW/NI' ],
	[ 'SQBU',  'Bruchmühlb-M LGr' ],
	[ 'SBUM',  'Bruchmühlb-Mies.' ],
	[ 'HBUE',  'Bruchmühlen' ],
	[ 'RBRF',  'Bruchs Schlachth' ],
	[ 'RBRD',  'Bruchs Schloßg' ],
	[ 'RBRC',  'Bruchs Stegwies' ],
	[ 'RBRE',  'Bruchs Tunnelstr' ],
	[ 'RBR',   'Bruchsal' ],
	[ 'RBRZ',  'Bruchsal GBZ' ],
	[ 'RBRR',  'Bruchsal Nord' ],
	[ 'RBRO',  'Bruchsal Ost' ],
	[ 'RBMT',  'Bruchsal-Mantel' ],
	[ 'RBRP',  'Bruchsal-Sport' ],
	[ 'SBRW',  'Bruchweiler' ],
	[ 'XABM',  'Bruck a. d. Mur' ],
	[ 'XABK',  'Bruck a.d.Leitha' ],
	[ 'XABMF', 'Bruck(Mur)Fbf' ],
	[ 'MBR',   'Bruckberg' ],
	[ 'TBRU',  'Brucken' ],
	[ 'NBRU',  'Bruckertshof' ],
	[ 'XABF',  'Bruck-Fusch' ],
	[ 'MBRM',  'Bruckmühl' ],
	[ 'KBKS',  'Bruder Klaus Sdl' ],
	[ 'BBRK',  'Brück (Mark)' ],
	[ 'LBRC',  'Brücke' ],
	[ 'EBRU',  'Brügge' ],
	[ 'WBGE',  'Brügge (Prign)' ],
	[ 'KBR',   'Brühl' ],
	[ 'KBLR',  'Brühl Brücke' ],
	[ 'KBR G', 'Brühl Gbf' ],
	[ 'KBLM',  'Brühl Mitte' ],
	[ 'KBLN',  'Brühl Nord' ],
	[ 'KBLD',  'Brühl Ost' ],
	[ 'KBR P', 'Brühl Pbf' ],
	[ 'KBLS',  'Brühl Süd' ],
	[ 'RBRW',  'Brühler Weg' ],
	[ 'KBRV',  'Brühl-Vochem' ],
	[ 'LLBR',  'Brünner Straße' ],
	[ 'XSBRU', 'Brugg AG' ],
	[ 'XBBR',  'Brugge' ],
	[ 'XFBAH', 'Brumath' ],
	[ 'XOBU',  'Brumunddal' ],
	[ 'LBRP',  'Brunau-Packeb' ],
	[ 'XIBB',  'Brunico/Bruneck' ],
	[ 'XSBNN', 'Brunnen' ],
	[ 'FBRS',  'Brunnenschneise' ],
	[ 'RBRU',  'Brunnenstück' ],
	[ 'XIBNO', 'Bruno' ],
	[ 'HBRU',  'Bruns' ],
	[ 'ABK',   'Brunsbüttel' ],
	[ 'ZWBR',  'Brusgi' ],
	[ 'XBBL',  'Bruxelles-Centr' ],
	[ 'XBBLX', 'Bruxelles-Lux' ],
	[ 'XBBM',  'Bruxelles-Marit' ],
	[ 'XBB',   'Bruxelles-Midi' ],
	[ 'XBBNL', 'Bruxelles-N-Aero' ],
	[ 'XBBN',  'Bruxelles-Nord' ],
	[ 'XBBPI', 'Brux-Petite-Ile' ],
	[ 'XVBU',  'Bruzaholm' ],
	[ 'XOBY',  'Bryne' ],
	[ 'XPBG',  'Brzeg' ],
	[ 'XPBD',  'Brzeg Dolny' ],
	[ 'XMSZS', 'B-szabadi-Sosto' ],
	[ 'RBTS',  'Bt Schulzentrum' ],
	[ 'RBTM',  'Bt Stadtmitte' ],
	[ 'RBTW',  'Bt Wannenweg' ],
	[ 'RBTR',  'Bt-Rinklingen' ],
	[ 'SBB',   'Bubach' ],
	[ 'NBTH',  'Bubenreuth' ],
	[ 'NBM',   'Buchbrunn-Mains' ],
	[ 'RBUN',  'Buchen (Odenw)' ],
	[ 'RBUO',  'Buchen Ost' ],
	[ 'FBNU',  'Buchenau (Lahn)' ],
	[ 'MBAU',  'Buchenau/Obb' ],
	[ 'MBHA',  'Buchenhain' ],
	[ 'WBUH',  'Buchenhorst' ],
	[ 'RBU',   'Buchholz (Baden)' ],
	[ 'ABLZ',  'Buchholz (Nordh)' ],
	[ 'BBUZ',  'Buchholz(Zauche)' ],
	[ 'HBUH',  'Buchhorst Abzw' ],
	[ 'MBU',   'Buchloe' ],
	[ 'XSBU',  'Buchs SG' ],
	[ 'BBUW',  'Buckow(b Beesk)' ],
	[ 'BBCH',  'Buckower Chauss' ],
	[ 'XUBB',  'Bucuresti Bane' ],
	[ 'XUBN',  'Bucuresti Nord' ],
	[ 'XUB',   'Bucuresti Obor' ],
	[ 'XPBU',  'Bucze' ],
	[ 'XMBJ',  'Buda Jozsefvaros' ],
	[ 'XMBU',  'Budafok-Haros' ],
	[ 'XMBOS', 'Budaörs' ],
	[ 'XMBR',  'Budapest Rakasr' ],
	[ 'XMBSR', 'Budapest Sorok u' ],
	[ 'XMBD',  'Budapest-Deli' ],
	[ 'XMBK',  'Budapest-Keleti' ],
	[ 'XMBO',  'Budapest-Kikötö' ],
	[ 'XMBN',  'Budapest-Nyugati' ],
	[ 'XMBDT', 'Budateteny' ],
	[ 'WBHN',  'Buddenhagen' ],
	[ 'XNB',   'Budel' ],
	[ 'FBUD',  'Budenheim' ],
	[ 'SBN',   'Bübingen' ],
	[ 'ABCH',  'Büchen' ],
	[ 'ABCHG', 'Büchen Bbf' ],
	[ 'NBUE',  'Büchenbach' ],
	[ 'NBUU',  'Büchenbach Üst' ],
	[ 'FBDH',  'Büches-Düdelshm' ],
	[ 'RBCG',  'Büchig' ],
	[ 'BBUE',  'Bückchen' ],
	[ 'HBKB',  'Bückeburg' ],
	[ 'LBUD',  'Büden' ],
	[ 'KBUE',  'Büderich' ],
	[ 'FBDR',  'Büdesh-Dromersh' ],
	[ 'FBDG',  'Büdingen (Oberh)' ],
	[ 'FBDW',  'Büdingen (Ww)' ],
	[ 'RBUE',  'Bühl (Baden)' ],
	[ 'RBNB',  'Bühl (Baden) F' ],
	[ 'XMBKK', 'Bükkösd' ],
	[ 'XSBH',  'Bülach' ],
	[ 'LBZG',  'Bülzig' ],
	[ 'HBDE',  'Bünde (Westf)' ],
	[ 'EBUE',  'Büren' ],
	[ 'FBRG',  'Bürgeln' ],
	[ 'WBGH',  'Bürgerhorst' ],
	[ 'XSBGL', 'Bürglen' ],
	[ 'FBUE',  'Bürstadt' ],
	[ 'FBUP',  'Bürstadt' ],
	[ 'EBUH',  'Büscherhof' ],
	[ 'ABUS',  'Büsenbachtal' ],
	[ 'ABSM',  'Büsum' ],
	[ 'KBUT',  'Büttgen' ],
	[ 'WB',    'Bützow' ],
	[ 'UBF',   'Bufleben' ],
	[ 'XUBF',  'Buftea' ],
	[ 'RBGG',  'Buggingen' ],
	[ 'XUBU',  'Buhaiesti' ],
	[ 'KBUH',  'Buir' ],
	[ 'KBUU',  'Buir Üst' ],
	[ 'XNBP',  'Buitenpost' ],
	[ 'XJBU',  'Bujanovac' ],
	[ 'XPBK',  'Buk' ],
	[ 'HBUK',  'Buke' ],
	[ 'XPBUB', 'Bukowina Bobr' ],
	[ 'EBUD',  'Buldern' ],
	[ 'XBBU',  'Bullange' ],
	[ 'SBY',   'Bullay DB' ],
	[ 'XFBG',  'Bully-Grenay' ],
	[ 'LBW',   'Buna Werke' ],
	[ 'LBW H', 'Buna Werke Bstg' ],
	[ 'SBTR',  'Bundenthal-Rumb.' ],
	[ 'BBUP',  'Bundesplatz' ],
	[ 'HBUN',  'Bunnen' ],
	[ 'XDBU',  'Bur' ],
	[ 'EBUR',  'Burbach' ],
	[ 'SSHI',  'Burbach Mitte' ],
	[ 'XLBD',  'Burden' ],
	[ 'LBU',   'Burg (b Mg)' ],
	[ 'ABR',   'Burg (Dithm)' ],
	[ 'ABUG',  'Burg (F) DB-Gr' ],
	[ 'FBUN',  'Burg Nord' ],
	[ 'WBSG',  'Burg Stargard' ],
	[ 'ABUW',  'Burg(F)West' ],
	[ 'MBGU',  'Burgau (Schwab)' ],
	[ 'NBUM',  'Burgbernheim' ],
	[ 'NBUS',  'Burgbernhm Stadt' ],
	[ 'NBUW',  'Burgbernh-Wildb' ],
	[ 'KBGL',  'Burgbrohl' ],
	[ 'HBGD',  'Burgdorf' ],
	[ 'XABU',  'Burgfried' ],
	[ 'NBUG',  'Burggailenreuth' ],
	[ 'NBUH',  'Burghaslach' ],
	[ 'FBUH',  'Burghaun' ],
	[ 'MBUH',  'Burghausen' ],
	[ 'MBGH',  'Burgheim' ],
	[ 'FBGH',  'Burgholzhausen' ],
	[ 'LBGK',  'Burgkemnitz' ],
	[ 'MBGK',  'Burgkirchen' ],
	[ 'NBK',   'Burgkunstadt' ],
	[ 'NBUR',  'Burglauer' ],
	[ 'NBF',   'Burglengenfeld' ],
	[ 'XEBU',  'Burgos' ],
	[ 'NBN',   'Burgsinn' ],
	[ 'NBNB',  'Burgsinn Bbf' ],
	[ 'DBU',   'Burgstädt' ],
	[ 'TBU',   'Burgstall (Murr)' ],
	[ 'NBUT',  'Burgthann' ],
	[ 'FBNG',  'Burg-u Nd Gemünd' ],
	[ 'ABWD',  'Burgwedel' ],
	[ 'NROS',  'Burgweinting' ],
	[ 'HBUR',  'Burhafe' ],
	[ 'DBWD',  'Burkhardsw-Maxen' ],
	[ 'DBUM',  'Burkhardtsd Mi' ],
	[ 'DBUF',  'Burkhardtsdorf' ],
	[ 'RBBN',  'Burkheim-Bisch.' ],
	[ 'TBLD',  'Burladingen' ],
	[ 'TBLW',  'Burladingen West' ],
	[ 'XIBUL', 'Busalla' ],
	[ 'EBAH',  'Buschh Achenbach' ],
	[ 'EBSG',  'Buschh Siemag' ],
	[ 'LBOW',  'Buschow' ],
	[ 'EBUS',  'Buschstraße' ],
	[ 'RBUS',  'Busenbach' ],
	[ 'SBNS',  'Busenb-Schindh' ],
	[ 'ZUBU',  'Bushtino' ],
	[ 'XFBS',  'Busigny' ],
	[ 'XSBUS', 'Bussnang' ],
	[ 'XIBU',  'Busto Arsizio' ],
	[ 'NBT',   'Buttenheim' ],
	[ 'UBU',   'Buttstädt' ],
	[ 'UQBU',  'Buttstädt TH/ST' ],
	[ 'FBZ',   'Butzbach' ],
	[ 'FBZN',  'Butzbach Nord' ],
	[ 'FBZO',  'Butzbach Ost' ],
	[ 'MBUX',  'Buxheim' ],
	[ 'ABX',   'Buxtehude' ],
	[ 'ABXG',  'Buxtehude DB-Gr' ],
	[ 'YHHBH', 'Buxtehude Strw' ],
	[ 'ABXS',  'Buxtehude Süd' ],
	[ 'XRBU',  'Buzet' ],
	[ 'XUBUZ', 'Buzias' ],
	[ 'WRSB',  'Bw Rost Seehafen' ],
	[ 'XVBYA', 'Byarum' ],
	[ 'XPBY',  'Bydgoszcz Gl' ],
	[ 'XTBS',  'Bysice' ],
	[ 'XICIG', 'C.Isarco/Gossens' ],
	[ 'UCA',   'Caaschwitz' ],
	[ 'XYCA',  'Cadca' ],
	[ 'XSCZ',  'Cadenazzo' ],
	[ 'ACD',   'Cadenberge' ],
	[ 'NCA',   'Cadolzburg' ],
	[ 'DCDF',  'Cainsdorf' ],
	[ 'DBAC',  'Cainsdorf Awanst' ],
	[ 'XICMT', 'Cairo Montenotte' ],
	[ 'XRC',   'Cakovec' ],
	[ 'XFCK',  'Calais Ville' ],
	[ 'XFFE',  'Calais-Frethun' ],
	[ 'XFCI',  'Calais-Maritime' ],
	[ 'XICD',  'Calamandrana' ],
	[ 'BC',    'Calau (Niederl)' ],
	[ 'LCBO',  'Calbe (S) Ost' ],
	[ 'LCBW',  'Calbe (S) West' ],
	[ 'HCAL',  'Calberlah' ],
	[ 'XECM',  'Caldas de M.' ],
	[ 'FCLD',  'Caldern' ],
	[ 'XECL',  'Caldetas-S Vicen' ],
	[ 'XECA',  'Calella' ],
	[ 'TCA',   'Calmbach' ],
	[ 'TCAS',  'Calmbach Süd' ],
	[ 'XICA',  'Caltagirone' ],
	[ 'XICL',  'Caltanissetta C.' ],
	[ 'FCX',   'Caltex' ],
	[ 'TCW',   'Calw' ],
	[ 'XICBS', 'Cambiano-Santena' ],
	[ 'UCB',   'Camburg (Saale)' ],
	[ 'WCA',   'Cammin (Meckl)' ],
	[ 'XECT',  'Camp de Tarragon' ],
	[ 'XICPM', 'Campiglia Marit.' ],
	[ 'XICTF', 'Campo d Tr/Freif' ],
	[ 'XICLM', 'Campo Ligure-M' ],
	[ 'XICN',  'Cancello' ],
	[ 'XICLL', 'Candia Lomellina' ],
	[ 'XICGR', 'Canegrate' ],
	[ 'XICNI', 'Canelli' ],
	[ 'XICC',  'Canicatti' ],
	[ 'XFCA',  'Cannes' ],
	[ 'XFCB',  'Cannes la Bocca' ],
	[ 'XICNL', 'Cantalupo' ],
	[ 'ECP',   'Capelle (Westf)' ],
	[ 'XLCP',  'Capellen' ],
	[ 'ZBCA',  'Capljina' ],
	[ 'XSCR',  'Capolago-Riva S' ],
	[ 'TCP',   'Cappel' ],
	[ 'TCP A', 'Cappel AVG-Anlag' ],
	[ 'BSIS',  'Caputh Schwielow' ],
	[ 'BCAP',  'Caputh-Geltow' ],
	[ 'XUCC',  'Caracal' ],
	[ 'XUCS',  'Caransebes' ],
	[ 'XFCAB', 'Carbonne' ],
	[ 'XFCN',  'Carcassonne' ],
	[ 'XICRT', 'Carentino' ],
	[ 'XICR',  'Cariati' ],
	[ 'XICAR', 'Carimate' ],
	[ 'WCAH',  'Carlshöhe' ],
	[ 'XICMG', 'Carmagnola' ],
	[ 'XFCNO', 'Carnoules' ],
	[ 'XICV',  'Carovigno' ],
	[ 'XXCB',  'Casa Branca' ],
	[ 'XICMF', 'Casale Monfer' ],
	[ 'XICAM', 'Casalmaggiore' ],
	[ 'XICP',  'Casalpusterlengo' ],
	[ 'XICSA', 'Casarsa' ],
	[ 'WCW',   'Casekow' ],
	[ 'XICS',  'Caserta' ],
	[ 'XICSS', 'Casorate Semp' ],
	[ 'XICSI', 'Cassine' ],
	[ 'XICAS', 'Cassino' ],
	[ 'XICDL', 'Castagnole d L' ],
	[ 'XICGG', 'Casteggio' ],
	[ 'XICAB', 'Castel Bolognese' ],
	[ 'XICSG', 'Castel S Giov' ],
	[ 'XICB',  'Casteld./Ehrenb.' ],
	[ 'XICAE', 'Castelfranco Em' ],
	[ 'XICAG', 'Castelguelfo' ],
	[ 'XICAF', 'Castell\' Alfero' ],
	[ 'XICLC', 'Castellazzo-C' ],
	[ 'XICT',  'Castello' ],
	[ 'XICLA', 'Castello d\'Annon' ],
	[ 'XICM',  'Castelmaggiore' ],
	[ 'XFCAN', 'Castelnaudary' ],
	[ 'XICNB', 'Castelnuovo B' ],
	[ 'XICLR', 'Castelrosso' ],
	[ 'XICSP', 'Castelspina-P' ],
	[ 'XSCA',  'Castione-Arbedo' ],
	[ 'XICTC', 'Catania C' ],
	[ 'XICZ',  'Catanzaro' ],
	[ 'XICZL', 'Catanzaro Lido' ],
	[ 'XICO',  'Cattolica S Gio.' ],
	[ 'XICCB', 'Cava Carbonara' ],
	[ 'XICTI', 'Cava Tigozzi' ],
	[ 'XICVB', 'Cavagnolo-Br' ],
	[ 'XFCAV', 'Cavaillon' ],
	[ 'XICVM', 'Cavallermaggiore' ],
	[ 'XXCX',  'Caxarias' ],
	[ 'XICF',  'Cefalu' ],
	[ 'XMCD',  'Celldömölk' ],
	[ 'HC',    'Celle' ],
	[ 'XICEL', 'Celle IT' ],
	[ 'HC G',  'Celle Gbf' ],
	[ 'HCN',   'Celle Nord' ],
	[ 'HCNG',  'Celle Nord DB-Gr' ],
	[ 'HCVO',  'Celle Vorstadt' ],
	[ 'XICNG', 'Cengio' ],
	[ 'XICTL', 'Centallo' ],
	[ 'XFCEN', 'Centron' ],
	[ 'XLCS',  'Cents-Hamm' ],
	[ 'XFCE',  'Cerbere' ],
	[ 'XTCEC', 'Cercany' ],
	[ 'XQCK',  'Cerkezköy' ],
	[ 'XTCES', 'Cernosice' ],
	[ 'XTCC',  'Cernovice u Ch' ],
	[ 'XTCVT', 'Cernovice u Tabo' ],
	[ 'XTCKO', 'Cerveny Kostelec' ],
	[ 'XICMM', 'Cervia-Mil Marit' ],
	[ 'XICER', 'Cervignano AG' ],
	[ 'XICE',  'Cesena' ],
	[ 'XICES', 'Cesenatico' ],
	[ 'XTCKA', 'Ceska Kamenice' ],
	[ 'XTC',   'Ceska Kubice' ],
	[ 'XTCL',  'Ceska Lipa hl.n.' ],
	[ 'XTCLS', 'Ceska Lipa Strel' ],
	[ 'XTCSK', 'Ceska Skalice' ],
	[ 'XTTR',  'Ceska Trebova' ],
	[ 'XTCB',  'Ceske Budejovice' ],
	[ 'XTCV',  'Ceske Velenice' ],
	[ 'XTCK',  'Cesky Tesin' ],
	[ 'XICVA', 'Ceva' ],
	[ 'XFCEV', 'Cevins' ],
	[ 'ECFS',  'CF Schulzentrum' ],
	[ 'XFCM',  'Chalons en Champ' ],
	[ 'XFCS',  'Chalon-sur-Saone' ],
	[ 'NCH',   'Cham (Oberpf)' ],
	[ 'NKUW',  'Cham (Oberpf) K' ],
	[ 'NCHM',  'Cham Müll' ],
	[ 'NCH S', 'Cham Schwedensch' ],
	[ 'XFCY',  'Chambery' ],
	[ 'NCHA',  'Chamerau' ],
	[ 'XFCV',  'Champag-Ardennes' ],
	[ 'XFCG',  'Champigneulles' ],
	[ 'XBCH',  'Charleroi-Sud' ],
	[ 'BCHG',  'Charlottbg Abzw' ],
	[ 'XVCG',  'Charlottenbg Gr' ],
	[ 'BCHS',  'Charlottenbg S-B' ],
	[ 'BCL',   'Charlottenhof OL' ],
	[ 'XFCHY', 'Charny (Yonne)' ],
	[ 'XFCAR', 'Chat Arnoux St A' ],
	[ 'XFCIR', 'Chateau Gontier' ],
	[ 'XFCD',  'Chateau-du-Loir' ],
	[ 'XFCX',  'Chateauroux' ],
	[ 'XFCT',  'Chateau-Thierry' ],
	[ 'XBCL',  'Chatelet' ],
	[ 'XFCUO', 'Chauconin' ],
	[ 'XFCH',  'Chauny' ],
	[ 'XTCH',  'Cheb' ],
	[ 'XTCS',  'Cheb-Skalka' ],
	[ 'XCTK',  'Cheliabinsk' ],
	[ 'XFCSG', 'Chelles-Gournay' ],
	[ 'XPCH',  'Chelm' ],
	[ 'XPCK',  'Chelmek' ],
	[ 'XPCM',  'Chelmza' ],
	[ 'DCHG',  'Chemn Hbf DB-Gr' ],
	[ 'DCKI',  'Chemn Kinderw' ],
	[ 'DCZW',  'Chemn Zwönitzbr' ],
	[ 'DCBH',  'Chemn-Borna Hp' ],
	[ 'DCE',   'Chemn-Erfenschl' ],
	[ 'YLLCI', 'Chemn-Hilb Strw' ],
	[ 'DC',    'Chemnitz Hbf' ],
	[ 'DCM',   'Chemnitz Mitte' ],
	[ 'DCSG',  'Chemnitz S DB-Gr' ],
	[ 'DCS',   'Chemnitz Süd' ],
	[ 'DCD',   'Chemnitz Süd Hp' ],
	[ 'DCHA',  'Chemnitz-Harthau' ],
	[ 'DCHP',  'Chemnitz-Hilb Hp' ],
	[ 'DCC',   'Chemnitz-Schönau' ],
	[ 'DCSI',  'Chemnitz-Siegmar' ],
	[ 'DCRE',  'Chemn-Reichenh' ],
	[ 'XFCGG', 'Chenay-Gagny' ],
	[ 'XBCE',  'Chenee' ],
	[ 'XFCHB', 'Cherbourg' ],
	[ 'ZUCK',  'Cherkassy' ],
	[ 'ZUCG',  'Chernigov' ],
	[ 'ZUCL',  'Chernolesskaia' ],
	[ 'XBCT',  'Chertal' ],
	[ 'XCCH',  'Chertkovo' ],
	[ 'XWCB',  'Cherven Brjag' ],
	[ 'XSCH',  'Chiasso' ],
	[ 'XSCC',  'Chiasso Cargo' ],
	[ 'XSCT',  'Chiasso CT' ],
	[ 'XSXCH', 'Chiasso Gr IT' ],
	[ 'XSCHT', 'Chiasso Transito' ],
	[ 'XICI',  'Chiavari' ],
	[ 'XICH',  'Chieti' ],
	[ 'XICK',  'Chiusa/Klausen' ],
	[ 'XICCS', 'Chiusano-Cossom' ],
	[ 'XICU',  'Chiusi-Chianci.T' ],
	[ 'XICHV', 'Chivasso' ],
	[ 'ZUCM',  'Chmelnickij' ],
	[ 'XTCE',  'Chocen' ],
	[ 'XPCL',  'Chociwel' ],
	[ 'XTCD',  'Chodov' ],
	[ 'XPCO',  'Chojnice' ],
	[ 'XPCJ',  'Chojnow' ],
	[ 'XTCO',  'Chomutov' ],
	[ 'XTCM',  'Chomutov Mesto' ],
	[ 'ZUC',   'Chop' ],
	[ 'WCO',   'Chorin' ],
	[ 'WCOK',  'Chorin Hp' ],
	[ 'XTCN',  'Chornice' ],
	[ 'XTCOT', 'Chotebor' ],
	[ 'XTCT',  'Chotetov' ],
	[ 'XTCY',  'Chotyne' ],
	[ 'XTCHC', 'Chrast u Chrudim' ],
	[ 'XTCP',  'Chrast u Plzne' ],
	[ 'XTCR',  'Chrastava' ],
	[ 'XTCA',  'Chrastava-And H' ],
	[ 'XTCHR', 'Chribska' ],
	[ 'XPCA',  'Chrosnica' ],
	[ 'XTCU',  'Chrudim' ],
	[ 'XSC',   'Chur' ],
	[ 'XTCHV', 'Chvalkov' ],
	[ 'XUCI',  'Ciceu' ],
	[ 'XPCIW', 'Ciechanow' ],
	[ 'XPCI',  'Ciemnice' ],
	[ 'XYCT',  'Cierna nad Tisou' ],
	[ 'XUCP',  'Cimpulung' ],
	[ 'XUCM',  'Cimpulung Moldov' ],
	[ 'XFCIG', 'Cintegabelle' ],
	[ 'XTCI',  'Citice' ],
	[ 'XUCL',  'Ciulnita' ],
	[ 'XICIV', 'Civitanova Mar.M' ],
	[ 'XICVV', 'Civitavecchia' ],
	[ 'ECOH',  'Clarholz' ],
	[ 'DCL',   'Clausnitz' ],
	[ 'XFCLE', 'Clermont-Ferrand' ],
	[ 'XFCL',  'Clerval' ],
	[ 'XLCV',  'Clervaux' ],
	[ 'HCLG',  'Cloppenb DB-Gr' ],
	[ 'HCLP',  'Cloppenburg' ],
	[ 'NC',    'Coburg' ],
	[ 'NCG',   'Coburg Gbf' ],
	[ 'NCN',   'Coburg Nord' ],
	[ 'NCNS',  'Coburg-Neuses' ],
	[ 'XICOC', 'Cocconato' ],
	[ 'SCOC',  'Cochem (Mosel)' ],
	[ 'XFCO',  'Cocheren' ],
	[ 'ECMF',  'Coesfeld (Westf)' ],
	[ 'XNCV',  'Coevorden' ],
	[ 'HCV',   'Coevorden BE' ],
	[ 'FCOE',  'Cölbe' ],
	[ 'XECV',  'Collado Villalba' ],
	[ 'NRF',   'Collenberg' ],
	[ 'XFCLL', 'Collioure' ],
	[ 'LCB',   'Collmen-Böhlitz' ],
	[ 'XFC',   'Colmar' ],
	[ 'XLCU',  'Colmar Usines' ],
	[ 'XLCB',  'Colmar-Berg' ],
	[ 'XUCT',  'Comanesti' ],
	[ 'XFCQ',  'Combs la Ville-Q' ],
	[ 'XIC',   'Como S.G.' ],
	[ 'XFCP',  'Compiegne' ],
	[ 'ASDC',  'Condea' ],
	[ 'XICGL', 'Conegliano' ],
	[ 'XFCF',  'Conflans-Jarny' ],
	[ 'WCOR',  'Consrade' ],
	[ 'SCN',   'Contwig' ],
	[ 'HCOP',  'Coppenbrügge' ],
	[ 'LCZ',   'Coppiplatz' ],
	[ 'XFCOM', 'Corbehem' ],
	[ 'XFCOE', 'Corbeil-Essones' ],
	[ 'XICST', 'Corbetta S Stef' ],
	[ 'XKC',   'Corby GEFCO' ],
	[ 'HCOR',  'Cordingen' ],
	[ 'XSCO',  'Cornaux' ],
	[ 'FCG',   'Cornberg' ],
	[ 'BCO',   'Coschen' ],
	[ 'XFCOS', 'Cosne' ],
	[ 'DCB',   'Cossebaude' ],
	[ 'DCO',   'Cossen' ],
	[ 'XSCS',  'Cossonay' ],
	[ 'XICIM', 'Costigliole (M d' ],
	[ 'XICIA', 'Costigliole d\'A' ],
	[ 'LCWG',  'Coswig (Anh) Gbf' ],
	[ 'LCW',   'Coswig (Anh) Hp' ],
	[ 'DCW',   'Coswig (bei Dre)' ],
	[ 'DCW B', 'Coswig Stw 1' ],
	[ 'BCS',   'Cottbus' ],
	[ 'BCSB',  'Cottbus Cbn' ],
	[ 'BCSF',  'Cottbus Cfw' ],
	[ 'BCSS',  'Cottbus Südwest' ],
	[ 'BCS Z', 'Cottbus W 10' ],
	[ 'BCS W', 'Cottbus W 9' ],
	[ 'BCSO',  'Cottbus-Sandow' ],
	[ 'XFCOL', 'Coulommiers' ],
	[ 'XFCSN', 'Courcelles s N' ],
	[ 'XFCOU', 'Coutras' ],
	[ 'XXCO',  'Covilha' ],
	[ 'XICOZ', 'Cozzo' ],
	[ 'TC',    'Crailsheim' ],
	[ 'TQC',   'Crailsheim BW/BY' ],
	[ 'ECRA',  'Crange' ],
	[ 'DCR',   'Cranzahl' ],
	[ 'XUCN',  'Crasna' ],
	[ 'ECA',   'C-Rauxel Hbf' ],
	[ 'ECAS',  'C-Rauxel Süd' ],
	[ 'ECASP', 'C-Rauxel Süd Hp' ],
	[ 'ECME',  'C-Rauxel-Merkl' ],
	[ 'UCL',   'Crawinkel' ],
	[ 'NCR',   'Creidlitz' ],
	[ 'XFCR',  'Creil' ],
	[ 'XICRA', 'Cremona' ],
	[ 'XICSC', 'Crescentino' ],
	[ 'NCRE',  'Creußen (Oberfr)' ],
	[ 'XFCW',  'Creutzwald' ],
	[ 'XICRE', 'Crevalcore' ],
	[ 'XKCR',  'Crewe' ],
	[ 'DCU',   'Crimmitschau' ],
	[ 'WCZ',   'Crivitz' ],
	[ 'UKS',   'Crossen (Elster)' ],
	[ 'UKSO',  'Crossen Ort' ],
	[ 'XICRO', 'Crotone' ],
	[ 'HCRA',  'Croya' ],
	[ 'XLCT',  'Cruchten' ],
	[ 'XJCK',  'Crveni Krst' ],
	[ 'XMC',   'Csajag' ],
	[ 'BMZD',  'Cs-Merzdorf' ],
	[ 'XMCN',  'Csor-Nadasdladan' ],
	[ 'XMCO',  'Csorvas' ],
	[ 'BWDF',  'Cs-Willmersdf N' ],
	[ 'XFCU',  'Culmont-Chalind' ],
	[ 'XFCZ',  'Culoz' ],
	[ 'XICUN', 'Cuneo' ],
	[ 'XICSZ', 'Cunico-Scandel' ],
	[ 'DCF',   'Cunnersdorf b Ka' ],
	[ 'UCF',   'Cursdorf' ],
	[ 'XUCA',  'Curtea de Arges' ],
	[ 'XUCU',  'Curtici' ],
	[ 'ACV M', 'Cux Amerika Bf' ],
	[ 'ACV',   'Cuxhaven' ],
	[ 'ACV F', 'Cuxhaven CF' ],
	[ 'ACVG',  'Cuxhaven DB-Gr' ],
	[ 'ACV G', 'Cuxhaven Gbf' ],
	[ 'XICZZ', 'Cuzzago' ],
	[ 'ZUCV',  'Cvetkovo' ],
	[ 'ECWH',  'CWH' ],
	[ 'XPCY',  'Czarnowasy' ],
	[ 'XPCD',  'Czechowice-Dzied' ],
	[ 'XPCZ',  'Czeremcha' ],
	[ 'XPCW',  'Czerwiensk' ],
	[ 'XPCWA', 'Czerwonka' ],
	[ 'XPCS',  'Czestoch Stradom' ],
	[ 'XPC',   'Czestochowa Osob' ],
	[ 'KDA',   'D Abstellbf' ],
	[ 'KDFF',  'D Flughafen' ],
	[ 'KDFFH', 'D Flughafen Hp' ],
	[ 'KDF',   'D Flughafen Term' ],
	[ 'KDF A', 'D Flughf W 884' ],
	[ 'KDH',   'D Hafen' ],
	[ 'KDU K', 'D Karthäuser Weg' ],
	[ 'KDVS',  'D Völklinger Str' ],
	[ 'KDV',   'D Volksgarten' ],
	[ 'KDW',   'D Wehrhahn' ],
	[ 'FDAL',  'Da Lichtwiese' ],
	[ 'EDAD',  'Daaden' ],
	[ 'FDA',   'Da-Arheilgen' ],
	[ 'WDL',   'Dabel' ],
	[ 'BDAB',  'Dabendorf' ],
	[ 'XPDGO', 'Dabrowa Gornica' ],
	[ 'MDA',   'Dachau Bahnhof' ],
	[ 'MDAS',  'Dachau Stadt' ],
	[ 'UDA',   'Dachrieden' ],
	[ 'XSDA',  'Dachsen' ],
	[ 'TDA',   'Dachswald' ],
	[ 'UDW',   'Dachwig' ],
	[ 'FDE N', 'Da-Eberst Nord' ],
	[ 'FDE',   'Da-Eberstadt' ],
	[ 'ADBH',  'Dagebüll Hafen' ],
	[ 'ADBK',  'Dagebüll Kirche' ],
	[ 'ADM',   'Dagebüll Mole' ],
	[ 'XSDS',  'Dagmersellen' ],
	[ 'EDHL',  'Dahl' ],
	[ 'EDAB',  'Dahlbruch' ],
	[ 'KDAM',  'Dahlem (Eifel)' ],
	[ 'KQDA',  'Dahlem NRW/RP' ],
	[ 'LDA',   'Dahlen (Sachs)' ],
	[ 'ADL',   'Dahlenburg' ],
	[ 'EDAK',  'Dahlerbrück' ],
	[ 'BDT',   'Dahlewitz' ],
	[ 'HDAG',  'Dahlinghausen' ],
	[ 'SDA',   'Dahn' ],
	[ 'SDAS',  'Dahn Süd' ],
	[ 'FDK',   'Da-Kranichstein' ],
	[ 'XADA',  'Dalaas' ],
	[ 'XOD',   'Dale' ],
	[ 'XWDP',  'Dalgopol' ],
	[ 'KDAL',  'Dalheim' ],
	[ 'KXD',   'Dalheim Grenze' ],
	[ 'RDL',   'Dallau' ],
	[ 'ADA',   'Dalldorf' ],
	[ 'BDL',   'Dallgow' ],
	[ 'KETD',  'Dalli' ],
	[ 'WDF',   'Dalwitzhof' ],
	[ 'WDF N', 'Dalwitzhof Nordk' ],
	[ 'RDA',   'Dammerstock' ],
	[ 'ADST',  'Dammtor (S-Bahn)' ],
	[ 'XSDN',  'Däniken' ],
	[ 'ADBG',  'Dannenb O DB-Gr' ],
	[ 'ADB',   'Dannenberg Ost' ],
	[ 'ADW',   'Dannenberg West' ],
	[ 'WDWE',  'Dannenwalde' ],
	[ 'MDAR',  'Darching' ],
	[ 'LDAR',  'Darlingerode' ],
	[ 'FD G',  'Darmstadt Gbf' ],
	[ 'FD',    'Darmstadt Hbf' ],
	[ 'FDN',   'Darmstadt Nord' ],
	[ 'FDO',   'Darmstadt Ost' ],
	[ 'FDS',   'Darmstadt Süd' ],
	[ 'WDAZ',  'Darze' ],
	[ 'MDAG',  'Dasing' ],
	[ 'HDAS',  'Dassel' ],
	[ 'EDAT',  'Datteln' ],
	[ 'KDAT',  'Dattenfeld(Sieg)' ],
	[ 'ADH',   'Dauenhof' ],
	[ 'SDF',   'Daufenbach' ],
	[ 'ZTDA',  'Daugavpils' ],
	[ 'SDAU',  'Daun' ],
	[ 'FDSU',  'Dausenau' ],
	[ 'EDVB',  'Davensberg' ],
	[ 'XSDD',  'Davos Dorf' ],
	[ 'XSDP',  'Davos Platz' ],
	[ 'FWX',   'Da-Wixhausen' ],
	[ 'XFDX',  'Dax' ],
	[ 'TXOH',  'DB/ENAG' ],
	[ 'KDBE',  'D-Benrath' ],
	[ 'KDBI',  'D-Bilk' ],
	[ 'KDBH',  'D-Bilk Hp' ],
	[ 'KDD',   'D-Derendorf' ],
	[ 'KDD O', 'D-Derendorf Dn' ],
	[ 'KDD N', 'D-Derendorf Dnf' ],
	[ 'KDDP',  'D-Derendorf Dp' ],
	[ 'KDDH',  'D-Derendorf Hp' ],
	[ 'XNDE',  'De Eschmarke' ],
	[ 'XPDA',  'Deba Opoczynska' ],
	[ 'ZUDB',  'Debalcevo' ],
	[ 'XPDB',  'Debica' ],
	[ 'XPDL',  'Deblin' ],
	[ 'XMD',   'Debrecen' ],
	[ 'XMDC',  'Debrecen-Csapok' ],
	[ 'XTD',   'Decin hl.n.' ],
	[ 'XTDN',  'Decin hl.n.nak.n' ],
	[ 'XTDVH', 'Decin vych horni' ],
	[ 'XTDV',  'Decin vychod' ],
	[ 'XTD Z', 'Decin zapad.n.' ],
	[ 'XTDC',  'Decin-Certova V' ],
	[ 'XTDPR', 'Decin-Priper' ],
	[ 'XTDP',  'Decin-Prost Zleb' ],
	[ 'XUDD',  'Deda' ],
	[ 'HDET',  'Dedelstorf' ],
	[ 'HDEH',  'Dedenhausen' ],
	[ 'HDED',  'Dedensen-Gümmer' ],
	[ 'EDED',  'Dedinghausen' ],
	[ 'DSCU',  'Dedores GmbH' ],
	[ 'XCDD',  'Dedovichi' ],
	[ 'ADZB',  'Deezbüll' ],
	[ 'NTWD',  'Degg Textilwerke' ],
	[ 'NDHG',  'Deggend Ha DB-Gr' ],
	[ 'NWTE',  'Deggend W 1 u 3' ],
	[ 'NWTZ',  'Deggend Werft 2' ],
	[ 'NDH',   'Deggendorf Hafen' ],
	[ 'NDG',   'Deggendorf Hbf' ],
	[ 'TDGM',  'Degmarn' ],
	[ 'XIDG',  'Dego' ],
	[ 'HDEI',  'Deichhausen' ],
	[ 'MADG',  'Deichmann' ],
	[ 'RDM',   'Deidesheim' ],
	[ 'NDE',   'Deining (Oberpf)' ],
	[ 'ADS',   'Deinste' ],
	[ 'MDS',   'Deisenhofen' ],
	[ 'TDL',   'Deißlingen' ],
	[ 'TDLM',  'Deißlingen Mitte' ],
	[ 'XUDC',  'Dej Calatori' ],
	[ 'XNDD',  'Delden' ],
	[ 'XSDE',  'Delemont' ],
	[ 'XNDT',  'Delft' ],
	[ 'XNDZ',  'Delfzijl' ],
	[ 'LDLG',  'Delitzsch Gbf' ],
	[ 'LDLO',  'Delitzsch ob Bf' ],
	[ 'LAH',   'Delitzsch uBf Ah' ],
	[ 'LDL',   'Delitzsch unt Bf' ],
	[ 'KDEM',  'D-Eller Mitte' ],
	[ 'KDES',  'D-Eller Süd' ],
	[ 'SDE',   'Dellfeld' ],
	[ 'SDEO',  'Dellfeld Ort' ],
	[ 'HD',    'Delmenhorst' ],
	[ 'HD F',  'Delmenhorst Df' ],
	[ 'HDG',   'Delmenhorst Gr' ],
	[ 'HDSU',  'Delmenhorst Süd' ],
	[ 'HQD',   'DelmenhorstNI/HB' ],
	[ 'XRDN',  'Delnice' ],
	[ 'EBTND', 'Delog/Detag' ],
	[ 'XVDJ',  'Delsjömotet' ],
	[ 'DDT',   'Demitz-Thumitz' ],
	[ 'LDK',   'Demker' ],
	[ 'WDM',   'Demmin' ],
	[ 'XNDH',  'Den Haag C' ],
	[ 'XNDHH', 'Den Haag HS' ],
	[ 'XNDL',  'Den Helder' ],
	[ 'XBDL',  'Denderleeuw' ],
	[ 'MDKL',  'Denklingen/Schw' ],
	[ 'DDZ',   'Dennheritz' ],
	[ 'SDBO',  'Densborn' ],
	[ 'RDZ',   'Denzlingen' ],
	[ 'WDN',   'Dergenthin' ],
	[ 'XQD',   'Derince' ],
	[ 'KDEK',  'Derkum' ],
	[ 'KDEA',  'Dernau' ],
	[ 'KDEB',  'Dernbach/Westerw' ],
	[ 'HDBG',  'Derneburg (Han)' ],
	[ 'XVDE',  'Derome' ],
	[ 'XTDS',  'Desenice' ],
	[ 'XIDS',  'Desenzano G S' ],
	[ 'XIDE',  'Desio' ],
	[ 'XTDE',  'Desna' ],
	[ 'XTDEP', 'Desna-Pustinska' ],
	[ 'XTDER', 'Desna-Riedl vila' ],
	[ 'LDME',  'Dessau Abus Werk' ],
	[ 'LDAD',  'Dessau Adria' ],
	[ 'LDWG',  'Dessau DB-Gr' ],
	[ 'LD G',  'Dessau Gbf' ],
	[ 'LD',    'Dessau Hbf' ],
	[ 'LDWM',  'Dessau Kreisbaub' ],
	[ 'LDS',   'Dessau Süd' ],
	[ 'LDWB',  'Dessau Waggonbau' ],
	[ 'LDAL',  'Dessau-Alten' ],
	[ 'LDBR',  'Dessauer Brücke' ],
	[ 'LDMO',  'Dessau-Mosigkau' ],
	[ 'WD',    'Dessow (Mark)' ],
	[ 'XTDT',  'Destinice' ],
	[ 'HDTL',  'Dethlingen' ],
	[ 'EDTM',  'Detmold' ],
	[ 'NDEB',  'Dettelbach Bf' ],
	[ 'TDH',   'Dettenhausen' ],
	[ 'FDET',  'Dettingen (Main)' ],
	[ 'TDT',   'Dettingen (Teck)' ],
	[ 'TDTUF', 'Dettingen Freib' ],
	[ 'TDTUG', 'Dettingen Gsaidt' ],
	[ 'TDTUL', 'Dettingen Lehen' ],
	[ 'TDTU',  'Dettingen Mitte.' ],
	[ 'TDTW',  'Dettingen(E)Wigg' ],
	[ 'HDEM',  'Dettum' ],
	[ 'XFDEE', 'Dettwiller' ],
	[ 'LDB',   'Deuben (b Zeitz)' ],
	[ 'NDN',   'Deuerling' ],
	[ 'EDSN',  'Deusen /Dortm' ],
	[ 'EDEU',  'Deuten' ],
	[ 'ADEV',  'Deutsch Evern' ],
	[ 'DDB',   'Deutschenbora' ],
	[ 'LDTZ',  'Deutzen' ],
	[ 'EDEZ',  'Deuz (Kr Siegen)' ],
	[ 'XUD',   'Deva' ],
	[ 'XMDV',  'Devecser' ],
	[ 'XNDV',  'Deventer' ],
	[ 'XFDE',  'Deville l Rouen' ],
	[ 'XYDN',  'DevinskaNovaVes' ],
	[ 'EDFD',  'Dfd /Dortmund' ],
	[ 'KDFL',  'D-Flingern' ],
	[ 'KDFS',  'D-Friedrichstadt' ],
	[ 'KDGA',  'D-Garath' ],
	[ 'KDGG',  'D-Gerresh DB-Gr' ],
	[ 'KDGE',  'D-Gerresheim' ],
	[ 'KDGR',  'D-Grafenberg' ],
	[ 'KDHL',  'D-Hellerhof' ],
	[ 'XGDK',  'Diakofto' ],
	[ 'LKZU',  'Diamant-Zuckfabr' ],
	[ 'XIDM',  'Diano Marina' ],
	[ 'HDHB',  'Dibbersen(b Brm)' ],
	[ 'KDSH',  'Dickscheheide' ],
	[ 'NDIE',  'Diebach' ],
	[ 'ADT',   'Diebsteich' ],
	[ 'FDI',   'Dieburg' ],
	[ 'RBTD',  'Diedelsheim' ],
	[ 'BDDF',  'Diedersdorf' ],
	[ 'MDID',  'Diedorf (Schwab)' ],
	[ 'HDI',   'Diekholzen' ],
	[ 'XLDK',  'Diekirch' ],
	[ 'XFDM',  'Diemeringen' ],
	[ 'BACO',  'Diepensee C' ],
	[ 'HDIP',  'Diepholz' ],
	[ 'KDI',   'Dieringhausen' ],
	[ 'LDI',   'Dieskau' ],
	[ 'MDIN',  'Dießen' ],
	[ 'XSDH',  'Diessenhofen' ],
	[ 'XSDHS', 'Diessenhofen S' ],
	[ 'EDTD',  'Diestedde' ],
	[ 'FDIE',  'Dietershan' ],
	[ 'NDT',   'Dietersheim' ],
	[ 'MDF',   'Dietfurt (Rott)' ],
	[ 'XADI',  'Dietfurth' ],
	[ 'XSD',   'Dietlikon' ],
	[ 'MDRD',  'Dietmannsried' ],
	[ 'RVLD',  'Dietrich' ],
	[ 'RDB',   'Dietzelbach' ],
	[ 'FDZ',   'Dietzenbach Bf' ],
	[ 'FDZM',  'Dietzenb-Mitte' ],
	[ 'FDZS',  'Dietzenb-Steinb' ],
	[ 'UDN',   'Dietzhausen' ],
	[ 'XFDI',  'Dieulouard' ],
	[ 'FDIZ',  'Diez' ],
	[ 'FDIO',  'Diez Ost' ],
	[ 'FQDI',  'Diez Ost RP/HE' ],
	[ 'XLDI',  'Differdange' ],
	[ 'XFD',   'Dijon' ],
	[ 'XFDP',  'Dijon Perrigny' ],
	[ 'XFDN',  'Dijon PN' ],
	[ 'XGD',   'Dikea' ],
	[ 'SDLAP', 'Dill Ford W 211' ],
	[ 'SDLAF', 'Dill Ford W 221' ],
	[ 'SDLAR', 'Dill Ford/Röderb' ],
	[ 'SDLOA', 'Dill Ost W 202' ],
	[ 'SDLOB', 'Dill Ost W 203' ],
	[ 'SDLOC', 'Dill Ost W 205' ],
	[ 'SDLR',  'Dill Röderberg' ],
	[ 'SDLZ',  'Dill Zentralkok' ],
	[ 'SDLH',  'Dill.Hochofen Hü' ],
	[ 'FDBT',  'Dillbrecht' ],
	[ 'FDST',  'Dillenb Stahlw' ],
	[ 'FDILS', 'Dillenbg Stw Ds' ],
	[ 'FDIL',  'Dillenburg' ],
	[ 'SDFG',  'Dilling DB/Ford' ],
	[ 'SDL',   'Dillingen (Saar)' ],
	[ 'SDHG',  'Dillingen DB/DHS' ],
	[ 'SDLG',  'Dillingen DB/Mei' ],
	[ 'SDZG',  'Dillingen DB/ZKS' ],
	[ 'SDLF',  'Dillingen Ford' ],
	[ 'SDLS',  'Dillingen Süd' ],
	[ 'MDIL',  'Dillingen/Donau' ],
	[ 'XJDI',  'Dimitrovgrad RS' ],
	[ 'EDGD',  'Dingden' ],
	[ 'XVDI',  'Dingle' ],
	[ 'MDIF',  'Dingolfing' ],
	[ 'MARM',  'Dinkelsb Rettenm' ],
	[ 'MDKB',  'Dinkelsbühl' ],
	[ 'MDKS',  'Dinkelscherben' ],
	[ 'EDIN',  'Dinslaken' ],
	[ 'XLDR',  'Dippach-Reckange' ],
	[ 'BDIR',  'Dippmannsdorf' ],
	[ 'SDIR',  'Dirmingen' ],
	[ 'HDRG',  'Dissen-B R DB-Gr' ],
	[ 'HDBR',  'Dissen-Bad Roth' ],
	[ 'TDIH',  'Distelhausen' ],
	[ 'LDT',   'Ditfurt' ],
	[ 'XIDI',  'Dittaino' ],
	[ 'NDI',   'Dittenbrunn' ],
	[ 'DDIF',  'Dittersbach(bFr)' ],
	[ 'DDF',   'Dittersdorf' ],
	[ 'TDM',   'Dittigheim' ],
	[ 'XKDI',  'Ditton' ],
	[ 'TDI',   'Ditzingen' ],
	[ 'XZDV',  'Divaca' ],
	[ 'XRDJ',  'Djaletovci' ],
	[ 'ZUDJ',  'Djankoi' ],
	[ 'ZADP',  'Djorce Petrov' ],
	[ 'ZUDD',  'Dneprodzerjinsk' ],
	[ 'ZUD',   'Dnepropetrovsk' ],
	[ 'XCDN',  'Dno' ],
	[ 'EDGM',  'Do Germania' ],
	[ 'EDMB',  'Do Möllerbrücke' ],
	[ 'EDWH',  'Do Signal Iduna' ],
	[ 'EDST',  'Do Stadthaus' ],
	[ 'EDTP',  'Do Tierpark' ],
	[ 'EDUV',  'Do Universität' ],
	[ 'EDWS',  'Do Westerholz' ],
	[ 'EDOZ',  'Do Zinkhütte' ],
	[ 'EDAP',  'Do-Aplerbeck' ],
	[ 'EDAU',  'Do-Aplerbeck Süd' ],
	[ 'EDAS',  'Do-Asseln' ],
	[ 'EDAM',  'Do-Asseln Mitte' ],
	[ 'XIDT',  'Dobbiaco/Toblach' ],
	[ 'DDEG',  'Döbeln DB-Gr' ],
	[ 'DDE',   'Döbeln Hbf' ],
	[ 'DDEZ',  'Döbeln Zentrum' ],
	[ 'KDOB',  'D-Oberbilk' ],
	[ 'LDO',   'Döberitz' ],
	[ 'BDKO',  'Doberlug-K ob Bf' ],
	[ 'BDKU',  'Doberlug-K untBf' ],
	[ 'BDKN',  'Doberlug-Kh Nord' ],
	[ 'LDOB',  'Doberschütz' ],
	[ 'XTDB',  'Dobesov' ],
	[ 'ZBDO',  'Doboj' ],
	[ 'XZD',   'Dobova' ],
	[ 'XZXDO', 'Dobova Gr HR' ],
	[ 'EDBH',  'Do-Bövinghausen' ],
	[ 'XTDF',  'Dobra u Fry-Mist' ],
	[ 'SDOD',  'Dockweiler-Dreis' ],
	[ 'LDF',   'Dodendorf' ],
	[ 'AKTKD', 'dodenhof' ],
	[ 'EDDP',  'Do-Dorstfeld' ],
	[ 'EDDS',  'Do-Dorstfeld Süd' ],
	[ 'XDDS',  'Doestrup Sdrj' ],
	[ 'RDRN',  'Dogern' ],
	[ 'RDGN',  'Döggingen' ],
	[ 'NDAU',  'Döhlau' ],
	[ 'HDLE',  'Döhle' ],
	[ 'DDO',   'Dohna (Sachs)' ],
	[ 'EDOH',  'Do-Huckarde' ],
	[ 'EDHU',  'Do-Huckarde Nord' ],
	[ 'EDHK',  'Do-Huckarde Süd' ],
	[ 'EDKD',  'Do-Kirchderne' ],
	[ 'EDKH',  'Do-Kirchhörde' ],
	[ 'EDKK',  'Do-Knappschaft' ],
	[ 'EDWK',  'Do-Körne West' ],
	[ 'EDKA',  'Do-Kruckel Awan' ],
	[ 'XTDK',  'Doksy' ],
	[ 'XFDO',  'Dole' ],
	[ 'XBDG',  'Dolhain-Gileppe' ],
	[ 'XKDM',  'Dollands Moor' ],
	[ 'HDOG',  'Dollbergen' ],
	[ 'ADR',   'Dollern' ],
	[ 'MDO',   'Dollnstein' ],
	[ 'UDST',  'Döllstädt' ],
	[ 'XPDOO', 'Dolna Odra' ],
	[ 'XTDH',  'Dolni Habartice' ],
	[ 'XTDD',  'Dolni Podluzi' ],
	[ 'XTDPO', 'Dolni Polubny' ],
	[ 'XTDA',  'Dolni Poustevna' ],
	[ 'XTDR',  'Dolni Radoun' ],
	[ 'XTDZV', 'Dolni Zandov' ],
	[ 'XTDL',  'Dolni Zleb' ],
	[ 'XTDZ',  'Dolni Zleb zast' ],
	[ 'EDLH',  'Do-Löttringhsn' ],
	[ 'EDLN',  'Do-Lütgend Nord' ],
	[ 'EDLS',  'Do-Lütgendortm H' ],
	[ 'EDLU',  'Do-Lütgendtm Gbf' ],
	[ 'EOBD',  'Dom' ],
	[ 'EDMR',  'Do-Marten' ],
	[ 'EDMS',  'Do-Marten Süd' ],
	[ 'XTDO',  'Domazlice' ],
	[ 'XODB',  'Dombas' ],
	[ 'NDB',   'Dombühl' ],
	[ 'NDBG',  'Dombühl DB-Gr' ],
	[ 'XIDSA', 'Domegliara S.A.' ],
	[ 'XFDF',  'Domfessel' ],
	[ 'XTDI',  'Domina' ],
	[ 'XLDM',  'Dommeldange' ],
	[ 'XVDN',  'Domnarvet' ],
	[ 'LDN',   'Domnitz (Saalkr)' ],
	[ 'XID',   'Domodossola' ],
	[ 'XTDM',  'Domousice' ],
	[ 'WDS',   'Domsühl' ],
	[ 'RDO',   'Donaueschingen' ],
	[ 'MDT',   'Donauwörth' ],
	[ 'EDOO',  'Do-Nette/Oestr' ],
	[ 'XCDG',  'Donguzskaia' ],
	[ 'XRDK',  'Donji Kraljevec' ],
	[ 'UDO',   'Donndorf (Unstr)' ],
	[ 'EDOE',  'Do-Obereving' ],
	[ 'EDOEF', 'Do-Obereving Oef' ],
	[ 'XPDOP', 'Dopiewo' ],
	[ 'KDOA',  'Dora' ],
	[ 'EDRA',  'Do-Rahm' ],
	[ 'EDRZ',  'Do-Rahm Üst' ],
	[ 'XNDO',  'Dordrecht' ],
	[ 'EDTH',  'Dörenthe' ],
	[ 'HDTP',  'Dörentrup' ],
	[ 'WMK',   'Dorf Mecklenburg' ],
	[ 'DDCH',  'Dorfchemnitz' ],
	[ 'MDFN',  'Dorfen Bahnhof' ],
	[ 'XADG',  'Dorfgastein' ],
	[ 'NDOE',  'Dörfles-Esbach' ],
	[ 'HDMK',  'Dorfmark' ],
	[ 'NDP',   'Dorfprozelten' ],
	[ 'FDH',   'Dorheim (Wett)' ],
	[ 'KDO',   'Dormagen' ],
	[ 'KDBWN', 'Dormagen Chemp N' ],
	[ 'KDBW',  'Dormagen Chemp S' ],
	[ 'XIDL',  'Dormeletto' ],
	[ 'KDOH',  'Dornap-Hahnenf' ],
	[ 'XADO',  'Dornbirn' ],
	[ 'XADS',  'Dornbirn-Schoren' ],
	[ 'UDG',   'Dornburg (Saale)' ],
	[ 'LDH',   'Dornreichenbach' ],
	[ 'TDS',   'Dornstetten' ],
	[ 'XPDO',  'Dorohusk' ],
	[ 'XPXDO', 'Dorohusk Gr UA' ],
	[ 'XPDOG', 'Dorohusk Granica' ],
	[ 'HDOP',  'Dörpen' ],
	[ 'HDPH',  'Dörpen Hp' ],
	[ 'HLE',   'Dörpen-Lehe' ],
	[ 'UDOE',  'Dörrberg' ],
	[ 'KDOS',  'Dorsfeld' ],
	[ 'EDRN',  'Dorsten' ],
	[ 'LDST',  'Dörstewitz' ],
	[ 'EDDPB', 'Dorstfeld' ],
	[ 'EDDPO', 'Dorstfeld Ost' ],
	[ 'EDFW',  'Dorstfeld West' ],
	[ 'EDDPH', 'Dorstfeld(hoch)' ],
	[ 'EDDPT', 'Dorstfeld(tief)' ],
	[ 'FDW',   'Dortelweil' ],
	[ 'EDOB',  'Dortmund Bbf' ],
	[ 'EDFB',  'Dortmund Flm' ],
	[ 'EDOG',  'Dortmund Gbf' ],
	[ 'EDO',   'Dortmund Hbf' ],
	[ 'EDND',  'Dortmund Nord' ],
	[ 'EDSD',  'Dortmund Stockh' ],
	[ 'EDOS',  'Dortmund Süd' ],
	[ 'EDW',   'Dortmund West' ],
	[ 'EDBA',  'Dortmund-Barop' ],
	[ 'EDBK',  'Dortmund-Brackel' ],
	[ 'EDD',   'Dortmund-Derne' ],
	[ 'EDMF',  'Dortmunderfeld' ],
	[ 'EDEV',  'Dortmund-Eving' ],
	[ 'EDH',   'Dortmund-Hörde' ],
	[ 'EDK',   'Dortmund-Kley' ],
	[ 'EDKO',  'Dortmund-Körne' ],
	[ 'EDKR',  'Dortmund-Kruckel' ],
	[ 'EDKU',  'Dortmund-Kurl' ],
	[ 'EDMG',  'Dortmund-Mengede' ],
	[ 'EDOP',  'Dortmund-Oespel' ],
	[ 'EDSO',  'Dortmund-Sölde' ],
	[ 'EDWI',  'Dortmund-Wickede' ],
	[ 'ADO',   'Dorum' ],
	[ 'HDVD',  'Dörverden' ],
	[ 'TDZB',  'Dörzbach' ],
	[ 'EDSH',  'Do-Scharnhorst' ],
	[ 'EDSM',  'Do-Somborn' ],
	[ 'RDOS',  'Dossenh.(Bergst)' ],
	[ 'WDOW',  'Dossow (Prign)' ],
	[ 'NDM',   'Dottenheim' ],
	[ 'TDOD',  'Dotternhsn-Dorm' ],
	[ 'XSDO',  'Dottikon-Din' ],
	[ 'XKDE',  'Dover ED' ],
	[ 'XKDP',  'Dover Priory' ],
	[ 'XKD',   'Dover WD' ],
	[ 'XODV',  'Dovre' ],
	[ 'EDOF',  'Do-Westerfilde' ],
	[ 'EDWW',  'Do-Wickede West' ],
	[ 'EDOL',  'Do-Wischlingen' ],
	[ 'AWHOD', 'Dradenau' ],
	[ 'XWDR',  'Dragoman' ],
	[ 'BDF',   'Drahnsdorf' ],
	[ 'LDRG',  'Drahtzug' ],
	[ 'XGDM',  'Drama' ],
	[ 'XODM',  'Drammen' ],
	[ 'XODR',  'Drangedal' ],
	[ 'KDRM',  'D-Rath Mitte' ],
	[ 'XLDF',  'Drauffelt' ],
	[ 'FBUSS', 'Dr-Buchschlag Hp' ],
	[ 'DKTF',  'Dre Flughafen' ],
	[ 'DFS',   'Dre Freibg Str' ],
	[ 'DHFR',  'Dre Freibge Bstg' ],
	[ 'HDRB',  'Drebber' ],
	[ 'BDR',   'Drebkau' ],
	[ 'DCTA',  'Dre-Cotta Bft' ],
	[ 'DCT',   'Dre-Cotta Bstg' ],
	[ 'DD',    'Dre-Dobritz' ],
	[ 'DF',    'Dre-Friedrichst' ],
	[ 'DGI',   'Dre-Gittersee' ],
	[ 'LDAH',  'Drei Annen Hohne' ],
	[ 'FBUS',  'Dreieich-Buchsch' ],
	[ 'FDCH',  'Dreieich-Dreichh' ],
	[ 'FGOZ',  'Dreieich-Götzenh' ],
	[ 'FOFF',  'Dreieich-Offenth' ],
	[ 'FSPO',  'Dreieich-Sprendl' ],
	[ 'FWED',  'Dreieich-Weibelf' ],
	[ 'FOHS',  'Dreikirchen' ],
	[ 'LDD',   'Dreileben-Drack' ],
	[ 'KDRE',  'D-Reisholz' ],
	[ 'KDRA',  'D-Reisholz Abzw' ],
	[ 'KDRH',  'D-Reisholz Hp' ],
	[ 'KDREF', 'D-Reisholz Rgf' ],
	[ 'KDREN', 'D-Reisholz Rn' ],
	[ 'EDTO',  'Dreis-Tiefenb O' ],
	[ 'EDTF',  'Dreis-Tiefenbach' ],
	[ 'DKT B', 'Dre-Klotzsch Bbf' ],
	[ 'DKT',   'Dre-Klotzsche' ],
	[ 'DN A',  'Dre-Neust Abstg' ],
	[ 'DN',    'Dre-Neustadt' ],
	[ 'DNG',   'Dre-Neustadt Gbf' ],
	[ 'DNSH',  'Dre-Nieders Bstg' ],
	[ 'DNS',   'Dre-Niedersedl' ],
	[ 'EDRS',  'Drensteinfurt' ],
	[ 'HDRE',  'Drentwede' ],
	[ 'DPS',   'Dre-Pieschen' ],
	[ 'DPSA',  'Dre-Pieschen Abz' ],
	[ 'DPL',   'Dre-Plauen' ],
	[ 'DRKA',  'Dre-Reick Abstbf' ],
	[ 'DDRE',  'Dresden' ],
	[ 'DGRS',  'Dresden Grenzstr' ],
	[ 'DH',    'Dresden Hbf' ],
	[ 'DIG',   'Dresden Ind-gel.' ],
	[ 'DM',    'Dresden Mitte' ],
	[ 'DA',    'Dresden-Altstadt' ],
	[ 'DKE',   'Dresden-Kemnitz' ],
	[ 'DRK',   'Dresden-Reick' ],
	[ 'DZSW',  'Dresden-Zschachw' ],
	[ 'DSTT',  'Dre-Stetzsch' ],
	[ 'DSTH',  'Dre-Strehlen' ],
	[ 'DTR',   'Dre-Trachau' ],
	[ 'WDRE',  'Drewin' ],
	[ 'HDRY',  'Dreye' ],
	[ 'HQDR',  'Dreye NI/HB' ],
	[ 'XUDT',  'Drobeta Turnu-S' ],
	[ 'WDH',   'Drögeheide' ],
	[ 'HDRD',  'Drögennindorf' ],
	[ 'ZUDR',  'Drogobych' ],
	[ 'LDM',   'Drohnd-Mehringen' ],
	[ 'HDRO',  'Drohne' ],
	[ 'DDN',   'Drosen' ],
	[ 'XPDR',  'Drzewce' ],
	[ 'EDBS',  'Dt Bauernsiedlg' ],
	[ 'EDHG',  'Du Hafen DB-Gr' ],
	[ 'EHKM',  'Du Hütte K/M' ],
	[ 'EDHM',  'Du Mannesmann' ],
	[ 'EDSL',  'Du Schlenk' ],
	[ 'EDBG',  'Du-Beeck Gbf' ],
	[ 'ZUDU',  'Dubno' ],
	[ 'EDBU',  'Du-Buchholz' ],
	[ 'EDBZ',  'Du-Buchholz Abzw' ],
	[ 'XTDU',  'Duchcov' ],
	[ 'WDU',   'Ducherow' ],
	[ 'KDUK',  'Duckterath' ],
	[ 'XLDB',  'Dudelange-Burang' ],
	[ 'XLDC',  'Dudelange-Centre' ],
	[ 'XLDU',  'Dudelange-Usines' ],
	[ 'XLDV',  'Dudelange-Ville' ],
	[ 'FDUU',  'Dudenhofen' ],
	[ 'EDUI',  'Du-Duissern' ],
	[ 'SDUW',  'Dudweiler' ],
	[ 'KDUL',  'Dülken' ],
	[ 'EDUL',  'Dülmen' ],
	[ 'EDULH', 'Dülmen (hoch)' ],
	[ 'HDUS',  'Dünsen' ],
	[ 'KDN',   'Düren' ],
	[ 'KDNG',  'Düren Im Gr Tal' ],
	[ 'KDN P', 'Düren Pbf' ],
	[ 'KDN G', 'Düren Vorbf' ],
	[ 'RDBG',  'Dürrenbüchig' ],
	[ 'MDZ',   'Dürrenzimmern' ],
	[ 'DDHG',  'Dürrhennd DB-Gr' ],
	[ 'DDH',   'Dürrhennersdorf' ],
	[ 'MDHR',  'Dürrnhaar' ],
	[ 'DRR',   'Dürrröhrsdorf' ],
	[ 'KDUR',  'Dürscheven' ],
	[ 'KD',    'Düsseldorf Hbf' ],
	[ 'KD N',  'Düsseldorf Nordk' ],
	[ 'KDZ',   'Düsseldorf Zoo' ],
	[ 'KDE',   'Düsseldorf-Eller' ],
	[ 'KDHA',  'Düsseldorf-Hamm' ],
	[ 'KDR',   'Düsseldorf-Rath' ],
	[ 'WDT',   'Dütschow' ],
	[ 'XFDU',  'Dugny' ],
	[ 'XRDS',  'Dugo Selo' ],
	[ 'EDGR',  'Du-Großenbaum' ],
	[ 'EDHZ',  'Du-Hochf S Abzw' ],
	[ 'EDHN',  'Du-Hochfeld Nord' ],
	[ 'EDHDH', 'Du-Hochfeld S Hf' ],
	[ 'EDHP',  'Du-Hochfeld S Hp' ],
	[ 'EDHDO', 'Du-Hochfeld S Vb' ],
	[ 'EDHD',  'Du-Hochfeld Süd' ],
	[ 'EDHA',  'Duisburg Hafen' ],
	[ 'EDG',   'Duisburg Hbf' ],
	[ 'EDHB',  'Duisburg-Hamborn' ],
	[ 'EDRM',  'Duisburg-Rahm' ],
	[ 'EDRU',  'Duisburg-Ruhrort' ],
	[ 'EDWD',  'Duisburg-Wedau' ],
	[ 'XNDN',  'Duiven B r o' ],
	[ 'XNDU',  'Duivendrecht' ],
	[ 'EDMO',  'DU-Meiderich Ost' ],
	[ 'EDME',  'Du-Meiderich Süd' ],
	[ 'XMDF',  'Dunai Finomito' ],
	[ 'XYDS',  'Dunajska Streda' ],
	[ 'XMDU',  'Dunaujvaros' ],
	[ 'XODU',  'Dunderland' ],
	[ 'XFDK',  'Dunkerque' ],
	[ 'XFDW',  'Dunkerque Pt Oue' ],
	[ 'KDU',   'D-Unterrath' ],
	[ 'EDOM',  'Du-Obermeiderich' ],
	[ 'XWDU',  'Dupnica' ],
	[ 'MDUH',  'Durach' ],
	[ 'XRDV',  'Durdevac' ],
	[ 'RDRM',  'Durmersheim' ],
	[ 'RDUN',  'Durmersheim Nord' ],
	[ 'EDRH',  'Du-Ruhrort Hafen' ],
	[ 'TDU',   'Dußlingen' ],
	[ 'FDTH',  'Dutenhofen/Wetz' ],
	[ 'EDWM',  'Du-Wanheim' ],
	[ 'EDBI',  'Du-Wedau Bissing' ],
	[ 'EDEF',  'Du-Wedau Entenf' ],
	[ 'EDWDO', 'Du-Wedau Ostgr' ],
	[ 'EDWDP', 'Du-Wedau Pbf' ],
	[ 'EDWDS', 'Du-Wedau Südbg' ],
	[ 'KWST',  'D-Wersten' ],
	[ 'EDYK',  'Dyckerhoff' ],
	[ 'XDDY',  'Dyreby' ],
	[ 'XPDZA', 'Dzialoszyn' ],
	[ 'XPDZ',  'Dziewoklicz' ],
	[ 'XPDZI', 'Dzikowice' ],
	[ 'EE U',  'E Burggrafenstr' ],
	[ 'EEKB',  'E Zollverein N' ],
	[ 'XFEB',  'Ebange' ],
	[ 'XKEI',  'Ebbsfleet Int' ],
	[ 'UEE',   'Ebeleben' ],
	[ 'NEE',   'Ebelsbach-Eltm' ],
	[ 'XAEB',  'Eben im Pongau' ],
	[ 'XAEF',  'Ebenfurth' ],
	[ 'NEBH',  'Ebenhausen(Ufr)' ],
	[ 'MEBH',  'Ebenhofen' ],
	[ 'MEBS',  'Ebenhsn-Schäftl' ],
	[ 'NED',   'Ebensfeld' ],
	[ 'REA',   'Eberbach' ],
	[ 'EEBE',  'E-Bergeborbeck' ],
	[ 'NEBM',  'Ebermannstadt' ],
	[ 'MEBM',  'Ebermergen' ],
	[ 'NEB',   'Ebern Hp' ],
	[ 'TEC',   'Ebersbach (Fils)' ],
	[ 'DXE',   'Ebersbach Grenze' ],
	[ 'DEB',   'Ebersbach(Sachs)' ],
	[ 'MEG',   'Ebersberg/Obb' ],
	[ 'DEBR',  'Ebersbrunn' ],
	[ 'NEC',   'Ebersdorf (Cobg)' ],
	[ 'UEFF',  'Ebersdorf-Fries' ],
	[ 'XFEH',  'Ebersheim' ],
	[ 'WE',    'Eberswalde Hbf' ],
	[ 'RET',   'Ebertsheim' ],
	[ 'NEG',   'Ebing' ],
	[ 'EEBB',  'E-Borbeck' ],
	[ 'EEBS',  'E-Borbeck Süd' ],
	[ 'REBR',  'Ebringen' ],
	[ 'HEBS',  'Ebstorf/KrUelzen' ],
	[ 'AECH',  'Echem' ],
	[ 'MEC',   'Eching' ],
	[ 'XNET',  'Echteld B r' ],
	[ 'TETD',  'Echterdingen' ],
	[ 'FEZL',  'Echzell' ],
	[ 'UEK',   'Eckardtsleben' ],
	[ 'UEC',   'Eckartsberga' ],
	[ 'TEI',   'Eckartshsn-Ilshf' ],
	[ 'AEC',   'Eckernförde' ],
	[ 'NEMN',  'Eckersmühlen' ],
	[ 'XVE',   'Ed' ],
	[ 'FED',   'Eddersheim' ],
	[ 'XBED',  'Ede BE' ],
	[ 'XNE',   'Ede Centrum' ],
	[ 'TED',   'Edelfingen' ],
	[ 'EEDZ',  'E-Dellwig' ],
	[ 'EEDO',  'E-Dellwig Ost' ],
	[ 'REK',   'Edenkoben' ],
	[ 'REKG',  'Edenkoben Gillet' ],
	[ 'FEDN',  'Ederbringhausen' ],
	[ 'KEDR',  'Ederen' ],
	[ 'FGRF',  'Edermünde-Grifte' ],
	[ 'HEDM',  'Edesheim (L)' ],
	[ 'HEDS',  'Edesheim (L) Süd' ],
	[ 'REH',   'Edesheim (Pfalz)' ],
	[ 'XNEW',  'Ede-Wageningen' ],
	[ 'ZIET',  'Edgeworthstown' ],
	[ 'SEE',   'Ediger-Eller' ],
	[ 'RED',   'Edingen (Baden)' ],
	[ 'FEDI',  'Edingen(Kr Wetz)' ],
	[ 'XQED',  'Edirne' ],
	[ 'DKR',   'Edle Krone' ],
	[ 'MEDL',  'Edling' ],
	[ 'XNEH',  'Eemshaven' ],
	[ 'KEKW',  'Eff Kiebitzweg' ],
	[ 'UEFT',  'Effelder (Thür)' ],
	[ 'KEFF',  'Efferen' ],
	[ 'FEF',   'Effolderbach' ],
	[ 'XSEK',  'Effretikon' ],
	[ 'REF',   'Efringen-Kirchen' ],
	[ 'FEGB',  'Egelsbach' ],
	[ 'XME',   'Eger' ],
	[ 'NEGE',  'Egersdorf' ],
	[ 'XOES',  'Egersund' ],
	[ 'HEGL',  'Egestorf (Lüneb)' ],
	[ 'HEGT',  'Egestorf/Deister' ],
	[ 'MEGF',  'Eggenfelden' ],
	[ 'MEFM',  'Eggenfelden M' ],
	[ 'EGG',   'Egger' ],
	[ 'LEGD',  'Eggersdorf' ],
	[ 'WEGS',  'Eggesin' ],
	[ 'MEGK',  'Egglkofen' ],
	[ 'MEGM',  'Eggmühl' ],
	[ 'NEO',   'Eggolsheim' ],
	[ 'NENG',  'Eging' ],
	[ 'MEGL',  'Eglharting' ],
	[ 'MELG',  'Egling' ],
	[ 'XSEG',  'Eglisau' ],
	[ 'XSEN',  'Egnach' ],
	[ 'TEH',   'Ehingen (Donau)' ],
	[ 'EELB',  'Ehlenbruch' ],
	[ 'HELH',  'Ehlershausen' ],
	[ 'TEHA',  'Ehningen Kriegb' ],
	[ 'TEHN',  'Ehningen(b Böbl)' ],
	[ 'EEHH',  'E-Holthausen' ],
	[ 'KEHR',  'Ehr' ],
	[ 'SEG',   'Ehrang' ],
	[ 'SEG M', 'Ehrang Mitte' ],
	[ 'SEG N', 'Ehrang Nord' ],
	[ 'SEGO',  'Ehrang Ort' ],
	[ 'SEG O', 'Ehrang Ost' ],
	[ 'SEG S', 'Ehrang Süd' ],
	[ 'FEGN',  'Ehringen' ],
	[ 'EERI',  'Ehringhsn/Lippst' ],
	[ 'FEHH',  'Ehringshsn(Obhe)' ],
	[ 'FEHR',  'Ehringshsn/Kr We' ],
	[ 'XAEZ',  'Ehrwald(Zugsp.B)' ],
	[ 'NNET',  'Eibach Üst' ],
	[ 'DEIB',  'Eibau' ],
	[ 'DEIG',  'Eibau DB-Gr' ],
	[ 'MEIB',  'Eibsee' ],
	[ 'DEI',   'Eich (Sachs)' ],
	[ 'BEBD',  'Eichborndamm' ],
	[ 'MAEI',  'Eichbühl/Eggmühl' ],
	[ 'EEHS',  'Eichen /Siegen' ],
	[ 'MEIC',  'Eichenau/Obb' ],
	[ 'HEBG',  'Eichenberg' ],
	[ 'HQEB',  'Eichenberg 6343' ],
	[ 'HEBGN', 'Eichenberg Nordk' ],
	[ 'HEBGO', 'Eichenberg Ostk' ],
	[ 'FEIZ',  'Eichenzell' ],
	[ 'BEG',   'Eichgestell' ],
	[ 'BEGN',  'Eichgestell Nord' ],
	[ 'EEHG',  'Eichhagen' ],
	[ 'FEIM',  'Eichmühle' ],
	[ 'REM',   'Eicholzheim' ],
	[ 'BEO',   'Eichow' ],
	[ 'MEB',   'Eichstätt Bf' ],
	[ 'MEST',  'Eichstätt Stadt' ],
	[ 'LEST',  'Eichstedt (Altm)' ],
	[ 'RE',    'Eichstetten a K' ],
	[ 'BEIW',  'Eichwalde' ],
	[ 'LEF',   'Eickendorf' ],
	[ 'AEST',  'Eidelst (S-Bahn)' ],
	[ 'AENG',  'Eidelst Zentr Gr' ],
	[ 'AQE',   'Eidelstedt HH/SH' ],
	[ 'AEBR',  'Eiderbrücke' ],
	[ 'XOED',  'Eidsvoll' ],
	[ 'XOEK',  'Eikenes' ],
	[ 'LEGV',  'Eilenb Gw+EBAWE' ],
	[ 'LEGOB', 'Eilenb Ost Bk Hp' ],
	[ 'LEGG',  'Eilenbg O DB-Gr' ],
	[ 'LEG',   'Eilenburg' ],
	[ 'LEGO',  'Eilenburg Ost' ],
	[ 'KEIL',  'Eilendorf' ],
	[ 'HEIL',  'Eilensen' ],
	[ 'LEI G', 'Eilsleb(b Mg)Gbf' ],
	[ 'LEI',   'Eilsleben (b Mg)' ],
	[ 'HEIV',  'Eilvese' ],
	[ 'REI',   'Eimeldingen' ],
	[ 'XOE',   'Eina' ],
	[ 'HEBM',  'Einbeck Mitte' ],
	[ 'HEB',   'Einbeck-Salzderh' ],
	[ 'XNEI',  'Eindhoven' ],
	[ 'AEF',   'Einfeld' ],
	[ 'SEI',   'Einöd (Saar)' ],
	[ 'DED',   'Einsiedel' ],
	[ 'DEDH',  'Einsiedel Gymnas' ],
	[ 'XSES',  'Einsiedeln' ],
	[ 'SEF',   'Einsiedlerhof' ],
	[ 'TEIN',  'Einsingen' ],
	[ 'HEWA',  'Einswarden' ],
	[ 'EETR',  'Eintracht' ],
	[ 'XBE',   'Eisden' ],
	[ 'UEI',   'Eisenach' ],
	[ 'UEI G', 'Eisenach Gbf' ],
	[ 'UEIA',  'Eisenach HTB' ],
	[ 'UEIP',  'Eisenach Opel' ],
	[ 'UEIW',  'Eisenach West' ],
	[ 'UEIS',  'Eisenach-Stedtf' ],
	[ 'MEZT',  'Eisenärzt' ],
	[ 'REIS',  'Eisenberg(Pfalz)' ],
	[ 'REISO', 'Eisenbg Bstg Ost' ],
	[ 'REISW', 'Eisenbg BstgWest' ],
	[ 'SEMA',  'Eisenb-Matzenb' ],
	[ 'BEHS',  'Eisenhüttenstadt' ],
	[ 'RES',   'Eisenhut' ],
	[ 'EEFD',  'Eiserfeld (Sieg)' ],
	[ 'UED',   'Eisfeld' ],
	[ 'LETM',  'Eisfelder Talm' ],
	[ 'TEF',   'Eislingen (Fils)' ],
	[ 'REIW',  'Eiswoog' ],
	[ 'MEI',   'Eitensheim' ],
	[ 'KEIT',  'Eitorf' ],
	[ 'HEIZ',  'Eitze' ],
	[ 'XDEY',  'Ejby' ],
	[ 'XCSV',  'Ekaterinburg Pas' ],
	[ 'EEKA',  'E-Katernberg N A' ],
	[ 'XVEJ',  'Ekenässjön' ],
	[ 'XVEY',  'Ekeryd' ],
	[ 'EEKN',  'E-Kray Nord' ],
	[ 'EEKS',  'E-Kray Süd' ],
	[ 'EEKZ',  'E-Kray Süd Abzw' ],
	[ 'XVEK',  'Eksjö' ],
	[ 'EEKU',  'E-Kupferdreh' ],
	[ 'EEBN',  'Elben' ],
	[ 'AEGS',  'Elbgaustraße' ],
	[ 'LELG',  'Elbingerode Harz' ],
	[ 'LELL',  'Elbingerode Lstr' ],
	[ 'XPE',   'Elblag' ],
	[ 'HED',   'Eldingen' ],
	[ 'LELD',  'Elend' ],
	[ 'ZUE',   'Elevatornaia' ],
	[ 'NELF',  'Elfershs-Trimbg' ],
	[ 'UELG',  'Elgersburg' ],
	[ 'FELH',  'Elgershausen' ],
	[ 'HELN',  'Elisabethfehn' ],
	[ 'XPEK',  'Elk' ],
	[ 'XDEL',  'Elkaerdam' ],
	[ 'DLD',   'Ellefeld' ],
	[ 'TBME',  'Ellental' ],
	[ 'AELA',  'Ellerau' ],
	[ 'REO',   'Ellerstadt' ],
	[ 'TELL',  'Ellhofen' ],
	[ 'TELI',  'Ellhofen Gewerbe' ],
	[ 'NEL',   'Ellingen (Bay)' ],
	[ 'UER',   'Ellrich' ],
	[ 'UQER',  'Ellrich TH/NI' ],
	[ 'TEL',   'Ellwangen' ],
	[ 'MELZ',  'Ellzee' ],
	[ 'FEL',   'Elm' ],
	[ 'WELM',  'Elmenhorst' ],
	[ 'AEL',   'Elmshorn' ],
	[ 'AEL N', 'Elmshorn Nord' ],
	[ 'AEL W', 'Elmshorn West' ],
	[ 'XFEL',  'Elne' ],
	[ 'TELP',  'Elpersheim' ],
	[ 'XAEL',  'Elsbethen' ],
	[ 'NELS',  'Elsendorf' ],
	[ 'HELS',  'Elsfleth' ],
	[ 'BEZ',   'Elsholz' ],
	[ 'LEK',   'Elsnigk (Anhalt)' ],
	[ 'BETN',  'Elstal' ],
	[ 'LELT',  'Elster (Elbe)' ],
	[ 'UELK',  'Elsterb Kunsts' ],
	[ 'UELB',  'Elsterberg' ],
	[ 'BEB',   'Elsterw-Biehla' ],
	[ 'BEW',   'Elsterwerda' ],
	[ 'YLLEW', 'Elsterwerda Strw' ],
	[ 'NEF',   'Eltersdorf' ],
	[ 'NEFU',  'Eltersdorf Üst' ],
	[ 'FELT',  'Eltville' ],
	[ 'FELTO', 'Eltville Ost' ],
	[ 'XOEL',  'Elverum' ],
	[ 'UEX',   'Elxleben' ],
	[ 'FELS',  'Elz(Kr Lbg/L)Süd' ],
	[ 'FELZ',  'Elz(Kr Limbg/La)' ],
	[ 'RELZ',  'Elzach' ],
	[ 'HELZ',  'Elze (Han)' ],
	[ 'SWR E', 'Em Wemmets Kurve' ],
	[ 'HESG',  'Emd Südkai DB-Gr' ],
	[ 'HE',    'Emden' ],
	[ 'LEMD',  'Emden (Kr Hald)' ],
	[ 'HEA',   'Emden Außenhafen' ],
	[ 'HEVA',  'Emden EVAG' ],
	[ 'HEVW',  'Emden Hbf VW' ],
	[ 'HER',   'Emden Rbf' ],
	[ 'HESK',  'Emden Südkai' ],
	[ 'HEVG',  'Emden VW DB-Gr' ],
	[ 'UEM',   'Emleben' ],
	[ 'HEML',  'Emlichheim' ],
	[ 'KEM',   'Emma' ],
	[ 'KEMM',  'Emmelshausen' ],
	[ 'XSEB',  'Emmenbrücke' ],
	[ 'REMM',  'Emmendingen' ],
	[ 'EEM',   'Emmerich' ],
	[ 'EXEM',  'Emmerich Grenze' ],
	[ 'HEMK',  'Emmerke' ],
	[ 'HEMT',  'Emmerthal' ],
	[ 'XMEM',  'Emöd' ],
	[ 'HEMP',  'Empelde' ],
	[ 'HEMA',  'Empelde Abzw' ],
	[ 'EEMP',  'Empel-Rees' ],
	[ 'XIEP',  'Empoli' ],
	[ 'EEMS',  'Ems' ],
	[ 'HEM',   'Emsbüren' ],
	[ 'EEDT',  'Emsdetten' ],
	[ 'NEK',   'Emskirchen' ],
	[ 'FEMT',  'Emstal' ],
	[ 'TEN',   'Endersbach' ],
	[ 'TEND',  'Endingen (Württ)' ],
	[ 'REN',   'Endingen a K' ],
	[ 'KENG',  'Engeln (Brohlt)' ],
	[ 'LEW',   'Engelsdf Werkst' ],
	[ 'LE',    'Engelsdorf' ],
	[ 'LE K',  'Engelsdorf (KV)' ],
	[ 'LE V',  'Engelsdorf B 1' ],
	[ 'LE H',  'Engelsdorf Bstg' ],
	[ 'LEO',   'Engelsdorf Ost' ],
	[ 'KENL',  'Engelskirchen' ],
	[ 'RENG',  'Engen' ],
	[ 'KENR',  'Engers' ],
	[ 'MEGH',  'Engertsham' ],
	[ 'XDEV',  'Engesvang' ],
	[ 'XBEN',  'Engis' ],
	[ 'TKL',   'Engstingen' ],
	[ 'TENG',  'Engstlatt' ],
	[ 'SENK',  'Enkenbach' ],
	[ 'XIEN',  'Enna' ],
	[ 'EENP',  'Ennepetal' ],
	[ 'EENA',  'Ennepet-Altenv' ],
	[ 'EENR',  'Enniger' ],
	[ 'EENL',  'Ennigerloh' ],
	[ 'ZIEC',  'Enniscorthy' ],
	[ 'XAEN',  'Enns' ],
	[ 'XNES',  'Enschede' ],
	[ 'SEN',   'Ensdorf (Saar)' ],
	[ 'FENS',  'Enspel' ],
	[ 'FERA',  'Enspel Adrian' ],
	[ 'FERU',  'Enspel Uhrmacher' ],
	[ 'TENT',  'Entringen' ],
	[ 'XXEC',  'Entroncamento' ],
	[ 'TEZ',   'Enzberg' ],
	[ 'MENW',  'Enzisweiler' ],
	[ 'TEW',   'Enzweihingen' ],
	[ 'EEPE',  'Epe (Westf)' ],
	[ 'XFE',   'Epernay' ],
	[ 'TEP',   'Epfendorf' ],
	[ 'MEPH',  'Epfenhausen' ],
	[ 'REPF',  'Epfenhofen' ],
	[ 'XFEI',  'Epierre-St L' ],
	[ 'XFEN',  'Epinal' ],
	[ 'XUEB',  'Episcopia Bihor' ],
	[ 'FEPB',  'Epp-Bremthal' ],
	[ 'SEP',   'Eppelborn' ],
	[ 'FEPP',  'Eppelsheim/Rhhes' ],
	[ 'FER',   'Eppertshausen' ],
	[ 'REP',   'Eppingen' ],
	[ 'REPG',  'Eppingen DB/AVG' ],
	[ 'REPW',  'Eppingen West' ],
	[ 'FEP',   'Eppstein' ],
	[ 'FERO',  'Erbach (Odenw)' ],
	[ 'FERB',  'Erbach (Rhg)' ],
	[ 'TER',   'Erbach (Württ)' ],
	[ 'FERN',  'Erbach Nord' ],
	[ 'NEDN',  'Erbendorf Nord' ],
	[ 'NEDS',  'Erbendorf Süd' ],
	[ 'HERT',  'Erbstorf' ],
	[ 'HERZ',  'Erbstorf Ziegel' ],
	[ 'XMEA',  'Erd also' ],
	[ 'XMEF',  'Erd felsö' ],
	[ 'LER',   'Erdeborn' ],
	[ 'MER',   'Erding' ],
	[ 'FEKW',  'Erdkauterweg' ],
	[ 'FEKM',  'Erdkauterweg MTG' ],
	[ 'TERD',  'Erdmannhausen' ],
	[ 'DEAG',  'Erdmannsd DB-Gr' ],
	[ 'DEA',   'Erdmannsdorf-Aug' ],
	[ 'MEWG',  'Erdweg' ],
	[ 'UEEN',  'Erf Dieselstr' ],
	[ 'UEEL',  'Erf Leipz Str' ],
	[ 'UE L',  'Erf Linderbach' ],
	[ 'UEG L', 'Erf Linderbach' ],
	[ 'KERF',  'Erftkanal' ],
	[ 'KEST',  'Erftstadt' ],
	[ 'KERW',  'Erftwerk' ],
	[ 'UE F',  'Erfurt Fzwerk' ],
	[ 'UE G',  'Erfurt Gbf' ],
	[ 'UEG',   'Erfurt Gbf' ],
	[ 'UEG B', 'Erfurt Gbf Eb' ],
	[ 'UEG E', 'Erfurt Gbf Eo' ],
	[ 'UE O',  'Erfurt Gbf Ost' ],
	[ 'UE',    'Erfurt Hbf' ],
	[ 'UEN',   'Erfurt Nord' ],
	[ 'UEO',   'Erfurt Ost' ],
	[ 'UE P',  'Erfurt Pbf' ],
	[ 'UEBI',  'Erfurt-Bischleb' ],
	[ 'UEGI',  'Erfurt-Gisperslb' ],
	[ 'TEG',   'Ergenzingen' ],
	[ 'MERB',  'Ergoldsbach' ],
	[ 'EERG',  'Ergste' ],
	[ 'HERH',  'Erichshof' ],
	[ 'AERI',  'Ericus' ],
	[ 'AERIA', 'Ericus Awanst' ],
	[ 'TEK',   'Eriskirch' ],
	[ 'KERZ',  'Erkelenz' ],
	[ 'NERK',  'Erkersreuth' ],
	[ 'BERK',  'Erkner' ],
	[ 'BQER',  'Erkner BB/BE' ],
	[ 'BE',    'Erkner S-B' ],
	[ 'KER',   'Erkrath' ],
	[ 'KERN',  'Erkrath Nord' ],
	[ 'DERA',  'Erla' ],
	[ 'DERB',  'Erlabrunn' ],
	[ 'NER',   'Erlangen' ],
	[ 'NER G', 'Erlangen Gbf' ],
	[ 'NERB',  'Erlangen-Bruck' ],
	[ 'NERP',  'Erlau (b Passau)' ],
	[ 'DER',   'Erlau (Sachs)' ],
	[ 'NERH',  'Erl-Bruck Hp' ],
	[ 'XSE',   'Erlen' ],
	[ 'NERL',  'Erlenbach (M)' ],
	[ 'XSEM',  'Ermatingen' ],
	[ 'XSEMS', 'Ermatingen S' ],
	[ 'NERM',  'Ermetzhofen' ],
	[ 'EEKW',  'Erndtebr Eisenw2' ],
	[ 'EEK',   'Erndtebrück' ],
	[ 'MERN',  'Ernsgaden' ],
	[ 'MERG',  'Ernsgaden Hp' ],
	[ 'FERH',  'Ernsthsn(Frknbg)' ],
	[ 'UERN',  'Ernstth a Rennst' ],
	[ 'UERG',  'Ernstthal DB-Gr' ],
	[ 'KERP',  'Erpel (Rhein)' ],
	[ 'RERO',  'Erpolzheim' ],
	[ 'XBEQ',  'Erquelinnes' ],
	[ 'XCER',  'Ershov' ],
	[ 'TERS',  'Ersingen' ],
	[ 'TERW',  'Ersingen West' ],
	[ 'XFES',  'Erstein' ],
	[ 'XSEF',  'Erstfeld' ],
	[ 'EEWT',  'Erwitte' ],
	[ 'DSCP',  'Erzg Pappenwerk' ],
	[ 'FEZ',   'Erzhausen' ],
	[ 'FEZS',  'Erzhausen Hp' ],
	[ 'RERZ',  'Erzingen (Baden)' ],
	[ 'TERZ',  'Erzingen (Württ)' ],
	[ 'RQER',  'Erzingen LGr' ],
	[ 'XDE',   'Esbjerg' ],
	[ 'MAES',  'Eschach/Weißenh' ],
	[ 'XLEB',  'Esch-Belval' ],
	[ 'FES',   'Eschborn' ],
	[ 'FESS',  'Eschborn Süd' ],
	[ 'AEBG',  'Escheburg' ],
	[ 'HESD',  'Eschede' ],
	[ 'RESN',  'Eschelbronn' ],
	[ 'XAEU',  'Eschenau AT' ],
	[ 'NESU',  'Eschenau (Mfr)' ],
	[ 'TESU',  'Eschenau b Heilb' ],
	[ 'NESB',  'Eschenbach b M E' ],
	[ 'MECH',  'Eschenlohe' ],
	[ 'HESW',  'Eschenwiese' ],
	[ 'HESR',  'Escherde' ],
	[ 'FEN',   'Eschhofen' ],
	[ 'KESM',  'Eschmar' ],
	[ 'XLEA',  'Esch-Sur-Alzette' ],
	[ 'FENG',  'Eschw Nord DB-Gr' ],
	[ 'FESG',  'Eschw Süd DB-Gr' ],
	[ 'FEG',   'Eschwege' ],
	[ 'FEGW',  'Eschwege West' ],
	[ 'KE',    'Eschweiler Hbf' ],
	[ 'KET',   'Eschweiler Talbf' ],
	[ 'KEW',   'Eschweiler West' ],
	[ 'KEA',   'Eschweiler-Aue' ],
	[ 'KEN',   'Eschweiler-Nothb' ],
	[ 'KESJ',  'Eschweiler-St.Jö' ],
	[ 'FONH',  'Eschw-Niederhone' ],
	[ 'FEGWS', 'Eschw-Stegmühle' ],
	[ 'FEGWW', 'Eschw-Wehre' ],
	[ 'KWEI',  'Eschw-Weisweiler' ],
	[ 'SES',   'Eselsfürth' ],
	[ 'HESO',  'Esens(Ostfriesl)' ],
	[ 'XDES',  'Eskilstrup' ],
	[ 'XVEC',  'Eskilstuna C' ],
	[ 'XVEI',  'Eskilstuna I' ],
	[ 'XVEH',  'Eskilstuna-Hallb' ],
	[ 'XVEV',  'Eslöv' ],
	[ 'EEFO',  'Esn-Frohnhausen' ],
	[ 'HEKP',  'Espelkamp' ],
	[ 'EEPR',  'Espeln-Riege' ],
	[ 'LESP',  'Espenhain' ],
	[ 'LESG',  'Espenhain DB-Gr' ],
	[ 'NES',   'Espenloh' ],
	[ 'XXE',   'Espinho' ],
	[ 'FMHF',  'Esp-Mönchehof' ],
	[ 'AESL',  'Essel (Kr Stade)' ],
	[ 'XBES',  'Essen BE' ],
	[ 'HESN',  'Essen (Oldb)' ],
	[ 'EE',    'Essen Hbf' ],
	[ 'EE R',  'Essen Hbf Er' ],
	[ 'EE O',  'Essen Hbf Ero' ],
	[ 'EESD',  'Essen Süd' ],
	[ 'EENW',  'Essen West' ],
	[ 'EEAL',  'Essen-Altenessen' ],
	[ 'EEDL',  'Essen-Dellwig' ],
	[ 'EEIB',  'Essen-Eiberg' ],
	[ 'EEGE',  'Essen-Gerschede' ],
	[ 'EEHR',  'Essen-Horl' ],
	[ 'EEHT',  'Essen-Horst' ],
	[ 'EEHU',  'Essen-Hügel' ],
	[ 'EEKP',  'Essen-Karnap' ],
	[ 'EESA',  'Essen-Stadtwald' ],
	[ 'EEST',  'Essen-Steele' ],
	[ 'EESO',  'Essen-Steele Ost' ],
	[ 'EEUE',  'Essen-Überruhr' ],
	[ 'EEVL',  'Essen-Vogelheim' ],
	[ 'EEWD',  'Essen-Werden' ],
	[ 'TES',   'Essingen/b Aalen' ],
	[ 'NEN',   'Eßleben' ],
	[ 'TE',    'Esslingen/Neckar' ],
	[ 'TEZL',  'Esslingen-Zell' ],
	[ 'TEZLF', 'Esslingen-Zell F' ],
	[ 'TEME',  'Essl-Mettingen' ],
	[ 'TEMEF', 'Essl-Mettingen F' ],
	[ 'MESW',  'Esso Werkbf' ],
	[ 'XXES',  'Estarreja' ],
	[ 'EESOR', 'E-Steele O R-au' ],
	[ 'EESOB', 'E-Steele O Rbrü' ],
	[ 'MESG',  'Esting' ],
	[ 'HEST',  'Estorf (Weser)' ],
	[ 'XDED',  'Estvad' ],
	[ 'XMEZ',  'Esztergom' ],
	[ 'XFETP', 'Etampes' ],
	[ 'HETL',  'Etelsen' ],
	[ 'XFEP',  'Etrepagny' ],
	[ 'XLET',  'Ettelbruck' ],
	[ 'XFET',  'Ettendorf' ],
	[ 'UEH',   'Ettenhausen' ],
	[ 'NET',   'Etterzhausen' ],
	[ 'RETG',  'Ettlingen DB/AVG' ],
	[ 'RETE',  'Ettlingen Erbpr' ],
	[ 'RETF',  'Ettlingen Freib.' ],
	[ 'RETT',  'Ettlingen Stadt' ],
	[ 'RETW',  'Ettlingen Wasen' ],
	[ 'RETL',  'Ettlingen West' ],
	[ 'METG',  'Ettringen' ],
	[ 'EEZB',  'Etzbach' ],
	[ 'NEW',   'Etzelwang' ],
	[ 'REZB',  'Etzenbach' ],
	[ 'NEZ',   'Etzenricht' ],
	[ 'UET',   'Etzleben' ],
	[ 'XSEW',  'Etzwilen' ],
	[ 'TEU',   'Eubigheim' ],
	[ 'HEHD',  'Euer Heide' ],
	[ 'NEU',   'Euerdorf' ],
	[ 'XBEP',  'Eupen' ],
	[ 'TGME',  'Europastraße' ],
	[ 'KEU',   'Euskirchen' ],
	[ 'NEM',   'Eußenheim' ],
	[ 'AEU',   'Eutin' ],
	[ 'TEB',   'Eutingen (Baden)' ],
	[ 'TET N', 'Eutingen Em Nord' ],
	[ 'TET S', 'Eutingen Em Süd' ],
	[ 'TET',   'Eutingen im Gäu' ],
	[ 'TET K', 'Eutingen Kurve' ],
	[ 'LEU',   'Eutzsch' ],
	[ 'XCEV',  'Evdakovo' ],
	[ 'HEVH',  'Evendorf-Hörpel' ],
	[ 'XOEV',  'Evenstad' ],
	[ 'KEVS',  'Eversael' ],
	[ 'HEVR',  'Eversen' ],
	[ 'XXEV',  'Evora' ],
	[ 'XFEV',  'Evreux' ],
	[ 'TEY',   'Eyach' ],
	[ 'TEY H', 'Eyach HZL' ],
	[ 'TNEE',  'Eyachbrücke' ],
	[ 'HEYD',  'Eyendorf' ],
	[ 'XNEM',  'Eygelshov Markt' ],
	[ 'HETR',  'Eystrup' ],
	[ 'HETRN', 'Eystrup' ],
	[ 'XCEZ',  'Ezerishe' ],
	[ 'TFLA',  'F Landratsamt' ],
	[ 'XAFS',  'Faak am See' ],
	[ 'SKLN',  'Fabrikhof' ],
	[ 'FFAN',  'Fachingen (Lahn)' ],
	[ 'XIFA',  'Faenza' ],
	[ 'DFBE',  'Fährbrücke' ],
	[ 'AFK',   'Fahrenkrug' ],
	[ 'RFN',   'Fahrnau' ],
	[ 'XSFD',  'Faido' ],
	[ 'LF W',  'Fak ob Bf W 2' ],
	[ 'LF U',  'Fak unt Bf B 20' ],
	[ 'LF F',  'Fak unt Bf W 15' ],
	[ 'LF S',  'Fak unt Bf W 17' ],
	[ 'LF N',  'Fak unt Bf W 26' ],
	[ 'LF V',  'Fak Weichenv' ],
	[ 'XIFC',  'Falconara' ],
	[ 'XVFM',  'Falerum' ],
	[ 'DFU',   'Falkenau (Sachs)' ],
	[ 'DFUS',  'Falkenau Süd' ],
	[ 'XVFA',  'Falkenberg SE' ],
	[ 'LF',    'Falkenberg (E)' ],
	[ 'WFBG',  'Falkenberg (M)' ],
	[ 'LFUG',  'Falkenberg DB-Gr' ],
	[ 'LF O',  'Falkenberg ob Bf' ],
	[ 'LFN',   'Falkenbg-Kiebitz' ],
	[ 'BFAH',  'Falkenh b Nauen' ],
	[ 'WFAP',  'Falkenh Gew-Park' ],
	[ 'WFA',   'Falkenhagen (Pr)' ],
	[ 'WFAE',  'Falkenhagen EOP' ],
	[ 'WFAG',  'Falkenhgn DB-Gr' ],
	[ 'BFKS',  'Falkensee' ],
	[ 'DFA',   'Falkenstein (V)' ],
	[ 'XVFK',  'Falköping C' ],
	[ 'HF',    'Fallersleben' ],
	[ 'FABL',  'F-Altenbrunslar' ],
	[ 'XXFM',  'Famalicao' ],
	[ 'BFS',   'Fangschleuse' ],
	[ 'XIFN',  'Fano' ],
	[ 'MFCH',  'Farchant' ],
	[ 'XDFA',  'Farris' ],
	[ 'MFP',   'Fasanenpark' ],
	[ 'XIFS',  'Fasano' ],
	[ 'HFAS',  'Faserwerke' ],
	[ 'FFDF',  'Faßdorf' ],
	[ 'ZUF',   'Fastov 1' ],
	[ 'XXFT',  'Fatima' ],
	[ 'NFCH',  'Faulbach' ],
	[ 'BFAU',  'Fauler See' ],
	[ 'XFF',   'Faulquemont' ],
	[ 'TFAU',  'Faurndau' ],
	[ 'XOFK',  'Fauske' ],
	[ 'TFV',   'Favoritepark' ],
	[ 'TFVA',  'Favoritepark RWE' ],
	[ 'XFFHL', 'Fegersheim Lipsh' ],
	[ 'ABUF',  'Fehmarn-Burg' ],
	[ 'XSFE',  'Fehraltorf' ],
	[ 'HEBF',  'Feierabend' ],
	[ 'NFZ',   'Feilitzsch' ],
	[ 'MFA',   'Feldafing' ],
	[ 'RFB',   'Feldberg-Bärent.' ],
	[ 'AFEB',  'Felde-Brandsbek' ],
	[ 'EFEL',  'Feldhausen' ],
	[ 'XAFK',  'Feldkirch' ],
	[ 'MFK',   'Feldkirchen b Mü' ],
	[ 'XAFT',  'Feldkirchen(Kär)' ],
	[ 'MAFW',  'Feldkirchen-West' ],
	[ 'EFMK',  'Feldmark' ],
	[ 'XAFX',  'Felixdorf' ],
	[ 'XIFZ',  'Felizzano' ],
	[ 'TFE',   'Fellbach' ],
	[ 'FGEF',  'Felsbg-Gensungen' ],
	[ 'XMFZ',  'Felsözsolca' ],
	[ 'XLF',   'Fentange' ],
	[ 'BFLZ',  'Ferch-Lienewitz' ],
	[ 'WFDF',  'Ferdinandshof' ],
	[ 'XMBF',  'Ferencvaros' ],
	[ 'LFMW',  'Fermerswalde' ],
	[ 'EFER',  'Ferndorf/Siegen' ],
	[ 'XIFMA', 'Ferno-Malpensa' ],
	[ 'XIFR',  'Ferrania' ],
	[ 'XIFE',  'Ferrara' ],
	[ 'XUF',   'Fetesti' ],
	[ 'NFT',   'Feucht' ],
	[ 'NFTO',  'Feucht Ost' ],
	[ 'NFTM',  'Feucht-Moosbach' ],
	[ 'MFWG',  'Feuchtwangen' ],
	[ 'EFEU',  'Feudingen' ],
	[ 'BFB',   'Feuerbachstraße' ],
	[ 'RBRL',  'Feuerwehrschule' ],
	[ 'FFBK',  'Ff-Berkersheim' ],
	[ 'FFES',  'Ff-Eschersheim' ],
	[ 'FFBS',  'Ff-Frankf Berg' ],
	[ 'FGM',   'Ff-Griesheim' ],
	[ 'FHOE',  'Ff-Höchst' ],
	[ 'FFAWA', 'Ff-Höchst Farb Ü' ],
	[ 'FFAW',  'Ff-Höchst Farbw.' ],
	[ 'FHOEG', 'Ff-Höchst Gbf' ],
	[ 'FHOEA', 'Ff-Höchst Pbf/Gb' ],
	[ 'FHOES', 'Ff-Höchst S-B/F' ],
	[ 'FLS',   'Ff-Louisa' ],
	[ 'FLSS',  'Ff-Louisa S-Bahn' ],
	[ 'FFLF',  'Ffm Flughf Fbf' ],
	[ 'FFLU',  'Ffm Flughf Regio' ],
	[ 'FFTGF', 'Ffm Frz' ],
	[ 'FFGA',  'Ffm Galluswarte' ],
	[ 'FHAU',  'Ffm Hauptwache' ],
	[ 'FFT',   'Ffm Hbf (tief)' ],
	[ 'FFAU',  'Ffm Hbf Außenbf' ],
	[ 'FKON',  'Ffm Konstablerw' ],
	[ 'FLBF',  'Ffm Lokalbahnhof' ],
	[ 'FFME',  'Ffm Messe' ],
	[ 'FMUL',  'Ffm Mühlberg' ],
	[ 'FFO G', 'Ffm Ost Gbf' ],
	[ 'FFO U', 'Ffm Ost Ubf' ],
	[ 'FFO V', 'Ffm Ost Vbf' ],
	[ 'FOST',  'Ffm Ostendstraße' ],
	[ 'FSHF',  'Ffm Schlachthof' ],
	[ 'FSP',   'Ffm Stadion' ],
	[ 'FSP S', 'Ffm Stadion Süd' ],
	[ 'FSTL',  'Ffm Stresemann' ],
	[ 'FFS',   'Ffm Süd' ],
	[ 'FFS A', 'Ffm Süd Abstbf' ],
	[ 'FFTA',  'Ffm Taunusanlage' ],
	[ 'FFW A', 'Ffm W S-B Überl' ],
	[ 'FFW',   'Ffm West' ],
	[ 'FFMK',  'Ff-Mainkur' ],
	[ 'FFGI',  'Ffm-Ginnheim' ],
	[ 'FULB',  'Ffm-U liederbach' ],
	[ 'FNI',   'Ff-Niederrad' ],
	[ 'FNI S', 'Ff-Niederrad Hp' ],
	[ 'FRH',   'Ff-Rödelheim' ],
	[ 'FSWF',  'Ff-Schwanheim F' ],
	[ 'FSWS',  'Ff-Schwanheim S' ],
	[ 'FSO',   'Ff-Sossenheim' ],
	[ 'FFZH',  'Ff-Zeilsheim' ],
	[ 'BFSS',  'Fh Bln-Schönef S' ],
	[ 'LFLU',  'Fh Leipzig/Halle' ],
	[ 'TFI',   'Fichtenberg' ],
	[ 'XIFD',  'Fidenza' ],
	[ 'XAFB',  'Fieberbrunn' ],
	[ 'AFFB',  'Fiefbergen' ],
	[ 'XEFI',  'Figueras' ],
	[ 'FIH',   'F-Ihringshausen' ],
	[ 'TFIL',  'Filderstadt' ],
	[ 'XUFI',  'Filiasi' ],
	[ 'XSFI',  'Filisur' ],
	[ 'FFI',   'Filsen' ],
	[ 'XIFLM', 'Finale Ligure M' ],
	[ 'BFIH',  'Finkenheerd' ],
	[ 'BFIN',  'Finkenkrug' ],
	[ 'BAFI',  'Finkenkrug (Afi)' ],
	[ 'EFP',   'Finnentrop' ],
	[ 'MFNS',  'Finninger Straße' ],
	[ 'XOFI',  'Finse' ],
	[ 'BFW',   'Finsterwalde NL' ],
	[ 'XIFI',  'Fiorenzuola' ],
	[ 'XIFRC', 'Firenze C. d. M.' ],
	[ 'XIFRR', 'Firenze Rifredi' ],
	[ 'XIFRS', 'Firenze S.M.N' ],
	[ 'MFIS',  'Fischach/Schwab' ],
	[ 'MFI',   'Fischbach (Inn)' ],
	[ 'NFIH',  'Fischbach (Nür)' ],
	[ 'MFBU',  'Fischbachau' ],
	[ 'SFC',   'Fischbach-Camph' ],
	[ 'SFWB',  'Fischbach-Weierb' ],
	[ 'AFIB',  'Fischbek' ],
	[ 'MFN',   'Fischen' ],
	[ 'KFIN',  'Fischenich' ],
	[ 'HFIS',  'Fischerhof' ],
	[ 'MFIN',  'Fischhsn-Neuhaus' ],
	[ 'RFIW',  'Fischweier' ],
	[ 'BFPN',  'Fko-Neuberesin' ],
	[ 'BFRS',  'Fko-Rosengarten' ],
	[ 'AFWI',  'Fl Wilhelminent' ],
	[ 'XOF',   'Fla' ],
	[ 'XSFM',  'Flamatt' ],
	[ 'KFL',   'Flammersfeld' ],
	[ 'EFLA',  'Flandersbach' ],
	[ 'XEFL',  'Flassa' ],
	[ 'XAFG',  'Flaurling' ],
	[ 'LFG',   'Flechtingen' ],
	[ 'LFL',   'Fleetmark' ],
	[ 'RFL',   'Flehingen' ],
	[ 'XVFB',  'Flemingsberg' ],
	[ 'XVFN',  'Flen' ],
	[ 'AF',    'Flensburg' ],
	[ 'AXFW',  'Flensburg Grenze' ],
	[ 'AFS',   'Flensburg Süd' ],
	[ 'AFW',   'Flensburg Weiche' ],
	[ 'XFFL',  'Flers' ],
	[ 'MFHB',  'Flh Mü Besucherp' ],
	[ 'MFTL',  'Flh Mü Tanklager' ],
	[ 'MFHT',  'Flh Mü Terminal' ],
	[ 'MFHW',  'Flh München West' ],
	[ 'FFD',   'Flieden' ],
	[ 'BFL',   'Fließ' ],
	[ 'AFT',   'Flintbek' ],
	[ 'MFLI',  'Flintsbach' ],
	[ 'XAFL',  'Flirsch' ],
	[ 'EDFM',  'Flm /Dortmund' ],
	[ 'XVFY',  'Floby' ],
	[ 'XVFL',  'Floda' ],
	[ 'DFL',   'Flöha' ],
	[ 'DFLP',  'Flöha-Plaue' ],
	[ 'RFLO',  'Flomersheim' ],
	[ 'LFLO',  'Florastraße' ],
	[ 'XAWFL', 'Floridsdorf' ],
	[ 'FFH',   'Flörsheim (Main)' ],
	[ 'DFM',   'Floßmühle' ],
	[ 'XSFU',  'Flüelen' ],
	[ 'TCFL',  'Flügelau' ],
	[ 'TFFL',  'Flug Friedrichsh' ],
	[ 'TFL',   'Flughafen Stg' ],
	[ 'MFHM',  'Flughf München' ],
	[ 'KFNO',  'Flughf Nordost' ],
	[ 'KFNW',  'Flughf Nordwest' ],
	[ 'XSFL',  'Flums' ],
	[ 'XUFC',  'Focsani' ],
	[ 'XAFC',  'Föderlach' ],
	[ 'XIFO',  'Foggia' ],
	[ 'LFDE',  'Fohrde' ],
	[ 'SFOE',  'Föhren' ],
	[ 'XIFOL', 'Foligno' ],
	[ 'XKF',   'Folkestone' ],
	[ 'XFFT',  'Fontaine' ],
	[ 'XFFA',  'Fontainebleau' ],
	[ 'XIFP',  'Fontanetto Po' ],
	[ 'XFFS',  'Fontan-Saorge' ],
	[ 'XMF',   'Fonyod' ],
	[ 'XMFL',  'Fonyodliget' ],
	[ 'XFFB',  'Forbach' ],
	[ 'RFCH',  'Forbach(Schwarz)' ],
	[ 'NFOE',  'Förbau' ],
	[ 'NFO',   'Forchheim (Ofr)' ],
	[ 'RFM',   'Forchheim/Karlsr' ],
	[ 'RFM H', 'Forchhm Hauptstr' ],
	[ 'LFDA',  'Förderst Awanst' ],
	[ 'LFD',   'Förderstedt' ],
	[ 'DFOE',  'Fördertechnik' ],
	[ 'XBFM',  'Forest-Midi' ],
	[ 'XIFL',  'Forli' ],
	[ 'XIFM',  'Formia' ],
	[ 'TFB',   'Fornsbach' ],
	[ 'KJSU',  'Forschungszentr' ],
	[ 'XVFO',  'Forserum' ],
	[ 'XVFH',  'Forsheda' ],
	[ 'RFO',   'Forst' ],
	[ 'BFO',   'Forst (Lausitz)' ],
	[ 'BXFO',  'Forst(L) Grenze' ],
	[ 'FKBHF', 'Forstfeldstraße' ],
	[ 'FFOR',  'Forsthaus' ],
	[ 'KFOS',  'Forsthaus' ],
	[ 'LFSE',  'Forsthaus Eiche' ],
	[ 'MFOS',  'Forsting' ],
	[ 'BFOW',  'Forstweg' ],
	[ 'XIFF',  'Fort./Franzensf.' ],
	[ 'XIFDM', 'Forte dei Marmi' ],
	[ 'NFH',   'Forth' ],
	[ 'UF',    'Förtha (Kr Eis)' ],
	[ 'NFDF',  'Förtschendorf' ],
	[ 'KFO',   'Fortuna' ],
	[ 'XIF',   'Fossano' ],
	[ 'XFFLT', 'Fourchambault' ],
	[ 'XMFV',  'Fövenyes' ],
	[ 'NFHB',  'Frahelsbruck' ],
	[ 'XBFR',  'Fraipont' ],
	[ 'XVFC',  'Framnäs City' ],
	[ 'DFK',   'Frankenberg (S)' ],
	[ 'DFKS',  'Frankenberg Süd' ],
	[ 'FFRG',  'Frankenberg-Goßb' ],
	[ 'FFRK',  'Frankenbg (Eder)' ],
	[ 'UFN',   'Frankenhain' ],
	[ 'XAFA',  'Frankenmarkt' ],
	[ 'RFST',  'Frankenst/Pfalz' ],
	[ 'DFRS',  'Frankenstein' ],
	[ 'RFT',   'Frankenthal Hbf' ],
	[ 'BFA',   'Frankf Allee S-B' ],
	[ 'KPHF',  'Frankf Str Abzw' ],
	[ 'BFGU',  'Frankf(O)Gülddf' ],
	[ 'BXF',   'Frankft(O)Grenze' ],
	[ 'BFP',   'Frankfurt (O)' ],
	[ 'BFFS',  'Frankfurt Strw' ],
	[ 'FF H',  'Frankfurt(M) H/T' ],
	[ 'FF',    'Frankfurt(M) Hbf' ],
	[ 'FFO',   'Frankfurt(M) Ost' ],
	[ 'FFK',   'Frankfurter Krz' ],
	[ 'KKFS',  'Frankfurter Str' ],
	[ 'FFND',  'Frankfurt-Nied' ],
	[ 'LFA',   'Frankleben' ],
	[ 'XTFA',  'Frant Lazne Auqa' ],
	[ 'XTF',   'Frantiskovy Lazn' ],
	[ 'XBFLA', 'Frasnes-lez-Anv' ],
	[ 'XAFR',  'Frastanz' ],
	[ 'RFS',   'Frauenalb-Schie.' ],
	[ 'NFU',   'Frauenau' ],
	[ 'NFRA',  'Frauenaurach' ],
	[ 'XSFA',  'Frauenfeld' ],
	[ 'BFR',   'Frauenhain' ],
	[ 'BQFR',  'Frauenhain SN/BB' ],
	[ 'HFAH',  'Fr-August-Hütte' ],
	[ 'KFRE',  'Frechen' ],
	[ 'KFRB',  'Frechen Rh-braun' ],
	[ 'KFKO',  'Frechen-Königsdf' ],
	[ 'LFK',   'Freckleben' ],
	[ 'HFRE',  'Freden (Leine)' ],
	[ 'AFE',   'Fredenbeck' ],
	[ 'XDF',   'Fredericia' ],
	[ 'XDFH',  'Frederikshavn' ],
	[ 'XDFHH', 'Frederikshavn G' ],
	[ 'BFDG',  'Fredersdf DB-Gr' ],
	[ 'BFD',   'Fredersdorf S-B' ],
	[ 'BFDZ',  'Fredersdorf b Bi' ],
	[ 'BFRD',  'Fredersdorf(Bln)' ],
	[ 'XOFR',  'Fredrikstad' ],
	[ 'DFR',   'Freiberg (Sachs)' ],
	[ 'DFRG',  'Freiberg DB-Gr' ],
	[ 'TFG',   'Freiberg/Neckar' ],
	[ 'RFLT',  'Freibg-Littenw' ],
	[ 'RFSG',  'Freibg-St Georg' ],
	[ 'RFZ',   'Freibg-Zähringen' ],
	[ 'RFK',   'Freiburg Klinik' ],
	[ 'RFMU',  'Freiburg Messe/U' ],
	[ 'RFGS',  'Freiburg Süd' ],
	[ 'RFW',   'Freiburg West' ],
	[ 'RFG',   'Freiburg(Brg)Gbf' ],
	[ 'RF',    'Freiburg(Brg)Hbf' ],
	[ 'RFHE',  'Freiburg-Herdern' ],
	[ 'RFWI',  'Freiburg-Wiehre' ],
	[ 'XSFB',  'Freienbach CH' ],
	[ 'EFRE',  'Freienohl' ],
	[ 'UFO',   'Freienorla' ],
	[ 'MFHD',  'Freihalden' ],
	[ 'MFHU',  'Freihalden Üst' ],
	[ 'NFR',   'Freihöls' ],
	[ 'NFRE',  'Freihung' ],
	[ 'MFLH',  'Freilass-Hofham' ],
	[ 'MFL',   'Freilassing' ],
	[ 'FFRH',  'Freimersheim' ],
	[ 'RFHM',  'Freinsheim' ],
	[ 'MFR',   'Freising' ],
	[ 'DFB',   'Freit Ost G-Anl' ],
	[ 'DFBS',  'Freital Ost' ],
	[ 'DHGW',  'Freital-Hainsb W' ],
	[ 'DHG',   'Freital-Hainsbg' ],
	[ 'DFD',   'Freit-Deuben' ],
	[ 'DFH',   'Freit-Hainsbg Hp' ],
	[ 'DPA',   'Freit-Potschapp' ],
	[ 'XFFR',  'Frejus-St-Raph' ],
	[ 'HFST',  'Frellstedt' ],
	[ 'AFF',   'Frelsdorf' ],
	[ 'SFF',   'Fremersdorf' ],
	[ 'XSFF',  'Frenkendorf-Füll' ],
	[ 'NFF',   'Frensdorf' ],
	[ 'LFZ',   'Frenz' ],
	[ 'KFR',   'Frenz Anst' ],
	[ 'AFN',   'Fresenburg' ],
	[ 'WFD',   'Fretzdorf' ],
	[ 'NFM',   'Freudenberg' ],
	[ 'TFSG',  'Freudenst AVG/DB' ],
	[ 'TFSI',  'Freudenst Ind' ],
	[ 'TFSS',  'Freudenst Stadt' ],
	[ 'TFS',   'Freudenstadt Hbf' ],
	[ 'TFSZ',  'Freudenstadt SZ' ],
	[ 'TFST',  'Freudenstein' ],
	[ 'EFBU',  'Freusbg Siedlung' ],
	[ 'UFB',   'Freyburg (Unstr)' ],
	[ 'UFB B', 'Freyburg Bahnstg' ],
	[ 'XFML',  'Freyming-Merleb' ],
	[ 'NFY',   'Freyung' ],
	[ 'TFF',   'Fr-Fischbach' ],
	[ 'XSF',   'Fribourg' ],
	[ 'TFKHK', 'Frickenh Kelters' ],
	[ 'TFKH',  'Frickenhausen' ],
	[ 'FFRN',  'Frickhofen' ],
	[ 'TFD',   'Fridingen b Tutt' ],
	[ 'MFDF',  'Fridolfing' ],
	[ 'FFG',   'Friedberg (Hess)' ],
	[ 'FFG G', 'Friedberg Görbel' ],
	[ 'FFG H', 'Friedberg Hohl' ],
	[ 'FGS',   'Friedberg Süd' ],
	[ 'MFDB',  'Friedberg/Augsbg' ],
	[ 'FFN',   'Friedelhausen' ],
	[ 'RFRI',  'Friedelsheim' ],
	[ 'BFRU',  'Friedenau' ],
	[ 'FFRD',  'Friedensdorf (L)' ],
	[ 'AFR',   'Friedensweg' ],
	[ 'BFDF',  'Friedersdorf' ],
	[ 'WFR',   'Friedland' ],
	[ 'HFRI',  'Friedland (Han)' ],
	[ 'HQFR',  'Friedland NI/HE' ],
	[ 'TF R',  'Friedrhf Gbf' ],
	[ 'TFH',   'Friedrhf Hafen' ],
	[ 'TF',    'Friedrhf Stadt' ],
	[ 'UFR',   'Friedrichroda' ],
	[ 'AFBG',  'Friedrichsbg' ],
	[ 'FFRI',  'Friedrichsdf(Ts)' ],
	[ 'BFFO',  'Friedrichsf Ost' ],
	[ 'EFFD',  'Friedrichsfeld' ],
	[ 'AFRG',  'Friedrichsgabe' ],
	[ 'TFOS',  'Friedrichshf Ost' ],
	[ 'BFHG',  'Friedrichshg Bk' ],
	[ 'LFH',   'Friedrichshöhe' ],
	[ 'FKFPL', 'Friedrichsplatz' ],
	[ 'AFRD',  'Friedrichsruh' ],
	[ 'WFRR',  'Friedrichsruhe' ],
	[ 'KFGN',  'Friedrichssegen' ],
	[ 'RFTL',  'Friedrichst(Ba)' ],
	[ 'SFI',   'Friedrichst.(S)' ],
	[ 'AFD',   'Friedrichstadt' ],
	[ 'RFRT',  'Friedrichstal' ],
	[ 'BFSTT', 'Friedrichstr Tun' ],
	[ 'TFSK',  'Friedrichstr.Si.' ],
	[ 'BFST',  'Friedrichstraße' ],
	[ 'WFL',   'Friedrichswalde' ],
	[ 'WFRW',  'Friedrichswalde' ],
	[ 'SFIM',  'Friedrthal Mitte' ],
	[ 'NFSB',  'Friedrthal/Bayr' ],
	[ 'XAF',   'Friesach' ],
	[ 'WFRK',  'Friesack (Mark)' ],
	[ 'LFI',   'Friesdorf' ],
	[ 'LFIO',  'Friesdorf Ost' ],
	[ 'HFRB',  'Friesenbrücke' ],
	[ 'RFH',   'Friesenhm(Baden)' ],
	[ 'HFRY',  'Friesoythe' ],
	[ 'HFLL',  'Frille' ],
	[ 'KFRI',  'Frimmersdorf' ],
	[ 'XVFD',  'Fristad' ],
	[ 'XDFV',  'Frisvardvej' ],
	[ 'XVFR',  'Fritsla' ],
	[ 'XAFW',  'Fritzens-Wattens' ],
	[ 'FFZ',   'Fritzlar' ],
	[ 'FFZO',  'Fritzlar Opperm' ],
	[ 'TKLU',  'Fr-Kluftern' ],
	[ 'TBK',   'Fr-Kochendorf' ],
	[ 'TMAN',  'Fr-Manzell' ],
	[ 'LFB',   'Frohburg' ],
	[ 'XFFM',  'Frohmuhl' ],
	[ 'EFRM',  'Frömern' ],
	[ 'TFR',   'Frommern' ],
	[ 'EFOE',  'Fröndenberg' ],
	[ 'FFRL',  'Fronhausen (La)' ],
	[ 'XFFX',  'Frontenex' ],
	[ 'MFMK',  'Frontenhsn-Markl' ],
	[ 'LFE',   'Frose' ],
	[ 'UFT',   'Fröttstädt' ],
	[ 'XFFD',  'Frouard' ],
	[ 'XIFB',  'Frugarolo-Bosc' ],
	[ 'XSFR',  'Frutigen' ],
	[ 'FSINO', 'F-Sindl Ostbstg' ],
	[ 'FSIN',  'F-Sindl Westbstg' ],
	[ 'XEFC',  'Fuencarral' ],
	[ 'FKRFF', 'Fünffensterstr' ],
	[ 'XEFO',  'Fuentes de Onoro' ],
	[ 'FFUR',  'Fürfurt' ],
	[ 'XMFR',  'Fürjes' ],
	[ 'XAFU',  'Fürnitz' ],
	[ 'WF',    'Fürstenberg(H)' ],
	[ 'WQF',   'Fürstenbg(H) LGr' ],
	[ 'MFB',   'Fürstenfeldbruck' ],
	[ 'SFH',   'Fürstenhausen' ],
	[ 'BFUW',  'Fürstenw (Spree)' ],
	[ 'BFUA',  'Fürstenw Getreid' ],
	[ 'BFUS',  'Fürstenw Süd' ],
	[ 'FFNW',  'Fürstenwald' ],
	[ 'MFZL',  'Fürstenzell' ],
	[ 'NF G',  'Fürth (Bay) Gbf' ],
	[ 'NF',    'Fürth (Bay) Hbf' ],
	[ 'RFUE',  'Fürth (Odenw)' ],
	[ 'NAEG',  'Fürth Gbf AEG' ],
	[ 'NFWS',  'Fürth Westvorst' ],
	[ 'NFBB',  'Fürth-Burgfbach' ],
	[ 'NFDB',  'Fürth-Dambach' ],
	[ 'NFUB',  'Fürth-Untfarrnb' ],
	[ 'NFUF',  'Fürth-Untfürberg' ],
	[ 'NFUA',  'Fürth-UntfürbgA' ],
	[ 'MFSN',  'Füssen' ],
	[ 'RFTZ',  'Fützen' ],
	[ 'XMFA',  'Füzesabony' ],
	[ 'FFU',   'Fulda' ],
	[ 'FFU G', 'Fulda Gbf' ],
	[ 'FFU W', 'Fulda Gbf (W123)' ],
	[ 'FFU N', 'Fulda SFS Nord' ],
	[ 'FFU B', 'Fulda(Bronnzell)' ],
	[ 'XAFM',  'Fulpmes' ],
	[ 'XDFU',  'Funder' ],
	[ 'ZUFK',  'Fundukleevka' ],
	[ 'RFU',   'Furschenbach' ],
	[ 'NXFU',  'Furth i W Grenze' ],
	[ 'NFW',   'Furth i Wald' ],
	[ 'MFU',   'Furth/b Deisenh' ],
	[ 'XOFU',  'Furumo' ],
	[ 'RFGM',  'Fußgönheim' ],
	[ 'XFFU',  'Futuroscope' ],
	[ 'KFWH',  'F-W-Hütte' ],
	[ 'FWON',  'F-Wolfershausen' ],
	[ 'XDGR',  'Gaarde' ],
	[ 'HGA',   'Gabelung' ],
	[ 'HGAA',  'Gabelung (Brg)' ],
	[ 'MGAL',  'Gablingen' ],
	[ 'WGA',   'Gadebusch' ],
	[ 'NGAE',  'Gädheim' ],
	[ 'XPGA',  'Gadki' ],
	[ 'XUGE',  'Gaesti' ],
	[ 'XCGA',  'Gagarin' ],
	[ 'RGG',   'Gaggenau' ],
	[ 'XFGN',  'Gagny' ],
	[ 'TGDS',  'Gaildorf Stadt' ],
	[ 'TGAW',  'Gaildorf West' ],
	[ 'XFGAA', 'Gaillon-Aubevoye' ],
	[ 'MGH',   'Gaimersheim' ],
	[ 'MGAI',  'Gaißach' ],
	[ 'XPGJ',  'Gajec' ],
	[ 'XYG',   'Galanta' ],
	[ 'SGSZ',  'Galgenschanze' ],
	[ 'XIGA',  'Gallarate' ],
	[ 'EGAB',  'Gallberg' ],
	[ 'WGAL',  'Gallin' ],
	[ 'WGAG',  'Gallin DB-Gr' ],
	[ 'ZIGW',  'Galway' ],
	[ 'XIGAM', 'Gamalero' ],
	[ 'FGAM',  'Gambach (Hess)' ],
	[ 'XIGBR', 'Gambolo Remondo' ],
	[ 'TGAM',  'Gamburg' ],
	[ 'XVGL',  'Gamleby' ],
	[ 'TGMT',  'Gammertingen' ],
	[ 'XSGM',  'Gampel-Steg' ],
	[ 'HGKE',  'Ganderkesee' ],
	[ 'XFGD',  'Gandrange' ],
	[ 'MGKN',  'Gangkofen' ],
	[ 'UGSM',  'Gangloffsömmern' ],
	[ 'XFGAN', 'Gannat' ],
	[ 'XAGD',  'Gänserndorf' ],
	[ 'EGAR',  'Garbeck' ],
	[ 'FGA',   'Garbenteich' ],
	[ 'MGA',   'Garching (Alz)' ],
	[ 'XRGA',  'Garcin' ],
	[ 'XFGA',  'Gardanne' ],
	[ 'LGA',   'Gardelegen' ],
	[ 'LGAU',  'Gardelegen Üst' ],
	[ 'XOGM',  'Gardermoen' ],
	[ 'AGD',   'Garding' ],
	[ 'XMGD',  'Gardony' ],
	[ 'XVGJ',  'Gardsjö' ],
	[ 'WGFZ',  'Garftitz' ],
	[ 'XIGLC', 'Garlasco' ],
	[ 'HGAT',  'Garlstorf(Harbg)' ],
	[ 'MGP',   'Garmisch-Partenk' ],
	[ 'XAGAR', 'Garnei' ],
	[ 'HGAL',  'Garrel' ],
	[ 'MGS',   'Gars (Inn)' ],
	[ 'HGAR',  'Garßen' ],
	[ 'HGAS',  'Garstedt(Lünebg)' ],
	[ 'TGT',   'Gärtringen' ],
	[ 'NGAS',  'Gasseldorf' ],
	[ 'LGAL',  'Gatersleben' ],
	[ 'XIGT',  'Gatteo a Mare' ],
	[ 'FGAL',  'Gau Algesheim' ],
	[ 'FGBM',  'Gau Bickelheim' ],
	[ 'TQGR',  'Gaubüttelbr LGr' ],
	[ 'TGRN',  'Gaubüttelbrunn' ],
	[ 'TGFD',  'Gäufelden' ],
	[ 'RGBA',  'Gausbach' ],
	[ 'TGSF',  'Gauselfingen' ],
	[ 'MGT',   'Gauting' ],
	[ 'XVG',   'Gävle' ],
	[ 'XPGAW', 'Gaworzyce' ],
	[ 'XYGB',  'Gbelce' ],
	[ 'XPG',   'Gdansk Glowny' ],
	[ 'XPGNP', 'Gdansk Nowy Port' ],
	[ 'XPGOL', 'Gdansk Oliwa' ],
	[ 'XPGWR', 'Gdansk Wrzeszcz' ],
	[ 'XPGD',  'Gdynia Gl Os' ],
	[ 'XPGP',  'Gdynia Port' ],
	[ 'EGBH',  'Gebhardsh-Stein' ],
	[ 'EGBK',  'Ge-Bismarck' ],
	[ 'UGBH',  'Gebra(Hainleite)' ],
	[ 'EGBN',  'Ge-Buer Nord' ],
	[ 'EGBU',  'Ge-Buer Nord Hp' ],
	[ 'EGBS',  'Ge-Buer Süd' ],
	[ 'XDG',   'Gedser' ],
	[ 'HGEE',  'Geeste' ],
	[ 'AGTH',  'Geestenseth' ],
	[ 'LGG',   'Geestgottberg' ],
	[ 'LQGG',  'Geestgottbg LGr' ],
	[ 'AGEH',  'Geesthacht' ],
	[ 'EGHS',  'Ge-Hassel' ],
	[ 'UGB',   'Gehlberg' ],
	[ 'HGBG',  'Gehlbergen' ],
	[ 'UGE',   'Gehofen' ],
	[ 'EGHN',  'Ge-Horst Nord' ],
	[ 'HGE',   'Gehrenrode' ],
	[ 'BGSE',  'Gehrenseestr' ],
	[ 'TBGG',  'Gehrn' ],
	[ 'NGET',  'Geigant' ],
	[ 'KGEK',  'Geilenkirchen' ],
	[ 'KGKK',  'Geilenkirchen KB' ],
	[ 'KGEH',  'Geilhausen' ],
	[ 'KQGE',  'Geilhausen LGr' ],
	[ 'XOGI',  'Geilo' ],
	[ 'XAGEI', 'Geinberg' ],
	[ 'MGLG',  'Geiselhöring' ],
	[ 'MGIB',  'Geisenbrunn' ],
	[ 'MGHS',  'Geisenhausen' ],
	[ 'FGSM',  'Geisenheim' ],
	[ 'DGEI',  'Geising' ],
	[ 'RGSN',  'Geisingen' ],
	[ 'TG',    'Geislingen (St)' ],
	[ 'TGW',   'Geislingen West' ],
	[ 'RGA',   'Geisngn-Aulfgn' ],
	[ 'RGHA',  'Geisngn-Hausen' ],
	[ 'RGK',   'Geisngn-Kirchen' ],
	[ 'RGL',   'Geisngn-Leipferd' ],
	[ 'EGST',  'Geist' ],
	[ 'MGEU',  'Geitau' ],
	[ 'LGH',   'Geithain' ],
	[ 'XIGL',  'Gela' ],
	[ 'WGE',   'Gelbensande' ],
	[ 'KGE',   'Geldern' ],
	[ 'XNLU',  'Geleen-Lutterade' ],
	[ 'XSGT',  'Gellert(Bas SBB)' ],
	[ 'XSGTR', 'Gellert(Muttenz)' ],
	[ 'FGEL',  'Gelnhausen' ],
	[ 'EG',    'Gelsenk Hbf' ],
	[ 'EGZO',  'Gelsenk Zoo' ],
	[ 'MGE',   'Geltendorf' ],
	[ 'XSGK',  'Gelterkinden' ],
	[ 'EBUG',  'Gemeinde Burbach' ],
	[ 'TGEM',  'Gemmingen' ],
	[ 'TGEW',  'Gemmingen West' ],
	[ 'XIGF',  'Gemona Friuli' ],
	[ 'KGEG',  'Gemünd DB-Gr' ],
	[ 'NGM',   'Gemünden (Main)' ],
	[ 'NGM S', 'Gemünden Saalebr' ],
	[ 'MGKG',  'Genderkingen' ],
	[ 'MGND',  'Gendorf' ],
	[ 'XSGE',  'Geneve' ],
	[ 'XSXGE', 'Geneve Gr FR' ],
	[ 'XSGEP', 'Geneve La Praill' ],
	[ 'XSGEA', 'Geneve-Aeroport' ],
	[ 'RGB',   'Gengenbach' ],
	[ 'XBGK',  'Genk' ],
	[ 'XBGKF', 'Genk (Ford)' ],
	[ 'SGN',   'Gennweiler' ],
	[ 'XIGQ',  'Genova Acquas' ],
	[ 'XIGBO', 'Genova Bolzaneto' ],
	[ 'XIGBZ', 'Genova Borzoli' ],
	[ 'XIGB',  'Genova Brignole' ],
	[ 'XIGCS', 'Genova Costa' ],
	[ 'XIGG',  'Genova Granara' ],
	[ 'XIGMA', 'Genova M.' ],
	[ 'XIGPD', 'Genova Pontedec' ],
	[ 'XIGP',  'Genova PP' ],
	[ 'XIGRV', 'Genova Rivarolo' ],
	[ 'XIGBQ', 'Genova S Biagio' ],
	[ 'XIGSL', 'Genova S. Limb' ],
	[ 'XIGSS', 'Genova Samp Sm' ],
	[ 'XIGSD', 'Genova Sampierd.' ],
	[ 'XIGSP', 'Genova Sestri P' ],
	[ 'BGH M', 'Gensh Heide Mitt' ],
	[ 'BGH N', 'Gensh Heide Nord' ],
	[ 'BGHO',  'Gensh Heide Ost' ],
	[ 'BGH',   'Genshagenr Heide' ],
	[ 'FGHA',  'Gens-Horrw' ],
	[ 'FGHS',  'Gens-Horrw Sond' ],
	[ 'FGHO',  'Gensingen-Horrw' ],
	[ 'XBG',   'Gent' ],
	[ 'XBGB',  'Gentbrugge' ],
	[ 'LGN',   'Genthin' ],
	[ 'XBGP',  'Gent-St-Pieters' ],
	[ 'XBGZ',  'Gent-Zeehaven' ],
	[ 'LGEZ',  'Genzien' ],
	[ 'NGE',   'Georgensgmünd' ],
	[ 'UGTT',  'Georgenthal (Th)' ],
	[ 'HGEO',  'Georgschacht' ],
	[ 'HGMH',  'Georgsmarienhtte' ],
	[ 'UG G',  'Gera Güterbf' ],
	[ 'UG',    'Gera Hbf' ],
	[ 'UGOT',  'Gera Ost' ],
	[ 'UGS',   'Gera Süd' ],
	[ 'UGBG',  'Geraberg' ],
	[ 'UGDV',  'Gera-Deb DB-Gr' ],
	[ 'UGDE',  'Gera-Debschwitz' ],
	[ 'TGES',  'Geradstetten' ],
	[ 'UGKB',  'Gera-Gessental' ],
	[ 'UGLB',  'Gera-Langenberg' ],
	[ 'UGLW',  'Gera-Liebschwitz' ],
	[ 'EGDB',  'Gerätedepot Bdw' ],
	[ 'UG T',  'Gera-Tinz' ],
	[ 'UGZ',   'Gera-Zwötzen' ],
	[ 'TGEH',  'Gerhausen' ],
	[ 'LGE',   'Gerichshain' ],
	[ 'TGLH',  'Gerlachsheim' ],
	[ 'XSGF',  'Gerlafingen' ],
	[ 'MGLH',  'Gerlenhofen' ],
	[ 'XAGE',  'Gerling/Pinzgau' ],
	[ 'MUG',   'Germering-Upfhfn' ],
	[ 'RGEH',  'Germersh Mitte/H' ],
	[ 'RGE',   'Germersheim' ],
	[ 'RGEM',  'Germershm Mitte' ],
	[ 'RGES',  'Germershm Süd' ],
	[ 'MGLD',  'Gernlinden' ],
	[ 'UNDO',  'Gernro-Niederor' ],
	[ 'RGS',   'Gernsbach' ],
	[ 'RGSD',  'Gernsbach Mitte' ],
	[ 'FGHM',  'Gernsheim' ],
	[ 'TGN',   'Geroldshausen' ],
	[ 'SGRB',  'Gerolst Basalt' ],
	[ 'SGR',   'Gerolstein' ],
	[ 'SGRG',  'Gerolstein DB-Gr' ],
	[ 'NGER',  'Gerolzhofen' ],
	[ 'XEG',   'Gerona(Viajeros)' ],
	[ 'EGRO',  'Ge-Rotthausen' ],
	[ 'EGED',  'Gerschede' ],
	[ 'DGD',   'Gersdorf (b Gör)' ],
	[ 'FGFD',  'Gersfeld (Rhön)' ],
	[ 'TGSN',  'Gerstetten' ],
	[ 'MGHF',  'Gersthofen' ],
	[ 'UGT',   'Gerstungen' ],
	[ 'UQGT',  'Gerstungen 6340' ],
	[ 'UQGTV', 'Gerstungen 6707' ],
	[ 'FGTB',  'Gertenbach' ],
	[ 'FQGT',  'Gertenbach HE/NI' ],
	[ 'LGWS',  'Gerwisch' ],
	[ 'EGS',   'Ge-Schalke' ],
	[ 'EGSV',  'Ge-Scholven' ],
	[ 'EGK',   'Geseke' ],
	[ 'EGKS',  'Geseke Süd' ],
	[ 'MGHG',  'Gessertsh DB-Gr' ],
	[ 'MGHN',  'Gessertshausen' ],
	[ 'BGB',   'Gesundbrunnen' ],
	[ 'FGGB',  'Gettenau-Binghm' ],
	[ 'AGF',   'Gettorf' ],
	[ 'EGVH',  'Gevelsberg Hbf' ],
	[ 'KGVW',  'Gevelsberg West' ],
	[ 'EGVF',  'Gevelsberg-Haufe' ],
	[ 'KGVK',  'Gevelsberg-Kipp' ],
	[ 'EGVA',  'Gevelsberg-Knapp' ],
	[ 'ZAG',   'Gevgelija' ],
	[ 'XFGE',  'Gevrey' ],
	[ 'XFGET', 'Gevrey Triage' ],
	[ 'EGVG',  'Gev-Vogels DB-Gr' ],
	[ 'EGVV',  'Gev-Vogelsang' ],
	[ 'DLGL',  'Gew Lichtenstein' ],
	[ 'XUGI',  'Gheorgheni' ],
	[ 'XIGI',  'Giarole' ],
	[ 'XIGR',  'Giarre-Riposto' ],
	[ 'TGB',   'Giengen (Brenz)' ],
	[ 'LGI',   'Giersleben' ],
	[ 'LGIA',  'Giersleben Abzw' ],
	[ 'XNGD',  'Giesendam B r o' ],
	[ 'FG',    'Gießen' ],
	[ 'FGFL',  'Gießen An Flughf' ],
	[ 'FGEV',  'Gießen Europav' ],
	[ 'FG R',  'Gießen Gbf' ],
	[ 'FG A',  'Gießen I Pbf/Gbf' ],
	[ 'FG B',  'Gießen II Pbf/Rb' ],
	[ 'FLST',  'Gießen Licher St' ],
	[ 'FGOG',  'Gießen Oswaldsg' ],
	[ 'XAGB',  'Gießenbach' ],
	[ 'FGB',   'Gießen-Bergwald' ],
	[ 'HGI',   'Gifhorn' ],
	[ 'HGIS',  'Gifhorn Stadt' ],
	[ 'HGIF',  'Giften' ],
	[ 'MGCH',  'Gilching-Argelsr' ],
	[ 'HGIM',  'Gildehaus' ],
	[ 'WGIH',  'Gildenhall' ],
	[ 'TGI',   'Gingen (Fils)' ],
	[ 'TGIS',  'Gingen Süd' ],
	[ 'XIGIC', 'Gioia del Colle' ],
	[ 'XIGIT', 'Gioia Tauro' ],
	[ 'NGIU',  'Girching' ],
	[ 'FGIR',  'Girod' ],
	[ 'XSGNR', 'Gisikon-Root' ],
	[ 'XFGI',  'Gisors' ],
	[ 'HGT',   'Gitt/Bad Grund' ],
	[ 'XSGI',  'Giubiasco' ],
	[ 'XIGU',  'Giulianova' ],
	[ 'XUGN',  'Giurgiu Nord' ],
	[ 'XPGY',  'Gizycko' ],
	[ 'XOGS',  'Gjerstad' ],
	[ 'XDGJ',  'Gjesing' ],
	[ 'XOGJ',  'Gjovik' ],
	[ 'NGKA',  'GKW Frauenaur A' ],
	[ 'NGKF',  'GKW Frauenaurach' ],
	[ 'EGBO',  'Gladbeck Ost' ],
	[ 'EGBW',  'Gladbeck West' ],
	[ 'EZK',   'Gladbeck-Zweckel' ],
	[ 'XOGL',  'Glamos' ],
	[ 'RL V',  'Glan Vögele' ],
	[ 'XNGB',  'Glanerbrug' ],
	[ 'SGM',   'Glan-Münchweiler' ],
	[ 'NGLW',  'Glanzstoffwerke' ],
	[ 'DGHU',  'Glashütte(Sachs)' ],
	[ 'BAG O', 'Glasow Damm Ost' ],
	[ 'BAG S', 'Glasow Damm Süd' ],
	[ 'BAG W', 'Glasow Damm West' ],
	[ 'XSG',   'Glattbrugg' ],
	[ 'XSGA',  'Glattfelden' ],
	[ 'RWDG',  'Glatz II (Weid)' ],
	[ 'FGBG',  'Glaub-Glauberg' ],
	[ 'DGLA',  'Glaubitz (b Rie)' ],
	[ 'FSTM',  'Glaub-Stockheim' ],
	[ 'DGL',   'Glauchau (Sachs)' ],
	[ 'DREG',  'Glauchau DB-Gr' ],
	[ 'DGLG',  'Glauchau Gewerbe' ],
	[ 'DGLS',  'Glauchau-Schönb' ],
	[ 'ABGL',  'Gleichrwerk' ],
	[ 'DGLM',  'Gleisberg-Marb' ],
	[ 'TGLM',  'Glems' ],
	[ 'KGL',   'Glesch' ],
	[ 'AGND',  'Glinde' ],
	[ 'LGLB',  'Glindenberg' ],
	[ 'XPGL',  'Gliwice' ],
	[ 'XPGLK', 'Gliwice Kont' ],
	[ 'XPGLP', 'Gliwice Port' ],
	[ 'XPGLS', 'Gliwice Sosnica' ],
	[ 'LGLO',  'Globig' ],
	[ 'XAGL',  'Gloggnitz' ],
	[ 'XUGL',  'Glogovat' ],
	[ 'XPGLO', 'Glogow' ],
	[ 'XDGL',  'Glostrup G' ],
	[ 'WGF',   'Glöwen' ],
	[ 'XCGL',  'Glubokaia' ],
	[ 'XPGC',  'Glucholazy' ],
	[ 'UGL',   'Glückauf' ],
	[ 'AGST',  'Glückstadt' ],
	[ 'XDGU',  'Glumsoe' ],
	[ 'XAGN',  'Gmünd NÖ' ],
	[ 'MGMD',  'Gmund(Tegernsee)' ],
	[ 'LGND',  'Gnadau' ],
	[ 'AGNB',  'Gnarrenburg' ],
	[ 'AGNBN', 'Gnarrenburg Nord' ],
	[ 'XVGN',  'Gnesta' ],
	[ 'WGNV',  'Gnevkow' ],
	[ 'XPGN',  'Gniezno' ],
	[ 'RGOS',  'Go Schloßstadion' ],
	[ 'FGOE',  'Göbelnrod' ],
	[ 'KGO',   'Goch' ],
	[ 'TGOS',  'Gochsen' ],
	[ 'NGHM',  'Gochsheim (Ufr)' ],
	[ 'NGHG',  'Gochsheim DB-Gr' ],
	[ 'RGOM',  'Gochsheim(Baden)' ],
	[ 'HGOH',  'Godelheim' ],
	[ 'HGOD',  'Godenau' ],
	[ 'HGDH',  'Godensholt' ],
	[ 'AGO',   'Godenstedt' ],
	[ 'HGTD',  'Gödenstf-Oelstf' ],
	[ 'XMGO',  'Godisa' ],
	[ 'RGOR',  'Godramstein' ],
	[ 'XLGB',  'Goebelsmuhle' ],
	[ 'LGOM',  'Goetheweg' ],
	[ 'HGOF',  'Gohfeld' ],
	[ 'AGOE',  'Göhl' ],
	[ 'AGH',   'Göhrde' ],
	[ 'WGO',   'Göhren (Rügen)' ],
	[ 'AGK',   'Gokels' ],
	[ 'XOG',   'Gol' ],
	[ 'LGM',   'Goldbeck(Kr Ost)' ],
	[ 'TGOL',  'Goldberg' ],
	[ 'HGOL',  'Goldenstedt/Oldb' ],
	[ 'FGDH',  'Goldhausen' ],
	[ 'TGL',   'Goldshöfe' ],
	[ 'XPGO',  'Goleniow' ],
	[ 'XUGO',  'Golesti' ],
	[ 'XAGA',  'Golling-Abtenau' ],
	[ 'BGM',   'Gollmitz NL' ],
	[ 'RGOE',  'Gölshausen' ],
	[ 'RGOI',  'Gölsh-Industrie' ],
	[ 'BGO',   'Golßen NL' ],
	[ 'BGZ',   'Golzow (Oderbr)' ],
	[ 'LGON',  'Golzow(b Brb) N' ],
	[ 'LGOZ',  'Golzow(b Brburg)' ],
	[ 'WGOL',  'Golzow(b Ebersw)' ],
	[ 'HGZW',  'Golzwarden' ],
	[ 'TGOM',  'Gomadingen' ],
	[ 'LGO',   'Gommern' ],
	[ 'TGMF',  'Gommersdorf' ],
	[ 'RGO',   'Gondelshm(Baden)' ],
	[ 'RGHM',  'Gönnheim' ],
	[ 'XIGZ',  'Gonzaga Reggiolo' ],
	[ 'XSGO',  'Goppenstein' ],
	[ 'TGO',   'Göppingen' ],
	[ 'LGOR',  'Görden' ],
	[ 'ZIG',   'Gorey' ],
	[ 'BGOR',  'Gorgast' ],
	[ 'XCGK',  'Goriachii Kliuch' ],
	[ 'XNGO',  'Gorinchem B r o' ],
	[ 'XIGC',  'Gorizia Centrale' ],
	[ 'DG',    'Görlitz' ],
	[ 'DXG',   'Görlitz Grenze' ],
	[ 'DGIB',  'Görlitz Indbf' ],
	[ 'DGWH',  'Görlitz-Weinhüb' ],
	[ 'XWGO',  'Gorna Orjach' ],
	[ 'XCGD',  'Gorodok' ],
	[ 'DGRA',  'Gör-Rauschwalde' ],
	[ 'UGSB',  'Görsbach' ],
	[ 'NGOE',  'Görschnitz' ],
	[ 'BGZG',  'Görzig' ],
	[ 'XPGW',  'Gorzow Wlkp' ],
	[ 'XPGK',  'Gorzuchow Klodzk' ],
	[ 'NGG',   'Gosberg' ],
	[ 'XSGS',  'Göschenen' ],
	[ 'HGS',   'Goslar' ],
	[ 'XRG',   'Gospic' ],
	[ 'DKH',   'Goßdf-Kohlmühle' ],
	[ 'FGOF',  'Goßfelden' ],
	[ 'NGOD',  'Goßmannsdorf' ],
	[ 'DGZ',   'Gößnitz' ],
	[ 'DQGZ',  'Gößnitz TH/SN' ],
	[ 'NGOS',  'Gößweinstein' ],
	[ 'XVGB',  'Göteborg' ],
	[ 'UGO',   'Gotha' ],
	[ 'UGO K', 'Gotha (W 103)' ],
	[ 'UGOG',  'Gotha DB-Grenze' ],
	[ 'UGO O', 'Gotha Gk (W 112)' ],
	[ 'UGOS',  'Gotha Ost' ],
	[ 'WGOE',  'Götschendorf' ],
	[ 'SGB',   'Göttelborn' ],
	[ 'DGOE',  'Göttengrün-Gef' ],
	[ 'RGH',   'Gottenheim' ],
	[ 'RGHG',  'DB/SWEG' ],
	[ 'NGZ',   'Gotteszell' ],
	[ 'HG',    'Göttingen' ],
	[ 'HG G',  'Göttingen Gbf' ],
	[ 'HG N',  'Göttingen Gbf N' ],
	[ 'XSGL',  'Gottlieben' ],
	[ 'RG',    'Gottmadingen' ],
	[ 'LGOE',  'Götz' ],
	[ 'XAGT',  'Götzendorf' ],
	[ 'FGHF',  'Götzenhof' ],
	[ 'XAGZ',  'Götzis' ],
	[ 'XNG',   'Gouda' ],
	[ 'XBGY',  'Gouvy' ],
	[ 'FGRI',  'Gr Buseck Indgl' ],
	[ 'HGGLO', 'Gr Gleid Ostkopf' ],
	[ 'FGRU',  'Gr Umstadt Mitte' ],
	[ 'FWH',   'Gr U-Wiebelsbach' ],
	[ 'WGMW',  'Graal-M Koppelw' ],
	[ 'WGM',   'Graal-Müritz' ],
	[ 'MGRL',  'Graben' ],
	[ 'RGN',   'Graben-Neudorf' ],
	[ 'WGRB',  'Grabow (Meckl)' ],
	[ 'WGOH',  'Grabowhöfe' ],
	[ 'MGFL',  'Gräfelfing' ],
	[ 'MGRA',  'Grafenaschau' ],
	[ 'NGFU',  'Grafenau' ],
	[ 'NGFG',  'Gräfenberg' ],
	[ 'EGRA',  'Grafenbusch /Ob' ],
	[ 'NG',    'Gräfendorf' ],
	[ 'TGRA',  'Grafeneck' ],
	[ 'LG',    'Gräfenhainichen' ],
	[ 'UGD',   'Gräfenroda' ],
	[ 'UGDG',  'Gräfenroda DB-Gr' ],
	[ 'UGDO',  'Gräfenroda Ort' ],
	[ 'LGRK',  'Gräfenst-Klippm' ],
	[ 'UGTA',  'Gräfentonna' ],
	[ 'NGFW',  'Grafenwiesen' ],
	[ 'NGR',   'Grafenwöhr' ],
	[ 'NGRL',  'Grafenwöhr Lager' ],
	[ 'XFGR',  'Graffenstaden' ],
	[ 'MGB',   'Grafing Bahnhof' ],
	[ 'MGRS',  'Grafing Stadt' ],
	[ 'NGF',   'Grafling' ],
	[ 'NGFA',  'Grafling-Arzting' ],
	[ 'MGF',   'Grafrath' ],
	[ 'MGRN',  'Grainau' ],
	[ 'XAGR',  'Gramatneusiedl' ],
	[ 'WGR',   'Grambow' ],
	[ 'WXG',   'Grambow Gr' ],
	[ 'XIGM',  'Grammichele' ],
	[ 'XOGN',  'Gran' ],
	[ 'XXGR',  'Grandola' ],
	[ 'RGNN',  'Gra-Neudorf Nord' ],
	[ 'XEGR',  'Granollers-Centr' ],
	[ 'WGRA',  'Gransee' ],
	[ 'HGRL',  'Grasleben' ],
	[ 'XVGT',  'Grästorp' ],
	[ 'XAGG',  'Gratw.-Gratkorn' ],
	[ 'LGRU',  'Graui' ],
	[ 'DGFL',  'Grauschwitz Fl' ],
	[ 'BGRA',  'Graustein' ],
	[ 'BQGR',  'Graustein BB/SN' ],
	[ 'FGRK',  'Gräveneck' ],
	[ 'FGR',   'Grävenwiesbach' ],
	[ 'XAG',   'Graz Hbf' ],
	[ 'XAGO',  'Graz Ost' ],
	[ 'XAGC',  'Graz Süd CCT' ],
	[ 'XAGV',  'Graz Vbf' ],
	[ 'FGSN',  'Grebenstein' ],
	[ 'XDGB',  'Gredstedbro' ],
	[ 'XOGF',  'Grefsen' ],
	[ 'WGW',   'Greifswald' ],
	[ 'WGWS',  'Greifswald Süd' ],
	[ 'UGR',   'Greiz' ],
	[ 'UGRD',  'Greiz-Dölau' ],
	[ 'UQGR',  'Greiz-Dölau LGr' ],
	[ 'KG P',  'Gremb Perswechs' ],
	[ 'KG R',  'Gremb Perswechs' ],
	[ 'KG',    'Gremberg' ],
	[ 'KG A',  'Gremberg Bn' ],
	[ 'KG C',  'Gremberg Bs' ],
	[ 'KG G',  'Gremberg Gnf' ],
	[ 'KG H',  'Gremberg Gsf' ],
	[ 'KGN',   'Gremberg N' ],
	[ 'KG F',  'Gremberg Rnw' ],
	[ 'KGS',   'Gremberg S' ],
	[ 'EGMD',  'Gremmendorf' ],
	[ 'XSGRN', 'Grenchen Nord' ],
	[ 'XFG',   'Grenoble' ],
	[ 'RGRZ',  'Grenzach' ],
	[ 'LGPN',  'Greppin' ],
	[ 'XFGS',  'Gresy sur Isere' ],
	[ 'NGTT',  'Grettstadt' ],
	[ 'XFGZ',  'Gretz-Armainvill' ],
	[ 'UGN',   'Greußen' ],
	[ 'EGRV',  'Greven' ],
	[ 'KGRB',  'Grevenbroich' ],
	[ 'EGVB',  'Grevenbrück' ],
	[ 'WGV',   'Grevesmühlen' ],
	[ 'ZIGS',  'Greystones' ],
	[ 'FDG',   'Gr-Gerau-Dornbg' ],
	[ 'XCGV',  'Griazi Voronejsk' ],
	[ 'WGBN',  'Grieben (Meckl)' ],
	[ 'WGRE',  'Grieben(b Grans)' ],
	[ 'BGBS',  'Griebnitzsee' ],
	[ 'BGBSO', 'Griebnitzsee Gbo' ],
	[ 'BGRI',  'Griebnitzsee S-B' ],
	[ 'LGB',   'Griebo' ],
	[ 'FGRD',  'Griedel' ],
	[ 'UGRI',  'Griefstedt' ],
	[ 'XAGRB', 'Gries' ],
	[ 'XAGI',  'Gries/Pinzgau' ],
	[ 'MGRI',  'Griesen (Obb)' ],
	[ 'MXG',   'Griesen(Obb) Gr' ],
	[ 'XAGP',  'Griesk-Gallspach' ],
	[ 'RGSS',  'Grießen (Baden)' ],
	[ 'LGRI',  'Grimma ob Bf' ],
	[ 'RGHF',  'Grimmelshofen' ],
	[ 'WGI',   'Grimmen' ],
	[ 'UGM',   'Grimmenthal' ],
	[ 'WGRO',  'Grischow (Meckl)' ],
	[ 'XEGI',  'Grisen' ],
	[ 'XIGDZ', 'Grisignano d Zoc' ],
	[ 'MGKU',  'Gr-Karolinenf Ü' ],
	[ 'MGK',   'Gr-karolinenfeld' ],
	[ 'DGO',   'Grobau' ],
	[ 'MGRZ',  'Gröbenzell' ],
	[ 'LGOS',  'Gröbers' ],
	[ 'LGOH',  'Gröbers Hp' ],
	[ 'LGOSO', 'Gröbers Ost' ],
	[ 'LQGOS', 'Gröbers ST/SN' ],
	[ 'LGOSS', 'Gröbers Süd' ],
	[ 'XAGM',  'Gröbming' ],
	[ 'LGST',  'Grockstädt' ],
	[ 'DGT',   'Gröditz (b Rie)' ],
	[ 'DQGT',  'Gröditz LGr' ],
	[ 'ZWG',   'Grodno' ],
	[ 'XPGM',  'Grodzisk Maz' ],
	[ 'XBGR',  'Groenendaal' ],
	[ 'HGRD',  'Grohnde' ],
	[ 'RGM',   'Grombach' ],
	[ 'EGRN',  'Gronau (Westf)' ],
	[ 'EXGR',  'Gronau Grenze' ],
	[ 'HGRN',  'Grone' ],
	[ 'XOGG',  'Grong' ],
	[ 'XNGR',  'Groningen' ],
	[ 'XNGE',  'Groningen-Emska.' ],
	[ 'XNGL',  'Groningen-Losfl.' ],
	[ 'MGDF',  'Gronsdorf' ],
	[ 'XIGPC', 'Gropello Cairoli' ],
	[ 'LGRL',  'Groß Ammensleben' ],
	[ 'LGBZ',  'Groß Behnitz' ],
	[ 'FGBB',  'Groß Bieberau' ],
	[ 'WGB',   'Groß Brütz' ],
	[ 'LGDG',  'Groß Dalzig' ],
	[ 'HGDN',  'Groß Düngen' ],
	[ 'LGGZ',  'Groß Garz' ],
	[ 'HGGL',  'Groß Gleidingen' ],
	[ 'LGGF',  'Groß Gräfendorf' ],
	[ 'HGIP',  'Groß Ippener' ],
	[ 'FGKA',  'Groß Karben' ],
	[ 'WGKW',  'Groß Kiesow' ],
	[ 'BTPI',  'Groß Köris' ],
	[ 'LGZ',   'Groß Kreutz' ],
	[ 'WGLS',  'Groß Laasch' ],
	[ 'WGLG',  'Groß Langerw' ],
	[ 'WGLI',  'Groß Lüsewitz' ],
	[ 'HGMK',  'Groß Mackenstedt' ],
	[ 'HGOS',  'Groß Oesingen' ],
	[ 'WGP',   'Groß Pankow' ],
	[ 'WGQ',   'Groß Quassow' ],
	[ 'LGQ',   'Groß Quenstedt' ],
	[ 'BGRR',  'Groß Rietz' ],
	[ 'FGRO',  'Groß Rohrheim' ],
	[ 'AGR',   'Groß Schlamin' ],
	[ 'WGS',   'Groß Schwaß' ],
	[ 'XAGS',  'Groß Schwechat' ],
	[ 'MGRO',  'Großaitingen' ],
	[ 'NGAH',  'Großalbershof' ],
	[ 'NGRS',  'Großarmschlag' ],
	[ 'FGAU',  'Großauheim (Ha)' ],
	[ 'BGSB',  'Großbeeren' ],
	[ 'BGSBS', 'Großbeeren Süd' ],
	[ 'BGBW',  'Großbeeren West' ],
	[ 'DGR',   'Großbothen' ],
	[ 'UGBB',  'Großbrembach' ],
	[ 'KGBU',  'Großbüllesheim' ],
	[ 'HGBW',  'Großburgwedel' ],
	[ 'LUM',   'Großdalzig Umspw' ],
	[ 'LGD',   'Großdeuben' ],
	[ 'FGRB',  'Großen Buseck' ],
	[ 'FGL',   'Großen Linden' ],
	[ 'AGSA',  'Großenaspe' ],
	[ 'AGRO',  'Großenbrode' ],
	[ 'UGG',   'Großengottern' ],
	[ 'DGB',   'Großenh Berl Bf' ],
	[ 'DGC',   'Großenh Cott Bf' ],
	[ 'HGRK',  'Großenkneten' ],
	[ 'FGLRI', 'Großenl Ind Gl' ],
	[ 'FGLR',  'Großenlüder' ],
	[ 'XIGS',  'Grosseto' ],
	[ 'UGFA',  'Großfurra' ],
	[ 'FGER',  'Groß-Gerau' ],
	[ 'FGERO', 'Groß-Gerau Ost' ],
	[ 'FDOH',  'Groß-Gerau-Dornh' ],
	[ 'NGRG',  'Großgeschaidt' ],
	[ 'DGRT',  'Großharthau' ],
	[ 'NGHR',  'Großheirath' ],
	[ 'MGHD',  'Großhelfendorf' ],
	[ 'UGHG',  'Großhering DB-Gr' ],
	[ 'UGH',   'Großheringen' ],
	[ 'UGHO',  'Großheringen Gho' ],
	[ 'UGHS',  'Großheringen Ghs' ],
	[ 'UQGH',  'Großheringen LGr' ],
	[ 'MGO',   'Großhesselohe' ],
	[ 'MGOI',  'Großh-lohe Isar' ],
	[ 'LGC',   'Großkorbetha' ],
	[ 'FGK',   'Großkrotzenburg' ],
	[ 'LGKL',  'Großkugel' ],
	[ 'LQGK',  'Großkugel ST/SN' ],
	[ 'NGL',   'Großlangheim' ],
	[ 'LGL',   'Großlehna' ],
	[ 'LQGL',  'Großlehna SN/ST' ],
	[ 'UGNH',  'Großneuhausen' ],
	[ 'LGP',   'Großpösna' ],
	[ 'DGP',   'Großpostwitz' ],
	[ 'BGR',   'Großräschen' ],
	[ 'DGRF',  'Großröhrsdorf' ],
	[ 'UGRU',  'Großrudestedt' ],
	[ 'RGRO',  'Großsachsen Ort' ],
	[ 'DGSG',  'Großsch DB-Gr' ],
	[ 'DGAU',  'Großschönau (Sa)' ],
	[ 'DXGS',  'Großschönau Gr' ],
	[ 'UGC',   'Großschwabhausen' ],
	[ 'DGSW',  'Großschweidnitz' ],
	[ 'LGS',   'Großsteinberg' ],
	[ 'DGST',  'Großstöbnitz' ],
	[ 'DGVB',  'Großvoigtsberg' ],
	[ 'NGRW',  'Großwalbur' ],
	[ 'LGWU',  'Großwudicke' ],
	[ 'LQGW',  'Großwudicke LGr' ],
	[ 'EGRK',  'Grottenkamp' ],
	[ 'RGZM',  'Grötzgn Kirchstr' ],
	[ 'RGZK',  'Grötzgn Krappmw' ],
	[ 'RGZG',  'Grötzing DB/AVG' ],
	[ 'RGZ',   'Grötzingen' ],
	[ 'RGZA',  'Grötzingen AVG' ],
	[ 'XOGU',  'Grua' ],
	[ 'NGRU',  'Grub (Oberpf)' ],
	[ 'NGUF',  'Grub am Forst' ],
	[ 'MGRB',  'Grub(Oberbay)' ],
	[ 'NGW',   'Grubweg' ],
	[ 'XPGZ',  'Grudziadz' ],
	[ 'BGKR',  'Grün Kreuz S-B' ],
	[ 'BGK N', 'Grün Kreuz Nord' ],
	[ 'BGK S', 'Grün Kreuz Süd' ],
	[ 'BGK W', 'Grün Kreuz West' ],
	[ 'DGN',   'Grüna (Sachs)' ],
	[ 'LGRA',  'Grünauer Allee' ],
	[ 'DGBA',  'Grünbach' ],
	[ 'TGRB',  'Grünbach Üst' ],
	[ 'BGBA',  'Grünbergallee' ],
	[ 'FGRG',  'Grünbg (Oberhe)' ],
	[ 'EGNO',  'Grünebach Ort' ],
	[ 'EGNH',  'Grünebacherhütte' ],
	[ 'WGRG',  'Grüneberg' ],
	[ 'AGHI',  'Grüner Hirsch' ],
	[ 'DGRBK', 'Grünh-Borste Kbf' ],
	[ 'DGRB',  'Grünh-Borstendf' ],
	[ 'TGR',   'Grünholz' ],
	[ 'RDOG',  'Grüningen' ],
	[ 'TGRS',  'Grünsfeld' ],
	[ 'RGR',   'Grünstadt' ],
	[ 'RGRN',  'Grünstadt Nord' ],
	[ 'DGS',   'Grünstädtel' ],
	[ 'TGRW',  'Grünt-Wittlensw' ],
	[ 'KGUI',  'Gruiten' ],
	[ 'KGUH',  'Gruiten Hp' ],
	[ 'KGUA',  'Gruiten Abzw' ],
	[ 'TGC',   'Grunbach' ],
	[ 'BGWD',  'Grunewald S-B' ],
	[ 'BGRU',  'Grunow (NL)' ],
	[ 'XPGF',  'Gryfice' ],
	[ 'NSDT',  'Gstadt' ],
	[ 'BGU',   'Guben' ],
	[ 'BXG',   'Guben Grenze' ],
	[ 'BGUN',  'Guben Nord' ],
	[ 'BGUS',  'Guben Süd' ],
	[ 'XPGU',  'Gubin' ],
	[ 'XOGD',  'Guda' ],
	[ 'SGD',   'Güdingen' ],
	[ 'TGU',   'Gültstein' ],
	[ 'HGUE',  'Gümmerwald' ],
	[ 'MGKF',  'Gündlkofen' ],
	[ 'LGBG',  'Güntersberge' ],
	[ 'MGNZ',  'Günzach' ],
	[ 'MGZB',  'Günzburg' ],
	[ 'LGSN',  'Güsen (Kr Genth)' ],
	[ 'LGT',   'Güsten' ],
	[ 'AGUE',  'Güster' ],
	[ 'WG',    'Güstrow' ],
	[ 'WG G',  'Güstrow Gbf' ],
	[ 'LGK',   'Güterglück' ],
	[ 'LGK N', 'Güterglück Gkn' ],
	[ 'EGLO',  'Gütersloh Hbf' ],
	[ 'EGLN',  'Gütersloh Nord' ],
	[ 'XSGU',  'Güttingen' ],
	[ 'XXGU',  'Guimaraes' ],
	[ 'XDGA',  'Guldager' ],
	[ 'XAGU',  'Gummern' ],
	[ 'KGU',   'Gummersbach' ],
	[ 'KKGU',  'Gummersbacher S' ],
	[ 'NGPA',  'Gumpenried-Asb' ],
	[ 'RGDN',  'Gundelfingen' ],
	[ 'MGUF',  'Gundelfingen/Bay' ],
	[ 'NGD',   'Gundelsdorf' ],
	[ 'NGU',   'Gundelshausen' ],
	[ 'RGUN',  'Gundelshm/Neckar' ],
	[ 'FGUH',  'Gundershm (Rhh)' ],
	[ 'FGUB',  'Guntersblum' ],
	[ 'XAGK',  'Guntramsd-Kaiser' ],
	[ 'DGUN',  'Gunzen' ],
	[ 'NGUG',  'Gunzenh DB-Gr' ],
	[ 'NGUN',  'Gunzenhausen' ],
	[ 'XUGH',  'Gura Humorului' ],
	[ 'XAGUR', 'Gurten' ],
	[ 'BGSW',  'Gusow' ],
	[ 'TGSS',  'Gussenstadt' ],
	[ 'KGUS',  'Gustorf' ],
	[ 'RGTA',  'Gutach(Breisgau)' ],
	[ 'DGF',   'Gutenfürst' ],
	[ 'DQGF',  'Gutenfürst SN/BY' ],
	[ 'UGU',   'Guthmannshausen' ],
	[ 'FGUR',  'Gutleuthof' ],
	[ 'FGX',   'Guxhagen' ],
	[ 'XMGN',  'Gyenesdias' ],
	[ 'XOGY',  'Gyland' ],
	[ 'XMGY',  'Gyoma' ],
	[ 'XMG',   'Györ' ],
	[ 'XMGG',  'Györ-Gyarvaros' ],
	[ 'XMGL',  'Gyula' ],
	[ 'RGZO',  'Gz Oberausstr' ],
	[ 'XNHHV', 'H.v.Holland Hav' ],
	[ 'XAHAG', 'Haag' ],
	[ 'XBHA',  'Haaltert' ],
	[ 'KHAN',  'Haan' ],
	[ 'XNHA',  'Haanrade' ],
	[ 'MHR',   'Haar' ],
	[ 'UHSN',  'Haarhausen' ],
	[ 'XNHE',  'Haarlem' ],
	[ 'XNHLS', 'Haarl-Spaarnwoud' ],
	[ 'XVHB',  'Habo' ],
	[ 'EHCH',  'Hachen' ],
	[ 'KHAC',  'Hachenburg' ],
	[ 'BHKM',  'Hackescher Markt' ],
	[ 'FHAD',  'Hadamar' ],
	[ 'AHNU',  'Hademarschen' ],
	[ 'LHD',   'Hadmersleben' ],
	[ 'XDHA',  'Hadsten' ],
	[ 'XSHW',  'Haeggenschwil-W' ],
	[ 'XSHP',  'Haerkingen P' ],
	[ 'EHFS',  'Hafen Saerbeck' ],
	[ 'NHUE',  'Hafenbrücke' ],
	[ 'AHAF',  'Haffkrug' ],
	[ 'WHK',   'Hagebök' ],
	[ 'NHA',   'Hagelstadt' ],
	[ 'HHAG',  'Hagen (Han)' ],
	[ 'HHGH',  'Hagen (Han) Hp' ],
	[ 'AHGN',  'Hagen (Kr Stade)' ],
	[ 'EHGG',  'Hagen Gbf' ],
	[ 'EHGGO', 'Hagen Gbf Bz Ost' ],
	[ 'EHGGB', 'Hagen Gbf Bz We' ],
	[ 'EHGGW', 'Hagen Gbf Hgw' ],
	[ 'EHG',   'Hagen Hbf' ],
	[ 'XAHU',  'Hagenau im Innkr' ],
	[ 'RHGB',  'Hagenbach' ],
	[ 'RHGBA', 'Hagenbach I' ],
	[ 'RHGBB', 'Hagenbach II' ],
	[ 'RHGBC', 'Hagenbach III' ],
	[ 'NHBU',  'Hagenbüchach' ],
	[ 'NHBH',  'Hagenbüchach Hp' ],
	[ 'EHGD',  'Hagen-Delstern' ],
	[ 'EHGE',  'Hagen-Eckesey' ],
	[ 'EHGH',  'Hagen-Halden' ],
	[ 'EHGP',  'Hagen-Haspe' ],
	[ 'EHGS',  'Hagen-Hengstey' ],
	[ 'EHGI',  'Hagen-Heubing' ],
	[ 'EHGK',  'Hagen-Kabel' ],
	[ 'EHGO',  'Hagen-Oberhagen' ],
	[ 'WHLG',  'Hagenow DB-Gr' ],
	[ 'WHL',   'Hagenow Land' ],
	[ 'WH',    'Hagenow Stadt' ],
	[ 'EHGV',  'Hagen-Vorhalle' ],
	[ 'DHW',   'Hagenwerder' ],
	[ 'DXHW',  'Hagenwerder Gr' ],
	[ 'EHAE',  'Häger' ],
	[ 'XFHD',  'Hagondange' ],
	[ 'XFHG',  'Haguenau' ],
	[ 'HHL',   'Hahlen' ],
	[ 'BHAH',  'Hähnichen' ],
	[ 'FHAE',  'Hähnlein-Alsbach' ],
	[ 'NHAG',  'Haidenaab-Göppm' ],
	[ 'THKP',  'Haidkapelle' ],
	[ 'FHG',   'Haiger' ],
	[ 'FHGO',  'Haiger Obertor' ],
	[ 'THGL',  'Haigerloch' ],
	[ 'FHME',  'Hailer-Meerholz' ],
	[ 'XAHM',  'Haiming' ],
	[ 'FHDT',  'Hainb-Hainstadt' ],
	[ 'MAHL',  'Haindl/Schongau' ],
	[ 'FHAN',  'Haine' ],
	[ 'DHND',  'Hainewalde' ],
	[ 'DHA',   'Hainichen' ],
	[ 'RHAI',  'Hainstadt(Baden)' ],
	[ 'FHAI',  'Haitz-Höchst' ],
	[ 'XMHU',  'Hajmasjer-Ujtele' ],
	[ 'XMHJ',  'Hajmasker' ],
	[ 'XOHK',  'Hakedal' ],
	[ 'BHB',   'Halbe' ],
	[ 'LHBO',  'Halberst Oststr' ],
	[ 'LHB',   'Halberstadt' ],
	[ 'LHBA',  'Halberstadt Ost' ],
	[ 'LHBS',  'Halberstadt-Spie' ],
	[ 'RHAM',  'Halbmeil' ],
	[ 'LHLG',  'Hald Euroglas' ],
	[ 'XOHA',  'Halden' ],
	[ 'LHBG',  'Haldensleb DB-Gr' ],
	[ 'LHL',   'Haldensleben' ],
	[ 'EHAD',  'Haldern (Rheinl)' ],
	[ 'HHAL',  'Halen' ],
	[ 'HQHA',  'Halen NRW/NI' ],
	[ 'MHLF',  'Halfing' ],
	[ 'HLI R', 'Ha-Li/Fischerhof' ],
	[ 'XQHA',  'Halkali' ],
	[ 'XAHT',  'Hall in Tirol' ],
	[ 'MHMO',  'Hallbergmoos' ],
	[ 'LHG O', 'Halle (S) Gbf O' ],
	[ 'EHAL',  'Halle (Westf)' ],
	[ 'LHGB',  'Halle Abzw Ab' ],
	[ 'LHNWO', 'Halle Abzw HNO' ],
	[ 'LHS',   'Halle Betrbf As' ],
	[ 'LHNW',  'Halle Betrbf HNW' ],
	[ 'LHS D', 'Halle Bk As' ],
	[ 'LHG',   'Halle Gbf' ],
	[ 'LHG M', 'Halle Gbf Am' ],
	[ 'LHG Y', 'Halle Gbf Hg 16' ],
	[ 'LHG W', 'Halle Gbf Hg 18' ],
	[ 'LHG D', 'Halle Gbf Hg 3' ],
	[ 'LHG U', 'Halle Gbf Hg 5/6' ],
	[ 'EHWS',  'Halle G-W-Stad' ],
	[ 'LHAC',  'Halle Kasseler B' ],
	[ 'LHAL',  'Halle Leuchtturm' ],
	[ 'LHME',  'Halle Messe' ],
	[ 'LHST',  'Halle Steintorbf' ],
	[ 'LHAT',  'Halle Thür Bahn' ],
	[ 'LH',    'Halle(Saale) Hbf' ],
	[ 'LHADB', 'Halle-Ammend Bst' ],
	[ 'LHAD',  'Halle-Ammendorf' ],
	[ 'XAHL',  'Hallein' ],
	[ 'XVHK',  'Hällekis' ],
	[ 'FKBHH', 'Hallenbad Ost' ],
	[ 'LHN',   'Halle-Neustadt' ],
	[ 'LHNI',  'Halle-Nietleben' ],
	[ 'LHT',   'Halle-Trotha' ],
	[ 'XVHV',  'Hällevadsholm' ],
	[ 'LHW',   'Halle-Wörmlitz' ],
	[ 'XOHL',  'Hallingskeid' ],
	[ 'XVHA',  'Hallsberg' ],
	[ 'XVHAR', 'Hallsberg Rbf' ],
	[ 'NHAL',  'Hallstadt(Bambg)' ],
	[ 'MHTM',  'Hallthurm' ],
	[ 'XAHE',  'Hallwang-Elixh.' ],
	[ 'XVHL',  'Halmstads C' ],
	[ 'AHKS',  'Halstenbek' ],
	[ 'XOHD',  'Haltdalen' ],
	[ 'EHLT',  'Haltern am See' ],
	[ 'RHL',   'Haltingen' ],
	[ 'EHL',   'Halver' ],
	[ 'XOHM',  'Hamar' ],
	[ 'HHBT',  'Hambostel' ],
	[ 'AAI',   'Hamburg Airport' ],
	[ 'ADF',   'Hamburg Dammtor' ],
	[ 'AHPA',  'Hamburg Hafen' ],
	[ 'AH',    'Hamburg Hbf' ],
	[ 'AHBS',  'Hamburg Süd' ],
	[ 'AA',    'Hamburg-Altona' ],
	[ 'ABAG',  'Hamburg-Barmbek' ],
	[ 'ALOF',  'Hamburg-Lokstedt' ],
	[ 'AOW',   'Hamburg-Tonndorf' ],
	[ 'AWN',   'Hamburg-Wandsbek' ],
	[ 'HHAE',  'Hämelerwald' ],
	[ 'HHM',   'Hameln' ],
	[ 'HWEL',  'Hameln-Wehl' ],
	[ 'LHMT',  'Hämerten' ],
	[ 'MHAM',  'Hamlar' ],
	[ 'EHMS',  'Hamm (W) Süd RLG' ],
	[ 'EHM',   'Hamm (Westf) Pbf' ],
	[ 'EHRB',  'Hamm Rbf' ],
	[ 'EHRBD', 'Hamm Rbf Hda' ],
	[ 'EHRBW', 'Hamm Rbf Hde' ],
	[ 'EHRBA', 'Hamm Rbf Hma' ],
	[ 'EHRBE', 'Hamm Rbf Hme' ],
	[ 'EHRBZ', 'Hamm Rbf Hps' ],
	[ 'EHRBO', 'Hamm Rbf Hro' ],
	[ 'EHRBM', 'Hamm Rbf Hso' ],
	[ 'EHRBS', 'Hamm Rbf Hso' ],
	[ 'EHRBN', 'Hamm Rbf Hvn' ],
	[ 'EHRBT', 'Hamm Rbf Persw' ],
	[ 'EHRBR', 'Hamm Rbf Rt II' ],
	[ 'EHMR',  'Hamm(Westf)RLG' ],
	[ 'AHAM',  'Hammah' ],
	[ 'NHG',   'Hammelburg' ],
	[ 'NHGO',  'Hammelburg Ost' ],
	[ 'WHAM',  'Hammelspring' ],
	[ 'HHWD',  'Hammelwarden' ],
	[ 'MHAU',  'Hammerau' ],
	[ 'AHAB',  'Hammerbrook' ],
	[ 'XBHB',  'Hammerbrücke' ],
	[ 'MHMB',  'Hammersbach' ],
	[ 'XDHU',  'Hammerum' ],
	[ 'EHK',   'Hamminkeln' ],
	[ 'HHBI',  'Han Bismarckstr' ],
	[ 'HLGF',  'Han Flughafen' ],
	[ 'HH P',  'Han Hbf Pferdet' ],
	[ 'HKWA',  'Han K-Wiechert-A' ],
	[ 'HHML',  'Han Mess/Laatzen' ],
	[ 'HNH',   'Han Nordhafen' ],
	[ 'HNHG',  'Han Nordhf DB-Gr' ],
	[ 'FH',    'Hanau Hbf' ],
	[ 'FH M',  'Hanau Mainbrücke' ],
	[ 'FHN',   'Hanau Nord' ],
	[ 'FH N',  'Hanau Nordseite' ],
	[ 'FH S',  'Hanau Südseite' ],
	[ 'FHW',   'Hanau West' ],
	[ 'FHWB',  'Hanau-Wi bad' ],
	[ 'AHAN',  'Handeloh' ],
	[ 'HAMI',  'H-Anderten-Misbg' ],
	[ 'HHKF',  'Hanekenfähr' ],
	[ 'XOHN',  'Hanestad' ],
	[ 'THFT',  'Hanfertal' ],
	[ 'KHIB',  'Hangelar IndBahn' ],
	[ 'KHIBM', 'Hangelar Mitte' ],
	[ 'BHGB',  'Hangelsberg' ],
	[ 'HHZ',   'Han-Hainholz' ],
	[ 'XYH',   'Haniska p Kos' ],
	[ 'HHBU',  'Hankensbüttel' ],
	[ 'HKL',   'Han-Kleefeld' ],
	[ 'XHHA',  'Hanko' ],
	[ 'HLEA',  'Han-Ledebg Abzw' ],
	[ 'HLEG',  'Han-Ledeburg' ],
	[ 'HLEI',  'Han-Leinhausen' ],
	[ 'HHAW',  'Han-Leinhsn Wbf' ],
	[ 'HLIH',  'Han-Linden Hafen' ],
	[ 'FHMD',  'Hann Münden' ],
	[ 'HHN',   'Han-Nordstadt' ],
	[ 'HBUG',  'Hannover Burg' ],
	[ 'HH',    'Hannover Hbf' ],
	[ 'HHBO',  'Hannover-Bornum' ],
	[ 'HLI',   'Hannover-Linden' ],
	[ 'HWU',   'Hannover-Wülfel' ],
	[ 'EHAN',  'Hansa /Dortmd' ],
	[ 'AWHOH', 'Hansaport' ],
	[ 'HVIN',  'Han-Vinnhorst' ],
	[ 'SHN',   'Hanw-Bad Rilchgn' ],
	[ 'SXHA',  'Hanweiler Grenze' ],
	[ 'NHAP',  'Happurg' ],
	[ 'HSOA',  'Harber' ],
	[ 'HHBR',  'Harber/Kr Soltau' ],
	[ 'LHBK',  'Harbke' ],
	[ 'LQHB',  'Harbke ST/NI' ],
	[ 'AHA',   'Harblek' ],
	[ 'MHRG',  'Harburg (Schwab)' ],
	[ 'AHRF',  'Harburg Rathaus' ],
	[ 'AHRS',  'Harburg S-Bahn' ],
	[ 'HHRD',  'Hardegsen' ],
	[ 'XAHA',  'Hard-Fussach' ],
	[ 'NHHF',  'Hardhof' ],
	[ 'KHAR',  'Hardt' ],
	[ 'HHAR',  'Haren (Ems)' ],
	[ 'XBHN',  'Haren Noord' ],
	[ 'XOHU',  'Harestua' ],
	[ 'XFHF',  'Hargarten-Falck' ],
	[ 'XVHR',  'Hargshamn' ],
	[ 'ZUH',   'Harkov-Pass' ],
	[ 'LHAP',  'Harpe' ],
	[ 'HHPS',  'Harpstedt' ],
	[ 'UH',    'Harra' ],
	[ 'UHNO',  'Harra Nord' ],
	[ 'XTHRV', 'Harrachov' ],
	[ 'XTHRS', 'Harrachov st hr' ],
	[ 'XOHR',  'Harran' ],
	[ 'UHRS',  'Harras (Thür)' ],
	[ 'NH',    'Harsdorf' ],
	[ 'AHFD',  'Harsefeld' ],
	[ 'AHSD',  'Harsefeld Süd' ],
	[ 'EHWK',  'Harsewinkel' ],
	[ 'EHWW',  'Harsewinkel West' ],
	[ 'LHAR',  'Harsleben' ],
	[ 'HHT',   'Harst' ],
	[ 'HHRS',  'Harsum' ],
	[ 'THRT',  'Hart (Hohenz)' ],
	[ 'FHAG',  'Hartberg' ],
	[ 'DLTSH', 'Hartenst Str' ],
	[ 'DHST',  'Hartenstein' ],
	[ 'NHAR',  'Hartershofen' ],
	[ 'LBSD',  'Hartgußw Bösdorf' ],
	[ 'MHHS',  'Harthaus' ],
	[ 'DHMU',  'Hartmannmühle' ],
	[ 'NHS',   'Hartmannshof' ],
	[ 'HHRT',  'Hartum' ],
	[ 'XKH',   'Harwich P.Q.' ],
	[ 'LHZG',  'Harzgerode' ],
	[ 'HHAB',  'Hasbergen' ],
	[ 'HHSB',  'Hasbergen/Osnabr' ],
	[ 'HHGG',  'Hasbgn Georgsm' ],
	[ 'HHSL',  'Haselünne' ],
	[ 'HHSW',  'Hasenwechsel' ],
	[ 'RHS',   'Haslach' ],
	[ 'NHCH',  'Hasloch (Main)' ],
	[ 'NQHC',  'Hasloch(Main)LGr' ],
	[ 'AHLH',  'Hasloh' ],
	[ 'AHLF',  'Haslohfurth' ],
	[ 'MHMR',  'Haspelmoor' ],
	[ 'HHPD',  'Hasporter Damm' ],
	[ 'HHSG',  'Hassel (Kr Hoya)' ],
	[ 'SHSS',  'Hassel (Saar)' ],
	[ 'LHAS',  'Hassel (Stendal)' ],
	[ 'LHAG',  'Hassel DB-Gr' ],
	[ 'HHSI',  'Hassel Ida' ],
	[ 'XDHL',  'Hasselager' ],
	[ 'BHSL',  'Hasselberg' ],
	[ 'FHL',   'Hasselborn' ],
	[ 'AHSB',  'Hasselbr S-Bahn' ],
	[ 'AHSF',  'Hasselbrook' ],
	[ 'AHSG',  'Hasselburg' ],
	[ 'LHAF',  'Hasselfelde' ],
	[ 'XBHT',  'Hasselt' ],
	[ 'NHT',   'Haßfurt' ],
	[ 'WHAL',  'Haßleben' ],
	[ 'XVHH',  'Hässleholm' ],
	[ 'RHLO',  'Haßloch (Pfalz)' ],
	[ 'RHAS',  'Haßmersheim' ],
	[ 'HHAS',  'Haste' ],
	[ 'HHAT',  'Hastedt' ],
	[ 'FHAH',  'Hattenbach' ],
	[ 'FHAT',  'Hattenheim' ],
	[ 'FHAS',  'Hattersheim (M)' ],
	[ 'KHAT',  'Hattert' ],
	[ 'XAHI',  'Hatting' ],
	[ 'EHAT',  'Hattingen (Ruhr)' ],
	[ 'RHATA', 'Hattingen Abzw' ],
	[ 'EHTM',  'Hattingen Mitte' ],
	[ 'RHAT',  'Hattingen(Baden)' ],
	[ 'EHAG',  'Hattingn R DB-Gr' ],
	[ 'HHTF',  'Hattorf' ],
	[ 'AHDT',  'Hattstedt' ],
	[ 'SHZ',   'Hatzenport' ],
	[ 'THAU',  'Haubersbronn' ],
	[ 'THAM',  'Haubersbronn Mit' ],
	[ 'RHEB',  'Haueneberstein' ],
	[ 'SHAM',  'Hauenstein Mitte' ],
	[ 'SHAU',  'Hauenstein/Pfalz' ],
	[ 'XOHS',  'Haugastol' ],
	[ 'FNK',   'Haunetal-Neukch' ],
	[ 'MHPH',  'Haupeltshofen' ],
	[ 'SHPG',  'Haupt DB/Miesau' ],
	[ 'AHS',   'Hauptbahnhof SB' ],
	[ 'SHPT',  'Hauptstuhl' ],
	[ 'XSHL',  'Hauptwil' ],
	[ 'XAHAS', 'Haus' ],
	[ 'RHA',   'Hausach' ],
	[ 'MGPH',  'Hausbergbahn' ],
	[ 'XFHBN', 'Hausbergen' ],
	[ 'AHBRM', 'Hausbruch Mitte' ],
	[ 'DHDF',  'Hausdorf' ],
	[ 'UHAU',  'Hausen' ],
	[ 'KHAD',  'Hausen (b Düren)' ],
	[ 'MHNS',  'Hausen (Schwab)' ],
	[ 'FHS',   'Hausen (Taunus)' ],
	[ 'THAT',  'Hausen i Tal' ],
	[ 'RHSN',  'Hausen-Raitbach' ],
	[ 'THSS',  'Hausen-Starzeln' ],
	[ 'FHHF',  'Häuserhof' ],
	[ 'MHHM',  'Hausham' ],
	[ 'MAHU',  'Hauslad-Ba/Feldk' ],
	[ 'NHZB',  'Hauzenberg' ],
	[ 'EHBK',  'Havixbeck' ],
	[ 'XTHA',  'Havlickuv Brod' ],
	[ 'EHGVE', 'Ha-Vorhalle Einf' ],
	[ 'EHGVF', 'Ha-Vorhalle Vof' ],
	[ 'EHGVW', 'Ha-Vorhalle Vwf' ],
	[ 'EHGVO', 'Ha-Vorhalle Yo' ],
	[ 'EHGW',  'Ha-Wehringhsn' ],
	[ 'EHWB',  'Ha-Westerbauer' ],
	[ 'XFHA',  'Hayange' ],
	[ 'XQHP',  'Haydarpasa' ],
	[ 'LHY',   'Haynsburg' ],
	[ 'XFHZ',  'Hazebrouck' ],
	[ 'RHBO',  'Hd Orthopädie' ],
	[ 'RHBF',  'HD West/Südstadt' ],
	[ 'RHKA',  'HD-Altstadt' ],
	[ 'THDV',  'Hdhm Voithwerk' ],
	[ 'THDM',  'Hdhm-Mergelstett' ],
	[ 'THDS',  'Hdhm-Schnaitheim' ],
	[ 'RHKM',  'HD-Kirchh/Rohrb' ],
	[ 'RSR',   'HD-Schlierb/Zieg' ],
	[ 'UHAS',  'Heberndorf' ],
	[ 'MHEF',  'Hebertsfelden' ],
	[ 'MHSN',  'Hebertshausen' ],
	[ 'MHSU',  'Hebertshsn Üst' ],
	[ 'MHDF',  'Hechendorf' ],
	[ 'THCH',  'Hechingen' ],
	[ 'THCG',  'Hechingen DB/HZL' ],
	[ 'THIL',  'Hechingen Landes' ],
	[ 'AHEN',  'Hechthausen' ],
	[ 'RHED',  'Heddesh.(Ba) Ort' ],
	[ 'RGCH',  'Heddesheim/Hberg' ],
	[ 'XDHED', 'Hedehusene' ],
	[ 'FHED',  'Hedemünden' ],
	[ 'NHED',  'Hedersdorf' ],
	[ 'LHEW',  'Hedersleben-Wedd' ],
	[ 'KRHT',  'Hedwigsthal' ],
	[ 'XDHEE', 'Hee' ],
	[ 'XSHR',  'Heerbrugg' ],
	[ 'XNHR',  'Heerenveen' ],
	[ 'XNH',   'Heerlen' ],
	[ 'XNHK',  'Heerlen d Kissel' ],
	[ 'BHST',  'Heerstraße' ],
	[ 'AHEL',  'Heeslingen' ],
	[ 'EHE',   'Heessen' ],
	[ 'EHE P', 'Heessen Hp' ],
	[ 'BHGM',  'Hegermühle' ],
	[ 'EHEG',  'Heggen' ],
	[ 'RHGN',  'Hegne' ],
	[ 'XOHG',  'Hegra' ],
	[ 'XMXHY', 'Hegyeshal Gr AT' ],
	[ 'XMHY',  'Hegyeshalom' ],
	[ 'EHID',  'Heide' ],
	[ 'AHI',   'Heide (Holst)' ],
	[ 'NHDK',  'Heideck' ],
	[ 'AHKU',  'Heidekultur' ],
	[ 'RHWI',  'Heidelb.-Wieb.O.' ],
	[ 'RHBZ',  'Heidelberg Bism.' ],
	[ 'RH',    'Heidelberg Hbf' ],
	[ 'BHEI',  'Heidelberger Pl.' ],
	[ 'RHBH',  'Heidelberg-Hand.' ],
	[ 'RHBW',  'Heidelb-Wiebl' ],
	[ 'RHI',   'Heidelsheim' ],
	[ 'RHIO',  'Heidelsheim Nord' ],
	[ 'DHD',   'Heidenau' ],
	[ 'AHDN',  'Heidenau (Harb)' ],
	[ 'DHDS',  'Heidenau Süd' ],
	[ 'DHDG',  'Heidenau-Gro' ],
	[ 'THD',   'Heidenheim' ],
	[ 'DHDD',  'Heidersdorf (E)' ],
	[ 'FHEI',  'Heidesheim' ],
	[ 'NWHW',  'Heidingsfeld' ],
	[ 'HHEI',  'Heidkrug' ],
	[ 'HHDM',  'Heidmühle (Oldb)' ],
	[ 'NHEIW', 'Heigenbr West' ],
	[ 'NHEI',  'Heigenbrücken' ],
	[ 'THST',  'Heilbr Sülmertor' ],
	[ 'TH S',  'Heilbr. Gbf Süd' ],
	[ 'TH E',  'Heilbr-Kanalbr' ],
	[ 'TH K',  'Heilbr-Klingenbg' ],
	[ 'THAG',  'Heilbronn DB/AVG' ],
	[ 'THSG',  'Heilbronn DB/St' ],
	[ 'TH G',  'Heilbronn Gbf' ],
	[ 'TH',    'Heilbronn Hbf' ],
	[ 'HHLB',  'Heiligenberg' ],
	[ 'WHDM',  'Heiligendamm' ],
	[ 'THHF',  'Heiligenfeld' ],
	[ 'HHFD',  'Heiligenfelde' ],
	[ 'WHEG',  'Heiligengrabe' ],
	[ 'HHLR',  'Heiligenrode' ],
	[ 'RHN',   'Heiligenst (Pf)' ],
	[ 'UHT',   'Heiligenstadt' ],
	[ 'MHEI',  'Heiligenstatt' ],
	[ 'NHE',   'Heilsbronn' ],
	[ 'KHE',   'Heimbach (Eifel)' ],
	[ 'SHB',   'Heimbach (Nahe)' ],
	[ 'SHBG',  'Heimbach DB/RPE' ],
	[ 'FHBH',  'Heimboldshausen' ],
	[ 'XOHI',  'Heimdal' ],
	[ 'MHMK',  'Heimenkirch' ],
	[ 'THMD',  'Heimerdingen' ],
	[ 'KHEH',  'Heimersheim' ],
	[ 'MHMG',  'Heimertingen' ],
	[ 'AHFS',  'Heimfeld' ],
	[ 'HHMS',  'Heimsen' ],
	[ 'MHEM',  'Heimstetten' ],
	[ 'FHEB',  'Heinebach' ],
	[ 'UHDF',  'Heinersdorf' ],
	[ 'FKNZH', 'Heinr-Heine-Str' ],
	[ 'KHCH',  'Heinrich' ],
	[ 'KHEBK', 'Heinsberg Kreish' ],
	[ 'KHEBH', 'Heinsberg-Horst' ],
	[ 'KOB',   'Heinsberg-Oberbr' ],
	[ 'KHEBR', 'Heinsberg-Rander' ],
	[ 'KHEBP', 'Heinsbg-Porselen' ],
	[ 'AHWA',  'Heinschenwalde' ],
	[ 'HHNS',  'Heinsen' ],
	[ 'EBHM',  'Heintzmann' ],
	[ 'SHZH',  'Heinzenhausen' ],
	[ 'XLHD',  'Heisdorf' ],
	[ 'RHE',   'Heitersheim' ],
	[ 'XAHP',  'Heiterw-Plansee' ],
	[ 'BCKW',  'Heizkw Cottbus' ],
	[ 'LHEL',  'Helbra' ],
	[ 'UHD',   'Heldrungen' ],
	[ 'BHEL',  'Helenesee' ],
	[ 'LHFT',  'Helfta' ],
	[ 'EHDF',  'Helgersdorf' ],
	[ 'XOHE',  'Hell' ],
	[ 'KHEL',  'Hellenthal' ],
	[ 'NHZM',  'Hellmitzheim' ],
	[ 'NHB',   'Helmbrechts' ],
	[ 'XNHM',  'Helmond' ],
	[ 'DHLF',  'Helmsdorf' ],
	[ 'RHSM',  'Helmsheim' ],
	[ 'RHM',   'Helmstadt(Baden)' ],
	[ 'HHLM',  'Helmstedt' ],
	[ 'HLMG',  'Helmstedt Grenze' ],
	[ 'EHEP',  'Helpup' ],
	[ 'XVHF',  'Helsingborg F' ],
	[ 'XVH',   'Helsingborgs C' ],
	[ 'XDH',   'Helsingoer' ],
	[ 'XHH',   'Helsinki' ],
	[ 'EHEM',  'Hemer' ],
	[ 'NHEM',  'Hemhofen' ],
	[ 'EHMD',  'Hemmerde' ],
	[ 'SHEM',  'Hemmersd.(Saar)' ],
	[ 'SXHE',  'Hemmersdorf Gr' ],
	[ 'THMG',  'Hemmingen' ],
	[ 'AHE',   'Hemmingstedt' ],
	[ 'AHEM',  'Hemmoor' ],
	[ 'RHCH',  'Hemsbach' ],
	[ 'XFHE',  'Hendaye' ],
	[ 'XSHE',  'Hendschiken' ],
	[ 'NHD',   'Henfenfeld' ],
	[ 'XNHL',  'Hengelo' ],
	[ 'NHBG',  'Hengersberg' ],
	[ 'XFHB',  'Henin-Beaumont' ],
	[ 'XDHEN', 'Henne' ],
	[ 'KHEN',  'Hennef (Sieg)' ],
	[ 'KHES',  'Hennef I Siegb' ],
	[ 'EHNE',  'Hennen' ],
	[ 'BHDF',  'Hennersdorf' ],
	[ 'BHDB',  'Hennersdorf Bk' ],
	[ 'DHRF',  'Hennersdorf (S)' ],
	[ 'BHFW',  'Hennersdorf West' ],
	[ 'BHND',  'Hennigsd (b Bln)' ],
	[ 'BHDW',  'Hennigsd N (Hdw)' ],
	[ 'BHDO',  'Hennigsd N(Hdo)' ],
	[ 'BHD',   'Hennigsdorf S-B' ],
	[ 'BHDN',  'Hennigsdorf Nord' ],
	[ 'AUB',   'Henstedt-Ulzburg' ],
	[ 'FHP N', 'Heppenheim Nord' ],
	[ 'FHP',   'Heppenhm/Bergstr' ],
	[ 'EHBD',  'Herbede' ],
	[ 'THT',   'Herbertingen' ],
	[ 'THTO',  'Herbertingen Ort' ],
	[ 'MHEH',  'Herbertshofen' ],
	[ 'MHEB',  'Herbertshofen S' ],
	[ 'XBH',   'Herbesthal' ],
	[ 'RHRB',  'Herblingen' ],
	[ 'THZ',   'Herbolzheim (Ja)' ],
	[ 'RHZ',   'Herbolzheim(Brg)' ],
	[ 'FHRB',  'Herborn (Dillkr)' ],
	[ 'THC',   'Herbrechtingen' ],
	[ 'KHEC',  'Herchen' ],
	[ 'EHCK',  'Herdecke' ],
	[ 'EHF',   'Herdorf' ],
	[ 'EHFF',  'Herdorf Freien' ],
	[ 'EQHF',  'Herdorf RP/NRW' ],
	[ 'XMHD',  'Herend' ],
	[ 'XBHR',  'Herentals' ],
	[ 'EHFD',  'Herford' ],
	[ 'MHGZ',  'Hergatz' ],
	[ 'XBHE',  'Hergenrath' ],
	[ 'FHER',  'Hergershausen' ],
	[ 'UHRH',  'Heringen (Helme)' ],
	[ 'FHRG',  'Heringen (Werra)' ],
	[ 'WHFN',  'Heringsdf Neuhof' ],
	[ 'XNHB',  'Herkenbosch' ],
	[ 'DHN',   'Herlasgrün' ],
	[ 'UHER',  'Herleshausen' ],
	[ 'UQHE',  'Herleshausen LGr' ],
	[ 'XBHH',  'Hermalle-s-H' ],
	[ 'HHEB',  'Hermannsburg' ],
	[ 'BHER',  'Hermannstraße' ],
	[ 'THMA',  'Hermaringen' ],
	[ 'THMT',  'Hermentingen' ],
	[ 'SHK',   'Hermeskeil' ],
	[ 'SQHK',  'Hermeskeil RP/SL' ],
	[ 'DHS',   'Hermsdf (b Dre)' ],
	[ 'UHK',   'Hermsdorf-Klost' ],
	[ 'XAHN',  'Hernals' ],
	[ 'EHER',  'Herne' ],
	[ 'EHERT', 'Herne Hot' ],
	[ 'EHBO',  'Herne-Börnig' ],
	[ 'EHEO',  'Herne-Rottbruch' ],
	[ 'XDHE',  'Herning' ],
	[ 'XDHEM', 'Herning Messe' ],
	[ 'XFHN',  'Herny' ],
	[ 'XFHNS', 'Herny Stammstr' ],
	[ 'NHER',  'Heroldsberg' ],
	[ 'NHEN',  'Heroldsberg Nord' ],
	[ 'KHER',  'Herrath' ],
	[ 'KHERN', 'Herrath (Nordb)' ],
	[ 'THE',   'Herrenberg' ],
	[ 'THE Z', 'Herrenberg (ZÖA)' ],
	[ 'BHE',   'Herrensee' ],
	[ 'EHRI',  'Herringen' ],
	[ 'THL',   'Herrlingen' ],
	[ 'XFHH',  'Herrlisheim Colm' ],
	[ 'XVHE',  'Herrljunga' ],
	[ 'NHH',   'Herrnberchtheim' ],
	[ 'WHB',   'Herrnburg' ],
	[ 'WQHB',  'Herrnburg MV/SH' ],
	[ 'EHGN',  'Her-Rottbr Hgn' ],
	[ 'EHEOV', 'Her-Rottbr Vockh' ],
	[ 'MHI',   'Herrsching' ],
	[ 'NHR O', 'Hersbr (re P) O' ],
	[ 'NHL',   'Hersbruck (li P)' ],
	[ 'NHR',   'Hersbruck (re P)' ],
	[ 'ZUHE',  'Herson' ],
	[ 'XBHL',  'Herstal' ],
	[ 'HHER',  'Herste' ],
	[ 'RHRT',  'Herten (Baden)' ],
	[ 'EHTN',  'Hertin' ],
	[ 'EHDT',  'Hervest-Dorsten' ],
	[ 'AHWH',  'Herwigshof' ],
	[ 'RHXB',  'Herxheim(Berg)' ],
	[ 'HHB',   'Herzberg (Harz)' ],
	[ 'WHE',   'Herzberg (Mark)' ],
	[ 'HHBS',  'Herzberg Schloß' ],
	[ 'BHZ',   'Herzberg(E)Stadt' ],
	[ 'LHZW',  'Herzberg(Elster)' ],
	[ 'EHEZ',  'Herzebrock' ],
	[ 'XBHZ',  'Herzele' ],
	[ 'FHZN',  'Herzhausen' ],
	[ 'AHZH',  'Herzhorn' ],
	[ 'HHZL',  'Herzlake' ],
	[ 'XSHZ',  'Herzogenbuchsee' ],
	[ 'XAHB',  'Herzogenburg' ],
	[ 'KHEZ',  'Herzogenrath' ],
	[ 'KXH',   'Herzogenrath Gr' ],
	[ 'AHOF',  'Hesedorf' ],
	[ 'RHBA',  'Heselbach' ],
	[ 'HHES',  'Hesepe' ],
	[ 'EEKH',  'Hespertalbahn' ],
	[ 'HHSO',  'Hess Oldendorf' ],
	[ 'XDHMD', 'Hesselmed' ],
	[ 'EHLN',  'Hesseln' ],
	[ 'FSCH',  'Hessen-Schöllenb' ],
	[ 'FKAI',  'Hess-Kailbach' ],
	[ 'HHTR',  'Hestrup' ],
	[ 'UHET',  'Hetschburg' ],
	[ 'FHH',   'Hettenhausen' ],
	[ 'THTN',  'Hettingen/Hohenz' ],
	[ 'LHE',   'Hettstedt' ],
	[ 'XMHV',  'Hetvehely' ],
	[ 'DHZF',  'Hetzdorf (Flöha)' ],
	[ 'DHZG',  'Hetzdorf DB-Gr' ],
	[ 'SHR',   'Hetzerath' ],
	[ 'LHR',   'Heudeber-Danst' ],
	[ 'AHDH',  'Heudorf-Hüttendf' ],
	[ 'MHEU',  'Heufeld' ],
	[ 'MHFM',  'Heufeldmühle' ],
	[ 'XBHEU', 'Heule' ],
	[ 'FHEU',  'Heusenstamm' ],
	[ 'EHIB',  'Hilchenbach' ],
	[ 'NHGN',  'Hildbrandsgrün' ],
	[ 'UHN',   'Hildburghausen' ],
	[ 'KHI',   'Hilden' ],
	[ 'KHIS',  'Hilden Süd' ],
	[ 'HHI G', 'Hildesheim Gbf' ],
	[ 'HHI',   'Hildesheim Hbf' ],
	[ 'HHIO',  'Hildesheim Ost' ],
	[ 'HHIH',  'Hille (W) Hafen' ],
	[ 'HHIW',  'Hille (Westf)' ],
	[ 'XNHO',  'Hillegom' ],
	[ 'EHIG',  'Hillegossen' ],
	[ 'EHIL',  'Hillnhütten' ],
	[ 'RHLT',  'Hilpertsau' ],
	[ 'NKLI',  'Hilpoltst Kling' ],
	[ 'NKNO',  'Hilpoltst Knopf' ],
	[ 'NRAI',  'Hilpoltst Raiff' ],
	[ 'NHP',   'Hilpoltstein' ],
	[ 'HHIL',  'Hilter' ],
	[ 'NHIL',  'Hiltersdorf' ],
	[ 'XNHI',  'Hilversum' ],
	[ 'XNHIS', 'Hilversum Sp' ],
	[ 'AHPF',  'Himmelpforten' ],
	[ 'RHIM',  'Himmelreich' ],
	[ 'NHIS',  'Himmelstadt' ],
	[ 'HHTA',  'Himmelsthür Abzw' ],
	[ 'HHIG',  'Himmighausen' ],
	[ 'XVHI',  'Hindas' ],
	[ 'RMUH',  'Hinkelpfad' ],
	[ 'XDHP',  'Hinnerup' ],
	[ 'MHRS',  'Hinrichssegen' ],
	[ 'XAHTG', 'Hintergasse' ],
	[ 'UHI',   'Hinternah' ],
	[ 'SHWO',  'Hinterweidnt Ort' ],
	[ 'RHIZ',  'Hinterzarten' ],
	[ 'RHIW',  'Hintsch WTB/DB' ],
	[ 'RHIN',  'Hintschingen' ],
	[ 'THI',   'Hirsau' ],
	[ 'NHI',   'Hirschaid' ],
	[ 'NHIR',  'Hirschau' ],
	[ 'DHE',   'Hirschfelde' ],
	[ 'DXHE',  'Hirschfelde Gr' ],
	[ 'MHFN',  'Hirschfelden' ],
	[ 'BHI',   'Hirschgarten' ],
	[ 'RHO',   'Hirschhorn (Ne.)' ],
	[ 'SHIH',  'Hirschhorn (Pf)' ],
	[ 'RQHO',  'Hirschhorn LGr' ],
	[ 'RHIR',  'Hirschsprung' ],
	[ 'XDHI',  'Hirtshals' ],
	[ 'AHIF',  'Hittfeld' ],
	[ 'AQHI',  'Hittfeld NI/HH' ],
	[ 'AHZ',   'Hitzacker' ],
	[ 'XVHJ',  'Hjaltevad' ],
	[ 'XOHJ',  'Hjerkinn' ],
	[ 'XDHM',  'Hjerm' ],
	[ 'XDHJ',  'Hjoerring' ],
	[ 'XHHS',  'Hki Sompas Hansa' ],
	[ 'TH B',  'Hlbr Bfsvorplatz' ],
	[ 'TH A',  'Hlbr Finanzamt' ],
	[ 'TH F',  'Hlbr Friedenspl' ],
	[ 'TH H',  'Hlbr Harmonie' ],
	[ 'TH P',  'Hlbr K-Schu-Pl' ],
	[ 'TH M',  'Hlbr Marktplatz' ],
	[ 'TH U',  'Hlbr Pfühlpark' ],
	[ 'TH R',  'Hlbr Rathaus' ],
	[ 'XTHLC', 'Hlinsko v Cech' ],
	[ 'LHNG',  'Hl-Nietleb DB-Gr' ],
	[ 'LHTS',  'Hl-Trotha S-Bahn' ],
	[ 'XTHMU', 'Hlubocky-Mar Ud' ],
	[ 'KKMB',  'H-Lübke-Ufer' ],
	[ 'LHWW',  'Hl-Wörmlitz West' ],
	[ 'AQEG',  'Hmb Elbgstr LGR' ],
	[ 'AHOSS', 'Hmb H Schaar Süd' ],
	[ 'AHOS',  'Hmb Hohe Schaar' ],
	[ 'ASTZ',  'Hmb Sternschanze' ],
	[ 'AHDG',  'Hmb Süd DB-Gr' ],
	[ 'AHO',   'Hmb U-elbe See' ],
	[ 'AHB',   'Hmb Unterelbe' ],
	[ 'AA G',  'Hmb-Altona Gbf' ],
	[ 'ABG G', 'Hmb-Berged Gbf' ],
	[ 'ABDS',  'Hmb-Berged.Süd' ],
	[ 'ABG',   'Hmb-Bergedorf' ],
	[ 'ABG S', 'Hmb-Bergedorf S' ],
	[ 'AHBT',  'Hmb-Berliner Tor' ],
	[ 'ABBK',  'Hmb-Billbrook' ],
	[ 'ABIS',  'Hmb-Billstedt' ],
	[ 'AHBIU', 'Hmb-Billwerd Ubf' ],
	[ 'AHBI',  'Hmb-Billwerder' ],
	[ 'AE F',  'Hmb-Eidelst Ef' ],
	[ 'AE N',  'Hmb-Eidelst En' ],
	[ 'AE O',  'Hmb-Eidelst Eo' ],
	[ 'AENZ',  'Hmb-Eidelst Zent' ],
	[ 'AE',    'Hmb-Eidelstedt' ],
	[ 'AEN',   'Hmb-Eidelstedt' ],
	[ 'AHARH', 'Hmb-Harb Bbf Süd' ],
	[ 'AHAR',  'Hmb-Harburg' ],
	[ 'AHARB', 'Hmb-Harburg Bbf' ],
	[ 'AHBG',  'Hmb-Hausbr DB-Gr' ],
	[ 'AHBR',  'Hmb-Hausbruch' ],
	[ 'AHBRS', 'Hmb-Hausbruch SB' ],
	[ 'ALAA',  'Hmb-Langenf Abzw' ],
	[ 'ALA',   'Hmb-Langenfd Bbf' ],
	[ 'AMOO',  'Hmb-Moorfleet' ],
	[ 'ANR',   'Hmb-Neugraben' ],
	[ 'ARALB', 'Hmb-Rahl Bbf' ],
	[ 'ARAL',  'Hmb-Rahlstedt' ],
	[ 'AQRI',  'Hmb-Rissen LGr' ],
	[ 'AROW',  'Hmb-Rissen Ölw Ü' ],
	[ 'AHROO', 'Hmb-Roth Ro' ],
	[ 'AHROP', 'Hmb-Roth Rop' ],
	[ 'AHROF', 'Hmb-Roth Tk' ],
	[ 'AHRO',  'Hmb-Rothburgsort' ],
	[ 'ASLS',  'Hmb-Schnelsen' ],
	[ 'ASLD',  'Hmb-SchnelsenSüd' ],
	[ 'AWHO',  'Hmb-Waltershof' ],
	[ 'AWN F', 'Hmb-Wandsbek Wf' ],
	[ 'AWLG',  'Hmb-Wilhbg DB-Gr' ],
	[ 'AWLB',  'Hmb-Wilhelmsbg' ],
	[ 'AWLBA', 'Hmb-Wlb Abzw' ],
	[ 'AWLBS', 'Hmb-Wlb Abzw S-B' ],
	[ 'XTHE',  'Hnevceves' ],
	[ 'XTHN',  'Hnevice' ],
	[ 'XDHB',  'Hobro' ],
	[ 'KHO',   'Hochdahl' ],
	[ 'KHOL',  'Hochdahl Abzw' ],
	[ 'KHOW',  'Hochdahl Awanst' ],
	[ 'KHOM',  'Hochdahl-Millr' ],
	[ 'AHOD',  'Hochdonn' ],
	[ 'THF',   'Hochdorf(b Horb)' ],
	[ 'XFHC',  'Hochfelden' ],
	[ 'XAHF',  'Hochfilzen' ],
	[ 'THO',   'Hochhausen' ],
	[ 'FHM',   'Hochheim (Main)' ],
	[ 'AHPS',  'Hochkamp' ],
	[ 'KHOK',  'Hochneukirch' ],
	[ 'SHY',   'Hochspeyer' ],
	[ 'SHY N', 'Hochspeyer Nord' ],
	[ 'SHY O', 'Hochspeyer Ost' ],
	[ 'FHT',   'Höchst (Odenw)' ],
	[ 'RHOSG', 'Hochst Grenzstr' ],
	[ 'MHDT',  'Höchstädt/Donau' ],
	[ 'SHST',  'Hochstätten/Pf' ],
	[ 'RHOS',  'Hochstetten' ],
	[ 'SHS',   'Hochstetten/Nahe' ],
	[ 'FHET',  'Höchst-Hetschb' ],
	[ 'NHM',   'Hochst-Marktzeu' ],
	[ 'EHOC',  'Hochstraße' ],
	[ 'MHWG',  'Hochwang' ],
	[ 'XAHO',  'Hochzirl' ],
	[ 'RHK',   'Hockenheim' ],
	[ 'UHR',   'Hockeroda' ],
	[ 'EHOE',  'Höcklingsen' ],
	[ 'KHOD',  'Höddelbusch' ],
	[ 'HHOD',  'Hodenhagen' ],
	[ 'LHDG',  'Hödingen' ],
	[ 'XMHM',  'Hodmezövasarhely' ],
	[ 'ZUHO',  'Hodorov' ],
	[ 'XZH',   'Hodos' ],
	[ 'XBHO',  'Hoeilaart' ],
	[ 'XDHT',  'Hoeje Taastrup' ],
	[ 'XDHTT', 'Hoeje Taastrup T' ],
	[ 'XDHS',  'Hoejslev' ],
	[ 'XNHH',  'Hoek v. Holland' ],
	[ 'XDHOE', 'Hoerdum' ],
	[ 'XDHG',  'Hoerning' ],
	[ 'KHTS',  'Hoerstg-Sevelen' ],
	[ 'RHOF',  'Hof (Münstertal)' ],
	[ 'NHO',   'Hof Hbf' ],
	[ 'NHAN',  'Hof Hbf Haßmann' ],
	[ 'NSHO',  'Hof Hbf Stadt 1' ],
	[ 'NHOS',  'Hof Hbf Stadt 2' ],
	[ 'NVBS',  'Hof Vogtl Baumw' ],
	[ 'NLEA',  'Hof Westfalen AG' ],
	[ 'SHFD',  'Hofeld' ],
	[ 'THOF',  'Hofen (b Aalen)' ],
	[ 'THOE',  'Höfen (Enz)' ],
	[ 'THON',  'Höfen (Enz) Nord' ],
	[ 'RHFF',  'Hoffenheim' ],
	[ 'KHOF',  'Hoffnungsthal' ],
	[ 'FHFG',  'Hofgeismar' ],
	[ 'FHMM',  'Hofgeism-Hümme' ],
	[ 'MHH',   'Hofham' ],
	[ 'FHOR',  'Hofheim (Ried)' ],
	[ 'FHF',   'Hofheim (Taunus)' ],
	[ 'THFG',  'Höfingen' ],
	[ 'NHN',   'Höflein' ],
	[ 'NHON',  'Hof-Neuhof' ],
	[ 'NZAP',  'Hof-Neuhof Zapf' ],
	[ 'XVHY',  'Högsby' ],
	[ 'NHMA',  'Hohe Marter' ],
	[ 'NHW',   'Hohe Wart' ],
	[ 'KHOG',  'Hohegrete' ],
	[ 'YBBHN', 'Hohen Neuend Sw' ],
	[ 'BHOW',  'Hohen Neuend W' ],
	[ 'BHN',   'Hohen Neuendorf' ],
	[ 'XAHH',  'Hohenau' ],
	[ 'HHVB',  'Hohenaverbergen' ],
	[ 'MHOB',  'Hohenbrunn' ],
	[ 'UHO',   'Hohenebra' ],
	[ 'UHOG',  'Hohenebra DB-Gr' ],
	[ 'UHOO',  'Hohenebra Ort' ],
	[ 'HHEG',  'Hoheneggelsen' ],
	[ 'HHEP',  'Hoheneggelsen Hp' ],
	[ 'FHC',   'Hoheneiche' ],
	[ 'AHCH',  'Hoheneichen' ],
	[ 'XAHS',  'Hohenems' ],
	[ 'DHOF',  'Hohenfichte' ],
	[ 'EHOH',  'Hohenhagen' ],
	[ 'KHOS',  'Höhenhaus' ],
	[ 'MHSB',  'Höhenkrchn-Siegb' ],
	[ 'BHL',   'Hohenleipisch' ],
	[ 'UHOL',  'Hohenleuben' ],
	[ 'EHOG',  'Hohenlimburg' ],
	[ 'LHOH',  'Hohennauen' ],
	[ 'MHPG',  'Hohenpeißenberg' ],
	[ 'LHRA',  'Hohenroda' ],
	[ 'MHSL',  'Hohenschäftlarn' ],
	[ 'BHH',   'Hohenschhsn S-B' ],
	[ 'NHOH',  'Hohenstadt(Mfr)' ],
	[ 'DHO',   'Hohenst-Ernstt' ],
	[ 'FHSU',  'Hohensülzen' ],
	[ 'EHOY',  'Hohensyburg' ],
	[ 'LHM',   'Hohenthurm' ],
	[ 'NHWNC', 'Hohenw Campingpl' ],
	[ 'NHWN',  'Hohenwarth' ],
	[ 'AHWT',  'Hohenwestedt' ],
	[ 'LHWU',  'Hohenwulsch' ],
	[ 'BHO',   'Hohenzollerndamm' ],
	[ 'SHMB',  'Höhmühlbach' ],
	[ 'DRDFH', 'Hohndorf Mitte' ],
	[ 'XVHOK', 'Hok' ],
	[ 'XOHO',  'Hokksund' ],
	[ 'HHDF',  'Holdorf (Oldb)' ],
	[ 'WHOL',  'Holdorf(Meckl)' ],
	[ 'LHO',   'Holleben' ],
	[ 'NHTL',  'Höllenthal' ],
	[ 'HHLI',  'Hollige' ],
	[ 'MHRK',  'Höllriegelskr' ],
	[ 'XOHT',  'Holmestrand' ],
	[ 'AHES',  'Holm-Seppensen' ],
	[ 'XTHO',  'Holoubkov' ],
	[ 'XDHO',  'Holstebro' ],
	[ 'AHST',  'Holstenstr' ],
	[ 'AHSO',  'Holstenstr D' ],
	[ 'AHSH',  'Holstenstr H' ],
	[ 'AKTKH', 'Holstentherme' ],
	[ 'HHOL',  'Holtensen/Linder' ],
	[ 'HHOHA', 'Holthausen' ],
	[ 'HHOH',  'Holthausen (Ems)' ],
	[ 'WHO',   'Holthusen' ],
	[ 'HHOE',  'Höltinghausen' ],
	[ 'HHTM',  'Holtum' ],
	[ 'XTHS',  'Holysov' ],
	[ 'LQHZ',  'Holzdorf ST/BB' ],
	[ 'UHF',   'Holzdorf(b Weim)' ],
	[ 'LHZ',   'Holzdorf(Elster)' ],
	[ 'THZG',  'Holzgerlingen' ],
	[ 'THZGN', 'Holzgerlingen N' ],
	[ 'THZGB', 'Holzgerlingen-Bu' ],
	[ 'DHU',   'Holzhau' ],
	[ 'DHUS',  'Holzhau Skilift' ],
	[ 'EHOZ',  'Holzhausen/Sieg' ],
	[ 'KHOZ',  'Holzheim b Neuss' ],
	[ 'HHZH',  'Holzhsn-Heddhsn' ],
	[ 'MHO',   'Holzkirchen' ],
	[ 'HHZM',  'Holzminden' ],
	[ 'RBOH',  'Holzweg' ],
	[ 'LBTS',  'Holzweißig' ],
	[ 'EHZW',  'Holzwickede' ],
	[ 'XFHM',  'Hombourg Ht' ],
	[ 'SHO',   'Homburg(Saar)Hbf' ],
	[ 'XFHOG', 'Hommarting' ],
	[ 'XOHMV', 'Hommelvik' ],
	[ 'XOHF',  'Honefoss' ],
	[ 'KHOR',  'Honrath' ],
	[ 'FHOF',  'Hoof (Kr Kassel)' ],
	[ 'XNHD',  'Hoofddorp' ],
	[ 'XNHG',  'Hoogeveen' ],
	[ 'XNHS',  'Hoogezand-Sapp' ],
	[ 'HHOS',  'Hoogstede' ],
	[ 'XAHG',  'Hopfgarten' ],
	[ 'LHGT',  'Hopfgarten (Sa)' ],
	[ 'XAHGB', 'Hopfgarten / B' ],
	[ 'UHP',   'Hopfgarten(Kr W)' ],
	[ 'MHPF',  'Höpfling' ],
	[ 'EHOP',  'Hoppecke' ],
	[ 'BHPG',  'Hoppegarten S-B' ],
	[ 'BHPN',  'Hoppegarten (M)' ],
	[ 'WHP',   'Hoppenwalde' ],
	[ 'MHOP',  'Hoppingen' ],
	[ 'SHPS',  'Hoppstädten/Nahe' ],
	[ 'THB',   'Horb' ],
	[ 'THB R', 'Horb Gbf' ],
	[ 'KHBR',  'Horchheimer Br.' ],
	[ 'RHOA',  'Hörden' ],
	[ 'RHOR',  'Hörden Hp' ],
	[ 'LHF',   'Hordorf' ],
	[ 'XSHG',  'Horgen' ],
	[ 'AHOW',  'Hörgensweg' ],
	[ 'BHG',   'Horka Gbf' ],
	[ 'BXH',   'Horka Grenze' ],
	[ 'BHRM',  'Horka Mitte' ],
	[ 'BHR',   'Horka Pbf' ],
	[ 'XVHOE', 'Hörle' ],
	[ 'EHOK',  'Horlecke' ],
	[ 'MHLK',  'Hörlkofen' ],
	[ 'AHOR',  'Horn' ],
	[ 'AHOE',  'Hörn' ],
	[ 'XSHB',  'Horn (Bodensee)' ],
	[ 'XSHBS', 'Horn(Bodensee) S' ],
	[ 'EHBM',  'Horn-Bad Meinbg' ],
	[ 'RHBG',  'Hornberg' ],
	[ 'XDHN',  'Horne' ],
	[ 'HHRN',  'Hörne' ],
	[ 'HHRG',  'Hörne DB-Gr' ],
	[ 'AHOG',  'Horneburg' ],
	[ 'XTHB',  'Horni Blatna' ],
	[ 'XTHD',  'Horni Dvoriste' ],
	[ 'XTHK',  'Horni Kamenice' ],
	[ 'XTHL',  'Horni Lidec' ],
	[ 'XTHP',  'Horni Podluzi' ],
	[ 'XTHPT', 'Horni Poustevna' ],
	[ 'XTHSY', 'Horni Skrychov' ],
	[ 'WHOR',  'Hornstorf' ],
	[ 'XTHV',  'Horovice' ],
	[ 'MHPD',  'Hörpolding' ],
	[ 'XVHO',  'Horred' ],
	[ 'KHR',   'Horrem' ],
	[ 'KHR U', 'Horrem Übgbf' ],
	[ 'UHL',   'Hörschel' ],
	[ 'XAHOG', 'Hörsching' ],
	[ 'UHOS',  'Hörselgau' ],
	[ 'XDHR',  'Horsens' ],
	[ 'LHSG',  'Hörsingen' ],
	[ 'AHOT',  'Horst in Holst' ],
	[ 'HHTL',  'Hörstel' ],
	[ 'HHOW',  'Hörstel-Ostenwld' ],
	[ 'EHOR',  'Horstmar' ],
	[ 'EHOM',  'Hörstmar (Lippe)' ],
	[ 'XPHZ',  'Horyniec Zdroj' ],
	[ 'NHOE',  'Hösbach' ],
	[ 'EHOS',  'Hösel' ],
	[ 'BHC',   'Hosena' ],
	[ 'BQHC',  'Hosena BB/SN' ],
	[ 'YLLHC', 'Hosena Strw' ],
	[ 'XCHO',  'Hosta' ],
	[ 'EHST',  'Höste' ],
	[ 'EHOV',  'Hövelhof' ],
	[ 'EHOW',  'Hövelhof TWE' ],
	[ 'EHOD',  'Hövelhof Industg' ],
	[ 'EHVR',  'Hövelriege' ],
	[ 'XOHV',  'Hovin' ],
	[ 'XVHVT', 'Hovslätt' ],
	[ 'HHX',   'Höxter' ],
	[ 'HHXR',  'Höxter Rathaus' ],
	[ 'HHYA',  'Hoya' ],
	[ 'HHYH',  'Hoyerhagen' ],
	[ 'BHW',   'Hoyerswerda' ],
	[ 'BHW W', 'Hoyerswerda W 6' ],
	[ 'BHWN',  'Hoyersw-Neustadt' ],
	[ 'HHOY',  'Hoykenkamp' ],
	[ 'THBH',  'Hp Heiligenfeld' ],
	[ 'XTHR',  'Hradek n. N.' ],
	[ 'XTHRG', 'Hradek n.N.(PL)' ],
	[ 'XCHA',  'Hramcovskaia' ],
	[ 'XTHM',  'Hranice n Morave' ],
	[ 'XTHC',  'Hranicna' ],
	[ 'XTHY',  'Hrebeny' ],
	[ 'XCHR',  'Hrizolitovyi' ],
	[ 'XZHK',  'Hrpelje-Kozina' ],
	[ 'RHAR',  'Hubacker' ],
	[ 'KHUB',  'Hubertushof' ],
	[ 'BHUB',  'Hubertushöhe' ],
	[ 'KHUS',  'Huchem-Stammeln' ],
	[ 'WHU',   'Huckstorf' ],
	[ 'HHUD',  'Hude' ],
	[ 'XUH',   'Huedin' ],
	[ 'RHFH',  'Hüffenhardt' ],
	[ 'RHF',   'Hüfingen' ],
	[ 'RHFM',  'Hüfingen Mitte' ],
	[ 'KHU',   'Hüls' ],
	[ 'ECWHA', 'Hüls AG' ],
	[ 'KHUG',  'Hülser Berg' ],
	[ 'FHUE',  'Hünfeld' ],
	[ 'XSHU',  'Hüntwangen-Wil' ],
	[ 'KHTB',  'Hürth' ],
	[ 'KBTH',  'Hürth-Berrenrath' ],
	[ 'KHTH',  'Hürth-Hermülheim' ],
	[ 'KKASS', 'Hürth-K Südk' ],
	[ 'KKAS',  'Hürth-Kalscheur' ],
	[ 'KKEN',  'Hürth-Kendenich' ],
	[ 'EHTD',  'Hüsten Ost' ],
	[ 'XAHUT', 'Hüttau' ],
	[ 'THTT',  'Hütten' ],
	[ 'AHTB',  'Hüttenbusch' ],
	[ 'UHGR',  'Hüttengrund' ],
	[ 'UHUE',  'Hüttengrund Hp' ],
	[ 'LHUE',  'Hüttenrode' ],
	[ 'SHT',   'Hüttingen' ],
	[ 'HHTZ',  'Hützel(Lünebg)' ],
	[ 'MHUF',  'Hufschlag' ],
	[ 'MHFG',  'Hufschlag Abzw' ],
	[ 'MHUG',  'Huglfing' ],
	[ 'EHUO',  'Hugo' ],
	[ 'EHUOS', 'Hugo Abzw' ],
	[ 'RHU',   'Hugstetten' ],
	[ 'THUB',  'Hulb' ],
	[ 'MHUS',  'Huldsessen' ],
	[ 'XVHT',  'Hult' ],
	[ 'XVHD',  'Hultsfred' ],
	[ 'BHUM',  'Humboldthain' ],
	[ 'XDHUM', 'Humlum' ],
	[ 'XOHUF', 'Hunderfossen' ],
	[ 'DHUN',  'Hundsgrün' ],
	[ 'FHUN',  'Hundstadt' ],
	[ 'FHUG',  'Hungen' ],
	[ 'HEHB',  'Huntebrücke' ],
	[ 'HHUB',  'Hunteburg' ],
	[ 'HHUL',  'Huntlosen' ],
	[ 'XDHY',  'Hurup Thy' ],
	[ 'AY',    'Husby' ],
	[ 'XVHU',  'Huskvarna' ],
	[ 'ZUHU',  'Hust' ],
	[ 'AHM',   'Husum' ],
	[ 'RHTT',  'Huttenheim' ],
	[ 'XBHU',  'Huy' ],
	[ 'RHUB',  'Huzenbach' ],
	[ 'XDHD',  'Hvidbjerg' ],
	[ 'XDHVD', 'Hviding' ],
	[ 'BSWSX', 'HW Schöneweide' ],
	[ 'SHWG',  'Hweident DB/AVG' ],
	[ 'SHWP',  'H\'weidenthal Hp' ],
	[ 'SHW',   'H\'weidenthal Ost' ],
	[ 'XDHYL', 'Hyllerslev' ],
	[ 'XUIB',  'Iacobeni' ],
	[ 'ZUI',   'Iagodin' ],
	[ 'XCIA',  'Iarcevo' ],
	[ 'ZUIP',  'Iasinovataia-Pas' ],
	[ 'RIB',   'Ibach' ],
	[ 'HI',    'Ibbenbüren' ],
	[ 'EIAG',  'Ibbenbüren DB-Gr' ],
	[ 'EIBO',  'Ibbenbüren Ost' ],
	[ 'HESH',  'Ibbenbüren-Esch' ],
	[ 'HLGG',  'Ibb-Laggenbeck' ],
	[ 'MIHN',  'Ichenhausen' ],
	[ 'MIC',   'Icking' ],
	[ 'SIDO',  'Idar-Oberstein' ],
	[ 'XGI',   'Idomeni' ],
	[ 'FIST',  'Idstein (Taunus)' ],
	[ 'FIDS',  'Idstein Üst' ],
	[ 'MSTA',  'Iffeldorf' ],
	[ 'XIIGM', 'Igea Marina' ],
	[ 'SIG',   'Igel' ],
	[ 'SXIG',  'Igel Grenze' ],
	[ 'SIGW',  'Igel West' ],
	[ 'NIDF',  'Igensdorf' ],
	[ 'TIH',   'Igersheim' ],
	[ 'ZLI',   'Ignalina' ],
	[ 'HIHV',  'Ihrhove' ],
	[ 'RIR',   'Ihringen' ],
	[ 'FQIHA', 'Ihringhsn 1732' ],
	[ 'FQIH',  'Ihringhsn 1733' ],
	[ 'XDIK',  'Ikast' ],
	[ 'XYI',   'Ilava' ],
	[ 'XPIL',  'Ilawa Glowna' ],
	[ 'LIB',   'Ilberstedt' ],
	[ 'XCIL',  'Ilezk' ],
	[ 'LIF',   'Ilfeld' ],
	[ 'LIFB',  'Ilfeld Bad' ],
	[ 'LIFS',  'Ilfeld Schreiber' ],
	[ 'XUI',   'Ilia' ],
	[ 'XZIB',  'Ilirska Bistrica' ],
	[ 'MILT',  'Illertissen' ],
	[ 'NILL',  'Illesheim' ],
	[ 'SILG',  'Illingen (Saar)' ],
	[ 'TIL',   'Illingen (Württ)' ],
	[ 'UI',    'Ilmenau' ],
	[ 'UIB',   'Ilmenau Bad' ],
	[ 'UIBG',  'Ilmenau DB-Gr' ],
	[ 'UIR',   'Ilmenau-Roda' ],
	[ 'UIP',   'Ilm-Pörl Höhe' ],
	[ 'HILD',  'Ilsede' ],
	[ 'HILS',  'Ilsede Süd' ],
	[ 'LIG',   'Ilsenburg' ],
	[ 'XOIG',  'Ilseng' ],
	[ 'XUIM',  'Ilva Mica' ],
	[ 'ZUITS', 'Im Tarasa Shevch' ],
	[ 'UIM',   'Immelborn' ],
	[ 'RIMM',  'Immend Mitte' ],
	[ 'RIM',   'Immendingen' ],
	[ 'RIMZ',  'Immend-Zimmern' ],
	[ 'FIM',   'Immenh (Hess)' ],
	[ 'NIM',   'Immenreuth' ],
	[ 'XSIM',  'Immensee' ],
	[ 'HIMS',  'Immensen-Arpke' ],
	[ 'MIMS',  'Immenstadt' ],
	[ 'KIMI',  'Immigrath' ],
	[ 'XII',   'Imola' ],
	[ 'XIIO',  'Imperia Oneglia' ],
	[ 'XIIM',  'Imperia PM' ],
	[ 'XAIB',  'Imsterberg' ],
	[ 'XAIP',  'Imst-Pitztal' ],
	[ 'HBHID', 'Imsumer Deich' ],
	[ 'SIM',   'Imsweiler' ],
	[ 'XIINS', 'Incisa Scapac' ],
	[ 'RLAI',  'Ind.Stammgleis' ],
	[ 'RRAI',  'Ind-Stammgl Rast' ],
	[ 'SMZS',  'Industriegelände' ],
	[ 'EIPU',  'Industriepk Unna' ],
	[ 'XVIT',  'Ingatorp' ],
	[ 'KING',  'Ingelbach' ],
	[ 'FIL',   'Ingelheim' ],
	[ 'XBIM',  'Ingelmunster' ],
	[ 'MISD',  'Ingol Sandrach' ],
	[ 'MINU',  'Ingolst Nord Ubf' ],
	[ 'MIH',   'Ingolstadt Hbf' ],
	[ 'MIN',   'Ingolstadt Nord' ],
	[ 'XFIW',  'Ingwiller' ],
	[ 'MINI',  'Inningen' ],
	[ 'XAI',   'Innsbruck Hbf' ],
	[ 'XAIH',  'Innsbruck Höttg' ],
	[ 'XAIW',  'Innsbruck Westbf' ],
	[ 'BIP',   'Innsbrucker Pl' ],
	[ 'XGIN',  'Inoi' ],
	[ 'XMIG',  'Inota-Gyartelep' ],
	[ 'XPIW',  'Inowroclaw' ],
	[ 'XPIWR', 'Inowroclaw Rab' ],
	[ 'WIM',   'Inselst Malchow' ],
	[ 'RIN',   'Insheim' ],
	[ 'XSIO',  'Interlaken Ost' ],
	[ 'XSI',   'Interlaken West' ],
	[ 'XAIDM', 'Inzersdf Metzger' ],
	[ 'XAIDL', 'Inzersdorf Lokal' ],
	[ 'XAID',  'Inzersdorf Ort' ],
	[ 'XAIDP', 'Inzersdorf Pbf' ],
	[ 'TIN',   'Inzigkofen' ],
	[ 'XAIZ',  'Inzing' ],
	[ 'NI',    'Iphofen' ],
	[ 'NIP',   'Ipsheim' ],
	[ 'DIR',   'Irfersgrün' ],
	[ 'EIGW',  'Irmgarteichen-W' ],
	[ 'NIR',   'Irrenlohe' ],
	[ 'XEIR',  'Irun' ],
	[ 'XFIS',  'Is sur Tille' ],
	[ 'MAIE',  'Isar-Amperw/Egad' ],
	[ 'XMI',   'Isaszeg' ],
	[ 'XIIT',  'Iselle di Trasqu' ],
	[ 'XIXIT', 'Iselle Grenze CH' ],
	[ 'AIS',   'Iserbrook' ],
	[ 'EIL',   'Iserlohn' ],
	[ 'EILH',  'Iserlohnerheide' ],
	[ 'HIHG',  'Isernhagen' ],
	[ 'XCIS',  'Ishim' ],
	[ 'XCIK',  'Isilkul' ],
	[ 'MIS',   'Ismaning' ],
	[ 'XIIC',  'Isola d Cantone' ],
	[ 'XIIS',  'Isola d Scala' ],
	[ 'XIIA',  'Isola d\'Asti' ],
	[ 'XIIP',  'Ispica' ],
	[ 'TIP',   'Ispringen' ],
	[ 'EIAV',  'Isselh-Avenwedde' ],
	[ 'EIAW',  'Isselh-Avenwedde' ],
	[ 'XQIS',  'Istanbul Sirkeci' ],
	[ 'RIT',   'Istein' ],
	[ 'RITB',  'Ittersbach' ],
	[ 'RITI',  'Ittersbach Indu.' ],
	[ 'RITBR', 'Ittersbach Rath' ],
	[ 'NIL',   'Ittling' ],
	[ 'RITL',  'Ittlingen' ],
	[ 'AIZ',   'Itzehoe' ],
	[ 'TIT',   'Itzelberg' ],
	[ 'XCIU',  'Iudino' ],
	[ 'XRIG',  'Ivanic Grad' ],
	[ 'XRIV',  'Ivankovo' ],
	[ 'ZWI',   'Ivazevicy' ],
	[ 'LIR',   'Ivenrode' ],
	[ 'KIV',   'Iversheim' ],
	[ 'WJAB',  'Jabel (Meckl)' ],
	[ 'XTJA',  'Jabl n Nis zasta' ],
	[ 'XTJAD', 'Jabl n Nisou d.n' ],
	[ 'XTJAB', 'Jabl nad Nisou' ],
	[ 'ZBJA',  'Jablanica' ],
	[ 'XTJY',  'Jablonecke Pasek' ],
	[ 'XTJP',  'Jablonne / P' ],
	[ 'XTJN',  'Jablunkov-Navsi' ],
	[ 'BJF',   'Jacobsdorf' ],
	[ 'LJL',   'Jacobsthal' ],
	[ 'HJAD',  'Jaderberg' ],
	[ 'HWJG',  'JadeWeserP DB-Gr' ],
	[ 'HWJP',  'JadeWeserPort' ],
	[ 'WJS',   'Jagdschloß' ],
	[ 'MJGS',  'Jägerhs(b B Kgr)' ],
	[ 'SJF',   'Jägersfreude' ],
	[ 'TJAH',  'Jagsthausen' ],
	[ 'TJM',   'Jagstheim' ],
	[ 'TJZ',   'Jagstzell' ],
	[ 'DJD',   'Jahnsdorf (Erzg)' ],
	[ 'XPJKZ', 'Jakuszyce' ],
	[ 'AJA',   'Jameln' ],
	[ 'XDJP',  'Janderup' ],
	[ 'XPJK',  'Janikowo' ],
	[ 'XRJK',  'Jankovci' ],
	[ 'XPJZ',  'Jankowa Zaganska' ],
	[ 'XPJP',  'Jankowo Pomorski' ],
	[ 'BJB',   'Jannowitzbrücke' ],
	[ 'XTJU',  'Janovice n Uh' ],
	[ 'BJW',   'Jänschwalde' ],
	[ 'BJWO',  'Jänschwalde Ost' ],
	[ 'XOJ',   'Jaren' ],
	[ 'XPJA',  'Jarocin' ],
	[ 'XTJZ',  'Jaromer zast' ],
	[ 'AJHH',  'Jarrenwisch' ],
	[ 'XPJ',   'Jasien' ],
	[ 'WJAS',  'Jasnitz' ],
	[ 'XPJAO', 'Jastrzebsko' ],
	[ 'XEX',   'Jativa/Xativa' ],
	[ 'WJK',   'Jatznick' ],
	[ 'LJV',   'Jävenitz' ],
	[ 'XPJS',  'Jaworzno Szczak' ],
	[ 'LJEB',  'Jeber-Bergfried' ],
	[ 'RJ',    'Jechtingen' ],
	[ 'XAJD',  'Jedlersdorf' ],
	[ 'XTJL',  'Jedlova' ],
	[ 'WJER',  'Jeeser' ],
	[ 'XDJE',  'Jegum' ],
	[ 'XPJG',  'Jelenia Gora' ],
	[ 'XBJ',   'Jemelle' ],
	[ 'UJP',   'Jena Paradies' ],
	[ 'UJS',   'Jena Saalbahnhof' ],
	[ 'UJW',   'Jena West' ],
	[ 'UGW',   'Jena-Göschwitz' ],
	[ 'UJZ',   'Jena-Zwätzen' ],
	[ 'XAJB',  'Jenbach' ],
	[ 'XAJBZ', 'Jenbach Zillert' ],
	[ 'XTJE',  'Jenec' ],
	[ 'XZJ',   'Jesenice' ],
	[ 'XTJNY', 'Jesenny' ],
	[ 'LJES',  'Jesewitz (b Lpz)' ],
	[ 'LJN',   'Jessen (Elster)' ],
	[ 'LJZ',   'Jeßnitz (Anh)' ],
	[ 'AJF',   'Jesteburg' ],
	[ 'XSJE',  'Jestetten' ],
	[ 'HJEB',  'Jettebruch' ],
	[ 'MJEB',  'Jettenbach' ],
	[ 'MJET',  'Jettingen' ],
	[ 'XFJM',  'Jeumont' ],
	[ 'HJ',    'Jever' ],
	[ 'XUJB',  'Jibou' ],
	[ 'XTJV',  'Jihlava' ],
	[ 'XTJM',  'Jihlava Mesto' ],
	[ 'XTJS',  'Jindrichov v S' ],
	[ 'XTJD',  'Jiretin pod Jedl' ],
	[ 'XTJ',   'Jirikov' ],
	[ 'XTJK',  'Jirkov' ],
	[ 'XTJI',  'Jirkov z.' ],
	[ 'ZWJ',   'Jitkovichi' ],
	[ 'ZUJT',  'Jitomir' ],
	[ 'BJLB',  'J-Leber-Brücke' ],
	[ 'ZUJM',  'Jmerinka' ],
	[ 'WJT',   'Joachimsthal' ],
	[ 'WWLS',  'Joachimsthal Kbf' ],
	[ 'DJA',   'Jocketa' ],
	[ 'RJO',   'Jockgrim Bf' ],
	[ 'MJBS',  'Jodbad Sulzbrunn' ],
	[ 'XFJF',  'Joeuf' ],
	[ 'DJ',    'Johanngeorgenst' ],
	[ 'DXJ',   'Johanngeorgst Gr' ],
	[ 'RJL',   'Jöhlingen' ],
	[ 'RJLB',  'Jöhlingen Bf' ],
	[ 'RJLW',  'Jöhlingen West' ],
	[ 'XFJY',  'Joigny' ],
	[ 'XVJ',   'Jönköping C' ],
	[ 'XVJG',  'Jonkoping Gb' ],
	[ 'XVJK',  'Jonkoping Kombi' ],
	[ 'XVJO',  'Jonsered' ],
	[ 'XOJS',  'Jorstad' ],
	[ 'NJS',   'Jossa' ],
	[ 'NQJS',  'Jossa HE/BY' ],
	[ 'DJZ',   'Jößnitz' ],
	[ 'XHJ',   'Joutseno' ],
	[ 'XAJ',   'Judenburg' ],
	[ 'AJ',    'Jübek' ],
	[ 'KJUC',  'Jüchen' ],
	[ 'LJD',   'Jüdendorf' ],
	[ 'HJD',   'Jühnde' ],
	[ 'KJ',    'Jülich' ],
	[ 'KJND',  'Jülich Nord' ],
	[ 'KJB',   'Jülich-Broich' ],
	[ 'KJSE',  'Jülich-Selgersdf' ],
	[ 'KJU',   'Jünkerath' ],
	[ 'BJUE',  'Jüterbog' ],
	[ 'BJUEG', 'Jüterbog Gbf' ],
	[ 'MJUL',  'Julbach' ],
	[ 'BJUN',  'Jungfernheide' ],
	[ 'BJUF',  'Jungfernheide N' ],
	[ 'FKJK',  'Jungfernkopf' ],
	[ 'AJUS',  'Jungfernstieg' ],
	[ 'TJUH',  'Jungingen/Hohenz' ],
	[ 'TJNU',  'Jungnau' ],
	[ 'XRJU',  'Jurdani' ],
	[ 'XFJU',  'Juvisy' ],
	[ 'KKBP',  'K Barbarossapl' ],
	[ 'KBP',   'K Businesspark' ],
	[ 'KKE N', 'K Eifelt Bez II' ],
	[ 'KKE M', 'K Eifelt Bez III' ],
	[ 'KKE S', 'K Eifelt Bez IV' ],
	[ 'KKE O', 'K Eifelt Bez V' ],
	[ 'KKE F', 'K Eifeltor Emf' ],
	[ 'KKE B', 'K Eifeltor Enf' ],
	[ 'KKE K', 'K Eifeltor Esf' ],
	[ 'KKP',   'K Geldernstr/Pa' ],
	[ 'KKHRW', 'K Hansar Wendean' ],
	[ 'KKLP',  'K Klettenbergp' ],
	[ 'AKSM',  'K Seefischmarkt' ],
	[ 'KKE A', 'K.Eifeltor R12' ],
	[ 'RKAG',  'Ka Augartenstr' ],
	[ 'RKME',  'Ka Ettlinger Tor' ],
	[ 'RKSEP', 'Ka Europapl Kais' ],
	[ 'RKSEK', 'Ka Europapl Karl' ],
	[ 'RKDG',  'Ka Gottesauer Pl' ],
	[ 'RKHH',  'Ka Heizkraftwerk' ],
	[ 'RKDUH', 'Ka Hubstraße' ],
	[ 'RKIS',  'Ka Kniel Siemens' ],
	[ 'RKMK',  'Ka Kongresszentr' ],
	[ 'RKBP',  'Ka Kronenpl Kais' ],
	[ 'RKMS',  'Ka Schiller Kais' ],
	[ 'RKDUU', 'Ka Untermühlstr' ],
	[ 'RKHG',  'Ka West DB/KVVH' ],
	[ 'RKMY',  'Ka Yorckstraße' ],
	[ 'EKMB',  'Kaan-Marienborn' ],
	[ 'KKAG',  'Kaarst DB-Gr' ],
	[ 'KKAI',  'Kaarst IKEA' ],
	[ 'KKMI',  'Kaarst M/Holzb' ],
	[ 'KKAA',  'Kaarster Bahnhof' ],
	[ 'KKSE',  'Kaarster See' ],
	[ 'ZLKA',  'Kabeliai' ],
	[ 'BKAB',  'Kablow' ],
	[ 'XTKA',  'Kadan' ],
	[ 'XMKD',  'Kadarta' ],
	[ 'LKE',   'Kade' ],
	[ 'FKLP',  'Kahl (M) Privatb' ],
	[ 'FKLM',  'Kahl (Main)' ],
	[ 'FKLPK', 'Kahl Kopp/Heide' ],
	[ 'FQKL',  'Kahl(Main)BY/HE' ],
	[ 'UKA',   'Kahla (Thür)' ],
	[ 'FQKA',  'Kailbach HE/BW' ],
	[ 'XSKI',  'Kaiseraugust' ],
	[ 'EKAI',  'Kaiserberg /Du' ],
	[ 'FKBW',  'Kaiserbrücke' ],
	[ 'FQKB',  'Kaiserbrücke LGr' ],
	[ 'FKBWO', 'Kaiserbrücke Ost' ],
	[ 'SKAI',  'Kaisersesch' ],
	[ 'SKAG',  'Kaisersesch DBGr' ],
	[ 'SKL',   'Kaisersl Hbf' ],
	[ 'SKLW',  'Kaisersl. West' ],
	[ 'SKLP',  'Kaisersl.Pfaffw.' ],
	[ 'XHKJ',  'Kajaani/Kajana' ],
	[ 'XGKA',  'Kalavrita' ],
	[ 'FKAE',  'Kälberau' ],
	[ 'NKAL',  'Kalchreuth' ],
	[ 'KKAK',  'Kaldenkirchen' ],
	[ 'KXKK',  'Kaldenkirchen Gr' ],
	[ 'XFKH',  'Kalhausen' ],
	[ 'XFKHR', 'Kalhausen (RAC)' ],
	[ 'XCKG',  'Kaliningrad' ],
	[ 'XCKGD', 'Kaliningr-Dsher' ],
	[ 'ZWKL',  'Kalinkovichi' ],
	[ 'XPKL',  'Kalisz' ],
	[ 'LWEK',  'Kalkwerk I' ],
	[ 'LWEW',  'Kalkwerk II' ],
	[ 'KKAL',  'Kall' ],
	[ 'XVKB',  'Källby' ],
	[ 'XVKL',  'Kallered' ],
	[ 'XVKM',  'Kalmar C' ],
	[ 'XWKZ',  'Kalotina Zapad' ],
	[ 'XAKAL', 'Kalsdorf' ],
	[ 'WKAR',  'Kalsow' ],
	[ 'MKBN',  'Kaltenbrunn/Obb' ],
	[ 'NKCK',  'Kalteneck' ],
	[ 'AKTKS', 'Kaltenk Süd' ],
	[ 'AKTK',  'Kaltenk. (Holst)' ],
	[ 'EKAL',  'Kalthof/Iserlohn' ],
	[ 'XDKA',  'Kalundborg' ],
	[ 'XAK',   'Kalwang' ],
	[ 'XTKZ',  'Kam Zehrovice' ],
	[ 'XOKM',  'Kambo' ],
	[ 'EKAM',  'Kamen' ],
	[ 'XTKML', 'Kamenice n L' ],
	[ 'EKME',  'Kamen-Methler' ],
	[ 'XCKA',  'Kamenskaia' ],
	[ 'XCKK',  'Kamensk-Uralskii' ],
	[ 'DKA',   'Kamenz (Sachs)' ],
	[ 'LKF',   'Kämmereiforst' ],
	[ 'FKMP',  'Kamp-Bornhofen' ],
	[ 'RKMW',  'Ka-Mühlburg West' ],
	[ 'EKAN',  'Kanal/Münster' ],
	[ 'HKAN',  'Kanalbrücke' ],
	[ 'HKNH',  'Kanalhafen' ],
	[ 'XCKAN', 'Kanash' ],
	[ 'RKD',   'Kandel' ],
	[ 'RKA',   'Kandern' ],
	[ 'XSKA',  'Kandersteg' ],
	[ 'LKAN',  'Kanena' ],
	[ 'RKNEB', 'Ka-Neureut Bärwg' ],
	[ 'RKNEK', 'Ka-Neureut Kirch' ],
	[ 'XCKN',  'Kanissai' ],
	[ 'XCKM',  'Kantemirovka' ],
	[ 'SKAZ',  'Kanzem' ],
	[ 'DTON',  'Kaolinwerke Kemm' ],
	[ 'RKPD',  'Kapellen-Druswlr' ],
	[ 'RSLA',  'Kapellenstr' ],
	[ 'KKAW',  'Kapellen-Wev' ],
	[ 'LKAPC', 'Kapen Chemiewerk' ],
	[ 'XAKP',  'Kapfenberg' ],
	[ 'XQKA',  'Kapikule' ],
	[ 'XMKS',  'Kaposszekcsö' ],
	[ 'XMKA',  'Kaposvar' ],
	[ 'XMKT',  'Kaposvar-Textilm' ],
	[ 'AKPP',  'Kappeln (Schlei)' ],
	[ 'RKPP',  'Kappelrodeck' ],
	[ 'RKPO',  'Kappelrodeck Ost' ],
	[ 'RKPW',  'Kapsweyer' ],
	[ 'RXKW',  'Kapsweyer Grenze' ],
	[ 'RKDT',  'Kar Durlacher T' ],
	[ 'RKEG',  'Kar Eggenst Str' ],
	[ 'RKEF',  'Kar Entenfang' ],
	[ 'RKEH',  'Kar Händelstraße' ],
	[ 'RK A',  'Kar Hbf DB/AVG' ],
	[ 'RKMH',  'Kar Herrenstraße' ],
	[ 'RKIH',  'Kar Herweghstr' ],
	[ 'RKSL',  'Kar Lameyplatz' ],
	[ 'RKMAA', 'Kar Marktpl Abzw' ],
	[ 'RKMAK', 'Kar Marktpl Kais' ],
	[ 'RKMA',  'Kar Marktpl Pyr' ],
	[ 'RKMT',  'Kar Mühlburger T' ],
	[ 'RKEP',  'Kar Philippstr' ],
	[ 'RKAP',  'Kar Poststraße' ],
	[ 'RKSR',  'Kar Rheinbergstr' ],
	[ 'RKRR',  'Kar Rheinbr Raff' ],
	[ 'RKRA',  'Kar Rheinbr StKA' ],
	[ 'RK H',  'Kar Rheinhafen' ],
	[ 'RKSS',  'Kar Starckstraße' ],
	[ 'RK T',  'Kar Tullastraße' ],
	[ 'RKDW',  'Kar Weinweg' ],
	[ 'RKAB',  'Kar. Albtalbf.' ],
	[ 'RKV',   'Kar.Hbf Bfsvorpl' ],
	[ 'XMKKS', 'Karakoszörcsök' ],
	[ 'XWK',   'Kardam' ],
	[ 'RKDUA', 'Kar-Durlach AVG' ],
	[ 'WKGW',  'Kargow' ],
	[ 'XTKE',  'Karizek' ],
	[ 'RKIN',  'Kar-Knielingen' ],
	[ 'XRKA',  'Karlovac' ],
	[ 'XTKVD', 'Karlovy V dol.n.' ],
	[ 'XTKV',  'Karlovy Vary' ],
	[ 'XTKVV', 'Karlovy V-Dvory' ],
	[ 'RKF',   'Karlsdorf' ],
	[ 'WKH',   'Karlshagen' ],
	[ 'AKHB',  'Karlshöfen/Brm' ],
	[ 'TKAH',  'Karlshöhe' ],
	[ 'BKLH',  'Karlshorst S-B' ],
	[ 'RKSE',  'Karlsr Europapl' ],
	[ 'RK G',  'Karlsr Geroldsä.' ],
	[ 'RK R',  'Karlsr Reitschul' ],
	[ 'RKRH',  'Karlsr Rheinbr' ],
	[ 'RKDU',  'Karlsr-Durlach' ],
	[ 'RKHA',  'Karlsr-Hagsfeld' ],
	[ 'RKR',   'Karlsruhe Gbf' ],
	[ 'RKHF',  'Karlsruhe Hafen' ],
	[ 'RK',    'Karlsruhe Hbf' ],
	[ 'RKUW',  'Karlsruhe Unterw' ],
	[ 'RKW',   'Karlsruhe West' ],
	[ 'LKRS',  'Karlsruher Str' ],
	[ 'NKA',   'Karlstadt (Main)' ],
	[ 'RKMG',  'Kar-Mühlburg' ],
	[ 'WKA',   'Karow (Meckl)' ],
	[ 'WKAZ',  'Karow(Meckl)Saat' ],
	[ 'YBBAK', 'Karower Kr Strw' ],
	[ 'ZUKA',  'Karpaty' ],
	[ 'MKH',   'Karpfham' ],
	[ 'ZTK',   'Karsava' ],
	[ 'UKF',   'Karsdorf' ],
	[ 'UKF B', 'Karsdorf Bahnstg' ],
	[ 'UKFP',  'Karsdorf Zementw' ],
	[ 'WKT',   'Karstädt' ],
	[ 'XCKT',  'Kartaly 1' ],
	[ 'SKU B', 'Karth Moselbr' ],
	[ 'SKU W', 'Karth W/Konz M' ],
	[ 'SKU',   'Karthaus' ],
	[ 'SKU M', 'Karthaus Mitte' ],
	[ 'SKU O', 'Karthaus NO' ],
	[ 'SKU N', 'Karthaus NW' ],
	[ 'XTKD',  'Karvina hl n' ],
	[ 'XWKS',  'Kaspichan' ],
	[ 'FK',    'Kassel Hbf' ],
	[ 'FKKVG', 'Kassel Hbf KVG' ],
	[ 'FK I',  'Kassel Mitte' ],
	[ 'FKR',   'Kassel Rbf' ],
	[ 'FKRB',  'Kassel Rbf Berg' ],
	[ 'FKR N', 'Kassel Rbf Nord' ],
	[ 'FKR S', 'Kassel Rbf Süd' ],
	[ 'FKR T', 'Kassel Rbf Tal' ],
	[ 'FKWK',  'Kassel Werkekr' ],
	[ 'EPDK',  'Kasseler Tor' ],
	[ 'FKOA',  'Kassel-Oberzw A' ],
	[ 'FKWAI', 'Kassel-W Ind-gl' ],
	[ 'FKWA',  'Kassel-Waldau' ],
	[ 'MKAT',  'Kastl/Obb' ],
	[ 'XGK',   'Katerini' ],
	[ 'AKAD',  'Katharinenheerd' ],
	[ 'AKTO',  'Kating' ],
	[ 'HKAT',  'Katlenburg' ],
	[ 'XPKAL', 'Katowice Ligota' ],
	[ 'XPKA',  'Katowice Osobowa' ],
	[ 'XVK',   'Katrineholm' ],
	[ 'FKAT',  'Kattenbühl' ],
	[ 'SKTS',  'Kattenes' ],
	[ 'EKV',   'Kattenvenne' ],
	[ 'XPKWR', 'Katy Wroclaw' ],
	[ 'FKFT',  'Katzenfurt' ],
	[ 'SDLK',  'Katzenschwänz' ],
	[ 'UKH',   'Katzhütte' ],
	[ 'NKG',   'Katzwang' ],
	[ 'SKW',   'Katzweiler' ],
	[ 'FKAU',  'Kaub' ],
	[ 'MKFB',  'Kaufbeuren' ],
	[ 'MKFG',  'Kaufering' ],
	[ 'XHK',   'Kauhava' ],
	[ 'UKLD',  'Kaulsdorf Awanst' ],
	[ 'BKAD',  'Kaulsdorf S-B' ],
	[ 'UKL',   'Kaulsdorf(Saale)' ],
	[ 'EKNZ',  'Kaunitz' ],
	[ 'XLKT',  'Kautenbach' ],
	[ 'EKAU',  'Kautex' ],
	[ 'WKV',   'Kavelstorf' ],
	[ 'HKHF',  'Kayhauserfeld' ],
	[ 'XLKA',  'Kayl' ],
	[ 'XCKZ',  'Kazan' ],
	[ 'ZUKP',  'Kazatin-Pass' ],
	[ 'XMKZ',  'Kazincbarcika' ],
	[ 'KKBI',  'K-Bickendorf' ],
	[ 'KKBL',  'K-Blumenberg' ],
	[ 'BKBO',  'K-Bonhoeffer-Nkl' ],
	[ 'KKCN',  'K-Chorw Nord' ],
	[ 'KKC',   'K-Chorweiler' ],
	[ 'XMKEC', 'Kecskemet' ],
	[ 'XMKEA', 'Kecskemet Also' ],
	[ 'XMKEM', 'Kecskemet-Maria' ],
	[ 'XPKE',  'Kedzierzyn Kozle' ],
	[ 'RKL',   'Kehl' ],
	[ 'RXKL',  'Kehl Grenze' ],
	[ 'TKEH',  'Kehlen' ],
	[ 'XSKH',  'Kehlhof' ],
	[ 'KKEG',  'K-Ehrenf DB-Gr' ],
	[ 'KKERW', 'K-Ehrenf Gbf Wk' ],
	[ 'KKERP', 'K-Ehrenf Pbf' ],
	[ 'KKERG', 'K-Ehrenfeld Gbf' ],
	[ 'FKEI',  'Keilsberg' ],
	[ 'AKI',   'Keitum' ],
	[ 'XMK',   'Kelebia' ],
	[ 'XMBL',  'Kelenföld' ],
	[ 'NKH',   'Kelheim' ],
	[ 'FKE',   'Kelkheim' ],
	[ 'FKHO',  'Kelkheim-Hornau' ],
	[ 'FKEM',  'Kelkheim-Münster' ],
	[ 'MKMZ',  'Kellmünz' ],
	[ 'FKCH',  'Kelsterbach' ],
	[ 'XAKM',  'Kematen/Tirol' ],
	[ 'XMKMH', 'Kemenesmihalyfa' ],
	[ 'DKEM',  'Kemmlitz Bf' ],
	[ 'NKNN',  'Kemnath-Neustadt' ],
	[ 'KKEM',  'Kempen (Ndrh)' ],
	[ 'MKP',   'Kempten (A) Hbf' ],
	[ 'MKPO',  'Kempten (A) Ost' ],
	[ 'DKAU',  'Kemtau' ],
	[ 'SKEN',  'Kennelgarten' ],
	[ 'WKEN',  'Kenz' ],
	[ 'RKN',   'Kenzingen' ],
	[ 'FKB',   'Kerkerbach' ],
	[ 'BKE',   'Kerkwitz' ],
	[ 'MAKI',  'Kernkraftw Isar' ],
	[ 'NKCH',  'Kersbach' ],
	[ 'XMKE',  'Kerta' ],
	[ 'KKES',  'Kesselheim' ],
	[ 'XSKW',  'Kesswil' ],
	[ 'XNKE',  'Kesteren' ],
	[ 'FKES',  'Kestert' ],
	[ 'XMKG',  'Keszöhidegkut-G' ],
	[ 'XMKY',  'Keszthely' ],
	[ 'XMKH',  'Ketegyhaza' ],
	[ 'XMKP',  'Ketpo' ],
	[ 'XPKET', 'Ketrzyn' ],
	[ 'EKG',   'Kettwig' ],
	[ 'EKGS',  'Kettwig Stausee' ],
	[ 'LKET',  'Ketzin' ],
	[ 'KKEV',  'Kevelaer' ],
	[ 'AKH',   'K-Hassee Cittip' ],
	[ 'XDKI',  'Kibaek' ],
	[ 'ZLKI',  'Kibartai' ],
	[ 'ZUKC',  'Kicman' ],
	[ 'TKBI',  'Kiebingen' ],
	[ 'UKIE',  'Kiebitzhöhe' ],
	[ 'MKI',   'Kiefersfelden' ],
	[ 'BKB',   'Kiekebusch b Cs' ],
	[ 'AK',    'Kiel Hbf' ],
	[ 'AK O',  'Kiel Hbf (Ko)' ],
	[ 'AKSS',  'Kiel Hbf (Ss)' ],
	[ 'AKHW',  'Kiel How.-werke' ],
	[ 'AKMA',  'Kiel M.-arsenal' ],
	[ 'AKNH',  'Kiel Nordhafen' ],
	[ 'AKNK',  'Kiel Norwegenkai' ],
	[ 'AKOH',  'Kiel Ostuferhf' ],
	[ 'AKSL',  'Kiel S a Langsee' ],
	[ 'AKSC',  'Kiel Scheerhafen' ],
	[ 'AKSU',  'Kiel Süd' ],
	[ 'AKSA',  'Kiel Süd (Ss)' ],
	[ 'AKSG',  'Kiel Süd Grenze' ],
	[ 'AKE',   'Kiel-Elmschenhgn' ],
	[ 'AKGA',  'Kiel-Gaarden' ],
	[ 'AKRU',  'Kiel-Russee' ],
	[ 'AKWD',  'Kiel-Wellingdorf' ],
	[ 'AKEW',  'Kiel-Wellsee' ],
	[ 'AKWK',  'Kiel-Wik' ],
	[ 'BAKB',  'Kienberg' ],
	[ 'KKIE',  'Kierberg' ],
	[ 'ZUK',   'Kiev-Passajirsk' ],
	[ 'TKTO',  'Kihm(T)-Ötlingen' ],
	[ 'XNK',   'Kijfhoek' ],
	[ 'XNKN',  'Kijfhoek Noord' ],
	[ 'XNKD',  'Kijfhoek Zuid' ],
	[ 'TKC',   'Kilchberg' ],
	[ 'XSKB',  'Kilchberg' ],
	[ 'XGKK',  'Kilkis' ],
	[ 'TKLR',  'Killer' ],
	[ 'XSKS',  'Killwangen-S' ],
	[ 'FWKI',  'Kimm' ],
	[ 'XAKB',  'Kindberg' ],
	[ 'MKIG',  'Kinding' ],
	[ 'SKIB',  'Kindsbach' ],
	[ 'XBK',   'Kinkempois' ],
	[ 'XVKN',  'Kinna' ],
	[ 'XVKR',  'Kinnared' ],
	[ 'MKIN',  'Kinsau' ],
	[ 'FKIZ',  'Kinzenberg' ],
	[ 'FKGS',  'Kirch Göns' ],
	[ 'WKJ',   'Kirch Jesar' ],
	[ 'MKAG',  'Kirchanschöring' ],
	[ 'TKIM',  'Kirchberg (Murr)' ],
	[ 'XAKG',  'Kirchberg i.T.' ],
	[ 'KKIB',  'Kirchbg.(Jülich)' ],
	[ 'XAKL',  'Kirchbichl' ],
	[ 'FKKD',  'Kirchditmold' ],
	[ 'RMBK',  'Kirchdorf' ],
	[ 'HKDF',  'Kirchdorf/Deist.' ],
	[ 'NKIR',  'Kirchehrenbach' ],
	[ 'EKIR',  'Kirchen' ],
	[ 'NKL',   'Kirchenlaibach' ],
	[ 'NKO',   'Kirchenlamitz O' ],
	[ 'TKI',   'Kirchentellinsf' ],
	[ 'FKBHG', 'Kirchgasse' ],
	[ 'FKIH',  'Kirchh (Bz Ksl)' ],
	[ 'TKMA',  'Kirchh Cronimet' ],
	[ 'HKHW',  'Kirchhammelward' ],
	[ 'FKHM',  'Kirchheim' ],
	[ 'TKM',   'Kirchheim (N)' ],
	[ 'TKT',   'Kirchheim (Teck)' ],
	[ 'RKH',   'Kirchheim (Wstr)' ],
	[ 'TKTS',  'Kirchheim(T)Süd' ],
	[ 'TKU',   'Kirchheim/Untfr' ],
	[ 'FKIR',  'Kirchheimbola' ],
	[ 'FKHA',  'Kirchhmbo Hartst' ],
	[ 'HKHN',  'Kirchhorsten' ],
	[ 'EKHU',  'Kirchhundem' ],
	[ 'HKLG',  'Kirchlengern' ],
	[ 'LKIM',  'Kirchmöser' ],
	[ 'UKI',   'Kirchscheidungen' ],
	[ 'HKSE',  'Kirchseelte' ],
	[ 'MKO',   'Kirchseeon' ],
	[ 'MKO H', 'Kirchseeon Hp' ],
	[ 'MKW',   'Kirchweidach' ],
	[ 'HKI',   'Kirchweyhe' ],
	[ 'HKIN',  'Kirchweyhe Nord' ],
	[ 'RKZ',   'Kirchzarten' ],
	[ 'SKI',   'Kirkel' ],
	[ 'SKR',   'Kirn' ],
	[ 'RKIR',  'Kirnbach' ],
	[ 'RKBG',  'Kirnbach-Grün' ],
	[ 'SKRS',  'Kirnsulzbach' ],
	[ 'XCK',   'Kirov Pass' ],
	[ 'ZUKI',  'Kirovograd' ],
	[ 'XCKI',  'Kirsanov' ],
	[ 'RKBV',  'Kirschbaumwasen' ],
	[ 'ALRK',  'Kirschenallee' ],
	[ 'XVKS',  'Kisa' ],
	[ 'XMKI',  'Kisber' ],
	[ 'XMKC',  'Kisceripuszta' ],
	[ 'XMKU',  'Kiskunfelegyhaza' ],
	[ 'XMKM',  'Kiskunmajsa' ],
	[ 'XMKPP', 'Kislippo' ],
	[ 'MKIS',  'Kissing' ],
	[ 'TKG',   'Kißlegg' ],
	[ 'XMKV',  'Kisvarda' ],
	[ 'XAKIT', 'Kittsee' ],
	[ 'XAKIH', 'Kitz / Hahnenk' ],
	[ 'XAKI',  'Kitzbühel' ],
	[ 'NKN',   'Kitzingen' ],
	[ 'NKNE',  'Kitzingen-Etwas' ],
	[ 'ZUKV',  'Kivercy' ],
	[ 'XOKE',  'Kjelsas' ],
	[ 'XDKJ',  'Kjersing' ],
	[ 'XOKO',  'Kjose' ],
	[ 'KKANO', 'K-Kalk Nd Bez I' ],
	[ 'KKANP', 'K-Kalk Nd Bez IV' ],
	[ 'KKANR', 'K-Kalk Nd BezIII' ],
	[ 'KKANE', 'K-Kalk Nord Einf' ],
	[ 'KKANM', 'K-Kalk Nord Km' ],
	[ 'KKANN', 'K-Kalk Nord Knf' ],
	[ 'KKANS', 'K-Kalk Nord Ksf' ],
	[ 'KKANW', 'K-Kalk Nord Kw' ],
	[ 'KKLM',  'Kl Marienthal' ],
	[ 'HEBA',  'Kl Wanzl Saatz' ],
	[ 'WQKW',  'Kl Warnow LGr' ],
	[ 'LKD',   'Kläden (Kr Stl)' ],
	[ 'LKDN',  'Kläden b Arends' ],
	[ 'LKD H', 'Kläden Bstg' ],
	[ 'XTKL',  'Kladno' ],
	[ 'DNK K', 'Klaffenbach Hp' ],
	[ 'TKLA',  'Klaffenbach-Alth' ],
	[ 'XAKT',  'Klagenfurt Hbf' ],
	[ 'ZLKL',  'Klaipeda' ],
	[ 'MKLA',  'Klais' ],
	[ 'BKLD',  'Klandorf' ],
	[ 'AKX',   'Klanxbüll' ],
	[ 'NKDF',  'Klardorf' ],
	[ 'BKDF',  'Klasdorf' ],
	[ 'XTKN',  'Klasterec n Ohri' ],
	[ 'XTKY',  'Klatovy' ],
	[ 'LKBZ',  'Klebitz' ],
	[ 'AKC',   'Klecken' ],
	[ 'XAKE',  'Kledering' ],
	[ 'WKLE',  'Kleeth' ],
	[ 'FKAH',  'Klein Auheim' ],
	[ 'WKB',   'Klein Bünzow' ],
	[ 'AFB',   'Klein Flottbek' ],
	[ 'LKLR',  'Klein Rössen' ],
	[ 'XAKS',  'Klein Schwechat' ],
	[ 'HKSU',  'Klein Süstedt' ],
	[ 'FKLU',  'Klein Umstadt' ],
	[ 'WKWA',  'Klein Warnow' ],
	[ 'MKHN',  'Kleinberghofen' ],
	[ 'XLKB',  'Kleinbettingen' ],
	[ 'SKB',   'Kleinblittersd' ],
	[ 'HKBR',  'Kleinenbremen' ],
	[ 'KKLE',  'Kleinenbroich' ],
	[ 'HKSI',  'Kleinensiel' ],
	[ 'MAKD',  'Kleiner/Mindelh' ],
	[ 'UKFA',  'Kleinfurra' ],
	[ 'NKGM',  'Kleingemünden' ],
	[ 'FKGE',  'Klein-Gerau' ],
	[ 'TKGB',  'Kleinglattbach' ],
	[ 'NKLH',  'Kleinheubach' ],
	[ 'UKJ',   'Kleinjena' ],
	[ 'RKEU',  'Kleinkems' ],
	[ 'RKES',  'Kleinkems Hp' ],
	[ 'MKKZ',  'Kleinkötz' ],
	[ 'NKLL',  'Kleinlangheim' ],
	[ 'FKO',   'Kleinostheim' ],
	[ 'DKRD',  'Kleinröhrsdorf' ],
	[ 'DKMA',  'Kleinschirma' ],
	[ 'RKBA',  'Kleinsteinbach' ],
	[ 'NKT',   'Kleinwallstadt' ],
	[ 'RKLN',  'Klengen' ],
	[ 'TKPS',  'Klepsau' ],
	[ 'KKLV',  'Kleve' ],
	[ 'XVKV',  'Klevshult' ],
	[ 'EDKL',  'Kley /Üst Do' ],
	[ 'FKY',   'Kleyerstraße' ],
	[ 'LKK',   'Klieken' ],
	[ 'BKG',   'Klinge' ],
	[ 'DKC',   'Klingenb-Colmn' ],
	[ 'NKM',   'Klingenberg' ],
	[ 'NKNB',  'Klingenbrunn' ],
	[ 'DKN',   'Klingenthal' ],
	[ 'DXK',   'Klingenthal Gr' ],
	[ 'HBKM',  'Klinik Brm-Nord' ],
	[ 'KWEK',  'Klinkum' ],
	[ 'LKLM',  'Klitschmar' ],
	[ 'BKL',   'Klitten' ],
	[ 'LKLI',  'Klitzschen' ],
	[ 'XPKLO', 'Klobuczyn' ],
	[ 'EKKR',  'Klöckn Rohstoffh' ],
	[ 'XRKL',  'Klostar' ],
	[ 'HKOE',  'Kloster Oesede' ],
	[ 'DKLB',  'Klosterbuch' ],
	[ 'BKLF',  'Klosterfelde' ],
	[ 'WKLH',  'Klosterheide (M)' ],
	[ 'MKLF',  'Klosterlechfeld' ],
	[ 'LKM',   'Klostermansfeld' ],
	[ 'LKMR',  'Klostermf Rands' ],
	[ 'RKLB',  'Klosterreichenb.' ],
	[ 'XSKT',  'Kloten' ],
	[ 'SKT',   'Klotten' ],
	[ 'XPKLB', 'Kluczbork' ],
	[ 'EKLU',  'Klusenstein' ],
	[ 'FKWO',  'Kl-Winternh-Ob-O' ],
	[ 'YMMOL', 'km 3,6/6,8 (MOL)' ],
	[ 'EKM',   'KM Europa Metall' ],
	[ 'KKM',   'K-Mülheim' ],
	[ 'KKM G', 'K-Mülheim Gbf' ],
	[ 'KKM A', 'K-Mülheim Ostk' ],
	[ 'KKM B', 'K-Mülheim Westk' ],
	[ 'XVKD',  'Knalleland' ],
	[ 'BKN',   'Knappenrode' ],
	[ 'TRKN',  'Knauf' ],
	[ 'LKNF',  'Knautnaundorf' ],
	[ 'HKNE',  'Knesebeck' ],
	[ 'RKIA',  'Knieling DB/AVG' ],
	[ 'RKID',  'Knielingen Endst' ],
	[ 'XRK',   'Knin' ],
	[ 'KKN B', 'K-Nippes Bez 1' ],
	[ 'KKN G', 'K-Nippes Bez 4' ],
	[ 'KKN E', 'K-Nippes Etzelst' ],
	[ 'KKN F', 'K-Nippes Nf' ],
	[ 'KKN W', 'K-Nippes Wendean' ],
	[ 'XAKF',  'Knittelfeld' ],
	[ 'TKNK',  'Knittl-Kleinvill' ],
	[ 'RKG',   'Knöringen-Essing' ],
	[ 'XAKH',  'Knoten Hadersdf' ],
	[ 'XAPKR', 'Knoten Rohr' ],
	[ 'XAPKW', 'Knoten Wagram' ],
	[ 'XPKNU', 'Knurow' ],
	[ 'KKOM',  'Ko Mosel Gbf' ],
	[ 'BKW',   'Kö Wusterh' ],
	[ 'XMKF',  'Köbanya felsö' ],
	[ 'XMKK',  'Köbanya-Kispest' ],
	[ 'SKG',   'Kobern-Gondorf' ],
	[ 'XSKO',  'Koblenz CH' ],
	[ 'KKO',   'Koblenz Hbf' ],
	[ 'SGS',   'Koblenz-Güls' ],
	[ 'MKCH',  'Kochel' ],
	[ 'TBKA',  'Kochendorf Audi' ],
	[ 'TKDN',  'Kochendorf Nord' ],
	[ 'TKSF',  'Kochersteinsfeld' ],
	[ 'TKTN',  'Kochertürn' ],
	[ 'XVKO',  'Kode' ],
	[ 'BKSB',  'Kodersd Sandberg' ],
	[ 'BKOD',  'Kodersdorf' ],
	[ 'NKI',   'Köditz' ],
	[ 'ZUKD',  'Kodyma' ],
	[ 'XDKHD', 'Koeb Helgoland' ],
	[ 'XDKH',  'Koebenhavn H' ],
	[ 'XDKHF', 'Koebenhv Frihavn' ],
	[ 'XDKHH', 'Koebenhv Havnega' ],
	[ 'XDKHL', 'Koebenhvs Lufthv' ],
	[ 'XDKT',  'Koebenhv-Taarnby' ],
	[ 'XDKG',  'Koege' ],
	[ 'KKOE',  'Ko-Ehrenbreitst' ],
	[ 'NKOE',  'Köfering' ],
	[ 'RKOF',  'Ko-Fürstenberg' ],
	[ 'XFKO',  'Kogenheim' ],
	[ 'HKBS',  'Kohlenbissen' ],
	[ 'KKOS',  'Kohlscheid' ],
	[ 'TKOS',  'Kohlstetten' ],
	[ 'XPKOL', 'Kolbaskowo' ],
	[ 'MKMR',  'Kolbermoor' ],
	[ 'XAKO',  'Kolbnitz' ],
	[ 'XCKO',  'Kolcovo' ],
	[ 'XDKO',  'Kolding' ],
	[ 'XTKI',  'Kolin' ],
	[ 'XCKL',  'Koliutkino' ],
	[ 'EKOL',  'Kolkmannshof' ],
	[ 'BKOW',  'Kolkwitz' ],
	[ 'BKOS',  'Kolkwitz Süd' ],
	[ 'UKOE',  'Kölleda' ],
	[ 'RKLR',  'Kollmarsreute' ],
	[ 'RKNA',  'Kollnau' ],
	[ 'BKHD',  'Köllnische Heide' ],
	[ 'KKB',   'Köln Bbf' ],
	[ 'KKBT',  'Köln Bonntor' ],
	[ 'KKD',   'Köln Deutzerfeld' ],
	[ 'KKE',   'Köln Eifeltor' ],
	[ 'KKHA',  'Köln Hafen' ],
	[ 'KKHR',  'Köln Hansaring' ],
	[ 'KK',    'Köln Hbf' ],
	[ 'KKDZ',  'Köln Messe/Deutz' ],
	[ 'KKDZB', 'Köln Messe/Dz Hp' ],
	[ 'KKDT',  'Köln Messe/Dz(t)' ],
	[ 'KSTA',  'Köln Steinstr A' ],
	[ 'KSTP',  'Köln Steinstr Hp' ],
	[ 'KKS',   'Köln Süd' ],
	[ 'KKSA',  'Köln Süd Abzw' ],
	[ 'KKW',   'Köln West' ],
	[ 'KKW F', 'Köln West Wf' ],
	[ 'KKW S', 'Köln West Ws' ],
	[ 'KFKB',  'Köln/Bonn Flughf' ],
	[ 'KKBH',  'Köln-Buchforst' ],
	[ 'KKBU',  'Köln-Butzweiler' ],
	[ 'KKDB',  'Köln-Dellbrück' ],
	[ 'KDZH',  'Köln-Deutz Hafen' ],
	[ 'KKER',  'Köln-Ehrenfeld' ],
	[ 'KKFT',  'Köln-Flittard' ],
	[ 'KGOF',  'Köln-Godorf' ],
	[ 'KKGH',  'Köln-Godorf Haf' ],
	[ 'KGOH',  'Köln-Godorf Hf D' ],
	[ 'KKGS',  'Köln-GodorfShell' ],
	[ 'KKH',   'Köln-Holweide' ],
	[ 'KKA',   'Köln-Kalk' ],
	[ 'KKAN',  'Köln-Kalk Nord' ],
	[ 'KKL',   'Köln-Longerich' ],
	[ 'KLOV',  'Köln-Lövenich' ],
	[ 'KLO',   'Köln-Lövenich Hp' ],
	[ 'KKMG',  'Köln-Mülheim Gr' ],
	[ 'KKNI',  'Köln-Niehl' ],
	[ 'KKNF',  'Köln-Niehl Ford' ],
	[ 'KKNH',  'Köln-Niehl Hafen' ],
	[ 'KKN',   'Köln-Nippes' ],
	[ 'KKNA',  'Köln-Nippes Abzw' ],
	[ 'KKN P', 'Köln-Nippes Pbf' ],
	[ 'YKKEZ', 'Köln-Nippes Strw' ],
	[ 'KKST',  'Köln-Stammhm NE' ],
	[ 'KKWO',  'Köln-Worringen' ],
	[ 'XPKOO', 'Kolo' ],
	[ 'XPKOB', 'Kolobrzeg' ],
	[ 'XMKL',  'Kolontar' ],
	[ 'WKP',   'Kölpinsee' ],
	[ 'KKOL',  'Ko-Lützel' ],
	[ 'KKOLM', 'Ko-Lützel Mitte' ],
	[ 'KKOLN', 'Ko-Lützel Nord' ],
	[ 'XPKK',  'Koluszki' ],
	[ 'XYKO',  'Komarno' ],
	[ 'XMKO',  'Komarom' ],
	[ 'SKOW',  'Ko-Moselweiß' ],
	[ 'RKOE',  'Köndringen' ],
	[ 'XOKB',  'Kongsberg' ],
	[ 'XOKN',  'Kongsvinger' ],
	[ 'XOKL',  'Kongsvoll' ],
	[ 'KKOB',  'Königsb (Kobl)' ],
	[ 'TKB',   'Königsbach/Baden' ],
	[ 'LKB',   'Königsborn' ],
	[ 'TKS',   'Königsbronn' ],
	[ 'DKB',   'Königsbrück' ],
	[ 'HKBA',  'Königsbühl' ],
	[ 'RKHS',  'Königschaffhaus.' ],
	[ 'FKHN',  'Königshofen' ],
	[ 'TKF',   'Königshofen (Bd)' ],
	[ 'HKOL',  'Königslutter' ],
	[ 'FKKPL', 'Königsplatz' ],
	[ 'EKSO',  'Königsstollen' ],
	[ 'DKOU',  'Königst (Sä) Üst' ],
	[ 'FKOE',  'Königstein (Ts)' ],
	[ 'DKOH',  'Königstein Hp' ],
	[ 'AKS',   'Königstraße' ],
	[ 'KKOW',  'Königswinter' ],
	[ 'XPKN',  'Konin' ],
	[ 'UKZ',   'Könitz (Thür)' ],
	[ 'ZBKC',  'Konjic' ],
	[ 'XRKJ',  'Konjscina' ],
	[ 'LKO',   'Könnern' ],
	[ 'ZUKT',  'Konotop' ],
	[ 'RKO',   'Konstanz' ],
	[ 'XSKZ',  'Konstanz CH' ],
	[ 'RQK',   'Konstanz 4000' ],
	[ 'RQKR',  'Konstanz 4322' ],
	[ 'RXKZ',  'Konstanz Gr' ],
	[ 'RXKR',  'Konstanz Gr Roma' ],
	[ 'SKZ',   'Konz' ],
	[ 'SKZK',  'Konz Kuag' ],
	[ 'XNKB',  'Koog Bloemwijk' ],
	[ 'XNKZ',  'Koog-Zaandijk' ],
	[ 'XZKL',  'Koper Luka' ],
	[ 'XZK',   'Koper Tovorna' ],
	[ 'RKOP',  'Ko-Petershausen' ],
	[ 'KPFD',  'Ko-Pfaffendorf' ],
	[ 'XOKG',  'Koppang' ],
	[ 'XOKP',  'Koppera' ],
	[ 'FKP',   'Köppern' ],
	[ 'FKOB',  'Korbach' ],
	[ 'FKOBI', 'Korbach Ind-Stgl' ],
	[ 'FKBS',  'Korbach Süd' ],
	[ 'SKDL',  'Kordel' ],
	[ 'XTKOV', 'Korenov' ],
	[ 'XTKOZ', 'Korenov zastavka' ],
	[ 'ZUKOK', 'Koristovka' ],
	[ 'RKOR',  'Kork' ],
	[ 'FKRL',  'Körle' ],
	[ 'FKOT',  'Körle Ost' ],
	[ 'XMKR',  'Körmend' ],
	[ 'EKRN',  'Körne' ],
	[ 'XOKJ',  'Kornsjo' ],
	[ 'TKO',   'Korntal' ],
	[ 'TKO E', 'Korntal Em WEG' ],
	[ 'TKO G', 'Korntal Gymnas' ],
	[ 'AKWS',  'Kornweg' ],
	[ 'TK N',  'Kornwesth Rbf NO' ],
	[ 'TK W',  'Kornwesth Rbf NW' ],
	[ 'TK O',  'Kornwesth Rbf SO' ],
	[ 'TK S',  'Kornwesth Rbf SW' ],
	[ 'TKH',   'Kornwestheim Pbf' ],
	[ 'TK',    'Kornwestheim Rbf' ],
	[ 'TK A',  'Kornwst Salzweg' ],
	[ 'ZUKN',  'Korosten' ],
	[ 'KKOI',  'Korschenbroich' ],
	[ 'XDKS',  'Korsoer' ],
	[ 'ZUKS',  'Korsun' ],
	[ 'ZUKSS', 'Korsun-Sevcenkiv' ],
	[ 'XPKS',  'Korsze' ],
	[ 'XBKO',  'Kortenberg' ],
	[ 'XBKK',  'Kortrijk' ],
	[ 'XQKY',  'Köseköy' ],
	[ 'WKO',   'Koserow' ],
	[ 'XYK',   'Kosice' ],
	[ 'KKSL',  'Koslar (Jülich)' ],
	[ 'XJKO',  'Kosovo Polje' ],
	[ 'KKSM',  'Ko-Stadtmitte' ],
	[ 'XRKS',  'Kostajnica' ],
	[ 'XTKS',  'Kostalov' ],
	[ 'FKOS',  'Kostheim' ],
	[ 'FKOO',  'Kostheim Ost' ],
	[ 'XPK',   'Kostrzyn' ],
	[ 'XPKOS', 'Kostrzyn Osob' ],
	[ 'XPKTO', 'Kostrzyn Tow' ],
	[ 'XPKW',  'Kostrzyn Wielkop' ],
	[ 'XPKO',  'Koszalin' ],
	[ 'LK',    'Köthen' ],
	[ 'LKTG',  'Köthen DB-Grenze' ],
	[ 'LK B',  'Köthen Stw B 4' ],
	[ 'LK C',  'Köthen Stw B 6' ],
	[ 'LK D',  'Köthen Stw W 3' ],
	[ 'LK R',  'Köthen Stw W 7' ],
	[ 'NKMG',  'Kothmaißling' ],
	[ 'ZUKK',  'Kotovsk' ],
	[ 'XOKY',  'Kotsoy' ],
	[ 'KKOF',  'Kottenforst' ],
	[ 'KKOH',  'Kottenheim' ],
	[ 'DKOT',  'Kottewitz' ],
	[ 'DKTW',  'Köttewitz' ],
	[ 'LKTU',  'Kötzschau' ],
	[ 'XTKU',  'Kounov' ],
	[ 'XTKO',  'Kovarska' ],
	[ 'ZUKO',  'Kovel' ],
	[ 'SKV',   'Kövenig' ],
	[ 'RKOW',  'Ko-Wollmatingen' ],
	[ 'UKR',   'Kraftsdorf' ],
	[ 'BFIK',  'Kraftw Finkenh' ],
	[ 'EEZK',  'Krages' ],
	[ 'EKRG',  'Kraghammer' ],
	[ 'XJKR',  'Kragujevac' ],
	[ 'LKRE',  'Krahne' ],
	[ 'RKT',   'Kraichtal' ],
	[ 'XPKR',  'Krakow Gl Osob' ],
	[ 'XPKNH', 'Krakow Nowa Huta' ],
	[ 'XJKL',  'Kraljevo' ],
	[ 'XYKA',  'Kralovany' ],
	[ 'XTKRP', 'Kralovske Porici' ],
	[ 'XTKR',  'Kralupy n.Vl.' ],
	[ 'ZUKM',  'Kramatorsk' ],
	[ 'XAKA',  'Kranebitten' ],
	[ 'UKD',   'Kranichfeld' ],
	[ 'XZKJ',  'Kranj' ],
	[ 'HKHG',  'Krankenhagen' ],
	[ 'XTKC',  'Kraslice' ],
	[ 'XTKP',  'Kraslice p Vlek' ],
	[ 'XTKCP', 'Kraslice Predm' ],
	[ 'XTKCS', 'Kraslice stred' ],
	[ 'XTKLP', 'Krasna Lipa' ],
	[ 'XTKLM', 'Krasna Lipa mest' ],
	[ 'ZUKR',  'Krasne' ],
	[ 'XCKD',  'Krasnodar' ],
	[ 'XCKR',  'Krasnoje RU' ],
	[ 'ZUKL',  'Krasnyi Liman' ],
	[ 'WKG',   'Kratzeburg' ],
	[ 'RKRS',  'Krauchenwies' ],
	[ 'UKW',   'Krauschwitz b Te' ],
	[ 'KNKR',  'Krauthausen' ],
	[ 'TKTH',  'Krautheim/Jagst' ],
	[ 'XTK',   'Krec' ],
	[ 'EKRD',  'Kredenbach' ],
	[ 'KKR',   'Krefeld Hbf' ],
	[ 'KKFN',  'Krefeld Nord' ],
	[ 'KKRH',  'Krefeld Ost Hf' ],
	[ 'KKRD',  'Krefeld Süd' ],
	[ 'KKRI',  'Krefeld-Inrath' ],
	[ 'KKRL',  'Krefeld-Linn' ],
	[ 'KKRO',  'Krefeld-Oppum' ],
	[ 'HK',    'Kreiensen' ],
	[ 'SKRB',  'Kreimbach-Kaulb' ],
	[ 'ZUKG',  'Kremenchug' ],
	[ 'BKRM',  'Kremmen' ],
	[ 'AKM',   'Krempe' ],
	[ 'AKHD',  'Kremperheide' ],
	[ 'XAKD',  'Krems(Donau)' ],
	[ 'XAKRM', 'Kremsmünster Mkt' ],
	[ 'LKNZ',  'Krensitz' ],
	[ 'TKN',   'Kressbronn' ],
	[ 'TQKN',  'Kressbronn BW/BY' ],
	[ 'SKK',   'Kreuz Konz' ],
	[ 'KKUZ',  'Kreuzau' ],
	[ 'KKUZE', 'Kreuzau Eifelstr' ],
	[ 'KKRZ',  'Kreuzberg (Ahr)' ],
	[ 'MKZB',  'Kreuzeckbahn' ],
	[ 'WKZ',   'Kreuzkrug' ],
	[ 'XSKRB', 'Kreuzl.Bernrain' ],
	[ 'XSKR',  'Kreuzlingen' ],
	[ 'XSKL',  'Kreuzlingen Haf.' ],
	[ 'MKZ',   'Kreuzstraße' ],
	[ 'EKT',   'Kreuztal' ],
	[ 'EKT G', 'Kreuztal Gbf' ],
	[ 'ELTF',  'Kreuzt-Littfeld' ],
	[ 'KKRW',  'Kreuzweingarten' ],
	[ 'KHB',   'Kr-Hobu Chempark' ],
	[ 'KKRK',  'Kriba' ],
	[ 'XAKK',  'Krichdorf a d Kr' ],
	[ 'XAKY',  'Krift' ],
	[ 'FKRI',  'Kriftel' ],
	[ 'XFKM',  'Krimmeri-Meinau' ],
	[ 'XTKM',  'Krimov' ],
	[ 'DKRP',  'Krippen' ],
	[ 'XOKS',  'Kristiansand' ],
	[ 'XRKI',  'Krizevci' ],
	[ 'UKPR',  'Krölpa-Ranis' ],
	[ 'XNKA',  'Krommenie-As' ],
	[ 'NK',    'Kronach' ],
	[ 'NKMU',  'Kronach Müll' ],
	[ 'FKRO',  'Kronberg (Ts)' ],
	[ 'FKRS',  'Kronberg Süd' ],
	[ 'EKSP',  'Kronospan' ],
	[ 'AKRH',  'Kronshagen' ],
	[ 'WKRP',  'Kronskamp' ],
	[ 'SKRO',  'Kronweiler' ],
	[ 'WKR',   'Kröpelin' ],
	[ 'XNKR',  'Kropswolde' ],
	[ 'DKPW',  'Kroptewitz' ],
	[ 'XPKRO', 'Krosno Odrz' ],
	[ 'LKRF',  'Krottorf' ],
	[ 'XZKR',  'Krsko' ],
	[ 'LKUE',  'Krüden' ],
	[ 'LKUG',  'Krüden DB-Grenze' ],
	[ 'KKRU',  'Kr-Uerdingen' ],
	[ 'KKRX',  'Kr-Uerdingen Hp' ],
	[ 'KKRF',  'Kruft' ],
	[ 'BKRL',  'Krugau Lager' ],
	[ 'MKRS',  'Krumbach(S)Schul' ],
	[ 'MKRB',  'Krumbach/S' ],
	[ 'DKRU',  'Krumhermsdorf' ],
	[ 'EKRU',  'Krummenerl' ],
	[ 'NKRN',  'Krummennaab' ],
	[ 'LKRP',  'Krumpa' ],
	[ 'XAKR',  'Krumpendorf' ],
	[ 'AKRS',  'Krupunder' ],
	[ 'XTKRY', 'Kryry' ],
	[ 'XPKC',  'Krzeszowice' ],
	[ 'XPKI',  'Krzewie' ],
	[ 'XPKZG', 'Krzewina Zgorzel' ],
	[ 'XPKY',  'Krzyz' ],
	[ 'FKASH', 'KS Am Stern Holl' ],
	[ 'FKHFH', 'KS Hauptfriedhof' ],
	[ 'FKHBS', 'KS Hegelsbergstr' ],
	[ 'FKHPL', 'KS Holländ Platz' ],
	[ 'FKHST', 'KS Holländ Str' ],
	[ 'FKMBS', 'KS Mombachstr' ],
	[ 'FKWST', 'KS Wiener Straße' ],
	[ 'FKWNA', 'Ksl Nord/West A' ],
	[ 'FKWNB', 'Ksl Nord/West B' ],
	[ 'FKBB',  'Ksl-Bettenh Berg' ],
	[ 'FKBH',  'Ksl-Bettenhausen' ],
	[ 'FKH',   'Ksl-Harlesh' ],
	[ 'FKNZ',  'Ksl-Niederzw' ],
	[ 'FKNH',  'Ksl-Nordshausen' ],
	[ 'FKOZ',  'Ksl-Oberzwehren' ],
	[ 'FKWS',  'Ksl-Wilhelmsh S' ],
	[ 'FKW',   'Ksl-Wilhelmshöhe' ],
	[ 'KKSH',  'K-Stammheim' ],
	[ 'DKU',   'Kubschütz' ],
	[ 'TKUC',  'Kuchen' ],
	[ 'KKUH',  'Kuchenheim' ],
	[ 'XAKU',  'Kuchl' ],
	[ 'ZUKU',  'Kuchurgan' ],
	[ 'AKUD',  'Kudensee' ],
	[ 'DKW',   'Küchwald' ],
	[ 'WKBM',  'Kühlungsborn Mi' ],
	[ 'WKBO',  'Kühlungsborn Os' ],
	[ 'WKBW',  'Kühlungsborn We' ],
	[ 'UKU',   'Kühnhausen' ],
	[ 'LKUH',  'Kühren' ],
	[ 'FKWB',  'Külte-Wetterburg' ],
	[ 'EKUE',  'Künsebeck' ],
	[ 'EKNT',  'Küntrop' ],
	[ 'NKUE',  'Küps' ],
	[ 'DKUR',  'Kürbitz' ],
	[ 'XSKN',  'Küssnacht a R' ],
	[ 'BKI',   'Küstrin-Kietz' ],
	[ 'BXK',   'Küstrin-Kietz Gr' ],
	[ 'BQKK',  'Küstr-Kietz LGr' ],
	[ 'XAKN',  'Kufstein' ],
	[ 'MXKU',  'Kufstein Grenze' ],
	[ 'KKBR',  'Kuhbrücke' ],
	[ 'AKML',  'Kuhmühlen' ],
	[ 'XWKU',  'Kulata' ],
	[ 'XCKUL', 'Kulatka' ],
	[ 'RKUL',  'Kullenm (H-alb)' ],
	[ 'NKUH',  'Kulmb Heinlein' ],
	[ 'NKU',   'Kulmbach' ],
	[ 'NKUI',  'Kulmbach IRUSO' ],
	[ 'NMOF',  'Kulmbach Mönchs' ],
	[ 'NMKU',  'Kulmbach Müll' ],
	[ 'ZAKU',  'Kumanovo' ],
	[ 'WKUM',  'Kummerow (b Srd)' ],
	[ 'BKUM',  'Kummersdorf(b S)' ],
	[ 'XCKH',  'Kunashak' ],
	[ 'XCKV',  'Kunavino' ],
	[ 'XAKUN', 'Kundl' ],
	[ 'BPA',   'Kunersdorf' ],
	[ 'XVKA',  'Kungsbacka' ],
	[ 'XVKH',  'Kungsbacka Hede' ],
	[ 'FKBHK', 'Kunigundishof' ],
	[ 'XPKU',  'Kunowice' ],
	[ 'RBTK',  'Kupferhälde' ],
	[ 'AKUP',  'Kupfermühle' ],
	[ 'XPKUP', 'Kupienino' ],
	[ 'RKU',   'Kuppenheim' ],
	[ 'XCKU',  'Kurgan' ],
	[ 'DKJH',  'Kurort Jonsdf Hp' ],
	[ 'DKJ',   'Kurort Jonsdorf' ],
	[ 'DKOY',  'Kurort Oybin' ],
	[ 'DKON',  'Kurort Oybin Ndf' ],
	[ 'DRAT',  'Kurort Rathen' ],
	[ 'TWBK',  'Kurpark' ],
	[ 'HKUR',  'Kurve' ],
	[ 'SKUS',  'Kusel' ],
	[ 'XCKS',  'Kushmurun' ],
	[ 'AKTH',  'Kutenholz' ],
	[ 'XRKU',  'Kutina' ],
	[ 'XTKH',  'Kutna Hora hl.n.' ],
	[ 'XPKT',  'Kutno' ],
	[ 'XYKU',  'Kuty' ],
	[ 'MKUN',  'Kutzenhausen' ],
	[ 'ZLKZ',  'Kuziai' ],
	[ 'XPKZ',  'Kuznica (Hel)' ],
	[ 'XPKB',  'Kuznica Bialost' ],
	[ 'XOKV',  'Kval' ],
	[ 'XOK',   'Kvam' ],
	[ 'XOKF',  'Kvitfjell' ],
	[ 'KKWW',  'K-Weiden West' ],
	[ 'LKYA',  'Kyhna' ],
	[ 'SKY',   'Kyllburg' ],
	[ 'WKY',   'Kyritz' ],
	[ 'XYKY',  'Kysak' ],
	[ 'XTKT',  'Kytlice' ],
	[ 'RLBM',  'L BASF Pbf Mitte' ],
	[ 'KLBY',  'L Chemiepark NE' ],
	[ 'KBAY',  'L Chempark Hp' ],
	[ 'ALHS',  'L Hochschulstadt' ],
	[ 'LLVD',  'L Völkerschlacht' ],
	[ 'RLRU',  'L.hafen-Ruchheim' ],
	[ 'XFLBS', 'La Bastide S L' ],
	[ 'XFBT',  'La Bathie' ],
	[ 'XFWBI', 'La Brigue' ],
	[ 'XFLAT', 'La Charite' ],
	[ 'XELE',  'La Encina' ],
	[ 'XELL',  'La Llagosta' ],
	[ 'XBLL',  'La Louviere-Cent' ],
	[ 'XFGPL', 'La Plaine' ],
	[ 'XFXGP', 'La Plaine Gr CH' ],
	[ 'XFLRY', 'La Roche s Yon' ],
	[ 'XELR',  'La Roda d Albac' ],
	[ 'XFLST', 'La Souterraine' ],
	[ 'XILS',  'La Spezia C' ],
	[ 'XILM',  'La Spezia M' ],
	[ 'XILSM', 'La Spezia Maritt' ],
	[ 'XALAA', 'Laa a d Thaya' ],
	[ 'NLB',   'Laaber' ],
	[ 'WLA',   'Laage (Meckl)' ],
	[ 'XNLA',  'Laaken' ],
	[ 'XALKN', 'Laakirchen AT' ],
	[ 'HLAW',  'Laarwald' ],
	[ 'HXL',   'Laarwald Grenze' ],
	[ 'MLBW',  'Laberweinting' ],
	[ 'XSLH',  'Lachen' ],
	[ 'HLDF',  'Lachendorf' ],
	[ 'XOLL',  'Ladalen' ],
	[ 'XOLE',  'Lademoen' ],
	[ 'RLD',   'Ladenburg' ],
	[ 'ELAG',  'Lage (Lippe)' ],
	[ 'XNZLW', 'Lage Zwaluwe' ],
	[ 'MLLF',  'Lagerlechfeld' ],
	[ 'XALN',  'Lähn' ],
	[ 'FLSR',  'Lahnt-Sarnau' ],
	[ 'XVLH',  'Laholm' ],
	[ 'RLSW',  'Lahr (Schwarzw)' ],
	[ 'XFLAE', 'L\'Aigle' ],
	[ 'XILG',  'Laigueglia' ],
	[ 'NLCK',  'Laineck' ],
	[ 'BLAM',  'Lakoma' ],
	[ 'WLD',   'Lalendorf' ],
	[ 'WLDO',  'Lalendorf Ost' ],
	[ 'NLAM',  'Lam' ],
	[ 'XLLM',  'Lamadelaine' ],
	[ 'XALB',  'Lambach' ],
	[ 'RLBP',  'Lambrecht(Pfalz)' ],
	[ 'RLSH',  'Lambsheim' ],
	[ 'FLR',   'Lamerden' ],
	[ 'XILA',  'Lamezia T.C.' ],
	[ 'FLAE',  'Lämmerberg' ],
	[ 'XSLMC', 'Lamone-Cadempino' ],
	[ 'FLP',   'Lampertheim' ],
	[ 'SLAO',  'Lampertsmühle-O' ],
	[ 'BLW',   'Lampertswalde' ],
	[ 'XBLA',  'Lanaken' ],
	[ 'WLAK',  'Lancken' ],
	[ 'MLDI',  'Landau (Isar)' ],
	[ 'RLW',   'Landau(Pfalz) W' ],
	[ 'RLA',   'Landau(Pfalz)Hbf' ],
	[ 'RLAD',  'Landau(Pfalz)Süd' ],
	[ 'XALE',  'Landeck' ],
	[ 'XBLD',  'Landen' ],
	[ 'XVLA',  'Landeryd' ],
	[ 'HLDB',  'Landesbergen/Han' ],
	[ 'XNLG',  'Landgraaf' ],
	[ 'MALD',  'Landl (Obb) Abzw' ],
	[ 'MLDL',  'Landl (Oberbay)' ],
	[ 'XSLQ',  'Landquart' ],
	[ 'FLRN',  'Landrücken Nord' ],
	[ 'FLRS',  'Landrücken Süd' ],
	[ 'XFLA',  'Landry' ],
	[ 'MLLS',  'Landsb(L) Schule' ],
	[ 'LLBG',  'Landsberg' ],
	[ 'LQLA',  'Landsberg S LGr' ],
	[ 'LLAS',  'Landsberg Süd' ],
	[ 'MLL',   'Landsberg/Lech' ],
	[ 'BLST',  'Landsberger All.' ],
	[ 'MLA',   'Landshut/B Hbf' ],
	[ 'MLAS',  'Landshut/B Süd' ],
	[ 'SLD',   'Landstuhl' ],
	[ 'SLWR',  'Landsw-Reden' ],
	[ 'ALAS',  'Landungsbrücken' ],
	[ 'ALAN',  'Landwehr' ],
	[ 'FLGS',  'Lang Göns' ],
	[ 'XDLG',  'Langaa' ],
	[ 'NLG',   'Langdorf' ],
	[ 'XBLO',  'Langdorp' ],
	[ 'DLAB',  'Langebrück (Sa)' ],
	[ 'HLAN',  'Langeland' ],
	[ 'ALAL',  'Langeln(Holst)' ],
	[ 'HLNG',  'Langelsheim' ],
	[ 'FLG',   'Langen (Hess)' ],
	[ 'XALA',  'Langen a.Arlberg' ],
	[ 'TLR',   'Langenargen' ],
	[ 'TLL',   'Langenau (Württ)' ],
	[ 'TQLL',  'Langenau(Wü)LGr' ],
	[ 'MLB',   'Langenbach (Obb)' ],
	[ 'HLBA',  'Langenberg' ],
	[ 'ELBG',  'Langenberg/Rhein' ],
	[ 'RLBD',  'Langenbrand-Berm' ],
	[ 'HLBT',  'Langenbrück(Tec)' ],
	[ 'DLCH',  'Langenbuch' ],
	[ 'HLGD',  'Langendamm (Han)' ],
	[ 'WLDF',  'Langendorf' ],
	[ 'ULF',   'Langendorf Hp' ],
	[ 'LLGS',  'Langeneichstädt' ],
	[ 'KLA',   'Langenfeld (Rhl)' ],
	[ 'NLD',   'Langenfeld(Mfr)' ],
	[ 'ALST',  'Langenfelde' ],
	[ 'XLLG',  'Langengrund' ],
	[ 'FLAH',  'Langenhahn' ],
	[ 'HLGM',  'Langenhgn Mitte' ],
	[ 'HLGH',  'Langenhgn Pferde' ],
	[ 'HKAW',  'Langenh-Kaltw' ],
	[ 'ALG',   'Langenhorn/Schl' ],
	[ 'SLN',   'Langenlonsheim' ],
	[ 'ALGM',  'Langenmoor' ],
	[ 'ULAO',  'Langenorla Ost' ],
	[ 'ULAW',  'Langenorla West' ],
	[ 'NLP',   'Langenprozelten' ],
	[ 'TLSM',  'Langenschemmern' ],
	[ 'FLSW',  'Langenschwarz' ],
	[ 'FSLB',  'Langenselbold' ],
	[ 'LLAG',  'Langenstein' ],
	[ 'RLSS',  'Langensteinb.Er.' ],
	[ 'RLBB',  'Langensteinbach' ],
	[ 'RLSB',  'Langensteinbach' ],
	[ 'XSLT',  'Langenthal' ],
	[ 'MLNW',  'Langenwang/Schw' ],
	[ 'LLWD',  'Langenweddingen' ],
	[ 'DLWM',  'Langenwolm Mitte' ],
	[ 'DLW',   'Langenwolmsdf' ],
	[ 'NLZ',   'Langenzenn' ],
	[ 'KLAW',  'Langerwehe' ],
	[ 'TLAF',  'Langes Feld' ],
	[ 'WLG',   'Langhagen' ],
	[ 'XALK',  'Langkampfen' ],
	[ 'NLGU',  'Langlau' ],
	[ 'XOLG',  'Langlete' ],
	[ 'SLM',   'Langmeil (Pfalz)' ],
	[ 'SLMG',  'Langmeil DB/DTV' ],
	[ 'MLQU',  'Langquaid/Eggm' ],
	[ 'ELSD',  'Langschede' ],
	[ 'FLF',   'Langsdf (Obhess)' ],
	[ 'FLAS',  'Langstadt' ],
	[ 'HLGW',  'Langwedel' ],
	[ 'MLAW',  'Langweid (Lech)' ],
	[ 'BLAK',  'Lankwitz' ],
	[ 'NLAN',  'Lanzendorf' ],
	[ 'XJLP',  'Lapovo' ],
	[ 'XGL',   'Larissa' ],
	[ 'XPJR',  'Laroslaw' ],
	[ 'XPLAO', 'Laski Odrz' ],
	[ 'XPJL',  'Laskowice Jelcz' ],
	[ 'XPLP',  'Laskowice Pom' ],
	[ 'XOLM',  'Lassemoen' ],
	[ 'HLAT',  'Lathen' ],
	[ 'HLAO',  'Lathen Ost' ],
	[ 'XILT',  'Latina' ],
	[ 'NLDF',  'Laubendorf' ],
	[ 'SLAU',  'Laubenheim(Nahe)' ],
	[ 'ULCH',  'Laucha (Unstrut)' ],
	[ 'TLT',   'Laucherthal' ],
	[ 'BLH',   'Lauchhammer' ],
	[ 'TLH',   'Lauchheim' ],
	[ 'RLAU',  'Lauchringen' ],
	[ 'RLAG',  'Lauchringen DB/W' ],
	[ 'RLAC',  'Lauchringen West' ],
	[ 'TL',    'Lauda' ],
	[ 'RLCH',  'Laudenb(Bergstr)' ],
	[ 'NLK',   'Laudenbach' ],
	[ 'RQLC',  'Laudenbach LGr' ],
	[ 'ALUB',  'Lauenbrück' ],
	[ 'ALAU',  'Lauenburg (Elbe)' ],
	[ 'AQLA',  'Lauenburg NI/SH' ],
	[ 'HQLF',  'Lauenfö NI/NRW' ],
	[ 'HLFO',  'Lauenförde-Bev' ],
	[ 'DLST',  'Lauenstein (S)' ],
	[ 'NLL',   'Lauf (links Peg)' ],
	[ 'NLLW',  'Lauf West' ],
	[ 'NLR',   'Lauf(rechts Peg)' ],
	[ 'NLA',   'Laufach' ],
	[ 'XSLL',  'Läufelfingen' ],
	[ 'XSLF',  'Laufen' ],
	[ 'TLFK',  'Laufen (Kocher)' ],
	[ 'MLF',   'Laufen (Oberbay)' ],
	[ 'RLFG',  'Laufenbg (Baden)' ],
	[ 'RLBO',  'Laufenbg(Bad)Ost' ],
	[ 'XSLN',  'Laufenburg' ],
	[ 'TLFM',  'Laufenmühle' ],
	[ 'TLN',   'Lauffen (Neckar)' ],
	[ 'MLIG',  'Lauingen' ],
	[ 'TLW O', 'Lauph Kurve Ost' ],
	[ 'TLW S', 'Lauph Kurve Süd' ],
	[ 'TLW K', 'Laupheim Kurve' ],
	[ 'TLM',   'Laupheim Stadt' ],
	[ 'TLW',   'Laupheim West' ],
	[ 'FLBG',  'Laurenburg/Lahn' ],
	[ 'XILR',  'Lauriano' ],
	[ 'XSLA',  'Lausanne' ],
	[ 'XSLAF', 'Lausanne-Flon' ],
	[ 'ULA',   'Lauscha (Thür)' ],
	[ 'XSLS',  'Lausen' ],
	[ 'RLHB',  'Lausheim-Blumegg' ],
	[ 'LLSG',  'Laußig (b Düben)' ],
	[ 'DLZ',   'Laußnitz' ],
	[ 'BLA',   'Lauta (NL)' ],
	[ 'BQLA',  'Lauta (Nl) LGr' ],
	[ 'RLBA',  'Lautenb (Baden)' ],
	[ 'MLT',   'Lauter' ],
	[ 'DLR',   'Lauter (Sachs)' ],
	[ 'XALAH', 'Lauterach' ],
	[ 'FLAU',  'Lauterb (Hess) N' ],
	[ 'WLAU',  'Lauterbach (Rg)' ],
	[ 'WLAM',  'Lauterbach Mole' ],
	[ 'LLSB',  'Lauterbach-Stein' ],
	[ 'HBLB',  'Lauterb-Barbis' ],
	[ 'XFLTG', 'Lauterbourg' ],
	[ 'SLKG',  'Lauterecken-Gru.' ],
	[ 'XDLA',  'Laven' ],
	[ 'XILVM', 'Laveno Mombello' ],
	[ 'XILV',  'Lavino' ],
	[ 'ZULV',  'Lavochne' ],
	[ 'XVLX',  'Laxa' ],
	[ 'XCLZ',  'Lazarevskaia' ],
	[ 'XTLK',  'Lazne Kynzvart' ],
	[ 'BNF',   'Lb-Neuendorf' ],
	[ 'ALD A', 'L-Dänischbg Abzw' ],
	[ 'ALD G', 'L-Dänischbg Gbf' ],
	[ 'XFLBL', 'Le Boulou' ],
	[ 'XFLB',  'Le Bourget' ],
	[ 'XICG',  'Le Cave / Grasst' ],
	[ 'XFLC',  'Le Creusot TGV' ],
	[ 'XFHV',  'Le Havre' ],
	[ 'XFLM',  'Le Mans' ],
	[ 'XFRVM', 'Le Raincy' ],
	[ 'XFTP',  'Le Treport Mers' ],
	[ 'XOLA',  'Leangen' ],
	[ 'SLCH',  'Lebach' ],
	[ 'SLCG',  'Lebach Em/Saarb' ],
	[ 'SLCJ',  'Lebach-Jabach' ],
	[ 'XBLK',  'Lebbeke' ],
	[ 'XPLB',  'Lebork' ],
	[ 'XILC',  'Lecce' ],
	[ 'XILMA', 'Lecco Maggianico' ],
	[ 'XCLE',  'Lechebnyi' ],
	[ 'ELEC',  'Lechtenberg' ],
	[ 'DLEW',  'Leckwitz' ],
	[ 'XPLD',  'Ledziny' ],
	[ 'HLEEP', 'Leer Gbf' ],
	[ 'HLEEA', 'Leer Süd' ],
	[ 'HLEE',  'Leer/Ostfriesl' ],
	[ 'HQLS',  'Leese-Sto NI/NRW' ],
	[ 'HLST',  'Leese-Stolzenau' ],
	[ 'HLEB',  'Leeste(b Bremen)' ],
	[ 'XNLW',  'Leeuwarden' ],
	[ 'ELGD',  'Legden' ],
	[ 'ULE',   'Legefeld' ],
	[ 'RLT',   'Legelshurst' ],
	[ 'XPLG',  'Legionowo' ],
	[ 'XILGN', 'Legnano' ],
	[ 'XPLE',  'Legnica' ],
	[ 'XULH',  'Lehliu' ],
	[ 'SLE',   'Lehmen' ],
	[ 'DLH',   'Lehndorf' ],
	[ 'FLEH',  'Lehnheim' ],
	[ 'BLEN',  'Lehnitz' ],
	[ 'ALHG',  'Lehnshallig' ],
	[ 'NLE',   'Lehrberg' ],
	[ 'HLEH',  'Lehre/Braunschw' ],
	[ 'HLER',  'Lehrte' ],
	[ 'HLERN', 'Lehrte Nord' ],
	[ 'HLERW', 'Lehrte West' ],
	[ 'XALZ',  'Leibnitz' ],
	[ 'KLEL',  'Leichlingen' ],
	[ 'XNL',   'Leiden' ],
	[ 'XNLL',  'Leiden Lamme' ],
	[ 'XNLI',  'Leidschend ICE' ],
	[ 'XNLV',  'Leidschendam-V' ],
	[ 'HLFG',  'Leiferde(b Gifh)' ],
	[ 'HLFB',  'Leiferde/Brg' ],
	[ 'HLFU',  'Leiferde/Gih Üst' ],
	[ 'ELEI',  'Leimstruth' ],
	[ 'UL',    'Leinefelde' ],
	[ 'TLF',   'Leinfelden' ],
	[ 'TLG',   'Leingarten' ],
	[ 'TLGM',  'Leingarten Mitte' ],
	[ 'TLGO',  'Leingarten Ost' ],
	[ 'TLGW',  'Leingarten West' ],
	[ 'MLEH',  'Leipheim' ],
	[ 'FKBHW', 'Leipz Pl(Weberh)' ],
	[ 'LLB',   'Leipzig Bayer Bf' ],
	[ 'LL',    'Leipzig Hbf' ],
	[ 'LMDR',  'Leipzig MDR' ],
	[ 'LNW',   'Leipzig Messe' ],
	[ 'LNW H', 'Leipzig Messe Hp' ],
	[ 'LLN',   'Leipzig Nord' ],
	[ 'LL N',  'Leipzig Nordkopf' ],
	[ 'LLAN',  'Leipzig-Anger' ],
	[ 'FKBHL', 'Leipziger Platz' ],
	[ 'LLG',   'Leipzig-Gohlis' ],
	[ 'LLEL',  'Leipzig-Leutzsch' ],
	[ 'LLMO',  'Leipzig-Mockau' ],
	[ 'LLMH',  'Leipzig-Möckern' ],
	[ 'LMLK',  'Leipzig-Mölkau' ],
	[ 'LLP',   'Leipzig-Plagwitz' ],
	[ 'LLT',   'Leipzig-Thekla' ],
	[ 'LLW',   'Leipzig-Wahren' ],
	[ 'DLS',   'Leisnig' ],
	[ 'ULL',   'Leißling' ],
	[ 'XALT',  'Leithen' ],
	[ 'ALE',   'Leitstade' ],
	[ 'XPLEK', 'Leknica' ],
	[ 'XNLY',  'Lelystad' ],
	[ 'XDLM',  'Lem' ],
	[ 'ELBK',  'Lembeck' ],
	[ 'HLMB',  'Lembruch' ],
	[ 'HLMF',  'Lemförde' ],
	[ 'HQLM',  'Lemförde NI/NRW' ],
	[ 'ELGO',  'Lemgo' ],
	[ 'ELGG',  'Lemgo DB-Gr' ],
	[ 'ELGL',  'Lemgo-Lüttfeld' ],
	[ 'HLEM',  'Lemmie' ],
	[ 'HLWD',  'Lemwerder' ],
	[ 'XYLN',  'Lenartovce' ],
	[ 'XALND', 'Lend' ],
	[ 'KLED',  'Lendersdorf' ],
	[ 'ELSN',  'Lendringsen' ],
	[ 'HBST',  'Lengede-Broist' ],
	[ 'DRAU',  'Lengef-Rauen' ],
	[ 'DLFD',  'Lengenfeld (V)' ],
	[ 'MLWG',  'Lengenwang' ],
	[ 'ELGS',  'Lengerich Stadt' ],
	[ 'ELEN',  'Lengerich/Westf' ],
	[ 'ELGP',  'Lengerich-H Pbf' ],
	[ 'ELGH',  'Lengerich-Hohne' ],
	[ 'FLE',   'Lengfeld' ],
	[ 'MLG',   'Lenggries' ],
	[ 'HLGL',  'Lenglern' ],
	[ 'XSLW',  'Lengwil' ],
	[ 'XMLT',  'Lengyeltoti' ],
	[ 'EMEG',  'Lennest-Meggen' ],
	[ 'XFLN',  'Lens' ],
	[ 'ALS',   'Lensahn' ],
	[ 'ALFD',  'Lentföhrden' ],
	[ 'XSLB',  'Lenzburg' ],
	[ 'XALEZ', 'Lenzing' ],
	[ 'XALO',  'Leoben Hbf' ],
	[ 'XALD',  'Leoben-Donawitz' ],
	[ 'XALG',  'Leogang' ],
	[ 'TLE',   'Leonberg' ],
	[ 'XBLB',  'Leopoldsburg' ],
	[ 'RLEO',  'Leopoldshf L-str' ],
	[ 'ELEO',  'Leopoldstal' ],
	[ 'XOL',   'Ler' ],
	[ 'XALM',  'Lermoos' ],
	[ 'XFLE',  'Lerouville' ],
	[ 'XVLE',  'Lerum' ],
	[ 'XFLAC', 'Les Arcs' ],
	[ 'XILES', 'Lesa' ],
	[ 'XFAO',  'Les-Aubrais-Orl' ],
	[ 'XZLB',  'Lesce-Bled' ],
	[ 'HLED',  'Leschede' ],
	[ 'XILSG', 'Lesegno' ],
	[ 'XOLJ',  'Lesja' ],
	[ 'XOLJV', 'Lesjaverk' ],
	[ 'XJLE',  'Leskovac' ],
	[ 'XPLN',  'Leszno' ],
	[ 'HLET',  'Leteln' ],
	[ 'ELED',  'Letm Dechenhöhle' ],
	[ 'ELE',   'Letmathe' ],
	[ 'XTLE',  'Letovice' ],
	[ 'BLTS',  'Letschin' ],
	[ 'ELET',  'Lette/Coesfeld' ],
	[ 'HLT',   'Letter' ],
	[ 'HLTA',  'Letter Abzw' ],
	[ 'ULBN',  'Leubingen' ],
	[ 'KLEU',  'Leubsdorf(Rhein)' ],
	[ 'DLEU',  'Leubsdorf(Sachs)' ],
	[ 'XLLD',  'Leudelange' ],
	[ 'XSLE',  'Leuk' ],
	[ 'FBFS',  'Leun/Braunfels' ],
	[ 'YLLAL', 'Leuna Strw' ],
	[ 'LLWN',  'Leuna Werke Nord' ],
	[ 'LLWS',  'Leuna Werke Süd' ],
	[ 'ULEU',  'Leutenberg' ],
	[ 'RLS',   'Leutersberg' ],
	[ 'MLSH',  'Leuterschach' ],
	[ 'DLT',   'Leutersdorf' ],
	[ 'RLEU',  'Leutershs./Baden' ],
	[ 'NLWI',  'Leutershs-Wied' ],
	[ 'KLET',  'Leutesdorf(Rh.)' ],
	[ 'BLE',   'Leuthen b Cottb' ],
	[ 'TLK',   'Leutkirch' ],
	[ 'XBLE',  'Leuven' ],
	[ 'KLMH',  'Lev Mitte Hp' ],
	[ 'KLM',   'Lev Morsbroich' ],
	[ 'XGLV',  'Levadia' ],
	[ 'XOLV',  'Levanger' ],
	[ 'XILE',  'Levanto' ],
	[ 'KLMI',  'Leverkusen Mitte' ],
	[ 'KLKH',  'Lev-Küpperst Hp' ],
	[ 'KLKS',  'Lev-Küpperst Üst' ],
	[ 'KLK',   'Lev-Küppersteg' ],
	[ 'KLRH',  'Lev-Rheindorf' ],
	[ 'KLRD',  'Lev-Rheindorf NE' ],
	[ 'KLS',   'Lev-Schlebusch' ],
	[ 'XWLV',  'Levski' ],
	[ 'LLW U', 'Le-Wahren Ubf' ],
	[ 'XFLZ',  'Lezignan (Aude)' ],
	[ 'KLAB',  'Lf-Berghausen' ],
	[ 'FLGF',  'Lg Flugsicherung' ],
	[ 'LLGZ',  'L-Großzschocher' ],
	[ 'MALI',  'Li-Aeschach Abzw' ],
	[ 'XGLI',  'Lianokladion' ],
	[ 'XTL',   'Liberec' ],
	[ 'XTLR',  'Liberec-Rochlice' ],
	[ 'FLI',   'Lich (Oberhess)' ],
	[ 'FLIR',  'Licherode' ],
	[ 'XTLI',  'Lichkov' ],
	[ 'DLIG',  'Lichtenberg (E)' ],
	[ 'BLI',   'Lichtenberg S-B' ],
	[ 'NLF',   'Lichtenfels' ],
	[ 'ULIH',  'Lichtenhain adB' ],
	[ 'BLRD',  'Lichtenrade' ],
	[ 'DLTS',  'Lichtenstein (S)' ],
	[ 'DLI',   'Lichtentanne (S)' ],
	[ 'ULIT',  'Lichtentanne(Th)' ],
	[ 'NLH',   'Lichtenthal' ],
	[ 'BLWE',  'Lichterfde West' ],
	[ 'BLIH',  'Lichterfelde Ost' ],
	[ 'BLIS',  'Lichterfelde Süd' ],
	[ 'XVLK',  'Lidköping' ],
	[ 'HLIB',  'Liebenau (Han)' ],
	[ 'FLIB',  'Liebenau(Bz Ksl)' ],
	[ 'WLBT',  'Liebenthal(Prgn)' ],
	[ 'FLIE',  'Lieblos' ],
	[ 'FLDB',  'Liederbach' ],
	[ 'FLDS',  'Liederbach Süd' ],
	[ 'XBL',   'Liege' ],
	[ 'XBLIG', 'Liege (G)' ],
	[ 'HLIE',  'Lienen' ],
	[ 'BLIA',  'Lienewitz (Lia)' ],
	[ 'XALI',  'Lienz' ],
	[ 'XBLI',  'Liers' ],
	[ 'ELBN',  'Liesborn' ],
	[ 'XSLI',  'Liestal' ],
	[ 'WLI',   'Lietzow (Rügen)' ],
	[ 'XHL',   'Lievestuore' ],
	[ 'XALZN', 'Liezen' ],
	[ 'XCLI',  'Lihaia' ],
	[ 'XFLI',  'Lille' ],
	[ 'XFLIE', 'Lille Europa' ],
	[ 'XFLID', 'Lille-Delivrance' ],
	[ 'XOLH',  'Lillehammer' ],
	[ 'XOLS',  'Lillestrom' ],
	[ 'DLIM',  'Limbach (V)' ],
	[ 'SLB',   'Limbach/Hombg Sa' ],
	[ 'SLBS',  'Limbach/Saarlou' ],
	[ 'FL',    'Limburg (Lahn)' ],
	[ 'FLIS',  'Limburg Süd' ],
	[ 'FQLI',  'Limburg Süd LGr' ],
	[ 'FQL',   'Limburg(L) 3710' ],
	[ 'FQL N', 'Limburg(L) 3730' ],
	[ 'RLI',   'Limburgerhof' ],
	[ 'RLIA',  'Limburghof Abzw' ],
	[ 'DLM',   'Limmritz (Sachs)' ],
	[ 'XILMN', 'Limone' ],
	[ 'LLI',   'Linda (Elster)' ],
	[ 'RLID',  'Lindach' ],
	[ 'MLI',   'Lindau Hbf' ],
	[ 'MLIA',  'Lindau-Aeschach' ],
	[ 'MLIR',  'Lindau-Reutin' ],
	[ 'MXLR',  'Lindau-Reutin Gr' ],
	[ 'KLID',  'Linden' ],
	[ 'HWLI',  'Linden (Wolfb)' ],
	[ 'LLIN',  'Lindenau' ],
	[ 'FKBHI', 'Lindenberg' ],
	[ 'BLNG',  'Lindenberg(Mark)' ],
	[ 'FLHH',  'Lindenholzhausen' ],
	[ 'FLHN',  'Lindenholzhausen' ],
	[ 'KLIH',  'Linderhausen' ],
	[ 'KLD',   'Lindern' ],
	[ 'KLDG',  'Lindern DB-Gr' ],
	[ 'ALH',   'Lindholm' ],
	[ 'XDLI',  'Lindholm DK' ],
	[ 'HLH',   'Lindhorst/Sch L' ],
	[ 'XVLM',  'Lindome' ],
	[ 'WLDW',  'Lindow (Mark)' ],
	[ 'BLT',   'Lindthal' ],
	[ 'HLWL',  'Lindwedel' ],
	[ 'HLIG',  'Lingen (Ems)' ],
	[ 'HLIS',  'Lingen(Ems)Stadt' ],
	[ 'RLF',   'Lingenfeld' ],
	[ 'XVLI',  'Linghem' ],
	[ 'RLIN',  'Linkenheim' ],
	[ 'RLING', 'Linkenheim Rath' ],
	[ 'XVL',   'Linköping' ],
	[ 'XNLH',  'Linne Herten' ],
	[ 'KLIN',  'Linnich' ],
	[ 'KLIT',  'Linnich-Tetz' ],
	[ 'HLBU',  'Linsburg' ],
	[ 'TLSH',  'Linsenhofen' ],
	[ 'XLLI',  'Lintgen' ],
	[ 'HLIN',  'Lintorf (Han)' ],
	[ 'ELIT',  'Lintorf(NRhein)' ],
	[ 'KLI',   'Linz (Rhein)' ],
	[ 'KLIG',  'Linz DB-Grenze' ],
	[ 'XAL',   'Linz Hbf' ],
	[ 'XALC',  'Linz OMV Chemie' ],
	[ 'XALSH', 'Linz Stadthafen' ],
	[ 'XALS',  'Linz Stahlwerke' ],
	[ 'XALV',  'Linz Vbf' ],
	[ 'XALW',  'Linz Wegscheid' ],
	[ 'XTZE',  'Lipa nad Drevn' ],
	[ 'XPLIL', 'Lipinki Luzyckie' ],
	[ 'XTLL',  'Lipova Sluknova' ],
	[ 'XTLC',  'Lipova u Chebu' ],
	[ 'ELPG',  'Lippborg-Heintr' ],
	[ 'ELPE',  'Lippe' ],
	[ 'FLIP',  'Lippoldshausen' ],
	[ 'ELPP',  'Lippstadt' ],
	[ 'ELPW',  'Lippstadt WLE' ],
	[ 'ELPPG', 'Lippstadt Gbf' ],
	[ 'ELPN',  'Lippstadt Nord' ],
	[ 'XYLM',  'Lipto Mikulas' ],
	[ 'XYLH',  'Liptovsky Hradok' ],
	[ 'XXLO',  'Lisboa Oriente' ],
	[ 'XXL',   'Lisboa S.A.' ],
	[ 'XVLB',  'Liseberg' ],
	[ 'XCLK',  'Liski' ],
	[ 'FLIH',  'Lispenhausen' ],
	[ 'KLIS',  'Lissendorf' ],
	[ 'ELIS',  'Listerscheid' ],
	[ 'XZLJ',  'Litija' ],
	[ 'XTLM',  'Litomerice Mesto' ],
	[ 'ZULB',  'Liuboml' ],
	[ 'XILI',  'Livorno Centrale' ],
	[ 'XILF',  'Livorno Ferraris' ],
	[ 'XZL',   'Ljubljana' ],
	[ 'XZLM',  'Ljubljana Moste' ],
	[ 'XVLJ',  'Ljung' ],
	[ 'XVLU',  'Ljungskile' ],
	[ 'ALKG',  'L-Konstinbf DBGr' ],
	[ 'ALKR',  'L-Kückn Roter H' ],
	[ 'LLWZ',  'L-Liebertwolkwit' ],
	[ 'RBRM',  'Lö Bromb/Hauing' ],
	[ 'RHAG',  'Lö Haagen/Messe' ],
	[ 'RLRS',  'Lö Museum/Burgh' ],
	[ 'XILO',  'Loano' ],
	[ 'DLOG',  'Löbau (S) DB-Gr' ],
	[ 'DL',    'Löbau (Sachs)' ],
	[ 'ULB',   'Lobenstein (Th)' ],
	[ 'XPLOB', 'Lobez' ],
	[ 'LLO',   'Lobstädt' ],
	[ 'LLOG',  'Loburg' ],
	[ 'XSLC',  'Locarno' ],
	[ 'LLOW',  'Lochau Werkbf' ],
	[ 'XALH',  'Lochau-Hoerbranz' ],
	[ 'RLOE',  'Löcherberg' ],
	[ 'MLCH',  'Lochham' ],
	[ 'XSLG',  'Löchligut' ],
	[ 'WLK',   'Löcknitz' ],
	[ 'LLOL',  'Lodersleben' ],
	[ 'XILD',  'Lodi' ],
	[ 'HLOD',  'Lödingsen' ],
	[ 'XPLC',  'Lodz Chojny' ],
	[ 'XPLK',  'Lodz Kaliska' ],
	[ 'XPLO',  'Lodz Olechow' ],
	[ 'XPLW',  'Lodz Widzew' ],
	[ 'XDLF',  'Loeftgard' ],
	[ 'SLF',   'Löf' ],
	[ 'RLGN',  'Löffingen' ],
	[ 'XZLO',  'Logatec' ],
	[ 'KLOC',  'Lohbruch' ],
	[ 'NLOR',  'Lohgarten-Roth' ],
	[ 'KLHD',  'Lohheide' ],
	[ 'MLH',   'Lohhof' ],
	[ 'DLO',   'Lohmen' ],
	[ 'FLOE',  'Löhnberg' ],
	[ 'HLON',  'Lohne (Oldb)' ],
	[ 'HL G',  'Löhne(Westf) Gbf' ],
	[ 'HL',    'Löhne(Westf) Pbf' ],
	[ 'SLOH',  'Lohnweiler' ],
	[ 'NLO',   'Lohr Bahnhof' ],
	[ 'NLOS',  'Lohr Stadt' ],
	[ 'BLOH',  'Lohsa' ],
	[ 'MLOI',  'Loiching' ],
	[ 'XALF',  'Loifarn' ],
	[ 'ULHO',  'Loitsch-Hohenleu' ],
	[ 'XCLO',  'Loknaia' ],
	[ 'XMLO',  'Lököshaza' ],
	[ 'FLOL',  'Lollar' ],
	[ 'XILN',  'Lonato' ],
	[ 'XKLC',  'London Ch.Cr.' ],
	[ 'XKLL',  'London Liv Str' ],
	[ 'XKLLB', 'London London Br' ],
	[ 'XKLP',  'London St Panc' ],
	[ 'XKLV',  'London Vict' ],
	[ 'XKLW',  'London Waterloo' ],
	[ 'XFLNG', 'Longueau' ],
	[ 'XFLY',  'Longwy' ],
	[ 'HLOE',  'Löningen' ],
	[ 'XVLO',  'Lönneberga' ],
	[ 'XOLD',  'Lonsdal' ],
	[ 'TLON',  'Lonsee' ],
	[ 'XFLS',  'Lons-Le-Saunier' ],
	[ 'XCL',   'Loo' ],
	[ 'XALDF', 'Loosdorf' ],
	[ 'MLOH',  'Loppenhausen' ],
	[ 'XELS',  'Lorca-Sutullena' ],
	[ 'FLOU',  'Lorch (Rh)' ],
	[ 'FLOR',  'Lorch (Rhein)' ],
	[ 'TLO',   'Lorch (Württ)' ],
	[ 'FLON',  'Lorchhausen' ],
	[ 'FQLO',  'Lorchhausen LGr' ],
	[ 'FLY',   'Loreley' ],
	[ 'XLLR',  'Lorentzweiler' ],
	[ 'RLRD',  'Lörr Dammstraße' ],
	[ 'RLR G', 'Lörrach Gbf' ],
	[ 'RLR',   'Lörrach Hbf' ],
	[ 'RLST',  'Lörrach-Stetten' ],
	[ 'XFLR',  'Lorraine-Louv' ],
	[ 'RLRW',  'Lörr-Schwarzwald' ],
	[ 'FLB',   'Lorsbach' ],
	[ 'FLO',   'Lorsch' ],
	[ 'RLFB',  'Lörzenb-Fahrenb' ],
	[ 'ZWLO',  'Lososna' ],
	[ 'DLAU',  'Lössau' ],
	[ 'RLOS',  'Loßburg-Rodt' ],
	[ 'DLN',   'Lößnitz ob Bf' ],
	[ 'DLNU',  'Lößnitz unt Bf' ],
	[ 'XOLT',  'Loten' ],
	[ 'ELOT',  'Lotharstraße' ],
	[ 'HLOT',  'Lotte(Tecklenbg)' ],
	[ 'XSLO',  'Lottstetten' ],
	[ 'XFLF',  'Loudrefing' ],
	[ 'XTLH',  'Loukov u Mn Hr' ],
	[ 'XTLNS', 'Louny stred' ],
	[ 'XFLO',  'Lourches' ],
	[ 'XFL',   'Lourdes' ],
	[ 'XTLV',  'Lovetin' ],
	[ 'XTLVO', 'Lovetin obec' ],
	[ 'XTLO',  'Lovosice' ],
	[ 'WLO',   'Löwenberg (Mark)' ],
	[ 'WLOD',  'Löwenberg Dorf' ],
	[ 'WLOG',  'Löwenbg(M)DB-Gr' ],
	[ 'TLOE',  'Löwental' ],
	[ 'XPLZ',  'Lowicz Gl' ],
	[ 'HLOX',  'Loxstedt' ],
	[ 'HQLO',  'Loxstedt NI/HB' ],
	[ 'XPLOZ', 'Loznica' ],
	[ 'XJLO',  'Loznica RS' ],
	[ 'ZULZ',  'Lozovaia' ],
	[ 'LLBB',  'Lpz Berliner Str' ],
	[ 'LL T',  'Lpz Hbf (tief)' ],
	[ 'LNW N', 'Lpz Messe Nord' ],
	[ 'LNW S', 'Lpz Messe Süd' ],
	[ 'LSEL',  'Lpz Olbrichtstr' ],
	[ 'LL P',  'Lpz Petzscher M' ],
	[ 'LSVS',  'Lpz Slevogtstr' ],
	[ 'LLC Y', 'Lpz-Connew Strw' ],
	[ 'LLC',   'Lpz-Connewitz' ],
	[ 'LLH',   'Lpz-Heiterblick' ],
	[ 'LHSN',  'Lpz-Holzhausen' ],
	[ 'LLK',   'Lpz-Knauthain' ],
	[ 'LLA',   'Lpz-Lützschena' ],
	[ 'LMIZ',  'Lpz-Miltitz' ],
	[ 'LLPD',  'Lpz-Paunsdorf' ],
	[ 'LLPDH', 'Lpz-Paunsdorf Hp' ],
	[ 'LLP G', 'Lpz-Plagwitz Gbf' ],
	[ 'LRMF',  'Lpz-Rückmarsdorf' ],
	[ 'LLS',   'Lpz-Schönefeld' ],
	[ 'LLST',  'Lpz-Stötteritz' ],
	[ 'LL V',  'Lpz-Volkmarsdorf' ],
	[ 'LLW L', 'Lpz-Wahren West' ],
	[ 'ALTG',  'L-Tra Skan DB-Gr' ],
	[ 'LEL',   'Lu Eisleben' ],
	[ 'LWND',  'Lu Wb-Labetz' ],
	[ 'LWP',   'Lu Wb-Piesteritz' ],
	[ 'LWET',  'Lu Wittenb Altst' ],
	[ 'LW',    'Lu Wittenberg' ],
	[ 'LWBW',  'Lu Wittenbg West' ],
	[ 'RL K',  'Lu(Rh) T51/52/53' ],
	[ 'XPLA',  'Lubaczow' ],
	[ 'XPLU',  'Luban Slaski' ],
	[ 'XYLB',  'Lubenik' ],
	[ 'XPLUG', 'Lubin Gorniczy' ],
	[ 'XPLL',  'Lublin' ],
	[ 'XPLLC', 'Lublinec' ],
	[ 'WLMW',  'Lubmin Gbf' ],
	[ 'WLMZ',  'Lubmin Mitte' ],
	[ 'BLU',   'Lubolz' ],
	[ 'XTLN',  'Lucany nad Nisou' ],
	[ 'XILUC', 'Lucca' ],
	[ 'ZULU',  'Luck' ],
	[ 'BSNZ',  'Luckaitztal' ],
	[ 'BPAS',  'Luckau-Paserin' ],
	[ 'BUK',   'Luckau-Uckro' ],
	[ 'LLUC',  'Luckenau' ],
	[ 'BLD G', 'Luckenw Gbf' ],
	[ 'BLD',   'Luckenwalde' ],
	[ 'NLHM',  'Ludersheim' ],
	[ 'XALU',  'Ludesch' ],
	[ 'RLOR',  'Ludw Oggersh RHB' ],
	[ 'RL T',  'Ludwh(R)Hbf tief' ],
	[ 'RLBN',  'Ludwhf BASF Nord' ],
	[ 'LLUD',  'Ludwig' ],
	[ 'RLBST', 'Ludwig BASF Südt' ],
	[ 'RLB W', 'Ludwig BASF Werk' ],
	[ 'RLB',   'Ludwig.(Rh)BASF' ],
	[ 'RLB G', 'Ludwigs BASF Gbf' ],
	[ 'RLB U', 'Ludwigs BASF Ubf' ],
	[ 'RLHR',  'Ludwigs.(Rh) RHB' ],
	[ 'RLO',   'Ludwigs.Oggersh.' ],
	[ 'TLUG',  'Ludwigsb DB/Lott' ],
	[ 'TLU',   'Ludwigsburg' ],
	[ 'NLS',   'Ludwigschorgast' ],
	[ 'BLFW',  'Ludwigsf Werkbf' ],
	[ 'BLF',   'Ludwigsfelde' ],
	[ 'FFL',   'Ludwigs-Friedlos' ],
	[ 'BSTH',  'Ludwigsf-Struves' ],
	[ 'RLBS',  'Ludwigsh BASF S.' ],
	[ 'RLSM',  'Ludwigsh Mitte' ],
	[ 'RL G',  'Ludwigsh(Rh)Gbf' ],
	[ 'RL',    'Ludwigsh(Rh)Hbf' ],
	[ 'RL N',  'Ludwigsh.(Rh)Ü.N' ],
	[ 'RL S',  'Ludwigsh.(Rh)ÜbS' ],
	[ 'RQLM',  'Ludwigshaf 3401' ],
	[ 'RQL',   'Ludwigshf(Rh)LGr' ],
	[ 'RLU',   'Ludwigshf/Bodens' ],
	[ 'NLUD',  'Ludwigshöhe' ],
	[ 'WL',    'Ludwigslust' ],
	[ 'NLUS',  'Ludwigsstadt' ],
	[ 'NLT',   'Ludwigsthal' ],
	[ 'ALSK',  'Lüb Skand-kai' ],
	[ 'LLUE',  'Lübars (Kr Burg)' ],
	[ 'HLBB',  'Lübbecke (Westf)' ],
	[ 'BLB',   'Lübben (Spreew)' ],
	[ 'BLN',   'Lübbenau Spreew' ],
	[ 'HLBR',  'Lübberstedt' ],
	[ 'HLUL',  'Lübberstedt/Lünb' ],
	[ 'ALB',   'Lübeck Flughafen' ],
	[ 'AL',    'Lübeck Hbf' ],
	[ 'ALR',   'Lübeck Hgbf' ],
	[ 'ALRA',  'Lübeck Hgbf Abzw' ],
	[ 'ALKO',  'Lübeck Konstinbf' ],
	[ 'AXLM',  'Lübeck SJ Malmö' ],
	[ 'ALSJ',  'Lübeck St Jürgen' ],
	[ 'AXLT',  'Lübeck VR Turku' ],
	[ 'ALD',   'Lübeck-Dänischbg' ],
	[ 'ALIV',  'Lübeck-Ivendorf' ],
	[ 'ALKN',  'Lübeck-Kücknitz' ],
	[ 'ALSC',  'Lübeck-Schlutup' ],
	[ 'WLOW',  'Lüblow (Meckl)' ],
	[ 'LLBS',  'Lübs (b Magdeb)' ],
	[ 'WLST',  'Lübstorf' ],
	[ 'ALTH',  'Lüb-Trav Hafen' ],
	[ 'ALTK',  'Lüb-Trav Skankai' ],
	[ 'ALTS',  'Lüb-Trav Strand' ],
	[ 'WLZ',   'Lübz' ],
	[ 'ALCH',  'Lüchow' ],
	[ 'HLN',   'Lüchtringen' ],
	[ 'HQLN',  'Lüchtringen LGr' ],
	[ 'ELS',   'Lüdenscheid' ],
	[ 'WLF',   'Lüdersdorf (M)' ],
	[ 'ELDH',  'Lüdinghausen' ],
	[ 'HLUE',  'Lügde' ],
	[ 'HLSB',  'Lührsbockel' ],
	[ 'KLDF',  'Lülsdorf' ],
	[ 'NLUE',  'Lülsfeld' ],
	[ 'ALBG',  'Lüneburg' ],
	[ 'ALBGG', 'Lüneburg Gbf' ],
	[ 'HLBK',  'Lüneburg Kurpark' ],
	[ 'HLBN',  'Lüneburg Nord' ],
	[ 'HLBS',  'Lüneburg Süd' ],
	[ 'ELUE',  'Lünen Hbf' ],
	[ 'ELUS',  'Lünen Süd' ],
	[ 'ELRN',  'Lünern' ],
	[ 'HLNT',  'Lünischteich' ],
	[ 'LLUP',  'Lüptitz' ],
	[ 'LLUG',  'Lüptitz DB-Gr' ],
	[ 'WLW',   'Lüssow (Meckl)' ],
	[ 'HLRI',  'Lüstringen' ],
	[ 'ELDD',  'Lütgendortmund' ],
	[ 'BLUT',  'Lütte' ],
	[ 'FLUE',  'Lütter' ],
	[ 'ELUZ',  'Lützel' ],
	[ 'RLUE',  'Lützelsachsen' ],
	[ 'RLZO',  'Lützelsachsen O.' ],
	[ 'WLTW',  'Lützow' ],
	[ 'XSL',   'Lugano' ],
	[ 'XSLV',  'Lugano Vedeggio' ],
	[ 'ZULG',  'Lugansk' ],
	[ 'DLG',   'Lugau' ],
	[ 'XILU',  'Lugo' ],
	[ 'XULU',  'Lugoj' ],
	[ 'XTLS',  'Luh n Svatavou' ],
	[ 'HLHD',  'Luhdorf' ],
	[ 'NLU',   'Luhe' ],
	[ 'NLW',   'Luhe-Wildenau' ],
	[ 'XIL',   'Luino' ],
	[ 'ULT',   'Luisenthal (Th)' ],
	[ 'SLU',   'Luisenthal(Saar)' ],
	[ 'NLUH',  'Luitpoldhütte' ],
	[ 'ZULJ',  'Lujany' ],
	[ 'XPL',   'Lukow' ],
	[ 'XFLUQ', 'Lumes' ],
	[ 'RLUM',  'Lu-Mundenheim' ],
	[ 'XVLD',  'Lund' ],
	[ 'XOLO',  'Lundamo' ],
	[ 'XDLUN', 'Lundby' ],
	[ 'XOLU',  'Lunde' ],
	[ 'XDLD',  'Lunde DK' ],
	[ 'ALU',   'Lunden' ],
	[ 'XDLU',  'Lunderskov' ],
	[ 'XFLUN', 'Lunel' ],
	[ 'XFLWQ', 'Lunel Viel' ],
	[ 'HLUN',  'Lunestedt' ],
	[ 'XFLU',  'Luneville' ],
	[ 'ZWLU',  'Luninec' ],
	[ 'XOLR',  'Lunner' ],
	[ 'XSLP',  'Lupfig' ],
	[ 'RLUR',  'Lu-Rheingönheim' ],
	[ 'RLH',   'Lußhardt' ],
	[ 'XALUU', 'Lustenau' ],
	[ 'XAXLU', 'Lustenau Gr CH' ],
	[ 'XALUM', 'Lustenau Markt' ],
	[ 'XSLZ',  'Luterbach-Attish' ],
	[ 'FKLPL', 'Lutherplatz' ],
	[ 'HLTT',  'Lutten' ],
	[ 'XFLUB', 'Lutterbach' ],
	[ 'FLUT',  'Lutterberg' ],
	[ 'HLTN',  'Luttern' ],
	[ 'HLUM',  'Luttum' ],
	[ 'ELUT',  'Lutum' ],
	[ 'XFLT',  'Lutzelbourg' ],
	[ 'XLL',   'Luxembourg' ],
	[ 'XLLH',  'Lux-Hollerich' ],
	[ 'XSLU',  'Luzern' ],
	[ 'XTLU',  'Luzna u Rakovn' ],
	[ 'ZUL',   'Lvov' ],
	[ 'HLWF',  'Lwerk Friesoythe' ],
	[ 'XDLN',  'Lyngs' ],
	[ 'ZWLT',  'Lyntupy' ],
	[ 'XFLPD', 'Lyon Part-Dieu' ],
	[ 'XFLBO', 'Lyon-Brotteaux' ],
	[ 'XFLG',  'Lyon-Guillotiere' ],
	[ 'XFLP',  'Lyon-Perrache' ],
	[ 'XFLSC', 'Lyon-St-Clair' ],
	[ 'XTLY',  'Lysa n Labem' ],
	[ 'XCID',  'lzdeshkovo' ],
	[ 'XAL K', 'Lz-Kleinmünchen' ],
	[ 'KMCP',  'M Industriepark' ],
	[ 'RMR W', 'Ma Rbf Westeinf' ],
	[ 'AMSB',  'Maasbüll' ],
	[ 'XNMA',  'Maassluis' ],
	[ 'XNMT',  'Maastricht' ],
	[ 'XNRVO', 'Maasvlakte Oost' ],
	[ 'XNRVW', 'Maasvlakte West' ],
	[ 'FMAB',  'Maberzell' ],
	[ 'ZUMA',  'Maceev' ],
	[ 'LMAC',  'Machern (Sachs)' ],
	[ 'LMAU',  'Machern Üst' ],
	[ 'XTMC',  'Machnin' ],
	[ 'XTMR',  'Machnin hrad' ],
	[ 'XFMCV', 'Macon Ville' ],
	[ 'XFMAL', 'Macon-Loche-TGV' ],
	[ 'XIMDD', 'Maddalene' ],
	[ 'XIMDP', 'Madonna d Pil' ],
	[ 'XEMAT', 'Madrid Atocha' ],
	[ 'XEMC',  'Madrid Chamartin' ],
	[ 'RMFS',  'Ma-Friedr Süd Hp' ],
	[ 'LM',    'Magdeburg Hbf' ],
	[ 'LMSO',  'Magdeburg Südost' ],
	[ 'LMB',   'Magdeburg-Buckau' ],
	[ 'LMSA',  'Magdeburg-Salbke' ],
	[ 'LMAE',  'Mägdesprung' ],
	[ 'XIMGT', 'Magenta' ],
	[ 'TMGK',  'Mägerkingen' ],
	[ 'XIMCM', 'Magliano-Crava' ],
	[ 'TMAG',  'Magstadt' ],
	[ 'BMAH',  'Mahlow' ],
	[ 'LMW',   'Mahlwinkel' ],
	[ 'XCMC',  'Maiachnaia' ],
	[ 'TMAI',  'Maichingen' ],
	[ 'TMIN',  'Maichingen Nord' ],
	[ 'TMIU',  'Maichingen Üst' ],
	[ 'XSMF',  'Maienfeld' ],
	[ 'RMKI',  'Maikammer-Kirrw.' ],
	[ 'FMAS',  'Mainaschaff' ],
	[ 'FMAA',  'Mainaschaff Abzw' ],
	[ 'NMM',   'Mainbernheim' ],
	[ 'NML',   'Mainleus' ],
	[ 'FMST',  'Main-Neckar-Br' ],
	[ 'NMRH',  'Mainroth' ],
	[ 'FHD',   'Maintal Ost' ],
	[ 'FBMR',  'Maintal West' ],
	[ 'FMZ G', 'Mainz Gbf' ],
	[ 'FMZ',   'Mainz Hbf' ],
	[ 'FMN',   'Mainz Nord' ],
	[ 'FMZ A', 'Mainz Pbf/Gbf' ],
	[ 'FQMS',  'Mainz Süd RP/HE' ],
	[ 'FMLA',  'Mainzer Landstr' ],
	[ 'FMGO',  'Mainz-Gonsenheim' ],
	[ 'FMK',   'Mainz-Kastel' ],
	[ 'FMAI',  'Mainzlar' ],
	[ 'FMDW',  'Mainzlar Didierw' ],
	[ 'FML',   'Mainz-Laubenheim' ],
	[ 'FMMB',  'Mainz-Marienborn' ],
	[ 'FMM',   'Mainz-Mombach' ],
	[ 'MMA',   'Maisach' ],
	[ 'MMA A', 'Maisach Abzw' ],
	[ 'XAMS',  'Maishfn-Saalbach' ],
	[ 'XOMJ',  'Majavatn' ],
	[ 'ZUMKP', 'Makeevka-Pass' ],
	[ 'XMMK',  'Maklar' ],
	[ 'XRMM',  'Maksimir' ],
	[ 'XTMV',  'Mala Velen' ],
	[ 'XYMA',  'Malacky' ],
	[ 'XPM',   'Malaszewicze' ],
	[ 'XPMA',  'Malbork' ],
	[ 'WMA',   'Malchin' ],
	[ 'MMAG',  'Malching/Obb' ],
	[ 'WMAL',  'Malchow (Meckl)' ],
	[ 'WMAB',  'Malchow Bauhof' ],
	[ 'XPMAL', 'Malczyce' ],
	[ 'XPMD',  'Maldyty' ],
	[ 'XYMS',  'Male Straciny' ],
	[ 'XTMS',  'Male Svatanovice' ],
	[ 'XEMA',  'Malgrat' ],
	[ 'MMD',   'Mallersdorf' ],
	[ 'XAMO',  'Mallnitz-Oberv.' ],
	[ 'XVMB',  'Malmbäck' ],
	[ 'XVM',   'Malmö' ],
	[ 'XVMG',  'Malmö Godsban' ],
	[ 'XDMS',  'Malmö Skepsbron' ],
	[ 'TMAL',  'Malmsheim' ],
	[ 'RMS',   'Malsch' ],
	[ 'RMSU',  'Malsch Süd' ],
	[ 'FBEF',  'Malsf-Beiseförth' ],
	[ 'FMFH',  'Malsfeld' ],
	[ 'MGL',   'Malteurop' ],
	[ 'XLMR',  'Mamer' ],
	[ 'XLMY',  'Mamer Lycee' ],
	[ 'MMAM',  'Mammendorf' ],
	[ 'XSMM',  'Mammern(Bodens)' ],
	[ 'XSMMS', 'Mammern(Bodens)S' ],
	[ 'XCMA',  'Mamonowo' ],
	[ 'XCXMA', 'Mamonowo Gr PL' ],
	[ 'XBMA',  'Manage' ],
	[ 'MMNG',  'Manching' ],
	[ 'FMAN',  'Mandern' ],
	[ 'UMCH',  'Manebach' ],
	[ 'NMG',   'Mangolding' ],
	[ 'NMDF',  'Manndorf' ],
	[ 'XSMB',  'Mannenbach' ],
	[ 'XSMBS', 'Mannenbach S' ],
	[ 'EMMB',  'Mannesmann' ],
	[ 'RMHH',  'Mannh Handelshf' ],
	[ 'RMIH',  'Mannh Indus-hf' ],
	[ 'RMR D', 'Mannh Rbf Gr D' ],
	[ 'RMR E', 'Mannh Rbf Gr E' ],
	[ 'RMR G', 'Mannh Rbf Gr G' ],
	[ 'RMR K', 'Mannh Rbf Gr K' ],
	[ 'RMR M', 'Mannh Rbf Gr M' ],
	[ 'RMR N', 'Mannh Rbf Gr N' ],
	[ 'RMKO',  'Mannh.-K.O-rh.E.' ],
	[ 'RMKB',  'Mannh.Kurpfalzb.' ],
	[ 'RMNN',  'Mannh.Neuostheim' ],
	[ 'RMBN',  'Mannh.Oberrh.Ei.' ],
	[ 'RMSZ',  'Mannh.Sand.Zell.' ],
	[ 'RMAS',  'Mannh.-Sandhofen' ],
	[ 'RMW G', 'Mannh.Waldh. Gbf' ],
	[ 'RMWT',  'Mannh.-Wallstadt' ],
	[ 'RM',    'Mannheim Hbf' ],
	[ 'RM O',  'Mannheim Hbf Ost' ],
	[ 'RMG',   'Mannheim Hgbf' ],
	[ 'RMR',   'Mannheim Rbf' ],
	[ 'RMHB',  'Mannheim RHB' ],
	[ 'RMA',   'Mannheim-Rheinau' ],
	[ 'RMW',   'Mannheim-Waldhof' ],
	[ 'RMKL',  'Mannh-Käfertal' ],
	[ 'RMLB',  'Mannh-Luzenberg' ],
	[ 'RMNS',  'Mannh-Neckarst' ],
	[ 'RMSN',  'Mannh-Seckenh.Bf' ],
	[ 'RMSE',  'Mannh-Seckenheim' ],
	[ 'XVMN',  'Mansarp' ],
	[ 'LMAS',  'Mansfeld (Südh)' ],
	[ 'XLMN',  'Manternach' ],
	[ 'XIMAF', 'Mantova Frassine' ],
	[ 'XVMT',  'Mantrop' ],
	[ 'ZIMJ',  'Manulla Jtn' ],
	[ 'XCMR',  'Maramzino' ],
	[ 'TMBM',  'Marbach (b Müns)' ],
	[ 'TMB',   'Marbach (Neckar)' ],
	[ 'RMBO',  'Marbach Ost' ],
	[ 'RMBW',  'Marbach West' ],
	[ 'FMR',   'Marbach/Fulda' ],
	[ 'EMHD',  'Marbeck-Heiden' ],
	[ 'FMBG',  'Marburg (Lahn)' ],
	[ 'FMBS',  'Marburg Süd' ],
	[ 'XAMG',  'Marchegg' ],
	[ 'XBMD',  'Marche-les-Dames' ],
	[ 'XBMP',  'Marchienne-au-P' ],
	[ 'XAMR',  'Marchtrenk' ],
	[ 'XIMAR', 'Marcianise' ],
	[ 'XYMC',  'Margecany' ],
	[ 'MMRN',  'Maria Rain' ],
	[ 'TMAB',  'Mariaberg' ],
	[ 'KMAG',  'Mariagrube' ],
	[ 'XVMR',  'Mariannelund' ],
	[ 'XTML',  'Marianske Lazne' ],
	[ 'EMV',   'Maria-Veen' ],
	[ 'XZM',   'Maribor' ],
	[ 'DMG',   'Marienberg (S)' ],
	[ 'XOTM',  'Marienborg' ],
	[ 'LMBN',  'Marienborn' ],
	[ 'EMFD',  'Marienfeld/Westf' ],
	[ 'HMAR',  'Marienhafe' ],
	[ 'KMAH',  'Marienheide' ],
	[ 'HMAS',  'Mariensiel' ],
	[ 'XVMA',  'Mariestad' ],
	[ 'ZLMJ',  'Marijampole' ],
	[ 'ZUMR',  'Mariupol' ],
	[ 'EMKE',  'Mark Elverlings' ],
	[ 'RMAD',  'Markdorf (Baden)' ],
	[ 'LMAR',  'Marke' ],
	[ 'RMAR',  'Markelfingen' ],
	[ 'TMA',   'Markelsheim' ],
	[ 'DMAR',  'Markersbach (E)' ],
	[ 'LMA',   'Markkleeberg' ],
	[ 'LMAN',  'Markkleeberg N' ],
	[ 'LMAM',  'Markkleebg Mitte' ],
	[ 'LMAW',  'Markkleebg West' ],
	[ 'LMAG',  'Markkleebg-Grst' ],
	[ 'XMMR',  'Marko' ],
	[ 'HMKD',  'Markoldendorf' ],
	[ 'LMKS',  'Markranstädt' ],
	[ 'UML',   'Marksuhl' ],
	[ 'LLMK',  'Markt' ],
	[ 'NMB',   'Markt Bibart' ],
	[ 'NMEI',  'Markt Einersheim' ],
	[ 'NMER',  'Markt Erlbach' ],
	[ 'MIDR',  'Markt Indersdorf' ],
	[ 'MSB',   'Markt Schwaben' ],
	[ 'MMWD',  'Markt Wald' ],
	[ 'NMT',   'Marktbreit' ],
	[ 'UMG',   'Marktgölitz' ],
	[ 'MMK',   'Marktl' ],
	[ 'NMH',   'Marktleuthen' ],
	[ 'MMOS',  'Marktobd Schule' ],
	[ 'MMO',   'Marktoberdorf' ],
	[ 'NMR',   'Marktredwitz' ],
	[ 'NMSG',  'Marktschorgast' ],
	[ 'XTMVE', 'Markvartice' ],
	[ 'EMAM',  'Marl Mitte' ],
	[ 'TMRL',  'Marlach' ],
	[ 'XFMSS', 'Marle-sur-Serre' ],
	[ 'EMHM',  'Marl-Hamm' ],
	[ 'UMAH',  'Marlishausen' ],
	[ 'XBMR',  'Marloie' ],
	[ 'EMSI',  'Marl-Sinsen' ],
	[ 'XOMD',  'Marnardal' ],
	[ 'XFMVC', 'Marne la Vallee' ],
	[ 'FMHM',  'Marnheim' ],
	[ 'NMAR',  'Maroldsweisach' ],
	[ 'EMAR',  'Marsberg' ],
	[ 'TKNM',  'Marschall' ],
	[ 'XFMBL', 'Marseille Blanc' ],
	[ 'XFM',   'Marseille-St-Ch' ],
	[ 'XDMA',  'Marslev' ],
	[ 'TMAR',  'Marstetten-Aitr.' ],
	[ 'WMTF',  'Martensdorf' ],
	[ 'XNMH',  'Martenshoek' ],
	[ 'XSMA',  'Martigny' ],
	[ 'XFMAG', 'Martigues' ],
	[ 'NMLZ',  'Martinlamitz' ],
	[ 'UMT',   'Martinroda' ],
	[ 'SMSO',  'Martinstein Ost' ],
	[ 'SMSW',  'Martinstein West' ],
	[ 'XAMA',  'Martinswand' ],
	[ 'MMSZ',  'Martinszell/Allg' ],
	[ 'XMMV',  'Martonvasar' ],
	[ 'XEML',  'Martorell' ],
	[ 'XSMW',  'Märwil' ],
	[ 'NMX',   'Marxgrün' ],
	[ 'RMX',   'Marxzell' ],
	[ 'MMZG',  'Marzling' ],
	[ 'AQM',   'Maschen 1255' ],
	[ 'AQM G', 'Maschen 1280' ],
	[ 'AMA',   'Maschen Pbf' ],
	[ 'AM',    'Maschen Rbf' ],
	[ 'AM O',  'Maschen Rbf Mnof' ],
	[ 'AM N',  'Maschen Rbf Mnwf' ],
	[ 'AM S',  'Maschen Rbf Msof' ],
	[ 'AM W',  'Maschen Rbf Mswf' ],
	[ 'XIMAS', 'Maschio' ],
	[ 'XIMAC', 'Massa Centro' ],
	[ 'EMAN',  'Massen' ],
	[ 'MMSG',  'Massing' ],
	[ 'KKBM',  'Mastlager' ],
	[ 'XMMZ',  'Mateszalka' ],
	[ 'EMAF',  'Mathilde' ],
	[ 'XAM',   'Matrei' ],
	[ 'NMAH',  'Matting Ausweich' ],
	[ 'MMTZ',  'Matzing' ],
	[ 'TMAU',  'Maubach' ],
	[ 'XFMB',  'Maubeuge' ],
	[ 'RMAU',  'Mauer (Heidelbg)' ],
	[ 'TMWA',  'Maulbr West AVG' ],
	[ 'TMBS',  'Maulbronn' ],
	[ 'TMWG',  'Maulbronn DB/AVG' ],
	[ 'TMW',   'Maulbronn West' ],
	[ 'RMLG',  'Maulburg' ],
	[ 'XLML',  'Maulusmuhle' ],
	[ 'NMSM',  'Mausheim' ],
	[ 'XAMT',  'Mautern' ],
	[ 'RQMW',  'Ma-Waldhof LGr' ],
	[ 'RMAL',  'Max Eisenbahnstr' ],
	[ 'RMAI',  'Max Im Rüsten' ],
	[ 'RMAX',  'Maxau' ],
	[ 'RMXU',  'Maxau DB/VBK' ],
	[ 'RMDR',  'Maxdorf' ],
	[ 'RMDS',  'Maxdorf Süd' ],
	[ 'NDIW',  'Maxhütte-H D W' ],
	[ 'NMXH',  'Maxhütte-Haidhof' ],
	[ 'RQMA',  'Maximilian LGr' ],
	[ 'EMAL',  'Maximilianpark' ],
	[ 'RMAW',  'Maximiliansau W' ],
	[ 'XAMX',  'Maxing' ],
	[ 'KMYO',  'Mayen Ost' ],
	[ 'KMYW',  'Mayen West' ],
	[ 'XAMY',  'Mayrhofen' ],
	[ 'KMAY',  'Mayschoß' ],
	[ 'KMBO',  'M\'busch-Osterath' ],
	[ 'HMAH',  'Mdn Abstieghafen' ],
	[ 'HOHF',  'Mdn Osthafen' ],
	[ 'HWHM',  'Mdn Westhafen' ],
	[ 'XXME',  'Mealhada' ],
	[ 'KMCD',  'Mech Mülldep' ],
	[ 'LMU',   'Mechau' ],
	[ 'XBMCH', 'Mechelen' ],
	[ 'XLME',  'Mecher' ],
	[ 'KMCH',  'Mechernich' ],
	[ 'KMCW',  'Mechernich West' ],
	[ 'UME',   'Mechterstädt' ],
	[ 'UMS',   'Mechterst-Sätt' ],
	[ 'AMD',   'Meckelfeld' ],
	[ 'AMDH',  'Meckelfeld Hp' ],
	[ 'AQMD',  'Meckelfeld NI/HH' ],
	[ 'TMK',   'Meckenbeuren' ],
	[ 'KMCK',  'Meckenheim' ],
	[ 'KMCM',  'Meckenheim-Merl' ],
	[ 'RMK',   'Meckesheim' ],
	[ 'FME',   'Mecklar' ],
	[ 'EMEK',  'Mecklenbeck' ],
	[ 'BMZ',   'Medewitz (Mark)' ],
	[ 'BQMZ',  'Medewitz LGr' ],
	[ 'XUMG',  'Medgidia' ],
	[ 'XUM',   'Medias' ],
	[ 'XEME',  'Medina del Campo' ],
	[ 'XCMG',  'Mednogorsk' ],
	[ 'BDW',   'Med\'st Babelsbg' ],
	[ 'XPME',  'Medyka' ],
	[ 'NMEE',  'Meeder' ],
	[ 'DMA',   'Meerane' ],
	[ 'DQMA',  'Meerane SN/TH' ],
	[ 'KMBK',  'Meerbeck' ],
	[ 'KMEE',  'Meerbeck Abzw' ],
	[ 'XBMH',  'Meerhout' ],
	[ 'AMSS',  'Meeschensee' ],
	[ 'HMEH',  'Mehle' ],
	[ 'DMEH',  'Mehltheuer' ],
	[ 'EMHO',  'Mehrhoog' ],
	[ 'BMEA',  'Mehrower Allee' ],
	[ 'AMR',   'Meimersdorf' ],
	[ 'AMRO',  'Meimersdorf Ost' ],
	[ 'XIMEA', 'Meina' ],
	[ 'HMEI',  'Meine' ],
	[ 'DMS',   'Meinersdorf (E)' ],
	[ 'HMRS',  'Meinersen' ],
	[ 'EMZH',  'Meinerzhagen' ],
	[ 'UM',    'Meiningen' ],
	[ 'LMEI',  'Meinsdorf' ],
	[ 'XSM',   'Meiringen' ],
	[ 'DME',   'Meißen' ],
	[ 'DMEA',  'Meißen Altstadt' ],
	[ 'DMTG',  'Meißen Tri DB-Gr' ],
	[ 'DMT',   'Meißen Trieb' ],
	[ 'ZTM',   'Meitene' ],
	[ 'MMEI',  'Meitingen' ],
	[ 'LME',   'Meitzendorf' ],
	[ 'FMLB',  'Melbach' ],
	[ 'HMEM',  'Melbeck-Embsen' ],
	[ 'WMCH',  'Melchow' ],
	[ 'AMFU',  'Meldorf' ],
	[ 'AMF',   'Meldorf Hp' ],
	[ 'XIMEL', 'Mele' ],
	[ 'XOMS',  'Melhus' ],
	[ 'ZUMP',  'Melitopol' ],
	[ 'XAME',  'Melk' ],
	[ 'NMEL',  'Melkendorf' ],
	[ 'HMEL',  'Melle' ],
	[ 'UMEL',  'Mellenbach-Glasb' ],
	[ 'HMDF',  'Mellendorf' ],
	[ 'XVME',  'Mellerud' ],
	[ 'XSMEL', 'Mellingen' ],
	[ 'UMEN',  'Mellingen (Thür)' ],
	[ 'NQME',  'Mellrichst LGr' ],
	[ 'NME',   'Mellrichstadt Bf' ],
	[ 'XTME',  'Melnik' ],
	[ 'XSMS',  'Mels' ],
	[ 'AME',   'Melsdorf' ],
	[ 'FMLS',  'Melsungen' ],
	[ 'XFMEL', 'Melun' ],
	[ 'XIME',  'Melzo' ],
	[ 'MM',    'Memmingen' ],
	[ 'XFMF',  'Menchhoffen' ],
	[ 'EMED',  'Menden' ],
	[ 'KMD',   'Menden (Rheinl)' ],
	[ 'EMDG',  'Menden DB-Gr' ],
	[ 'EMEU',  'Menden Süd' ],
	[ 'KNME',  'Mendig' ],
	[ 'XSME',  'Mendrisio' ],
	[ 'TMG',   'Mengen' ],
	[ 'TMGG',  'Mengen DB/AB' ],
	[ 'FMGH',  'Mengeringhausen' ],
	[ 'UMGH',  'Mengersg-Hämm' ],
	[ 'UMHO',  'Mengers-Häm Ost' ],
	[ 'NMTH',  'Mengersreuth' ],
	[ 'XFME',  'Menton' ],
	[ 'KMZ',   'Menzelen West' ],
	[ 'WMEF',  'Menzendorf' ],
	[ 'RMZN',  'Menzingen(Baden)' ],
	[ 'XSMEN', 'Menznau' ],
	[ 'HMEP',  'Meppen' ],
	[ 'HMEE',  'Meppen Emshafen' ],
	[ 'HRWA',  'Meppen RWE' ],
	[ 'HMES',  'Meppen Süd' ],
	[ 'XOMK',  'Meraker' ],
	[ 'XIMER', 'Merana' ],
	[ 'XIMM',  'Merano/Meran' ],
	[ 'RDAI',  'Mercedes Benz' ],
	[ 'MMEG',  'Merching' ],
	[ 'XBMER', 'Merchtem' ],
	[ 'SMER',  'Merchweiler' ],
	[ 'XBME',  'Merelbeke' ],
	[ 'XIMGZ', 'Mergozzo' ],
	[ 'MMR',   'Mering' ],
	[ 'MMRU',  'Mering Üst' ],
	[ 'MSAF',  'Mering-St Afra' ],
	[ 'XLMK',  'Merkholtz' ],
	[ 'TBLM',  'Merkle' ],
	[ 'EMES',  'Mersch' ],
	[ 'XLM',   'Mersch' ],
	[ 'LMG',   'Merseburg' ],
	[ 'LMGB',  'Merseburg Bergm' ],
	[ 'LMG G', 'Merseburg Gbf' ],
	[ 'LMEH',  'Merseburg-Elis' ],
	[ 'KMT',   'Merten' ],
	[ 'KMES',  'Merten (Sieg)' ],
	[ 'UMD',   'Mertendorf' ],
	[ 'XLMT',  'Mertert' ],
	[ 'XLMP',  'Mertert-Port' ],
	[ 'RME',   'Mertesheim' ],
	[ 'MMTG',  'Mertingen Bf' ],
	[ 'XFMEV', 'Merville' ],
	[ 'XFMEH', 'Merxheim' ],
	[ 'BMZG',  'Merzdorf DB-Gr' ],
	[ 'YBBMZ', 'Merzdorf Strw' ],
	[ 'KMZH',  'Merzenhausen' ],
	[ 'KMEZ',  'Merzenich' ],
	[ 'KMEU',  'Merzenich Üst' ],
	[ 'SMZG',  'Merzig (Saar)' ],
	[ 'SMZM',  'Merzig(S)Stadtm' ],
	[ 'EMSD',  'Meschede' ],
	[ 'HWUM',  'Mesmerode' ],
	[ 'LMF',   'Meßdorf' ],
	[ 'BMN',   'Messe Nord/ICC' ],
	[ 'BMS',   'Messe Süd' ],
	[ 'FMES',  'Messel' ],
	[ 'XFMES', 'Messempre' ],
	[ 'XAMD',  'Messendorf' ],
	[ 'XIMN',  'Messina C' ],
	[ 'XIMNM', 'Messina Maritt' ],
	[ 'XXMA',  'Messines-Alte' ],
	[ 'EMSN',  'Messinghausen' ],
	[ 'RMSS',  'Meßkirch' ],
	[ 'XTMA',  'Mest Albrechtice' ],
	[ 'XUMS',  'Mestecanis' ],
	[ 'XIMT',  'Metaponto' ],
	[ 'EMTE',  'Metelen Land' ],
	[ 'XNME',  'Meteren B r' ],
	[ 'XRME',  'Metkovic' ],
	[ 'NMET',  'Metten Bf' ],
	[ 'FMET',  'Mettenheim' ],
	[ 'TMTL',  'Mettertal' ],
	[ 'HMET',  'Mettingen (W)' ],
	[ 'SMT',   'Mettlach' ],
	[ 'KME',   'Mettmann St Wald' ],
	[ 'KMEW',  'Mettmann Zentrum' ],
	[ 'XFMZ',  'Metz Chambiere' ],
	[ 'XFMZN', 'Metz NAN' ],
	[ 'XFMS',  'Metz Sablon' ],
	[ 'TME',   'Metzingen(Württ)' ],
	[ 'TNHU',  'Metzingen-Neuh' ],
	[ 'TMEG',  'Metzingn DB/ENAG' ],
	[ 'XFMZV', 'Metz-Ville' ],
	[ 'FMEU',  'Meudt (Westerw)' ],
	[ 'FMEV',  'Meudt(Ww) V&B II' ],
	[ 'XFMU',  'Meuse' ],
	[ 'UMEU',  'Meuselbach-Schw' ],
	[ 'BMEX',  'Mexikoplatz' ],
	[ 'WME',   'Meyenburg' ],
	[ 'WQME',  'Meyenburg BB/MV' ],
	[ 'XWMZ',  'Mezdra' ],
	[ 'XMMY',  'Mezöbereny' ],
	[ 'XMMP',  'Mezöpeterd' ],
	[ 'XMME',  'Mezötur' ],
	[ 'XMMB',  'Mezözombor' ],
	[ 'XIMZ',  'Mezzocorona' ],
	[ 'RMFE',  'M-Fr Südein/Ausf' ],
	[ 'RMF',   'M-Friedrichsfeld' ],
	[ 'LMTW',  'Mg SKET Ind-park' ],
	[ 'LM S',  'Mg Südseite' ],
	[ 'LGW',   'M-Gaschwitz' ],
	[ 'LMB B', 'Mg-Buckau Bbf' ],
	[ 'LMEU',  'Mg-Eichenw Üst' ],
	[ 'LMGE',  'Mg-Eichenweiler' ],
	[ 'LMB F', 'Mg-Fermersleben' ],
	[ 'KMGE',  'MG-Genhausen' ],
	[ 'LMGH',  'Mg-Hasselbachpl' ],
	[ 'LMHR',  'Mg-Herrenkrug' ],
	[ 'KM G',  'M\'gladb Gbf' ],
	[ 'KM',    'M\'gladbach Hbf' ],
	[ 'KML',   'MG-Lürrip' ],
	[ 'LMN',   'Mg-Neustadt' ],
	[ 'KMR',   'MG-Rheindahlen' ],
	[ 'LMR',   'Mg-Rothensee' ],
	[ 'LMRH',  'Mg-Rothensee Hp' ],
	[ 'LMR F', 'Mg-Rothensee Rmf' ],
	[ 'LMS',   'Mg-Sudenburg' ],
	[ 'EMHI',  'MHI' ],
	[ 'RMR A', 'Mhm Maimarkt Bft' ],
	[ 'RMSM',  'Mhm Maimarkt Hp' ],
	[ 'RMN',   'Mhm-Neckarau' ],
	[ 'EMRS',  'Mh-Speldorf' ],
	[ 'EMRY',  'Mh-Styrum' ],
	[ 'EMRYA', 'Mh-Styrum West' ],
	[ 'LMIN',  'Michaelstein' ],
	[ 'XLMC',  'Michelau' ],
	[ 'TMIC',  'Michelau (Württ)' ],
	[ 'NMI',   'Michelau(Oberfr)' ],
	[ 'NMIK',  'Michelaubrück' ],
	[ 'FMICH', 'Michelb Herrnm' ],
	[ 'FMIC',  'Michelbach (Ufr)' ],
	[ 'SMI',   'Michelbach(Saar)' ],
	[ 'XAMI',  'Micheldorf' ],
	[ 'FMIR',  'Michelsrombach' ],
	[ 'FMI',   'Michelstadt' ],
	[ 'BMIP',  'Michendorf' ],
	[ 'XCMU',  'Michurinsk' ],
	[ 'XDMF',  'Middelfart' ],
	[ 'TMST',  'Miedelsbach-Stbg' ],
	[ 'XPMDW', 'Miedwiecko' ],
	[ 'XPMZD', 'Miedzychod' ],
	[ 'XPMY',  'Miedzylesie' ],
	[ 'XPMZ',  'Miedzyzdroje' ],
	[ 'XPMIE', 'Miekinia' ],
	[ 'XPMC',  'Mielec' ],
	[ 'XUMC',  'Miercurea Ciuc' ],
	[ 'MMIB',  'Miesbach' ],
	[ 'SRAM',  'Miesenbach' ],
	[ 'KMIE',  'Miesenheim' ],
	[ 'LMST',  'Mieste' ],
	[ 'LMT',   'Miesterhorst' ],
	[ 'XIMGG', 'Mignanego' ],
	[ 'XPMI',  'Mikolajki' ],
	[ 'XTMD',  'Mikulasovice d n' ],
	[ 'XTMK',  'Mikulovice' ],
	[ 'XIMB',  'Milano C' ],
	[ 'XIMC',  'Milano Certosa' ],
	[ 'XIMF',  'Milano Farini' ],
	[ 'XIMG',  'Milano Greco P' ],
	[ 'XIML',  'Milano Lambrate' ],
	[ 'XIMV',  'Milano P Vittori' ],
	[ 'XIMP',  'Milano PG' ],
	[ 'XIMPP', 'Milano PG pass' ],
	[ 'XIMR',  'Milano Rogoredo' ],
	[ 'XIMSV', 'Milano S Villapi' ],
	[ 'XIMSC', 'Milano S.Cristof' ],
	[ 'XIMS',  'Milano Smistam' ],
	[ 'XIMI',  'Milazzo' ],
	[ 'EMIK',  'Milke' ],
	[ 'XCMI',  'Millerovo' ],
	[ 'EMIL',  'Millingen' ],
	[ 'KMIL',  'Millingen' ],
	[ 'KMILG', 'Millingen Gbf' ],
	[ 'WMF',   'Milmersdorf' ],
	[ 'XBMM',  'Milmort' ],
	[ 'XTMI',  'Milostin' ],
	[ 'XPMIL', 'Milowka' ],
	[ 'NMLT',  'Miltach' ],
	[ 'NM',    'Miltenberg' ],
	[ 'NM W',  'Miltenberg West' ],
	[ 'LMI',   'Miltern' ],
	[ 'LMIA',  'Miltitzer Allee' ],
	[ 'DMI',   'Miltitz-Roitzsch' ],
	[ 'WMI',   'Miltzow' ],
	[ 'LMIL',  'Milzau' ],
	[ 'NMIM',  'Mimberg' ],
	[ 'XTMM',  'Mimon' ],
	[ 'MMAH',  'Mindelaltheim' ],
	[ 'MMH',   'Mindelheim' ],
	[ 'HM',    'Minden (Westf)' ],
	[ 'HMNF',  'Minden Fr-Wilh-S' ],
	[ 'HM G',  'Minden Gbf' ],
	[ 'HMHF',  'Minden Industrhf' ],
	[ 'HMKT',  'Minden Königstor' ],
	[ 'HQM',   'Minden NI/NRW' ],
	[ 'HMNO',  'Minden Oberstadt' ],
	[ 'HMST',  'Minden Stadt' ],
	[ 'HMAM',  'Minden-Aminghaus' ],
	[ 'XAMN',  'Mining' ],
	[ 'XPMM',  'Minsk Mazow' ],
	[ 'ZWM',   'Minsk-Passajirsk' ],
	[ 'XEMB',  'Mirabel' ],
	[ 'XFMI',  'Miramas' ],
	[ 'XIMA',  'Mirandola' ],
	[ 'ZUMN',  'Mironovka' ],
	[ 'WMIR',  'Mirow' ],
	[ 'XIMIA', 'Misano Adriatico' ],
	[ 'HMI',   'Misburg' ],
	[ 'XMMT',  'Miskolc-Tiszai' ],
	[ 'WMIS',  'Mistorf' ],
	[ 'XCMF',  'Mitrofanovka' ],
	[ 'RDOM',  'Mitte/Siedlung' ],
	[ 'FMGD',  'Mittel Gründau' ],
	[ 'DMHD',  'Mittelherwsdf Sa' ],
	[ 'DMDF',  'Mittelndorf' ],
	[ 'DMST',  'Mitteloelsnitz' ],
	[ 'UMSK',  'Mittelschmalkald' ],
	[ 'NMSN',  'Mittelsinn' ],
	[ 'BMIO',  'Mittenw(Mark)Ost' ],
	[ 'MMW',   'Mittenwald' ],
	[ 'MXM',   'Mittenwald Gr' ],
	[ 'WMDE',  'Mittenwalde bTem' ],
	[ 'MMTA',  'Mitteralm' ],
	[ 'XAMH',  'Mitterberghütten' ],
	[ 'XAMV',  'Mitterdf-Veitsch' ],
	[ 'MMIG',  'Mittergars' ],
	[ 'NMIT',  'Mitterteich' ],
	[ 'AML',   'Mittl Landweg' ],
	[ 'DMW',   'Mittweida' ],
	[ 'BMX',   'Mixdorf' ],
	[ 'XAMIX', 'Mixnitz-Bärensch' ],
	[ 'XVMJ',  'Mjölby' ],
	[ 'XTMB',  'Ml Boleslav hl n' ],
	[ 'XTMBM', 'Ml Boleslav Mest' ],
	[ 'XTMBD', 'Ml Boleslav-Debr' ],
	[ 'XJML',  'Mladenovac' ],
	[ 'XPML',  'Mlawa' ],
	[ 'XPMN',  'Mlynary' ],
	[ 'XTMY',  'Mlyny (CZ)' ],
	[ 'XOMR',  'Mo i Rana' ],
	[ 'BMOAO', 'Moabit Ost' ],
	[ 'FAMO',  'Mo-Altmorschen' ],
	[ 'HWMG',  'Mobil Oil DB-Gr' ],
	[ 'TMO',   'Mochenwangen' ],
	[ 'LMOE',  'Möckern (b Mg)' ],
	[ 'TML',   'Möckmühl' ],
	[ 'LMRN',  'Mockrehna' ],
	[ 'XFMOD', 'Modane' ],
	[ 'XIMD',  'Modena' ],
	[ 'XOME',  'Moelv' ],
	[ 'XNMD',  'Moerdijk' ],
	[ 'KMO',   'Moers' ],
	[ 'KMO G', 'Moers Gbf' ],
	[ 'KMOK',  'Moers Kreisb' ],
	[ 'KMON',  'Moers Nord' ],
	[ 'LMGI',  'Mögelin' ],
	[ 'TMOE',  'Mögglingen b Gm' ],
	[ 'ZWMO',  'Mogilev' ],
	[ 'XPMG',  'Mogilno' ],
	[ 'TMLK',  'Möglingen/Kocher' ],
	[ 'XSMI',  'Möhlin' ],
	[ 'TMHR',  'Möhring Rathaus' ],
	[ 'TMHB',  'Möhringen Bf' ],
	[ 'XOM',   'Moi' ],
	[ 'WMOI',  'Moidentin' ],
	[ 'XCMJ',  'Mojaisk' ],
	[ 'XBML',  'Mol' ],
	[ 'XIMOB', 'Mola di Bari' ],
	[ 'XIMLE', 'Molare' ],
	[ 'XIMO',  'Molfetta' ],
	[ 'XVML',  'Mollaryd' ],
	[ 'EMOE',  'Möllen' ],
	[ 'LQMO',  'Mollgraben LGr' ],
	[ 'AMLN',  'Mölln (Lauenb)' ],
	[ 'WMOE',  'Mölln (Meckl)' ],
	[ 'XVMD',  'Mölndal' ],
	[ 'XVMY',  'Mölnlycke' ],
	[ 'XSMOS', 'Mols' ],
	[ 'XIM',   'Molteno' ],
	[ 'RMZ',   'Molzau' ],
	[ 'XIMMR', 'Mombaldone-Roc' ],
	[ 'XIMBZ', 'Mombaruzzo' ],
	[ 'FMOE',  'Mömbris-Menseng' ],
	[ 'XFMH',  'Mommenheim' ],
	[ 'XFMC',  'Monaco-M.Carlo' ],
	[ 'TMON',  'Monb-Neuhausen' ],
	[ 'XIMCI', 'Moncalieri' ],
	[ 'XIMCV', 'Moncalvo' ],
	[ 'XBMC',  'Monceau' ],
	[ 'WMN',   'Mönchhagen' ],
	[ 'FMOH',  'Mönchhof' ],
	[ 'NMOE',  'Mönchröden' ],
	[ 'FMOW',  'Mönchwald' ],
	[ 'KMOD',  'Mondorf (Siegkr)' ],
	[ 'XIMDV', 'Mondovi' ],
	[ 'XIMOF', 'Monfalcone' ],
	[ 'XIMGO', 'Mongardino' ],
	[ 'XIMW',  'Monguelfo/Welsbg' ],
	[ 'KMHR',  'Monheim (Rhl)' ],
	[ 'KMOB',  'Monheim Blee' ],
	[ 'KMHN',  'Monheim Nord' ],
	[ 'XIMON', 'Monopoli' ],
	[ 'SML',   'Monreal' ],
	[ 'XBMS',  'Mons' ],
	[ 'XBMO',  'Monschau' ],
	[ 'FMSH',  'Monsheim' ],
	[ 'XVMS',  'Monsteras' ],
	[ 'XFMM',  'Mont St. Martin' ],
	[ 'FMT',   'Montabaur' ],
	[ 'FMTN',  'Montabaur(Regio)' ],
	[ 'XFMD',  'Montbeliard' ],
	[ 'XIMCA', 'Montechiaro d\'A' ],
	[ 'XIMCD', 'Montechiaro-Den' ],
	[ 'XIMGS', 'Montegrosso' ],
	[ 'XFMN',  'Montelimar' ],
	[ 'XIMRO', 'Monterosso' ],
	[ 'XIMNP', 'Monteu da Po' ],
	[ 'XSMY',  'Monthey' ],
	[ 'XIMLA', 'Monticello d\'A' ],
	[ 'XIMTM', 'Montiglio-Mur' ],
	[ 'XFMLV', 'Montlucon Ville' ],
	[ 'XFMOM', 'Montmelian' ],
	[ 'XFMND', 'Mont-Notre-Dame' ],
	[ 'XFMOL', 'Montoire-s-l-L' ],
	[ 'XFMO',  'Montpellier' ],
	[ 'XSMO',  'Montreux' ],
	[ 'XBM',   'Montzen' ],
	[ 'XIMOZ', 'Monza' ],
	[ 'SMON',  'Monzingen' ],
	[ 'AMBH',  'Moorbekhalle' ],
	[ 'HMOD',  'Moordeich' ],
	[ 'RMOO',  'Moos' ],
	[ 'SMBT',  'Moosbachtal' ],
	[ 'XAMB',  'Moosbierbaum/H' ],
	[ 'MMB',   'Moosburg' ],
	[ 'MMRI',  'Moosrain' ],
	[ 'XMM',   'Mor' ],
	[ 'XPMO',  'Morag' ],
	[ 'XIMSP', 'Morano sul Po' ],
	[ 'XFMOR', 'Moret-Veneux' ],
	[ 'FMF',   'Mörfelden' ],
	[ 'XSMG',  'Morges' ],
	[ 'XFMOH', 'Morhange' ],
	[ 'LMGN',  'Möringen (Altm)' ],
	[ 'RMOE',  'Mörlenbach' ],
	[ 'NMOU',  'Morlesau' ],
	[ 'XVMO',  'Morrum' ],
	[ 'ZUMS',  'Morshin' ],
	[ 'AMM',   'Morsum (Sylt)' ],
	[ 'XIMOR', 'Mortara' ],
	[ 'RMO',   'Mosbach (Baden)' ],
	[ 'RMOW',  'Mosbach West' ],
	[ 'RNZ',   'Mosb-Neckarelz' ],
	[ 'FMOS',  'Moschheim' ],
	[ 'LBSS',  'Moschwig' ],
	[ 'DML',   'Mosel' ],
	[ 'SMK',   'Moselkern' ],
	[ 'LMOS',  'Möser' ],
	[ 'XOMN',  'Mosjoen' ],
	[ 'XCM',   'Moskva' ],
	[ 'XCMB',  'Moskva-Beloruss' ],
	[ 'LMOF',  'Mosolf' ],
	[ 'LMOG',  'Mosolf DB-Grenze' ],
	[ 'XMMO',  'Mosonmagyarovar' ],
	[ 'XOMO',  'Moss' ],
	[ 'TMS',   'Mössingen' ],
	[ 'XTMO',  'Most' ],
	[ 'XTMN',  'Most Nove Nadr' ],
	[ 'ZBM',   'Mostar Teretna' ],
	[ 'XTMT',  'Mostek' ],
	[ 'XTMH',  'Most-Herkules' ],
	[ 'ZUMO',  'Mostiska' ],
	[ 'XPMK',  'Mostki' ],
	[ 'XVMTA', 'Motala C' ],
	[ 'NMOT',  'Mottgers' ],
	[ 'NQMO',  'Mottgers HE/BY' ],
	[ 'MMTN',  'Möttingen' ],
	[ 'XAMTZ', 'Mötz' ],
	[ 'XFMOU', 'Mouchard' ],
	[ 'XFMSA', 'Moulins-s-Allier' ],
	[ 'XBMN',  'Mouscron' ],
	[ 'XBMT',  'Moustier' ],
	[ 'XSMU',  'Moutier' ],
	[ 'XFMT',  'Moutiers-Salins' ],
	[ 'XOMV',  'Movatn' ],
	[ 'HMOV',  'Mover' ],
	[ 'XFMG',  'Moyeuvre Grande' ],
	[ 'XPMR',  'Mragowo' ],
	[ 'FRFH',  'M-Röhrenf Ostbs' ],
	[ 'FRFHW', 'M-Röhrenf Westbs' ],
	[ 'XPMRZ', 'Mrozy' ],
	[ 'EABT',  'Mst-Albachten' ],
	[ 'EAML',  'Mst-Amelsbüren' ],
	[ 'XPMW',  'Mszczonow' ],
	[ 'EMUD',  'Mudersbach' ],
	[ 'MMDN',  'Mü Donnersbgbr' ],
	[ 'MAFB',  'Mü Friedenhei Br' ],
	[ 'MHAB',  'Mü Hackerbrücke' ],
	[ 'MHT',   'Mü Hbf tief' ],
	[ 'MH W',  'Mü Hbf Vorst.Süd' ],
	[ 'MHPW',  'Mü Heim Pl West' ],
	[ 'MHP',   'Mü Heimeranplatz' ],
	[ 'MMHG',  'Mü Hirschgarten' ],
	[ 'MIT',   'Mü Isartor' ],
	[ 'MKA',   'Mü Karlsplatz' ],
	[ 'MALS',  'Mü Landsbger Str' ],
	[ 'MLEF',  'Mü Leienfelsstr' ],
	[ 'MLEU',  'Mü Leuchtenberg' ],
	[ 'MMP',   'Mü Marienplatz' ],
	[ 'MN B',  'Mü Nord Betrhof' ],
	[ 'MN D',  'Mü Nord Einf D' ],
	[ 'MN',    'Mü Nord Rbf' ],
	[ 'MN A',  'Mü Nord Rbf A' ],
	[ 'MN E',  'Mü Nord Rbf E' ],
	[ 'MN F',  'Mü Nord Rbf For' ],
	[ 'MN L',  'Mü Nord Rbf Las' ],
	[ 'MN M',  'Mü Nord Rbf Mi' ],
	[ 'MN R',  'Mü Nord Rbf Ri' ],
	[ 'MN T',  'Mü Nord Rbf Ri M' ],
	[ 'MN S',  'Mü Nord Rbf Ri S' ],
	[ 'MOP A', 'Mü O Abzw Freilh' ],
	[ 'MGIF',  'Mü O Frankenwstr' ],
	[ 'MOP L', 'Mü O Freiladehof' ],
	[ 'MOP H', 'Mü O Hultschistr' ],
	[ 'MOP R', 'Mü O Riedenb Str' ],
	[ 'MOP W', 'Mü O Wendeanlage' ],
	[ 'MRP',   'Mü Rosenheimerpl' ],
	[ 'MSW',   'Mü Siemenswerke' ],
	[ 'MMAR',  'Mü St-MartinStr' ],
	[ 'MBAA',  'Mü-Berg a L Abzw' ],
	[ 'MBAL',  'Mü-Berg a Laim' ],
	[ 'LMCH',  'Mücheln(Geiselt)' ],
	[ 'LMCZ',  'Mücheln-Stadt' ],
	[ 'BMC',   'Mücka' ],
	[ 'FMCK',  'Mücke (Hessen)' ],
	[ 'BMH',   'Mückenhain' ],
	[ 'SMD',   'Müden (Mosel)' ],
	[ 'HMUO',  'Müden (Örtze)' ],
	[ 'MEGS',  'Mü-Englschalk' ],
	[ 'MFAS',  'Mü-Fasanerie' ],
	[ 'MFG',   'Mü-Fasangarten' ],
	[ 'MFE',   'Mü-Feldmoching' ],
	[ 'MFHH',  'Mü-Freiham Hp' ],
	[ 'DMUE',  'Mügeln Bf' ],
	[ 'DMUES', 'Mügeln Stadt' ],
	[ 'TMRO',  'Mühla Rößlesweg' ],
	[ 'TM',    'Mühlacker' ],
	[ 'TM N',  'Mühlacker Em No' ],
	[ 'TM S',  'Mühlacker Em Süd' ],
	[ 'TM K',  'Mühlacker Kurve' ],
	[ 'LMUA',  'Mühlanger' ],
	[ 'DMHL',  'Mühlbach' ],
	[ 'FMBA',  'Mühlbach' ],
	[ 'NMUB',  'Mühlberg' ],
	[ 'LMUK',  'Mühlbg Kieswerk' ],
	[ 'MMF',   'Mühldorf/Obb' ],
	[ 'XSMH',  'Mühlehorn' ],
	[ 'TMUE',  'Mühlen (b Horb)' ],
	[ 'HMLN',  'Mühlen (Oldb)' ],
	[ 'BMM',   'Mühlenbeck-Mön' ],
	[ 'KMUH',  'Mühlenberg' ],
	[ 'LMLT',  'Mühlental' ],
	[ 'AWHOM', 'Mühlenwerder' ],
	[ 'UMH',   'Mühlhausen (Th)' ],
	[ 'NMHO',  'Mühlhausen(Ofr)' ],
	[ 'NMHW',  'Mühlhausen(Wern)' ],
	[ 'RMH',   'Mühlhausen/Engen' ],
	[ 'XAMHM', 'Mühlheim' ],
	[ 'FMH',   'Mühlheim (Main)' ],
	[ 'TMUL',  'Mühlheim b Tuttl' ],
	[ 'FMHO',  'Mühlheim Ost' ],
	[ 'FMHD',  'Mühlhm-Dieteshm' ],
	[ 'XAMM',  'Mühl-Möllbrücke' ],
	[ 'NMST',  'Mühlstetten' ],
	[ 'FNR',   'Mühltal' ],
	[ 'MMTL',  'Mühlthal/Obb' ],
	[ 'DMF',   'Mühltroff' ],
	[ 'DMFG',  'Mühltroff DB-Gr' ],
	[ 'DQMF',  'Mühltroff SN/TH' ],
	[ 'TMRN',  'Mühringen' ],
	[ 'MJK',   'Mü-Johanneskir' ],
	[ 'MKFS',  'Mü-Karlsfeld Hp' ],
	[ 'MLR W', 'Mü-Laim ICE WuA' ],
	[ 'MLR O', 'Mü-Laim Ost' ],
	[ 'ML',    'Mü-Laim Pbf' ],
	[ 'MLR',   'Mü-Laim Rbf' ],
	[ 'EMLR',  'Mülheim Hbf' ],
	[ 'EMRW',  'Mülheim West' ],
	[ 'LMUE',  'Mülldeponie' ],
	[ 'RML',   'Müllheim (Baden)' ],
	[ 'BMR',   'Müllrose' ],
	[ 'MLO',   'Mü-Lochhausen' ],
	[ 'MMBH',  'Mü-Milbertshofen' ],
	[ 'MMT',   'Mü-Mittersendl' ],
	[ 'FMGR',  'Mümling-Grumbach' ],
	[ 'NMBG',  'Münchberg' ],
	[ 'BMB',   'Müncheberg (M)' ],
	[ 'HMHZ',  'Münchehof (Harz)' ],
	[ 'UMU',   'München b Berka' ],
	[ 'MHAR',  'München Harras' ],
	[ 'MH',    'München Hbf' ],
	[ 'MAKN',  'München Kanal' ],
	[ 'MOP',   'München Ost Pbf' ],
	[ 'MOR',   'München Ost Rbf' ],
	[ 'MS',    'München Süd' ],
	[ 'MMAL',  'München-Allach' ],
	[ 'MMAU',  'München-Aubing' ],
	[ 'XSMBU', 'Münchenbuchsee' ],
	[ 'MDFG',  'München-Daglfing' ],
	[ 'MFH',   'München-Freiham' ],
	[ 'MFM',   'München-Freimann' ],
	[ 'MGI',   'München-Giesing' ],
	[ 'MKF',   'München-Karlsf' ],
	[ 'MLW',   'München-Langwied' ],
	[ 'MMCH',  'München-Moosach' ],
	[ 'MP',    'München-Pasing' ],
	[ 'MPER',  'München-Perlach' ],
	[ 'MRI',   'München-Riem' ],
	[ 'MRI P', 'München-Riem Pbf' ],
	[ 'MRIU',  'München-Riem Ubf' ],
	[ 'MSN',   'München-Solln' ],
	[ 'FMHN',  'Münchhausen' ],
	[ 'TMCG',  'Münchingen' ],
	[ 'MMST',  'Münchsmünster' ],
	[ 'SMUE',  'Münchweiler(Als)' ],
	[ 'SMR',   'Münchweiler/Rod' ],
	[ 'MMDL',  'Mündling' ],
	[ 'MNA',   'Mü-Neuaubing' ],
	[ 'MNAA',  'Mü-Neuaubing AW' ],
	[ 'MANH',  'Mü-Neuhausen' ],
	[ 'MANL',  'Mü-Neulustheim' ],
	[ 'MNPS',  'Mü-Neuperl Süd' ],
	[ 'KKMT',  'Müngersdf-Tpark' ],
	[ 'NMUE',  'Münnerstadt' ],
	[ 'TMN',   'Münsingen' ],
	[ 'XSMUS', 'Münsingen CH' ],
	[ 'EMSTG', 'Münster (W) Gbf' ],
	[ 'EMST',  'Münster (W) Hbf' ],
	[ 'EMSTP', 'Münster (W) Pbf' ],
	[ 'EMSW',  'Münster Hbf WLE' ],
	[ 'EMSO',  'Münster Ost' ],
	[ 'FMTR',  'Münster(b Diebg)' ],
	[ 'ENBE',  'Münster-Häger' ],
	[ 'EHIT',  'Münster-Hiltrup' ],
	[ 'EMSR',  'Münster-Roxel' ],
	[ 'SMSA',  'Münster-Sarmsh.' ],
	[ 'ESPR',  'Münster-Sprakel' ],
	[ 'RUM',   'Münstertal(Schw)' ],
	[ 'XAMW',  'Münster-Wiesing' ],
	[ 'XSMN',  'Münstlg-Scherz' ],
	[ 'MANY',  'Mü-Nymphenburg' ],
	[ 'RMZH',  'Münzesheim' ],
	[ 'RMZO',  'Münzesheim Ost' ],
	[ 'MAOZ',  'Mü-Obermenz Abzw' ],
	[ 'MOZ',   'Mü-Obermenzing' ],
	[ 'MPB',   'Mü-Pasing Bbf' ],
	[ 'MPG',   'Mü-Pasing Gbf' ],
	[ 'MP N',  'Mü-Pasing Nord' ],
	[ 'MPGO',  'Mü-Pasing Ost' ],
	[ 'MP P',  'Mü-Pasing W 347' ],
	[ 'MP R',  'Mü-Pasing W 352' ],
	[ 'MP W',  'Mü-Pasing West' ],
	[ 'MRI W', 'Mü-Riem West' ],
	[ 'SMLB',  'Mürlenbach' ],
	[ 'XAMZ',  'Mürzzuschlag' ],
	[ 'EMCH',  'Müschede' ],
	[ 'AMUE',  'Müssen' ],
	[ 'MSTH',  'Mü-Steinhausen' ],
	[ 'MTR',   'Mü-Trudering' ],
	[ 'MWTR',  'Mü-Waldtrudering' ],
	[ 'MWKR',  'Mü-Westkreuz' ],
	[ 'NMUG',  'Muggendorf' ],
	[ 'NNMU',  'Muggenhof Strw' ],
	[ 'RMU',   'Muggensturm' ],
	[ 'RMU N', 'Muggensturm Nord' ],
	[ 'XHM',   'Muhos' ],
	[ 'NMS',   'Muhr am See' ],
	[ 'XBMU',  'Muizen' ],
	[ 'XBMUG', 'Muizen Goederen' ],
	[ 'ZUMC',  'Mukachevo' ],
	[ 'DMUL',  'Mulda (Sachs)' ],
	[ 'DMB',   'Muldenberg' ],
	[ 'DMBH',  'Muldenbg-Floßpl' ],
	[ 'DMH',   'Muldenhütten' ],
	[ 'LMD',   'Muldenstein' ],
	[ 'XFMVD', 'Mulhouse Dornach' ],
	[ 'XFMVN', 'Mulhouse Nord' ],
	[ 'XFMV',  'Mulhouse Ville' ],
	[ 'XVMU',  'Mullsjö' ],
	[ 'AMH',   'Mulmshorn' ],
	[ 'AMS',   'Mulsum-Essel' ],
	[ 'XDMU',  'Mundelstrup' ],
	[ 'TMU',   'Munderkingen' ],
	[ 'XFMUM', 'Mundolsheim' ],
	[ 'XVMK',  'Munkedal' ],
	[ 'XBMZ',  'Munkzwalm' ],
	[ 'XLMB',  'Munsbach' ],
	[ 'XFMST', 'Munster FR' ],
	[ 'HMSS',  'Munster (Ö) Süd' ],
	[ 'HMS',   'Munster (Örtze)' ],
	[ 'XSMUO', 'Muolen' ],
	[ 'XSMR',  'Murg' ],
	[ 'RMRG',  'Murg (Baden)' ],
	[ 'RMUG',  'Murg Gbf' ],
	[ 'MMU',   'Murnau' ],
	[ 'MUO',   'Murnau Ort' ],
	[ 'XMMU',  'Murony' ],
	[ 'TMT',   'Murrhardt' ],
	[ 'XAMU',  'Musau' ],
	[ 'XCML',  'Musliumovo' ],
	[ 'RMCH',  'Mußbach' ],
	[ 'XFMUS', 'Mussidan' ],
	[ 'XIMU',  'Mussotto' ],
	[ 'XTMUZ', 'Mutejovice zast' ],
	[ 'XSMT',  'Muttenz' ],
	[ 'XHMU',  'Muurola' ],
	[ 'XOMY',  'Myrdal' ],
	[ 'XPMS',  'Myslowice' ],
	[ 'FWFK',  'Mz Waggonfabrik' ],
	[ 'FMB A', 'Mz-Bisch Überl I' ],
	[ 'FMB N', 'Mz-Bisch ÜberlII' ],
	[ 'FMB P', 'Mz-Bischofsh Pbf' ],
	[ 'FMB',   'Mz-Bischofsheim' ],
	[ 'FMB M', 'Mz-Bischofshm Mi' ],
	[ 'FMB O', 'Mz-Bischofshm O' ],
	[ 'FMB W', 'Mz-Bischofshm We' ],
	[ 'FMGN',  'Mz-Gustavsbg Hf' ],
	[ 'FMG',   'Mz-Gustavsburg' ],
	[ 'FMS',   'Mz-Römisches Th' ],
	[ 'FMWG',  'Mz-Weisenau Gbf' ],
	[ 'ZINM',  'Naas-Monasterevi' ],
	[ 'NNAB',  'Nabburg' ],
	[ 'NSUG',  'Nabburg DB-Gr' ],
	[ 'ENCH',  'Nachrodt' ],
	[ 'LNHM',  'Nachterst-Hoym' ],
	[ 'FNAC',  'Nackenheim' ],
	[ 'HNSN',  'Naensen' ],
	[ 'XDNV',  'Naestved' ],
	[ 'TNAI',  'Nag-Iselshausen' ],
	[ 'TNA',   'Nagold' ],
	[ 'TNAS',  'Nagold-Steinberg' ],
	[ 'TNA M', 'Nag-Stadtmitte' ],
	[ 'XMNY',  'Nagybatony' ],
	[ 'XMNB',  'Nagyigmand-Babol' ],
	[ 'XMN',   'Nagykanizsa' ],
	[ 'XMNV',  'Nagymaros-Visegr' ],
	[ 'XMNS',  'Nagysimonyi' ],
	[ 'LMGA',  'Nahrstedt' ],
	[ 'NNIL',  'Naila' ],
	[ 'XPNN',  'Naklo n Notecia' ],
	[ 'SNAB',  'Namborn' ],
	[ 'KNAMN', 'Namedy Nordbstg' ],
	[ 'KNAM',  'Namedy Südbstg' ],
	[ 'XONK',  'Namsskogan' ],
	[ 'XBNA',  'Namur' ],
	[ 'XFNT',  'Nancois Tronvill' ],
	[ 'XFN',   'Nancy' ],
	[ 'NNAN',  'Nantenbach' ],
	[ 'XFNA',  'Nantes' ],
	[ 'XINAC', 'Napoli C' ],
	[ 'XINAF', 'Napoli C. F.' ],
	[ 'XINAM', 'Napoli Marittima' ],
	[ 'XINAG', 'Napoli P Garibal' ],
	[ 'XINAS', 'Napoli-Sm.' ],
	[ 'EAPH',  'N-Appelhülsen' ],
	[ 'XFNB',  'Narbonne' ],
	[ 'ZUNK',  'Narkevichi' ],
	[ 'LNA',   'Narsdorf' ],
	[ 'DNA',   'Nassau (Erzg)' ],
	[ 'FNAS',  'Nassau (Lahn)' ],
	[ 'MNBN',  'Nassenbeuren Hp' ],
	[ 'WNAS',  'Nassenheide' ],
	[ 'XVN',   'Nässjö' ],
	[ 'XOON',  'Nationaltheatret' ],
	[ 'KPHN',  'Nato' ],
	[ 'HQNA',  'Natrup-H NRW/NI' ],
	[ 'HNAH',  'Natrup-Hagen' ],
	[ 'BNAU',  'Nauen' ],
	[ 'LNAU',  'Nauendorf' ],
	[ 'FNU',   'Nauheim(b Gr-Ge)' ],
	[ 'UNRO',  'Naumbg-Roßbach' ],
	[ 'FNMB',  'Naumburg (Ksl)' ],
	[ 'UNM',   'Naumburg (S) Hbf' ],
	[ 'UNMO',  'Naumburg (S) Ost' ],
	[ 'UNMG',  'Naumburg DB-Gr' ],
	[ 'LNH',   'Naunhof' ],
	[ 'XTNAV', 'Navarov' ],
	[ 'WIN',   'Nbg-Industriegel' ],
	[ 'FNOM',  'Nd Ofleiden MHI' ],
	[ 'DNCUA', 'Ndrcunnersdf W15' ],
	[ 'KNRC',  'Ne Rheinparkcent' ],
	[ 'KNEA',  'Neanderthal' ],
	[ 'XSN',   'Nebikon' ],
	[ 'DNEB',  'Nebitzschen' ],
	[ 'UNE',   'Nebra' ],
	[ 'UNEG',  'Nebra DB-Gr' ],
	[ 'UQNE',  'Nebra ST/TH' ],
	[ 'WNL',   'Nechlin' ],
	[ 'WQNL',  'Nechlin BB/MV' ],
	[ 'RNBH',  'Neckarb.Helmhof' ],
	[ 'RNHF',  'Neckarbisch Nord' ],
	[ 'RNHS',  'Neckarbisch.St.' ],
	[ 'RNB',   'Neckarburken' ],
	[ 'RNMA',  'Neckargem Altst' ],
	[ 'RNM',   'Neckargemünd' ],
	[ 'RQNM',  'Neckargemünd LGr' ],
	[ 'RNA',   'Neckargerach' ],
	[ 'TNY',   'Neckarhsn b Horb' ],
	[ 'RNH',   'Neckarhsn/Nstein' ],
	[ 'TSNS',  'Neckarpark' ],
	[ 'RNT',   'Neckarsteinach' ],
	[ 'TN',    'Neckarsulm' ],
	[ 'TN A',  'Neckarsulm AVG' ],
	[ 'TN M',  'Neckarsulm Mitte' ],
	[ 'TNSN',  'Neckarsulm Nord' ],
	[ 'TN G',  'NeckarsulmDB/AVG' ],
	[ 'RNEZ',  'Neckarzimmern' ],
	[ 'HNAB',  'Neddenaverbergen' ],
	[ 'SNF',   'Neef' ],
	[ 'XBN',   'Neerpelt' ],
	[ 'HNET',  'Neetze' ],
	[ 'ANEZ',  'Neetzendorf' ],
	[ 'WNA',   'Neetzka' ],
	[ 'ENHU',  'Neheim-H Ue(RLG)' ],
	[ 'ENHR',  'Neheim-Hüst RLG' ],
	[ 'ENHH',  'Neheim-Hüsten' ],
	[ 'ENHW',  'Neheim-Hüsten W' ],
	[ 'TNEH',  'Nehren' ],
	[ 'RNFL',  'Neidenfels Hp' ],
	[ 'RNFS',  'Neidenfels Üst' ],
	[ 'RNST',  'Neidenstein' ],
	[ 'LNI',   'Neinstedt' ],
	[ 'KNEI',  'Neitersen' ],
	[ 'XINE',  'Neive' ],
	[ 'XTNJ',  'Nejdek' ],
	[ 'XTNJZ', 'Nejdek zast' ],
	[ 'ZUNJ',  'Nejin' ],
	[ 'XTNK',  'Nekrasin' ],
	[ 'XONL',  'Nelaug' ],
	[ 'TNL',   'Nellmersbach' ],
	[ 'XMNK',  'Nemesgulacs-K' ],
	[ 'XMNC',  'Nemeskocs' ],
	[ 'XFNP',  'Nemours-St-Pierr' ],
	[ 'LNDG',  'Nemsdf-Göhrendf' ],
	[ 'XAND',  'Nendeln' ],
	[ 'TNED',  'Nendingen(Tuttl)' ],
	[ 'LNS',   'Nennhausen' ],
	[ 'SNE',   'Nennig' ],
	[ 'SNEC',  'Nennig CSL' ],
	[ 'DNGM',  'Nennigmühle' ],
	[ 'XANE',  'Nenzing' ],
	[ 'RNN',   'Nenzingen' ],
	[ 'ZUNP',  'Nepolokovcy' ],
	[ 'XTNE',  'Neratovice' ],
	[ 'MNSG',  'Nersingen' ],
	[ 'XONB',  'Nesbyen' ],
	[ 'XONV',  'Neslandsvatn' ],
	[ 'BNES',  'Nesselgrund' ],
	[ 'MNEW',  'Nesselwang' ],
	[ 'XBNE',  'Nessonvaux' ],
	[ 'XTNT',  'Nestedice' ],
	[ 'XTNM',  'Nestemice' ],
	[ 'XCNE',  'Nesterov' ],
	[ 'ENTS',  'Netphen (Sieg)' ],
	[ 'ENTE',  'Nette /Dortmd' ],
	[ 'ANTB',  'Nettelnburg' ],
	[ 'KNEH',  'Nettersheim' ],
	[ 'XANF',  'Nettingsdorf' ],
	[ 'HNE',   'Netze' ],
	[ 'WNED',  'Netzeband' ],
	[ 'LNKA',  'Netzkater' ],
	[ 'DNZU',  'Netzschkau' ],
	[ 'HNNT',  'Neu Neetze' ],
	[ 'WNPG',  'Neu Pudagla' ],
	[ 'ANSJ',  'Neu St Jürgen' ],
	[ 'WNWO',  'Neu Wokern' ],
	[ 'AQNW',  'Neu Wulmst HH/NI' ],
	[ 'ANWF',  'Neu Wulmstorf' ],
	[ 'FNAP',  'Neu-Anspach' ],
	[ 'NNAE',  'Neubäu' ],
	[ 'SLDN',  'Neubauer Hübel' ],
	[ 'ENBM',  'Neubeckum' ],
	[ 'ENBW',  'Neubeckum WLE' ],
	[ 'ENBMG', 'Neubeckum Gbf' ],
	[ 'ENBMP', 'Neubeckum Pbf' ],
	[ 'NNB',   'Neuberg' ],
	[ 'MNB',   'Neubiberg' ],
	[ 'WN G',  'Neubrandenbg Gbf' ],
	[ 'WN',    'Neubrandenburg' ],
	[ 'SNBR',  'Neubrücke (Nahe)' ],
	[ 'SQNB',  'Neubrücke LGr' ],
	[ 'WNB',   'Neubukow' ],
	[ 'MNBD',  'Neuburg (Donau)' ],
	[ 'MNBK',  'Neuburg (Kammel)' ],
	[ 'RNBU',  'Neuburg (Rhein)' ],
	[ 'MANG',  'Neuburg-Grünau' ],
	[ 'LNX',   'Neuburxdorf' ],
	[ 'LQNX',  'Neuburxdorf LGr' ],
	[ 'XSNC',  'Neuchatel' ],
	[ 'TND',   'Neudenau' ],
	[ 'HNPL',  'Neudf-Platendf' ],
	[ 'UND',   'Neudietendorf' ],
	[ 'DNDF',  'Neudorf (Erzgeb)' ],
	[ 'HNMU',  'Neue Mühle' ],
	[ 'UNS',   'Neue Schenke' ],
	[ 'HNHA',  'Neuekrug-Hahausn' ],
	[ 'TNEB',  'Neuenb Freibad' ],
	[ 'RXNB',  'Neuenbg (Ba) Gr.' ],
	[ 'TNES',  'Neuenbürg Süd' ],
	[ 'TNE',   'Neuenbürg(Württ)' ],
	[ 'RNBG',  'Neuenburg/Baden' ],
	[ 'NNDU',  'Neuendettelsau' ],
	[ 'BNG',   'Neuenhagen b Bln' ],
	[ 'HNEH',  'Neuenhaus' ],
	[ 'HNEK',  'Neuenkirch.(Sol)' ],
	[ 'HNKO',  'Neuenkirchen/Old' ],
	[ 'HNKP',  'Neuenkoop' ],
	[ 'NNE O', 'Neuenm-Wbg Ost' ],
	[ 'NNE S', 'Neuenm-Wbg Süd' ],
	[ 'NNE',   'Neuenm-Wirsberg' ],
	[ 'ENRA',  'Neuenrade' ],
	[ 'NNHC',  'Neuenreuth/Creu' ],
	[ 'TNSW',  'Neuenstadt West' ],
	[ 'TNST',  'Neuenstadt/Koch.' ],
	[ 'TNN',   'Neuenstein' ],
	[ 'KNEW',  'Neuer Weg' ],
	[ 'KQNE',  'NRW/RP' ],
	[ 'MNF',   'Neufahrn b Frei' ],
	[ 'MNFR',  'Neufahrn/Nbay' ],
	[ 'XBNC',  'Neufchateau' ],
	[ 'XFNE',  'Neufchateau' ],
	[ 'TNEF',  'Neuffen' ],
	[ 'TNFH',  'Neufra (Hohenz)' ],
	[ 'TNX',   'Neufra b Rottw' ],
	[ 'LNG',   'Neugarten' ],
	[ 'DNF',   'Neugersdorf' ],
	[ 'MNGH',  'Neugilching' ],
	[ 'ANRS',  'Neugr (S-Bahn)' ],
	[ 'UNHR',  'Neuhaus am Rennw' ],
	[ 'NNP',   'Neuhaus(Pegnitz)' ],
	[ 'XSNE',  'Neuhausen CH' ],
	[ 'DNH',   'Neuhausen (Erzg)' ],
	[ 'BNH',   'Neuhausen b Cs' ],
	[ 'RNHN',  'Neuhausen Bad Bf' ],
	[ 'FNF N', 'Neuhof Nord' ],
	[ 'FNFS',  'Neuhof Süd' ],
	[ 'BNE',   'Neuhof(b Zossen)' ],
	[ 'FNF',   'Neuhof(Kr Fulda)' ],
	[ 'UNHI',  'Neuhs-Igelshieb' ],
	[ 'FNIS',  'Neu-Isenburg' ],
	[ 'FNISA', 'Neu-Isenburg ARZ' ],
	[ 'FNIU',  'Neu-Isenburg Hp' ],
	[ 'LNK',   'Neukieritzsch' ],
	[ 'NNS',   'Neukir (Sulz-R)' ],
	[ 'DNKO',  'Neukirch (L) Ost' ],
	[ 'DNKW',  'Neukirch (L)West' ],
	[ 'DNKG',  'Neukirch W DB-Gr' ],
	[ 'XSNK',  'Neukirch-Egnach' ],
	[ 'MNK',   'Neukirchen (Inn)' ],
	[ 'KNCH',  'Neukirchen (Moe)' ],
	[ 'ANEK',  'Neukirchen/Holst' ],
	[ 'DNK',   'Neukirchen-Klaff' ],
	[ 'LNWY',  'Neukirchen-Wyhra' ],
	[ 'ANL',   'Neukloster/Kr St' ],
	[ 'BNK',   'Neukölln S-B' ],
	[ 'RNL',   'Neulußheim' ],
	[ 'ANSG',  'Neum Süd DB-Gr' ],
	[ 'DNM',   'Neumark (Sachs)' ],
	[ 'MNRG',  'Neumarkt DB-Gr' ],
	[ 'NNT',   'Neumarkt(Oberpf)' ],
	[ 'XANK',  'Neumarkt-Kallham' ],
	[ 'XANKD', 'Neumarkt-Köstend' ],
	[ 'MNR',   'Neumarkt-St Veit' ],
	[ 'UNME',  'Neumühle (Elst)' ],
	[ 'ANSW',  'Neumünst Stadtw' ],
	[ 'AN',    'Neumünster' ],
	[ 'ANMG',  'Neumünster DB-Gr' ],
	[ 'AN G',  'Neumünster Gbf' ],
	[ 'ANM',   'Neumünster Süd' ],
	[ 'ANMS',  'Neumünster Süd' ],
	[ 'LN',    'Neundorf (Anh)' ],
	[ 'UNH',   'Neunhofen' ],
	[ 'SNKE',  'Neunk Bauknecht' ],
	[ 'SNKG',  'Neunk Hermine' ],
	[ 'SNKW',  'Neunk(S)-Wellesw' ],
	[ 'SNK',   'Neunkir (S) Hbf' ],
	[ 'NNKS',  'Neunkir a Sand' ],
	[ 'RNK',   'Neunkirch' ],
	[ 'ENKN',  'Neunkirchen Nord' ],
	[ 'ENK',   'Neunkirchen/Sieg' ],
	[ 'DNOE',  'Neuoelsnitz' ],
	[ 'MNFG',  'Neuoffingen' ],
	[ 'MNN',   'Neuötting' ],
	[ 'BNP',   'Neupetershain' ],
	[ 'YKKNR', 'Neurather Rg Sw' ],
	[ 'XANG',  'Neuratting' ],
	[ 'WNTG',  'Neurup RhT DB-Gr' ],
	[ 'WNR',   'Neuruppin' ],
	[ 'WNRG',  'Neuruppin DB-Gr' ],
	[ 'WNRR',  'Neuruppin Rh Tor' ],
	[ 'WNRW',  'Neuruppin West' ],
	[ 'DNP',   'Neusalza-Spremb' ],
	[ 'MNES',  'Neusäß' ],
	[ 'NNEU',  'Neuses(Kronach)' ],
	[ 'NNSG',  'Neusorg' ],
	[ 'DNZ',   'Neusörnewitz' ],
	[ 'KNAL',  'Neuss Allerheil' ],
	[ 'KNAK',  'Neuss Am Kaiser' ],
	[ 'KNG',   'Neuss Gbf' ],
	[ 'KNHA',  'Neuss Hafen' ],
	[ 'KN',    'Neuss Hbf' ],
	[ 'KNH',   'Neuss Hessentor' ],
	[ 'KNHM',  'Neuss Htor Menke' ],
	[ 'KN O',  'Neuss Ostseite' ],
	[ 'KNSD',  'Neuss Süd' ],
	[ 'KN D',  'Neuss W 31' ],
	[ 'KN W',  'Neuss Westseite' ],
	[ 'WNSG',  'Neust (Ds) DB-Gr' ],
	[ 'NNW',   'Neust (Waldnaab)' ],
	[ 'RN O',  'Neust(W) Ülp Ost' ],
	[ 'RNBO',  'Neust(W)-Böbig' ],
	[ 'RN A',  'Neust.(W)Rgd Gra' ],
	[ 'NNA',   'Neust/Aisch Bf' ],
	[ 'MND',   'Neustadt (Donau)' ],
	[ 'WNS',   'Neustadt (Dosse)' ],
	[ 'ANT',   'Neustadt (Holst)' ],
	[ 'UNU',   'Neustadt (Orla)' ],
	[ 'DNE',   'Neustadt (Sachs)' ],
	[ 'RN',    'Neustadt (W) Hbf' ],
	[ 'HNRU',  'Neustadt a Rbg' ],
	[ 'DNEG',  'Neustadt DB-Gr' ],
	[ 'RND',   'Neustadt Süd' ],
	[ 'NQNU',  'Neustadt(b C)LGr' ],
	[ 'NNU',   'Neustadt(b Cobg)' ],
	[ 'FNSM',  'Neustadt(Kr Mbg)' ],
	[ 'NNAM',  'Neustadt/A Mitte' ],
	[ 'WNS G', 'Neustadt/D Gbf' ],
	[ 'ANN',   'Neustadt/Hol Gbf' ],
	[ 'RNSS',  'Neustadt/Schwarz' ],
	[ 'WNG',   'Neustadt-Glewe' ],
	[ 'TNHO',  'Neustadt-Hohena' ],
	[ 'NNSP',  'Neustift(Passau)' ],
	[ 'NNSB',  'Neustift-Blindh' ],
	[ 'WNZG',  'Neustrelitz DBGr' ],
	[ 'WNT',   'Neustrelitz Hbf' ],
	[ 'WHN',   'Neustrelitz Hfn' ],
	[ 'WNTS',  'Neustrelitz Süd' ],
	[ 'BNTB',  'Neutrebbin' ],
	[ 'MNM',   'Neu-Ulm' ],
	[ 'LNWK',  'Neuwerk' ],
	[ 'KNE',   'Neuwied' ],
	[ 'KNE G', 'Neuwied Gbf' ],
	[ 'ANWS',  'Neuwiedenthal' ],
	[ 'RETN',  'Neuwiesenreben' ],
	[ 'TNW',   'Neuwirtshaus' ],
	[ 'ANW',   'Neuwittenbek' ],
	[ 'BNZ',   'Neuzelle' ],
	[ 'XCN',   'Nevelsk' ],
	[ 'ENV',   'Neviges' ],
	[ 'ENHF',  'Nevinghof/M Z N' ],
	[ 'ZINB',  'Newbridge' ],
	[ 'FNFD',  'N-Flörshm-Dalshm' ],
	[ 'XFNC',  'Nice Ville' ],
	[ 'XINC',  'Nicorvo' ],
	[ 'FND',   'Nidda' ],
	[ 'FHWD',  'Nidderau' ],
	[ 'FHWR',  'Nidderau (Regio)' ],
	[ 'FECH',  'Nidderau-Eichen' ],
	[ 'FWIN',  'Nidder-Windecken' ],
	[ 'KNID',  'Nideggen' ],
	[ 'ANB',   'Niebüll' ],
	[ 'ANBG',  'Niebüll DB-Gr' ],
	[ 'ANBN',  'Niebüll neg' ],
	[ 'SNID',  'Niedaltdorf' ],
	[ 'FNOF',  'Nieder Ofleiden' ],
	[ 'FNO',   'Nieder Ohmen' ],
	[ 'FNOL',  'Nieder Olm' ],
	[ 'FNRW',  'Nieder Wöllstadt' ],
	[ 'FNDA',  'Niederahr' ],
	[ 'FMOF',  'Niederahr Tongr' ],
	[ 'MNAR',  'Niederarnbach' ],
	[ 'DNDR',  'Niederau' ],
	[ 'FNIA',  'Niederaula' ],
	[ 'TNB',   'Niederbiegen' ],
	[ 'XSNB',  'Niederbipp' ],
	[ 'DNBO',  'Niederbobritzsch' ],
	[ 'FNCH',  'Niederbrechen' ],
	[ 'DNCU',  'Niedercunnersdf' ],
	[ 'ENDI',  'Niederdielfen' ],
	[ 'KND',   'Niederdollendorf' ],
	[ 'DNIE',  'Niederdorf(Erzg)' ],
	[ 'FNIE',  'Niederdorfelden' ],
	[ 'ENDR',  'Niederdreisbach' ],
	[ 'EQNI',  'Niederdressd LGr' ],
	[ 'ENID',  'Niederdresselndf' ],
	[ 'ENDE',  'Niedereimer' ],
	[ 'FNIB',  'Niedererbach' ],
	[ 'FQNI',  'Niedererbach LGr' ],
	[ 'WNW',   'Niederfinow' ],
	[ 'XSNI',  'Niederglatt' ],
	[ 'LNOE',  'Niedergörne' ],
	[ 'LNF',   'Niedergörsdorf' ],
	[ 'FNHD',  'Niederhadamar' ],
	[ 'FNDH',  'Niederheimbach' ],
	[ 'FNH',   'Niederhöchstadt' ],
	[ 'DNHD',  'Niederhohndorf' ],
	[ 'RRID',  'Niederholz' ],
	[ 'FNHA',  'Niederhone' ],
	[ 'ENDV',  'Niederhövels' ],
	[ 'FNJ',   'Niederjosbach' ],
	[ 'FNIJ',  'Niederjossa' ],
	[ 'KNK',   'Niederkassel' ],
	[ 'XLNK',  'Niederkorn' ],
	[ 'ENL',   'Niederlaasphe' ],
	[ 'KNL N', 'Niederlahnst N' ],
	[ 'KNL',   'Niederlahnstein' ],
	[ 'BNDL',  'Niederlehme' ],
	[ 'MNLH',  'Niederlindhart' ],
	[ 'SNDL',  'Niederlinxweiler' ],
	[ 'YFFNL', 'Niederlst Strw' ],
	[ 'HNMS',  'Niedermarschacht' ],
	[ 'FNMI',  'Niedermittlau' ],
	[ 'SNDM',  'Niedermohr' ],
	[ 'LNR',   'Niederndodeleben' ],
	[ 'FNSD',  'Niedernhsn (Ts)' ],
	[ 'DNOW',  'Niederoderwitz' ],
	[ 'UNP',   'Niederpöllnitz' ],
	[ 'MNRU',  'Niederraunau' ],
	[ 'MNRO',  'Niederroth' ],
	[ 'LNDH',  'Niedersachsw Her' ],
	[ 'LNDI',  'Niedersachsw Ilf' ],
	[ 'LNDS',  'Niedersachsw Ost' ],
	[ 'UNIW',  'Niedersachswerf' ],
	[ 'EQND',  'Niederscheld LGr' ],
	[ 'ENDN',  'Niederschelden' ],
	[ 'ENDO',  'Niederschelden N' ],
	[ 'DNSL',  'Niederschlag' ],
	[ 'DNDS',  'Niederschlottw' ],
	[ 'UNSK',  'Niederschmalkald' ],
	[ 'RNS',   'Niederschopfheim' ],
	[ 'FNS',   'Niederselters' ],
	[ 'UNI',   'Niederspier' ],
	[ 'FNIH',  'Niedersteinbach' ],
	[ 'TNI',   'Niederstetten' ],
	[ 'TNS',   'Niederstotzingen' ],
	[ 'DNST',  'Niederstriegis' ],
	[ 'UNTA',  'Niedertrebra' ],
	[ 'FNL',   'Niederwalgern' ],
	[ 'FNWF',  'Niederwalluf' ],
	[ 'DNI',   'Niederwartha' ],
	[ 'RNW',   'Niederwasser' ],
	[ 'FNDW',  'Niederweimar' ],
	[ 'DNRG',  'Niederwie DB-Gr' ],
	[ 'DNR',   'Niederwiesa' ],
	[ 'UNWL',  'Niederwillingen' ],
	[ 'RNID',  'Niederwinden' ],
	[ 'DNWZ',  'Niederwürschnitz' ],
	[ 'FNIZ',  'Niederzeuzheim' ],
	[ 'KNZS',  'Niederzissen' ],
	[ 'DNZW',  'Niederzwönitz' ],
	[ 'TNF',   'Niefern' ],
	[ 'XPNG',  'Niegoslawice' ],
	[ 'XPNIA', 'Nielubia' ],
	[ 'LNM',   'Niemberg' ],
	[ 'BNGK',  'Niemegk' ],
	[ 'LNB',   'Nienburg (Saale)' ],
	[ 'HNBG',  'Nienburg (Weser)' ],
	[ 'LNBG',  'Nienburg/S Getr.' ],
	[ 'LNHG',  'Nienhagen(b Hab)' ],
	[ 'HNST',  'Nienstädt' ],
	[ 'ENIR',  'Nierenhof' ],
	[ 'FNIR',  'Nierstein' ],
	[ 'BNY',   'Niesky' ],
	[ 'XPNI',  'Nietkow' ],
	[ 'KNIK',  'Nieukerk' ],
	[ 'XNNA',  'Nieuw Amsterdam' ],
	[ 'XNNS',  'Nieuwe Schans' ],
	[ 'KNIS',  'Nievelstein' ],
	[ 'KNIV',  'Nievenheim' ],
	[ 'FNIV',  'Nievern' ],
	[ 'XNNM',  'Nijmegen' ],
	[ 'XCNA',  'Nijniaia' ],
	[ 'XCNI',  'Nikel' ],
	[ 'ZUNT',  'Nikitovka' ],
	[ 'TNK',   'Niklashausen' ],
	[ 'ZUN',   'Nikolaev' ],
	[ 'BNIS',  'Nikolassee St-B' ],
	[ 'BNIW',  'Nikolassee Ws-B' ],
	[ 'NANG',  'Nilkheim DB-Gr' ],
	[ 'RNIM',  'Nimburg (Baden)' ],
	[ 'XFNI',  'Nimes' ],
	[ 'FNIP',  'Nippe' ],
	[ 'XJNI',  'Nis' ],
	[ 'XINI',  'Niscemi' ],
	[ 'XCGM',  'Nishnij Nov Mosk' ],
	[ 'XPNK',  'Nisko' ],
	[ 'FERW',  'Nistertal-B Mbg' ],
	[ 'XOND',  'Nittedal' ],
	[ 'SNI',   'Nittel' ],
	[ 'NNIT',  'Nittenau' ],
	[ 'XINM',  'Nizza Monferrato' ],
	[ 'XEN',   'Noain' ],
	[ 'DNB',   'Nöbdenitz' ],
	[ 'LNOB',  'Nobitz' ],
	[ 'XONO',  'Nodeland' ],
	[ 'XDNA',  'Noerre Alslev' ],
	[ 'XDNN',  'Noerre-Nebel' ],
	[ 'XDNP',  'Noerreport' ],
	[ 'XLNZ',  'Noertzange' ],
	[ 'XINO',  'Nogara' ],
	[ 'XFNR',  'Nogent le Retrou' ],
	[ 'SNON',  'Nohen' ],
	[ 'SNO',   'Nohfelden' ],
	[ 'UNOH',  'Nohra (b Weimar)' ],
	[ 'UNA',   'Nohra (Wipper)' ],
	[ 'XFNO',  'Noisy-le-Sec' ],
	[ 'NFIN',  'Nokia' ],
	[ 'BNPL',  'Nöldnerplatz' ],
	[ 'MNHN',  'Nonnenhorn' ],
	[ 'SNWR',  'Nonnweiler' ],
	[ 'XONA',  'Nordagutu' ],
	[ 'TSN',   'Nordbahnhof' ],
	[ 'YBBNB', 'Nordbf Strw' ],
	[ 'ENOB',  'Nordbögge' ],
	[ 'ENOBU', 'Nordbögge Üst' ],
	[ 'HND',   'Norddeich' ],
	[ 'HNDM',  'Norddeich Mole' ],
	[ 'HNN',   'Norden' ],
	[ 'HNNG',  'Norden DB-Gr' ],
	[ 'MNOD',  'Nordendorf' ],
	[ 'HNO',   'Nordenham' ],
	[ 'ANEB',  'Norderelbbr' ],
	[ 'ANDM',  'Norderst Mitte' ],
	[ 'AND',   'Norderstedt' ],
	[ 'ANIB',  'Norderstedt Ind' ],
	[ 'LNHH',  'Nordh Hesseröder' ],
	[ 'LNHR',  'Nordh Ricarda-H' ],
	[ 'LNHA',  'Nordh-Altentor' ],
	[ 'ANH',   'Nordhastedt' ],
	[ 'UN',    'Nordhausen' ],
	[ 'UN A',  'Nordhausen No' ],
	[ 'LNHN',  'Nordhausen Nord' ],
	[ 'UN N',  'Nordhausen Nzw' ],
	[ 'UNSA',  'Nordhausen-Salza' ],
	[ 'TNO',   'Nordheim (Württ)' ],
	[ 'LNHK',  'Nordh-Krimderode' ],
	[ 'ANZ',   'Nordholz' ],
	[ 'HNDH',  'Nordhorn' ],
	[ 'KNOKA', 'Nordkanal Bksig' ],
	[ 'KNOKB', 'Nordkanal W 1' ],
	[ 'KNOKC', 'Nordkanal W 7' ],
	[ 'MNLG',  'Nördl DB-Gr (DZ)' ],
	[ 'MWAG',  'Nördl DB-Gr (WA)' ],
	[ 'MAZW',  'Nördling Waldhof' ],
	[ 'MNL',   'Nördlingen' ],
	[ 'ANDS',  'Nordsode' ],
	[ 'HNOS',  'Nordstemmen' ],
	[ 'ENON',  'Nordstern /Ge' ],
	[ 'UKOH',  'Nordthür Kohle' ],
	[ 'ENOW',  'Nordwalde' ],
	[ 'KNO',   'Norf' ],
	[ 'SNOR',  'Norheim' ],
	[ 'XVNH',  'Norrahammar' ],
	[ 'XVNC',  'Norrköping' ],
	[ 'XVNS',  'Norsesund' ],
	[ 'RNO',   'Norsingen' ],
	[ 'HNTH',  'Nörten-Hardenbg' ],
	[ 'XKNP',  'North Portal MEZ' ],
	[ 'HN',    'Northeim (Han)' ],
	[ 'HN G',  'Northeim/Han Gbf' ],
	[ 'HNTM',  'Nortmoor' ],
	[ 'ANF',   'Nortorf' ],
	[ 'DNO',   'Nossen' ],
	[ 'DNOV',  'Nossen DB-Gr B' ],
	[ 'DNOC',  'Nossen DB-Gr C' ],
	[ 'WNOS',  'Nossentin' ],
	[ 'XFNDB', 'Notre Dame B' ],
	[ 'XRNG',  'Nova Gradiska' ],
	[ 'XRNK',  'Nova Kapela' ],
	[ 'XJNP',  'Nova Pazova' ],
	[ 'XTNR',  'Nova Role' ],
	[ 'XTNRZ', 'Nova Role zast' ],
	[ 'XTNV',  'Nova Vcelnice' ],
	[ 'XTNVN', 'Nova Ves n Nisou' ],
	[ 'XYNV',  'Nova Vieska' ],
	[ 'XINV',  'Novara' ],
	[ 'XTNH',  'Nove Hamry' ],
	[ 'XTNHZ', 'Nove Hamry zast' ],
	[ 'XTNS',  'Nove Sedlo u Lok' ],
	[ 'XYNZ',  'Nove Zamky' ],
	[ 'XFNV',  'Noveant' ],
	[ 'XJNB',  'Novi Beograd' ],
	[ 'XINL',  'Novi Ligure' ],
	[ 'XINB',  'Novi S Bovo' ],
	[ 'XJNS',  'Novi Sad' ],
	[ 'XZNM',  'Novo Mesto' ],
	[ 'ZUNA',  'Novoalekseevka' ],
	[ 'XCNC',  'Novocherkassk' ],
	[ 'XRNS',  'Novoselec' ],
	[ 'XCNG',  'Novosibirsk-Gl' ],
	[ 'XCNS',  'Novosokolniki' ],
	[ 'XRNV',  'Novska' ],
	[ 'XTNB',  'Novy Bor' ],
	[ 'XPNS',  'Nowa Sol' ],
	[ 'XPND',  'Nowe Drezdenko' ],
	[ 'XPNO',  'Nowogard' ],
	[ 'XPNT',  'Nowy Tomysl' ],
	[ 'XFNY',  'Noyon' ],
	[ 'FNDS',  'N-scheld Süd' ],
	[ 'TNG',   'Nsu Gr AVG/SWH' ],
	[ 'TNSK',  'Nsu Kaufland' ],
	[ 'LNDD',  'Nudersdorf' ],
	[ 'DNUN',  'Nünchritz' ],
	[ 'NSTD',  'Nür Frankenstad' ],
	[ 'NNGR',  'Nür Großmarkt' ],
	[ 'NNEG',  'Nür Hafen DB-Gr' ],
	[ 'NJB',   'Nür Jansenbr' ],
	[ 'NNR B', 'Nür Minervabr' ],
	[ 'NNR A', 'Nür Rbf Ausfahrt' ],
	[ 'NNR E', 'Nür Rbf Einfahrt' ],
	[ 'NNRS',  'Nür Rothenbg Str' ],
	[ 'NDHF',  'Nür-Dürrenhof' ],
	[ 'NDTH',  'Nür-Dutzendt Hp' ],
	[ 'NND',   'Nür-Dutzendteich' ],
	[ 'NNES',  'Nür-Eibach SB' ],
	[ 'NNER',  'Nür-Erlenstegen' ],
	[ 'NGLH',  'Nür-Gleißhammer' ],
	[ 'NNLW',  'Nür-Langwasser' ],
	[ 'NNLH',  'Nür-Laufamholz' ],
	[ 'NNMO',  'Nür-Mögeldorf' ],
	[ 'NNEH',  'Nürnberg Hafen' ],
	[ 'NN',    'Nürnberg Hbf' ],
	[ 'NNG',   'Nürnberg Hgbf' ],
	[ 'NNRD',  'Nürnberg Nord' ],
	[ 'NNRO',  'Nürnberg Nordost' ],
	[ 'NNO',   'Nürnberg Ost' ],
	[ 'NNOS',  'Nürnberg Ostring' ],
	[ 'NNR',   'Nürnberg Rbf' ],
	[ 'NNDO',  'Nürnberg-Doos' ],
	[ 'NNEI',  'Nürnberg-Eibach' ],
	[ 'MAND',  'Nürnberger Bund' ],
	[ 'NNRH',  'Nürnberg-Rehhof' ],
	[ 'NNST',  'Nürnberg-Stein' ],
	[ 'TSNA',  'Nürnbg Str Abzw' ],
	[ 'NNRE',  'Nür-Reichelsd SB' ],
	[ 'NNRF',  'Nür-Reichelsdorf' ],
	[ 'NNSR',  'Nür-Sandreuth' ],
	[ 'NNSW',  'Nür-Schweinau' ],
	[ 'NNSN',  'Nür-Steinbühl' ],
	[ 'TNU',   'Nürtingen' ],
	[ 'TNUG',  'Nürtingen DB/WEG' ],
	[ 'TNUV',  'Nürtingen Vorst' ],
	[ 'TNU R', 'Nürting-Roßdorf' ],
	[ 'HNM',   'Nüttermoor' ],
	[ 'ANTZ',  'Nützen' ],
	[ 'TNUF',  'Nufringen' ],
	[ 'NNBS',  'Nußberg-Schönau' ],
	[ 'ENUT',  'Nuttlar' ],
	[ 'XDNY',  'Nyborg' ],
	[ 'XONY',  'Nydalen' ],
	[ 'XMNH',  'Nyiregyhaza' ],
	[ 'XDNK',  'Nykoebing F' ],
	[ 'XVNK',  'Nyköpings C' ],
	[ 'XTN',   'Nymburk hl.n.' ],
	[ 'XTNY',  'Nyrany' ],
	[ 'EOBU',  'Ob-Buschhausen' ],
	[ 'FORA',  'Ober Ramstadt' ],
	[ 'FOW',   'Ober Widdersheim' ],
	[ 'ROA',   'Oberachern' ],
	[ 'ROAB',  'Oberachern Bind.' ],
	[ 'EOD',   'Oberaden' ],
	[ 'TOAI',  'Oberaichen' ],
	[ 'XAOA',  'Oberalm' ],
	[ 'MOA',   'Oberammergau' ],
	[ 'NOA',   'Oberasbach' ],
	[ 'MOU',   'Oberau' ],
	[ 'MOD',   'Oberaudorf' ],
	[ 'MODU',  'Oberaudorf Üst' ],
	[ 'MABO',  'Oberbachern' ],
	[ 'MOBU',  'Oberbachern Üst' ],
	[ 'SOH',   'Oberb-Hillesheim' ],
	[ 'SOG',   'Oberbillig' ],
	[ 'FOBA',  'Oberbimbach' ],
	[ 'TOBB',  'Oberboihingen' ],
	[ 'FOB',   'Oberbrechen' ],
	[ 'XSOG',  'Oberburg' ],
	[ 'NON',   'Oberdachstetten' ],
	[ 'ROBE',  'Oberd-Flehingen' ],
	[ 'KODR',  'Oberdrees' ],
	[ 'EODR',  'Oberdreisbach' ],
	[ 'TOLC',  'Oberelchingen' ],
	[ 'FOSN',  'Oberelsungen' ],
	[ 'KOE',   'Obererbach' ],
	[ 'TOES',  'Oberesslingen' ],
	[ 'TOESF', 'Oberesslingen F' ],
	[ 'NOB',   'Oberferrieden' ],
	[ 'ROGI',  'Obergimpern' ],
	[ 'XSOB',  'Oberglatt' ],
	[ 'MOGS',  'Obergries' ],
	[ 'MOGB',  'Obergriesbach' ],
	[ 'UOGR',  'Obergrunstedt' ],
	[ 'EOBRB', 'Oberh W Abzw Oro' ],
	[ 'EOBRS', 'Oberh West Stw 1' ],
	[ 'EOBRZ', 'Oberh West Stw 2' ],
	[ 'AOHA',  'Oberhafen' ],
	[ 'NOH',   'Oberhaid' ],
	[ 'ROHD',  'Oberharmersb.D.' ],
	[ 'ROHR',  'Oberharmersb.R.' ],
	[ 'FOBN',  'Oberhaun' ],
	[ 'ROBH',  'Oberhausen' ],
	[ 'EOB',   'Oberhausen Hbf' ],
	[ 'EOBR',  'Oberhausen West' ],
	[ 'UOF',   'Oberhof (Thür)' ],
	[ 'XAOB',  'Oberhofen' ],
	[ 'LOH',   'Oberholz' ],
	[ 'FOBE',  'Oberhörgn-Eberst' ],
	[ 'EOB N', 'Oberhsn Hbf Obn' ],
	[ 'EOB O', 'Oberhsn Hbf Obo' ],
	[ 'EOBRM', 'Oberhsn West Orm' ],
	[ 'EOBRO', 'Oberhsn West Oro' ],
	[ 'EOBRW', 'Oberhsn West Orw' ],
	[ 'EOHT',  'Oberhsn-Holten' ],
	[ 'ROB',   'Oberkirch' ],
	[ 'NOKS',  'Oberklingensporn' ],
	[ 'TON',   'Oberkochen' ],
	[ 'XLOK',  'Oberkorn' ],
	[ 'NOKP',  'Oberkotzau' ],
	[ 'ROK',   'Oberkrozingen' ],
	[ 'KOL G', 'Oberlahnst. Gbf' ],
	[ 'KOL',   'Oberlahnstein' ],
	[ 'UOLA',  'Oberlauscha' ],
	[ 'TOL',   'Oberlenningen' ],
	[ 'DOBL',  'Oberlichtenau' ],
	[ 'MOLH',  'Oberlindhart' ],
	[ 'SOW',   'Oberlinxweiler' ],
	[ 'KOM',   'Obermaubach' ],
	[ 'XFOM',  'Obermodern' ],
	[ 'SOBM',  'Obermohr' ],
	[ 'NOBN',  'Obernau' ],
	[ 'XAOM',  'Obernberg-Alth' ],
	[ 'NOE',   'Obernbg-Elsenf' ],
	[ 'TOB',   'Oberndorf (N)' ],
	[ 'EOBW',  'Oberndorf /Wittg' ],
	[ 'DOBN',  'Oberneuschönberg' ],
	[ 'FOBH',  'Obernhof (Lahn)' ],
	[ 'HOBJ',  'Obernjesa' ],
	[ 'HOBK',  'Obernkirchen' ],
	[ 'NOBZ',  'Obernzell' ],
	[ 'DOZO',  'Oberoderw Odf' ],
	[ 'DOZA',  'Oberoderwi Abzw' ],
	[ 'DOZ',   'Oberoderwitz' ],
	[ 'DOD',   'Oberottendorf' ],
	[ 'MOMN',  'Oberottmarshsn' ],
	[ 'ROOE',  'Oberöwisheim' ],
	[ 'XSOR',  'Oberrieden' ],
	[ 'XSOT',  'Oberriet' ],
	[ 'UQOR',  'Oberröblgen LGr' ],
	[ 'UOR',   'Oberröblingen' ],
	[ 'UORO',  'Oberrohn' ],
	[ 'DOH',   'Oberrothenbach' ],
	[ 'ROBL',  'Oberrotweil' ],
	[ 'ROSC',  'Oberschefflenz' ],
	[ 'MOSM',  'Oberschleißheim' ],
	[ 'DOSC',  'Oberschlottwitz' ],
	[ 'BOB',   'Obersdorf' ],
	[ 'NOBS',  'Obersinn' ],
	[ 'BOSP',  'Oberspree' ],
	[ 'MOSF',  'Oberstaufen' ],
	[ 'MOF',   'Oberstdorf' ],
	[ 'XFOZ',  'Oberstinzel' ],
	[ 'NOT',   'Obertraubling' ],
	[ 'FOTS',  'Obertshsn(Kr Of)' ],
	[ 'ROT',   'Obertsrot/Murgt' ],
	[ 'FOU',   'Oberursel (Ts)' ],
	[ 'DOG',   'Obervogelgesang' ],
	[ 'UOB',   'Oberweimar' ],
	[ 'UOW',   'Oberweißbach-D' ],
	[ 'NOBW',  'Oberwerrn' ],
	[ 'FOBW',  'Oberwesel' ],
	[ 'ROD',   'Oberwinden' ],
	[ 'KOWI',  'Oberwinter' ],
	[ 'TOBZ',  'Oberzell' ],
	[ 'KOZS',  'Oberzissen' ],
	[ 'MOBG',  'Obing' ],
	[ 'ROBK',  'Ob-Koehlersiedlg' ],
	[ 'EOS M', 'Ob-Osterf Mitte' ],
	[ 'EOS U', 'Ob-Osterf Museum' ],
	[ 'EOS T', 'Ob-Osterf Ost' ],
	[ 'EOS B', 'Ob-Osterf Ostb' ],
	[ 'EOS P', 'Ob-Osterf Süd' ],
	[ 'EOS E', 'Ob-Osterf West' ],
	[ 'EOS G', 'Ob-Osterf Westb' ],
	[ 'EOS',   'Ob-Osterfeld' ],
	[ 'XBOB',  'Obourg' ],
	[ 'XTOB',  'Obratan' ],
	[ 'EOSD',  'Ob-Sterkrade' ],
	[ 'UOFM',  'Obstfelderschm' ],
	[ 'NOK',   'Ochenbruck' ],
	[ 'HOCG',  'Ocholt DB-Gr' ],
	[ 'NOF',   'Ochsenfurt' ],
	[ 'LOL',   'Ochtmersleben' ],
	[ 'EOP',   'Ochtrup' ],
	[ 'HOCB',  'Ochtrup-Brechte' ],
	[ 'FOCK',  'Ockenheim' ],
	[ 'XFOQ',  'Ocquerre' ],
	[ 'XDON',  'Oddesund Nord' ],
	[ 'KODE',  'Odendorf' ],
	[ 'RODH',  'Odenheim' ],
	[ 'RODW',  'Odenheim West' ],
	[ 'XDOD',  'Odense' ],
	[ 'BODK',  'Oderbrücke' ],
	[ 'BQOD',  'Oderbrücke LGr' ],
	[ 'BOD',   'Oderin' ],
	[ 'ZUO',   'Odessa-Glavnaia' ],
	[ 'TODH',  'Ödheim' ],
	[ 'LOE',   'Oebisfelde' ],
	[ 'LQOE',  'Oebisfelde 6107' ],
	[ 'LQOES', 'Oebisfelde 6399' ],
	[ 'DOR',   'Oederan' ],
	[ 'BOEG',  'Oegeln' ],
	[ 'LOEH',  'Oehna' ],
	[ 'EOEL',  'Oelde' ],
	[ 'XDOG',  'Oelgod' ],
	[ 'DOE',   'Oelsnitz (Erzg)' ],
	[ 'DOV',   'Oelsnitz (Vogtl)' ],
	[ 'DOE B', 'Oelsnitz Bf Str' ],
	[ 'AOE',   'Oerel' ],
	[ 'AOES',  'Oerel Süd' ],
	[ 'NOER',  'Oerlenbach' ],
	[ 'EOER',  'Oerlinghausen' ],
	[ 'XFOE',  'Oermingen' ],
	[ 'KOTB',  'Oermterberg' ],
	[ 'WOE',   'Oertzenhof' ],
	[ 'EOES',  'Oese' ],
	[ 'HOES',  'Oesede' ],
	[ 'XDOP',  'Oesterport' ],
	[ 'FOE',   'Oestr-Winkel' ],
	[ 'XLOE',  'Oetrange' ],
	[ 'MOET',  'Oettingen (Bay)' ],
	[ 'EOVP',  'Oeventrop' ],
	[ 'HOYGA', 'Oeynhausen Abzw' ],
	[ 'HOFD',  'Ofenerdiek' ],
	[ 'ROKS',  'Off Schulzentrum' ],
	[ 'ROU',   'Offenau' ],
	[ 'FOO',   'Offenb (M) Ost' ],
	[ 'FOLM',  'Offenb Ledermus' ],
	[ 'FOMP',  'Offenb Marktpl' ],
	[ 'FOWH',  'Offenbach Waldhf' ],
	[ 'FO G',  'Offenbach(M) Gbf' ],
	[ 'FO',    'Offenbach(M) Hbf' ],
	[ 'FOBI',  'Offenbach-Bieber' ],
	[ 'RO N',  'Offenbg nördl Es' ],
	[ 'RO S',  'Offenbg südl Es' ],
	[ 'FOKL',  'Offenb-Kaiserlei' ],
	[ 'RO',    'Offenburg' ],
	[ 'ROG',   'Offenburg Gbf' ],
	[ 'ROG A', 'Offenburg Gbf A' ],
	[ 'ROG E', 'Offenburg Gbf E' ],
	[ 'TOFS',  'Offenhausen' ],
	[ 'HQOF',  'Offensen NI/HE' ],
	[ 'HOFN',  'Offensen/North' ],
	[ 'MOFF',  'Offingen' ],
	[ 'ROFH',  'Oftersheim' ],
	[ 'XIOG',  'Oggiono' ],
	[ 'XROG',  'Ogulin' ],
	[ 'AOPS',  'Ohlsdorf(S-Bahn)' ],
	[ 'MOH',   'Ohlstadt' ],
	[ 'HODF',  'Ohrdorf' ],
	[ 'UOH',   'Ohrdruf' ],
	[ 'TOE',   'Öhringen Hbf' ],
	[ 'TOEW',  'Öhringen/West' ],
	[ 'TOBG',  'Ohrnberg' ],
	[ 'AOR',   'Ohrstedt' ],
	[ 'FOK',   'Okarben' ],
	[ 'HOK',   'Oker' ],
	[ 'HOKB',  'Okerbrücke' ],
	[ 'XOOK',  'Oklungen' ],
	[ 'XDOB',  'Oksboel' ],
	[ 'XROK',  'Okucani' ],
	[ 'XPOWA', 'Olawa' ],
	[ 'DOL',   'Olbernhau' ],
	[ 'DOLW',  'Olbernhau West' ],
	[ 'DOGT',  'Olbernh-Grünthal' ],
	[ 'DODN',  'Olbersdorf Nddf' ],
	[ 'DODO',  'Olbersdorf Oberd' ],
	[ 'UOL',   'Olbersleben' ],
	[ 'TOED',  'Ölbronn-Dürrn' ],
	[ 'MOL',   'Olching' ],
	[ 'HOLD',  'Oldb (Oldb) Hbf' ],
	[ 'HOLO',  'Oldenbg-Osternbg' ],
	[ 'HOLB',  'Oldenbüttel' ],
	[ 'AOL A', 'Oldenburg(H) Gbf' ],
	[ 'AOL',   'Oldenburg(Holst)' ],
	[ 'HOLW',  'Oldenb-Wechloy' ],
	[ 'EOLT',  'Oldentrup' ],
	[ 'XNOD',  'Oldenzaal' ],
	[ 'HODH',  'Oldershsn(Harbg)' ],
	[ 'HODU',  'Oldersum' ],
	[ 'HHMG',  'Old-Hemmelsberg' ],
	[ 'XTOL',  'Oldrichov u N' ],
	[ 'XIOL',  'Oleggio' ],
	[ 'XBOL',  'Olen' ],
	[ 'XPOR',  'Olesnica Rataje' ],
	[ 'XIOO',  'Olevano' ],
	[ 'XIOM',  'Olivetta S Mich' ],
	[ 'TOHS',  'Olnhausen' ],
	[ 'XVOL',  'Olofstrom' ],
	[ 'XTO',   'Olomouc hl.n.' ],
	[ 'XTOM',  'Olomouc Mesto' ],
	[ 'XTOV',  'Olovi' ],
	[ 'EOLP',  'Olpe' ],
	[ 'EOLS',  'Olsberg' ],
	[ 'SOU',   'Olsbrücken' ],
	[ 'XPOL',  'Olsztyn Glowny' ],
	[ 'XPOLZ', 'Olsztyn Zachodni' ],
	[ 'XSOL',  'Olten' ],
	[ 'XSON',  'Olten Nord' ],
	[ 'BOLS',  'Olympiastadion' ],
	[ 'XNOM',  'Ommen' ],
	[ 'XCOM',  'Omsk-Passajirski' ],
	[ 'XNON',  'Onnen' ],
	[ 'ROEN',  'Önsbach' ],
	[ 'XFO',   'Onville' ],
	[ 'XBO',   'Oostende' ],
	[ 'XPOP',  'Opalenica' ],
	[ 'XROM',  'Opatija-Matulji' ],
	[ 'XNOP',  'Opheusden B r o' ],
	[ 'KOPL',  'Opladen' ],
	[ 'KOPLM', 'Opladen Mitte' ],
	[ 'XPO',   'Opole Glowne' ],
	[ 'XOOP',  'Oppdal' ],
	[ 'ROP',   'Oppenau' ],
	[ 'AOPD',  'Oppendorf' ],
	[ 'AOPDK', 'Oppendorf Kraftw' ],
	[ 'FOPP',  'Oppenheim' ],
	[ 'TOP',   'Oppenweiler (Wü)' ],
	[ 'FOPN',  'Oppershofen' ],
	[ 'XOOH',  'Opphus' ],
	[ 'XSOP',  'Oppikon' ],
	[ 'UOG',   'Oppurg' ],
	[ 'XBOW',  'Opwijk' ],
	[ 'XIOA',  'Ora/Auer' ],
	[ 'XUOE',  'Oradea Est' ],
	[ 'ZWOC',  'Orancycy' ],
	[ 'XFOR',  'Orange' ],
	[ 'LOR K', 'Oranienbaum Kr' ],
	[ 'LOR',   'Oranienbaum(Anh)' ],
	[ 'BOR',   'Oranienburg' ],
	[ 'BORB',  'Oranienburg S-B' ],
	[ 'BORS',  'OranienburgerStr' ],
	[ 'XFOC',  'Orchies' ],
	[ 'XVO',   'Örebro C' ],
	[ 'XMOG',  'Öreglak' ],
	[ 'XDOH',  'Orehoved' ],
	[ 'XCOB',  'Orenburg' ],
	[ 'XDKHO', 'Örestad' ],
	[ 'XROV',  'Oriovac' ],
	[ 'UO',    'Orlamünde' ],
	[ 'XFOL',  'Orleans' ],
	[ 'XVOY',  'Ormaryd' ],
	[ 'XGOM',  'Ormenion' ],
	[ 'XZO',   'Ormoz' ],
	[ 'XMOH',  'Oroshaza' ],
	[ 'ZWO',   'Orscha-Centraln' ],
	[ 'RORW',  'Orschweier' ],
	[ 'XCOR',  'Orsk' ],
	[ 'XUOS',  'Orsova' ],
	[ 'KORY',  'Orsoy' ],
	[ 'XIO',   'Orte' ],
	[ 'XMOT',  'Örtilos' ],
	[ 'BORT',  'Ortrand' ],
	[ 'BQOR',  'Ortrand BB/SN' ],
	[ 'XMOV',  'Örvenyes' ],
	[ 'XIOV',  'Orvieto' ],
	[ 'HORX',  'Orxhausen' ],
	[ 'XPOZ',  'Orzysz' ],
	[ 'XOOS',  'Os' ],
	[ 'KOSB',  'Osberghausen' ],
	[ 'DOT',   'Oschatz' ],
	[ 'DOT K', 'Oschatz Körnerst' ],
	[ 'DOT L', 'Oschatz Lichtstr' ],
	[ 'DOTS',  'Oschatz Süd' ],
	[ 'LO',    'Oschersleben' ],
	[ 'BOSS',  'Osdorfer Straße' ],
	[ 'XRO',   'Osijek' ],
	[ 'ZWXOS', 'Osinowka Gr RU' ],
	[ 'XCOS',  'Osinski' ],
	[ 'XVOH',  'Oskarshamn' ],
	[ 'XVOS',  'Oskarström' ],
	[ 'XMOK',  'Öskü' ],
	[ 'XOO',   'Oslo' ],
	[ 'HOHT',  'Osn Altstadt' ],
	[ 'HO S',  'Osn Hbf Schinkel' ],
	[ 'HO N',  'Osn Hbf Vorbf' ],
	[ 'HOR O', 'Osn Rbf Oro' ],
	[ 'HOR S', 'Osn Rbf Ors' ],
	[ 'HO',    'Osnabrück Hbf' ],
	[ 'HO O',  'Osnabrück Hbf Po' ],
	[ 'HO U',  'Osnabrück Hbf Pu' ],
	[ 'HORP',  'Osnabrück Süd' ],
	[ 'HOEG',  'Osn-Eversb DB-Gr' ],
	[ 'HQOE',  'Osn-Eversbg LGr' ],
	[ 'HOE',   'Osn-Eversburg' ],
	[ 'XIOT',  'Ospital. Trav' ],
	[ 'XNO',   'Oss' ],
	[ 'UOM',   'Oßmannstedt' ],
	[ 'XROT',  'Ostarije' ],
	[ 'EBRO',  'Ostbevern' ],
	[ 'BOG',   'Ostendgestell' ],
	[ 'HOSW',  'Ostenwalde' ],
	[ 'FVOE',  'Osterberg/EKZ' ],
	[ 'LOB',   'Osterburg' ],
	[ 'TO',    'Osterburken' ],
	[ 'HOSC',  'Ostercappeln' ],
	[ 'EOFE',  'Osterfeld' ],
	[ 'NOS',   'Osterhofen/Nbay' ],
	[ 'MOSH',  'Osterhofen/Obb' ],
	[ 'HOSS',  'Osterholz-Scharm' ],
	[ 'HOSG',  'Osterh-Sch DB-Gr' ],
	[ 'XION',  'Osteria Nuova' ],
	[ 'LOSM',  'Ostermark' ],
	[ 'MOM',   'Ostermünchen' ],
	[ 'XSOM',  'Ostermundingen' ],
	[ 'LOST',  'Osternienburg' ],
	[ 'HOTM',  'Osterode Mitte' ],
	[ 'HOTL',  'Osterode-Leege' ],
	[ 'AONA',  'Osterrönf Awanst' ],
	[ 'AON',   'Osterrönfeld' ],
	[ 'AOSO',  'Oster-Scharm Ost' ],
	[ 'AOSD',  'Ostersode' ],
	[ 'KOSS',  'Osterspai' ],
	[ 'AODT',  'Osterstedt' ],
	[ 'XVOSV', 'Östersunds Västr' ],
	[ 'LOT',   'Osterteich' ],
	[ 'HOTW',  'Osterwald' ],
	[ 'LON',   'Osterweddingen' ],
	[ 'XMOF',  'Ostffyasszonyfa' ],
	[ 'FOM',   'Osthm (b Butzb)' ],
	[ 'FOS',   'Osthm (Kr Hanau)' ],
	[ 'FOHF',  'Osthofen' ],
	[ 'XIOS',  'Ostiglia' ],
	[ 'BOKR',  'Ostkreuz (Bst E)' ],
	[ 'BOK',   'Ostkreuz (Ringb)' ],
	[ 'BOKS',  'Ostkreuz (S-B)' ],
	[ 'BOKN',  'Ostkreuz Nord' ],
	[ 'EOTN',  'Ostönnen' ],
	[ 'DOU',   'Ostrau' ],
	[ 'XTOH',  'Ostrava hl.n.' ],
	[ 'XTOK',  'Ostrava-Kunice' ],
	[ 'XTOI',  'Ostrava-Svinov' ],
	[ 'ZUOS',  'Ostriakovo' ],
	[ 'XPOS',  'Ostroda' ],
	[ 'XTOS',  'Ostrov nad Ohri' ],
	[ 'XPOW',  'Ostrow Wlkp' ],
	[ 'XTON',  'Ostrozska N.Ves' ],
	[ 'WBI',   'Ostseebad Binz' ],
	[ 'XIOU',  'Ostuni' ],
	[ 'XPOM',  'Oswiecim' ],
	[ 'XMOP',  'Osztopan' ],
	[ 'HOTF',  'Othfresen' ],
	[ 'AOH',   'Othmarschen' ],
	[ 'ROH',   'Ötigheim' ],
	[ 'TOET',  'Ötisheim' ],
	[ 'XOOT',  'Otta' ],
	[ 'HOTT',  'Ottbergen' ],
	[ 'DOP',   'Ottdf-Okr Fa. Ri' ],
	[ 'ROTU',  'Ottenau' ],
	[ 'DON',   'Ottendf-Okr Nord' ],
	[ 'DOS',   'Ottendf-Okr Süd' ],
	[ 'DOF',   'Ottendorf' ],
	[ 'DOK',   'Ottendorf-Okr Hp' ],
	[ 'ROTT',  'Ottenhöfen' ],
	[ 'ROTW',  'Ottenhöfen West' ],
	[ 'MONH',  'Ottenhofen/Obb' ],
	[ 'NOBE',  'Ottenhofen-Berg' ],
	[ 'NOTS',  'Ottensoos' ],
	[ 'MOTF',  'Otterfing' ],
	[ 'AOF',   'Otterndorf' ],
	[ 'AOBG',  'Ottersberg (Han)' ],
	[ 'ROW',   'Ottersweier' ],
	[ 'LOTW',  'Otterwisch' ],
	[ 'MOTG',  'Otting' ],
	[ 'MOTW',  'Otting-Weilheim' ],
	[ 'MOBR',  'Ottobrunn' ],
	[ 'SOTW',  'Ottweiler (Saar)' ],
	[ 'SOTG',  'Ottweiler DB/SWE' ],
	[ 'XPOT',  'Otusz' ],
	[ 'HOTZ',  'Otze' ],
	[ 'NOZ',   'Otzing' ],
	[ 'XAOE',  'Ötztal' ],
	[ 'XNOW',  'Oudewater' ],
	[ 'FOUS',  'Ou-Stierstadt' ],
	[ 'XDOU',  'Outrup' ],
	[ 'FWN',   'Ou-Weißk/Steinb' ],
	[ 'XIOD',  'Ovada' ],
	[ 'XIODN', 'Ovada Nord' ],
	[ 'XXO',   'Ovar' ],
	[ 'LOV',   'Ovelgünne' ],
	[ 'KOV',   'Overath' ],
	[ 'XVOV',  'Överby' ],
	[ 'XVOB',  'Överumsbruk' ],
	[ 'XNOV',  'Overveen' ],
	[ 'XIOI',  'Oviglio' ],
	[ 'TOW',   'Owen (Teck)' ],
	[ 'AOS',   'Owschlag' ],
	[ 'XVOX',  'Öxnered' ],
	[ 'MOYM',  'Oy-Mittelberg' ],
	[ 'XMO',   'Ozd' ],
	[ 'XPOO',  'Ozorkow' ],
	[ 'XIOZ',  'Ozzano Monfer' ],
	[ 'BGOL',  'P Wissensch Golm' ],
	[ 'XIPW',  'P.Gardena/Waidbr' ],
	[ 'MADS',  'PA Scholz' ],
	[ 'MPBU',  'Paarbrücke' ],
	[ 'ZLPA',  'Pabrade' ],
	[ 'XDPA',  'Padborg' ],
	[ 'EPDG',  'Paderborn DB-Gr' ],
	[ 'EPD G', 'Paderborn Gbf' ],
	[ 'EPD',   'Paderborn Hbf' ],
	[ 'EPDN',  'Paderborn Nord' ],
	[ 'LPD',   'Paditz' ],
	[ 'XIPP',  'Padova' ],
	[ 'XIPPM', 'Padova C d Marte' ],
	[ 'XIPPI', 'Padova Interpor.' ],
	[ 'KPFF',  'Paffendorf' ],
	[ 'XFPS',  'Pagny-s-Moselle' ],
	[ 'XFPVR', 'Pagny-Vandieres' ],
	[ 'MPD',   'Paindorf' ],
	[ 'XYPA',  'Palarikovo' ],
	[ 'XIPLV', 'Palazzolo Vercel' ],
	[ 'XPPA',  'Paledzie' ],
	[ 'XGPA',  'Paleofarsalos' ],
	[ 'XIPA',  'Palermo C' ],
	[ 'XIPLO', 'Palestro' ],
	[ 'XIPAM', 'Palmanova' ],
	[ 'XHP',   'Paltamo' ],
	[ 'SPZ',   'Palzem' ],
	[ 'SQPZ',  'Palzem RP/SL' ],
	[ 'XEPP',  'Pamplona' ],
	[ 'XMPM',  'Pamuk' ],
	[ 'NPK',   'Pankofen' ],
	[ 'BPHD',  'Pankow-Heinersdf' ],
	[ 'APF',   'Pansdorf' ],
	[ 'XFPAN', 'Pantin' ],
	[ 'XIPL',  'Paola' ],
	[ 'XMP',   'Papa' ],
	[ 'HPAP',  'Papenburg (Ems)' ],
	[ 'WPF',   'Papendorf Hp' ],
	[ 'XNPP',  'Papendrecht B r' ],
	[ 'FOKG',  'Papierfabr DB-Gr' ],
	[ 'FPAP',  'Papierfabrik' ],
	[ 'FPAPK', 'Papierfabrik' ],
	[ 'UPM',   'Papiermühle' ],
	[ 'MPP',   'Pappenheim' ],
	[ 'XIPBG', 'Parabiago' ],
	[ 'XLPR',  'Paradiso' ],
	[ 'WPM',   'Parchim' ],
	[ 'XTPAR', 'Pardubice' ],
	[ 'XFPMP', 'Paris Montparnas' ],
	[ 'XFPN',  'Paris Nord' ],
	[ 'XFPA',  'Paris-Austerlitz' ],
	[ 'XFPO',  'Paris-Est' ],
	[ 'XFPG',  'Paris-G-d-Lyon' ],
	[ 'XFPC',  'Paris-La Chapell' ],
	[ 'XFPLV', 'Paris-La Villett' ],
	[ 'XFPSL', 'Paris-St-Lazare' ],
	[ 'ZWPB',  'Park Bug' ],
	[ 'WPA',   'Parkentin' ],
	[ 'NPUE',  'Parkstein-Hütten' ],
	[ 'XIPM',  'Parma' ],
	[ 'XAPD',  'Parndorf' ],
	[ 'HPAS',  'Parsau' ],
	[ 'NPB',   'Parsberg' ],
	[ 'NPAR',  'Partenstein' ],
	[ 'XVPT',  'Partille' ],
	[ 'WP',    'Pasewalk' ],
	[ 'WPO',   'Pasewalk Ost' ],
	[ 'XTPAS', 'Paskov' ],
	[ 'XPPK',  'Paslek' ],
	[ 'NPAG',  'Passau DB-Gr' ],
	[ 'NPA G', 'Passau Gbf' ],
	[ 'NXPA',  'Passau Grenze' ],
	[ 'NPA',   'Passau Hbf' ],
	[ 'NPA P', 'Passau Hbf Vogl' ],
	[ 'NZP',   'Passau Zahnradf' ],
	[ 'NPAO',  'Passau-Rosenau' ],
	[ 'WPAW',  'Passow (Meckl)' ],
	[ 'WPS',   'Passow (Uckerm)' ],
	[ 'WPSG',  'Passow DB-Grenze' ],
	[ 'XAPT',  'Paternion-Feistr' ],
	[ 'NPAD',  'Patersdorf' ],
	[ 'XGPT',  'Patras' ],
	[ 'XAPA',  'Patsch' ],
	[ 'HPTS',  'Pattensen(Lüneb)' ],
	[ 'XIPT',  'Patti S.Piero P.' ],
	[ 'XFPU',  'Pau' ],
	[ 'WPAUO', 'Paulinaue Ost' ],
	[ 'WPAU',  'Paulinenaue' ],
	[ 'UPA',   'Paulinzella' ],
	[ 'UP',    'Pausa' ],
	[ 'XUPU',  'Pausa (RO)' ],
	[ 'UQP',   'Pausa SN/TH' ],
	[ 'XIPVI', 'Pavia' ],
	[ 'XPPAW', 'Pawlowice' ],
	[ 'XPPAG', 'Pawlowice Gorn' ],
	[ 'XRPC',  'Pcelic' ],
	[ 'BQGB',  'Pd Griebns 6118' ],
	[ 'NPE',   'Pechbrunn' ],
	[ 'WWOP',  'Peenebrücke' ],
	[ 'WPD',   'Peenemünde' ],
	[ 'LPG',   'Pegau' ],
	[ 'LQPG',  'Pegau SN/ST' ],
	[ 'XAPG',  'Peggau-Deutschf' ],
	[ 'NPZ',   'Pegnitz' ],
	[ 'BPZ',   'Peickwitz' ],
	[ 'HP',    'Peine' ],
	[ 'HP G',  'Peine Gbf' ],
	[ 'HPED',  'Peine Ost' ],
	[ 'MPEI',  'Peiß' ],
	[ 'LPE',   'Peißen' ],
	[ 'MPBG',  'Peißenberg' ],
	[ 'MPBN',  'Peißenberg Nord' ],
	[ 'MPTN',  'Peiting Nord' ],
	[ 'MPTO',  'Peiting Ost' ],
	[ 'BPO',   'Peitz Ost' ],
	[ 'YBBPO', 'Peitz Ost Strw' ],
	[ 'EPK',   'Pelkum' ],
	[ 'SPM',   'Pelm' ],
	[ 'XFPTE', 'Peltre' ],
	[ 'XIPNG', 'Penango' ],
	[ 'MPZ',   'Penzberg Pbf' ],
	[ 'XBP',   'Pepinster' ],
	[ 'XCPE',  'Perebor' ],
	[ 'XCPO',  'Perevozskaia' ],
	[ 'XFPGX', 'Perigueux' ],
	[ 'MPRM',  'Perkam' ],
	[ 'XRPE',  'Perkovic' ],
	[ 'SPE',   'Perl' ],
	[ 'SXPE',  'Perl Grenze' ],
	[ 'WPB',   'Perleberg' ],
	[ 'XCPZ',  'Perm 2' ],
	[ 'XAPH',  'Pernh-Wulzeshofe' ],
	[ 'XWPR',  'Pernik' ],
	[ 'XTPEK', 'Pernink' ],
	[ 'XFPEA', 'Peronne' ],
	[ 'XFPE',  'Perpignan' ],
	[ 'XFPEG', 'Perrigny' ],
	[ 'XIPE',  'Pesaro' ],
	[ 'XIPC',  'Pescara C' ],
	[ 'XIPDG', 'Peschiera d Gard' ],
	[ 'XIP',   'Pescia' ],
	[ 'XIPSS', 'Pessione' ],
	[ 'XMPZ',  'Pesterzsebet' ],
	[ 'XLP',   'Petange' ],
	[ 'LPB',   'Petergrube' ],
	[ 'NPET',  'Petersaurach' ],
	[ 'NPEN',  'PetersaurachNord' ],
	[ 'WPE',   'Petershagen (Um)' ],
	[ 'BPEN',  'Petershagen Nord' ],
	[ 'HLAD',  'Petershag-Lahde' ],
	[ 'BPE',   'Petershain' ],
	[ 'MPE',   'Petershsn/Obb' ],
	[ 'XAPK',  'Peterskirchen' ],
	[ 'LPRO',  'Petersroda' ],
	[ 'LQPR',  'Petersroda ST/SN' ],
	[ 'XMPF',  'Petfürdö' ],
	[ 'XFPTC', 'Petit Croix' ],
	[ 'XFPQ',  'Petit Quevilly' ],
	[ 'UPE',   'Petriroda' ],
	[ 'XCPP',  'Petropavlovsk' ],
	[ 'XUPT',  'Petrosani' ],
	[ 'XTPK',  'Petrovice u Karv' ],
	[ 'XAPE',  'Pettneu' ],
	[ 'NPT',   'Pettstadt' ],
	[ 'TPHM',  'Pf Maihälden' ],
	[ 'BPF',   'Pfaffendorf (M)' ],
	[ 'RHBP',  'Pfaffengr/Wiebl' ],
	[ 'DPFH',  'Pfaffenhain' ],
	[ 'MPFH',  'Pfaffenhausen' ],
	[ 'MPF',   'Pfaffenhofen/Ilm' ],
	[ 'XSPF',  'Pfäffikon SZ' ],
	[ 'TPG',   'Pfäffingen' ],
	[ 'FPF',   'Pfahlgraben' ],
	[ 'SPF',   'Pfalzel' ],
	[ 'EPFB',  'Pfannenberg' ],
	[ 'MPKI',  'Pfarrkirchen' ],
	[ 'XAPFW', 'Pfarrwerfen' ],
	[ 'DMP',   'P-Fbr Marschwitz' ],
	[ 'FPD',   'Pfeddersheim' ],
	[ 'RP',    'Pfingstberg' ],
	[ 'RELP',  'Pfinzkanal Leoph' ],
	[ 'XAPL',  'Pflach' ],
	[ 'TPF',   'Pflaumloch' ],
	[ 'TQPF',  'Pflaumloch BW/BY' ],
	[ 'TPHG',  'Pforzheim DB/AVG' ],
	[ 'TPH',   'Pforzheim Hbf' ],
	[ 'MPFR',  'Pfraundorf (Inn)' ],
	[ 'NPD',   'Pfreimd' ],
	[ 'MPFD',  'Pfronten-Ried' ],
	[ 'MPFS',  'Pfronten-Stein' ],
	[ 'MPFW',  'Pfronten-Weißb' ],
	[ 'MXP',   'Pf-Steinach Gr' ],
	[ 'THP',   'Pfühlpark' ],
	[ 'THPG',  'Pfühlpark DB/AVG' ],
	[ 'FPU',   'Pfungstadt' ],
	[ 'RPB',   'Philippsbg (Bad)' ],
	[ 'WPH',   'Philippshagen' ],
	[ 'SPI',   'Philippsheim' ],
	[ 'XIPZ',  'Piacenza' ],
	[ 'XIPNA', 'Piana' ],
	[ 'XIPOG', 'Piano Orizzontal' ],
	[ 'XAPI',  'Pians' ],
	[ 'ZUP',   'Piatihatki' ],
	[ 'XUPN',  'Piatra Neamt' ],
	[ 'XUPO',  'Piatra Olt' ],
	[ 'BPIC',  'Pichelsberg' ],
	[ 'XAPC',  'Pichl' ],
	[ 'MPI',   'Piding' ],
	[ 'XIPV',  'Piedimonte V.S.L' ],
	[ 'XPPN',  'Piensk' ],
	[ 'XIPG',  'Pietra Ligure' ],
	[ 'XIPBA', 'Pietrabissara' ],
	[ 'XIPIE', 'Pietrasanta' ],
	[ 'XPPI',  'Pila Glowna' ],
	[ 'XPPW',  'Pilawa' ],
	[ 'BPIL',  'Pillgram' ],
	[ 'XAPV',  'Pill-Vomperbach' ],
	[ 'XCPI',  'Pilnia' ],
	[ 'XMPC',  'Pincehely' ],
	[ 'XEPI',  'Pineda' ],
	[ 'AP',    'Pinneberg' ],
	[ 'APS',   'Pinneberg SB' ],
	[ 'WPIN',  'Pinnow' ],
	[ 'XSXPT', 'Pino Grenze IT' ],
	[ 'XSPIT', 'Pino Transito' ],
	[ 'NPI',   'Pinzberg' ],
	[ 'XIPIL', 'Pioltello Limito' ],
	[ 'XIPB',  'Piombino' ],
	[ 'XIPBM', 'Piombino Maritti' ],
	[ 'XPPT',  'Piotrkow Trybun' ],
	[ 'MPIC',  'Pirach' ],
	[ 'DPK',   'Pirk' ],
	[ 'SPS',   'Pirmasens Hbf' ],
	[ 'SPSN',  'Pirmasens Nord' ],
	[ 'DPI',   'Pirna' ],
	[ 'DPI G', 'Pirna Gbf' ],
	[ 'DPIC',  'Pirna-Copitz' ],
	[ 'DPIN',  'Pirna-Copitz N' ],
	[ 'XJP',   'Pirot' ],
	[ 'XIPI',  'Pisa C' ],
	[ 'XIPIR', 'Pisa S.Rossore' ],
	[ 'XIPIP', 'Pisciotta' ],
	[ 'XTPC',  'Pisecna' ],
	[ 'XTPIZ', 'Pisek zast' ],
	[ 'XFPI',  'Pisseleux' ],
	[ 'XFPIT', 'Pithiviers' ],
	[ 'XRPT',  'Pitomaca' ],
	[ 'XZPV',  'Pivka' ],
	[ 'XAPID', 'Pixendorf' ],
	[ 'FKPDE', 'Pl d D Einheit' ],
	[ 'DSRB',  'Pl(V)-Straßberg' ],
	[ 'WPZ',   'Plaaz' ],
	[ 'WPZA',  'Plaaz Abzw' ],
	[ 'KPL',   'Plaidt' ],
	[ 'XTPA',  'Plana u Mar.Laz.' ],
	[ 'MPL',   'Planegg' ],
	[ 'MAPL',  'Planegg Awanst' ],
	[ 'MPLU',  'Planegg Üst' ],
	[ 'BPWA',  'Plänterwald' ],
	[ 'WPLM',  'Plate (Meckl)' ],
	[ 'NPL',   'Plattling' ],
	[ 'XGP',   'Platy' ],
	[ 'UPL',   'Plaue (Thür)' ],
	[ 'DPM',   'Plauen (V) Mitte' ],
	[ 'DP',    'Plauen (V) ob Bf' ],
	[ 'DPW',   'Plauen (V) West' ],
	[ 'DPZ',   'Plauen Zellwolle' ],
	[ 'DPU',   'Plauen(V) unt Bf' ],
	[ 'DPC',   'Plauen-Chrieschw' ],
	[ 'WPUQ',  'Plau-Quetzin' ],
	[ 'XTPLY', 'Plavy' ],
	[ 'NPLF',  'Pleinfeld' ],
	[ 'NPLG',  'Pleinting' ],
	[ 'EPLE',  'Pleister' ],
	[ 'XTPLA', 'Plesna' ],
	[ 'DXBD',  'Plesna Gr' ],
	[ 'BP',    'Plessa' ],
	[ 'EPLT',  'Plettenberg' ],
	[ 'EPLM',  'Plettenberg M.' ],
	[ 'XWP',   'Pleven' ],
	[ 'XRP',   'Ploce' ],
	[ 'TP',    'Plochingen' ],
	[ 'XPPL',  'Plock' ],
	[ 'XUPV',  'Ploiesti Vest' ],
	[ 'XFPSM', 'Plombiere-St Ma' ],
	[ 'APLN',  'Plön' ],
	[ 'XPPLO', 'Plonsk' ],
	[ 'XPPLY', 'Ploty' ],
	[ 'XWPL',  'Plovdiv' ],
	[ 'TPL',   'Plüderhausen' ],
	[ 'WPSW',  'Plüschow' ],
	[ 'XTPZ',  'Plzen hl.n.' ],
	[ 'XTPP',  'Plzen-Jizni pred' ],
	[ 'BMQU',  'P-Marquardt' ],
	[ 'XTPN',  'Pnovany' ],
	[ 'XIPCP', 'Pocapaglia' ],
	[ 'XTPCY', 'Pocerady' ],
	[ 'XAPN',  'Pöchlarn' ],
	[ 'DPF',   'Pockau-Lengefeld' ],
	[ 'MPKG',  'Pocking' ],
	[ 'XTPB',  'Podborany' ],
	[ 'XCPG',  'Podgornoe' ],
	[ 'XYPH',  'Podhajska' ],
	[ 'ZBPO',  'Podlugovi' ],
	[ 'XUPD',  'Podu Olt' ],
	[ 'XWPD',  'Podujane Raz' ],
	[ 'ZUPZ',  'Podzamche' ],
	[ 'BPOE',  'Poelchaustraße' ],
	[ 'APOF',  'Pogeez' ],
	[ 'HPOG',  'Poggenhagen' ],
	[ 'XIPR',  'Poggio Rusco' ],
	[ 'FPOL',  'Pohlgöns' ],
	[ 'NPOI',  'Poikam' ],
	[ 'MPO',   'Poing' ],
	[ 'XFPT',  'Poitiers' ],
	[ 'HPOI',  'Poitzen' ],
	[ 'WPOE',  'Pölchow' ],
	[ 'XMPT',  'Polgardi-Ipartel' ],
	[ 'XPPC',  'Police Chemia' ],
	[ 'XIPO',  'Polignano a Mare' ],
	[ 'MPN',   'Polling' ],
	[ 'NPG',   'Pölling' ],
	[ 'UPW',   'Pöllwitz' ],
	[ 'UQPW',  'Pöllwitz TH/SN' ],
	[ 'XYPO',  'Polomka' ],
	[ 'XAPS',  'Pöls' ],
	[ 'BPOL',  'Polzen' ],
	[ 'XXPB',  'Pombal' ],
	[ 'XTPI',  'Pomezi n O' ],
	[ 'XIPMP', 'Pomezia S.P.' ],
	[ 'NPOM',  'Pommelsbrunn' ],
	[ 'NPMH',  'Pommelsbrunn Hp' ],
	[ 'SPOM',  'Pommern (Mosel)' ],
	[ 'DPOM',  'Pommritz' ],
	[ 'ZUPM',  'Pomoshnaia' ],
	[ 'DPO',   'Ponitz' ],
	[ 'LPOE',  'Pönitz (b Lpz)' ],
	[ 'APN',   'Pönitz (Holst)' ],
	[ 'XFPM',  'Pont-a-Mousson' ],
	[ 'XIPN',  'Pontecagnano' ],
	[ 'XIPCR', 'Pontecurone' ],
	[ 'XIPTI', 'Ponti' ],
	[ 'XSPT',  'Pontresina' ],
	[ 'XFPXE', 'Pont-Ste-Maxence' ],
	[ 'XFPV',  'Pont-St-Vincent' ],
	[ 'XRPP',  'Popovaca' ],
	[ 'XWPP',  'Popovo' ],
	[ 'APB',   'Poppenbüttel' ],
	[ 'WRP',   'Poppendorf' ],
	[ 'WRPG',  'Poppendorf DB-Gr' ],
	[ 'NPOP',  'Poppenhausen' ],
	[ 'XYPT',  'Poprad-Tatry' ],
	[ 'XPPO',  'Porazyn' ],
	[ 'XIPD',  'Pordenone' ],
	[ 'ZLPO',  'Porece' ],
	[ 'XMPP',  'Porpac' ],
	[ 'DPSC',  'Porschdorf' ],
	[ 'UPF',   'Porstendorf' ],
	[ 'XFPR',  'Port Vendres' ],
	[ 'HPTH',  'Porta Westf Hp' ],
	[ 'XIPCM', 'Portacomaro' ],
	[ 'XEPB',  'Port-Bou' ],
	[ 'XFPAA', 'Port-d\'Atelier' ],
	[ 'XIPS',  'Porto S Giorg.Fe' ],
	[ 'XAPW',  'Pörtschach a.W.' ],
	[ 'KPR',   'Porz (Rhein)' ],
	[ 'KPRH',  'Porz (Rhein) Hp' ],
	[ 'KPH',   'Porz-Heumar' ],
	[ 'KPK',   'Porz-Königsforst' ],
	[ 'KPW',   'Porz-Wahn' ],
	[ 'KPW N', 'Porz-Wahn Nord' ],
	[ 'KPW S', 'Porz-Wahn Süd' ],
	[ 'WPWK',  'Posewald' ],
	[ 'WPOW',  'Posewald Hp' ],
	[ 'NPOE',  'Pösing' ],
	[ 'MPH',   'Possenhofen' ],
	[ 'UPS',   'Pößneck ob Bf' ],
	[ 'UPSU',  'Pößneck unt Bf' ],
	[ 'NPOH',  'Postbauer-Heng' ],
	[ 'KKPO',  'Posthof' ],
	[ 'XZPJ',  'Postojna' ],
	[ 'XTPS',  'Postredni-Sucha' ],
	[ 'BPDC',  'Potsd.Charlotten' ],
	[ 'BPD',   'Potsdam Hbf' ],
	[ 'BPDH',  'Potsdam Hbf S-B' ],
	[ 'BWP',   'Potsdam Park S' ],
	[ 'BPDP',  'Potsdam Pirschh' ],
	[ 'BPOP',  'Potsdamer Platz' ],
	[ 'BRC',   'Potsd-Rehbrücke' ],
	[ 'XTPO',  'Potucky' ],
	[ 'XTPOZ', 'Potucky zastavka' ],
	[ 'XFPSU', 'Pougues-les-Eaux' ],
	[ 'XCPN',  'Povorino' ],
	[ 'XPPF',  'Poznan Franowo' ],
	[ 'XPPG',  'Poznan Glowny' ],
	[ 'XPPGO', 'Poznan Gorczyn' ],
	[ 'XPPJ',  'Poznan Junikowo' ],
	[ 'XPPS',  'Poznan Staroleka' ],
	[ 'XPPWO', 'Poznan Wola' ],
	[ 'XPPWS', 'Poznan Wschod' ],
	[ 'XIPF',  'Pozzolo Formig' ],
	[ 'XIPOS', 'Pozzuoli Solfat' ],
	[ 'EPRA',  'Praest' ],
	[ 'XXPR',  'Pragal' ],
	[ 'TPT',   'Pragtunnel' ],
	[ 'XTP',   'Praha hl.n.' ],
	[ 'XTPJ',  'Praha ONJ' ],
	[ 'XTPBU', 'Praha-Bubny' ],
	[ 'XTPH',  'Praha-Holesovice' ],
	[ 'XTPL',  'Praha-Liben' ],
	[ 'XTPMA', 'Praha-Malesice' ],
	[ 'XTPD',  'Praha-Radotin' ],
	[ 'XTPM',  'Praha-Smichov' ],
	[ 'XTPU',  'Praha-Uhrineves' ],
	[ 'XTPV',  'Praha-Vrsovice' ],
	[ 'XTPY',  'Praha-Vysehrad' ],
	[ 'XTPZI', 'Praha-Zizkov' ],
	[ 'XTPZL', 'Praha-Zlicin' ],
	[ 'XYPRZ', 'Prakovce zast' ],
	[ 'XAPM',  'Pram-Haag' ],
	[ 'BPM',   'Pramsdorf' ],
	[ 'XIPCO', 'Prasco-Cremolino' ],
	[ 'LPT',   'Pratau' ],
	[ 'LPTG',  'Pratau DB-Gr' ],
	[ 'XIPRT', 'Prato Centrale' ],
	[ 'XSPR',  'Pratteln' ],
	[ 'XUP',   'Predeal' ],
	[ 'XIPRD', 'Predosa' ],
	[ 'APZ',   'Preetz' ],
	[ 'XAPR',  'Pregarten' ],
	[ 'XTPE',  'Prelouc' ],
	[ 'LPZ',   'Premnitz' ],
	[ 'LPZH',  'Premnitz Nord' ],
	[ 'LPZS',  'Premnitz Zentrum' ],
	[ 'XIPMC', 'Premosello-Ch' ],
	[ 'WPL',   'Prenzlau' ],
	[ 'WPLV',  'Prenzlau Vorst' ],
	[ 'WPLW',  'Prenzlau West' ],
	[ 'BPLA',  'Prenzlauer Allee' ],
	[ 'XTPR',  'Prerov' ],
	[ 'XJPR',  'Presevo' ],
	[ 'NPS',   'Pressath' ],
	[ 'NPR',   'Pressig-Rothenk' ],
	[ 'XZPR',  'Prestranek' ],
	[ 'NPRE',  'Pretzfeld' ],
	[ 'LPRZ',  'Pretzier (Altm)' ],
	[ 'LPH',   'Pretzsch' ],
	[ 'HPOL',  'Preuß Oldendorf' ],
	[ 'EPRN',  'Preußen' ],
	[ 'BPRG',  'Preußnitz DB-Gr' ],
	[ 'XYPB',  'Pribeta' ],
	[ 'XCPD',  'Pridacha' ],
	[ 'WPIG',  'Priemerbg DB-Gr' ],
	[ 'WPI',   'Priemerburg' ],
	[ 'MPR',   'Prien a Chiemsee' ],
	[ 'BPRS',  'Priesterweg' ],
	[ 'DPR',   'Priestewitz' ],
	[ 'ZBPR',  'Prijedor' ],
	[ 'EPVP',  'Prinz v Preußen' ],
	[ 'XAPRD', 'Prinzersdorf' ],
	[ 'BPOT',  'Priort' ],
	[ 'APD',   'Prisdorf' ],
	[ 'XTPRI', 'Prisovice' ],
	[ 'LPL',   'Pristäblich' ],
	[ 'UPZ',   'Prittitz' ],
	[ 'LPI',   'Pritzerbe' ],
	[ 'WPRZ',  'Pritzier' ],
	[ 'WPR',   'Pritzwalk' ],
	[ 'WPRG',  'Pritzwalk DB-Gr' ],
	[ 'WPRH',  'Pritzwalk Hainhz' ],
	[ 'WPRW',  'Pritzwalk West' ],
	[ 'APSH',  'Probsteierhagen' ],
	[ 'UPR',   'Probstzella' ],
	[ 'UQPR',  'Probstzella LGr' ],
	[ 'YLMPF', 'Probstzella Strw' ],
	[ 'LPRL',  'Prödel' ],
	[ 'LPR',   'Profen' ],
	[ 'XBPO',  'Profondsart' ],
	[ 'XGPM',  'Promachon' ],
	[ 'FWRY',  'Propan Rheingas' ],
	[ 'USAP',  'Propangasanlage' ],
	[ 'WPRA',  'Prora' ],
	[ 'WPRO',  'Prora Ost' ],
	[ 'XTPRN', 'Prosec nad Nisou' ],
	[ 'DPRO',  'Prösen' ],
	[ 'DPRW',  'Prösen West' ],
	[ 'BPW',   'Prösen-Wainsdf' ],
	[ 'EPRL',  'Prosper-Levin' ],
	[ 'XPPR',  'Pruszkow' ],
	[ 'XPPRS', 'Przeclaw Szprot' ],
	[ 'XPPRZ', 'Przemysl Glowny' ],
	[ 'XPPZ',  'Przeworsk' ],
	[ 'XPPRY', 'Przylep' ],
	[ 'XPPRO', 'Przywory Opolsk' ],
	[ 'XCPS',  'Pskov-Passajirsk' ],
	[ 'XZP',   'Ptuj' ],
	[ 'XFPB',  'Puberg' ],
	[ 'MPM',   'Puchheim' ],
	[ 'XAPO',  'Puch-Oberalm' ],
	[ 'XYPU',  'Puchov' ],
	[ 'KPUD',  'Puderbach' ],
	[ 'SPDR',  'Pünderich DB' ],
	[ 'XEPG',  'Puente Genil-H' ],
	[ 'KPUF',  'Puffendorf' ],
	[ 'XRPU',  'Pula' ],
	[ 'XPPUM', 'Pulawy Miasto' ],
	[ 'KPUL',  'Pulheim' ],
	[ 'MPUL',  'Pullach' ],
	[ 'MPU',   'Pulling b Freis' ],
	[ 'DPUL',  'Pulsnitz' ],
	[ 'DPUM',  'Pumpspeicherwerk' ],
	[ 'XAPZ',  'Pusarnitz' ],
	[ 'NPU',   'Puschendorf' ],
	[ 'XMPB',  'Pusztabereny' ],
	[ 'WPUB',  'Putbus' ],
	[ 'AXP',   'Puttgard M See' ],
	[ 'APU',   'Puttgarden' ],
	[ 'DPT',   'Putzkau' ],
	[ 'XPPY',  'Pyrzyce' ],
	[ 'XPPYK', 'Pyskowice' ],
	[ 'XCPY',  'Pytalovo' ],
	[ 'KQ',    'Quadrath-Ichend' ],
	[ 'HQ',    'Quakenbrück' ],
	[ 'KFQ',   'Quarzwerke' ],
	[ 'LQB',   'Quedlinburg' ],
	[ 'LQIS',  'Queis' ],
	[ 'EQL',   'Quelle' ],
	[ 'EQLK',  'Quelle Kupferh' ],
	[ 'EQL O', 'Quelle Ost' ],
	[ 'EQL W', 'Quelle West' ],
	[ 'LQ',    'Querfurt' ],
	[ 'LQUG',  'Querfurt DB-Gr' ],
	[ 'LQW',   'Querfurt West' ],
	[ 'LQKI',  'Querfurt Zuckerf' ],
	[ 'XBQ',   'Quevy' ],
	[ 'XBXQU', 'Quevy Gr FR' ],
	[ 'AQB',   'Quickborn' ],
	[ 'AQBD',  'Quickborn Süd' ],
	[ 'AQBS',  'Quickborner Str' ],
	[ 'SQS',   'Quierschied' ],
	[ 'XFQ',   'Quimper' ],
	[ 'SQI',   'Quint' ],
	[ 'UQU',   'Quittelsdorf' ],
	[ 'RRAM',  'Ra Daimler-Benz' ],
	[ 'XVRH',  'Rabbalshede' ],
	[ 'HRBB',  'Rabber' ],
	[ 'XIRCC', 'Racconigi' ],
	[ 'LRAK',  'Rackith (Elbe)' ],
	[ 'LRAS',  'Rackith Süd' ],
	[ 'LRK',   'Rackwitz (b Lpz)' ],
	[ 'ERDB',  'Radbod' ],
	[ 'ARH',   'Radbruch' ],
	[ 'BRAD',  'Raddusch' ],
	[ 'XORD',  'Rade' ],
	[ 'DRAG',  'Radeberg' ],
	[ 'DRBD',  'Radebeul Nord' ],
	[ 'DRB',   'Radebeul Ost' ],
	[ 'DRBW',  'Radebeul West' ],
	[ 'DRBK',  'Radebeul-Kötzsch' ],
	[ 'DRBN',  'Radebeul-Naundf' ],
	[ 'DRBT',  'Radebeul-Wein' ],
	[ 'DRB B', 'Radebl Ost Bstg' ],
	[ 'DRBA',  'Radeb-Naundf Abz' ],
	[ 'DRBZ',  'Radeb-Zitzsch' ],
	[ 'LRAD',  'Rademin' ],
	[ 'HRBK',  'Radenbeck' ],
	[ 'MRDD',  'Radersdorf' ],
	[ 'LRA',   'Radis' ],
	[ 'ZURA',  'Radivilov' ],
	[ 'NRA',   'Radldorf (Nbay)' ],
	[ 'XUR',   'Radna' ],
	[ 'RRZ',   'Radolfzell' ],
	[ 'RRZ G', 'Radolfzell Gbf' ],
	[ 'RRZB',  'Radolfz-Haselbr' ],
	[ 'XWRA',  'Radomir' ],
	[ 'XPRM',  'Radomsko' ],
	[ 'XARA',  'Radstadt' ],
	[ 'XBR',   'Raeren' ],
	[ 'ERAE',  'Raestrup-Eversw' ],
	[ 'ZURF',  'Rafalovka' ],
	[ 'XSRG',  'Räfis-Burgerau' ],
	[ 'XSRF',  'Rafz' ],
	[ 'BRA',   'Ragow Umspannw' ],
	[ 'LRH',   'Raguhn' ],
	[ 'LRHU',  'Raguhn Üst' ],
	[ 'HRAH',  'Rahden/Lübbecke' ],
	[ 'BRD',   'Rahnsdorf' ],
	[ 'BRDF',  'Rahnsdorf' ],
	[ 'RMHR',  'Raiffeisen ZG' ],
	[ 'MRN',   'Rain' ],
	[ 'NRAF',  'Raindorf' ],
	[ 'AAR',   'Rainweg' ],
	[ 'ARS',   'Raisdorf' ],
	[ 'ARSW',  'Raisdorf West' ],
	[ 'MRAG',  'Raisting' ],
	[ 'NRAH',  'Raitersaich' ],
	[ 'DRH',   'Raitzhain' ],
	[ 'XMR',   'Rajka' ],
	[ 'XZR',   'Rakek' ],
	[ 'XMRA',  'Rakos' ],
	[ 'XMRU',  'Rakospalota-Ujp' ],
	[ 'XMRR',  'Rakosrendezö' ],
	[ 'WRAK',  'Rakow' ],
	[ 'WRMB',  'Rambin (Rügen)' ],
	[ 'XFRB',  'Rambucourt' ],
	[ 'MRMB',  'Ramerberg' ],
	[ 'HRAT',  'Ramhorst' ],
	[ 'SRCS',  'Rammelsb Steinbr' ],
	[ 'SRCH',  'Rammelsbach' ],
	[ 'RRAW',  'Rammelswiesen' ],
	[ 'TRM',   'Rammingen' ],
	[ 'MRAM',  'Rammingen (Bay)' ],
	[ 'RRBI',  'Ramsbach Birkhof' ],
	[ 'RRBH',  'Ramsbach-Höfle' ],
	[ 'NRAB',  'Ramsberg' ],
	[ 'RRN',   'Ramsen (Pfalz)' ],
	[ 'NRSL',  'Ramsenthal' ],
	[ 'XKR',   'Ramsgate' ],
	[ 'XKRP',  'Ramsgate Harbour' ],
	[ 'HRAM',  'Ramsloh' ],
	[ 'SRAS',  'Ramstein' ],
	[ 'XDRA',  'Randers' ],
	[ 'TRGD',  'Rangendingen' ],
	[ 'BRSF',  'Rangsdorf' ],
	[ 'TRA',   'Rankmühle' ],
	[ 'XARW',  'Rankweil' ],
	[ 'NRAAE', 'Ranna Bk 1' ],
	[ 'NRAAZ', 'Ranna Bk 2' ],
	[ 'FRAN',  'Ranstadt' ],
	[ 'XSRZ',  'Ranzo-S-Abbondio' ],
	[ 'RAPM',  'RAP Muhrhaag' ],
	[ 'XIRAP', 'Rapallo' ],
	[ 'XMRP',  'Raposka' ],
	[ 'URP',   'Rappelsdorf' ],
	[ 'XRRA',  'Rasa' ],
	[ 'DRAS',  'Raschau' ],
	[ 'XJRA',  'Raska' ],
	[ 'RRA',   'Rastatt' ],
	[ 'RRAB',  'Rastatt Beinle' ],
	[ 'RRAG',  'Rastatt DB/AVG' ],
	[ 'RRAS',  'Rastatt-Süd' ],
	[ 'HRST',  'Rastede' ],
	[ 'WRW',   'Rastow' ],
	[ 'ARAT',  'Ratekau' ],
	[ 'FKRAT', 'Rathaus' ],
	[ 'BRST',  'Rathaus Steglitz' ],
	[ 'LRW',   'Rathenow' ],
	[ 'LQRW',  'Rathenow BB/ST' ],
	[ 'LRWD',  'Rathenow DB-Gr' ],
	[ 'LRWG',  'Rathenow N Getr' ],
	[ 'LRWN',  'Rathenow Nord' ],
	[ 'DRD',   'Rathmannsdorf(P)' ],
	[ 'KRAO',  'Ratingen Ost' ],
	[ 'KRAW',  'Ratingen West' ],
	[ 'XARK',  'Rattenbg-Krams' ],
	[ 'ARF',   'Ratzeburg' ],
	[ 'LRI',   'Rätzlingen' ],
	[ 'KRAU',  'Raubach' ],
	[ 'MRA',   'Raubling' ],
	[ 'URAU',  'Rauenstein Thür' ],
	[ 'XORF',  'Raufoss' ],
	[ 'ERMA',  'Raumland-Markhsn' ],
	[ 'RRMZ',  'Raumünzach' ],
	[ 'DRU',   'Raun' ],
	[ 'FRA',   'Raunheim' ],
	[ 'FRW',   'Rauschwald' ],
	[ 'LRTB',  'Rautenbach' ],
	[ 'XIRAV', 'Ravenna' ],
	[ 'TRB',   'Ravensburg' ],
	[ 'XVRL',  'Rävlanda' ],
	[ 'XDRV',  'Ravnstrup' ],
	[ 'XURZ',  'Razboieni' ],
	[ 'ZURD',  'Razdelnaia 1' ],
	[ 'YFKWB', 'RB-Gr km 0,396' ],
	[ 'YFKEK', 'RB-Gr km 0,431' ],
	[ 'YLHOW', 'RB-Gr km 0,611' ],
	[ 'YLMBE', 'RB-Gr km 0,843' ],
	[ 'YFKLS', 'RB-Gr km 0,980' ],
	[ 'YEHLH', 'RB-Gr km 102,500' ],
	[ 'YDFHU', 'RB-Gr km 104,850' ],
	[ 'YMTBC', 'RB-Gr km 107,785' ],
	[ 'YBLST', 'RB-Gr km 110' ],
	[ 'YBLOR', 'RB-Gr km 110,000' ],
	[ 'YBLGR', 'RB-Gr km 112,500' ],
	[ 'YDFAB', 'RB-Gr km 113,200' ],
	[ 'YBLAG', 'RB-Gr km 113,750' ],
	[ 'YHFJL', 'RB-Gr km 113,800' ],
	[ 'YLMEC', 'RB-Gr km 114,228' ],
	[ 'YHLHS', 'RB-Gr km 117,070' ],
	[ 'YFKBK', 'RB-Gr km 12,792' ],
	[ 'YDFHS', 'RB-Gr km 120,000' ],
	[ 'YFKGK', 'RB-Gr km 13,100' ],
	[ 'YFHGH', 'RB-Gr km 132,000' ],
	[ 'YBLWB', 'RB-Gr km 137,000' ],
	[ 'YLHBL', 'RB-Gr km 14,850' ],
	[ 'YBLGS', 'RB-Gr km 143,562' ],
	[ 'YFRML', 'RB-Gr km 15,040' ],
	[ 'YMTFR', 'RB-Gr km 15,045' ],
	[ 'YLMGS', 'RB-Gr km 151,699' ],
	[ 'YLHAE', 'RB-Gr km 168,600' ],
	[ 'YLHOV', 'RB-Gr km 168,938' ],
	[ 'YBLGN', 'RB-Gr km 18,500' ],
	[ 'YHFGH', 'RB-Gr km 182,000' ],
	[ 'YLFGD', 'RB-Gr km 191,343' ],
	[ 'YEHEM', 'RB-Gr km 197,550' ],
	[ 'YKMGW', 'RB-Gr km 2,000' ],
	[ 'YFHAB', 'RB-Gr km 211,057' ],
	[ 'YLHIB', 'RB-Gr km 23,220' ],
	[ 'YFKAE', 'RB-Gr km 23,317' ],
	[ 'YBWSB', 'RB-Gr km 236,475' ],
	[ 'YDHDH', 'RB-Gr km 28,923' ],
	[ 'YHLVI', 'RB-Gr km 29,083' ],
	[ 'YDFES', 'RB-Gr km 29,658' ],
	[ 'YDFSW', 'RB-Gr km 291,046' ],
	[ 'YFKOR', 'RB-Gr km 3,100' ],
	[ 'YFKHW', 'RB-Gr km 3,366' ],
	[ 'YKMNS', 'RB-Gr km 30,800' ],
	[ 'YFNJ',  'RB-Gr km 32,000' ],
	[ 'YBHGG', 'RB-Gr km 32,200' ],
	[ 'YBLBO', 'RB-Gr km 33,030' ],
	[ 'YFKMO', 'RB-Gr km 36,000' ],
	[ 'YFKSR', 'RB-Gr km 36,760' ],
	[ 'YBLGB', 'RB-Gr km 37,000' ],
	[ 'YBLWG', 'RB-Gr km 37,900' ],
	[ 'YBLDG', 'RB-Gr km 37,940' ],
	[ 'YDFHA', 'RB-Gr km 41,000' ],
	[ 'YBLKG', 'RB-Gr km 42,447' ],
	[ 'YLMEO', 'RB-Gr km 44,000' ],
	[ 'YDFNR', 'RB-Gr km 44,160' ],
	[ 'YFHHL', 'RB-Gr km 44,800' ],
	[ 'YFKZH', 'RB-Gr km 50,309' ],
	[ 'YFKST', 'RB-Gr km 51,272' ],
	[ 'YKMNO', 'RB-Gr km 54,788' ],
	[ 'YFRLH', 'RB-Gr km 56,000' ],
	[ 'YBLBN', 'RB-Gr km 56,200' ],
	[ 'YKMWK', 'RB-Gr km 56,959' ],
	[ 'YLMMR', 'RB-Gr km 57,690' ],
	[ 'YKMAI', 'RB-Gr km 58,600' ],
	[ 'YFKIA', 'RB-Gr km 58,833' ],
	[ 'YEHHK', 'RB-Gr km 6,000' ],
	[ 'YDFSM', 'RB-Gr km 61,142' ],
	[ 'YBLDN', 'RB-Gr km 67,600' ],
	[ 'YBLBW', 'RB-Gr km 75,000' ],
	[ 'YBLLZ', 'RB-Gr km 78,343' ],
	[ 'YDFJP', 'RB-Gr km 79,483' ],
	[ 'YFMLH', 'RB-Gr km 79,710' ],
	[ 'YFHLO', 'RB-Gr km 8,400' ],
	[ 'YLHSN', 'RB-Gr km 82,631' ],
	[ 'YHELF', 'RB-Gr km 89,9' ],
	[ 'YHELH', 'RB-Gr km 89,900' ],
	[ 'YDHBB', 'RB-Gr km 94,500' ],
	[ 'YKMGN', 'RB-Gr km 95,782' ],
	[ 'YDHHB', 'RB-Gr km 98,600' ],
	[ 'YKMBE', 'RB-Gr km 99,960' ],
	[ 'YFMFH', 'RB-Gr.km 26,745' ],
	[ 'YFNLM', 'RB-Gr.km 264,930' ],
	[ 'YDFWB', 'RB-Grenze' ],
	[ 'FNRI',  'Rdg-Nd Roden Igl' ],
	[ 'FNRO',  'Rdg-Nieder Roden' ],
	[ 'XIREC', 'Re' ],
	[ 'MRH',   'Rebdorf-Hofmühle' ],
	[ 'RBBL',  'Rebland (Baden)' ],
	[ 'XSRM',  'Rebstein-Marbach' ],
	[ 'KREC',  'Rech' ],
	[ 'DRBG',  'Rechenberg' ],
	[ 'TRC',   'Rechtenstein' ],
	[ 'HRFD',  'Rechterfeld' ],
	[ 'LRC',   'Reckahn' ],
	[ 'LRCR',  'Reckahn Awanst' ],
	[ 'HRKE',  'Recke' ],
	[ 'NRDF',  'Reckendorf' ],
	[ 'ERFE',  'Reckenfeld' ],
	[ 'ERE',   'Recklinghsn Hbf' ],
	[ 'ERHO',  'Recklinghsn Ost' ],
	[ 'ERES',  'Recklinghsn Süd' ],
	[ 'SRWH',  'Reckweilerhof' ],
	[ 'XPRCY', 'Reczyn' ],
	[ 'XPRE',  'Reda' ],
	[ 'WRDL',  'Reddelich' ],
	[ 'XFRD',  'Reding' ],
	[ 'NRCU',  'Rednitzhemb Üst' ],
	[ 'NRCH',  'Rednitzhembach' ],
	[ 'XERG',  'Redondela de Gal' ],
	[ 'NRZ',   'Redwitz (Rodach)' ],
	[ 'ARES',  'Reeperbahn' ],
	[ 'XVRT',  'Reftele' ],
	[ 'NRHF',  'Reg Bayernhafen' ],
	[ 'NRAZ',  'Reg Hafen Abzw' ],
	[ 'NRHG',  'Reg Hafen DB-Gr' ],
	[ 'NBWH',  'Reg-Burgw Hp' ],
	[ 'NREG',  'Regen' ],
	[ 'NROB',  'Regensbg Ost' ],
	[ 'NRPH',  'Regensbg Prüfe' ],
	[ 'NRWA',  'Regensbg Walhal' ],
	[ 'NRPF',  'Regensbg-Prüfe' ],
	[ 'NRWU',  'Regensbg-Wutzlh' ],
	[ 'NRH B', 'Regensburg Bbf' ],
	[ 'NRH',   'Regensburg Hbf' ],
	[ 'NRGF',  'Regenstauf' ],
	[ 'XIRC',  'Reggio Cal Centr' ],
	[ 'XIRE',  'Reggio Emilia' ],
	[ 'LQRB',  'Regis-Breit LGr' ],
	[ 'LRB',   'Regis-Breitingen' ],
	[ 'NRU',   'Rehau' ],
	[ 'HRWE',  'Rehden-Wetschen' ],
	[ 'LRF',   'Rehfeld(Fak/Els)' ],
	[ 'BRE',   'Rehfelde' ],
	[ 'ERHI',  'Re-Hillen' ],
	[ 'WRA',   'Rehna' ],
	[ 'HRER',  'Rehren' ],
	[ 'EREH',  'Rehsiepen' ],
	[ 'SRW',   'Rehweiler' ],
	[ 'NREK',  'Reichelsd Keller' ],
	[ 'NNRU',  'Reichelsdorf Üst' ],
	[ 'FRHM',  'Reichelshm/Wett' ],
	[ 'RRU',   'Reichenau(Baden)' ],
	[ 'RRBK',  'Reichenb Kurpark' ],
	[ 'DRC',   'Reichenb(V)ob Bf' ],
	[ 'DRCH',  'Reichenbach (OL)' ],
	[ 'XSRC',  'Reichenbach Kt' ],
	[ 'RRBA',  'Reichenbach/Ettl' ],
	[ 'TRF',   'Reichenbach/Fils' ],
	[ 'TRCB',  'Reichenberg' ],
	[ 'XSRE',  'Reichenburg' ],
	[ 'NREI',  'Reichenschwand' ],
	[ 'RWSR',  'Reichentaler Str' ],
	[ 'MRCH',  'Reichersbeuern' ],
	[ 'MRS',   'Reichertshsn/Ilm' ],
	[ 'TRL',   'Reicholzheim' ],
	[ 'XFRE',  'Reichstett' ],
	[ 'NRWD',  'Reichswald' ],
	[ 'DRF',   'Reifl-Wünschend' ],
	[ 'RRIN',  'Reihen' ],
	[ 'SREI',  'Reil DB' ],
	[ 'RRHM',  'Reilsheim' ],
	[ 'XFRS',  'Reims' ],
	[ 'ARBK',  'Reinbek' ],
	[ 'AQRBK', 'Reinbek 1244' ],
	[ 'AQRB',  'Reinbek 6100' ],
	[ 'ARD',   'Reinfeld (Holst)' ],
	[ 'URN',   'Reinhardsb-Fried' ],
	[ 'FREI',  'Reinheim (Odenw)' ],
	[ 'ARE',   'Reinsbüttel' ],
	[ 'LRDB',  'Reinsdf Zement' ],
	[ 'LRDH',  'Reinsdorf' ],
	[ 'URD',   'Reinsdorf (b Ar)' ],
	[ 'URDN',  'Reinsdorf (b Nb)' ],
	[ 'XORV',  'Reinsvoll' ],
	[ 'RRSH',  'Reisen (Hess)' ],
	[ 'FRSK',  'Reiskir (Kr Gie)' ],
	[ 'XORI',  'Reitan' ],
	[ 'XARE',  'Reith' ],
	[ 'XDRE',  'Rejsby' ],
	[ 'XARWL', 'Rekawinkel' ],
	[ 'EREK',  'Reken' ],
	[ 'XSRN',  'Rekingen AG' ],
	[ 'ERKS',  'Rekostein' ],
	[ 'KRE',   'Remagen' ],
	[ 'XFRF',  'Remelfing' ],
	[ 'XFRM',  'Remilly' ],
	[ 'XFRT',  'Remiremont' ],
	[ 'ERMH',  'Remmighausen' ],
	[ 'KR',    'Remscheid Hbf' ],
	[ 'KRL',   'Remscheid-Lennep' ],
	[ 'XORN',  'Rena' ],
	[ 'RR',    'Renchen' ],
	[ 'AR',    'Rendsburg' ],
	[ 'ARG',   'Rendsburg DB-Gr' ],
	[ 'ARHB',  'Rendsburg Hochbr' ],
	[ 'KDNR',  'Renkerstraße' ],
	[ 'XFR',   'Rennes' ],
	[ 'TRX',   'Renningen' ],
	[ 'TRXS',  'Renningen Süd' ],
	[ 'RRE',   'Rennplatz' ],
	[ 'UREN',  'Rennsteig' ],
	[ 'XBRP',  'Renory-Port' ],
	[ 'SRE',   'Rentrisch' ],
	[ 'NREN',  'Rentweinsdorf' ],
	[ 'URH',   'Rentwertshausen' ],
	[ 'URM',   'Rentzschmühle' ],
	[ 'XURS',  'Resita Sud' ],
	[ 'XTRE',  'Retenice' ],
	[ 'KRET',  'Rethel' ],
	[ 'HRTN',  'Rethen (Leine)' ],
	[ 'XMRT',  'Retszilas' ],
	[ 'HREM',  'Rettmer' ],
	[ 'NREZ',  'Retzb-Zellingen' ],
	[ 'LREU',  'Reuden(Kr Zeitz)' ],
	[ 'URR',   'Reurieth' ],
	[ 'LRE',   'Reußen' ],
	[ 'DREU',  'Reust' ],
	[ 'DRTH',  'Reuth (b Plauen)' ],
	[ 'NRT',   'Reuth(b Erbend)' ],
	[ 'TREB',  'Reutl-Betzingen' ],
	[ 'TRE',   'Reutlingen Hbf' ],
	[ 'TREW',  'Reutlingen West' ],
	[ 'TRES',  'Reutl-Sondelfing' ],
	[ 'XART',  'Reutte in Tirol' ],
	[ 'XARTS', 'Reutte Schulz.' ],
	[ 'XIREV', 'Revere' ],
	[ 'XIRES', 'Revere Scalo' ],
	[ 'XMRF',  'Revfülöp' ],
	[ 'XFREV', 'Revigny' ],
	[ 'XIRZ',  'Rezzato' ],
	[ 'ERHA',  'Rhade' ],
	[ 'DMVD',  'Rhäsa Werkbf' ],
	[ 'ERDW',  'Rheda-Wiedenbr' ],
	[ 'KRD',   'Rheidt (Siegkr)' ],
	[ 'KRBA',  'Rheinbach' ],
	[ 'KRBL',  'Rheinbach Römerk' ],
	[ 'KRBE',  'Rheinberg (Rhl)' ],
	[ 'KRBK',  'Rheinberg(Rhl)Kb' ],
	[ 'RKIG',  'Rheinbr DB/StKA' ],
	[ 'KRBR',  'Rheinbrohl' ],
	[ 'KRHB',  'Rheinbrücke' ],
	[ 'FRHD',  'Rheindürkheim' ],
	[ 'HR',    'Rheine' ],
	[ 'HRAG',  'Rheine DB-Grenze' ],
	[ 'HRK',   'Rheine KLV' ],
	[ 'HQR',   'Rheine NRW/NI' ],
	[ 'HKAR',  'Rheine RVM' ],
	[ 'HRSB',  'Rheine Stadtberg' ],
	[ 'XSRH',  'Rheineck' ],
	[ 'HMSU',  'Rheine-Mesum' ],
	[ 'XSRD',  'Rheinfelden' ],
	[ 'RRH',   'Rheinfelden (Ba)' ],
	[ 'KRH',   'Rheinhausen' ],
	[ 'KRHO',  'Rheinhausen Ost' ],
	[ 'KRHK',  'Rheinkamp' ],
	[ 'WRH',   'Rheinsberg (M)' ],
	[ 'YRRHH', 'Rheinsh4132/3450' ],
	[ 'RRHH',  'Rheinsheim' ],
	[ 'RQRH',  'Rheinsheim BW/RP' ],
	[ 'RRW',   'Rheinweiler' ],
	[ 'RRZA',  'Rheinzabern Bf' ],
	[ 'KRHE',  'Rhens' ],
	[ 'KRRT',  'Rheurdt' ],
	[ 'KRY G', 'Rheydt Gbf' ],
	[ 'KRY',   'Rheydt Hbf' ],
	[ 'KRY P', 'Rheydt Pbf' ],
	[ 'KRYG',  'Rheydt-Geneicken' ],
	[ 'LRIW',  'Rhinow' ],
	[ 'XIR',   'Rho' ],
	[ 'KRHD',  'Rhöndorf' ],
	[ 'ERHY',  'Rhynern' ],
	[ 'RRZU',  'Rhz Alte Römerst' ],
	[ 'RRZM',  'Rhz Rappengasse' ],
	[ 'RXSH',  'Ri Neuhausen CH' ],
	[ 'XCRI',  'Riajsk' ],
	[ 'XCRA',  'Riazan 2' ],
	[ 'LRIK',  'Ribbeck' ],
	[ 'XDRB',  'Ribe' ],
	[ 'XDRBN', 'Ribe Noerremark' ],
	[ 'XFRIB', 'Ribeauville Gare' ],
	[ 'WRIO',  'Ribnitz-Dam Ost' ],
	[ 'WRI',   'Ribnitz-Dam West' ],
	[ 'XIRN',  'Riccione' ],
	[ 'RRIH',  'Richen(Eppingen)' ],
	[ 'KRIC',  'Richterich' ],
	[ 'XSRW',  'Richterswil' ],
	[ 'FRIH',  'Richthof' ],
	[ 'XFRI',  'Richwiller' ],
	[ 'ARL',   'Rickling' ],
	[ 'LRIB',  'Riebau' ],
	[ 'FRID',  'Ried' ],
	[ 'XARI',  'Ried i Innkreis' ],
	[ 'HRID',  'Riede (b Bremen)' ],
	[ 'XARD',  'Riedenburg' ],
	[ 'MRDU',  'Riederau' ],
	[ 'TRI',   'Riedlingen' ],
	[ 'RRD',   'Riedöschingen' ],
	[ 'FRIE',  'Riedrode' ],
	[ 'FGE',   'Riedst-Goddelau' ],
	[ 'FLW',   'Ried-Wolfskehl' ],
	[ 'RRL',   'Riegel' ],
	[ 'RRP',   'Riegel NE' ],
	[ 'RROP',  'Riegel a K Ort' ],
	[ 'RRIE',  'Riehen' ],
	[ 'RQRI',  'Riehen(b Bas)LGr' ],
	[ 'WRKD',  'Riekdahl' ],
	[ 'XSRI',  'Rielasingen' ],
	[ 'DCHAR', 'Riemensch-Str' ],
	[ 'NRCK',  'Rieneck' ],
	[ 'DR',    'Riesa' ],
	[ 'DR R',  'Riesa Rbf' ],
	[ 'DR V',  'Riesa Stw 4' ],
	[ 'SRI',   'Rieschweiler' ],
	[ 'ARY',   'Rieseby' ],
	[ 'HRIE',  'Rieste/Bersenbr' ],
	[ 'URIE',  'Riestedt' ],
	[ 'TRH',   'Rietheim (Württ)' ],
	[ 'BRI',   'Rietschen' ],
	[ 'XARZ',  'Rietz' ],
	[ 'MRFR',  'Riffelriss' ],
	[ 'ZTR',   'Riga-Passajirsk' ],
	[ 'THER',  'Rigips' ],
	[ 'XIRGS', 'Rigoroso' ],
	[ 'XRR',   'Rijeka' ],
	[ 'XYRIS', 'Rimavska Sobota' ],
	[ 'RRIM',  'Rimbach' ],
	[ 'XVRF',  'Rimforsa' ],
	[ 'XIRI',  'Rimini' ],
	[ 'XIRIM', 'Rimini Miramare' ],
	[ 'XIRIT', 'Rimini Torre Pe.' ],
	[ 'MRG',   'Rimsting' ],
	[ 'XDRH',  'Rindsholm' ],
	[ 'XORB',  'Ringebu' ],
	[ 'ERIG',  'Ringel' ],
	[ 'WRIW',  'Ringenwalde' ],
	[ 'XDRG',  'Ringkoebing' ],
	[ 'URGS',  'Ringlebe-Gebesee' ],
	[ 'RRI',   'Ringsheim' ],
	[ 'XDRI',  'Ringsted' ],
	[ 'ERIK',  'Rinkerode' ],
	[ 'RRIT',  'Rinnthal' ],
	[ 'HRIN',  'Rinteln' ],
	[ 'HRNN',  'Rinteln Nord' ],
	[ 'HRNS',  'Rinteln Süd' ],
	[ 'XIRP',  'Rio di Pusteria' ],
	[ 'XIRSC', 'Riosecco' ],
	[ 'RRB',   'Rippberg' ],
	[ 'ARI',   'Rissen' ],
	[ 'ARIU',  'Rissen Üst' ],
	[ 'TRST',  'Rißtissen' ],
	[ 'URI',   'Ritschenhausen' ],
	[ 'HRTH',  'Ritterhude' ],
	[ 'HQRT',  'Ritterhude NI/HB' ],
	[ 'HRIT',  'Ritterkamp' ],
	[ 'LRIT',  'Ritze' ],
	[ 'LRIG',  'Ritze DB-Grenze' ],
	[ 'XIRVS', 'Rivalta Scrivia' ],
	[ 'XSRB',  'Rivera-Bironico' ],
	[ 'XFRV',  'Rivesaltes' ],
	[ 'MROS',  'Ro Hochschule' ],
	[ 'WRSN',  'Ro Seehf Nord' ],
	[ 'WRSS',  'Ro Seehf Süd' ],
	[ 'XOR',   'Roa' ],
	[ 'XFROA', 'Roanne' ],
	[ 'XIRBO', 'Robbio' ],
	[ 'XIRL',  'Robilante' ],
	[ 'LRN',   'Röblingen am See' ],
	[ 'LRNG',  'Röblingen DB-Gr' ],
	[ 'XIROG', 'Roccagrimalda' ],
	[ 'XIROV', 'Roccavione' ],
	[ 'XIROC', 'Rocchetta Cairo' ],
	[ 'XIRTC', 'Rocchetta Tanaro' ],
	[ 'BROT',  'Rochau Forsthaus' ],
	[ 'FROB',  'Rockenberg' ],
	[ 'SRC',   'Rockenhausen' ],
	[ 'LRZ',   'Röcknitz' ],
	[ 'XVRJ',  'Rocksjön' ],
	[ 'ZURK',  'Rodakovo' ],
	[ 'SROA',  'Rodalben' ],
	[ 'XLRD',  'Rodange' ],
	[ 'XDR',   'Rodby F' ],
	[ 'XDRO',  'Rodby Faerge' ],
	[ 'FROD',  'Rodenbach /Hanau' ],
	[ 'FRB',   'Rodenbach/Dillkr' ],
	[ 'KRK',   'Rodenkirchen' ],
	[ 'HRDK',  'Rodenkirchen/Old' ],
	[ 'NRTL',  'Rödental' ],
	[ 'NRTM',  'Rödental Mitte' ],
	[ 'DRO',   'Röderau' ],
	[ 'DRA',   'Röderau Bogendr' ],
	[ 'FORD',  'Rödermk-Ober Rod' ],
	[ 'FUCH',  'Rödermk-Urberach' ],
	[ 'DROW',  'Rodewisch' ],
	[ 'DRDW',  'Rodewitz' ],
	[ 'FROL',  'Rodgau-Rollwald' ],
	[ 'FDU',   'Rodg-Dudenhofen' ],
	[ 'FHHN',  'Rodg-Hainhausen' ],
	[ 'FJUE',  'Rodg-Jügesheim' ],
	[ 'FWEK',  'Rodg-Weiskirchen' ],
	[ 'FRO',   'Rodheim v d Höhe' ],
	[ 'NROD',  'Roding' ],
	[ 'XTRD',  'Rodinov' ],
	[ 'LROD',  'Rodleben' ],
	[ 'DRDF',  'Rödl-Hohndorf' ],
	[ 'XURV',  'Rodna Veche' ],
	[ 'XGR',   'Rodopolis' ],
	[ 'XDRD',  'Roedekro' ],
	[ 'XDRKB', 'Roedkaersbro' ],
	[ 'XDRJ',  'Roenbjerg' ],
	[ 'XDRN',  'Roenne' ],
	[ 'XFRSW', 'Roeschwoog' ],
	[ 'WRGT',  'Roggentin' ],
	[ 'XSRO',  'Roggwil-Berg' ],
	[ 'XSRY',  'Roggwil-Wynau' ],
	[ 'XORG',  'Rognan' ],
	[ 'XORS',  'Rognes' ],
	[ 'FDAR',  'Röhm Anst' ],
	[ 'XYRH',  'Rohoznik' ],
	[ 'UROH',  'Rohr (Thür)' ],
	[ 'NRB',   'Rohrbach' ],
	[ 'RRST',  'Rohrbach (Pfalz)' ],
	[ 'SRO',   'Rohrbach (Saar)' ],
	[ 'MRBI',  'Rohrbach/Ilm' ],
	[ 'MROH',  'Rohrbach/Obb' ],
	[ 'XARH',  'Rohr-Bad Hall' ],
	[ 'MRDO',  'Rohrdorf/Obb' ],
	[ 'MRFD',  'Rohrenfeld' ],
	[ 'MRM',   'Röhrmoos' ],
	[ 'MRMS',  'Röhrmoos Hp' ],
	[ 'MRMU',  'Röhrmoos Üst' ],
	[ 'NRBH',  'Röhrnbach' ],
	[ 'HROR',  'Rohrsen/Nienburg' ],
	[ 'DRRW',  'Rohrwerk' ],
	[ 'TRO',   'Roigheim' ],
	[ 'KROI',  'Roisdorf' ],
	[ 'KROW',  'Roisdorf West' ],
	[ 'LROI',  'Roitzsch' ],
	[ 'LBTA',  'Roitzsch Abzw' ],
	[ 'XPRI',  'Rokita' ],
	[ 'XORK',  'Rokland' ],
	[ 'XTRO',  'Rokycany' ],
	[ 'KROL',  'Rolandseck' ],
	[ 'RROL',  'Rollenberg' ],
	[ 'NRON',  'Rollhofen' ],
	[ 'XIRO',  'Roma Ostiense' ],
	[ 'XIRM',  'Roma Termini' ],
	[ 'XIRT',  'Roma Tiburtina' ],
	[ 'XIRU',  'Roma Tuscolana' ],
	[ 'XURM',  'Roman' ],
	[ 'XSR',   'Romanshorn' ],
	[ 'XSRHF', 'Romanshorn (See)' ],
	[ 'XFRO',  'Rombas' ],
	[ 'TOER',  'Römerwall' ],
	[ 'TROM',  'Rommelshausen' ],
	[ 'KROG',  'Rommersk Gr' ],
	[ 'KROM',  'Rommerskirchen' ],
	[ 'ZURM',  'Romodan' ],
	[ 'XIRF',  'Roncafort' ],
	[ 'XIRB',  'Ronco Scrivia' ],
	[ 'XBRO',  'Ronet' ],
	[ 'XBROF', 'Ronet Formation' ],
	[ 'DRON',  'Ronneburg (Thür)' ],
	[ 'HRBG',  'Ronnenberg' ],
	[ 'FRON',  'Ronshausen' ],
	[ 'FROH',  'Rönshausen' ],
	[ 'BRGT',  'Röntgental' ],
	[ 'XLRT',  'Roodt' ],
	[ 'XNRD',  'Roosendaal' ],
	[ 'XARP',  'Roppen' ],
	[ 'XORR',  'Roros' ],
	[ 'XSRS',  'Rorschach' ],
	[ 'XSRSH', 'Rorschach Hafen' ],
	[ 'XSRSS', 'Rorschach Hf S' ],
	[ 'XVRP',  'Rörstorp' ],
	[ 'XIRS',  'Rosarno' ],
	[ 'KROS',  'Rosbach (Sieg)' ],
	[ 'FROS',  'Rosbach v d Höhe' ],
	[ 'HRDF',  'Rosdorf' ],
	[ 'NRNU',  'Rosenau/Grafenau' ],
	[ 'XARB',  'Rosenbach' ],
	[ 'XAXRB', 'Rosenbach Gr SI' ],
	[ 'TRBG',  'Rosenberg/Baden' ],
	[ 'EHW',   'Rosend-Holtwick' ],
	[ 'LRO',   'Rosengarten' ],
	[ 'WRO',   'Rosenhagen' ],
	[ 'MRO',   'Rosenheim' ],
	[ 'MART',  'Rosenheim Ost' ],
	[ 'MARS',  'Rosenheim Süd' ],
	[ 'ERSH',  'Rosenheim/W-wald' ],
	[ 'EVLR',  'Rosenhügel' ],
	[ 'DXHZ',  'Rosenthal Gr 1' ],
	[ 'DXHD',  'Rosenthal Gr 2' ],
	[ 'WROW',  'Rosenwinkel' ],
	[ 'XURN',  'Rosiori Nord' ],
	[ 'XDRK',  'Roskilde' ],
	[ 'NROE',  'Röslau' ],
	[ 'KROE',  'Rösrath' ],
	[ 'KRST',  'Rösrath-Stümpen' ],
	[ 'XIRA',  'Rossano' ],
	[ 'SROB',  'Roßbach (Pfalz)' ],
	[ 'TROS',  'Roßberg' ],
	[ 'TROG',  'Roßberg Em Stadt' ],
	[ 'XIRSG', 'Rossiglione' ],
	[ 'HROS',  'Rössing' ],
	[ 'UROS',  'Roßla' ],
	[ 'ZIRE',  'Rosslare Europ' ],
	[ 'LR',    'Roßlau (Elbe)' ],
	[ 'LRAI',  'Roßlau Abzw Ai' ],
	[ 'LRAW',  'Roßlau Aw' ],
	[ 'LRG O', 'Roßlau Gbf Ost' ],
	[ 'LRG',   'Roßlau(Elbe) Gbf' ],
	[ 'URO',   'Roßleben' ],
	[ 'XCRS',  'Rossosh' ],
	[ 'NRL',   'Roßtal' ],
	[ 'NRW',   'Roßtal Wegbrücke' ],
	[ 'DRW',   'Roßwein' ],
	[ 'WRHI',  'Rost Hinrdf Str' ],
	[ 'WXRS',  'Rost Seeh Mi See' ],
	[ 'WRTF',  'Rost Thierf Str' ],
	[ 'WEV',   'Rost-Evershagen' ],
	[ 'WRK',   'Rost-Kassebohm' ],
	[ 'WLH',   'Rost-Lichtenhagn' ],
	[ 'WLKL',  'Rost-Lütt Klein' ],
	[ 'WRMA',  'Rost-Marienehe' ],
	[ 'WR',    'Rostock Hbf' ],
	[ 'WRHO',  'Rostock Holbeinp' ],
	[ 'WRHP',  'Rostock Parkstr' ],
	[ 'WRSC',  'Rostock Seeh Ubf' ],
	[ 'WRS',   'Rostock Seehafen' ],
	[ 'WRB',   'Rostock-Bramow' ],
	[ 'WRD',   'Rostock-Dierkow' ],
	[ 'WGMS',  'Rostock-Torfbr' ],
	[ 'XCRO',  'Rostov-Glavnyi' ],
	[ 'WRT',   'Rost-Toitenwink' ],
	[ 'RRT',   'Röt' ],
	[ 'TRS',   'Rot am See' ],
	[ 'XTRV',  'Rotava' ],
	[ 'TRY',   'Rotenbach' ],
	[ 'RROE',  'Rötenbach(Baden)' ],
	[ 'AROG',  'Rotenburg(Wümme)' ],
	[ 'FROF',  'Rotenburg/Fulda' ],
	[ 'FRTN',  'Rotenhain' ],
	[ 'LROH',  'Rotes Haus' ],
	[ 'RRK',   'Rotes Kreuz' ],
	[ 'HROT',  'Rötgesbüttel' ],
	[ 'NRO',   'Roth' ],
	[ 'LRTH',  'Rötha' ],
	[ 'NRP',   'Röthenbach (Peg)' ],
	[ 'NRTH',  'Röthenbach(Opf)' ],
	[ 'MRTA',  'Röthenbach/Allg' ],
	[ 'NRPE',  'Röthenb-Seespitz' ],
	[ 'NRPG',  'Röthenb-Steinb' ],
	[ 'NRBG',  'Rothenbürg' ],
	[ 'XSRTB', 'Rothenburg' ],
	[ 'NRTN',  'Rothenburg Nord' ],
	[ 'NROT',  'Rothenburg o d T' ],
	[ 'AROP',  'Rothenburgsort' ],
	[ 'UROT',  'Rothenstein (S)' ],
	[ 'XSRTT', 'Rothenthurm' ],
	[ 'XSRR',  'Rothrist' ],
	[ 'XSRK',  'Rotkreuz' ],
	[ 'RRM',   'Rot-Malsch' ],
	[ 'MRT',   'Rott (Inn)' ],
	[ 'MROT',  'Rottau' ],
	[ 'TRR',   'Rottenacker' ],
	[ 'URTB',  'Rottenbach' ],
	[ 'URTG',  'Rottenbach DB-Gr' ],
	[ 'TRT',   'Rottenburg (N)' ],
	[ 'MRBL',  'Rottenburg/Laab' ],
	[ 'NRTD',  'Rottendorf' ],
	[ 'XAR',   'Rottenmann' ],
	[ 'XNRI',  'Rotterd Ijsselm' ],
	[ 'XNRL',  'Rotterd Lombardi' ],
	[ 'XNRN',  'Rotterd Noord G' ],
	[ 'XNRC',  'Rotterdam C' ],
	[ 'XNRE',  'Rotterdam EP' ],
	[ 'XNREW', 'Rotterdam EPW' ],
	[ 'XNR',   'Rotterdam Rmo' ],
	[ 'XNRW',  'Rotterdam Waalh.' ],
	[ 'XNRB',  'Rotterdam-Botlek' ],
	[ 'XNRP',  'Rotterdam-Pernis' ],
	[ 'XNRS',  'RotterdamStadion' ],
	[ 'NRHN',  'Rottershausen' ],
	[ 'URTS',  'Rottleberode Süd' ],
	[ 'XIRTF', 'Rottofreno' ],
	[ 'TR',    'Rottweil' ],
	[ 'TRSA',  'Rottweil Saline' ],
	[ 'TRG',   'Rottw-Göllsdorf' ],
	[ 'TRNF',  'Rottw-Neufra' ],
	[ 'XTRN',  'Roudnice n Labem' ],
	[ 'XFROU', 'Rouffach' ],
	[ 'XIROT', 'Rovato' ],
	[ 'XIRR',  'Rovereto' ],
	[ 'WRV',   'Rövershagen' ],
	[ 'XIRG',  'Rovigo' ],
	[ 'ZUR',   'Rovno' ],
	[ 'XPRO',  'Rozmierka' ],
	[ 'XTRZ',  'Rozna' ],
	[ 'XTRK',  'Roztoky u Kriv' ],
	[ 'KRG',   'Rs Güldenwerth' ],
	[ 'KRB',   'Rs-Bliedinghsn' ],
	[ 'KRLA',  'Rs-Lüttringhsn' ],
	[ 'KRLU',  'Rs-Lüttringhsn' ],
	[ 'XCRT',  'Rtiscevo 1' ],
	[ 'XTRP',  'Rtyne v Podkrkon' ],
	[ 'XIRUB', 'Rubiera' ],
	[ 'TRUS',  'Ruchsen' ],
	[ 'XPRB',  'Ruda Bielszowice' ],
	[ 'XPRCH', 'Ruda Chebzie' ],
	[ 'XPRL',  'Ruda Czarny Las' ],
	[ 'XPRK',  'Ruda Kochlowice' ],
	[ 'TRU',   'Rudersberg' ],
	[ 'TRUN',  'Rudersberg Nord' ],
	[ 'ERUD',  'Rudersdorf' ],
	[ 'EQRU',  'Rudersdorf LGr' ],
	[ 'XPRC',  'Rudniki K Czesto' ],
	[ 'UR G',  'Rudolst (Th) Gbf' ],
	[ 'UR',    'Rudolstadt (Th)' ],
	[ 'URS',   'Rudolst-Schwarza' ],
	[ 'FRS',   'Rü bacher Schlu' ],
	[ 'LRL',   'Rübeland' ],
	[ 'LRL K', 'Rübeland Kalkw' ],
	[ 'LRL W', 'Rübeland Werk 3' ],
	[ 'ARP',   'Rübenkamp' ],
	[ 'NRUE',  'Rückersd (Mfr)' ],
	[ 'BRO',   'Rückersdorf NL' ],
	[ 'BRUE',  'Rüdersdf(b Bln)' ],
	[ 'FRDH',  'Rüdesheim (Rh)' ],
	[ 'WRZ',   'Rüdnitz' ],
	[ 'HRUH',  'Rühen' ],
	[ 'TMCR',  'Rührberg' ],
	[ 'RRZD',  'Rülzh Freizeitz' ],
	[ 'RRZH',  'Rülzheim Bf' ],
	[ 'XSRU',  'Rümlang' ],
	[ 'KRUN',  'Ründeroth' ],
	[ 'HRUE',  'Rüningen' ],
	[ 'RRUT',  'Rüppurr Tulpenst' ],
	[ 'XSRL',  'Rüschlikon' ],
	[ 'NRLB',  'Rüsselbach' ],
	[ 'FRUE',  'Rüsselsheim' ],
	[ 'FRUO',  'Rüsselshm Opelw' ],
	[ 'ERTN',  'Rüthen' ],
	[ 'XSRT',  'Rüthi SG' ],
	[ 'XKRU',  'Rugby' ],
	[ 'BRU',   'Ruhland' ],
	[ 'BRUZ',  'Ruhlsdf-Zerpens' ],
	[ 'NRUF',  'Ruhmannsfelden' ],
	[ 'MRPD',  'Ruhpolding' ],
	[ 'ERTL',  'Ruhrtal' ],
	[ 'MRUS',  'Ruhstorf' ],
	[ 'HRUT',  'Rullstorf' ],
	[ 'XARU',  'Rum' ],
	[ 'XJRU',  'Ruma' ],
	[ 'XTRU',  'Rumburk' ],
	[ 'XLRU',  'Rumelange' ],
	[ 'KRUM',  'Rumeln' ],
	[ 'MRUM',  'Rumgraben' ],
	[ 'EROL',  'Rummenohl' ],
	[ 'NRUD',  'Runding' ],
	[ 'FRUK',  'Runkel' ],
	[ 'XPRU',  'Runowo Pom' ],
	[ 'HRPT',  'Rupennest' ],
	[ 'XSRP',  'Rupperswil' ],
	[ 'DRUG',  'Ruppertsgrün' ],
	[ 'NRST',  'Rupprechtstegen' ],
	[ 'ARWD',  'Ruschwedel' ],
	[ 'XWR',   'Ruse' ],
	[ 'XTRS',  'Rusova' ],
	[ 'XYRS',  'Rusovce' ],
	[ 'TRUT',  'Rutesheim' ],
	[ 'WRU',   'Ruthenbeck' ],
	[ 'XHR',   'Ruukki' ],
	[ 'SRUW',  'Ruwer West' ],
	[ 'XYRU',  'Ruzomberok' ],
	[ 'BRW',   'R-Wallenberg-Str' ],
	[ 'ERWH',  'RWE /Hagen' ],
	[ 'ERWK',  'RWE /Iserl' ],
	[ 'FGOR',  'RWE Götzenhain' ],
	[ 'KBHR',  'RWE Paffendorf' ],
	[ 'KRWE',  'RWE Power AG' ],
	[ 'HLBL',  'RWG Leese' ],
	[ 'XDRY',  'Ry' ],
	[ 'XPRT',  'Rybnik Towarowy' ],
	[ 'XTRY',  'Rybniste' ],
	[ 'XVRY',  'Rydaholm' ],
	[ 'XPRY',  'Rydultowy' ],
	[ 'XORY',  'Rygge' ],
	[ 'XPRN',  'Rykoszyn' ],
	[ 'KRYO',  'Ry-Odenkirchen' ],
	[ 'XPR',   'Rzepin' ],
	[ 'XPRZ',  'Rzeszow' ],
	[ 'XISAB', 'S Anna Robella' ],
	[ 'XISAS', 'S Antonino Sal' ],
	[ 'XFSAC', 'S Avre l Chambre' ],
	[ 'XISBT', 'S Benedetto d Tr' ],
	[ 'XISBC', 'S Benigno Cuneo' ],
	[ 'XISDA', 'S Damiano d\'Asti' ],
	[ 'XISGL', 'S Germano Verc' ],
	[ 'XISGM', 'S Giacomo' ],
	[ 'XISGO', 'S Giorgio Casale' ],
	[ 'XIGN',  'S Giorgio Nogaro' ],
	[ 'XISGT', 'S Giuletta' ],
	[ 'XISGP', 'S Giuliano Piem' ],
	[ 'XISGC', 'S Giuseppe d C' ],
	[ 'XISML', 'S Martino Lupari' ],
	[ 'XFSMV', 'S Michel Valloir' ],
	[ 'XISNO', 'S Nicolo' ],
	[ 'XISPS', 'S Paolo Solbrito' ],
	[ 'XASPS', 'S Peter-Seitenst' ],
	[ 'XISSP', 'S Sebastiano Po' ],
	[ 'XISSB', 'S Stefano Belbo' ],
	[ 'XISVT', 'S Vittoria' ],
	[ 'XISZF', 'S Zeno Folzano' ],
	[ 'XISBO', 'S. Bonifacio' ],
	[ 'XISA',  'S.Agata Militell' ],
	[ 'XISB',  'S.Benedetto Po' ],
	[ 'XISCI', 'S.Cand./Innichen' ],
	[ 'XISD',  'S.Donato di Lec' ],
	[ 'XISF',  'S.Felice sul P.' ],
	[ 'XISG',  'S.Giovanni in P.' ],
	[ 'XISGV', 'S.Giovanni Vald.' ],
	[ 'XISZ',  'S.Lzo./St.Lorenz' ],
	[ 'XISM',  'S.Margherita L P' ],
	[ 'XISP',  'S.Pietro Vernot.' ],
	[ 'XIST',  'S.Teresa di Riva' ],
	[ 'XISV',  'S.Vito al Tagl.' ],
	[ 'XISVL', 'S.Vito-Lanciano' ],
	[ 'NSL',   'Saal (Donau)' ],
	[ 'RSAB',  'Saalbach' ],
	[ 'FSB',   'Saalburg (Ts)' ],
	[ 'USK',   'Saaleck' ],
	[ 'UQSK',  'Saaleck 6305' ],
	[ 'US',    'Saalfeld (Saale)' ],
	[ 'XASA',  'Saalfelden' ],
	[ 'DSAA',  'Saara' ],
	[ 'SSM',   'Saarbr Messebf.' ],
	[ 'SSR G', 'Saarbr Rbf Hgbf' ],
	[ 'SSR M', 'Saarbr Rbf Mitte' ],
	[ 'SSR N', 'Saarbr Rbf Nord' ],
	[ 'SSR O', 'Saarbr Rbf Ost' ],
	[ 'SSR W', 'Saarbr Rbf West' ],
	[ 'SSH O', 'Saarbr. Hbf So' ],
	[ 'SSH G', 'Saarbr. Hbf Srg' ],
	[ 'SSLM',  'Saarbr-Schleifm' ],
	[ 'SXSD',  'Saarbrücken Gr' ],
	[ 'SSH',   'Saarbrücken Hbf' ],
	[ 'SSO',   'Saarbrücken Ost' ],
	[ 'SSR',   'Saarbrücken Rbf' ],
	[ 'SSH W', 'Saarbrücken W600' ],
	[ 'SSH R', 'Saarbrücken W603' ],
	[ 'SSH S', 'Saarbrücken W604' ],
	[ 'SSAB',  'Saarburg(Trier)' ],
	[ 'SSDM',  'Saardamm' ],
	[ 'SSLB',  'Saarhölzbach' ],
	[ 'SQSL',  'Saarhölzbach LGr' ],
	[ 'SSLV',  'Saarlouis Becker' ],
	[ 'SSLS',  'Saarlouis Hbf' ],
	[ 'BSAM',  'Saarmund' ],
	[ 'FSAA',  'Saasen' ],
	[ 'WSAA',  'Saatel' ],
	[ 'NSA',   'Sachsen (b Ansb)' ],
	[ 'LSAD',  'Sachsendorf(Cal)' ],
	[ 'BSAH',  'Sachsenhausen' ],
	[ 'TSA',   'Sachsenheim' ],
	[ 'KTRC',  'Sachtleben C' ],
	[ 'XISAC', 'Sacile' ],
	[ 'XSSA',  'Safenwil' ],
	[ 'XVSF',  'Säffle' ],
	[ 'XCSF',  'Safonovo' ],
	[ 'WSAG',  'Sagard' ],
	[ 'ASAG',  'Sagehorn' ],
	[ 'AQSAG', 'Sagehorn 1404' ],
	[ 'AQSA',  'Sagehorn 2200' ],
	[ 'XESG',  'Sagunto' ],
	[ 'XFSZE', 'Saincaize' ],
	[ 'XFSAS', 'Saintes' ],
	[ 'XBSG',  'Saint-Ghislain' ],
	[ 'XYSA',  'Sala' ],
	[ 'TSAL',  'Salach' ],
	[ 'XFSAI', 'Salaise' ],
	[ 'XTSJ',  'Salajna' ],
	[ 'ESDD',  'Salchendorf/Deuz' ],
	[ 'ESDS',  'Salchendorf/Kr S' ],
	[ 'XISH',  'Sale Langhe' ],
	[ 'RSLM',  'Salem' ],
	[ 'XISN',  'Salerno' ],
	[ 'XSSAS', 'Sales' ],
	[ 'XSSZ',  'Salez-Sennwald' ],
	[ 'XMSK',  'Salgotarjan küls' ],
	[ 'XISCT', 'Saliceto' ],
	[ 'ZWSK',  'Salihorsk' ],
	[ 'MSAL',  'Sallach' ],
	[ 'SSMR',  'Salmrohr' ],
	[ 'SSMT',  'Salmtal' ],
	[ 'XISGG', 'Saluggia' ],
	[ 'XAAI',  'Salzb Aiglhof' ],
	[ 'XASBG', 'Salzb Glanbachbr' ],
	[ 'XASLF', 'Salzb Liefering' ],
	[ 'FWSA',  'Salzbach' ],
	[ 'HSAL',  'Salzbergen' ],
	[ 'XASBA', 'Salzburg Aigen' ],
	[ 'XASGH', 'Salzburg Gnigl H' ],
	[ 'MXSZ',  'Salzburg Grenze' ],
	[ 'XASB',  'Salzburg Hbf' ],
	[ 'XASBM', 'Salzburg Mitte' ],
	[ 'XASBP', 'Salzburg Parsch' ],
	[ 'XASSA', 'Salzburg Sam' ],
	[ 'XASBS', 'Salzburg Süd' ],
	[ 'XASG',  'Salzburg-Gnigl' ],
	[ 'HBSK',  'Salzdtf-Solebad' ],
	[ 'HSBG',  'Salzg-Bad DB-Gr' ],
	[ 'HSGG',  'Salzgitter DB-Gr' ],
	[ 'HSB',   'Salzgitter-Bad' ],
	[ 'HSHL',  'Salzhausen/Lüneb' ],
	[ 'ESZK',  'Salzkotten' ],
	[ 'LSW',   'Salzwedel' ],
	[ 'LSW G', 'Salzwedel Gbf' ],
	[ 'LQSW',  'Salzwedel ST/NI' ],
	[ 'TBFS',  'Salzwerk' ],
	[ 'XCSAM', 'Samara' ],
	[ 'NSAM',  'Sambach' ],
	[ 'ZUSB',  'Sambor' ],
	[ 'XSSD',  'Samedan' ],
	[ 'XSSMT', 'Samstagern' ],
	[ 'WSAM',  'Samtens' ],
	[ 'XESP',  'San Pol de Mar' ],
	[ 'XISAR', 'San Remo' ],
	[ 'XISS',  'San Severo' ],
	[ 'NSNH',  'Sand (Ndb) Hafen' ],
	[ 'NSND',  'Sand (Niederbay)' ],
	[ 'XWSN',  'Sandanski' ],
	[ 'XVSR',  'Sandared' ],
	[ 'NSAN',  'Sandbach (Nbay)' ],
	[ 'HSAN',  'Sande' ],
	[ 'XOSN',  'Sande NO' ],
	[ 'ESDB',  'Sandebeck' ],
	[ 'HSAB',  'Sanderbusch' ],
	[ 'LSL',   'Sandersleben Anh' ],
	[ 'WSAF',  'Sandförde' ],
	[ 'WSAN',  'Sandhagen' ],
	[ 'XVSM',  'Sandhem' ],
	[ 'HSAK',  'Sandkrug' ],
	[ 'XOSS',  'Sandnes' ],
	[ 'BSDO',  'Sandow' ],
	[ 'XOSV',  'Sandvika' ],
	[ 'ASDW',  'Sandwehle' ],
	[ 'RSAW',  'Sandweier' ],
	[ 'XLSC',  'Sandweiler-Cont' ],
	[ 'USG',   'Sangerhausen' ],
	[ 'WSTZ',  'Sanitz' ],
	[ 'XVSNN', 'Sannarp' ],
	[ 'XFSN',  'Sanry sur Nied' ],
	[ 'RSAH',  'Sansenhecken' ],
	[ 'ESCI',  'Sanssouci' ],
	[ 'XXSR',  'Santarem' ],
	[ 'XISTH', 'Santhia' ],
	[ 'XISTU', 'Santuario' ],
	[ 'XMSA',  'Sap' ],
	[ 'ZUSP',  'Sapejanka' ],
	[ 'XRSJ',  'Sapjane' ],
	[ 'XRXSJ', 'Sapjane Gr SI' ],
	[ 'XNSO',  'Sappemeer Oost' ],
	[ 'XISR',  'Sapri' ],
	[ 'ZBS',   'Sarajevo Teretna' ],
	[ 'XCSR',  'Saraktash' ],
	[ 'XUSR',  'Saratel' ],
	[ 'XCSA',  'Saratov-Passajir' ],
	[ 'XMSEG', 'Saregres' ],
	[ 'XSSR',  'Sargans' ],
	[ 'BSAE',  'Särichen' ],
	[ 'XISAM', 'Sarmato' ],
	[ 'FSR',   'Sarnau Bbf' ],
	[ 'WSAW',  'Sarnow' ],
	[ 'RANS',  'Sarnstall' ],
	[ 'ZUSA',  'Sarny' ],
	[ 'XMSP',  'Sarpentele' ],
	[ 'XOSA',  'Sarpsborg' ],
	[ 'XFSTF', 'Sarraltroff' ],
	[ 'XFSB',  'Sarrebourg' ],
	[ 'XFSM',  'Sarreguemines' ],
	[ 'XFSI',  'Sarreinsming' ],
	[ 'XFSIC', 'Sarreinsming C' ],
	[ 'HSRD',  'Sarstedt' ],
	[ 'XMSM',  'Sarszentmihaly' ],
	[ 'XISTR', 'Sartirana' ],
	[ 'XMSV',  'Sarvar' ],
	[ 'XNSG',  'Sas van Gent' ],
	[ 'RSAS',  'Sasbach a K' ],
	[ 'ESAS',  'Sassenroth' ],
	[ 'WSZ',   'Sassnitz' ],
	[ 'WSZF',  'Sassnitz Fährhf' ],
	[ 'WM',    'Sassnitz-Mukran' ],
	[ 'WSZG',  'Sassn-Mukr DB-Gr' ],
	[ 'WM B',  'Sassn-Mukr/Borch' ],
	[ 'WM A',  'Sassn-Mukran A' ],
	[ 'WXMB',  'Sassn-Mukran B' ],
	[ 'WM E',  'Sassn-Mukran E' ],
	[ 'WXM',   'Sassn-Mukran Kl' ],
	[ 'WMW',   'Sassn-Mukran Wst' ],
	[ 'WXSZ',  'Sassn-Mukran(SE)' ],
	[ 'XFSRI', 'Sathonay-Rilieux' ],
	[ 'XPSAT', 'Satopy Samulewo' ],
	[ 'TSAT',  'Satteldorf' ],
	[ 'USAE',  'Sättelstädt' ],
	[ 'BSAT',  'Satzkorn' ],
	[ 'KSA',   'Satzvey' ],
	[ 'LSBT',  'Saubachtal' ],
	[ 'MSR',   'Sauerlach' ],
	[ 'RSDO',  'Sauldorf' ],
	[ 'TSL',   'Saulgau' ],
	[ 'MSGB',  'Saulgrub' ],
	[ 'FSLH',  'Saulheim' ],
	[ 'XFSUD', 'Saumur' ],
	[ 'XVSAV', 'Sävenäs' ],
	[ 'XVSAE', 'Sävenas Iomr' ],
	[ 'XFSV',  'Saverne' ],
	[ 'XISVG', 'Savigliano' ],
	[ 'BSAP',  'Savignyplatz' ],
	[ 'XISAV', 'Savona Letimbro' ],
	[ 'XVSVJ', 'Sävsjö' ],
	[ 'XRSM',  'Savski Marof' ],
	[ 'LSX',   'Saxdorf' ],
	[ 'XAML',  'Sb Mülln-Altstdt' ],
	[ 'SSB',   'Sbr-Burbach' ],
	[ 'XASVZ', 'Schaan-Vaduz' ],
	[ 'XASD',  'Schaanwald' ],
	[ 'KSHY',  'Schaephuysen' ],
	[ 'XBS',   'Schaerbeek' ],
	[ 'XBSF',  'Schaerbeek Form' ],
	[ 'SSU',   'Schafbrücke' ],
	[ 'HSFF',  'Schäferhof' ],
	[ 'RSCFW', 'Schaffh West' ],
	[ 'RSCFP', 'Schaffhaus W 119' ],
	[ 'RSCFO', 'Schaffhaus W 203' ],
	[ 'RSCFR', 'Schaffhausen GB' ],
	[ 'RSCF',  'Schaffhausen PB' ],
	[ 'XSS',   'Schaffhsn CH' ],
	[ 'LSST',  'Schafstädt' ],
	[ 'XASFU', 'Schaftenau' ],
	[ 'MSFL',  'Schaftlach' ],
	[ 'RSAI',  'Schaidt (Pfalz)' ],
	[ 'MSCA',  'Schalchen' ],
	[ 'NSI',   'Schalding' ],
	[ 'USCK',  'Schalkau' ],
	[ 'USKM',  'Schalkau Mitte' ],
	[ 'ESMU',  'Schalksmühle' ],
	[ 'TSKS',  'Schalkstetten' ],
	[ 'RSAL',  'Schallstadt' ],
	[ 'ESCA',  'Schameder' ],
	[ 'HSDL',  'Schandelah' ],
	[ 'LSBG',  'Schanzberg' ],
	[ 'ASAZ',  'Scharbeutz' ],
	[ 'XASH',  'Schärding' ],
	[ 'DSS',   'Scharfenstein' ],
	[ 'ESMD',  'Scharmede' ],
	[ 'HSNB',  'Scharnebeck' ],
	[ 'XAA',   'Scharnitz' ],
	[ 'WST',   'Scharstorf' ],
	[ 'HSC',   'Scharzfeld' ],
	[ 'LSBF',  'Schb-Felgeleben' ],
	[ 'LSBE',  'Schb-Salzelmen' ],
	[ 'FBHM',  'Sch-Büdesheim' ],
	[ 'MSC',   'Schechen' ],
	[ 'XNSE',  'Scheemda' ],
	[ 'ASL',   'Scheeßel' ],
	[ 'ASGR',  'Scheggerott' ],
	[ 'DSG',   'Scheibenberg' ],
	[ 'FKSMP', 'Scheidemannpl/DB' ],
	[ 'FKSMW', 'Scheidemannpl/Wi' ],
	[ 'SSD',   'Scheidt (Saar)' ],
	[ 'USTZ',  'Scheiplitz' ],
	[ 'TSK',   'Schelklingen' ],
	[ 'TSX',   'Schemmerberg' ],
	[ 'RSZL',  'Schenkenzell' ],
	[ 'TSEP',  'Scheppach' ],
	[ 'HSCD',  'Scherfede' ],
	[ 'ESER',  'Scherl' ],
	[ 'MASH',  'Scherm' ],
	[ 'HSCN',  'Scheuen' ],
	[ 'XLSB',  'Scheuerbusch' ],
	[ 'ESCF',  'Scheuerfeld' ],
	[ 'ESCW',  'Scheuerfld Wbahn' ],
	[ 'KSEV',  'Scheven' ],
	[ 'BSC',   'Schichauweg' ],
	[ 'XNSC',  'Schiedam-Rott.W.' ],
	[ 'HSCI',  'Schieder' ],
	[ 'HSCB',  'Schierbrok' ],
	[ 'XLSR',  'Schieren' ],
	[ 'LSCR',  'Schierke' ],
	[ 'MSLG',  'Schierling' ],
	[ 'LSIS',  'Schierstedt' ],
	[ 'RSDG',  'Schifferst Gem' ],
	[ 'RSDS',  'Schifferst. Süd' ],
	[ 'RSD',   'Schifferstadt' ],
	[ 'XLSL',  'Schifflange' ],
	[ 'SSWL',  'Schiffweiler' ],
	[ 'RSCL',  'Schiltach' ],
	[ 'RSCM',  'Schiltach Mitte' ],
	[ 'FSBN',  'Schimborn' ],
	[ 'XSSF',  'Schindellegi-F.' ],
	[ 'XNSP',  'Schiphol' ],
	[ 'DSWK',  'Schirgisw-Kirsch' ],
	[ 'NSG',   'Schirnding' ],
	[ 'NXSG',  'Schirnding Grenz' ],
	[ 'LSD',   'Schkeuditz' ],
	[ 'LSD U', 'Schkeuditz Ügl' ],
	[ 'LSDW',  'Schkeuditz West' ],
	[ 'FKIL',  'Sch-Kilianstädt' ],
	[ 'LSP',   'Schkopau' ],
	[ 'MSLS',  'Schlachters' ],
	[ 'HSCL',  'Schladen (Harz)' ],
	[ 'KSLA',  'Schladern (Sieg)' ],
	[ 'XASL',  'Schladming' ],
	[ 'TSLT',  'Schlatt (Hohenz)' ],
	[ 'ASBR',  'Schleibrücke' ],
	[ 'KSLE',  'Schleiden(Eifel)' ],
	[ 'BSFE',  'Schleife' ],
	[ 'MSM',   'Schleißheim' ],
	[ 'DSZ',   'Schleiz' ],
	[ 'DSZB',  'Schleiz Awanst' ],
	[ 'DSZW',  'Schleiz West' ],
	[ 'ASW',   'Schleswig' ],
	[ 'DSCL',  'Schlettau (Erzg)' ],
	[ 'USNN',  'Schleus Neundorf' ],
	[ 'USN',   'Schleusingen' ],
	[ 'USNO',  'Schleusingen Ost' ],
	[ 'RSG',   'Schliengen' ],
	[ 'RSG N', 'Schliengen Nord' ],
	[ 'FSBA',  'Schlierb(S-Eder)' ],
	[ 'MSCS',  'Schliersee' ],
	[ 'NSLN',  'Schlömen' ],
	[ 'ESHO',  'Schloß Holte' ],
	[ 'ESNH',  'Schloß Neuhaus' ],
	[ 'ESNS',  'Schloß Neuhaus H' ],
	[ 'RSLG',  'Schloßberg' ],
	[ 'RSLU',  'Schluchsee' ],
	[ 'FSUE',  'Schlüchtern' ],
	[ 'NSFD',  'Schlüsselfeld' ],
	[ 'ALRT',  'Schlutuper Tann' ],
	[ 'BSHN',  'Schmachtenhagen' ],
	[ 'USM',   'Schmalkalden' ],
	[ 'FSMU',  'Schmalnau' ],
	[ 'ESMH',  'Schmehausen' ],
	[ 'USMS',  'Schm-Fachhochsch' ],
	[ 'KSMI',  'Schmidtheim' ],
	[ 'MASE',  'Schmidtmühle' ],
	[ 'TSHM',  'Schmiechen' ],
	[ 'TSHA',  'Schmiechen Albb' ],
	[ 'MSCN',  'Schmiechen/Schw' ],
	[ 'USFD',  'Schmiedef Rennst' ],
	[ 'HSMK',  'Schmiedekamp' ],
	[ 'DSMI',  'Schmilka-Hir' ],
	[ 'DSPG',  'Schmirchau Gbf' ],
	[ 'FSLM',  'Schmittlotheim' ],
	[ 'WSCM',  'Schmollensee' ],
	[ 'DSML',  'Schmölln (OL)' ],
	[ 'DSM',   'Schmölln (Thür)' ],
	[ 'LSC',   'Schmon' ],
	[ 'NSAW',  'Schnabelwaid' ],
	[ 'NSMA',  'Schnaittach M' ],
	[ 'NSBA',  'Schnaittenbach' ],
	[ 'XASNN', 'Schnann' ],
	[ 'NSCB',  'Schneeberg (Odw)' ],
	[ 'BSB',   'Schneeberg(Mark)' ],
	[ 'DCZWS', 'Schneeberger Str' ],
	[ 'NQSC',  'Schneebg/Amb LGr' ],
	[ 'HSCG',  'Schnega' ],
	[ 'FSNH',  'Schneidhain' ],
	[ 'NSNE',  'Schnelldorf' ],
	[ 'DLTSS', 'Schneller-Siedl' ],
	[ 'ASDN',  'Schneverdingen' ],
	[ 'NSY',   'Schney' ],
	[ 'NSNI',  'Schnitzmühle' ],
	[ 'FOBD',  'Sch-Oberdorfeld' ],
	[ 'SSOF',  'Schoden-Ockfen' ],
	[ 'FSK',   'Schöllkrippen' ],
	[ 'NSNA',  'Schöllnach' ],
	[ 'RKLS',  'Scholz' ],
	[ 'TSCB',  'Schömberg b Rott' ],
	[ 'DSN',   'Schöna' ],
	[ 'USU',   'Schönau (Hörsel)' ],
	[ 'TSBG',  'Schönberg' ],
	[ 'WSBG',  'Schönberg (M)' ],
	[ 'DSB',   'Schönberg (V)' ],
	[ 'DSBV',  'Schönberg DB-Gr' ],
	[ 'ASCB',  'Schönberg(Holst)' ],
	[ 'DQSB',  'Schönberg(V)LGr' ],
	[ 'ASCS',  'Schönbger Strand' ],
	[ 'XASBL', 'Schönbichl' ],
	[ 'BSBD',  'Schönborn' ],
	[ 'MSDF',  'Schondorf (Bay)' ],
	[ 'LSB G', 'Schöneb (E) Gbf' ],
	[ 'LSBS',  'Schönebeck Süd' ],
	[ 'LSB',   'Schönebeck(Elbe)' ],
	[ 'LSBO',  'Schöneb-Frohse' ],
	[ 'DSCK',  'Schöneck (V)' ],
	[ 'DSCF',  'Schöneck(V)Ferp' ],
	[ 'BFHS',  'Schönefeld' ],
	[ 'BFLH',  'Schönefeld S-B' ],
	[ 'BSEP',  'Schöneicher Plan' ],
	[ 'BSL',   'Schönerlinde' ],
	[ 'BSWO',  'Schöneweide Ost' ],
	[ 'BSW',   'Schöneweide S-B' ],
	[ 'HSWO',  'Schönewörde' ],
	[ 'EHGVS', 'Schönfeld Abzw' ],
	[ 'BSFL',  'Schönfließ' ],
	[ 'BSOE',  'Schönfließ Dorf' ],
	[ 'BSNF',  'Schönfließ S-B' ],
	[ 'BSFW',  'Schönfließ West' ],
	[ 'MSGU',  'Schongau' ],
	[ 'MSNG',  'Schöngeising' ],
	[ 'LSH',   'Schönhausen (E)' ],
	[ 'LSHH',  'Schönhausen HGV' ],
	[ 'BSAL',  'Schönhauser All' ],
	[ 'LSM',   'Schönhauser Damm' ],
	[ 'BSNH',  'Schönholz S-B' ],
	[ 'ASCK',  'Schönkirchen' ],
	[ 'RSOM',  'Schönmünzach' ],
	[ 'WSCN',  'Schönow(Uckerm)' ],
	[ 'USCS',  'Schönstedt' ],
	[ 'TSTL',  'Schöntal' ],
	[ 'NSGN',  'Schonungen' ],
	[ 'NSOE',  'Schönwald(Ofr)' ],
	[ 'WSOE',  'Schönwalde' ],
	[ 'BSWL',  'Schönwalde b N' ],
	[ 'WSOG',  'Schönwalde DB-Gr' ],
	[ 'BSCH',  'Schönwalde Sprw' ],
	[ 'BSWA',  'Schönwalde(Barn)' ],
	[ 'BSWH',  'Schönwalde(Barn)' ],
	[ 'XASCH', 'Schönwies' ],
	[ 'RSCH',  'Schopfheim' ],
	[ 'RSCW',  'Schopfheim West' ],
	[ 'TSPF',  'Schopfloch b Fr' ],
	[ 'SSCP',  'Schopp' ],
	[ 'HSPP',  'Schöppenstedt' ],
	[ 'USCH',  'Schöps' ],
	[ 'TSFH',  'Schorndf-Hammer' ],
	[ 'TSF',   'Schorndorf' ],
	[ 'ESHM',  'Schötmar' ],
	[ 'ESHMA', 'Schötmar Awanst' ],
	[ 'XLSW',  'Schouweiler' ],
	[ 'LSRU',  'Schraplau' ],
	[ 'TSCH',  'Schrezheim' ],
	[ 'RS',    'Schriesheim' ],
	[ 'MSHN',  'Schrobenhausen' ],
	[ 'TSZG',  'Schrozberg' ],
	[ 'XASN',  'Schruns' ],
	[ 'ASY',   'Schuby' ],
	[ 'XSSBU', 'Schübelb-Buttiko' ],
	[ 'ASC',   'Schülldorf' ],
	[ 'USP',   'Schüptitz' ],
	[ 'HSTT',  'Schüttorf' ],
	[ 'XBSU',  'Schulen' ],
	[ 'USPF',  'Schulpforte' ],
	[ 'BSZF',  'Schulzendorf(Tg)' ],
	[ 'ASCG',  'Schusterkrug' ],
	[ 'ESCT',  'Schutzbach' ],
	[ 'TSHT',  'Schw H-Hessental' ],
	[ 'WSN',   'Schwaan' ],
	[ 'WSN S', 'Schwaan Süd' ],
	[ 'NSC',   'Schwabach' ],
	[ 'NSCL',  'Schwabach-Limb' ],
	[ 'MSHU',  'Schwabhsn Nord' ],
	[ 'MSHH',  'Schwabhsn/Dachau' ],
	[ 'TSG',   'Schwäbisch Gmünd' ],
	[ 'TSHL',  'Schwäbisch Hall' ],
	[ 'MSMN',  'Schwabmünchen' ],
	[ 'TSWA',  'Schwabsberg' ],
	[ 'TSS W', 'Schwabstr Wende' ],
	[ 'RSU',   'Schwackenreute' ],
	[ 'KSWD',  'Schwadorf' ],
	[ 'NSAI',  'Schwaig' ],
	[ 'MSCG',  'Schwaigen' ],
	[ 'TSWG',  'Schwaigern' ],
	[ 'TSWO',  'Schwaigern Ost' ],
	[ 'TSWW',  'Schwaigern West' ],
	[ 'TSWK',  'Schwaikheim' ],
	[ 'FSTS',  'Schwalb a Ts Li' ],
	[ 'FSLN',  'Schwalbach Nord' ],
	[ 'USWL',  'Schwallungen' ],
	[ 'FWRA',  'Schwalmst-Wiera' ],
	[ 'NSCH',  'Schwandorf' ],
	[ 'NSWK',  'Schwanenkirchen' ],
	[ 'WQSA',  'Schwanhde LGr' ],
	[ 'WSAH',  'Schwanheide' ],
	[ 'BSHE',  'Schwante' ],
	[ 'HSWS',  'Schwarmstedt' ],
	[ 'AWR',   'Schwart Waldh' ],
	[ 'RSZH',  'Schwarzach/Baden' ],
	[ 'XASW',  'Schwarzach-St.V.' ],
	[ 'BSWB',  'Schwarzbach b Ru' ],
	[ 'USCG',  'Schwarzburg' ],
	[ 'NSW',   'Schwarzenb (Pr)' ],
	[ 'NSBS',  'Schwarzenb Saale' ],
	[ 'FSWR',  'Schwarzenbach' ],
	[ 'XSSWB', 'Schwarzenbach SG' ],
	[ 'ASWA',  'Schwarzenbek' ],
	[ 'RSW',   'Schwarzenberg' ],
	[ 'DSCH',  'Schwarzenberg Hp' ],
	[ 'DSC',   'Schwarzenberg(E)' ],
	[ 'DSCN',  'Schwarzenbg-Neuw' ],
	[ 'NSDO',  'Schwarzenf/Opf' ],
	[ 'HSRA',  'Schwarzer Rabe' ],
	[ 'SSWN',  'Schwarzerden' ],
	[ 'BSRO',  'Schwarzheide Ost' ],
	[ 'BSKL',  'Schwarzkollm' ],
	[ 'XASC',  'Schwaz' ],
	[ 'WSC',   'Schwedt (Oder)' ],
	[ 'WSCT',  'Schwedt Mitte' ],
	[ 'HSGM',  'Schwegermoor' ],
	[ 'SSWE',  'Schweich DB' ],
	[ 'HHIS',  'Schweicheln' ],
	[ 'RSHF',  'Schweighofen' ],
	[ 'DSKH',  'Schweikershain' ],
	[ 'NSMT',  'Schweinf Mitte' ],
	[ 'NSST',  'Schweinf Stadt' ],
	[ 'NSSE',  'Schweinf-Sennf' ],
	[ 'NS',    'Schweinfurt Hbf' ],
	[ 'DSU',   'Schweinsb-Cul' ],
	[ 'FSWG',  'Schweinsberg' ],
	[ 'NSWF',  'Schweinsdorf' ],
	[ 'XSSHL', 'Schweizerhalle' ],
	[ 'KSWE',  'Schwelm' ],
	[ 'KSWW',  'Schwelm West' ],
	[ 'KSWL',  'Schwelm-Loh' ],
	[ 'MSWN',  'Schwenningen/Bay' ],
	[ 'RSCV',  'Schwenningen/Ne.' ],
	[ 'WSWN',  'Schwenzin' ],
	[ 'SSWH',  'Schweppenhausen' ],
	[ 'WSGN',  'Schwer-Görr Nord' ],
	[ 'WS',    'Schwerin Hbf' ],
	[ 'WSMI',  'Schwerin Mitte' ],
	[ 'WSS',   'Schwerin Süd' ],
	[ 'WSGR',  'Schwerin-Görries' ],
	[ 'WSWZ',  'Schwerin-Warnitz' ],
	[ 'ESRO',  'Schwerte Ost' ],
	[ 'ESRTF', 'Schwerte West' ],
	[ 'ESRT',  'Schwerte(Ruhr)' ],
	[ 'DSWOP', 'Schweta Bf' ],
	[ 'DSWO',  'Schweta Gasthof' ],
	[ 'RSZ',   'Schwetzingen' ],
	[ 'WSH',   'Schw-Haselholz' ],
	[ 'TSBD',  'Schwieberdingen' ],
	[ 'HSWB',  'Schwindebeck' ],
	[ 'MSDG',  'Schwindegg' ],
	[ 'XFSWM', 'Schwindratzheim' ],
	[ 'WSL',   'Schw-Lankow' ],
	[ 'NSCU',  'Schw-Limbach Üst' ],
	[ 'RSST',  'Schwörstadt' ],
	[ 'XSSY',  'Schwyz' ],
	[ 'XISC',  'Scilla' ],
	[ 'XPSC',  'Scinawa' ],
	[ 'XISO',  'Scordia' ],
	[ 'XSST',  'Scuol-Tarasp' ],
	[ 'DSEB',  'Sebnitz (Sachs)' ],
	[ 'DXSB',  'Sebnitz Grenze' ],
	[ 'XTSBZ', 'Sebuzin' ],
	[ 'FSN',   'Sechshelden' ],
	[ 'KSEC',  'Sechtem' ],
	[ 'XCSE',  'Sechuga' ],
	[ 'RSE',   'Seckach' ],
	[ 'BSE',   'Seddin' ],
	[ 'BSE W', 'Seddin AusfW' ],
	[ 'BSE B', 'Seddin Bla' ],
	[ 'BSE N', 'Seddin Einf Nord' ],
	[ 'BSE O', 'Seddin So' ],
	[ 'BSE M', 'Seddin Srw M' ],
	[ 'BSS',   'Seddin Süd' ],
	[ 'BSS S', 'Seddin Süd Ausf' ],
	[ 'BSS O', 'Seddin Süd Sso' ],
	[ 'BSS W', 'Seddin Süd Ssw' ],
	[ 'BSS U', 'Seddin Süd Umsp' ],
	[ 'HSEB',  'Sedelsberg' ],
	[ 'BSEO',  'Sedlitz Ost' ],
	[ 'USE',   'Seebach(Kr Mühl)' ],
	[ 'WAB',   'Seebad Ahlbeck' ],
	[ 'WHF',   'Seebad Heringsdf' ],
	[ 'WLM',   'Seebad Lubmin' ],
	[ 'USB',   'Seebergen' ],
	[ 'RSEE',  'Seebrugg' ],
	[ 'BSEE',  'Seefeld (Mark)' ],
	[ 'XAS',   'Seefeld in Tirol' ],
	[ 'XASPC', 'Seefeld PlayCast' ],
	[ 'MSH',   'Seefeld-Hechendf' ],
	[ 'MSEG',  'Seeg' ],
	[ 'BSFD',  'Seegefeld' ],
	[ 'LSNA',  'Seehausen (Altm)' ],
	[ 'WSEE',  'Seehausen(Uck)' ],
	[ 'NSHF',  'Seehof' ],
	[ 'LSEE',  'Seehof Abzw' ],
	[ 'MSEH',  'Seehof Bbf' ],
	[ 'LSEG',  'Seehof DB-Gr' ],
	[ 'XASK',  'Seekirchen a W' ],
	[ 'MSEB',  'Seeleiten-Bergg' ],
	[ 'RSWD',  'Seelenwald' ],
	[ 'LSE',   'Seelingst(b Bra)' ],
	[ 'BSLO',  'Seelow (Mark)' ],
	[ 'WSEV',  'Seelvitz' ],
	[ 'HS',    'Seelze' ],
	[ 'HSR',   'Seelze Mitte' ],
	[ 'HSR O', 'Seelze Ost' ],
	[ 'HSR W', 'Seelze West' ],
	[ 'DSRH',  'Seerhausen' ],
	[ 'HSSN',  'Seesen' ],
	[ 'MSE',   'Seeshaupt' ],
	[ 'XISEG', 'Segrate' ],
	[ 'SSE',   'Sehlem(Wittlich)' ],
	[ 'DSEH',  'Sehma' ],
	[ 'HSEN',  'Sehnde' ],
	[ 'MSBD',  'Seiboldsdorf' ],
	[ 'DSF',   'Seiffen (Erzgeb)' ],
	[ 'DXSH',  'Seifhennersdf Gr' ],
	[ 'DSFH',  'Seifhennersdorf' ],
	[ 'WSEI',  'Seilershof' ],
	[ 'DSEN',  'Seitschen' ],
	[ 'XDSE',  'Sejstrup' ],
	[ 'NSN',   'Selb Nord' ],
	[ 'NSS',   'Selb Stadt' ],
	[ 'FMTS',  'Selbach' ],
	[ 'NSLZ',  'Selbitz' ],
	[ 'NSP',   'Selb-Plößberg' ],
	[ 'NSPA',  'Selb-Plößbg Abzw' ],
	[ 'BASS',  'Selchow Süd' ],
	[ 'BASC',  'Selchow West' ],
	[ 'XFSL',  'Selestat' ],
	[ 'KSHS',  'Selhausen' ],
	[ 'FSEL',  'Seligenst (Hess)' ],
	[ 'NSLI',  'Seligenst (Würz)' ],
	[ 'LSEH',  'Sellerhausen' ],
	[ 'WSIN',  'Sellin Ost' ],
	[ 'WSIW',  'Sellin West' ],
	[ 'HSEL',  'Sellingsloh' ],
	[ 'ASLL',  'Sellstedt' ],
	[ 'ESEM',  'Selm' ],
	[ 'ESEB',  'Selm-Beifang' ],
	[ 'ESMG',  'Selmig Abzw' ],
	[ 'XOSB',  'Selsbakk' ],
	[ 'ASLI',  'Selsingen' ],
	[ 'USEL',  'Seltendorf' ],
	[ 'XASZ',  'Selzthal' ],
	[ 'XJSE',  'Semizovac' ],
	[ 'XCSL',  'Semlevo' ],
	[ 'MSED',  'Senden' ],
	[ 'MSWG',  'Senden DB/SWU' ],
	[ 'ESDH',  'Sendenhorst' ],
	[ 'BSN',   'Senftenberg' ],
	[ 'BSN E', 'Senftenberg B 10' ],
	[ 'BSN A', 'Senftenberg B 7' ],
	[ 'XYSM',  'Senica n Myjavou' ],
	[ 'XISE',  'Senigallia' ],
	[ 'XCSN',  'Sennaia' ],
	[ 'ESEL',  'Sennelager' ],
	[ 'ESES',  'Sennestadt' ],
	[ 'TSE',   'Sennfeld' ],
	[ 'XJSA',  'Senta' ],
	[ 'XWSP',  'Septemvri' ],
	[ 'XBSE',  'Seraing' ],
	[ 'WSES',  'Serams' ],
	[ 'XISER', 'Seregno' ],
	[ 'XCSG',  'Sergach' ],
	[ 'XISLC', 'Serralunga-Cer' ],
	[ 'XISVA', 'Serravalle d\'A' ],
	[ 'XISRS', 'Serravalle Scr' ],
	[ 'SSER',  'Serrig' ],
	[ 'TSER',  'Sersheim' ],
	[ 'XISCD', 'Sesto Calende' ],
	[ 'XISGI', 'Sesto S Giovanni' ],
	[ 'XISL',  'Sestri Levante' ],
	[ 'XRSE',  'Sesvete' ],
	[ 'XFSE',  'Sete' ],
	[ 'XXLSR', 'Sete Rios' ],
	[ 'XISCM', 'Settime-Cin-Mom' ],
	[ 'XISTM', 'Settimo' ],
	[ 'NSF',   'Seubersdorf' ],
	[ 'FSG',   'Seulberg' ],
	[ 'NSE',   'Seulbitz' ],
	[ 'XSSV',  'Sevelen' ],
	[ 'XZSN',  'Sevnica' ],
	[ 'NSYB',  'Seybothenreuth' ],
	[ 'XTSZ',  'Sezimovo Usti' ],
	[ 'XISZZ', 'Sezzadio' ],
	[ 'KSGR',  'Sg Grünewald' ],
	[ 'KSS',   'Sg Schaberg' ],
	[ 'KSV',   'Sg Vogelpark' ],
	[ 'ZWSH',  'Shabinka' ],
	[ 'XCSH',  'Shahtnaia' ],
	[ 'ZLSI',  'Sharkiai' ],
	[ 'XKSH',  'Sheffield' ],
	[ 'TAIS',  'Shell' ],
	[ 'ZUSH',  'Shepetovka' ],
	[ 'XNSH',  's-Hertogenbosch' ],
	[ 'ZUSI',  'Shevchenkovo Iuj' ],
	[ 'XWSU',  'Shumen' ],
	[ 'XCSHU', 'Shumerlia' ],
	[ 'ZUSN',  'Sianki' ],
	[ 'XISI',  'Sibari' ],
	[ 'XFS',   'Sibelin' ],
	[ 'XRSB',  'Sibenik' ],
	[ 'XRSI',  'Sibinj' ],
	[ 'XJSI',  'Sid' ],
	[ 'RSIB',  'Siebeldingen-Bi.' ],
	[ 'DSBR',  'Siebenbrunn' ],
	[ 'XSSW',  'Siebnen-Wangen' ],
	[ 'XPS',   'Siedlce' ],
	[ 'ESIH',  'Siedlinghausen' ],
	[ 'KSIB',  'Siegburg/Bonn' ],
	[ 'RSGB',  'Siegelsbach' ],
	[ 'NSDF',  'Siegelsdorf' ],
	[ 'ESIE',  'Siegen' ],
	[ 'ESIG',  'Siegen Ost Gbf' ],
	[ 'EHTG',  'Siegen-Geisweid' ],
	[ 'ESW',   'Siegen-Weidenau' ],
	[ 'XSSH',  'Siegershausen' ],
	[ 'KSLK',  'Sieglar' ],
	[ 'MSGD',  'Siegsdorf' ],
	[ 'KKSS',  'Siegstraße' ],
	[ 'KSIW',  'Siegwerk' ],
	[ 'ESEK',  'Sieker Edeka GM' ],
	[ 'HSIK',  'Siekweg' ],
	[ 'XIS',   'Siena' ],
	[ 'XPSIL', 'Sieniawa Lubuska' ],
	[ 'XPSIZ', 'Sieniawa Zarska' ],
	[ 'XPSR',  'Sieradz' ],
	[ 'XFSIK', 'Sierck-les-Bains' ],
	[ 'ASID',  'Sierksdorf' ],
	[ 'XSSI',  'Sierre/Siders' ],
	[ 'SSBG',  'Siersburg' ],
	[ 'KSIH',  'Siershahn' ],
	[ 'XDSIG', 'Sig' ],
	[ 'XUSM',  'Sighetu Marm' ],
	[ 'XUSG',  'Sighisoara' ],
	[ 'ESI',   'Sigle' ],
	[ 'TSY',   'Siglingen' ],
	[ 'TSIG',  'Sigmaringen' ],
	[ 'TSIL',  'Sigmaringen Lb.' ],
	[ 'TSIH',  'Sigmaringendf Hp' ],
	[ 'TSID',  'Sigmaringendorf' ],
	[ 'ZTS',   'Sigulda' ],
	[ 'ESIL',  'Silbach' ],
	[ 'USI',   'Silberhausen' ],
	[ 'LHSS',  'Silberhöhe' ],
	[ 'LSIB',  'Silberhütte Anh' ],
	[ 'DSBS',  'Silberstraße' ],
	[ 'XDSL',  'Silkeborg' ],
	[ 'XESL',  'Silla' ],
	[ 'XASIL', 'Sillian' ],
	[ 'LBAB',  'Silokanalbrücke' ],
	[ 'XVSI',  'Silverdalen' ],
	[ 'XASLZ', 'Silz' ],
	[ 'MSBI',  'Simbach (Inn)' ],
	[ 'MXS',   'Simbach (Inn) Gr' ],
	[ 'XUSI',  'Simeria' ],
	[ 'ZUSF',  'Simferopol' ],
	[ 'XWSM',  'Simitli' ],
	[ 'NSHU',  'Simmelsd-Hütten' ],
	[ 'XNS',   'Simpelveld' ],
	[ 'FSMH',  'Simtshausen' ],
	[ 'XUSN',  'Sinaia' ],
	[ 'TSI',   'Sindelfingen' ],
	[ 'KSIU',  'Sindorf' ],
	[ 'KSID',  'Sindorf Awanst' ],
	[ 'XGS',   'Sindos' ],
	[ 'ZUSE',  'Sinelnikovo 1' ],
	[ 'ZUSEZ', 'Sinelnikovo 2' ],
	[ 'RSI',   'Singen (Htw)' ],
	[ 'USGN',  'Singen (Thür)' ],
	[ 'RSII',  'Singen Industrie' ],
	[ 'RSIS',  'Singen Landesgar' ],
	[ 'FSL',   'Singlis' ],
	[ 'XOSG',  'Singsas' ],
	[ 'DSGZ',  'Singwitz' ],
	[ 'FSI',   'Sinn' ],
	[ 'NSB',   'Sinnberg' ],
	[ 'RSM',   'Sinsheim Hbf' ],
	[ 'RSMM',  'Sinsheim Museum' ],
	[ 'RSZM',  'Sinzheim (Bühl)' ],
	[ 'RSZN',  'Sinzheim Nord' ],
	[ 'KSIZ',  'Sinzig (Rhein)' ],
	[ 'NSIH',  'Sinzing' ],
	[ 'NSIN',  'Sinzing/Regensbg' ],
	[ 'XMSI',  'Siofok' ],
	[ 'XSSN',  'Sion' ],
	[ 'RSIN',  'Sipplingen' ],
	[ 'XISRC', 'Siracusa' ],
	[ 'XRSS',  'Sisak' ],
	[ 'XSSC',  'Sissach' ],
	[ 'XSSIN', 'Sisseln' ],
	[ 'XPSIK', 'Sitkowka Nowiny' ],
	[ 'XNSI',  'Sittard' ],
	[ 'ASIT',  'Sittensen' ],
	[ 'USDF',  'Sitzend-Unterw' ],
	[ 'XDSR',  'Sjoerring' ],
	[ 'XDSB',  'Skaerbaek' ],
	[ 'XDSK',  'Skagen' ],
	[ 'XTSS',  'Skalice n Svitav' ],
	[ 'XPSKA', 'Skandawa' ],
	[ 'XDSG',  'Skanderborg' ],
	[ 'XCSK',  'Skangali' ],
	[ 'XOTS',  'Skansen' ],
	[ 'XOSE',  'Skarnes' ],
	[ 'XVSE',  'Skee' ],
	[ 'XVSN',  'Skene' ],
	[ 'XOS',   'Ski' ],
	[ 'XPSW',  'Skierniewice' ],
	[ 'XVSGD', 'Skillingaryd' ],
	[ 'XDSI',  'Skive' ],
	[ 'XDSJ',  'Skjern' ],
	[ 'XZSL',  'Skofja Loka' ],
	[ 'ZUSK',  'Skole' ],
	[ 'ZAS',   'Skopje' ],
	[ 'XOSP',  'Skoppum' ],
	[ 'XVSVD', 'Skövde' ],
	[ 'XOSY',  'Skoyen' ],
	[ 'XVSP',  'Skurup' ],
	[ 'XYSL',  'Sladkovicovo' ],
	[ 'XRSL',  'Slavonski Brod' ],
	[ 'ZUSLV', 'Slavsko' ],
	[ 'XPSLK', 'Slawkow' ],
	[ 'XPSP',  'Slawkow Poludin' ],
	[ 'XPSLW', 'Slawno' ],
	[ 'XWSL',  'Sliven' ],
	[ 'ZUSD',  'Slobodka' ],
	[ 'XPSLB', 'Slubice' ],
	[ 'XNSL',  'Sluiskil' ],
	[ 'XTSLN', 'Sluknov' ],
	[ 'XTSLZ', 'Sluknov Zastavka' ],
	[ 'XPSL',  'Slupsk' ],
	[ 'XVSL',  'Smalandsstenar' ],
	[ 'XPSY',  'Smardy' ],
	[ 'XCSM',  'Smolensk' ],
	[ 'XTSM',  'Smrzovka' ],
	[ 'XTSMD', 'Smrzovka dolni' ],
	[ 'XTSMS', 'Smrzovka stred' ],
	[ 'XTSML', 'Smrzovka-Lucni' ],
	[ 'XOSM',  'Snartemo' ],
	[ 'XOSNA', 'Snasa' ],
	[ 'XNSK',  'Sneek' ],
	[ 'XDSN',  'Snested' ],
	[ 'ZUSNI', 'Sniatyn' ],
	[ 'XOSNP', 'Snippen' ],
	[ 'SSOP',  'Sobernh Polymer' ],
	[ 'XPSH',  'Sochaczew' ],
	[ 'XCSI',  'Sochi' ],
	[ 'XESC',  'Socuellamos' ],
	[ 'HSOT',  'Soderstorf' ],
	[ 'XVSD',  'Södertälje Södra' ],
	[ 'XDSGD', 'Soendergaad' ],
	[ 'ESOT',  'Soest' ],
	[ 'ESOS',  'Soest Süd' ],
	[ 'ESTT',  'Soest Thomätor' ],
	[ 'XDSS',  'Soevigsund' ],
	[ 'XWS',   'Sofija' ],
	[ 'XWSS',  'Sofija Sever' ],
	[ 'HSOG',  'Sögel' ],
	[ 'DSOL',  'Sohl' ],
	[ 'DSOH',  'Sohland' ],
	[ 'DSOA',  'Sohland Awanst' ],
	[ 'ZUSO',  'Sokal' ],
	[ 'XTSO',  'Sokolov' ],
	[ 'XCSO',  'Solcy' ],
	[ 'XISLO', 'Solero' ],
	[ 'KSO',   'Solingen Hbf' ],
	[ 'KSM',   'Solingen Mitte' ],
	[ 'LSOL',  'Söllichau' ],
	[ 'LQSO',  'Söllichau ST/SN' ],
	[ 'RSLZ',  'Söllingen Abzw' ],
	[ 'RSLV',  'Söllingen AVG' ],
	[ 'RSLR',  'Söllingen Reetzs' ],
	[ 'RSL',   'Söllingen(Karls)' ],
	[ 'RSLP',  'Söllingen(Rast)' ],
	[ 'USOL',  'Sollstedt' ],
	[ 'FSOL',  'Solms' ],
	[ 'MSO',   'Solnhofen' ],
	[ 'XSSO',  'Solothurn' ],
	[ 'ZUSV',  'Solovino 1' ],
	[ 'LSK',   'Solpke' ],
	[ 'HSO',   'Soltau (Han)' ],
	[ 'ASON',  'Soltau Nord' ],
	[ 'HSOS',  'Soltau Süd' ],
	[ 'HSSG',  'Soltau Süd DB-Gr' ],
	[ 'HSDK',  'Soltendieck' ],
	[ 'TBFK',  'Solvay' ],
	[ 'XFSO',  'Somain' ],
	[ 'XMSH',  'Somlovasarhely' ],
	[ 'XISLB', 'Somma Lombardo' ],
	[ 'XISCA', 'Sommacampagna S' ],
	[ 'RSO',   'Sommerau/Schwar.' ],
	[ 'USD',   'Sömmerda' ],
	[ 'XDSO',  'Sommersted' ],
	[ 'XMSY',  'Somogyjad' ],
	[ 'XMSGS', 'Somogyszob' ],
	[ 'XMSGY', 'Somogyvar' ],
	[ 'ESON',  'Sondern' ],
	[ 'TSOD',  'Sondernach' ],
	[ 'RSOH',  'Sondernheim' ],
	[ 'USH',   'Sondershausen' ],
	[ 'USHG',  'Sondershsn DB-Gr' ],
	[ 'USON',  'Sonneberg Nord' ],
	[ 'USOO',  'Sonneberg Ost' ],
	[ 'USOW',  'Sonneberg West' ],
	[ 'USO',   'Sonneberg(T)Hbf' ],
	[ 'BSO',   'Sonnenallee' ],
	[ 'XOVYS', 'Sonsveien' ],
	[ 'MSHM',  'Sontheim/Schwab' ],
	[ 'TSON',  'Sontheim-Brenz' ],
	[ 'MSF',   'Sonthofen' ],
	[ 'FSON',  'Sontra' ],
	[ 'LSPH',  'Sophienhof HSB' ],
	[ 'NSOP',  'Sophienthal' ],
	[ 'XPSO',  'Sopot' ],
	[ 'XMS',   'Sopron' ],
	[ 'XMSR',  'Sopron Rendezö' ],
	[ 'LSOR',  'Sorge' ],
	[ 'XPSWY', 'Sorkwity' ],
	[ 'XDSOR', 'Soroe' ],
	[ 'XMSO',  'Soroksar Term' ],
	[ 'HSOR',  'Sorsum' ],
	[ 'XOSSA', 'Sorumsand' ],
	[ 'ASOE',  'Sörup' ],
	[ 'XPSZ',  'Sosn Zagorze' ],
	[ 'XPSI',  'Sosnowiec Glowny' ],
	[ 'XPSIJ', 'Sosnowiec Jezor' ],
	[ 'AS',    'Sottrum' ],
	[ 'XKSP',  'South Portal' ],
	[ 'MSY',   'Soyen' ],
	[ 'XBSP',  'Spa' ],
	[ 'LSPA',  'Spaatz' ],
	[ 'TSPM',  'Spaiching Mitte' ],
	[ 'TSP',   'Spaichingen' ],
	[ 'XTSPL', 'Spalov' ],
	[ 'XDSP',  'Spangsbjerg' ],
	[ 'XDSPS', 'Spangsbjerg side' ],
	[ 'ASPS',  'Sparrieshoop' ],
	[ 'KSPA',  'Spay' ],
	[ 'SSPE',  'Speicher' ],
	[ 'NSKN',  'Speikern' ],
	[ 'HSPE',  'Spelle' ],
	[ 'HQSP',  'Spelle NI/NRW' ],
	[ 'ESPN',  'Spellen' ],
	[ 'RSP',   'Speyer Hbf' ],
	[ 'RSPN',  'Speyer Nord-West' ],
	[ 'XTSP',  'Spicak' ],
	[ 'KSPI',  'Spich' ],
	[ 'NSPU',  'Spiegelau' ],
	[ 'RSPG',  'Spielberg' ],
	[ 'XASS',  'Spielfeld-Straß' ],
	[ 'XSSP',  'Spiez' ],
	[ 'XISPG', 'Spigno' ],
	[ 'XISPT', 'Spinetta' ],
	[ 'XYSN',  'Spisska Nova Ves' ],
	[ 'XASPP', 'Spital am Pyhrn' ],
	[ 'XASP',  'Spittal(Millst.)' ],
	[ 'LBSN',  'Splau' ],
	[ 'XRS',   'Split' ],
	[ 'WSP',   'Sponholz' ],
	[ 'WSPO',  'Spornitz' ],
	[ 'XISPN', 'Spotorno' ],
	[ 'BSPE',  'Spreewitz' ],
	[ 'BSPN',  'Spreewitz Nord' ],
	[ 'BSPS',  'Spreewitz Süd' ],
	[ 'BSP',   'Spremberg' ],
	[ 'FSPRN', 'Sprendlgen Nord' ],
	[ 'FSPR',  'Sprendlgn (Rhh)' ],
	[ 'FSPRS', 'Sprendlingen Süd' ],
	[ 'HSPR',  'Springe' ],
	[ 'BSPH',  'Springpfuhl' ],
	[ 'LKS',   'Sprotta Kieswerk' ],
	[ 'ASP',   'Sprötze' ],
	[ 'XISQ',  'Squinzano' ],
	[ 'XJSM',  'Sr Mitrovica' ],
	[ 'MSAB',  'St Alban' ],
	[ 'XFBC',  'St Brice Courc' ],
	[ 'XFSDD', 'St Dalmas Tende' ],
	[ 'DEG',   'St Egidien' ],
	[ 'DEGG',  'St Egidien DB-Gr' ],
	[ 'XSSG',  'St Gallen' ],
	[ 'XSSGW', 'St Gallen Winkel' ],
	[ 'XSSGH', 'St Gallen-Haggen' ],
	[ 'RSGO',  'St Georgen/Schw.' ],
	[ 'XSSGE', 'St German' ],
	[ 'FSGO',  'St Goar' ],
	[ 'FSGH',  'St Goarshausen' ],
	[ 'RSIG',  'St Ilgen-Sandhs' ],
	[ 'SSI',   'St Ingbert' ],
	[ 'XFJ',   'St Jory' ],
	[ 'ESKA',  'St Keppel Allenb' ],
	[ 'MKL',   'St Kolomann' ],
	[ 'XFSMA', 'St Malo' ],
	[ 'MMG',   'St Mang' ],
	[ 'ASM',   'St Margarethen' ],
	[ 'ASD',   'St Michaelisdonn' ],
	[ 'MOTN',  'St Ottilien' ],
	[ 'APO',   'St Peter-Ording' ],
	[ 'SSTO',  'St Thomas' ],
	[ 'SSWD',  'St Wendel' ],
	[ 'HWHS',  'St Wilhelmshaven' ],
	[ 'XAJO',  'St. Jodok' ],
	[ 'XSMZ',  'St. Moritz' ],
	[ 'XAAB',  'St.Anton a.Arlbg' ],
	[ 'XAAM',  'St.Anton i.M.' ],
	[ 'XASJ',  'St.Johann i.P.' ],
	[ 'XAJT',  'St.Johann i.T.' ],
	[ 'XSSM',  'St.Margrethen' ],
	[ 'XASMG', 'St.Martin a Grim' ],
	[ 'XASE',  'St.Michael' ],
	[ 'XCPV',  'St.Peterbg Vars' ],
	[ 'XCPVI', 'St.Peterbg Viteb' ],
	[ 'XCP',   'St.Peterburg' ],
	[ 'XAPF',  'St.Pölten Fbf' ],
	[ 'XAP',   'St.Pölten Hbf' ],
	[ 'XASV',  'St.Valentin' ],
	[ 'XAVG',  'St.Veit a.d.Glan' ],
	[ 'XSSTA', 'Staad' ],
	[ 'AST',   'Stade' ],
	[ 'ASTG',  'Stade DB-Grenze' ],
	[ 'XASU',  'Stadlau' ],
	[ 'TAUS',  'Stadt Aulendorf' ],
	[ 'HBDS',  'Stadt Bünde' ],
	[ 'EEDA',  'Stadt Emsdetten' ],
	[ 'MAFU',  'Stadt Füssen' ],
	[ 'HLRS',  'Stadt Leer' ],
	[ 'XASRM', 'Stadt Rottenmann' ],
	[ 'ESIS',  'Stadt Siegen' ],
	[ 'HVSS',  'Stadt Visselhöv' ],
	[ 'DWH',   'Stadt Wehlen' ],
	[ 'EWRNA', 'Stadt Werne' ],
	[ 'FWOI',  'Stadt Worms Indg' ],
	[ 'FSTA',  'Stadtallendorf' ],
	[ 'SKLS',  'Stadtanschluß' ],
	[ 'BSST',  'Stadtforst' ],
	[ 'HSHG',  'Stadthagen' ],
	[ 'HSHW',  'Stadthagen West' ],
	[ 'ASHS',  'Stadthausbrücke' ],
	[ 'USTM',  'Stadtilm' ],
	[ 'HSDF',  'Stadtoldendorf' ],
	[ 'NSPO',  'Stadtprozelten' ],
	[ 'USR',   'Stadtroda' ],
	[ 'NSTS',  'Stadtsteinach' ],
	[ 'FST',   'Staffel' ],
	[ 'NSTAA', 'Staffelbach Bk 1' ],
	[ 'NSTAF', 'Staffelbach Bk 2' ],
	[ 'LSTL',  'Staffelde' ],
	[ 'XFSTA', 'Staffelfelden' ],
	[ 'MSTW',  'Stahlwerk' ],
	[ 'HBRG',  'Stahlwerke DB-Gr' ],
	[ 'HSTA',  'Stahlwerkskurve' ],
	[ 'RST',   'Stahringen' ],
	[ 'RSTG',  'Stahringen DB/LK' ],
	[ 'XOST',  'Stai' ],
	[ 'XASI',  'Stainach-Irdning' ],
	[ 'ASTD',  'Stakendorf' ],
	[ 'XJSC',  'Stalac' ],
	[ 'SSTB',  'Stambach' ],
	[ 'XFST',  'Stambach' ],
	[ 'NSM',   'Stammbach' ],
	[ 'XFSAR', 'St-Amour' ],
	[ 'XASTM', 'Stams' ],
	[ 'XOSTG', 'Stange' ],
	[ 'XTSN',  'Stankov' ],
	[ 'XASTS', 'Stans(b Schwaz)' ],
	[ 'LSBU',  'Stapelburg' ],
	[ 'LQSB',  'Stapelburg ST/NI' ],
	[ 'XTSBV', 'Stara Boleslav' ],
	[ 'XJSP',  'Stara Pazova' ],
	[ 'XTSR',  'Stara Role' ],
	[ 'XPSJ',  'Stare Jablonki' ],
	[ 'XPSA',  'Stargard Szcz.' ],
	[ 'XRST',  'Stari Mikanovci' ],
	[ 'XTSTK', 'Starkoc' ],
	[ 'MST',   'Starnberg' ],
	[ 'MSNO',  'Starnberg Nord' ],
	[ 'LSF',   'Staßfurt' ],
	[ 'LSF G', 'Staßfurt Gbf' ],
	[ 'XBSA',  'Statte' ],
	[ 'DSTU',  'Stauchitz' ],
	[ 'SSTH',  'Staudernheim' ],
	[ 'RSTF',  'Staufen' ],
	[ 'RSTS',  'Staufen Süd' ],
	[ 'FSPE',  'Staufenb-Speele' ],
	[ 'XOSR',  'Stavanger' ],
	[ 'WRST',  'Stavenhagen' ],
	[ 'XFSA',  'St-Avold' ],
	[ 'XPSTY', 'Stawiany' ],
	[ 'XPSTP', 'Stawiany Pinczow' ],
	[ 'EBGO',  'St-Borghorst' ],
	[ 'EBFT',  'St-Burgsteinfurt' ],
	[ 'XBSD',  'St-Denijs-B' ],
	[ 'RSTB',  'Stebbach' ],
	[ 'XTST',  'Stebnice' ],
	[ 'WSTS',  'Stechlinsee' ],
	[ 'XSSB',  'Steckborn' ],
	[ 'XSSBS', 'Steckborn S' ],
	[ 'HSTF',  'Stederdorf/Uelz' ],
	[ 'ASDS',  'Stedesand' ],
	[ 'LST',   'Stedten' ],
	[ 'XNSW',  'Steenwijk' ],
	[ 'ZUST',  'Stefaneshty' ],
	[ 'NSWH',  'Stegenwaldhaus' ],
	[ 'WHDS',  'Steilk Wittenb' ],
	[ 'TDUS',  'Steim' ],
	[ 'HSTI',  'Steimke' ],
	[ 'HSBF',  'Steimke-Burdorf' ],
	[ 'MSTN',  'Stein a d Traun' ],
	[ 'DSTI',  'Steina' ],
	[ 'RSNA',  'Steinach (Baden)' ],
	[ 'USTN',  'Steinach (Thür)' ],
	[ 'NGYP',  'Steinach Gyproc' ],
	[ 'XAST',  'Steinach i Tirol' ],
	[ 'USTA',  'Steinach Süd' ],
	[ 'NSTN',  'Steinach/R o d T' ],
	[ 'SSTA',  'Steinalben' ],
	[ 'FSA',   'Steinau (Straße)' ],
	[ 'ASTT',  'Steinautal' ],
	[ 'NSD',   'Steinbach a Wald' ],
	[ 'USTH',  'Steinbch-Hallenb' ],
	[ 'USTB',  'Steinberg' ],
	[ 'HSTB',  'Steinbergen' ],
	[ 'XFSNG', 'Steinbourg' ],
	[ 'NNSE',  'Steinbühl' ],
	[ 'XASF',  'Steindorf-Straßw' ],
	[ 'MSA',   'Steinebach' ],
	[ 'XSSU',  'Steinebrunn' ],
	[ 'FSFZ',  'Steinefrenz' ],
	[ 'RSTN',  'Steinen' ],
	[ 'LSR',   'Steinerne Renne' ],
	[ 'FSTE',  'Steinerts' ],
	[ 'HSFD',  'Steinfeld (Oldb)' ],
	[ 'LSFD',  'Steinfeld(b Stl)' ],
	[ 'RSFL',  'Steinfeld(Pfalz)' ],
	[ 'XLST',  'Steinfort' ],
	[ 'FSTF',  'Steinfurth' ],
	[ 'ESTG',  'Steinhagen/Westf' ],
	[ 'WSNB',  'Steinhausen-Neub' ],
	[ 'FSHM',  'Steinheim/Main' ],
	[ 'HSTM',  'Steinheim/Westf' ],
	[ 'MSHG',  'Steinhöring' ],
	[ 'HSTN',  'Steinhorst' ],
	[ 'XOSJ',  'Steinkjer' ],
	[ 'DSPH',  'Steinpleis' ],
	[ 'XSSK',  'Stein-Säckingen' ],
	[ 'RSS',   'Steinsfurt' ],
	[ 'LSBR',  'Steintorbrücke' ],
	[ 'XOSTV', 'Steinvik' ],
	[ 'LDSW',  'Steinw Dönstedt' ],
	[ 'RSTE',  'Steinweiler' ],
	[ 'SSTW',  'Steinwenden' ],
	[ 'MASK',  'Steinwerk Awanst' ],
	[ 'ASTE',  'Stelle' ],
	[ 'HSTE',  'Stelle(Gr Macke)' ],
	[ 'ASTS',  'Stellingen' ],
	[ 'ESML',  'Stemel' ],
	[ 'HSEM',  'Stemmen' ],
	[ 'LS',    'Stendal' ],
	[ 'LSFH',  'Stendal FH' ],
	[ 'LS G',  'Stendal Gbf' ],
	[ 'LSV',   'Stendal Vorbf' ],
	[ 'LSS',   'Stendal-Stadtsee' ],
	[ 'WSD',   'Stendell(PCK)' ],
	[ 'XVSK',  'Stenkullen' ],
	[ 'DSTN',  'Stenn' ],
	[ 'XVSJ',  'Stensjön' ],
	[ 'XVST',  'Stenstorp' ],
	[ 'XVSG',  'Stenungsund' ],
	[ 'XFSF',  'Stephansfeld' ],
	[ 'NSTP',  'Steppach-Pommer' ],
	[ 'FSTZ',  'Sterbfritz' ],
	[ 'WSBU',  'Stern (Buchholz)' ],
	[ 'WSTB',  'Sternberg(Meckl)' ],
	[ 'WSE',   'Sternfeld' ],
	[ 'LSTH',  'Sternhaus-Haferf' ],
	[ 'LSTE',  'Sternh-Ramberg' ],
	[ 'ASST',  'Sternschanze SB' ],
	[ 'XBST',  'Sterpenich' ],
	[ 'FSZH',  'Sterzhausen' ],
	[ 'XTSE',  'Steti' ],
	[ 'XSSE',  'Stettbach' ],
	[ 'TSTD',  'Stetten (D)' ],
	[ 'MSTS',  'Stetten (Schwab)' ],
	[ 'TSHG',  'Stetten am Heubg' ],
	[ 'TSTT',  'Stetten b Haig.' ],
	[ 'TSTE',  'Stetten-Beinst' ],
	[ 'RSF',   'Stettfeld(Baden)' ],
	[ 'XASY',  'Steyr' ],
	[ 'XASYF', 'Steyr Frachtgut' ],
	[ 'TSFS',  'Stg Feuersee' ],
	[ 'TS R',  'Stg Gw Rosenst.' ],
	[ 'TS N',  'Stg Hbf Em Nord' ],
	[ 'TS P',  'Stg Hbf Gw Prag' ],
	[ 'TS T',  'Stg Hbf tief' ],
	[ 'TSNR',  'Stg Nord Gbf' ],
	[ 'TSNRE', 'Stg Nord Gbf Em' ],
	[ 'TSNU',  'Stg Nürnbg Str' ],
	[ 'TSOS',  'Stg Österfeld' ],
	[ 'TSS',   'Stg Schwabstraße' ],
	[ 'TSMI',  'Stg Stadtmitte' ],
	[ 'TSUN',  'Stg Universität' ],
	[ 'TS W',  'Stg.Hbf Wolfram.' ],
	[ 'TSC',   'Stg-Bad Cannst' ],
	[ 'TSEB',  'Stg-Ebitzweg' ],
	[ 'XFSGF', 'St-Germ-d-Fosses' ],
	[ 'XFSG',  'St-Gervais' ],
	[ 'TSZ F', 'Stg-Feuerb WEG' ],
	[ 'TSFE',  'Stg-Feuerbach' ],
	[ 'TSM',   'Stg-Münster' ],
	[ 'TSOM',  'Stg-Obertürkheim' ],
	[ 'TSSM',  'Stg-Sommerrain' ],
	[ 'TSU',   'Stg-Untertürkhm' ],
	[ 'TSU F', 'Stg-Utürkhm 526f' ],
	[ 'TSU P', 'Stg-Utürkhm Pbf' ],
	[ 'TSV',   'Stg-Vaihingen' ],
	[ 'TSWF',  'Stg-Weilimdorf' ],
	[ 'TSZA',  'Stg-Zazenhausen' ],
	[ 'TSZ',   'Stg-Zuffenhausen' ],
	[ 'TSZ E', 'Stg-Zuffenhsn Em' ],
	[ 'XFSHT', 'St-Hilaire-au-T' ],
	[ 'HSVL',  'Stickhsn-Velde' ],
	[ 'LSTI',  'Stiege' ],
	[ 'XFSW',  'Stiring-Wendel' ],
	[ 'XFJL',  'St-Jean-de-Luz' ],
	[ 'XFJMA', 'St-Jean-d-Maur' ],
	[ 'XOSJD', 'Stjordal' ],
	[ 'XFSTL', 'St-Louis' ],
	[ 'XFXSL', 'St-Louis Gr CH' ],
	[ 'XSMC',  'St-Maurice' ],
	[ 'XPSB',  'Stobno' ],
	[ 'RSTK',  'Stockach' ],
	[ 'XVSYD', 'Stockaryd' ],
	[ 'NSOK',  'Stockau' ],
	[ 'MSD',   'Stockdorf' ],
	[ 'XASRA', 'Stockerau' ],
	[ 'FSTH',  'Stockhausen (La)' ],
	[ 'NSTH',  'Stockheim (Ofr)' ],
	[ 'XVS',   'Stockholm' ],
	[ 'XVSO',  'Stockholm Ö' ],
	[ 'XVSS',  'Stockholm Skepps' ],
	[ 'XVSA',  'Stockholm-Arsta' ],
	[ 'XVSC',  'Stockholms C' ],
	[ 'XVSY',  'Stockholms S' ],
	[ 'FSTN',  'Stockschneise' ],
	[ 'FSTK',  'Stockstadt (M)' ],
	[ 'FSTR',  'Stockstadt (Rh)' ],
	[ 'ESTK',  'Stockum' ],
	[ 'ESTR',  'Stockumer Straße' ],
	[ 'XOSK',  'Stokke' ],
	[ 'USTO',  'Stolberg (Harz)' ],
	[ 'KSTT',  'Stolberg Altst' ],
	[ 'KST B', 'Stolberg Gl 27' ],
	[ 'KST E', 'Stolberg Gl 44' ],
	[ 'KSTH',  'Stolberg Hammer' ],
	[ 'KST G', 'Stolberg(Rhl)Gbf' ],
	[ 'KST',   'Stolberg(Rhl)Hbf' ],
	[ 'KST P', 'Stolberg(Rhl)Pbf' ],
	[ 'KSTM',  'Stolbg MühlenerB' ],
	[ 'KSTR',  'Stolbg Rathaus' ],
	[ 'KSTS',  'Stolbg Schneidmü' ],
	[ 'DSTO',  'Stollberg(Sachs)' ],
	[ 'DSTOS', 'Stollbg Schlacht' ],
	[ 'RSHN',  'Stollhofen' ],
	[ 'DSTL',  'Stolpen' ],
	[ 'KSOM',  'Stommeln' ],
	[ 'XVSH',  'Stora Höga' ],
	[ 'XOSKV', 'Storekvina' ],
	[ 'XOSO',  'Storen' ],
	[ 'BSTW',  'Storkow (Mark)' ],
	[ 'BSTO',  'Storkower Str' ],
	[ 'TSGZ',  'Storzingen' ],
	[ 'USTS',  'Stößen' ],
	[ 'USHM',  'Stotternheim' ],
	[ 'KSTZ',  'Stotzheim' ],
	[ 'XFPY',  'St-Pierre-d\'Alb' ],
	[ 'XFPDC', 'St-Pierre-d-C' ],
	[ 'XFPL',  'St-Pol-de-Leon' ],
	[ 'XFSP',  'St-Priest' ],
	[ 'XFSQ',  'St-Quentin' ],
	[ 'XISTD', 'Stradella' ],
	[ 'WSRB',  'Strals-Grünhufe' ],
	[ 'WSR',   'Stralsund Hbf' ],
	[ 'WSRR',  'Stralsund Rgd' ],
	[ 'WSRG',  'Stralsund SRG' ],
	[ 'XFSR',  'St-Raphael-Vales' ],
	[ 'XFSTH', 'Strasb Port-d-Rh' ],
	[ 'XFCBR', 'Strasb-Cronenbg' ],
	[ 'XFSTD', 'Strasbg Neudorf' ],
	[ 'XFSTN', 'Strasbg.Rbf Nord' ],
	[ 'XFSTS', 'Strasbg.Rbf Süd' ],
	[ 'XFSTK', 'Strasbg-Koenigsh' ],
	[ 'XFSTG', 'Strasbourg' ],
	[ 'WSB',   'Strasburg' ],
	[ 'LSTR',  'Straßberg Harz' ],
	[ 'LSGL',  'Straßberg-Glaseb' ],
	[ 'TSTR',  'Straßberg-Wiling' ],
	[ 'DSTR',  'Straßgr-Bernsdf' ],
	[ 'XASTH', 'Straßhof' ],
	[ 'NSK',   'Straßkirchen' ],
	[ 'MSMS',  'Straß-Moos' ],
	[ 'XASR',  'Straßwalchen' ],
	[ 'XKSF',  'Stratford Int' ],
	[ 'NST',   'Straubing' ],
	[ 'NSTC',  'Straubing Müllv' ],
	[ 'NSTT',  'Straubing Ost' ],
	[ 'BST',   'Strausberg' ],
	[ 'BSTN',  'Strausberg Nord' ],
	[ 'BSTV',  'Strausberg S-B' ],
	[ 'BSTR',  'Strausberg Stadt' ],
	[ 'BSTS',  'Strausberg Stadt' ],
	[ 'USF',   'Straußfurt' ],
	[ 'USFG',  'Straußfurt DB-Gr' ],
	[ 'XYSZ',  'Strazske' ],
	[ 'XYSB',  'Strba' ],
	[ 'ASTR',  'Strecknitz' ],
	[ 'XYSC',  'Strecno' ],
	[ 'XTSK',  'Stredokluky' ],
	[ 'XUSH',  'Strehaia Halta' ],
	[ 'NSTR',  'Streitberg' ],
	[ 'XYSK',  'Strekov' ],
	[ 'XASTR', 'Strengen' ],
	[ 'XISTA', 'Stresa' ],
	[ 'BSRW',  'Stresow' ],
	[ 'XISVI', 'Strevi' ],
	[ 'TBAW',  'StreWe 4520/4521' ],
	[ 'XTSB',  'Stribro' ],
	[ 'XRSV',  'Striziv Vrpolje' ],
	[ 'LSTK',  'Ströbeck' ],
	[ 'DSTM',  'Strobelmühle' ],
	[ 'WSTK',  'Strohkirchen' ],
	[ 'SST G', 'Stromberg Einf' ],
	[ 'SST',   'Stromberg/Hunsr.' ],
	[ 'XVSMS', 'Strömstad' ],
	[ 'FMOES', 'Strötzbach' ],
	[ 'XDS',   'Struer' ],
	[ 'ASTK',  'Strukkamp' ],
	[ 'NFFG',  'Strullend DB-Gr' ],
	[ 'NSU',   'Strullendorf' ],
	[ 'ESTU',  'Struthütten' ],
	[ 'EWIH',  'Strw 2143/2144' ],
	[ 'EGHE',  'Strw 2172/2230' ],
	[ 'EGB',   'Strw 2205/2206' ],
	[ 'EEFR',  'Strw 2244/2280' ],
	[ 'KANG',  'Strw 2404/2405' ],
	[ 'KDL',   'Strw 2410/2411' ],
	[ 'KMAW',  'Strw 2581/2601' ],
	[ 'EEIN',  'Strw 2811/2823' ],
	[ 'SBIW',  'Strw 3141/3140' ],
	[ 'YFRSR', 'Strw 5223/4124' ],
	[ 'BPRA',  'Strw 6542/6553' ],
	[ 'BPRB',  'Strw 6555/6542' ],
	[ 'YBBDB', 'Strw 6941/6942' ],
	[ 'YTTSE', 'StrWe 4800/4842' ],
	[ 'YKMSN', 'StrWe 4951/5902' ],
	[ 'FSY',   'Stryck' ],
	[ 'ZUSY',  'Stryi' ],
	[ 'XGSR',  'Strymon' ],
	[ 'XPSKW', 'Strzelce Kraj W' ],
	[ 'XPSOP', 'Strzelce Opolsk' ],
	[ 'XFSSL', 'St-Sulpice-Laur' ],
	[ 'HSUB',  'Stubben' ],
	[ 'WSBB',  'Stubbenfelde' ],
	[ 'TSBH',  'Stubersheim' ],
	[ 'XTSA',  'Studenka' ],
	[ 'XDST',  'Studsgaard' ],
	[ 'RSTU',  'Stühlingen' ],
	[ 'UST',   'Stützerbach' ],
	[ 'HSTU',  'Stuhr' ],
	[ 'NSUL',  'Stulln-Nabburg' ],
	[ 'LSTF',  'Stumsdorf' ],
	[ 'KSTU',  'Sturm' ],
	[ 'XYST',  'Sturovo' ],
	[ 'TSH',   'Stuttgart Hafen' ],
	[ 'TS',    'Stuttgart Hbf' ],
	[ 'TSO',   'Stuttgart Ost' ],
	[ 'TSW',   'Stuttgart West' ],
	[ 'TSRO',  'Stuttgart-Rohr' ],
	[ 'XJST',  'Subotica' ],
	[ 'WSBA',  'Subzin-L Awanst' ],
	[ 'WSBN',  'Subzin-Liessow' ],
	[ 'XTS',   'Sucha' ],
	[ 'XTSU',  'Suchdol n Odrou' ],
	[ 'ASU',   'Suchsdorf' ],
	[ 'ASUG',  'Suchsdorf DB-Gr' ],
	[ 'HSUD',  'Suderburg' ],
	[ 'HSUW',  'Suderwittingen' ],
	[ 'HSUH',  'Sudheim' ],
	[ 'ESDM',  'Sudmühle' ],
	[ 'HSWY',  'Sudweyhe' ],
	[ 'KSBR',  'Südbrücke' ],
	[ 'BSDE',  'Südende' ],
	[ 'ASUE',  'Süderbrarup' ],
	[ 'ASDD',  'Süderdeich' ],
	[ 'ASEG',  'Süderelbbr DB-Gr' ],
	[ 'ASE',   'Süderelbbrücke' ],
	[ 'ANBS',  'Süderlügum' ],
	[ 'ANBA',  'Süderlügum Awans' ],
	[ 'AXS',   'Süderlügum Gr' ],
	[ 'BSKR',  'Südkreuz (Rb)' ],
	[ 'BSKV',  'Südkreuz (Vb)' ],
	[ 'LSUE',  'Südstadt' ],
	[ 'LSUEA', 'Südstadt Bft Sa' ],
	[ 'TBF S', 'Südzucker' ],
	[ 'HSUK',  'Sülbeck' ],
	[ 'HSF',   'Sülfeld' ],
	[ 'ASDF',  'Sülldorf' ],
	[ 'WSLT',  'Sülstorf' ],
	[ 'TSUE',  'Sülzbach' ],
	[ 'TSUS',  'Sülzbach Schule' ],
	[ 'HSUZ',  'Sülze (Han)' ],
	[ 'USUE',  'Sülzenbrücken' ],
	[ 'NSUE',  'Sünching' ],
	[ 'LSUP',  'Süplingen' ],
	[ 'LSUPA', 'Süplingen Abzw' ],
	[ 'ASUP',  'Suerhop' ],
	[ 'KSU',   'Sürth' ],
	[ 'TSD',   'Süßen' ],
	[ 'XASBN', 'Süssenbrunn' ],
	[ 'HSUS',  'Süstedt' ],
	[ 'XPSF',  'Sufczyn' ],
	[ 'XCSUG', 'Suhinichi-Gl' ],
	[ 'USL',   'Suhl' ],
	[ 'USLH',  'Suhl-Heinrichs' ],
	[ 'XHS',   'Sukeva' ],
	[ 'WSU',   'Sukow' ],
	[ 'XPSUL', 'Sulechow' ],
	[ 'XCSU',  'Sulin' ],
	[ 'HSUL',  'Sulingen (Han)' ],
	[ 'XFSS',  'Sully sur Loire' ],
	[ 'TSUL',  'Sulz (Neckar)' ],
	[ 'XASUL', 'Sulzau' ],
	[ 'NSRH',  'Sulzb Rosenbg H' ],
	[ 'MSBH',  'Sulzbach (Inn)' ],
	[ 'NSUZ',  'Sulzbach (M)' ],
	[ 'TSBM',  'Sulzbach (Murr)' ],
	[ 'SSZ',   'Sulzbach (Saar)' ],
	[ 'FSZ',   'Sulzbach (Ts)' ],
	[ 'FSZN',  'Sulzbach (Ts) N' ],
	[ 'TSBK',  'Sulzbach(Kocher)' ],
	[ 'NSR',   'Sulzbach-Rosenbg' ],
	[ 'SSZA',  'Sulzb-Altenw' ],
	[ 'MSUG',  'Sulzberg' ],
	[ 'TSUD',  'Sulzdorf' ],
	[ 'RSFR',  'Sulzf Ravensburg' ],
	[ 'RSFD',  'Sulzfeld (Baden)' ],
	[ 'XASUM', 'Summerau' ],
	[ 'ZUS',   'Sumy' ],
	[ 'ESUD',  'Sundern/Sauerl' ],
	[ 'BSDG',  'Sundgauer Str' ],
	[ 'XVSU',  'Sundsvall' ],
	[ 'XRSU',  'Sunja' ],
	[ 'TSUH',  'S-Untertürkh Hp' ],
	[ 'XCST',  'Surovatiha' ],
	[ 'XSSUS', 'Sursee' ],
	[ 'XFSVF', 'Survilliers Foss' ],
	[ 'XCSC',  'Suscevo' ],
	[ 'XNSU',  'Susteren' ],
	[ 'DSUT',  'Sutter' ],
	[ 'HSUN',  'Sutthausen' ],
	[ 'XCSZ',  'Suzemka' ],
	[ 'ZUSL',  'Svaliava' ],
	[ 'XTSV',  'Svatava' ],
	[ 'XTSVZ', 'Svatava zast' ],
	[ 'XVSDA', 'Svedala' ],
	[ 'XDSV',  'Svejbaek' ],
	[ 'XOSD',  'Svenningdal' ],
	[ 'XVSVH', 'Svenshögen' ],
	[ 'XTSC',  'Svetec' ],
	[ 'XJSZ',  'Svetozarevo' ],
	[ 'XWSV',  'Svilengrad' ],
	[ 'XWSVS', 'Svilengrad Süd' ],
	[ 'XTSI',  'Svitavy' ],
	[ 'XWSO',  'Svoge' ],
	[ 'XTSVO', 'Svor' ],
	[ 'DSVT',  'Svt' ],
	[ 'WSMH',  'Sw Margaretenhof' ],
	[ 'XPSWZ', 'Swarzedz' ],
	[ 'XPSWW', 'Swidwin' ],
	[ 'XPSWB', 'Swiebodzin' ],
	[ 'XPSWI', 'Swinoujscie' ],
	[ 'XPSM',  'Swinoujscie C' ],
	[ 'HSYK',  'Syke' ],
	[ 'HSYD',  'Syke Ost' ],
	[ 'HSYS',  'Syke Stadt' ],
	[ 'ESYL',  'Sylbach' ],
	[ 'DSY',   'Syrau' ],
	[ 'XLSY',  'Syren' ],
	[ 'ESYH',  'Sythen' ],
	[ 'ESYB',  'Sythen Bbf' ],
	[ 'XCSY',  'Syzran 1' ],
	[ 'HSZH',  'Sz Haverlahw' ],
	[ 'HSHN',  'Sz Hütte Nord' ],
	[ 'HSHS',  'Sz Hütte Süd' ],
	[ 'HSZK',  'Sz Sch Konrad 1' ],
	[ 'XMST',  'Szabadbattyan' ],
	[ 'XMSF',  'Szabadifürdö' ],
	[ 'XMSZG', 'Szabadikigyos' ],
	[ 'XMSJ',  'Szajol' ],
	[ 'XMSZH', 'Szakaly-Högyesz' ],
	[ 'XMSZK', 'Szantod-Körösheg' ],
	[ 'HSZB',  'Sz-Beddingen Hf' ],
	[ 'HBVW',  'Sz-Beddingen VW' ],
	[ 'HSZC',  'Sz-Calbecht' ],
	[ 'XPSZC', 'Szczaniec' ],
	[ 'XPSGI', 'Szczecin Glinki' ],
	[ 'XPSG',  'Szczecin Glowny' ],
	[ 'XPSU',  'Szczecin Gu.' ],
	[ 'XPSN',  'Szczecin Nieb' ],
	[ 'XPSPB', 'Szczecin PCB' ],
	[ 'XPSPC', 'Szczecin PCC' ],
	[ 'XPST',  'Szczecin Turzyn' ],
	[ 'XPSWH', 'Szczecin WZH' ],
	[ 'XPSD',  'Szczecin-Dabie' ],
	[ 'XPSK',  'Szczecinek' ],
	[ 'XPWS',  'Szczecin-Wstowo' ],
	[ 'HSD',   'Sz-Drütte' ],
	[ 'XMSD',  'Szeged-Rokus' ],
	[ 'XMSZ',  'Szekesfehervar' ],
	[ 'XMSZR', 'Szekesferevar-Re' ],
	[ 'HSZE',  'Sz-Engelnstedt' ],
	[ 'XMSE',  'Szentes' ],
	[ 'XMSL',  'Szentgal' ],
	[ 'XMSG',  'Szentgotthard' ],
	[ 'XMSZZ', 'Szepezdfürdö' ],
	[ 'XMSS',  'Szerencs' ],
	[ 'HSZI',  'Sz-Immendf West' ],
	[ 'HSI',   'Sz-Immendorf' ],
	[ 'XPSPG', 'Szklarska Por Go' ],
	[ 'XPSPH', 'Szklarska Por Hu' ],
	[ 'HSL',   'Sz-Lebenstedt' ],
	[ 'XMSB',  'Szob' ],
	[ 'XMXSB', 'Szob Gr SK' ],
	[ 'XMSN',  'Szolnok' ],
	[ 'XPSZP', 'Szprotawa' ],
	[ 'HSRI',  'Sz-Ringelheim' ],
	[ 'HST',   'Sz-Thiede' ],
	[ 'HSZV',  'Sz-Voßpass' ],
	[ 'HSWI',  'Sz-Watenst Ikea' ],
	[ 'HSW',   'Sz-Watenstedt' ],
	[ 'LTA',   'Tabakmühle' ],
	[ 'XJTA',  'Tabanovci' ],
	[ 'STB',   'Taben' ],
	[ 'XVTG',  'Taberg' ],
	[ 'XTT',   'Tabor' ],
	[ 'MTCH',  'Tacherting' ],
	[ 'XITG',  'Taggia' ],
	[ 'XCTT',  'Tahtalym' ],
	[ 'TTH',   'Talhausen' ],
	[ 'ZETN',  'Tallinn' ],
	[ 'XUTL',  'Talmaciu' ],
	[ 'XCTA',  'Tamala' ],
	[ 'XCT',   'Tambov 1' ],
	[ 'XBTA',  'Tamines' ],
	[ 'TTM',   'Tamm (Württ)' ],
	[ 'XOTN',  'Tangen' ],
	[ 'LTH',   'Tangerhütte' ],
	[ 'LTM',   'Tangermünde' ],
	[ 'LTMW',  'Tangermünde West' ],
	[ 'DTN',   'Tanna' ],
	[ 'DTA',   'Tanndorf' ],
	[ 'XVTN',  'Tannefors' ],
	[ 'ATAK',  'Tanneneck' ],
	[ 'TTA',   'Tannheim (Württ)' ],
	[ 'TQTA',  'Tannheim(W)LGr' ],
	[ 'UTA',   'Tannroda' ],
	[ 'TTAW',  'Tannwald' ],
	[ 'WTA',   'Tantow' ],
	[ 'WXT',   'Tantow Gr' ],
	[ 'XVTA',  'Tanum' ],
	[ 'XTTA',  'Tanvald' ],
	[ 'XTTZ',  'Tanvald zastavka' ],
	[ 'XITM',  'Taormina-Giardin' ],
	[ 'MTPF',  'Tapfheim' ],
	[ 'XMTP',  'Tapolca' ],
	[ 'XITA',  'Taranto' ],
	[ 'XFTA',  'Tarascon' ],
	[ 'XDTAM', 'Tarm' ],
	[ 'XMTR',  'Tarnok' ],
	[ 'XPTA',  'Tarnow' ],
	[ 'XPTAO', 'Tarnow Opolski' ],
	[ 'XPTG',  'Tarnowskie Gory' ],
	[ 'ATP',   'Tarp' ],
	[ 'XETA',  'Tarragona' ],
	[ 'XITB',  'Tarvisio Boscov' ],
	[ 'XIXTB', 'Tarvisio Gr AT' ],
	[ 'XMTS',  'Taszar' ],
	[ 'XMTA',  'Tata' ],
	[ 'XMTB',  'Tatabanya' ],
	[ 'XMTV',  'Tatarvar' ],
	[ 'ATAT',  'Tating' ],
	[ 'DTB',   'Taubenheim' ],
	[ 'TTBN',  'Tauberbisch Nord' ],
	[ 'TTB',   'Tauberbischofshm' ],
	[ 'MTA',   'Tauberfeld' ],
	[ 'FTM',   'Taubertsmühle' ],
	[ 'LTC',   'Taucha (b Lpz)' ],
	[ 'MTU',   'Taufkirchen' ],
	[ 'XATF',  'Taufkirchen Pram' ],
	[ 'XDTA',  'Taulov' ],
	[ 'LTNH',  'Tautenhain' ],
	[ 'XFTX',  'Tavaux' ],
	[ 'XFTXS', 'Tavaux Solvay' ],
	[ 'XITL',  'Tavernelle' ],
	[ 'XST',   'Taverne-Torric' ],
	[ 'XATR',  'Taxenbach-Rauris' ],
	[ 'XATX',  'Taxham' ],
	[ 'XPTC',  'Tczew' ],
	[ 'HTKB',  'Tecklenburg' ],
	[ 'XSTE',  'Tecknau' ],
	[ 'MTE',   'Tegernsee' ],
	[ 'LTE',   'Teicha' ],
	[ 'BT',    'Teichland' ],
	[ 'MTO',   'Teisendorf' ],
	[ 'NTEN',  'Teisnach' ],
	[ 'XMTG',  'Telegerendas' ],
	[ 'XITEL', 'Telese' ],
	[ 'XATP',  'Telfs-Pfaffenhfn' ],
	[ 'ETEL',  'Telgte' ],
	[ 'BTL',   'Teltow' ],
	[ 'BQTL',  'Teltow BB/BE' ],
	[ 'BGSBT', 'Teltow Gbf' ],
	[ 'BTLS',  'Teltow Stadt' ],
	[ 'STS',   'Temmels' ],
	[ 'BTHF',  'Tempelhof S-B' ],
	[ 'XFTE',  'Templeuve' ],
	[ 'WT',    'Templin' ],
	[ 'WTVG',  'Templin DB-Grenz' ],
	[ 'WFH',   'Templin Fährkrug' ],
	[ 'WTV',   'Templin Stadt' ],
	[ 'WTAD',  'Templin-Ahrensdf' ],
	[ 'XFTND', 'Tende' ],
	[ 'XVTT',  'Tenhult' ],
	[ 'RTMU',  'Teningen-Mund' ],
	[ 'XATN',  'Tenneck' ],
	[ 'XTTV',  'Teplic v Cechach' ],
	[ 'XYTV',  'Teplicka n Vahom' ],
	[ 'XPTE',  'Terespol' ],
	[ 'XPXTE', 'Terespol Gr BY' ],
	[ 'XPTP',  'Terespol Pom' ],
	[ 'XATW',  'Terfens-Weer' ],
	[ 'XFTG',  'Tergnier' ],
	[ 'XITE',  'Termini Imerese' ],
	[ 'XITO',  'Termoli' ],
	[ 'XNTE',  'Terneuzen' ],
	[ 'XITN',  'Terni' ],
	[ 'ZUTP',  'Ternopol' ],
	[ 'XITT',  'Terontola Corton' ],
	[ 'XHTJ',  'Tervajoki' ],
	[ 'XHTV',  'Tervola' ],
	[ 'XITZM', 'Terzo-Montabone' ],
	[ 'WTHN',  'Teschenhagen' ],
	[ 'WTOW',  'Teschow' ],
	[ 'XBTS',  'Tessenderlo' ],
	[ 'WTI',   'Tessin' ],
	[ 'WTIW',  'Tessin West' ],
	[ 'XBTE',  'Testelt' ],
	[ 'XLTT',  'Tetange' ],
	[ 'WTE',   'Teterow' ],
	[ 'XFTT',  'Teting' ],
	[ 'NTZ',   'Teublitz (Opf)' ],
	[ 'UTEU',  'Teuchern' ],
	[ 'UTEG',  'Teuchern DB-Gr' ],
	[ 'DTF',   'Teufelsmühle' ],
	[ 'UQTL',  'Teutleben TH/ST' ],
	[ 'LTTO',  'Teutschenth Ost' ],
	[ 'LTT',   'Teutschenthal' ],
	[ 'XFHP',  'TGV Hte Picardie' ],
	[ 'LTL',   'Thale Hbf' ],
	[ 'LTLM',  'Thale Musestieg' ],
	[ 'STWF',  'Thaleischw-Frö' ],
	[ 'TTL',   'Thalfingen b Ulm' ],
	[ 'TQTL',  'Thalfingen LGr' ],
	[ 'DTAL',  'Thalheim (Erzg)' ],
	[ 'DTL',   'Thalheim-Kr' ],
	[ 'FTHA',  'Thalitter' ],
	[ 'NTMG',  'Thalmässing' ],
	[ 'XSTW',  'Thalwil' ],
	[ 'MTHN',  'Thannhausen/Schw' ],
	[ 'MTMA',  'Thann-Matzbach' ],
	[ 'MTHU',  'Thansau' ],
	[ 'NTAS',  'Thansüß' ],
	[ 'DTH',   'Tharandt' ],
	[ 'RTG',   'Thayngen' ],
	[ 'RQTG',  'Thayngen CH/BW' ],
	[ 'HTDH',  'Thedinghausen' ],
	[ 'STN',   'Theisbergstegen' ],
	[ 'LT',    'Theißen' ],
	[ 'UTH',   'Themar' ],
	[ 'UTHG',  'Themar DB-Gr' ],
	[ 'DWIE',  'Therm Wiesenbad' ],
	[ 'ATHS',  'Thesdorf' ],
	[ 'XGT',   'Thessaloniki' ],
	[ 'XFTI',  'Thiacourt' ],
	[ 'XFTHV', 'Thionville' ],
	[ 'XDT',   'Thisted' ],
	[ 'XGTH',  'Thive' ],
	[ 'NT',    'Thüngen (Ufr)' ],
	[ 'NTHM',  'Thüngersheim' ],
	[ 'KTH',   'Thür' ],
	[ 'XSTH',  'Thun' ],
	[ 'XSTU',  'Thusis' ],
	[ 'BTHR',  'Thyrow' ],
	[ 'ETHY',  'Thyssen (Hatt)' ],
	[ 'DTHY',  'Thyssen-Schulte' ],
	[ 'ZUTI',  'Tiachevo' ],
	[ 'ATB',   'Tiebensee' ],
	[ 'DTFN',  'Tiefenau' ],
	[ 'NTFB',  'Tiefenb (Passau)' ],
	[ 'LTF',   'Tiefenbachmühle' ],
	[ 'ETIE',  'Tiefenbroich' ],
	[ 'BTFS',  'Tiefensee' ],
	[ 'XFTB',  'Tieffenbach' ],
	[ 'ATK',   'Tiefstack' ],
	[ 'XBTI',  'Tienen' ],
	[ 'RTI',   'Tiengen (Hochrh)' ],
	[ 'BTGN',  'Tiergarten' ],
	[ 'XHTK',  'Tikkurila' ],
	[ 'XNT',   'Tilburg' ],
	[ 'XBTL',  'Tilleur' ],
	[ 'XFTBY', 'Tilloy-et-Bellay' ],
	[ 'XDTM',  'Tim' ],
	[ 'XUT',   'Timisoara C' ],
	[ 'ATIM',  'Timmend Strand' ],
	[ 'XDTI',  'Tinglev' ],
	[ 'XDTN',  'Tingsted' ],
	[ 'ZMT',   'Tiraspol' ],
	[ 'XUTR',  'Tirgoviste' ],
	[ 'XUTF',  'Tirgu Frumos' ],
	[ 'XUTJ',  'Tirgu Jiu' ],
	[ 'XUTM',  'Tirgu Mures' ],
	[ 'XTTC',  'Tisice' ],
	[ 'XATI',  'Tisis' ],
	[ 'XTTI',  'Tisova u N' ],
	[ 'ATIT',  'Tiste' ],
	[ 'XDTR',  'Tistrup' ],
	[ 'XMTT',  'Tiszatenyö' ],
	[ 'XMTU',  'Tiszaujvaros' ],
	[ 'RTIT',  'Titisee' ],
	[ 'XJT',   'Titograd' ],
	[ 'XJTM',  'Titovo Mitrovica' ],
	[ 'MWSL',  'Tittmoning-Wiesm' ],
	[ 'XUTT',  'Titu' ],
	[ 'XCTM',  'Tiumen' ],
	[ 'HTIV',  'Tivoli' ],
	[ 'XDTB',  'Tjaereborg' ],
	[ 'XVTY',  'Tjunnaryd' ],
	[ 'XVTK',  'Tjustskolan' ],
	[ 'XSTOA', 'Tobel-Affeltrang' ],
	[ 'ZKT',   'Tobol' ],
	[ 'XDTO',  'Toender' ],
	[ 'XDTON', 'Toender Nord' ],
	[ 'XVTO',  'Tofta' ],
	[ 'MTG',   'Töging (Inn)' ],
	[ 'XMT',   'Tokaj' ],
	[ 'XOTL',  'Tolga' ],
	[ 'XPTM',  'Tomaszow Maz' ],
	[ 'XDTP',  'Tommerup' ],
	[ 'HTBR',  'Ton- u Torfwerke' ],
	[ 'XITOA', 'Tonco-Alfiano' ],
	[ 'XBTG',  'Tongeren' ],
	[ 'KTVD',  'Tönisvorst' ],
	[ 'HTNH',  'Tönnhausen' ],
	[ 'ATG',   'Tönning' ],
	[ 'XUTP',  'Toplita' ],
	[ 'XPTOP', 'Toporow' ],
	[ 'UTP',   'Töppeln' ],
	[ 'UTPU',  'Töppeln Üst' ],
	[ 'HTPP',  'Toppenstedt' ],
	[ 'XVTB',  'Töreboda' ],
	[ 'LTG',   'Torgau' ],
	[ 'LTG E', 'Torgau (Et)' ],
	[ 'WTO',   'Torgelow' ],
	[ 'XITUS', 'Torino d Sangro' ],
	[ 'XITD',  'Torino Dora' ],
	[ 'XITUL', 'Torino Lingotto' ],
	[ 'XITUO', 'Torino Orbassano' ],
	[ 'XITUP', 'Torino P Susa' ],
	[ 'XITU',  'Torino P.N.' ],
	[ 'XITUR', 'Torino Stura' ],
	[ 'XDTY',  'Tornby' ],
	[ 'ATM',   'Tornesch' ],
	[ 'LTN',   'Tornitz' ],
	[ 'LTNG',  'Tornitz DB-Grenz' ],
	[ 'XVTP',  'Torpakra' ],
	[ 'XITZ',  'Torrazza Piem' ],
	[ 'XITOB', 'Torreberetti' ],
	[ 'XITOR', 'Tortona' ],
	[ 'XPTO',  'Torun Glowny' ],
	[ 'XVTU',  'Torup' ],
	[ 'XPTOR', 'Torzym' ],
	[ 'ATST',  'Tostedt' ],
	[ 'ATSG',  'Tostedt DB-Gr' ],
	[ 'ATSW',  'Tostedt West' ],
	[ 'XFTU',  'Toul' ],
	[ 'XFTO',  'Toulon' ],
	[ 'XFTM',  'Toulouse-Matabi' ],
	[ 'XFTC',  'Tourcoing' ],
	[ 'XBTO',  'Tournai' ],
	[ 'XFTOU', 'Tournan' ],
	[ 'XFTOC', 'Tournan-Chatres' ],
	[ 'XRT',   'Tovarnik' ],
	[ 'XRXTO', 'Tovarnik Gr RS' ],
	[ 'XOTE',  'Toyen' ],
	[ 'STT',   'Traben Trarb. DB' ],
	[ 'NTB',   'Trabitz' ],
	[ 'XKTP',  'Trafford Park' ],
	[ 'FTH',   'Trais-Horloff' ],
	[ 'XVTR',  'Tranas' ],
	[ 'XITI',  'Trani' ],
	[ 'TTPS',  'Trappensee' ],
	[ 'RT',    'Trasadingen' ],
	[ 'WTH',   'Trassenheide' ],
	[ 'WTM',   'Trassenmoor' ],
	[ 'HTRA',  'Trauen' ],
	[ 'UTN',   'Traun' ],
	[ 'XATRN', 'Traun' ],
	[ 'MTRD',  'Traundorf' ],
	[ 'MTRT',  'Traunreut' ],
	[ 'MTSK',  'Traunst Klinikum' ],
	[ 'MTS',   'Traunstein' ],
	[ 'MAST',  'Traunstein Stadt' ],
	[ 'XZT',   'Trbovlje' ],
	[ 'LTU',   'Trebbichau' ],
	[ 'BTN',   'Trebbin' ],
	[ 'LTRL',  'Treben-Lehma' ],
	[ 'NTG',   'Trebgast' ],
	[ 'LTB',   'Trebitz (Elbe)' ],
	[ 'LTRB',  'Trebitz(b Könn)' ],
	[ 'BTZ',   'Trebnitz (Mark)' ],
	[ 'LTNZ',  'Trebnitz Strw' ],
	[ 'LTRE',  'Trebsen (Mulde)' ],
	[ 'LTRG',  'Trebsen Getreide' ],
	[ 'LSET',  'Trebsen Quartzw' ],
	[ 'XTTRB', 'Trebusice' ],
	[ 'XITCE', 'Trecate' ],
	[ 'FTRE',  'Trechtingshausen' ],
	[ 'XATA',  'Treibach-Althf' ],
	[ 'STK',   'Treis-Karden' ],
	[ 'XVT',   'Trelleborg' ],
	[ 'XVTF',  'Trelleborg F' ],
	[ 'XTTM',  'Tremesna v Sle' ],
	[ 'MTNB',  'Trennbach' ],
	[ 'XITR',  'Trento' ],
	[ 'BVTW',  'Treptow Strw' ],
	[ 'YBBTW', 'Treptower P Strw' ],
	[ 'BTP',   'Treptower Park' ],
	[ 'XITP',  'Trepuzzi' ],
	[ 'MTL',   'Treuchtlingen' ],
	[ 'DTRE',  'Treuen' ],
	[ 'BTZN',  'Treuenbrietzen' ],
	[ 'BTZS',  'Treuenbrietzen S' ],
	[ 'XITS',  'Treviso Centrale' ],
	[ 'FTS',   'Treysa' ],
	[ 'HTRI',  'Triangel' ],
	[ 'RTR',   'Triberg' ],
	[ 'XAT',   'Trieben' ],
	[ 'UTB',   'Triebes' ],
	[ 'NTRI',  'Triefenried' ],
	[ 'STR',   'Trier Hbf' ],
	[ 'STR N', 'Trier Hbf Nord' ],
	[ 'STRS',  'Trier Süd' ],
	[ 'STRW',  'Trier West' ],
	[ 'SEU',   'Trier-Euren' ],
	[ 'NTF',   'Triesdorf' ],
	[ 'XITC',  'Trieste C M' ],
	[ 'XIT',   'Trieste Centrale' ],
	[ 'KKTR',  'Trimbornstr' ],
	[ 'XATK',  'Trimmelkam-Ost.' ],
	[ 'XTTRI', 'Trinec' ],
	[ 'XITBV', 'Trinita-B Vagien' ],
	[ 'XITRV', 'Trino Vercellese' ],
	[ 'UTR',   'Triptis' ],
	[ 'XYT',   'Trnava' ],
	[ 'BTR',   'Tröbitz' ],
	[ 'TTRA',  'Trochtelf Alb-G' ],
	[ 'TTRF',  'Trochtelfgn/Hzl' ],
	[ 'TTO',   'Trochtelfingen' ],
	[ 'XXTF',  'Trofa' ],
	[ 'XITRF', 'Trofarello' ],
	[ 'XOTF',  'Trofors' ],
	[ 'LTZ',   'Tröglitz' ],
	[ 'KT',    'Troisdorf' ],
	[ 'KT N',  'Troisdorf Nord' ],
	[ 'KT V',  'Troisdorf Vorbf' ],
	[ 'KTWE',  'Troisdorf West' ],
	[ 'XLXTV', 'Troisvierg Gr BE' ],
	[ 'XLTV',  'Troisvierges' ],
	[ 'XDTD',  'Trolhede' ],
	[ 'WTRO',  'Trollenhagen' ],
	[ 'XVTH',  'Trollhättan' ],
	[ 'XITML', 'Tromello' ],
	[ 'KTR',   'Trompet' ],
	[ 'UTRO',  'Tromsdorf' ],
	[ 'UQTR',  'Tromsdorf ST/TH' ],
	[ 'XOT',   'Trondheim' ],
	[ 'XITRZ', 'Tronzano' ],
	[ 'XBT',   'Trooz' ],
	[ 'TTR',   'Trossingen Bf' ],
	[ 'TTR H', 'Trossingen HZL' ],
	[ 'TTRS',  'Trossingen Stadt' ],
	[ 'TTRG',  'Trossingn DB/HZL' ],
	[ 'MTSB',  'Trostberg' ],
	[ 'XTTN',  'Trsnice' ],
	[ 'ZATR',  'Trubarevo' ],
	[ 'NTRU',  'Trubbachbrücke' ],
	[ 'XSTR',  'Trübbach' ],
	[ 'ZUTU',  'Truskavec' ],
	[ 'XTTVS', 'Trutnov stred' ],
	[ 'XPTR',  'Trzcianca' ],
	[ 'XPTRZ', 'Trzciniec Zgorz' ],
	[ 'XPTZ',  'Trzebiatow' ],
	[ 'XPTB',  'Trzebinia' ],
	[ 'XPTL',  'Trzemeszno Lubus' ],
	[ 'XATS',  'Tschagguns' ],
	[ 'XCTU',  'Tuapse' ],
	[ 'KTUM',  'Tuchmühle' ],
	[ 'TTD',   'Tübgn-Derendingn' ],
	[ 'TTWG',  'Tübingen DB/ZÖA' ],
	[ 'TT G',  'Tübingen Gbf' ],
	[ 'TT',    'Tübingen Hbf' ],
	[ 'TTW',   'Tübingen West' ],
	[ 'TTLU',  'Tübingen-Lustnau' ],
	[ 'HTFH',  'Tül-Fahrenhorst' ],
	[ 'MTFD',  'Türkenfeld' ],
	[ 'MTHB',  'Türkheim (B) Bf' ],
	[ 'MTHG',  'Türkheim DB-Gr' ],
	[ 'MTHM',  'Türkheim/B Markt' ],
	[ 'STMG',  'Türkism DB/HRB' ],
	[ 'STM',   'Türkismühle' ],
	[ 'XMTK',  'Tüskevar' ],
	[ 'MTLG',  'Tüßling' ],
	[ 'XUTO',  'Tulcea Oras' ],
	[ 'MTUL',  'Tulling' ],
	[ 'XATU',  'Tulln' ],
	[ 'XATD',  'Tullnerfeld' ],
	[ 'XPTU',  'Tuplice' ],
	[ 'XPTUD', 'Tuplice Debinka' ],
	[ 'XSTG',  'Turgi' ],
	[ 'XHTH',  'Turku sat/Abo.ha' ],
	[ 'XHT',   'Turku/Abo' ],
	[ 'XHTP',  'Turku-Pansio' ],
	[ 'ZLT',   'Turmantas' ],
	[ 'XPT',   'Turoszow' ],
	[ 'TTUZ',  'Tut Zentrum' ],
	[ 'MTUG',  'Tutting' ],
	[ 'TTUG',  'Tuttl Gänsäcker' ],
	[ 'TTUS',  'Tuttl Schulen' ],
	[ 'TTU',   'Tuttlingen' ],
	[ 'TTUN',  'Tuttlingen Nord' ],
	[ 'MTZ',   'Tutzing' ],
	[ 'HOLT',  'Tweelbäke' ],
	[ 'FTW',   'Twiste' ],
	[ 'FTWS',  'Twistesee' ],
	[ 'HT',    'Twistringen' ],
	[ 'XPTY',  'Tychy' ],
	[ 'XTTS',  'Tynec n Sazavou' ],
	[ 'XOTY',  'Tynset' ],
	[ 'XCUA',  'Uaz' ],
	[ 'EUBD',  'Ubbedissen' ],
	[ 'RUOM',  'Ubstadt Mülldepo' ],
	[ 'RUO',   'Ubstadt Ort' ],
	[ 'RUOS',  'Ubstadt Salzbr' ],
	[ 'RUOU',  'Ubstadt Uhland' ],
	[ 'RUWA',  'Ubstadt-W Abzw' ],
	[ 'RUW',   'Ubstadt-Weiher' ],
	[ 'LUS',   'Uchtspringe' ],
	[ 'XFUC',  'Uckange' ],
	[ 'XVU',   'Uddevalla C' ],
	[ 'XVUO',  'Uddevalla Östra' ],
	[ 'UUD',   'Uder' ],
	[ 'XIU',   'Udine' ],
	[ 'KUBP',  'Übach-Palenberg' ],
	[ 'RUEM',  'Überlingen' ],
	[ 'RUEB',  'Überlingen Therm' ],
	[ 'MUS',   'Übersee' ],
	[ 'LUEB',  'Uebigau' ],
	[ 'WUEK',  'Ückeritz' ],
	[ 'WUMH',  'Ueckerm Stadthaf' ],
	[ 'WUM',   'Ueckermünde' ],
	[ 'KUD',   'Üdingen' ],
	[ 'KUDF',  'Uedorf' ],
	[ 'EULD',  'Uelde' ],
	[ 'HU',    'Uelzen' ],
	[ 'HU G',  'Uelzen Gbf' ],
	[ 'EUTP',  'Uentrop' ],
	[ 'EUNT',  'Uentrop Süd' ],
	[ 'RUEN',  'Ü-Nußdorf' ],
	[ 'HUNZ',  'Uenzen' ],
	[ 'SUF',   'Uersfeld (Eifel)' ],
	[ 'SUG',   'Ürzig DB' ],
	[ 'XBBLU', 'Üst Block 17' ],
	[ 'SSBA',  'Üst Saarbahn' ],
	[ 'AUTS',  'Uetersen' ],
	[ 'XCUF',  'Ufa' ],
	[ 'HUFN',  'Uffeln' ],
	[ 'NU',    'Uffenheim' ],
	[ 'MUF',   'Uffing a Staffel' ],
	[ 'UUF',   'Uftrungen' ],
	[ 'XDUL',  'Uglev' ],
	[ 'TUH',   'Uhingen' ],
	[ 'TWBU',  'Uhlandplatz' ],
	[ 'RUDM',  'Uhldingen-Mühlh' ],
	[ 'FUR',   'Uhlerborn' ],
	[ 'UUS',   'Uhlstädt' ],
	[ 'BUD',   'Uhsmannsdorf' ],
	[ 'BUS',   'Uhyst' ],
	[ 'XNUI',  'Uitgeest' ],
	[ 'ZUU',   'Ujgorod' ],
	[ 'XMUS',  'Ujszasz' ],
	[ 'XMU',   'Ukk' ],
	[ 'DUD',   'Ulbersdorf' ],
	[ 'XDUF',  'Ulfborg' ],
	[ 'XCUL',  'Uljanovsk-Centr' ],
	[ 'DULR',  'Ullersreuth' ],
	[ 'TUD',   'Ulm Donautal' ],
	[ 'TU',    'Ulm Hbf' ],
	[ 'TQUF',  'Ulm Hbf BW/BY FB' ],
	[ 'TQUR',  'Ulm Hbf BW/BY RB' ],
	[ 'TU N',  'Ulm Hbf Em Nord' ],
	[ 'TU O',  'Ulm Hbf Em Ost' ],
	[ 'TUO',   'Ulm Ost' ],
	[ 'TU R',  'Ulm Rbf' ],
	[ 'TUDT',  'Ulm-Donautal Hp' ],
	[ 'TUDS',  'Ulm-Donautal SWU' ],
	[ 'SUL',   'Ulmen' ],
	[ 'TUOE',  'Ulm-Örlingen' ],
	[ 'TU F',  'Ulm-Söflingen' ],
	[ 'XAU',   'Ulrichsbr-Füssen' ],
	[ 'XDUP',  'Ulstrup' ],
	[ 'AUBS',  'Ulzburg Süd' ],
	[ 'XCU',   'Umet' ],
	[ 'TUF',   'Ummendorf' ],
	[ 'MURB',  'Umrathshausen Bf' ],
	[ 'MURO',  'Umrathshsn Ort' ],
	[ 'RUN',   'Unadingen' ],
	[ 'NUDF',  'Undorf' ],
	[ 'XCUN',  'Unecha' ],
	[ 'NUND',  'Unfriedsdorf' ],
	[ 'FUNG',  'Ungedanken' ],
	[ 'MUGH',  'Ungerhausen' ],
	[ 'HUA',   'Union' ],
	[ 'KUN',   'Unkel' ],
	[ 'TUN',   'Unlingen' ],
	[ 'EUN',   'Unna' ],
	[ 'EUNW',  'Unna West' ],
	[ 'EUK',   'Unna-Königsborn' ],
	[ 'FUKO',  'Unnau-Korb' ],
	[ 'MUAG',  'Unterammergau' ],
	[ 'NUA',   'Unterasbach' ],
	[ 'MUA',   'Unteraschau' ],
	[ 'LUBG',  'Unterberg' ],
	[ 'XAUS',  'Unterberg-Stefbr' ],
	[ 'TUE',   'Unterelchingen' ],
	[ 'MUFH',  'Unterfahlheim' ],
	[ 'MUFG',  'Unterföhring' ],
	[ 'RUG',   'Untergimpern' ],
	[ 'MUGR',  'Untergrainau' ],
	[ 'TUG',   'Untergriesheim' ],
	[ 'RURB',  'Untergrombach' ],
	[ 'TUGN',  'Untergröningen' ],
	[ 'MUH',   'Unterhaching' ],
	[ 'MUHU',  'Unterhaching Üst' ],
	[ 'RUH',   'Unterharmersbach' ],
	[ 'MUHN',  'Unterhausen/Bay' ],
	[ 'NUT',   'Unterheckenhofen' ],
	[ 'TUJM',  'Unterjes Mitte' ],
	[ 'TUJS',  'Unterjes Sandäck' ],
	[ 'TUK',   'Unterkochen' ],
	[ 'DUK',   'Unterkoskau' ],
	[ 'UUTL',  'Unterlemnitz' ],
	[ 'TUL',   'Unterlenningen' ],
	[ 'UUZA',  'Unterloqu Awanst' ],
	[ 'UUZ',   'Unterloquitz Hp' ],
	[ 'HUNL',  'Unterlüß' ],
	[ 'UUM',   'Untermaßfeld' ],
	[ 'KUM',   'Untermaub-Schlag' ],
	[ 'MAUG',  'Untermenzing' ],
	[ 'DUN',   'Unterneudorf' ],
	[ 'FKUNK', 'Unterneust Kirch' ],
	[ 'RUOE',  'Unteröwisheim' ],
	[ 'TURB',  'Unterreichenbach' ],
	[ 'FUTR',  'Unterrieden' ],
	[ 'TUNR',  'Unterrot' ],
	[ 'MUSM',  'Unterschleißheim' ],
	[ 'HUNT',  'Unterstedt' ],
	[ 'NUST',  'Unterstei /Bayr' ],
	[ 'NUS',   'Untersteinach/St' ],
	[ 'SUSZ',  'Untersulzbach' ],
	[ 'XSUT',  'Unterterzen' ],
	[ 'UUW',   'Unterwellenborn' ],
	[ 'KKOU',  'Unterwerk' ],
	[ 'EMUW',  'Unterwerk/Münst' ],
	[ 'DUW',   'Unterwiesenth' ],
	[ 'MUZ',   'Unterzeismering' ],
	[ 'RUOEL', 'Untöwishm L-Str' ],
	[ 'XAUM',  'Unzmarkt' ],
	[ 'AUP',   'Uphusum' ],
	[ 'XYUP',  'Upor' ],
	[ 'ZKU',   'Uralsk' ],
	[ 'TUA',   'Urbach b Schorn' ],
	[ 'XCUB',  'Urbah' ],
	[ 'FURBN', 'Urbar Nord' ],
	[ 'FURBS', 'Urbar Süd' ],
	[ 'EUR',   'Urenco' ],
	[ 'KUFD',  'Urfeld' ],
	[ 'KURF',  'Urft (Steinf)' ],
	[ 'XCUM',  'Urmary' ],
	[ 'SURM',  'Urmersbach' ],
	[ 'KUR',   'Urmitz' ],
	[ 'KURR',  'Urmitz Rheinbr' ],
	[ 'XJUR',  'Urosevac' ],
	[ 'MURS',  'Urschalling' ],
	[ 'TURS',  'Urspring' ],
	[ 'XAUR',  'Urstein' ],
	[ 'SUZD',  'Usch-Zendscheid' ],
	[ 'FUSI',  'Usingen' ],
	[ 'HUS',   'Uslar' ],
	[ 'LKMU',  'Uspw Klostermfd' ],
	[ 'FUS',   'Usseln' ],
	[ 'XOUS',  'Ustaoset' ],
	[ 'XTUS',  'Usti n L-Strekov' ],
	[ 'XTU',   'Usti n.L. hl.n.' ],
	[ 'XTUZ',  'Usti n.L. zapad' ],
	[ 'XTUO',  'Usti nad Orlici' ],
	[ 'XCUK',  'Ust-Katav' ],
	[ 'XCUS',  'Ust-Luga' ],
	[ 'XHU',   'Utajärvi' ],
	[ 'HUTB',  'Utbremen' ],
	[ 'XCUO',  'Utorgosh' ],
	[ 'XNU',   'Utrecht C' ],
	[ 'XNUG',  'Utrecht GE' ],
	[ 'MUHO',  'Uttenhofen' ],
	[ 'FUT',   'Uttershausen' ],
	[ 'MUTG',  'Utting' ],
	[ 'XSUW',  'Uttwil' ],
	[ 'WUTZ',  'Utzedel' ],
	[ 'SUT',   'Utzerath' ],
	[ 'XMV',   'Vac' ],
	[ 'NVA',   'Vach' ],
	[ 'UVA',   'Vachdorf' ],
	[ 'MVAD',  'Vachendorf' ],
	[ 'ZUVS',  'Vadul-Siret' ],
	[ 'XVVY',  'Vaggeryd' ],
	[ 'LVA',   'Vahldorf' ],
	[ 'HVAH',  'Vahr' ],
	[ 'TV',    'Vaihingen (Enz)' ],
	[ 'TVS',   'Vaihingen Stadt' ],
	[ 'XFVAR', 'Vaires' ],
	[ 'XFVSM', 'Vaires sur Marne' ],
	[ 'XNVC',  'Valburg CUP' ],
	[ 'XNVO',  'Valburg oost B r' ],
	[ 'XNVW',  'Valburg west B r' ],
	[ 'XDVAL', 'Valby' ],
	[ 'XIVO',  'Valdaora-Anters' ],
	[ 'XTVA',  'Valdek' ],
	[ 'XFVDR', 'Val-de-Reuil' ],
	[ 'XFVC',  'Valence' ],
	[ 'XFVCV', 'Valence-TGV' ],
	[ 'XFVA',  'Valenciennes' ],
	[ 'XFVL',  'Valenton' ],
	[ 'XIVZ',  'Valenza' ],
	[ 'XNVB',  'Valkenburg (NL)' ],
	[ 'XIVLL', 'Valle Lomellina' ],
	[ 'KVA',   'Vallendar' ],
	[ 'XIVLM', 'Valmadonna' ],
	[ 'XTVM',  'Valy u Mar Lazni' ],
	[ 'XDVA',  'Vamdrup' ],
	[ 'XAVA',  'Vandans' ],
	[ 'XVVB',  'Vänersborg C' ],
	[ 'XIVAP', 'Vanzago-Pogliano' ],
	[ 'ZUVP',  'Vapnjarka' ],
	[ 'XVV',   'Vara' ],
	[ 'XFVN',  'Varangeville' ],
	[ 'XRVA',  'Varazdin' ],
	[ 'XIVR',  'Varazze' ],
	[ 'XVVA',  'Varberg' ],
	[ 'XMVD',  'Varda' ],
	[ 'XDVR',  'Varde' ],
	[ 'XDVRK', 'Varde Kaserne' ],
	[ 'XDVRN', 'Varde Nord' ],
	[ 'XDVRW', 'Varde Vest' ],
	[ 'HVA',   'Varel (Oldb)' ],
	[ 'ZLVA',  'Varena' ],
	[ 'EVRS',  'Varensell' ],
	[ 'XIVRS', 'Varese' ],
	[ 'XVVG',  'Vargada' ],
	[ 'XVVN',  'Vargön' ],
	[ 'XYVA',  'Varin' ],
	[ 'XONDV', 'Varingskollen' ],
	[ 'XWV',   'Varna' ],
	[ 'XVVR',  'Värnamo' ],
	[ 'XOSJV', 'Varnes' ],
	[ 'XTSVD', 'Varns stare' ],
	[ 'XTVD',  'Varnsdorf' ],
	[ 'XTVK',  'Varnsdorf piv Ko' ],
	[ 'XMVR',  'Varoslöd' ],
	[ 'XMVK',  'Varoslöd-Kislöd' ],
	[ 'XMVT',  'Varpalota' ],
	[ 'HVAB',  'Varrelbusch' ],
	[ 'XVSV',  'Vartan' ],
	[ 'XUVS',  'Vaslui' ],
	[ 'XVVK',  'Västervik' ],
	[ 'XIVA',  'Vasto S Salvo' ],
	[ 'AVF',   'Vastorf' ],
	[ 'MVS',   'Vaterstetten' ],
	[ 'XUVD',  'Vatra Dornei' ],
	[ 'LVT',   'Vatterode' ],
	[ 'LVTT',  'Vatteröder Teich' ],
	[ 'XVVX',  'Växjö' ],
	[ 'XTVC',  'Vcelnicka' ],
	[ 'EVEB',  'VEBA /Bottrop' ],
	[ 'HVEC',  'Vechelde' ],
	[ 'HVCH',  'Vechta' ],
	[ 'HVCS',  'Vechta-Stoppelm' ],
	[ 'AVL',   'Veddel' ],
	[ 'AVLS',  'Veddel (S-Bahn)' ],
	[ 'AVLG',  'Veddel DB-Gr' ],
	[ 'XVVD',  'Veddige' ],
	[ 'XVVM',  'Vedum' ],
	[ 'XNVE',  'Veendam' ],
	[ 'XNVK',  'Veenendaal K' ],
	[ 'HVR',   'Veerßen' ],
	[ 'XOVH',  'Vegarshei' ],
	[ 'KSTV',  'Vegla' ],
	[ 'BVLZ',  'Vehlefanz' ],
	[ 'HVEH',  'Vehrte' ],
	[ 'UVF',   'Veilsdorf' ],
	[ 'NVE',   'Veitshöchheim' ],
	[ 'XDVK',  'Vejbaek' ],
	[ 'XDVJ',  'Vejle' ],
	[ 'XTVY',  'Vejprty' ],
	[ 'NVN',   'Velden (Hersbr)' ],
	[ 'XAVE',  'Velden a.W.' ],
	[ 'NVDO',  'Velden Dolomit' ],
	[ 'HVDH',  'Veldhausen' ],
	[ 'WV',    'Velgast' ],
	[ 'WVEG',  'Velgast DB-Gr' ],
	[ 'XTVEL', 'Velim' ],
	[ 'XTVSV', 'Velk Svatonovice' ],
	[ 'XTVH',  'Velke Hamry' ],
	[ 'XTVHM', 'Velke Hamry mest' ],
	[ 'XTVZ',  'Velke Zernoseky' ],
	[ 'XTVV',  'Velky Senov' ],
	[ 'XTVVZ', 'Velky Senov zast' ],
	[ 'EVE',   'Vellinghsn' ],
	[ 'HVEP',  'Velpe (Westf)' ],
	[ 'BVLT',  'Velten (Mark)' ],
	[ 'HVTH',  'Veltheim' ],
	[ 'HQVT',  'Veltheim NRW/NI' ],
	[ 'XDVE',  'Vemb' ],
	[ 'XFVH',  'Vendenheim' ],
	[ 'XIVNM', 'Venezia Mestre' ],
	[ 'XIVNS', 'Venezia S.Lucia' ],
	[ 'XIVN',  'Venezia Sc Margh' ],
	[ 'XFVE',  'Venissieux' ],
	[ 'XNVL',  'Venlo' ],
	[ 'XNVLO', 'Venlo Ostkopf' ],
	[ 'HVBK',  'Vennebeck' ],
	[ 'XOVN',  'Vennesla' ],
	[ 'XIVT',  'Ventimiglia' ],
	[ 'WVE',   'Ventschow' ],
	[ 'XMVP',  'Vep' ],
	[ 'ZUVE',  'Verba' ],
	[ 'XIVEP', 'Verbania-Pall' ],
	[ 'XIVE',  'Vercelli' ],
	[ 'XZV',   'Verd' ],
	[ 'XOVD',  'Verdal' ],
	[ 'XIVDO', 'Verdello Dalmine' ],
	[ 'HVEA',  'Verden (A) Süd' ],
	[ 'HV',    'Verden (Aller)' ],
	[ 'XUVR',  'Veresti' ],
	[ 'XIVGE', 'Vergiate' ],
	[ 'ZUVC',  'Verhovcevo' ],
	[ 'TVRD',  'Veringendorf' ],
	[ 'TVRS',  'Veringenstadt' ],
	[ 'EVR',   'Verl/Bz Detmold' ],
	[ 'XIVNN', 'Vernante' ],
	[ 'HQVW',  'Vernawahlhsn LGr' ],
	[ 'HVWH',  'Vernawahlshausen' ],
	[ 'XFVEA', 'Verneuil-sur-Avr' ],
	[ 'XFVEE', 'Vernieul l\'Etang' ],
	[ 'XFVNO', 'Vernon' ],
	[ 'KVER',  'Vernum' ],
	[ 'XMVC',  'Veroce' ],
	[ 'XIVLO', 'Verolengo' ],
	[ 'XIVD',  'Verona CD' ],
	[ 'XIVPV', 'Verona P.V.' ],
	[ 'XIVPA', 'Verona Parona' ],
	[ 'XIVP',  'Verona PN' ],
	[ 'XIVQ',  'Verona Quadr Eur' ],
	[ 'EVRM',  'Versmold' ],
	[ 'XCVE',  'Vertunovskaia' ],
	[ 'XBVC',  'Verviers-Central' ],
	[ 'XBVP',  'Verviers-Palais' ],
	[ 'XIVU',  'Verzuolo' ],
	[ 'XTVE',  'Vesec u Liberce' ],
	[ 'XTVER', 'Vesele Rabstejn' ],
	[ 'UVE',   'Veßra' ],
	[ 'XOVY',  'Vestby' ],
	[ 'XMVM',  'Veszprem' ],
	[ 'XVVL',  'Vetlanda' ],
	[ 'XWVT',  'Vetovo' ],
	[ 'BV',    'Vetschau' ],
	[ 'EVWU',  'VEW /Unna' ],
	[ 'EVWG',  'VEW /Gronau' ],
	[ 'EVWE',  'VEW /Berghsn' ],
	[ 'EVWT',  'VEW /Dortmund' ],
	[ 'EVWM',  'VEW /Münster/W' ],
	[ 'EVWW',  'VEW /Winterberg' ],
	[ 'XIVI',  'Viareggio' ],
	[ 'XCV',   'Viazma' ],
	[ 'XDVG',  'Viborg' ],
	[ 'XDVI',  'Viby Jylland' ],
	[ 'XDVSJ', 'Viby Sjaelland' ],
	[ 'XIVC',  'Vicenza' ],
	[ 'XIVFM', 'Vicoforte-S M' ],
	[ 'XUV',   'Videle' ],
	[ 'XDVS',  'Vidstrup' ],
	[ 'NVIC',  'Viechtach' ],
	[ 'KVH',   'Vie-Helenabrunn' ],
	[ 'HVBG',  'Vienenburg' ],
	[ 'XFVI',  'Vienne' ],
	[ 'DVR',   'Vierenstraße' ],
	[ 'MESH',  'Vierk-Esterhf' ],
	[ 'FVI',   'Viermünden' ],
	[ 'UVU',   'Viernau' ],
	[ 'RVIN',  'Viernh.Oberrh.E.' ],
	[ 'RVI',   'Viernheim' ],
	[ 'WVIA',  'Vierow Anst' ],
	[ 'KV',    'Viersen' ],
	[ 'KV G',  'Viersen Gbf' ],
	[ 'UVIU',  'Vieselb Umspannw' ],
	[ 'UVI',   'Vieselbach' ],
	[ 'FAVI',  'Viessmann 2' ],
	[ 'XFVVA', 'Vievola' ],
	[ 'XIVGA', 'Vigliano d\'Asti' ],
	[ 'XIVIG', 'Vignale' ],
	[ 'XEVG',  'Vigo-Guixar' ],
	[ 'XOVS',  'Vikersund' ],
	[ 'XOVM',  'Vikhammer' ],
	[ 'XVVS',  'Vikingstad' ],
	[ 'XAVI',  'Viktring' ],
	[ 'XXVF',  'Vilar Formoso' ],
	[ 'XTVL',  'Vilemov Sluknova' ],
	[ 'XIVL',  'Villa Literno' ],
	[ 'XIVOP', 'Villa Opicina' ],
	[ 'XIVG',  'Villa S.Giovanni' ],
	[ 'XIVB',  'Villab./Niederdf' ],
	[ 'XAVH',  'Villach Hbf' ],
	[ 'XAVHG', 'Villach Hbf Ost' ],
	[ 'XAVHO', 'Villach Hbf Verl' ],
	[ 'XAVS',  'Villach Süd' ],
	[ 'XAVW',  'Villach Westbf' ],
	[ 'XIVLD', 'Villadossola' ],
	[ 'XIVFC', 'Villafranca-Can' ],
	[ 'XIVV',  'Villalvernia' ],
	[ 'XIVLA', 'Villanova d\'Ard' ],
	[ 'XIVNA', 'Villanova d\'Asti' ],
	[ 'XMVL',  'Villany' ],
	[ 'XEVB',  'Villarrobledo' ],
	[ 'XFVD',  'Villars l Dombes' ],
	[ 'XIVST', 'Villastellone' ],
	[ 'XIVM',  'Villaverla-M' ],
	[ 'XFVDS', 'Villedieu-les-Po' ],
	[ 'XFVIS', 'Villeneuve St G' ],
	[ 'XFVR',  'Villers-Cotter' ],
	[ 'XFVG',  'Villiers Bel Gon' ],
	[ 'RVL',   'Villingen(Schww)' ],
	[ 'FVR',   'Villmar' ],
	[ 'ZLV',   'Vilnius' ],
	[ 'XAV',   'Vils' ],
	[ 'MVSB',  'Vilsbiburg' ],
	[ 'NVK',   'Vilseck' ],
	[ 'NFRS',  'Vilseck Freihun' ],
	[ 'NVKL',  'Vilseck Lager' ],
	[ 'NVIB',  'Vilshofen Berger' ],
	[ 'NVI',   'Vilshofen(Nbay)' ],
	[ 'XBVV',  'Vilvoorde' ],
	[ 'XVVE',  'Vimmerby' ],
	[ 'XDVP',  'Vinderup' ],
	[ 'XVVI',  'Vingaker' ],
	[ 'KVI',   'Vingst' ],
	[ 'XRVI',  'Vinkovci' ],
	[ 'ZUVI',  'Vinnica' ],
	[ 'XOVI',  'Vinstra' ],
	[ 'LVG',   'Vinzelberg' ],
	[ 'XIVS',  'Vipit./Sterzing' ],
	[ 'XDVY',  'Visby' ],
	[ 'XBV',   'Vise' ],
	[ 'XVVF',  'Viskafors' ],
	[ 'XIVIS', 'Visone' ],
	[ 'XSVI',  'Visp' ],
	[ 'HVIS',  'Visselhövede' ],
	[ 'ZWV',   'Vitebsk' ],
	[ 'XFVV',  'Vitry-La-Ville' ],
	[ 'XFVF',  'Vitry-L-Francois' ],
	[ 'XFVT',  'Vittel' ],
	[ 'XIVIA', 'Vittuone Arluno' ],
	[ 'UVZ',   'Vitzenburg' ],
	[ 'UVZG',  'Vitzenburg DB-Gr' ],
	[ 'XIVZL', 'Vizzini-Licodia' ],
	[ 'XCVL',  'Vladimir Pass' ],
	[ 'XTVKZ', 'Vlecka Arko' ],
	[ 'XTVS',  'Vlecka Sucha' ],
	[ 'XNVT',  'Vleuten' ],
	[ 'XNVI',  'Vlissingen' ],
	[ 'XNVIS', 'Vlissingen Sloeh' ],
	[ 'XNVP',  'Vlodrop' ],
	[ 'HVLO',  'Vlotho' ],
	[ 'KVLY',  'Vluyn' ],
	[ 'FNV',   'V-Niedervellmar' ],
	[ 'FOV',   'V-Obervellmar' ],
	[ 'XAVB',  'Vöcklabruck' ],
	[ 'XAVM',  'Vöcklamarkt' ],
	[ 'XFVO',  'Voellerdingen' ],
	[ 'EVD',   'Voerde' ],
	[ 'EVDU',  'Voerde Üst' ],
	[ 'KVOG',  'Vogelsang' ],
	[ 'WVOG',  'Vogelsang' ],
	[ 'SVO',   'Vogelweh' ],
	[ 'XIVOG', 'Voghera' ],
	[ 'XIVOO', 'Vogogna Ossola' ],
	[ 'MVRW',  'Vohbg Bayernoil' ],
	[ 'MVG',   'Vohburg' ],
	[ 'THCV',  'Vohenstein' ],
	[ 'EVOH',  'Vohren' ],
	[ 'MVRN',  'Vöhringen' ],
	[ 'HVOE',  'Vöhrum' ],
	[ 'DVO',   'Voigtsgrün' ],
	[ 'UVO',   'Voigtstedt' ],
	[ 'ZUVT',  'Voitovcy' ],
	[ 'XDV',   'Vojens' ],
	[ 'XTV',   'Vojtanov' ],
	[ 'DXBF',  'Vojtanov Gr' ],
	[ 'DXBE',  'Vojtanov Gr 2' ],
	[ 'HVOL',  'Voldagsen' ],
	[ 'XAVO',  'Volders-Baumk' ],
	[ 'KKV',   'Volkhovener Weg' ],
	[ 'SVLW',  'Völkl Walzw Abzw' ],
	[ 'SVWG',  'Völklin DB/Walzw' ],
	[ 'SVL',   'Völklingen' ],
	[ 'SVW',   'Völklingen Walzw' ],
	[ 'FVA',   'Volkmarsen' ],
	[ 'EVOK',  'Volkringhsn' ],
	[ 'HELV',  'Völksen/Eldagsen' ],
	[ 'WVR',   'Vollrathsruhe' ],
	[ 'XLVM',  'Volmerange-l-Min' ],
	[ 'ZUVO',  'Volochisk' ],
	[ 'ZUVV',  'Volovec' ],
	[ 'HVOP',  'Volpriehausen' ],
	[ 'XAVL',  'Völs' ],
	[ 'XMVY',  'Vonyarcvashegy' ],
	[ 'XDVB',  'Vordingborg' ],
	[ 'HVHP',  'Vorhop' ],
	[ 'HVMP',  'Vormeppen' ],
	[ 'EVRD',  'Vormwald' ],
	[ 'EVRO',  'Vormwald Dorf' ],
	[ 'ZUVR',  'Vorohta' ],
	[ 'XCVO',  'Voronej' ],
	[ 'XBVX',  'Voroux' ],
	[ 'NV',    'Vorra (Pegnitz)' ],
	[ 'HVOR',  'Vorsfelde' ],
	[ 'HVWR',  'Vorwalsrode' ],
	[ 'HVOW',  'Vorwohle' ],
	[ 'XOV',   'Voss' ],
	[ 'AVSL',  'Voßloch' ],
	[ 'HVPG',  'VPS DB-Gr' ],
	[ 'XWVA',  'Vraca' ],
	[ 'XJVR',  'Vranje' ],
	[ 'XTVR',  'Vratimov' ],
	[ 'XTVN',  'Vratis nad Nisou' ],
	[ 'XRVB',  'Vrbovec' ],
	[ 'XRVK',  'Vrbovsko' ],
	[ 'XDVM',  'Vroegum' ],
	[ 'XJVS',  'Vrsac' ],
	[ 'XYVU',  'Vrutky' ],
	[ 'RVLE',  'V-S Eisstadion' ],
	[ 'RVLH',  'V-S Hammerstatt' ],
	[ 'XTVB',  'Vsebor' ],
	[ 'XTVT',  'Vsetaty' ],
	[ 'RVLZ',  'V-S-Zollhaus' ],
	[ 'XCVU',  'Vurnary' ],
	[ 'DBAR',  'VW-Mot. Chemnitz' ],
	[ 'XCVY',  'Vyrica' ],
	[ 'XTVP',  'Vysoka Pec' ],
	[ 'HWRG',  'W Böhme DB-Gr' ],
	[ 'KWR',   'W Rauenthal' ],
	[ 'KWZ',   'W Zool Garten' ],
	[ 'EWFR',  'Wa Unser Fritz' ],
	[ 'FWAB',  'Wabern (Bz Ksl)' ],
	[ 'HWAD',  'Wachendorf' ],
	[ 'RWCH',  'Wachenh.(Pfalz)' ],
	[ 'NWAR',  'Wachenroth' ],
	[ 'MWAE',  'Wächterhof' ],
	[ 'FWAE',  'Wächtersbach' ],
	[ 'NWDN',  'Wackersdorf Nord' ],
	[ 'NWDF',  'Wackersdorf/Opf' ],
	[ 'TWHF',  'Wackershofen' ],
	[ 'MWCK',  'Wackerwerk' ],
	[ 'XSWW',  'Wädenswil' ],
	[ 'EWDL',  'Wadersloh' ],
	[ 'NWAF',  'Waffenbrunn' ],
	[ 'AWAF',  'Waffensen' ],
	[ 'AWAG',  'Waffensen DB-Gr' ],
	[ 'AWGR',  'Wagersrott' ],
	[ 'RWG',   'Waghäusel' ],
	[ 'MWGN',  'Waging' ],
	[ 'EWAL',  'Wahlbach/Siegen' ],
	[ 'FWHM',  'Wahlhm(Kr Alzey)' ],
	[ 'LWH',   'Wahlitz' ],
	[ 'LWAE',  'Wählitz Werkbf' ],
	[ 'AWAH',  'Wahlstedt' ],
	[ 'RWW',   'Wahlwies' ],
	[ 'HWAB',  'Wahnebergen' ],
	[ 'EWHP',  'Wa-Höntrop' ],
	[ 'BWK',   'Wahrenbrück' ],
	[ 'LLW V', 'Wahrener Viadukt' ],
	[ 'HWAZ',  'Wahrenholz' ],
	[ 'TWN',   'Waiblingen' ],
	[ 'RWB',   'Waibstadt' ],
	[ 'BWAI',  'Waidmannslust' ],
	[ 'NWA',   'Waigolshausen' ],
	[ 'AWK',   'Wakendorf' ],
	[ 'LWAB',  'Walbeck' ],
	[ 'KWBB',  'Walberberg' ],
	[ 'XPWLF', 'Walbrzych Fabryc' ],
	[ 'XPWL',  'Walbrzych Gl' ],
	[ 'XAWLD', 'Wald am Arlberg' ],
	[ 'XAWA',  'Wald Schoberpaß' ],
	[ 'RETZ',  'Waldbr-Etzenrot' ],
	[ 'BWA',   'Walddrehna' ],
	[ 'TWG',   'Waldenburg (Wü)' ],
	[ 'NWDH',  'Waldershof' ],
	[ 'SWAB',  'Waldfischbach' ],
	[ 'HWHN',  'Waldhausen' ],
	[ 'TWHS',  'Waldhausen/Geisl' ],
	[ 'DWA',   'Waldheim' ],
	[ 'HWAM',  'Waldheim' ],
	[ 'HWHF',  'Waldhöfe' ],
	[ 'TWY',   'Waldhsn b Schorn' ],
	[ 'NWKN',  'Waldkir (Nbay)' ],
	[ 'RWA',   'Waldkirch' ],
	[ 'DWK',   'Waldkirchen (E)' ],
	[ 'MWKG',  'Waldkraibg-Kraib' ],
	[ 'NWLM',  'Waldmünchen' ],
	[ 'KWAD',  'Waldorf' ],
	[ 'RWU',   'Waldshut' ],
	[ 'RXWA',  'Waldshut Grenze' ],
	[ 'RWU S', 'Waldshut SBB' ],
	[ 'XSWA',  'Walenstadt' ],
	[ 'XLWF',  'Walferdange' ],
	[ 'SWL',   'Walhausen (Saar)' ],
	[ 'KWAH',  'Walheim (Aachen)' ],
	[ 'TWH',   'Walheim (Württ)' ],
	[ 'KXW',   'Walheim Grenze' ],
	[ 'HWKD',  'Walkenried' ],
	[ 'FWAA',  'Wallau (L) Anst' ],
	[ 'FWA',   'Wallau (Lahn)' ],
	[ 'FWF',   'Walldorf (Hess)' ],
	[ 'UWD',   'Walldorf (Werra)' ],
	[ 'RWDN',  'Walldürn' ],
	[ 'HWAL',  'Walle/Verden' ],
	[ 'NWFS',  'Wallenfels' ],
	[ 'FWAD',  'Wallenrod' ],
	[ 'NWLD',  'Wallersdorf' ],
	[ 'FWAH',  'Wallertheim' ],
	[ 'MWHN',  'Walleshausen' ],
	[ 'UWAL',  'Wallhausen (Hel)' ],
	[ 'TWAL',  'Wallhausen/Württ' ],
	[ 'XSWS',  'Wallisellen' ],
	[ 'FWMD',  'Wallmerod/Westw' ],
	[ 'LWWZ',  'Wallwitz(Saalkr)' ],
	[ 'XPWA',  'Walowice' ],
	[ 'MWKN',  'Walpertskirchen' ],
	[ 'KWAP',  'Walporzheim' ],
	[ 'UWL',   'Walschleben' ],
	[ 'WWL',   'Walsleben' ],
	[ 'HWSR',  'Walsrode' ],
	[ 'HWSG',  'Walsrode DB-Gr' ],
	[ 'HWRO',  'Walsrode Nord' ],
	[ 'EWLS',  'Walsum' ],
	[ 'UWN',   'Waltershausen' ],
	[ 'UWNS',  'Waltersh-Schnepf' ],
	[ 'DWF',   'Walthersdorf (E)' ],
	[ 'EWAZ',  'Walzwerk' ],
	[ 'UWA',   'Wandersleben' ],
	[ 'BWAZ',  'Wandlitz' ],
	[ 'BWAS',  'Wandlitzsee' ],
	[ 'AWCH',  'Wandsb Chaussee' ],
	[ 'UWG',   'Wangen' ],
	[ 'TWW',   'Wangen (Allgäu)' ],
	[ 'TQWW',  'Wangen(Allg)LGr' ],
	[ 'HSA',   'Wangeroog Saline' ],
	[ 'HWG',   'Wangerooge' ],
	[ 'HWA',   'Wangerooge W-anl' ],
	[ 'HWN',   'Wangerooge West' ],
	[ 'EWAB',  'Wanne Brennerstr' ],
	[ 'EWAH',  'Wanne Herzogstr' ],
	[ 'EWAD',  'Wanne Osthafen' ],
	[ 'EWAW',  'Wanne Westhafen' ],
	[ 'EWANB', 'Wanne-E Bro' ],
	[ 'EWAN',  'Wanne-E Hbf' ],
	[ 'EWANW', 'Wanne-E Westberg' ],
	[ 'EWANF', 'Wanne-E Wof' ],
	[ 'EWANT', 'Wanne-E Wst' ],
	[ 'XFWH',  'Wannehain' ],
	[ 'TWAN',  'Wannweil' ],
	[ 'LWAN',  'Wansleben am See' ],
	[ 'HWAR',  'Warburg (Westf)' ],
	[ 'HQWA',  'Warburg (Wf)2550' ],
	[ 'HWBM',  'Wardböhmen' ],
	[ 'WWR',   'Waren (Müritz)' ],
	[ 'WWRG',  'Waren DB-Gr' ],
	[ 'EWAF',  'Warendorf' ],
	[ 'EWEM',  'Warendorf E-Müss' ],
	[ 'WWAH',  'Warenshof' ],
	[ 'WWAA',  'Warenshof Anst' ],
	[ 'DWAB',  'Warmbad' ],
	[ 'XAWV',  'Warmbad Villach' ],
	[ 'NWST',  'Warmensteinach' ],
	[ 'WWM',   'Warnemünde' ],
	[ 'WWMW',  'Warnemünde Werft' ],
	[ 'MWGU',  'Warngau' ],
	[ 'WWAN',  'Warnitz (Uckerm)' ],
	[ 'WWRN',  'Warnow (Meckl)' ],
	[ 'WWBW',  'Warnowbr W' ],
	[ 'WWBO',  'Warnowbrücke O' ],
	[ 'BWRS',  'Warschauer Str' ],
	[ 'EWRS',  'Warstein' ],
	[ 'XPWC',  'Warszawa C' ],
	[ 'XPWG',  'Warszawa Gdanska' ],
	[ 'XPWP',  'Warszawa Praga' ],
	[ 'XPWW',  'Warszawa Wschod.' ],
	[ 'XPWZ',  'Warszawa Zachod' ],
	[ 'XAWBK', 'Wartberg a d Kr' ],
	[ 'XAWB',  'Wartberg i.Mürz.' ],
	[ 'BWAB',  'Wartenberg' ],
	[ 'UWAR',  'Wartha (Werra)' ],
	[ 'UQWA',  'Wartha(Werra)LGr' ],
	[ 'TWVH',  'Warthausen Hp' ],
	[ 'AWA',   'Wasbek' ],
	[ 'FWWN',  'Wäschbach Nord' ],
	[ 'FWWS',  'Wäschbach Süd' ],
	[ 'RWR',   'Wasenweiler' ],
	[ 'TWA',   'Wasseralfingen' ],
	[ 'MWBG',  'Wasserbg/Bodens' ],
	[ 'MWSB',  'Wasserbg/Inn Bf' ],
	[ 'XLW',   'Wasserbillig' ],
	[ 'MWSG',  'Wasserburg/Günz' ],
	[ 'SWAS',  'Wasserliesch' ],
	[ 'UWTL',  'Wasserthaleben' ],
	[ 'MWTD',  'Wassertrüdingen' ],
	[ 'MWAS',  'Wasserzell/Eich' ],
	[ 'BWAF',  'Waßmannsdorf' ],
	[ 'UWS',   'Wasungen' ],
	[ 'XBWA',  'Waterloo' ],
	[ 'XBWM',  'Watermael' ],
	[ 'EWAT',  'Wattenscheid' ],
	[ 'EWAU',  'Wattenscheid Üst' ],
	[ 'NWAS',  'Watzelsteg' ],
	[ 'FWST',  'Watzenb-Steinbg' ],
	[ 'KWBA',  'W-Barmen' ],
	[ 'LWBU',  'Webau' ],
	[ 'XLWK',  'Wecker' ],
	[ 'FWCK',  'Weckesheim' ],
	[ 'HWEA',  'Weddel Abzw' ],
	[ 'HWED',  'Weddel/Braunschw' ],
	[ 'HBHW',  'Weddewarden' ],
	[ 'HBHWT', 'Weddewarder Tief' ],
	[ 'BWED',  'Wedding S-B' ],
	[ 'AWL',   'Wedel (Holst)' ],
	[ 'HWEE',  'Weener' ],
	[ 'HXWE',  'Weener Grenze' ],
	[ 'XNWT',  'Weert' ],
	[ 'AWRZ',  'Weertzen' ],
	[ 'XSWN',  'Weesen' ],
	[ 'DWSN',  'Weesenstein' ],
	[ 'XNWS',  'Weesp' ],
	[ 'HWEZ',  'Weetzen' ],
	[ 'KWEE',  'Weeze' ],
	[ 'LWF',   'Wefensleben' ],
	[ 'LWEF',  'Weferlingen' ],
	[ 'LWEZ',  'Weferln Zuckerf' ],
	[ 'FWGA',  'Wega' ],
	[ 'KWEG',  'Wegberg' ],
	[ 'LWEG',  'Wegeleben' ],
	[ 'LWST',  'Wegenstedt' ],
	[ 'XPWE',  'Wegliniec' ],
	[ 'AWHD',  'Wehdel' ],
	[ 'SWE',   'Wehr (Mosel)' ],
	[ 'RBN',   'Wehr-Brennet' ],
	[ 'HQWE',  'Wehrden 2975' ],
	[ 'HWEH',  'Wehrden(Weser)' ],
	[ 'HWRD',  'Wehrendorf' ],
	[ 'FWEH',  'Wehrheim' ],
	[ 'MWBH',  'Weibhausen' ],
	[ 'MWEI',  'Weichering' ],
	[ 'MAWB',  'Weichselbaum' ],
	[ 'EWANY', 'W-Eickel Bro/Sot' ],
	[ 'DWEI',  'Weickersdorf' ],
	[ 'NWGR',  'Weickersgrüben' ],
	[ 'UWE',   'Weida' ],
	[ 'UWEA',  'Weida Altstadt' ],
	[ 'UWEM',  'Weida Mitte' ],
	[ 'NWDO',  'Weiden (Oberpf)' ],
	[ 'NWDW',  'Weiden West' ],
	[ 'NGOL',  'Weiden(Oberpf)G' ],
	[ 'NWBM',  'Weiden(Opf)B-M' ],
	[ 'ESWV',  'Weidenau Vorbf' ],
	[ 'ESWH',  'Weidenau-Herrenw' ],
	[ 'MWDB',  'Weidenbach' ],
	[ 'NWBE',  'Weidenberg' ],
	[ 'NWBG',  'Weidenbg Weidenb' ],
	[ 'RWD',   'Weidenthal' ],
	[ 'MWDG',  'Weiderting' ],
	[ 'NWDG',  'Weiding' ],
	[ 'NWHR',  'Weiherhammer' ],
	[ 'NWHF',  'Weiherhof' ],
	[ 'TWM',   'Weikersheim' ],
	[ 'TLC',   'Weik-Laudenbach' ],
	[ 'TWEI',  'Weil (Schönbuch)' ],
	[ 'RW',    'Weil am Rhein' ],
	[ 'TW',    'Weil der Stadt' ],
	[ 'RWGA',  'Weil Gartenstadt' ],
	[ 'RWEI',  'Weil Ost' ],
	[ 'RWPF',  'Weil Pfädlistr' ],
	[ 'TWEIT', 'Weil Troppel' ],
	[ 'TWEIU', 'Weil Unt Halde' ],
	[ 'RQW',   'Weil(Rhein)LGr' ],
	[ 'MWLB',  'Weilbach' ],
	[ 'NWE',   'Weilbach (Ufr)' ],
	[ 'FWG',   'Weilburg' ],
	[ 'TWEL',  'Weiler (Rems)' ],
	[ 'KWLB',  'Weiler B E' ],
	[ 'KWES',  'Weilerswist' ],
	[ 'TWLH',  'Weilheim' ],
	[ 'MWH',   'Weilheim/Obb' ],
	[ 'UWM',   'Weimar' ],
	[ 'UWMB',  'Weimar Berka Bf' ],
	[ 'UWM F', 'Weimar W1' ],
	[ 'UWMT',  'Weimar West' ],
	[ 'DWE',   'Weinböhla' ],
	[ 'DWEW',  'Weinböhla Hp' ],
	[ 'XSW',   'Weinfelden' ],
	[ 'RWGT',  'Weingarten (Ba)' ],
	[ 'TWEB',  'Weingarten/Berg' ],
	[ 'RWEN',  'Weinh.Oberrh.Ei.' ],
	[ 'RQWE',  'Weinheim BW/HE' ],
	[ 'RWE',   'Weinheim(Bergst)' ],
	[ 'TWR',   'Weinsberg' ],
	[ 'TWRW',  'Weinsberg West' ],
	[ 'DWS',   'Weischlitz' ],
	[ 'WWSN',  'Weisen' ],
	[ 'RWSB',  'Weisenbach' ],
	[ 'RWSS',  'Weisenheim(Sand)' ],
	[ 'TWSS',  'Weissach' ],
	[ 'LWG',   'Weißandt-Gölzau' ],
	[ 'TWSN',  'Weißenau' ],
	[ 'KWEB',  'Weißenberg' ],
	[ 'NWG',   'Weißenburg (Bay)' ],
	[ 'UW',    'Weißenfels' ],
	[ 'UWWE',  'Weißenfels West' ],
	[ 'MWSH',  'Weißenhorn' ],
	[ 'NWEO',  'Weißenohe' ],
	[ 'UWSE',  'Weißensee (Thür)' ],
	[ 'TPW',   'Weißenstein' ],
	[ 'KWEH',  'Weißenthurm' ],
	[ 'HWF',   'Weißer Floh' ],
	[ 'DWIG',  'Weißig (b Groß)' ],
	[ 'BWKL',  'Weißkeißel' ],
	[ 'BWKM',  'Weißkollm' ],
	[ 'BWKO',  'Weißkollm Awanst' ],
	[ 'BWW',   'Weißwasser (OL)' ],
	[ 'XSWEI', 'Weite' ],
	[ 'EWTF',  'Weitefeld' ],
	[ 'FWI',   'Weiterstadt' ],
	[ 'DWX',   'Weixdorf' ],
	[ 'DWXB',  'Weixdorf Bad' ],
	[ 'RWZ',   'Weizen' ],
	[ 'MWZH',  'Weizern-Hopferau' ],
	[ 'XPWEJ', 'Wejherowo' ],
	[ 'FWZ',   'Welgesh-Zotzenh' ],
	[ 'XBW',   'Welkenraedt' ],
	[ 'FWES',  'Welkers' ],
	[ 'LWL',   'Wellen' ],
	[ 'SWN',   'Wellen (Mosel)' ],
	[ 'HWLL',  'Wellendorf/Osnbr' ],
	[ 'AWBS',  'Wellingsbüttel' ],
	[ 'BWZ',   'Wellmitz' ],
	[ 'XAWE',  'Wels Hbf' ],
	[ 'XAWEF', 'Wels Hbf Fg' ],
	[ 'XAWEV', 'Wels Vbf' ],
	[ 'XAWET', 'Wels Vbf CCT' ],
	[ 'EWSE',  'Welschen-Ennest' ],
	[ 'RWEL',  'Welschingen-Neuh' ],
	[ 'EWVE',  'Welver' ],
	[ 'EWVA',  'Welver Awanst' ],
	[ 'TWZ',   'Welzheim' ],
	[ 'XKWY',  'Wembley' ],
	[ 'SWR K', 'Wemmetsw Kurve' ],
	[ 'SWRR',  'Wemmetsw Rathaus' ],
	[ 'SWR',   'Wemmetsweiler' ],
	[ 'MWDS',  'Wendelstein' ],
	[ 'HWEB',  'Wenden-Bechtsbüt' ],
	[ 'HWEN',  'Wendessen' ],
	[ 'AWE',   'Wendisch Evern' ],
	[ 'BSH',   'Wendisch Rietz' ],
	[ 'AWDH',  'Wendland' ],
	[ 'XAWEN', 'Wendling' ],
	[ 'TWD',   'Wendlingen (N)' ],
	[ 'TWGN',  'Wengen' ],
	[ 'EWGG',  'Wengern O DB-Gr' ],
	[ 'EWGO',  'Wengern Ost' ],
	[ 'XSWY',  'Wengi-ey' ],
	[ 'EWMN',  'Wennemen' ],
	[ 'HWSN',  'Wennigsen/Deist' ],
	[ 'BWR',   'Werbig' ],
	[ 'BWRU',  'Werbig Bstg unt' ],
	[ 'BWRO',  'Werbig Bstg ob' ],
	[ 'BWRA',  'Werbig oben' ],
	[ 'DWR',   'Werdau' ],
	[ 'DWBN',  'Werdau Bgdr Nmsp' ],
	[ 'DWBW',  'Werdau Bgdr Wdsp' ],
	[ 'DWBZ',  'Werdau Bgdr Zwsp' ],
	[ 'DWND',  'Werdau Nord' ],
	[ 'WWD',   'Werder (b Neur)' ],
	[ 'BWE',   'Werder (Havel)' ],
	[ 'EWHL',  'Werdohl' ],
	[ 'FWDF',  'Werdorf' ],
	[ 'XAWRF', 'Werfen' ],
	[ 'BWPF',  'Werftpfuhl' ],
	[ 'KWHT',  'Werk Hürth' ],
	[ 'UD',    'Werkbf Deuna' ],
	[ 'ULH',   'Werkbf Lederhose' ],
	[ 'MSHW',  'Werkbf Terreno' ],
	[ 'LWT',   'Werkleitz' ],
	[ 'LWTG',  'Werkleitz DB-Gr' ],
	[ 'KWER',  'Werkstätte' ],
	[ 'EWER',  'Werl' ],
	[ 'FWER',  'Werlau' ],
	[ 'HWRT',  'Werlte' ],
	[ 'TWER',  'Wernau (Neckar)' ],
	[ 'NWRB',  'Wernberg' ],
	[ 'EWRT',  'Werne(Lippe)Ost' ],
	[ 'EWRN',  'Werne/Lippe' ],
	[ 'BWER',  'Werneuchen' ],
	[ 'BWEG',  'Werneuchen DB-Gr' ],
	[ 'NWFD',  'Wernfeld' ],
	[ 'NWFH',  'Wernfeld Hp' ],
	[ 'LWDE',  'Wernig Elmowerk' ],
	[ 'LWDK',  'Wernig HS Harz' ],
	[ 'LWDH',  'Werniger Hassero' ],
	[ 'LWD',   'Wernigerode' ],
	[ 'LWDT',  'Wernigerode West' ],
	[ 'UWH',   'Wernshausen' ],
	[ 'XAWR',  'Wernstein' ],
	[ 'HWRS',  'Wersen' ],
	[ 'MWHA',  'Wertach-Haslach' ],
	[ 'TWTB',  'Werth-Bestenh' ],
	[ 'TWT',   'Wertheim' ],
	[ 'UWTH',  'Werther' ],
	[ 'TWMH',  'Werthm Mainhafen' ],
	[ 'EWES',  'Wesel' ],
	[ 'EWFK',  'Wesel-Feldmark' ],
	[ 'WWE',   'Wesenberg' ],
	[ 'AWBU',  'Wesselburen' ],
	[ 'KWSL',  'Wesseling' ],
	[ 'KWSN',  'Wesseling Nord' ],
	[ 'KWSS',  'Wesseling Süd' ],
	[ 'KBZD',  'Wesseling-Berzdf' ],
	[ 'HWES',  'Wesseln' ],
	[ 'MWS',   'Weßling/Obb' ],
	[ 'EWBH',  'Westbarthausen' ],
	[ 'EQWB',  'Westbarthsn LGr' ],
	[ 'EWBV',  'Westbevern' ],
	[ 'BWES',  'Westend' ],
	[ 'MWDF',  'Westendorf' ],
	[ 'XAWD',  'Westendorf AT' ],
	[ 'FWBG',  'Westerburg' ],
	[ 'MWM',   'Westerham' ],
	[ 'EWSH',  'Westerholt' ],
	[ 'HWTH',  'Westerhsn/Melle' ],
	[ 'HWTK',  'Westerkappeln' ],
	[ 'AWLA',  'Westerland(Sylt)' ],
	[ 'TWEH',  'Westernhausen' ],
	[ 'TWS',   'Westerstetten' ],
	[ 'TWSH',  'Westerstetten Hp' ],
	[ 'HOCH',  'Westerst-Ocholt' ],
	[ 'XNWV',  'Westervoort NL' ],
	[ 'HWEW',  'Westerwalsede' ],
	[ 'DWES',  'Westewitz-Hochw' ],
	[ 'HGDW',  'Westf AG' ],
	[ 'BWH',   'Westhafen/S-Bahn' ],
	[ 'TWX',   'Westhausen' ],
	[ 'EWSM',  'Westheim (Westf)' ],
	[ 'NWFB',  'Westheim F+B' ],
	[ 'MWHS',  'Westheim/Schwab' ],
	[ 'NWL',   'Westheim-Langen' ],
	[ 'EWEF',  'Westhofen' ],
	[ 'BWKRR', 'Westkreuz (Rb)' ],
	[ 'BWKR',  'Westkreuz (Sb)' ],
	[ 'EWN',   'Westönnen' ],
	[ 'SRAW',  'Westrich' ],
	[ 'XBWR',  'Westrozebeke' ],
	[ 'UWEH',  'Wethau' ],
	[ 'FWT',   'Wetter (Hess-Na)' ],
	[ 'EWET',  'Wetter (Ruhr)' ],
	[ 'LWZE',  'Wetterzeube' ],
	[ 'LQWZ',  'Wetterzeube LGr' ],
	[ 'XSWE',  'Wettingen' ],
	[ 'FWR',   'Wetzlar' ],
	[ 'FWR G', 'Wetzlar Gbf' ],
	[ 'AWYU',  'Weyerdeelen-Umb' ],
	[ 'AWYM',  'Weyermoor' ],
	[ 'XBWW',  'Weywertz' ],
	[ 'XPWEZ', 'Wezyska' ],
	[ 'HWMO',  'Whv Mobil Oil' ],
	[ 'HWNG',  'Whv Nord DB-Gr' ],
	[ 'EWIC',  'Wickede (Ruhr)' ],
	[ 'NWK',   'Wicklesgreuth' ],
	[ 'ZIW',   'Wicklow' ],
	[ 'KWIC',  'Wickrath' ],
	[ 'KWIA',  'Wickrath Awanst' ],
	[ 'TWDN',  'Widdern' ],
	[ 'KWDG',  'Widdig' ],
	[ 'XKWI',  'Widnes' ],
	[ 'SWK',   'Wiebelskirchen' ],
	[ 'YLLWI', 'Wiederitzs Strw' ],
	[ 'LWI',   'Wiederitzsch' ],
	[ 'EWID',  'Wiederstein' ],
	[ 'DWID',  'Wiednitz' ],
	[ 'XPWIP', 'Wielen Polnocny' ],
	[ 'AWMD',  'Wiemersdorf' ],
	[ 'XAWK',  'Wien Donaukaibf' ],
	[ 'XAWF',  'Wien F-J Bf' ],
	[ 'XAWU',  'Wien Freudenau H' ],
	[ 'XAWIE', 'Wien Hbf' ],
	[ 'XAWIO', 'Wien Hbf (Ost)' ],
	[ 'XAWH',  'Wien Hütteldorf' ],
	[ 'XAWLH', 'Wien Lobau Hafen' ],
	[ 'XAWM',  'Wien Matzleinsdf' ],
	[ 'XAWG',  'Wien Meidling' ],
	[ 'XAWMI', 'Wien Mitte' ],
	[ 'XAWN',  'Wien Nordwestbf' ],
	[ 'XAWNP', 'Wien Praterstern' ],
	[ 'XAWSG', 'Wien Simmering' ],
	[ 'XAWS',  'Wien Südbf' ],
	[ 'XAWSO', 'Wien Südbf (Ost)' ],
	[ 'XAWSS', 'Wien Südbf (Süd)' ],
	[ 'XAWSF', 'Wien Südbf Fg' ],
	[ 'XAWW',  'Wien Westbf' ],
	[ 'XAWZ',  'Wien ZVbf' ],
	[ 'XAWNS', 'Wiener Neustadt' ],
	[ 'XAWP',  'Wien-Penzing' ],
	[ 'HWRN',  'Wieren' ],
	[ 'DWIS',  'Wiesa (Erzgeb)' ],
	[ 'NWU',   'Wiesau (Oberpf)' ],
	[ 'FW',    'Wiesbaden Hbf' ],
	[ 'FWO',   'Wiesbaden Ost' ],
	[ 'BAWS',  'Wiesenau' ],
	[ 'BWSU',  'Wiesenau Hp' ],
	[ 'BAWG',  'Wiesenau DB-Gr' ],
	[ 'DWSB',  'Wiesenburg (S)' ],
	[ 'BWG',   'Wiesenburg(Mark)' ],
	[ 'BWD',   'Wiesendamm' ],
	[ 'FWIF',  'Wiesenfeld' ],
	[ 'NWDC',  'Wiesenfeld/Cobg' ],
	[ 'RWI',   'Wiesental' ],
	[ 'NWIE',  'Wiesenthau' ],
	[ 'NWSH',  'Wiesentheid' ],
	[ 'TWID',  'Wieslensdorf' ],
	[ 'RWS',   'Wiesloch-Walldf' ],
	[ 'MWSM',  'Wiesmühl (Alz)' ],
	[ 'NWI',   'Wiesthal' ],
	[ 'HCWB',  'Wietzenbruch' ],
	[ 'HWZD',  'Wietzendorf' ],
	[ 'XSWI',  'Wil' ],
	[ 'MWBN',  'Wilburgstetten' ],
	[ 'RWIN',  'Wilching-Hallau' ],
	[ 'BWI',   'Wildau' ],
	[ 'TWIB',  'Wildberg (Württ)' ],
	[ 'WWBG',  'Wildberg(b Neur)' ],
	[ 'FBOS',  'Wild-Bosserode' ],
	[ 'FHNB',  'Wildeck-Hönebach' ],
	[ 'HWIH',  'Wildeshausen' ],
	[ 'NWF',   'Wildflecken' ],
	[ 'FOBS',  'Wild-Obersuhl' ],
	[ 'XAWI',  'Wildon' ],
	[ 'BWP G', 'Wildpark Gbf' ],
	[ 'BWPO',  'Wildpark Ost' ],
	[ 'BWPS',  'Wildpark Süd' ],
	[ 'BAWP',  'Wildpark West' ],
	[ 'FWIL',  'Wildsberg' ],
	[ 'TWL',   'Wilferdgn-Singen' ],
	[ 'RWSW',  'Wilgartswiesen' ],
	[ 'AWFS',  'Wilhelmsburg SB' ],
	[ 'FWL',   'Wilhelmsdorf/Ts' ],
	[ 'TWK',   'Wilhelmsglück' ],
	[ 'BWHA',  'Wilhelmsh Abzw' ],
	[ 'BWIG',  'Wilhelmshagen' ],
	[ 'HW',    'Wilhelmshaven' ],
	[ 'HWW',   'Wilhelmshaven W' ],
	[ 'BWHO',  'Wilhelmshorst' ],
	[ 'FWUE',  'Wilhelmshütte(L)' ],
	[ 'FKWSM', 'Wilhelmstraße' ],
	[ 'NWDM',  'Wilhermsdf Mitte' ],
	[ 'NWHD',  'Wilhermsdorf' ],
	[ 'HWNO',  'Wilhhv Nord' ],
	[ 'HWOE',  'Wilhhv Ölweiche' ],
	[ 'DWL',   'Wilischthal' ],
	[ 'DWI',   'Wilkau-Haßlau' ],
	[ 'XPWSW', 'Wilkowo Swieb' ],
	[ 'HWBD',  'Willebadessen' ],
	[ 'FWLN',  'Willingen' ],
	[ 'FQWL',  'Willingen HE/NRW' ],
	[ 'FWLM',  'Willmenrod' ],
	[ 'NWIG',  'Willmering' ],
	[ 'FWRT',  'Willroth' ],
	[ 'TWLB',  'Willsbach' ],
	[ 'WWLD',  'Wilmersdorf' ],
	[ 'FWTH',  'Wilsenroth' ],
	[ 'FQWT',  'Wilsenroth HE/RP' ],
	[ 'AWIR',  'Wilster' ],
	[ 'DWT',   'Wilthen' ],
	[ 'SWIG',  'Wiltingen (Saar)' ],
	[ 'XLWZ',  'Wiltz' ],
	[ 'XLWW',  'Wilwerwiltz' ],
	[ 'XFWI',  'Wilwisheim' ],
	[ 'MWI',   'Wilzhofen' ],
	[ 'XFWU',  'Wimmenau' ],
	[ 'SWIN',  'Wincheringen' ],
	[ 'EWIL',  'Windelsbleiche' ],
	[ 'RWND',  'Winden (Pfalz)' ],
	[ 'FQWH',  'NRW/RP' ],
	[ 'HWDH',  'Windheim (Weser)' ],
	[ 'NWB',   'Windischeschenb' ],
	[ 'XAWIG', 'Windischgarsten' ],
	[ 'NWIN',  'Windsbach' ],
	[ 'RWAE',  'Windschläg' ],
	[ 'NWD',   'Windsf-Dittenh' ],
	[ 'XFWM',  'Wingen-sur-Moder' ],
	[ 'UWIR',  'Wingerode' ],
	[ 'NWID',  'Wingersdorf' ],
	[ 'AWG',   'Wingst' ],
	[ 'NWKH',  'Winkelhaid' ],
	[ 'TWI',   'Winnenden' ],
	[ 'SWI',   'Winningen(Mosel)' ],
	[ 'HWIN',  'Winninghausen' ],
	[ 'SWNW',  'Winnweiler' ],
	[ 'XNWI',  'Winschoten' ],
	[ 'AWI',   'Winsen (Luhe)' ],
	[ 'HWID',  'Winsen(Luhe)Süd' ],
	[ 'TWIN',  'Winterb b Schorn' ],
	[ 'EWTB',  'Winterberg' ],
	[ 'NWN',   'Winterhausen' ],
	[ 'AWIM',  'Wintermoor' ],
	[ 'XBWI',  'Winterslag' ],
	[ 'KWTW',  'Winterswick(Moe)' ],
	[ 'XNWW',  'Winterswijk' ],
	[ 'XSWT',  'Winterthur' ],
	[ 'TWZH',  'Winzenhofen' ],
	[ 'UWIP',  'Wipperdorf' ],
	[ 'LWIP',  'Wippra' ],
	[ 'KWIR',  'Wirges' ],
	[ 'FWIR',  'Wirtheim' ],
	[ 'WWI',   'Wismar' ],
	[ 'WWIG',  'Wismar DB-Grenze' ],
	[ 'WWIH',  'Wismar Hafen' ],
	[ 'XFWBG', 'Wissembourg' ],
	[ 'EWIN',  'Wissen/Sieg' ],
	[ 'HWIS',  'Wissingen' ],
	[ 'EWIA',  'Wit-Annen Nord' ],
	[ 'XPWIT', 'Witnica' ],
	[ 'EWIK',  'Wittbräucke' ],
	[ 'XFWIH', 'Wittelsheim' ],
	[ 'EWIT',  'Witten Hbf' ],
	[ 'BWIN',  'Wittenau (Whr D)' ],
	[ 'XSWB',  'Wittenbach' ],
	[ 'WW',    'Wittenberge' ],
	[ 'WW N',  'Wittenberge Nord' ],
	[ 'WWT',   'Wittenhagen' ],
	[ 'KWIS',  'Witterschlick' ],
	[ 'DWIM',  'Wittgensdf Mitte' ],
	[ 'DWIO',  'Wittgensdorf ob' ],
	[ 'TWIT',  'Wittighausen' ],
	[ 'HWTT',  'Wittingen' ],
	[ 'HWTW',  'Wittingen West' ],
	[ 'HWIL',  'Wittlage' ],
	[ 'SWIH',  'Wittlich Hbf' ],
	[ 'BWMD',  'Wittmannsdf (NL)' ],
	[ 'HWTM',  'Wittmund' ],
	[ 'XFWT',  'Wittring' ],
	[ 'WWK',   'Wittstock (D)' ],
	[ 'FWZN',  'Witzenhausen N' ],
	[ 'MWIT',  'Witzighausen' ],
	[ 'DWIT',  'Witzschdorf' ],
	[ 'AWRT',  'Witzwort' ],
	[ 'KWL',   'W-Langerfeld' ],
	[ 'KWLP',  'W-Langerfeld Hp' ],
	[ 'LLWP',  'W-Leuschner-Pl' ],
	[ 'XPWLO', 'Wloclawek' ],
	[ 'XPWLB', 'Wloclawek Brzez' ],
	[ 'XPWLA', 'Wloszczowa' ],
	[ 'XPWLP', 'Wloszczowa Pol' ],
	[ 'RWRTA', 'Wö Badallee' ],
	[ 'RWRTK', 'Wö Badepark' ],
	[ 'KWO',   'W-Oberbarmen' ],
	[ 'XPWOD', 'Wodzislaw Slaski' ],
	[ 'XNWO',  'Woerden' ],
	[ 'UWOF',  'Woffleben' ],
	[ 'XSWO',  'Wohlen' ],
	[ 'UWOE',  'Wöhlsdorf Metall' ],
	[ 'AWLF',  'Wohltorf' ],
	[ 'LWN',   'Wohnstadt Nord' ],
	[ 'XFWY',  'Woippy' ],
	[ 'XPWOW', 'Wojnowice Wlkp' ],
	[ 'EWBC',  'Wolbeck' ],
	[ 'RWO',   'Wolfach' ],
	[ 'TWO',   'Wolfegg' ],
	[ 'LWO',   'Wolfen (Kr Bitt)' ],
	[ 'HWOL',  'Wolfenbüttel' ],
	[ 'HWOH',  'Wolfenbüttel Hp' ],
	[ 'LWOR',  'Wolferode' ],
	[ 'UWLH',  'Wölfershausen' ],
	[ 'FWOE',  'Wölfershm-Södel' ],
	[ 'SWOW',  'Wolfersweiler' ],
	[ 'FWFG',  'Wolfgang' ],
	[ 'FWFH',  'Wolfhagen' ],
	[ 'MWO',   'Wolfratshausen' ],
	[ 'HWOB',  'Wolfsburg Hbf' ],
	[ 'UWOL',  'Wolfsgefärth' ],
	[ 'NWM',   'Wolfsmünster' ],
	[ 'SWFS',  'Wolfstein' ],
	[ 'XAWT',  'Wolfurt' ],
	[ 'WWO',   'Wolgast' ],
	[ 'WWOH',  'Wolgast Hafen' ],
	[ 'WWOF',  'Wolgaster Fähre' ],
	[ 'XPWO',  'Wolin Pomorski' ],
	[ 'DWO',   'Wolkenstein' ],
	[ 'XAWO',  'Wolkersdorf' ],
	[ 'UWK',   'Wolkramshausen' ],
	[ 'BWOK',  'Wollankstraße' ],
	[ 'BWOU',  'Wollankstraße' ],
	[ 'LWLS',  'Wolmirstedt' ],
	[ 'MWBM',  'Wolnzach Markt' ],
	[ 'XPWLW', 'Wolow' ],
	[ 'LWPN',  'Wölpern' ],
	[ 'AWOL',  'Wolterdingen/Han' ],
	[ 'LWOL',  'Woltersdorf b Mg' ],
	[ 'BWOL',  'Woltersdorf/N-Ur' ],
	[ 'HWWI',  'Woltwiesche' ],
	[ 'XAWL',  'Wörgl' ],
	[ 'LWOZ',  'Wörlitz' ],
	[ 'XNWM',  'Wormerveer' ],
	[ 'FQWO',  'Worms Br LGr' ],
	[ 'FWOB',  'Worms Brücke' ],
	[ 'FWORE', 'Worms Einmündung' ],
	[ 'FWORG', 'Worms Gbf' ],
	[ 'FWOR',  'Worms Hbf' ],
	[ 'MWNS',  'Wörnitzstein' ],
	[ 'FWRR',  'Wörrstadt' ],
	[ 'FWOD',  'Wörsdorf' ],
	[ 'AWPW',  'Worspwede' ],
	[ 'MWTI',  'Wörth (Isar)' ],
	[ 'NWOE',  'Wörth (M)' ],
	[ 'RWRT',  'Wörth (Rhein)' ],
	[ 'RWRTL', 'Wörth Alte Bahnm' ],
	[ 'RWRG',  'Wörth AVG/DB' ],
	[ 'RWRTB', 'Wörth Bienwald' ],
	[ 'RWRTP', 'Wörth Bürgerpark' ],
	[ 'RWTG',  'Wörth DB/AVG' ],
	[ 'RWRD',  'Wörth Mozartstr' ],
	[ 'RWRTR', 'Wörth Rathaus' ],
	[ 'RWRZ',  'Wörth Zügelstr' ],
	[ 'RWSN',  'Wössingen' ],
	[ 'RWSO',  'Wössingen Ost' ],
	[ 'FRSA',  'W-Reichensachsen' ],
	[ 'AWRE',  'Wremen' ],
	[ 'AQWR',  'Wremen NI/HB' ],
	[ 'HWRX',  'Wrexen' ],
	[ 'BWRZ',  'Wriezen' ],
	[ 'AWST',  'Wrist' ],
	[ 'XPWBG', 'Wroblin Glog' ],
	[ 'XPWRB', 'Wroclaw Brochow' ],
	[ 'XPWRG', 'Wroclaw Gadow' ],
	[ 'XPWR',  'Wroclaw Glowny' ],
	[ 'XPWRL', 'Wroclaw Lesnica' ],
	[ 'XPWN',  'Wroclaw Nadodrze' ],
	[ 'XPWRD', 'Wroclaw Now Dwor' ],
	[ 'KWRO',  'W-Ronsdorf' ],
	[ 'XPWRZ', 'Wrzesnia' ],
	[ 'FWO G', 'Ws Ost Gbf' ],
	[ 'FWO B', 'Ws Ost Gbf (B)' ],
	[ 'FWO A', 'Ws Ost Gbf Ültg' ],
	[ 'FWB',   'Ws-Biebrich' ],
	[ 'FWB A', 'Ws-Biebrich Ült' ],
	[ 'FWEF',  'Ws-Erbenh Flugh' ],
	[ 'FWE',   'Ws-Erbenheim' ],
	[ 'FWIG',  'Ws-Igstadt' ],
	[ 'KWSO',  'W-Sonnborn' ],
	[ 'FWS',   'Ws-Schierstein' ],
	[ 'KWS G', 'W-Steinbeck Gbf' ],
	[ 'KWS',   'W-Steinbeck Pbf' ],
	[ 'EWAP',  'Wülfrath-Aprath' ],
	[ 'DWU',   'Wülknitz' ],
	[ 'UWF',   'Wünschendorf (E)' ],
	[ 'UWFN',  'Wünschendorf N' ],
	[ 'BWUE',  'Wünsdorf-Waldst' ],
	[ 'NWR A', 'Wür Rbf Ausfahrt' ],
	[ 'HQWS',  'NRW/HE' ],
	[ 'EWGD',  'Würgendorf' ],
	[ 'EWGT',  'Würgendorf Ort' ],
	[ 'NWHO',  'Wür-Heidingsf O' ],
	[ 'NWHWU', 'Wür-Heidingsf W' ],
	[ 'KWMB',  'Würselen-Merzb' ],
	[ 'SWB',   'Würzbach (Saar)' ],
	[ 'NWH F', 'Würzbg Hbf Zell' ],
	[ 'NWR U', 'Würzbg Rbf Zell' ],
	[ 'NWH',   'Würzburg Hbf' ],
	[ 'NWR',   'Würzburg Rbf' ],
	[ 'NWS',   'Würzburg Süd' ],
	[ 'NWZ',   'Würzburg-Zell' ],
	[ 'DWD',   'Wüstenbrand' ],
	[ 'DWST',  'Wüstendittdf' ],
	[ 'WWSF',  'Wüstenfelde' ],
	[ 'AWHF',  'Wüstenhöfen' ],
	[ 'NWBZ',  'Wüstenselbitz' ],
	[ 'BWST',  'Wüstermarke' ],
	[ 'HWUE',  'Wüsting' ],
	[ 'WWST',  'Wüstmark' ],
	[ 'BWT',   'Wuhletal' ],
	[ 'BWHH',  'Wuhlheide (SB)' ],
	[ 'LWU',   'Wulfen (Anhalt)' ],
	[ 'EWUF',  'Wulfen (Westf)' ],
	[ 'HWUF',  'Wulfsen Nord' ],
	[ 'HWUL',  'Wulften' ],
	[ 'MWUH',  'Wullenstetten Hp' ],
	[ 'NHOB',  'Wun-Holenbr' ],
	[ 'HWUN',  'Wunstorf' ],
	[ 'HWUG',  'Wunstorf DB-Gr' ],
	[ 'HWUS',  'Wunstorf Stadt' ],
	[ 'HWUW',  'Wunstorf West' ],
	[ 'KWU',   'W-Unterbarmen' ],
	[ 'KW',    'Wuppertal Hbf' ],
	[ 'NWLZ',  'Wurlitz' ],
	[ 'TWUM',  'Wurmlingen Mitte' ],
	[ 'TWUN',  'Wurmlingen Nord' ],
	[ 'UWCH',  'Wurzbach (Thür)' ],
	[ 'LWZ',   'Wurzen' ],
	[ 'WWH',   'Wusterhausen (D)' ],
	[ 'BWNG',  'Wusterm Nd DB-Gr' ],
	[ 'BWUS',  'Wustermark' ],
	[ 'BAWF',  'Wustermark Awf' ],
	[ 'BWUSN', 'Wustermark Awn' ],
	[ 'BWUG',  'Wustermark DB-Gr' ],
	[ 'BWURE', 'Wustermark Einfg' ],
	[ 'BWUNU', 'Wustermark N Ubf' ],
	[ 'BWUN',  'Wustermark Nord' ],
	[ 'BWUR',  'Wustermark Rbf' ],
	[ 'BWURO', 'Wustermark Wot' ],
	[ 'LWUZ',  'Wusterwitz' ],
	[ 'LQWU',  'Wusterwitz BB/ST' ],
	[ 'WRDN',  'Wustrau-Radensl' ],
	[ 'SWU',   'Wustweiler' ],
	[ 'RWBL',  'Wutachblick' ],
	[ 'UWU',   'Wutha' ],
	[ 'WWU',   'Wutike' ],
	[ 'RWUT',  'Wutöschingen' ],
	[ 'KWV',   'W-Vohwinkel' ],
	[ 'RWY',   'Wyhlen' ],
	[ 'XPWK',  'Wysoka Kamienska' ],
	[ 'KX',    'Xanten' ],
	[ 'XGX',   'Xanthi' ],
	[ 'XAY',   'Ybbs a.d.Donau' ],
	[ 'XDYD',  'Ydby' ],
	[ 'YBBYO', 'Yorckstr Strw' ],
	[ 'BGGS',  'Yorckstr(Gr-gör)' ],
	[ 'BYOR',  'Yorckstraße' ],
	[ 'XVY',   'Ystad' ],
	[ 'XVYB',  'Ytterby' ],
	[ 'XSY',   'Yverdon' ],
	[ 'XBYG',  'Yves-Gomezee' ],
	[ 'DZT',   'Zabeltitz' ],
	[ 'XRZB',  'Zabok' ],
	[ 'XTZM',  'Zabreh na Morave' ],
	[ 'XPZB',  'Zabrze' ],
	[ 'XPZM',  'Zabrze Makoszowy' ],
	[ 'WZN',   'Zachun' ],
	[ 'XRZD',  'Zadar' ],
	[ 'XTZT',  'Zadni Treban' ],
	[ 'XPZ',   'Zagan' ],
	[ 'XZZG',  'Zagorje' ],
	[ 'XRZ',   'Zagreb Gl.kol.' ],
	[ 'XRZZ',  'Zagreb Zapad' ],
	[ 'LZA',   'Zahna' ],
	[ 'XMZH',  'Zahony' ],
	[ 'NZH',   'Zainhammer' ],
	[ 'RZA',   'Zaisenhausen' ],
	[ 'XMZE',  'Zalaegerszeg' ],
	[ 'XMZL',  'Zalalövö' ],
	[ 'XMZV',  'Zalaszentivan' ],
	[ 'XUZN',  'Zalau Nord' ],
	[ 'ZUZA',  'Zalesciki' ],
	[ 'XZZA',  'Zalog' ],
	[ 'XMZ',   'Zamardi' ],
	[ 'XMZF',  'Zamardi felsö' ],
	[ 'XNZA',  'Zandvoort a.Zee' ],
	[ 'XMZA',  'Zankafürdö' ],
	[ 'XMZK',  'Zanka-Köveskal' ],
	[ 'NZA',   'Zapfendorf' ],
	[ 'ZUZ',   'Zaporoje 1' ],
	[ 'XRZP',  'Zapresic' ],
	[ 'XEZ',   'Zaragoza D.C.' ],
	[ 'WZAR',  'Zarrendorf' ],
	[ 'XPZY',  'Zary' ],
	[ 'HZSB',  'Zasenbeck' ],
	[ 'XPZS',  'Zasieki' ],
	[ 'XTZA',  'Zatec' ],
	[ 'ZUZT',  'Zatishe' ],
	[ 'LZAU',  'Zauschwitz' ],
	[ 'XPZAW', 'Zawiercie' ],
	[ 'TSZAH', 'Zazenhausen Hp' ],
	[ 'XPZN',  'Zbaszyn' ],
	[ 'XPZA',  'Zbaszynek' ],
	[ 'XTZC',  'Zbecno' ],
	[ 'XTZB',  'Zbiroh' ],
	[ 'XTZS',  'Zdar n Sazavou' ],
	[ 'XTZK',  'Zdar u Kamen n L' ],
	[ 'XTZDS', 'Zdarec u Skutce' ],
	[ 'XTZI',  'Zdice' ],
	[ 'XPZDZ', 'Zdieszowice' ],
	[ 'XTZD',  'Zdirec n Doubrav' ],
	[ 'ZUZD',  'Zdolbunov' ],
	[ 'XPZW',  'Zdunska Wola' ],
	[ 'XPZE',  'Zebrzydowa' ],
	[ 'XPZD',  'Zebrzydowice' ],
	[ 'LZK',   'Zeddenick S-Anh' ],
	[ 'XBZD',  'Zedelgem' ],
	[ 'XBZV',  'Zeebrugg Vorming' ],
	[ 'XBZ',   'Zeebrugge' ],
	[ 'XBZR',  'Zeebrugge Ramsk' ],
	[ 'BZS',   'Zeesen' ],
	[ 'WZE',   'Zehdenick (Mark)' ],
	[ 'WZEN',  'Zehdenick-Neuhof' ],
	[ 'YBBZD', 'Zehlendorf Strw' ],
	[ 'NZ',    'Zeil' ],
	[ 'NZK',   'Zeil Kümm Kiesw' ],
	[ 'BZA',   'Zeischa' ],
	[ 'DZNH',  'Zeithain' ],
	[ 'DZN',   'Zeithain Bogendr' ],
	[ 'LZ',    'Zeitz' ],
	[ 'LZZN',  'Zeitz Abzw Zn' ],
	[ 'LZZG',  'Zeitz DB-Gr' ],
	[ 'LZ G',  'Zeitz Gbf' ],
	[ 'XTZL',  'Zelec' ],
	[ 'XCZD',  'Zelennyi Dol' ],
	[ 'XTZRC', 'Zelezna Ruda C' ],
	[ 'XTZR',  'Zelezna Ruda M' ],
	[ 'XTZY',  'Zelezny Brod' ],
	[ 'RZLH',  'Zell (Harmersb.)' ],
	[ 'RZ',    'Zell (Wiesental)' ],
	[ 'XAZ',   'Zell am See' ],
	[ 'XAZZ',  'Zell am Ziller' ],
	[ 'UZL',   'Zella-Mehlis' ],
	[ 'UZLW',  'Zella-Mehlis W' ],
	[ 'LZD',   'Zellendorf' ],
	[ 'LQZD',  'Zellendorf BB/ST' ],
	[ 'NZLT',  'Zellertal' ],
	[ 'FZH',   'Zellhausen' ],
	[ 'FZR',   'Zell-Romrod' ],
	[ 'TEHZ',  'Zellstoffwerk' ],
	[ 'XAZW',  'Zeltweg' ],
	[ 'XBZZ',  'Zelzate' ],
	[ 'WZP',   'Zempin' ],
	[ 'ZBZE',  'Zenica Zelezara' ],
	[ 'FZE',   'Zennern' ],
	[ 'BZEP',  'Zepernick(b Brn)' ],
	[ 'FZEP',  'Zeppelinheim' ],
	[ 'EZE',   'Zeppenfeld' ],
	[ 'LZP',   'Zeppernick b Mg' ],
	[ 'LZE',   'Zerbst' ],
	[ 'KZE',   'Zerkall' ],
	[ 'XSZE',  'Zermatt' ],
	[ 'BZF',   'Zernsdorf' ],
	[ 'WZIN',  'Zerrenthin' ],
	[ 'XFZ',   'Zetting' ],
	[ 'UZU',   'Zeulenroda u Bf' ],
	[ 'RZE',   'Zeutern' ],
	[ 'RZEO',  'Zeutern Ost' ],
	[ 'RZES',  'Zeutern Sportpla' ],
	[ 'BZTH',  'Zeuthen S-B' ],
	[ 'UZE',   'Zeutsch' ],
	[ 'AZN',   'Zeven (Han)' ],
	[ 'AZNN',  'Zeven Nord' ],
	[ 'AZNS',  'Zeven Süd' ],
	[ 'XNZV',  'Zevenaar' ],
	[ 'XNZVA', 'Zevenaar B r a' ],
	[ 'XNZO',  'Zevenaar Oost' ],
	[ 'XPZG',  'Zgorzelec' ],
	[ 'XPZGM', 'Zgorzelec Miasto' ],
	[ 'XSZLA', 'ZH Limmattal A' ],
	[ 'XSZLE', 'ZH Limmattal E' ],
	[ 'XYZH',  'Ziar nad Hronom' ],
	[ 'XBZI',  'Zichem' ],
	[ 'XZZM',  'Zidani most' ],
	[ 'XSZB',  'Ziegelbrücke' ],
	[ 'WDRW',  'Ziegelei' ],
	[ 'FSUEZ', 'Ziegenberg' ],
	[ 'RZHB',  'Ziehbrunnen' ],
	[ 'LZI',   'Zielitz' ],
	[ 'LZIO',  'Zielitz Ort' ],
	[ 'LZI Z', 'Zielitz Stw B2' ],
	[ 'XPZIG', 'Zielona Gora' ],
	[ 'LZL',   'Ziepel' ],
	[ 'FZB',   'Zierenberg' ],
	[ 'FZBR',  'Zierenbg-Rosent' ],
	[ 'KZI',   'Zieverich' ],
	[ 'XYZ',   'Zilina' ],
	[ 'NZF',   'Zillendorf' ],
	[ 'BZIL',  'Ziltendorf' ],
	[ 'BZIG',  'Ziltendorf DB-Gr' ],
	[ 'BZW',   'Ziltendorf EKO' ],
	[ 'TZI',   'Zimmern /Grünsf' ],
	[ 'RZIM',  'Zimmern /Seckach' ],
	[ 'FZM',   'Zimmersrode' ],
	[ 'XWZ',   'Zimnica' ],
	[ 'WZ',    'Zinnowitz' ],
	[ 'XAZL',  'Zirl' ],
	[ 'NZIK',  'Zirndf Kneippa' ],
	[ 'NZI',   'Zirndorf' ],
	[ 'XTFS',  'Zirovice-Seniky' ],
	[ 'WZIR',  'Zirtow' ],
	[ 'XJZI',  'Zitomislici' ],
	[ 'DZ',    'Zittau' ],
	[ 'DXZ',   'Zittau Grenze' ],
	[ 'DZH',   'Zittau Hp' ],
	[ 'DZS',   'Zittau Süd' ],
	[ 'DZV',   'Zittau Vorstadt' ],
	[ 'XSZI',  'Zizers' ],
	[ 'XTZN',  'Zlin stred' ],
	[ 'ZUZN',  'Znamenka' ],
	[ 'ZUZP',  'Znamenka-Pas' ],
	[ 'LZBR',  'Zöberitz' ],
	[ 'DZL',   'Zoblitz' ],
	[ 'DZB',   'Zöblitz-Pobersh' ],
	[ 'XSZG',  'Zofingen' ],
	[ 'XYZO',  'Zohor' ],
	[ 'XBZO',  'Zolder' ],
	[ 'NZG',   'Zollberg' ],
	[ 'TZO',   'Zollern' ],
	[ 'MZHP',  'Zollhs-Petersth' ],
	[ 'BZLF',  'Zöllmersdorf' ],
	[ 'LZO',   'Zoo' ],
	[ 'KKZO',  'Zoobrücke Wende' ],
	[ 'MZO',   'Zorneding' ],
	[ 'XFZW',  'Zornhoff-Monsw' ],
	[ 'LZGL',  'Zörnigall' ],
	[ 'BZO',   'Zossen' ],
	[ 'BZO A', 'Zossen (Zoa)' ],
	[ 'BZOG',  'Zossen DB-Grenze' ],
	[ 'RZT',   'Zotzenbach' ],
	[ 'UZM',   'Zschachenmühle' ],
	[ 'DZSC',  'Zschaitz' ],
	[ 'LZH',   'Zschepa-Hohburg' ],
	[ 'LZBN',  'Zscherben' ],
	[ 'LHNZ',  'Zscherbener Str' ],
	[ 'DZP',   'Zschopau' ],
	[ 'DZPO',  'Zschopau Ost' ],
	[ 'LZS',   'Zschortau' ],
	[ 'KZU',   'Zuckerfabrik' ],
	[ 'KZ',    'Zülpich' ],
	[ 'XEZU',  'Zuera' ],
	[ 'XSZN',  'Zürich Enge' ],
	[ 'XSZF',  'Zürich Flughafen' ],
	[ 'XSZH',  'Zürich HB' ],
	[ 'XSZL',  'Zürich Limmattal' ],
	[ 'XSZW',  'Zürich Wiedikon' ],
	[ 'XSZWO', 'Zürich Wollishof' ],
	[ 'XSZA',  'Zürich-Altst.' ],
	[ 'XSZR',  'Zürich-Hardbr' ],
	[ 'XSML',  'Zürich-Mülligen' ],
	[ 'XSZO',  'Zürich-Oerlikon' ],
	[ 'XSZP',  'Zürich-Opfikon' ],
	[ 'XSZS',  'Zürich-Stadelhof' ],
	[ 'XSZV',  'Zürich-Vorbahnh' ],
	[ 'WZS',   'Züssow' ],
	[ 'WZSG',  'Züssow DB-Gr' ],
	[ 'TZU',   'Züttlingen' ],
	[ 'DZG',   'Zug' ],
	[ 'XSZU',  'Zug CH' ],
	[ 'XNZB',  'Zuidbroek' ],
	[ 'XPZUK', 'Zukowice' ],
	[ 'XEZM',  'Zumarraga' ],
	[ 'HZWD',  'Zumwalde' ],
	[ 'KZMU',  'Zur Mühlen' ],
	[ 'RZHN',  'Zusenhofen' ],
	[ 'XNZP',  'Zutphen goederen' ],
	[ 'RZUN',  'Zuzenhausen' ],
	[ 'XCZV',  'Zverevo' ],
	[ 'XJZW',  'Zvornik' ],
	[ 'DZWG',  'Zw Stadthalle' ],
	[ 'SZWR',  'Zwbr-Rosengarten' ],
	[ 'SZW',   'Zweibrücken Hbf' ],
	[ 'SQZW',  'Zweibrücken LGr' ],
	[ 'TZWE',  'Zwerchweg' ],
	[ 'DZW',   'Zwickau (S) Hbf' ],
	[ 'DZWK',  'Zwickau Bk B13' ],
	[ 'DZSG',  'Zwickau DB-Gr' ],
	[ 'DZW T', 'Zwickau Stw B10' ],
	[ 'DZW C', 'Zwickau Stw B13' ],
	[ 'DZW M', 'Zwickau Stw B4' ],
	[ 'DZWM',  'Zwickau Zentrum' ],
	[ 'DZWP',  'Zwickau-Pölb' ],
	[ 'NZWL',  'Zwiesel (Bay)' ],
	[ 'NZWU',  'Zwieselau' ],
	[ 'XNZW',  'Zwijndrecht' ],
	[ 'RZW',   'Zwingenbg(Baden)' ],
	[ 'FZW',   'Zwingenbg/Bergst' ],
	[ 'XNZL',  'Zwolle' ],
	[ 'XNZLG', 'Zwolle goederen' ],
	[ 'XNZLR', 'Zwolle rangeer' ],
	[ 'DZI',   'Zwönitz' ],
	[ 'DZWO',  'Zwota' ],
	[ 'DZWZ',  'Zwota-Zechenb' ],
	[ 'DZA',   'Zwotental' ],
	[ 'DZAG',  'Zwotental DB-Gr' ],
	[ 'DZWS',  'Zw-Schedewitz' ],
	[ 'XPZR',  'Zyrardow' ],
);

sub get_stations {
	return @stations;
}

sub normalize {
	my ($val) = @_;

	$val =~ s{Ä}{Ae}g;
	$val =~ s{Ö}{Oe}g;
	$val =~ s{Ü}{Ue}g;
	$val =~ s{ä}{ae}g;
	$val =~ s{ö}{oe}g;
	$val =~ s{ß}{sz}g;
	$val =~ s{ü}{ue}g;

	return $val;
}

sub get_station {
	my ($name) = @_;

	my $ds100_match = firstval { $name eq $_->[0] } @stations;

	if ($ds100_match) {
		return ($ds100_match);
	}

	return get_station_by_name($name);
}

sub get_station_by_name {
	my ($name) = @_;

	my $nname = lc($name);
	my $actual_match = firstval { $nname eq lc( $_->[1] ) } @stations;

	if ($actual_match) {
		return ($actual_match);
	}

	$nname = normalize($nname);
	$actual_match = firstval { $nname eq normalize( lc( $_->[1] ) ) } @stations;
	if ($actual_match) {
		return ($actual_match);
	}

	my @distances   = map { distance( $nname, $_->[1] ) } @stations;
	my $min_dist    = min(@distances);
	my @station_map = pairwise { [ $a, $b ] } @stations, @distances;

	my @substring_matches = grep { $_->[1] =~ m{$name}i } @stations;
	my @levenshtein_matches
	  = map { $_->[0] } grep { $_->[1] == $min_dist } @station_map;

	return uniq_by { $_->[0] } ( @substring_matches, @levenshtein_matches );
}

1;

__END__

=head1 NAME

Travel::Status::DE::IRIS::Stations - Station name to station code mapping

=head1 SYNOPSIS

    use Travel::Status::DE::IRIS::Stations;

    my $name = 'Essen Hbf';
    my @stations = Travel::Status::DE::IRIS::Stations::get_station_by_name(
      $name);

    if (@stations < 1) {
      # no matching stations
    }
    elsif (@stations > 1) {
      # too many matches
    }
    else {
      printf("Input '%s' matched station code %s (as '%s')\n",
        $name, @{$stations[0]});
    }

=head1 VERSION

version 0.00

=head1 DESCRIPTION

This module contains a mapping of DeutscheBahn station names to station codes.
A station name is a (perhaps slightly abbreviated) string naming a particular
station; a station code is a two to five character denoting a station for the
IRIS web service.

Example station names (code in parentheses) are:
"Essen HBf" (EE), "Aachen Schanz" (KASZ), "Do UniversitE<auml>t" (EDUV).

B<Note:> Station codes may contain whitespace.

=head1 METHODS

=over

=item Travel::Status::DE::IRIS::get_stations

Returns a list of [station code, station name] listrefs lexically sorted by
station name.

=item Travel::Status::DE::IRIS::get_station(I<$in>)

Returns a list of [station code, station name] listrefs matching I<$in>.

If a I<$in> is a valid station code, only one element ([I<$in>, related name])
is returned. Otherwise, it is passed to get_station_by_name(I<$in>) (see
below).

Note that station codes matching is case sensitive and must be exact.

=item Travel::Status::DE::IRIS::get_station_by_name(I<$name>)

Returns a list of [station code, station name] listrefs where the station
name matches I<$name>.

Matching happens in two steps: If a case-insensitive exact match exists, only
this one is returned. Otherwise, all stations whose name contains I<$name> as
a substring (also case-insensitive) are returned.

This two-step behaviour makes sure that not prefix-free stations can still be
matched directly. For instance, both "Essen-Steele" and "Essen-Steele Ost"
are valid station names, but "essen-steele" will only return "Essen-Steele".

=back

=head1 DIAGNOSTICS

None.

=head1 DEPENDENCIES

=over

=item * List::MoreUtils(3pm)

=item * List::Util(3pm)

=item * List::UtilsBy(3pm)

=item * Text::LevenshteinXS(3pm)

=back

=head1 BUGS AND LIMITATIONS

There is no support for intelligent whitespaces (to also match "-" and similar)
yet.

=head1 SEE ALSO

Travel::Status::DE::IRIS(3pm).

=head1 AUTHOR

Copyright (C) 2014-2015 by Daniel Friesel E<lt>derf@finalrewind.orgE<gt>

=head1 LICENSE

This module is licensed under the same terms as Perl itself.


