#!/usr/bin/perlnew
use strict;
use warnings;
use 5.014;
use Test::Simple tests => 1;
use Data::Dumper;

use Firewall::DBI::Oracle;


=lala
has dsn => (
    is => 'ro',
    isa => 'Str',
    required => 1,
);

has user => (
    is => 'ro',
    isa => 'Str',
    required => 1,
);

has password => (
    is => 'ro',
    isa => 'Str',
    required => 1,
);

has dbi => (
    is      => 'ro',
    lazy    => 1,
    builder => '_buildDbi',
);

has option => (
    is => 'ro',
    isa => 'HashRef[Str]',
    default => sub { {} },
);
=cut

my $db = {
    mt => { host => '10.25.10.72', port => 1521, sid  => 'mt', user => 'rsms', password => 'test1234' },
    t0paitsm => { host => '10.31.10.25', port => 1558, sid  => 't0paitsm', user => 'jemondata', password => 'rsms1234' },
};


my $dbi;

ok(
    do {
        my ($dbi2, $dbi3);
        eval {
            $dbi = Firewall::DBI::Oracle->new( dsn => 'dbi:Oracle:host=10.31.10.25;sid=t0paitsm;port=1558', user => 'jemondata', password => 'rsms1234' );
            #$dbi = Firewall::DBI::Oracle->new( dsn => 'dbi:Oracle:host=10.25.10.72;sid=mt;port=1521', user => 'rsms', password => 'test1234' );
            my $param = $db->{t0paitsm};
            $dbi2 = Firewall::DBI::Oracle->new( $param );
            $dbi3 = Firewall::DBI::Oracle->new( %$param );
        };
        warn $@ if $@;
        $dbi->isa('Firewall::DBI::Oracle')
            and $dbi2->isa('Firewall::DBI::Oracle')
            and $dbi3->isa('Firewall::DBI::Oracle')
    },
    ' 生成 Firewall::DBI::Oracle 对象');


=lala
say Dumper $dbi->execute("select sysdate from dual")->all;
my $lala = $dbi->clone;
say Dumper $lala->execute("select sysdate from dual")->all;
sleep;
=cut
