package Slovo::Controller::Stranici;
use Mojo::Base 'Slovo::Controller', -signatures;
use feature qw(lexical_subs unicode_strings);
## no critic qw(TestingAndDebugging::ProhibitNoWarnings)
no warnings "experimental::lexical_subs";

# Will be passed to the stash and used in the template

# Returns a list of page data for listing in menus.
# No permission filters are applied because f the user gets to this page, he
# should have passed throu all filters from the parrent page to this page.
# This SQL statement is supported now even in MySQL 8.
# https://stackoverflow.com/questions/324935/mysql-with-clause#325243
# https://sqlite.org/lang_with.html
my $breadcrumb = sub ($c, $pid, $language) {
  my $db = $c->dbx->db;
  my $rows = $db->query(<<"SQL", $pid, $language)->hashes;
WITH RECURSIVE pids(p)
  AS(VALUES(?) UNION SELECT pid FROM stranici s, pids WHERE s.id = p)
  SELECT s.alias, c.title FROM stranici s, celini c
  WHERE s.id IN pids
    AND c.page_id = s.id
    AND c.language = ?
    AND c.data_type = 'заглавѥ'
    AND s.page_type !='коренъ';
SQL

  return $rows;
};

# GET /<:страница>.стр<*пѫт>
# Display a page in the site
sub execute($c) {

  #TODO: handle different celini types like въпросъ, писанѥ, белѣжка, книга
  my $alias   = $c->stash->{'страница'};
  my $l       = $c->language;
  my $path    = $c->stash->{'пѫт'};
  my $preview = $c->is_user_authenticated && $c->param('прегледъ');
  my $user    = $c->user;
  state $json_path    = '/paths/~1страници/get/parameters/3/default';
  state $list_columns = $c->openapi_spec($json_path);
  state $not_found_id = $c->not_found_id;
  my $page
    = $c->stranici->find_for_display($alias, $user, $c->domain, $preview);
  $page //= $c->stranici->find($not_found_id);
  my $celini = $c->celini->all_for_display($page, $user, $l, $preview);
  $page->{is_dir} = $page->{permissions} =~ /^d/;
  return
    $c->render(
             breadcrumb => $page->{id} == $not_found_id
             ? []
             : $c->$breadcrumb($page->{pid}, $l),
             $page->{id} == $not_found_id ? (status => $c->not_found_code) : (),
             $page->{template} ? (template => $page->{template}) : (),
             celini       => $celini,
             list_columns => $list_columns,
             page         => $page,
             preview      => $preview,
             user         => $user,
    );
}

# Al the following routes are under /Ꙋправленѥ

# GET /stranici/create
# Display form for creating resource in table stranici.
sub create($c) {
  return $c->render(in => {});
}

# POST /stranici
# Add a new record to table stranici.
sub store($c) {
  my $user = $c->user;
  if ($c->current_route =~ /^api\./) {    #invoked via OpenAPI
    $c->openapi->valid_input or return;
    my $in = $c->validation->output;
    @$in{qw(user_id group_id changed_by)}
      = ($user->{id}, $user->{group_id}, $user->{id});
    my $id = $c->stranici->add($in);
    $c->res->headers->location(
                        $c->url_for("api.show_stranici", id => $id)->to_string);
    return $c->render(openapi => '', status => 201);
  }

  # 1. Validate input
  my $v = $c->_validation;
  return $c->render(action => 'create', in => {}) if $v->has_error;

  # 2. Insert it into the database
  my $in = $v->output;
  @$in{qw(user_id group_id)} = ($user->{id}, $user->{group_id});

  my $id = $c->stranici->add($in);

  # 3. Prepare the response data or just return "201 Created"
  # See https://developer.mozilla.org/docs/Web/HTTP/Status/201
  # TODO: make it more user friendly.
  return $c->redirect_to(edit_stranici => {id => $id});
}

# GET /stranici/:id/edit
# Display form for edititing resource in table stranici.
sub edit($c) {

  #TODO: implement language switching based on Ado::L18n
  my $row = $c->stranici->find_for_edit($c->stash('id'), $c->language);
  $c->req->param($_ => $row->{$_}) for keys %$row;    # prefill form fields.
  return $c->render(in => $row);
}

# PUT /stranici/:id
# Update the record in table stranici
sub update($c) {

  # Validate input
  my $v = $c->_validation;
  return $c->render(action => 'edit', stranici => {}) if $v->has_error;
  my $in = $v->output;

  # Update the record
  my $id = $c->param('id');
  $c->stranici->save($id, $in);

  # Redirect to the updated record or just send "204 No Content"
  # See https://developer.mozilla.org/docs/Web/HTTP/Status/204
  return $c->redirect_to('show_stranici', id => $id);
}

# GET /stranici/:id
# Display a record from table stranici.
sub show($c) {
  my $row = $c->stranici->find($c->param('id'));
  if ($c->current_route =~ /^api\./) {    #invoked via OpenAPI
    return
      $c->render(
         openapi => {errors => [{path => $c->url_for, message => 'Not Found'}]},
         status  => 404)
      unless $row;
    return $c->render(openapi => $row);
  }
  $row = $c->stranici->find($c->param('id'));
  return $c->render(text => $c->res->default_message(404), status => 404)
    unless $row;
  return $c->render(stranici => $row);
}

# GET /stranici
# List resources from table stranici.
## no critic qw(Subroutines::ProhibitBuiltinHomonyms)
sub index($c) {
  if ($c->current_route =~ /^api\./) {    #invoked via OpenAPI
    $c->openapi->valid_input or return;
    my $input = $c->validation->output;

    # TODO: Modify $input: add where clause, get also title in the requested
    # language from celini and merge it into the stranici object. Modify the
    # Swagger description of respons object to conform to the output.
    return $c->render(openapi => $c->stranici->all($input));
  }
  return $c->render(stranici => $c->stranici->all);
}

# DELETE /stranici/:id
sub remove($c) {
  if ($c->current_route =~ /^api\./) {    #invoked via OpenAPI
    $c->openapi->valid_input or return;
    my $input = $c->validation->output;
    my $row   = $c->stranici->find($input->{id});
    $c->render(
         openapi => {errors => [{path => $c->url_for, message => 'Not Found'}]},
         status  => 404)
      && return
      unless $row;
    $c->stranici->remove($input->{id});
    return $c->render(openapi => '', status => 204);
  }
  $c->stranici->remove($c->param('id'));
  return $c->redirect_to('home_stranici');
}


# Validation for actions that store or update
sub _validation($c) {
  $c->req->param(alias => $c->param('title')) unless $c->param('alias');
  for (qw(hidden deleted)) {
    $c->req->param($_ => 0) unless $c->param($_);
  }
  my $v = $c->validation;

  # Add validation rules for the record to be stored in the database
  $v->optional('pid',    'trim')->like(qr/^\d+$/);
  $v->optional('dom_id', 'trim')->like(qr/^\d+$/);
  $v->required('alias', 'slugify')->size(0, 32);
  $v->required('page_type', 'trim')->size(0, 32);
  $v->optional('sorting',     'trim')->like(qr/^\d+$/);
  $v->optional('template',    'trim')->size(0, 255);
  $v->optional('permissions', 'trim')->like(qr/^[dlrwx\-]{10}$/);
  $v->optional('user_id',     'trim')->like(qr/^\d+$/);
  $v->optional('group_id',    'trim')->like(qr/^\d+$/);
  $v->optional('tstamp',      'trim')->like(qr/^\d+$/);
  $v->optional('start',       'trim')->like(qr/^\d+$/);
  $v->optional('stop',        'trim')->like(qr/^\d+$/);
  $v->optional('published',   'trim')->in(2, 1, 0);
  $v->optional('hidden',  'trim')->in(1, 0);
  $v->optional('deleted', 'trim')->in(1, 0);
  $v->optional('changed_by', 'trim')->like(qr/^\d+$/);

  # Page attributes
  $v->required('title', 'xml_escape', 'trim')->size(3, 32);
  $v->optional('body',     'trim');
  $v->optional('title_id', 'trim')->like(qr/^\d+$/);
  $v->required('language', 'trim')->size(5, 5);
  return $v;
}

# GET/api/страници
# List of published pages under a given pid in the current domain.
# Used for sidedrawer or sitemap
sub list($c) {

  $c->openapi->valid_input or return;
  my $in      = $c->validation->output;
  my $user    = $c->user;
  my $preview = $c->is_user_authenticated && $c->param('прегледъ');
  my $list
    = $c->stranici->all_for_list($user, $c->domain, $preview, $c->language,
                                 $in);
  return $c->render(openapi => $list);
}

1;
