use v5.16.0;
use ExtUtils::MakeMaker;

my @exe = ('pl', $^O =~ /^MSWin/ ? 'pl.cmd' : ());
if( my $alt = $ENV{PL_ALT} ) {
    for( @exe ) {
	my $orig = $_;
	s/^pl/$alt/;
	link $orig, $_ and -f or eval {
	    require File::Copy;
	    File::Copy::copy( $orig, $_ );
	};
    }
}

WriteMakefile
    NAME		=> 'App::pl',
    AUTHOR		=> 'Daniel Pfeiffer <occitan@esperanto.org>',
    LICENSE		=> 'perl_5',
    VERSION_FROM	=> 'pl',
    ABSTRACT		=> 'Perl One-Liner Magic Wand',
    MIN_PERL_VERSION	=> v5.16.0,
    PREREQ_PM		=> {},
    EXE_FILES		=> \@exe,
    NO_MYMETA		=> 1,
    META_ADD		=> {
	distribution_type => 'script',
	dynamic_config => 0,
	prereqs => {
	    runtime => {
		suggests => { 'Algorithm::Diff' => 0 }
	    }
	},
	resources => {
	    repository => {
		type	=> 'git',
		url	=> 'git://git.code.sf.net/p/perl1liner/code',
		web	=> 'https://git.code.sf.net/p/perl1liner/code'
	    },
	    homepage => 'https://perl1liner.sourceforge.io/'
	}
    };
