#!perl
#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#
#   file: t/test-dist-zilla-build.t
#
#   Copyright © 2015 Van de Bugger
#
#   This file is part of perl-Test-Dist-Zilla.
#
#   perl-Test-Dist-Zilla is free software: you can redistribute it and/or modify it under the terms
#   of the GNU General Public License as published by the Free Software Foundation, either version
#   3 of the License, or (at your option) any later version.
#
#   perl-Test-Dist-Zilla is distributed in the hope that it will be useful, but WITHOUT ANY
#   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#   PURPOSE. See the GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License along with
#   perl-Test-Dist-Zilla. If not, see <http://www.gnu.org/licenses/>.
#
#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

use if $ENV{AUTOMATED_TESTING}, 'Test::DiagINC';
use Test::Routine;
with 'Test::Dist::Zilla::Build';

use Test::Fatal;
use Test::More;
use Test::Routine::Util;
use Test::Deep qw{ cmp_deeply re };
use Path::Tiny;

test 'Post-build' => sub {
    my ( $self ) = @_;
    my $expected = $self->expected;
    if ( $self->exception ) {
        plan skip_all => 'exception occurred';
    };
    plan tests => 2;
    my $built_in = path( $self->tzil->built_in );
    $self->_anno_line( 'Built in: ' . "$built_in" );
    ok( $built_in->is_dir, 'build directory exists' );
    if ( exists( $expected->{ files } ) ) {
        my @files = sort( map( { $_->basename . '' } $built_in->children() ) );
        $self->_anno_text( 'Content', @files );
        cmp_deeply( \@files, [ sort( @{ $expected->{ files } } ) ] );
    };
};

# --------------------------------------------------------------------------------------------------

plan tests => 2;

run_me 'Successful build' => {
    files => {
        'README' => 'Dummy README file',
    },
    plugins => [
        'GatherDir',
    ],
    expected => {
        files => [ 'dist.ini', 'README' ],
        messages => [
            '[DZ] beginning to build Dummy',
            re( qr{^\[DZ\] writing Dummy in } ),
        ],
    },
};

run_me 'Failed build' => {
    plugins => [
        'GatherDirOops',
    ],
    expected => {
        exception => re( qr{^Required plugin (Dist::Zilla::Plugin::)?GatherDirOops isn't installed\.} ),
        #   Older `Dizt::Zilla` may print short plugin name.
        messages => [
        ],
    },
};

done_testing;

exit( 0 );

# end of file #
