#!/usr/bin/perl
use strict;
use warnings;
use Test::More;
use Test::Exception;

use lib 'lib';

use Locale::Country::EU ':all';

subtest 'list_countries returns an ARRAY of hashes' => sub{
    my $array = list_eu_countries;
    isa_ok($array, 'ARRAY');
};

subtest 'is_eu_country throws when no arguement is provided' => sub {
    dies_ok { is_eu_country } 'die as expected';
};

subtest 'is_eu_country returns falsey on invalid country agruement' => sub {
    my $boolean = is_eu_country('United States of Whatever');
    ok($boolean eq 0, 'returned falsey value');
};

subtest 'is_eu_country returns truthy on valid country agruement' => sub {
    my $array = list_eu_countries;
    my $boolean = is_eu_country($array->[0]->{'ISO-name'});

    ok($boolean, 'returned truthy value');
};

done_testing();