=begin comment

Copyright (c) 2019 Aspose Pty Ltd

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

=end comment

=cut

package AsposeSlidesCloud::Object::MatrixElement;

require 5.6.0;
use strict;
use warnings;
use utf8;
use JSON qw(decode_json);
use Data::Dumper;
use Module::Runtime qw(use_module);
use Log::Any qw($log);
use Date::Parse;
use DateTime;

use AsposeSlidesCloud::Object::MathElement;

use base ("Class::Accessor", "Class::Data::Inheritable");


#
#Specifies the Matrix object,
#
# NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
# REF: https://github.com/swagger-api/swagger-codegen
#

#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
__PACKAGE__->mk_classdata('attribute_map' => {});
__PACKAGE__->mk_classdata('swagger_types' => {});
__PACKAGE__->mk_classdata('method_documentation' => {}); 
__PACKAGE__->mk_classdata('class_documentation' => {});

# new object
sub new { 
    my ($class, %args) = @_; 

	my $self = bless {}, $class;
	
	foreach my $attribute (keys %{$class->attribute_map}) {
		my $args_key = $class->attribute_map->{$attribute};
		$self->$attribute( $args{ $args_key } );
	}
	$self->{ type } = 'Matrix';
	return $self;
}  

# used by JSON for serialization
sub TO_JSON { 
    my $self = shift;
    my $_data = {};
    foreach my $_key (keys %{$self->attribute_map}) {
        if (defined $self->{$_key}) {
            $_data->{$self->attribute_map->{$_key}} = $self->{$_key};
        }
    }
    return $_data;
}


__PACKAGE__->class_documentation({description => 'Specifies the Matrix object,',
                                  class => 'MatrixElement',
                                  required => [], # TODO
}                                 );

__PACKAGE__->method_documentation({
    'type' => {
    	datatype => 'string',
    	base_name => 'Type',
    	description => 'Element type',
    	format => '',
    	read_only => '',
    		},
    'hide_placeholders' => {
    	datatype => 'boolean',
    	base_name => 'HidePlaceholders',
    	description => 'Hide the placeholders for empty matrix elements',
    	format => '',
    	read_only => '',
    		},
    'base_justification' => {
    	datatype => 'string',
    	base_name => 'BaseJustification',
    	description => 'Specifies the vertical justification respect to surrounding text. ',
    	format => '',
    	read_only => '',
    		},
    'min_column_width' => {
    	datatype => 'int',
    	base_name => 'MinColumnWidth',
    	description => 'Minimum column width in twips (1/20th of a point)',
    	format => '',
    	read_only => '',
    		},
    'column_gap_rule' => {
    	datatype => 'string',
    	base_name => 'ColumnGapRule',
    	description => 'The type of horizontal spacing between columns of a matrix.',
    	format => '',
    	read_only => '',
    		},
    'column_gap' => {
    	datatype => 'int',
    	base_name => 'ColumnGap',
    	description => 'The value of horizontal spacing between columns of a matrix',
    	format => '',
    	read_only => '',
    		},
    'row_gap_rule' => {
    	datatype => 'string',
    	base_name => 'RowGapRule',
    	description => 'The type of vertical spacing between rows of a matrix',
    	format => '',
    	read_only => '',
    		},
    'row_gap' => {
    	datatype => 'int',
    	base_name => 'RowGap',
    	description => 'The value of vertical spacing between rows of a matrix;             ',
    	format => '',
    	read_only => '',
    		},
    'items' => {
    	datatype => 'ARRAY[ARRAY[MathElement]]',
    	base_name => 'Items',
    	description => 'Matrix items',
    	format => '',
    	read_only => '',
    		},
});

__PACKAGE__->swagger_types( {
    'type' => 'string',
    'hide_placeholders' => 'boolean',
    'base_justification' => 'string',
    'min_column_width' => 'int',
    'column_gap_rule' => 'string',
    'column_gap' => 'int',
    'row_gap_rule' => 'string',
    'row_gap' => 'int',
    'items' => 'ARRAY[ARRAY[MathElement]]'
} );

__PACKAGE__->attribute_map( {
    'type' => 'Type',
    'hide_placeholders' => 'HidePlaceholders',
    'base_justification' => 'BaseJustification',
    'min_column_width' => 'MinColumnWidth',
    'column_gap_rule' => 'ColumnGapRule',
    'column_gap' => 'ColumnGap',
    'row_gap_rule' => 'RowGapRule',
    'row_gap' => 'RowGap',
    'items' => 'Items'
} );

__PACKAGE__->mk_accessors(keys %{__PACKAGE__->attribute_map});


1;
