OrderedCollection
	subclass: #Stack
	instanceVariableNames: 'stackType '
	classVariableNames: ''
	poolDictionaries: ''  !


!Stack class methods !
   
dataStack: aSize
        "create a Stack marked as a data stack"
	^(self new: aSize) stackType: false; yourself!
  
returnStack: aSize
        "create a Stack marked as a return stack"
	^(self new: aSize) stackType: true; yourself! !



!Stack methods !
 
drop
    " the DROP method"
    (self  size > 0)
    ifTrue: [ self removeLast. ^0 ].
        self isReturnStack ifTrue: [^-6]. "Return Stack underflow"
        ^-4 "Stack underflow"!

dup
    " the DUP method"
    (self  size > 0)
    ifTrue: [ self addLast: (self at: endPosition).
                 ^0 ].
        self isReturnStack ifTrue: [^-6]. "Return Stack underflow"
        ^-4 "Stack underflow"!
   
isReturnStack
	"true means returnStack"
	^stackType!
  
over
    " the OVER method"
    (self  size > 1)
    ifTrue: [ self addLast: (self at: (endPosition - 1)).
                 ^0 ].
        self isReturnStack ifTrue: [^-6]. "Return Stack underflow"
        ^-4 "Stack underflow"!
   
pop
    "remove top item from Stack, return proper THROW code"
    (self size > 0)
        ifTrue: [ self removeLast. ^0 ].
    self isReturnStack ifTrue: [^-6]. "Return stack underflow"
     ^-4 "Stack underflow"!
 
popPush: aStack
    "remove top item from self,
      push to aStack,
      return proper THROW code"
     (self size > 0)
        ifTrue: [ ^aStack push: self removeLast].   "push handles throw code"
        self isReturnStack ifTrue: [^-6]. "Return Stack underflow"
        ^-4 "Stack underflow"!
   
push: anObject
    "add to a Stack, return proper THROW code"
     self add: anObject. ^0
     "92-10-04 jax"!
   
pushPop: aStack
    "remove top item from aStack,
      push to self,
      return proper THROW code"
    (aStack size > 0)
        ifTrue: [ ^self push: aStack removeLast].   "push handles throw code"
        aStack isReturnStack ifTrue: [^-6]. "Return Stack underflow"
        ^-4 "Stack underflow"!

pushSize
        "underlies Forth DEPTH"
    ^self push: self size!
   
rot
    " the ROT method"
     (self  size > 2)
    ifTrue: [ self addLast: (self at: (endPosition - 2)).
     self removeAbsoluteIndex: (endPosition - 3).
                  ^0 ].
        self isReturnStack ifTrue: [^-6]. "Return Stack underflow"
        ^-4 "Stack underflow"!

stackType
	"true means returnStack"
	^stackType!
  
stackType: aBoolean
	"true means returnStack"
	stackType := aBoolean!
 
swap
    " the SWAP method"
    (self  size > 1)
    ifTrue: [ self addLast: (self at: (endPosition - 1)).
     self removeAbsoluteIndex: endPosition - 2.
                  ^0 ].
        self isReturnStack ifTrue: [^-6]. "Return Stack underflow"
        ^-4 "Stack underflow"! !
