 /*
  * Khoros: $Id$
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 *---------------------------------------------------------------------
 *            Copyright 1990 University of New Mexico
 * 
 * Permission to copy and modify this software and its documen- 
 * tation only for internal use in your organization is hereby 
 * granted, provided that this notice is retained thereon and 
 * on all copies.  UNM makes no representations as too the sui- 
 * tability and operability of this software for any purpose. 
 * It is provided 'as is' without express or implied warranty. 
 *  
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, 
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT- 
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL, 
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT- 
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS 
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER- 
 * FORMANCE OF THIS SOFTWARE. 
 *  
 * No other rights, including for example, the right to redis- 
 * tribute this software and its documentation or the right to 
 * prepare derivative works, are granted unless specifically 
 * provided in a separate license agreement. 
 * 
 *---------------------------------------------------------------------
 */
#include "unmcopyright.h"
#include "xvforms.h"
#include "form_info.h"


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name:  form_info.c
 >>>>
 >>>>      Program Desc:  code to extract values
 >>>>                     from the graphical user interface 
 >>>>
 >>>>            Author:  automatically generated by conductor
 >>>>
 >>>> Date Last Updated:  Thu Oct 24 23:11:05 1991
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


/********************************************************
*
*  Routine Name: xvf_get_master
*
*       Purpose: Fills in the user-specified
*                'master'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                forminfo - pointer to the user-specified
*                'master'
*
*       Output:  current values stored in  master
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_master(formptr, forminfo)

xvf_form *formptr;
master *forminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;

	/***** getting 'master' Form Information structure *****/


	index = 2;

	xvf_parse_workspace_line(database[index], &line_info);
	forminfo->image_workspace = line_info.workspace;

	index = 11;

	xvf_parse_quit_line(database[index], &line_info);
	forminfo->quit = line_info.selected;

	index = 13;

	xvf_parse_startsubform_line(database[index], &line_info);
	forminfo->files_subform_selected = line_info.selected;

	index = 28;

	xvf_parse_startsubform_line(database[index], &line_info);
	forminfo->disp_subform_selected = line_info.selected;

	index = 49;

	xvf_parse_startsubform_line(database[index], &line_info);
	forminfo->class_subform_selected = line_info.selected;

	index = 56;

	xvf_parse_startsubform_line(database[index], &line_info);
	forminfo->legend_subform_selected = line_info.selected;

	index = 76;

	xvf_parse_startsubform_line(database[index], &line_info);
	forminfo->zoom_subform_selected = line_info.selected;

	index = 85;

	xvf_parse_startsubform_line(database[index], &line_info);
	forminfo->scatter_plot_selected = line_info.selected;

}

/********************************************************
*
*  Routine Name: xvf_get_files_subform
*
*       Purpose: Fills in the user-specified
*                'master_files_subform'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                subforminfo - pointer to the user-specified
*                'master_files_subform'
*
*       Output:  current values stored in  'master_files_subform'
*
*    Called By:  the application program when appropriate

*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_files_subform(formptr, subforminfo)

xvf_form *formptr;
master_files_subform *subforminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 14;


	/*** extracting 'master->files_subform'
 	   Subform Information structure ***/


	index = 14;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->files_selected = line_info.selected;

}



/********************************************************
*
*  Routine Name: xvf_get_disp_subform
*
*       Purpose: Fills in the user-specified
*                'master_disp_subform'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                subforminfo - pointer to the user-specified
*                'master_disp_subform'
*
*       Output:  current values stored in  'master_disp_subform'
*
*    Called By:  the application program when appropriate

*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_disp_subform(formptr, subforminfo)

xvf_form *formptr;
master_disp_subform *subforminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 29;


	/*** extracting 'master->disp_subform'
 	   Subform Information structure ***/


	index = 29;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->disp_selected = line_info.selected;

}



/********************************************************
*
*  Routine Name: xvf_get_class_subform
*
*       Purpose: Fills in the user-specified
*                'master_class_subform'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                subforminfo - pointer to the user-specified
*                'master_class_subform'
*
*       Output:  current values stored in  'master_class_subform'
*
*    Called By:  the application program when appropriate

*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_class_subform(formptr, subforminfo)

xvf_form *formptr;
master_class_subform *subforminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 50;


	/*** extracting 'master->class_subform'
 	   Subform Information structure ***/


	index = 50;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->class_selected = line_info.selected;

}



/********************************************************
*
*  Routine Name: xvf_get_legend_subform
*
*       Purpose: Fills in the user-specified
*                'master_legend_subform'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                subforminfo - pointer to the user-specified
*                'master_legend_subform'
*
*       Output:  current values stored in  'master_legend_subform'
*
*    Called By:  the application program when appropriate

*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_legend_subform(formptr, subforminfo)

xvf_form *formptr;
master_legend_subform *subforminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 57;


	/*** extracting 'master->legend_subform'
 	   Subform Information structure ***/


	index = 57;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->legend_selected = line_info.selected;

}



/********************************************************
*
*  Routine Name: xvf_get_zoom_subform
*
*       Purpose: Fills in the user-specified
*                'master_zoom_subform'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                subforminfo - pointer to the user-specified
*                'master_zoom_subform'
*
*       Output:  current values stored in  'master_zoom_subform'
*
*    Called By:  the application program when appropriate

*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_zoom_subform(formptr, subforminfo)

xvf_form *formptr;
master_zoom_subform *subforminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 77;


	/*** extracting 'master->zoom_subform'
 	   Subform Information structure ***/


	index = 77;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->zoom_selected = line_info.selected;

}



/********************************************************
*
*  Routine Name: xvf_get_scatter_plot
*
*       Purpose: Fills in the user-specified
*                'master_scatter_plot'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                subforminfo - pointer to the user-specified
*                'master_scatter_plot'
*
*       Output:  current values stored in  'master_scatter_plot'
*
*    Called By:  the application program when appropriate

*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_scatter_plot(formptr, subforminfo)

xvf_form *formptr;
master_scatter_plot *subforminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 86;


	/*** extracting 'master->scatter_plot'
 	   Subform Information structure ***/


	index = 86;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->scatter_selected = line_info.selected;

}



/********************************************************
*
*  Routine Name: xvf_get_files
*
*       Purpose: Fills in the user-specified
*                'files_subform_files'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'files_subform_files'
*
*       Output:  current values stored in  'files_subform_files'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_files(formptr, paneinfo)

xvf_form *formptr;
files_subform_files *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 15;


	/* extracting 'master->files_subform->files'
 	   Pane Information structure */

	index++;

	xvf_parse_input_line(database[index], &line_info);
	if (line_info.filename != NULL) {
	   paneinfo->in_image = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->in_image = NULL;

	paneinfo->in_image_selected = line_info.selected;
	index++;

	xvf_parse_output_line(database[index], &line_info);
	if (line_info.filename != NULL) {

	   paneinfo->out_image = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->out_image = NULL;

	paneinfo->out_image_selected = line_info.selected;
	index++;

	index++;

	xvf_parse_input_line(database[index], &line_info);
	if (line_info.filename != NULL) {
	   paneinfo->in_legend = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->in_legend = NULL;

	paneinfo->in_legend_selected = line_info.selected;
	index++;

	xvf_parse_output_line(database[index], &line_info);
	if (line_info.filename != NULL) {

	   paneinfo->out_legend = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->out_legend = NULL;

	paneinfo->out_legend_selected = line_info.selected;
	index++;

	index++;

	xvf_parse_output_line(database[index], &line_info);
	if (line_info.filename != NULL) {

	   paneinfo->out_image_cmap = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->out_image_cmap = NULL;

	paneinfo->out_image_cmap_selected = line_info.selected;
	index++;

	xvf_parse_output_line(database[index], &line_info);
	if (line_info.filename != NULL) {

	   paneinfo->out_cmap = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->out_cmap = NULL;

	paneinfo->out_cmap_selected = line_info.selected;
	index++;

	index++;

	xvf_parse_quit_line(database[index], &line_info);
	paneinfo->quit = line_info.selected;
	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_disp
*
*       Purpose: Fills in the user-specified
*                'disp_subform_disp'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'disp_subform_disp'
*
*       Output:  current values stored in  'disp_subform_disp'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_disp(formptr, paneinfo)

xvf_form *formptr;
disp_subform_disp *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 30;


	/* extracting 'master->disp_subform->disp'
 	   Pane Information structure */

	xvf_parse_cycle_line(database[index], &line_info);
	paneinfo->norm_type = line_info.cycle_val;
	paneinfo->norm_type_selected = line_info.selected;
	index++;

	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->norm_time = line_info.logical_val;
	paneinfo->norm_time_selected = line_info.selected;
	index++;

	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->norm_method = line_info.logical_val;
	paneinfo->norm_method_selected = line_info.selected;
	index++;

	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->red = line_info.selected;
	index++;

	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->green = line_info.selected;
	index++;

	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->blue = line_info.selected;
	index++;

	index++;

	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->red_func = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->red_func = NULL;

	paneinfo->red_func_selected = line_info.selected;
	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->green_func = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->green_func = NULL;

	paneinfo->green_func_selected = line_info.selected;
	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->blue_func = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->blue_func = NULL;

	paneinfo->blue_func_selected = line_info.selected;
	index++;

	xvf_parse_input_line(database[index], &line_info);
	if (line_info.filename != NULL) {
	   paneinfo->file_view = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->file_view = NULL;

	paneinfo->file_view_selected = line_info.selected;
	index++;

	index++;

	xvf_parse_quit_line(database[index], &line_info);
	paneinfo->quit = line_info.selected;
	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_class
*
*       Purpose: Fills in the user-specified
*                'class_subform_class'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'class_subform_class'
*
*       Output:  current values stored in  'class_subform_class'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_class(formptr, paneinfo)

xvf_form *formptr;
class_subform_class *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 51;


	/* extracting 'master->class_subform->class'
 	   Pane Information structure */

	xvf_parse_workspace_line(database[index], &line_info);
	paneinfo->class_workspace = line_info.workspace;
	index++;

	index++;

	xvf_parse_quit_line(database[index], &line_info);
	paneinfo->quit = line_info.selected;
	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_legend
*
*       Purpose: Fills in the user-specified
*                'legend_subform_legend'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'legend_subform_legend'
*
*       Output:  current values stored in  'legend_subform_legend'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_legend(formptr, paneinfo)

xvf_form *formptr;
legend_subform_legend *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 58;


	/* extracting 'master->legend_subform->legend'
 	   Pane Information structure */

	xvf_parse_toggle_line(database[index], &line_info);
	paneinfo->color_model_val = line_info.toggle_val;
	paneinfo->color_model_selected = line_info.selected;
	index++;

	index = 65;
	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->delete = line_info.selected;
	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->empty = line_info.selected;
	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->show = line_info.selected;
	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->hide = line_info.selected;
	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->catch_all = line_info.selected;
	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->transfer = line_info.selected;
	index++;

	xvf_parse_workspace_line(database[index], &line_info);
	paneinfo->legend_workspace = line_info.workspace;
	index++;

	index++;

	xvf_parse_quit_line(database[index], &line_info);
	paneinfo->quit = line_info.selected;
	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_zoom
*
*       Purpose: Fills in the user-specified
*                'zoom_subform_zoom'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'zoom_subform_zoom'
*
*       Output:  current values stored in  'zoom_subform_zoom'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_zoom(formptr, paneinfo)

xvf_form *formptr;
zoom_subform_zoom *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 78;


	/* extracting 'master->zoom_subform->zoom'
 	   Pane Information structure */

	xvf_parse_float_line(database[index], &line_info);
	paneinfo->zoomfactor = line_info.float_val;
	paneinfo->zoomfactor_selected = line_info.selected;
	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->do_zoom = line_info.selected;
	index++;

	xvf_parse_workspace_line(database[index], &line_info);
	paneinfo->zoom_workspace = line_info.workspace;
	index++;

	index++;

	xvf_parse_quit_line(database[index], &line_info);
	paneinfo->quit = line_info.selected;
	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_scatter
*
*       Purpose: Fills in the user-specified
*                'scatter_plot_scatter'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'scatter_plot_scatter'
*
*       Output:  current values stored in  'scatter_plot_scatter'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_scatter(formptr, paneinfo)

xvf_form *formptr;
scatter_plot_scatter *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 87;


	/* extracting 'master->scatter_plot->scatter'
 	   Pane Information structure */

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->x_column = line_info.selected;
	index++;

	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->y_column = line_info.selected;
	index++;

	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->x_func = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->x_func = NULL;

	paneinfo->x_func_selected = line_info.selected;
	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->y_func = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->y_func = NULL;

	paneinfo->y_func_selected = line_info.selected;
	index++;

	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->prop = line_info.logical_val;
	paneinfo->prop_selected = line_info.selected;
	index++;

	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->operation = line_info.logical_val;
	paneinfo->operation_selected = line_info.selected;
	index++;

	xvf_parse_float_line(database[index], &line_info);
	paneinfo->zoomfactor = line_info.float_val;
	paneinfo->zoomfactor_selected = line_info.selected;
	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->select = line_info.selected;
	index++;

	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->set = line_info.selected;
	index++;

	xvf_parse_workspace_line(database[index], &line_info);
	paneinfo->plot_workspace = line_info.workspace;
	index++;

	index++;

	xvf_parse_quit_line(database[index], &line_info);
	paneinfo->quit = line_info.selected;
	index++;



}


