/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vasphere.c
 >>>>
 >>>>      Program Name: vasphere
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Generate an aspheric surface of revolution
 >>>>	
 >>>>	
 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Tue Apr 23 02:07:17 1991
 >>>>
 >>>>          Routines: main- the main program for vasphere
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vasphere.h"


/****************************************************************
 *
 * Routine Name:  main program for vasphere
 *
 *       Input:  
 *          -o  output image 
 *
 *
 *          [-r] desired number of rows in output image  (value > 0)
 *          [-c] desired number of columns in output image  (value > 0)
 *          [-cx] coordinate system X origin (pixel number)  (value >= 0)
 *          [-cy] coordinate system Y origin (pixel number)  (value >= 0)
 *          [-x] X offset of center of symmetry (meters) 
 *          [-y] Y offset of center of symmetry (meters) 
 *          [-curv] curvature parameter 
 *          [-a2] A2 Coefficient 
 *          [-a4] A4 Coefficient 
 *          [-a6] A6 Coefficient 
 *          [-a8] A8 Coefficient 
 *          [-a10] A10 Coefficient 
 *          [-piston] piston (meters) 
 *          [-s] pixel size (meters) 
 *          [-cutoff] cutoff radius (meters) 
 *          [-t] Selects data type of output image
 *		'byte' (choose Byte data storage type),
 *		'float' (choose Float data storage type),
 *		 or 'double' (choose Double data storage type)
 *		   [default = float] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image;
int type;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if(check_args())exit(1);

if(!vget_type(&type, vasphere->t_toggle))
  {
    fprintf(stderr,"vasphere:  Invalid data type specified\n");
    exit(1);
  }

if(type!=VFF_TYP_1_BYTE && type!=VFF_TYP_FLOAT && type !=VFF_TYP_DOUBLE)
  {
    fprintf(stderr,"%s:  Illegal image data type specified.\n",program);
    exit(1);
  }

if (vasphere->r_int <= 0 || vasphere->c_int <= 0)
  {
    fprintf(stderr,"%s: Rows and columns must be positive and non-zero\n",program);
    exit(1);
  }
/* -main_before_lib_call_end */

/* -main_library_call */
if(! lvasphere( &image,vasphere->r_int,vasphere->c_int, type,
              vasphere->cx_int,vasphere->cy_int,
              vasphere->x_float,vasphere->y_float, vasphere->s_float,
              vasphere->curv_float,
              vasphere->a2_float, vasphere->a4_float,
              vasphere->a6_float, vasphere->a8_float,
              vasphere->a10_float,
              vasphere->cutoff_float,vasphere->piston_float))
  {
      (void) fprintf(stderr, "lvasphere Failed\n");
      exit(1);
  }
/* -main_library_call_end */

/* -main_after_lib_call */
writeimage(vasphere->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vasphere 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vasphere :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tGenerate an aspheric surface of revolution\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-o  output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-r]  desired number of rows in output image (integer, > 0) [32]\n");
	fprintf(stderr,"\t[-c]  desired number of columns in output image (integer, > 0) [32]\n");
	fprintf(stderr,"\t[-cx]  coordinate system X origin (pixel number) (integer, >= 0) [16]\n");
	fprintf(stderr,"\t[-cy]  coordinate system Y origin (pixel number) (integer, >= 0) [16]\n");
	fprintf(stderr,"\t[-x]  X offset of center of symmetry (meters) (float) [0]\n");
	fprintf(stderr,"\t[-y]  Y offset of center of symmetry (meters) (float) [0]\n");
	fprintf(stderr,"\t[-curv]  curvature parameter (float) [0.1]\n");
	fprintf(stderr,"\t[-a2]  A2 Coefficient (float) [0]\n");
	fprintf(stderr,"\t[-a4]  A4 Coefficient (float) [0]\n");
	fprintf(stderr,"\t[-a6]  A6 Coefficient (float) [0]\n");
	fprintf(stderr,"\t[-a8]  A8 Coefficient (float) [0]\n");
	fprintf(stderr,"\t[-a10]  A10 Coefficient (float) [0]\n");
	fprintf(stderr,"\t[-piston]  piston (meters) (float) [0]\n");
	fprintf(stderr,"\t[-s]  pixel size (meters) (float) [0.1]\n");
	fprintf(stderr,"\t[-cutoff]  cutoff radius (meters) (float) [0]\n");
	fprintf(stderr, "\t[-t]  Selects data type of output image\n");
	fprintf(stderr, "\t\t'byte'  (choose Byte data storage type),\n");
	fprintf(stderr, "\t\t'float'  (choose Float data storage type),\n");
	fprintf(stderr, "\t\t or 'double'  (choose Double data storage type)\n");
	fprintf(stderr, "\t\t[default = float]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vasphere\n");
	fprintf(stderr, "\t[-U] Gives the usage for vasphere\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vasphere.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vasphere.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vasphere
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*o_pstr = 
	"\nEnter: (o) output image \n        {outfile}: "; 
char	*r_pstr = 
	"\nEnter: (r) desired number of rows in output image \n        {integer, > 0 [32] }: "; 
char	*c_pstr = 
	"\nEnter: (c) desired number of columns in output image \n        {integer, > 0 [32] }: "; 
char	*cx_pstr = 
	"\nEnter: (cx) coordinate system X origin (pixel number) \n        {integer, >= 0 [16] }: "; 
char	*cy_pstr = 
	"\nEnter: (cy) coordinate system Y origin (pixel number) \n        {integer, >= 0 [16] }: "; 
char	*x_pstr = 
	"\nEnter: (x) X offset of center of symmetry (meters) \n        {float [0.000000] }: "; 
char	*y_pstr = 
	"\nEnter: (y) Y offset of center of symmetry (meters) \n        {float [0.000000] }: "; 
char	*curv_pstr = 
	"\nEnter: (curv) curvature parameter \n        {float [0.100000] }: "; 
char	*a2_pstr = 
	"\nEnter: (a2) A2 Coefficient \n        {float [0.000000] }: "; 
char	*a4_pstr = 
	"\nEnter: (a4) A4 Coefficient \n        {float [0.000000] }: "; 
char	*a6_pstr = 
	"\nEnter: (a6) A6 Coefficient \n        {float [0.000000] }: "; 
char	*a8_pstr = 
	"\nEnter: (a8) A8 Coefficient \n        {float [0.000000] }: "; 
char	*a10_pstr = 
	"\nEnter: (a10) A10 Coefficient \n        {float [0.000000] }: "; 
char	*piston_pstr = 
	"\nEnter: (piston) piston (meters) \n        {float [0.000000] }: "; 
char	*s_pstr = 
	"\nEnter: (s) pixel size (meters) \n        {float [0.100000] }: "; 
char	*cutoff_pstr = 
	"\nEnter: (cutoff) cutoff radius (meters) \n        {float [0.000000] }: "; 
char	*t_pstr = "\nEnter: (t) Selects data type of output image -- \n      \t\t'byte' (choose Byte data storage type)\n\t\t'float' (choose Float data storage type)\n\t\tor 'double' (choose Double data storage type)\n  [float]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vasphere", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vasphere.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vasphere: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vasphere.ans");
		}

	     }

	}

	/*
	 * allocate the vasphere structure
	 */
	vasphere = (vasphere_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vasphere_struct));

	/*
	 * get required arguments for vasphere
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vasphere->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vasphere->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vasphere->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vasphere->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vasphere->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vasphere
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vasphere->r_flag = vget_int(fid, prompt_flag,
	"-r", r_pstr, &(vasphere->r_int),
	32, 2, 2);

	vasphere->c_flag = vget_int(fid, prompt_flag,
	"-c", c_pstr, &(vasphere->c_int),
	32, 2, 2);

	vasphere->cx_flag = vget_int(fid, prompt_flag,
	"-cx", cx_pstr, &(vasphere->cx_int),
	16, 1, 1);

	vasphere->cy_flag = vget_int(fid, prompt_flag,
	"-cy", cy_pstr, &(vasphere->cy_int),
	16, 1, 1);

	vasphere->x_flag = vget_float(fid, prompt_flag,
	"-x", x_pstr, &(vasphere->x_float),
	0.000000, 0.000000, 0.000000);

	vasphere->y_flag = vget_float(fid, prompt_flag,
	"-y", y_pstr, &(vasphere->y_float),
	0.000000, 0.000000, 0.000000);

	vasphere->curv_flag = vget_float(fid, prompt_flag,
	"-curv", curv_pstr, &(vasphere->curv_float),
	0.100000, 0.000000, 0.000000);

	vasphere->a2_flag = vget_float(fid, prompt_flag,
	"-a2", a2_pstr, &(vasphere->a2_float),
	0.000000, 0.000000, 0.000000);

	vasphere->a4_flag = vget_float(fid, prompt_flag,
	"-a4", a4_pstr, &(vasphere->a4_float),
	0.000000, 0.000000, 0.000000);

	vasphere->a6_flag = vget_float(fid, prompt_flag,
	"-a6", a6_pstr, &(vasphere->a6_float),
	0.000000, 0.000000, 0.000000);

	vasphere->a8_flag = vget_float(fid, prompt_flag,
	"-a8", a8_pstr, &(vasphere->a8_float),
	0.000000, 0.000000, 0.000000);

	vasphere->a10_flag = vget_float(fid, prompt_flag,
	"-a10", a10_pstr, &(vasphere->a10_float),
	0.000000, 0.000000, 0.000000);

	vasphere->piston_flag = vget_float(fid, prompt_flag,
	"-piston", piston_pstr, &(vasphere->piston_float),
	0.000000, 0.000000, 0.000000);

	vasphere->s_flag = vget_float(fid, prompt_flag,
	"-s", s_pstr, &(vasphere->s_float),
	0.100000, 0.000000, 0.000000);

	vasphere->cutoff_flag = vget_float(fid, prompt_flag,
	"-cutoff", cutoff_pstr, &(vasphere->cutoff_float),
	0.000000, 0.000000, 0.000000);


	/*
	 * get optional toggles for vasphere
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		vasphere->t_flag = vget_string(fid, prompt_flag,
		"-t", t_pstr, &(vasphere->t_toggle),
		"float");

		if (((strcmp(vasphere->t_toggle, "byte") == 0)) || 
		     ((strcmp(vasphere->t_toggle, "float") == 0)) || 
		     ((strcmp(vasphere->t_toggle, "double") == 0)))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		vasphere->t_flag = vget_string(fid, prompt_flag,
		"-t", t_pstr, &(vasphere->t_toggle),
		"float");

		if (((strcmp(vasphere->t_toggle, "byte") != 0)) && 
		     ((strcmp(vasphere->t_toggle, "float") != 0)) && 
		     ((strcmp(vasphere->t_toggle, "double") != 0)))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



