/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vgeneric.h
 >>>>            Author: Scott Wilson
 >>>> Date Last Updated: Mon Apr 15 22:18:48 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vgeneric_h_
#define _vgeneric_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vgeneric Argument Structure
*
****************************************************************/

typedef struct _vgeneric  {

/*
 *  selects minus sign (TRUE) or blank (FALSE) for input name #1 (Required logical)
 */
int	 di1_logic;	/* selects minus sign (TRUE) or blank (FALSE) for input name #1 LOGIC */
int	 di1_flag;  	/* selects minus sign (TRUE) or blank (FALSE) for input name #1 FLAG */

/*
 *  selects minus sign (TRUE) or blank (FALSE) for input name #2 (Required logical)
 */
int	 di2_logic;	/* selects minus sign (TRUE) or blank (FALSE) for input name #2 LOGIC */
int	 di2_flag;  	/* selects minus sign (TRUE) or blank (FALSE) for input name #2 FLAG */

/*
 *  selects minus sign (TRUE) or blank (FALSE) for input name #3 (Required logical)
 */
int	 di3_logic;	/* selects minus sign (TRUE) or blank (FALSE) for input name #3 LOGIC */
int	 di3_flag;  	/* selects minus sign (TRUE) or blank (FALSE) for input name #3 FLAG */

/*
 *  selects minus sign (TRUE) or blank (FALSE) for output name #1 (Required logical)
 */
int	 do1_logic;	/* selects minus sign (TRUE) or blank (FALSE) for output name #1 LOGIC */
int	 do1_flag;  	/* selects minus sign (TRUE) or blank (FALSE) for output name #1 FLAG */

/*
 *  selects minus sign (TRUE) or blank (FALSE) for output name #2 (Required logical)
 */
int	 do2_logic;	/* selects minus sign (TRUE) or blank (FALSE) for output name #2 LOGIC */
int	 do2_flag;  	/* selects minus sign (TRUE) or blank (FALSE) for output name #2 FLAG */

/*
 *  selects minus sign (TRUE) or blank (FALSE) for output name #3 (Required logical)
 */
int	 do3_logic;	/* selects minus sign (TRUE) or blank (FALSE) for output name #3 LOGIC */
int	 do3_flag;  	/* selects minus sign (TRUE) or blank (FALSE) for output name #3 FLAG */

/*
 *  selects minus sign (TRUE) or blank (FALSE) for arg name #1 (Required logical)
 */
int	 dn1_logic;	/* selects minus sign (TRUE) or blank (FALSE) for arg name #1 LOGIC */
int	 dn1_flag;  	/* selects minus sign (TRUE) or blank (FALSE) for arg name #1 FLAG */

/*
 *  selects minus sign (TRUE) or blank (FALSE) for arg name #2 (Required logical)
 */
int	 dn2_logic;	/* selects minus sign (TRUE) or blank (FALSE) for arg name #2 LOGIC */
int	 dn2_flag;  	/* selects minus sign (TRUE) or blank (FALSE) for arg name #2 FLAG */

/*
 *  selects minus sign (TRUE) or blank (FALSE) for arg name #3 (Required logical)
 */
int	 dn3_logic;	/* selects minus sign (TRUE) or blank (FALSE) for arg name #3 LOGIC */
int	 dn3_flag;  	/* selects minus sign (TRUE) or blank (FALSE) for arg name #3 FLAG */

/*
 *  selects minus sign (TRUE) or blank (FALSE) for arg name #4 (Required logical)
 */
int	 dn4_logic;	/* selects minus sign (TRUE) or blank (FALSE) for arg name #4 LOGIC */
int	 dn4_flag;  	/* selects minus sign (TRUE) or blank (FALSE) for arg name #4 FLAG */

/*
 *  selects minus sign (TRUE) or blank (FALSE) for arg name #5 (Required logical)
 */
int	 dn5_logic;	/* selects minus sign (TRUE) or blank (FALSE) for arg name #5 LOGIC */
int	 dn5_flag;  	/* selects minus sign (TRUE) or blank (FALSE) for arg name #5 FLAG */

/*
 *  selects minus sign (TRUE) or blank (FALSE) for arg name #6 (Required logical)
 */
int	 dn6_logic;	/* selects minus sign (TRUE) or blank (FALSE) for arg name #6 LOGIC */
int	 dn6_flag;  	/* selects minus sign (TRUE) or blank (FALSE) for arg name #6 FLAG */

/*
 *  selects minus sign (TRUE) or blank (FALSE) for arg name #7 (Required logical)
 */
int	 dn7_logic;	/* selects minus sign (TRUE) or blank (FALSE) for arg name #7 LOGIC */
int	 dn7_flag;  	/* selects minus sign (TRUE) or blank (FALSE) for arg name #7 FLAG */

/*
 *  selects minus sign (TRUE) or blank (FALSE) for arg name #8 (Required logical)
 */
int	 dn8_logic;	/* selects minus sign (TRUE) or blank (FALSE) for arg name #8 LOGIC */
int	 dn8_flag;  	/* selects minus sign (TRUE) or blank (FALSE) for arg name #8 FLAG */

/*
 *  prefix string (Optional string)
 */
char	*prefix_string;	/* prefix string STRING */
int	 prefix_flag;   	/* prefix string FLAG */

/*
 *  input image (Optional infile)
 */
char	*i_file;	/* input image FILENAME */
int	 i_flag;	/* input image FLAG */

/*
 *  output image or file (Optional outfile)
 */
char	*o_file;	/* output image or file FILENAME */
int	 o_flag;	/* output image or file FLAG */

/*
 *  name of input argument #1 (Optional string)
 */
char	*iname1_string;	/* name of input argument #1 STRING */
int	 iname1_flag;   	/* name of input argument #1 FLAG */

/*
 *  input filename #1 (Optional infile)
 */
char	*i1_file;	/* input filename #1 FILENAME */
int	 i1_flag;	/* input filename #1 FLAG */

/*
 *  name of input argument #2 (Optional string)
 */
char	*iname2_string;	/* name of input argument #2 STRING */
int	 iname2_flag;   	/* name of input argument #2 FLAG */

/*
 *  input filename #2 (Optional infile)
 */
char	*i2_file;	/* input filename #2 FILENAME */
int	 i2_flag;	/* input filename #2 FLAG */

/*
 *  name of input argument #3 (Optional string)
 */
char	*iname3_string;	/* name of input argument #3 STRING */
int	 iname3_flag;   	/* name of input argument #3 FLAG */

/*
 *  input filename #3 (Optional infile)
 */
char	*i3_file;	/* input filename #3 FILENAME */
int	 i3_flag;	/* input filename #3 FLAG */

/*
 *  name of output argument #1 (Optional string)
 */
char	*oname1_string;	/* name of output argument #1 STRING */
int	 oname1_flag;   	/* name of output argument #1 FLAG */

/*
 *  output filename #1 (Optional outfile)
 */
char	*o1_file;	/* output filename #1 FILENAME */
int	 o1_flag;	/* output filename #1 FLAG */

/*
 *  name of output argument #2 (Optional string)
 */
char	*oname2_string;	/* name of output argument #2 STRING */
int	 oname2_flag;   	/* name of output argument #2 FLAG */

/*
 *  output filename #2 (Optional outfile)
 */
char	*o2_file;	/* output filename #2 FILENAME */
int	 o2_flag;	/* output filename #2 FLAG */

/*
 *  name of output argument #3 (Optional string)
 */
char	*oname3_string;	/* name of output argument #3 STRING */
int	 oname3_flag;   	/* name of output argument #3 FLAG */

/*
 *  output filename #3 (Optional outfile)
 */
char	*o3_file;	/* output filename #3 FILENAME */
int	 o3_flag;	/* output filename #3 FLAG */

/*
 *  Name of argument #1 (Optional string)
 */
char	*name1_string;	/* Name of argument #1 STRING */
int	 name1_flag;   	/* Name of argument #1 FLAG */

/*
 *  argument #1 value (Optional string)
 */
char	*val1_string;	/* argument #1 value STRING */
int	 val1_flag;   	/* argument #1 value FLAG */

/*
 *  Name of argument #2 (Optional string)
 */
char	*name2_string;	/* Name of argument #2 STRING */
int	 name2_flag;   	/* Name of argument #2 FLAG */

/*
 *  argument #2 value (Optional string)
 */
char	*val2_string;	/* argument #2 value STRING */
int	 val2_flag;   	/* argument #2 value FLAG */

/*
 *  Name of argument #3 (Optional string)
 */
char	*name3_string;	/* Name of argument #3 STRING */
int	 name3_flag;   	/* Name of argument #3 FLAG */

/*
 *  argument #3 value (Optional string)
 */
char	*val3_string;	/* argument #3 value STRING */
int	 val3_flag;   	/* argument #3 value FLAG */

/*
 *  Name of argument #4 (Optional string)
 */
char	*name4_string;	/* Name of argument #4 STRING */
int	 name4_flag;   	/* Name of argument #4 FLAG */

/*
 *  argument #4 value (Optional string)
 */
char	*val4_string;	/* argument #4 value STRING */
int	 val4_flag;   	/* argument #4 value FLAG */

/*
 *  Name of argument #5 (Optional string)
 */
char	*name5_string;	/* Name of argument #5 STRING */
int	 name5_flag;   	/* Name of argument #5 FLAG */

/*
 *  argument #5 value (Optional string)
 */
char	*val5_string;	/* argument #5 value STRING */
int	 val5_flag;   	/* argument #5 value FLAG */

/*
 *  Name of argument #6 (Optional string)
 */
char	*name6_string;	/* Name of argument #6 STRING */
int	 name6_flag;   	/* Name of argument #6 FLAG */

/*
 *  argument #6 value (Optional string)
 */
char	*val6_string;	/* argument #6 value STRING */
int	 val6_flag;   	/* argument #6 value FLAG */

/*
 *  Name of argument #7 (Optional string)
 */
char	*name7_string;	/* Name of argument #7 STRING */
int	 name7_flag;   	/* Name of argument #7 FLAG */

/*
 *  argument #7 value (Optional string)
 */
char	*val7_string;	/* argument #7 value STRING */
int	 val7_flag;   	/* argument #7 value FLAG */

/*
 *  Name of argument #8 (Optional string)
 */
char	*name8_string;	/* Name of argument #8 STRING */
int	 name8_flag;   	/* Name of argument #8 FLAG */

/*
 *  argument #8 value (Optional string)
 */
char	*val8_string;	/* argument #8 value STRING */
int	 val8_flag;   	/* argument #8 value FLAG */

/*
 *  trailer string (Optional string)
 */
char	*trailer_string;	/* trailer string STRING */
int	 trailer_flag;   	/* trailer string FLAG */

}  vgeneric_struct;

vgeneric_struct *vgeneric;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
/* -include_macros_end */

#endif
