/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vblurlace.c
 >>>>
 >>>>      Program Name: vblurlace
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Corrects motion blur in images acquired in video  interlaced
 >>>>	mode.
 >>>>	
 >>>>	
 >>>>            Author: Donna Koechner, John Rasure
 >>>>
 >>>> Date Last Updated: Mon Apr 15 22:13:16 1991
 >>>>
 >>>>          Routines: main- the main program for vblurlace
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vblurlace.h"


/****************************************************************
 *
 * Routine Name:  main program for vblurlace
 *
 *       Input:  
 *           -i  input interlace image 
 *           -o  correct output image 
 *
 *
 *           [-s] number of pixels to shift 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */

if (check_args())
{
  fprintf(stderr, "%s: Illegal arguments on command line.\n", program);
  exit(1);
}

READINPUT(image);
CHECKINPUT(program,image);      /* Verify input image */

/* -main_before_lib_call_end */

/* -main_library_call */
    if(! lvblurlace(image,vblurlace->s_int))
    {
        (void) fprintf(stderr, "lvblurlace Failed\n");
        exit(1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(vblurlace->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vblurlace 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vblurlace :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCorrects motion blur in images acquired in video  interlaced\n");
	fprintf(stderr, "\tmode.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input interlace image  (infile)\n");
	fprintf(stderr,"\t-o  correct output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-s]  number of pixels to shift (integer) [0]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vblurlace\n");
	fprintf(stderr, "\t[-U] Gives the usage for vblurlace\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vblurlace.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vblurlace.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vblurlace
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input interlace image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) correct output image \n        {outfile}: "; 
char	*s_pstr = 
	"\nEnter: (s) number of pixels to shift \n        {integer [0] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vblurlace", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vblurlace.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vblurlace: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vblurlace.ans");
		}

	     }

	}

	/*
	 * allocate the vblurlace structure
	 */
	vblurlace = (vblurlace_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vblurlace_struct));

	/*
	 * get required arguments for vblurlace
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vblurlace->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vblurlace->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vblurlace->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vblurlace->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vblurlace->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vblurlace->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vblurlace->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vblurlace->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vblurlace->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vblurlace->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vblurlace
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vblurlace->s_flag = vget_int(fid, prompt_flag,
	"-s", s_pstr, &(vblurlace->s_int),
	0, 0, 0);


}



