/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvrcsum.c
 >>>>
 >>>>      Program Name: vrcsum
 >>>>
 >>>> Date Last Updated: Mon Apr 15 22:16:00 1991 
 >>>>
 >>>>          Routines: lvrcsum - the library call for vrcsum
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvrcsum - library call for vrcsum
*
* Purpose:
*    
*    Compute row and column sums
*    
*    
* Input:
*    
*    image          pointer to image structure to be analyzed
*    
*    
* Output:
*    
*    orimage        points to the image structure pointer  to  receive
*                   the row sums.
*    
*    ocimage        points to the image structure pointer  to  receive
*                   the column sums.
*    
*    Return Value:  1 on success, 0 on failure
*    
*    
*
* Written By: Scott Wilson
****************************************************************/


/* -library_def */
int
lvrcsum(image,orimage,ocimage)
struct xvimage *image,**orimage,**ocimage;
/* -library_def_end */

/* -library_code */
{
    int j,k;
    char *malloc();
    unsigned char *c;
    short *s;
    int *i;
    float *f;
    double *sr,*sc,*d;
    int rows,cols;
    int b,nb;

    rows = image->col_size;
    cols = image->row_size;
    nb = image->num_data_bands;

    if (orimage != NULL)
      {
        *orimage = createimage(1,rows,
                          VFF_TYP_DOUBLE,1,nb,
                          "Row Sums",0,0,VFF_MS_NONE,
                          VFF_MAPTYP_NONE,VFF_LOC_IMPLICIT,0);
        if (*orimage == NULL)
          {
            fprintf(stderr,"lvrcsum: Unable tp allocate row sum image\n");
            return(0);
          }
        bzero((*orimage)->imagedata,rows*nb*sizeof(double));
      }
    if (ocimage != NULL)
      {
        *ocimage = createimage(cols,1,
                          VFF_TYP_DOUBLE,1,nb,
                          "Column Sums",0,0,VFF_MS_NONE,
                          VFF_MAPTYP_NONE,VFF_LOC_IMPLICIT,0);
        if (*ocimage == NULL)
          {
            fprintf(stderr,"lvrcsum: Unable tp allocate column sum image\n");
            if (orimage != NULL) freeimage(*orimage);
            return(0);
          }
        bzero((*orimage)->imagedata,cols*nb*sizeof(double));
      }

    switch (image->data_storage_type)
      {
        case VFF_TYP_BIT :
          fprintf(stderr,"lvrcsum: Don't know how to rcsum a BIT image!\n");
          return(0);
          break;
        case VFF_TYP_1_BYTE : 
          c = (unsigned char *)(image->imagedata);
          if (orimage != NULL) sr = (double *)((*orimage)->imagedata);
          if (ocimage != NULL) sc = (double *)((*ocimage)->imagedata);
          for (b=0; b<nb; b++)
            for (j=0; j<rows; j++)
              for (k=0; k<cols; k++)
                {
                  if (orimage != NULL) sr[BPIXEL(b,0,j,rows,1)] +=
                                        c[BPIXEL(b,k,j,rows,cols)];
                  if (ocimage != NULL) sc[BPIXEL(b,k,0,1,cols)] +=
                                        c[BPIXEL(b,k,j,rows,cols)];
                }
          break;
        case VFF_TYP_2_BYTE :
          s = (short *)(image->imagedata);
          if (orimage != NULL) sr = (double *)((*orimage)->imagedata);
          if (ocimage != NULL) sc = (double *)((*ocimage)->imagedata);
          for (b=0; b<nb; b++)
            for (j=0; j<rows; j++)
              for (k=0; k<cols; k++)
                {
                  if (orimage != NULL) sr[BPIXEL(b,0,j,rows,1)] +=
                                        s[BPIXEL(b,k,j,rows,cols)];
                  if (ocimage != NULL) sc[BPIXEL(b,k,0,1,cols)] +=
                                        s[BPIXEL(b,k,j,rows,cols)];
                }
          break;
        case VFF_TYP_4_BYTE :
          i = (int *)(image->imagedata);
          if (orimage != NULL) sr = (double *)((*orimage)->imagedata);
          if (ocimage != NULL) sc = (double *)((*ocimage)->imagedata);
          for (b=0; b<nb; b++)
            for (j=0; j<rows; j++)
              for (k=0; k<cols; k++)
                {
                  if (orimage != NULL) sr[BPIXEL(b,0,j,rows,1)] +=
                                        i[BPIXEL(b,k,j,rows,cols)];
                  if (ocimage != NULL) sc[BPIXEL(b,k,0,1,cols)] +=
                                        i[BPIXEL(b,k,j,rows,cols)];
                }
          break;
        case VFF_TYP_FLOAT :
          f = (float *)(image->imagedata);
          if (orimage != NULL) sr = (double *)((*orimage)->imagedata);
          if (ocimage != NULL) sc = (double *)((*ocimage)->imagedata);
          for (b=0; b<nb; b++)
            for (j=0; j<rows; j++)
              for (k=0; k<cols; k++)
                {
                  if (orimage != NULL) sr[BPIXEL(b,0,j,rows,1)] +=
                                        f[BPIXEL(b,k,j,rows,cols)];
                  if (ocimage != NULL) sc[BPIXEL(b,k,0,1,cols)] +=
                                        f[BPIXEL(b,k,j,rows,cols)];
                }
          break;
        case VFF_TYP_DOUBLE :
          d = (double *)(image->imagedata);
          if (orimage != NULL) sr = (double *)((*orimage)->imagedata);
          if (ocimage != NULL) sc = (double *)((*ocimage)->imagedata);
          for (b=0; b<nb; b++)
            for (j=0; j<rows; j++)
              for (k=0; k<cols; k++)
                {
                  if (orimage != NULL) sr[BPIXEL(b,0,j,rows,1)] +=
                                        d[BPIXEL(b,k,j,rows,cols)];
                  if (ocimage != NULL) sc[BPIXEL(b,k,0,1,cols)] +=
                                        d[BPIXEL(b,k,j,rows,cols)];
                }
          break;
        case VFF_TYP_COMPLEX :
          fprintf(stderr,"lvrcsum: COMPLEX not supported\n");
          return(0);
          break;
        case VFF_TYP_DCOMPLEX :
          fprintf(stderr,"lvrcsum: DOUBLE COMPLEX not supported\n");
          return(0);
          break;
        default:
          fprintf(stderr,"lvrcsum: Unknown data storage type, %d\n",image->data_storage_type);
          return(0);
          break;
      }
      return(1);
}
/* -library_code_end */
