/*					    */
/*** symmetry.h - Nina Amenta, Aug. 1989 ****/
/*					    */
#define NUM_SYM 17

#define FALSE 0
#define SX 0
#define SY 1
#define EX 2
#define EY 3
#define GLIDE 1

typedef struct point_t
{
  float x;
  float y;
} POINT;


typedef struct rectangle_t
{
  float x;
  float y;
  float width;
  float height;
} RECTANGLE;

typedef POINT VECTOR;
typedef struct sym_t SYMMETRY;
typedef struct s_line LINE;
typedef float MATRIX[4];
typedef MATRIX XFORM;

/* Bit flags for dof (degrees of freedom) field of symmetry definition */
#define RAT 1
#define ANG 2

struct sym_t
{
  int dof;
  VECTOR v1;
  VECTOR v2;
  int refl;
  VECTOR reflections[2];
  int glide;
  int rot;
  char *label;
};


struct s_line
{
  MATRIX m;
  short id;
  LINE *next;
};

extern SYMMETRY SYMTAB[];
extern POINT ORIGIN;

#define RectIncludesPoint(r,p) \
	(((p).x>=(r).x) && \
         ((p).y>=(r).y) && \
	 (((p).x<=(r).x+(r).width)) && \
	 (((p).y<=(r).y+(r).height)))

#define PointRightOfRect(p,r) \
	 (((p).x>(r).x+(r).width))


#define bump(src,dest,scale,vec) \
{  (dest)->x=(scale)*(vec)->x+(src)->x; (dest)->y=(scale)*(vec)->y+(src)->y; }


