/*					    */
/*** kaliprint.c - Nina Amenta, Aug. 1989 ***/
/*					    */
#include <math.h>
#include <stdio.h>
#include "symmetry.h"

#define WID 1.2
#define PSSTACKSIZE 40

LINE *ReadPattern();
LINE *NewLine();
RECTANGLE clip;
LINE *MakeCurrentObject();
void DrawLine();
LINE *SpewObject();

main(argc, argv)
int	argc;
char	*argv[];
{
  FILE *pat;
  int i;
  RECTANGLE win_rect,bounds;
  POINT *sym_pts;
  int count;
  SYMMETRY *sym;
  float xforms[5][4];
  LINE *cur,*Lines,*obj;
  float scale;
  
  if (argc<2) {
      printf("file name on command line please!\n");
  }
  else 
    {
	pat = fopen(argv[1],"r");

	fscanf(pat,"%d\n",&i);
	sym = &SYMTAB[i];
	fscanf(pat,"%f %f\n",&win_rect.width,&win_rect.height);
	fscanf(pat,"%f %f\n",&(sym->v1.x),&(sym->v1.y));
	fscanf(pat,"%f %f\n",&(sym->v2.x),&(sym->v2.y));
	fscanf(pat,"%f\n",&scale);

	win_rect.x = win_rect.y = 0.0;
	init_postscript(&win_rect);
	count = SetUpSymmetry(sym,&sym_pts,xforms,&win_rect);
	DrawClippingRectangle(&win_rect);
	Lines = NULL;
	Lines = ReadPattern(Lines,pat);
	obj = MakeCurrentObject(Lines,sym,xforms,&bounds);
	/* Draw the object in pieces if necessary, to avoid
	   overflowing the Postscript stack */
	while (obj != NULL)
	    {
		obj = SpewObject(obj);
		ReplicateObject(&win_rect,obj,sym_pts,count,&bounds,
				&(sym->v1),&(sym->v2),DrawLine);
	    }
	close_postscript();
    }
}

DrawDot(p)
POINT *p;
{};

Flush() {};

LogTranslation(i)
int i;
{};

TranslateCoordinates(x,y,z)
float x,y,z;
{
    printf("gsave %6.3f %6.3f translate\n",x,y);
}

TranslateBack()
{
    printf("grestore\n");
}

void DrawLine(l)
LINE *l;
{
	printf("%6.3f %6.3f moveto\n",l->m[EX],l->m[EY]);
	printf("%6.3f %6.3f lineto\n",l->m[SX],l->m[SY]);
}  


DrawClippingRectangle(rec)
RECTANGLE *rec;
{
  printf("%6.3f %6.3f moveto\n",rec->x,rec->y);
  printf("%6.3f %6.3f lineto\n",rec->x,rec->height);
  printf("%6.3f %6.3f lineto\n",rec->width,rec->height);
  printf("%6.3f %6.3f lineto\n",rec->width,rec->y);
  printf("%6.3f %6.3f lineto\n",rec->x,rec->y);
  printf("closepath gsave stroke grestore\n");
  printf("clip newpath\n");
}


init_postscript (rec)
RECTANGLE *rec;
{
  float horiz,vert,units;
  printf("%%!-Adobe-1.0\n");
  printf("/inch {72 mul} def\n");
  printf("0 setgray\n");
  printf("/Times-Roman findfont 2 scalefont setfont\n");
  horiz = 7.5/rec->width;
  vert = 10.0/rec->height;
  units = (vert<horiz) ? vert : horiz;
  horiz = (8.5-(units*rec->width))/2.0;
  vert = (11.0-(units*rec->height))/2.0;
  printf("%4.3f inch %4.3f inch translate\n",horiz,vert);
  printf("%4.3f inch %4.3f inch scale\n",units,units);
  printf("%2.1f setlinewidth\n",WID);
  printf("1 setlinecap\n");
  printf("1 setlinejoin\n");
  printf("\n");
  CopyRectangle(rec,&clip);
}

close_postscript ()
{
  printf("showpage\n");
}


DrawObject(obj,drawing_routine)
LINE *obj;
void (*drawing_routine) ();
{
  printf("pattern\n");
}

LINE *SpewObject(obj)
LINE *obj;
{
int i;
    printf("/pattern { \n");
    printf("   newpath \n");
    i = 0;
    while ((i++ < PSSTACKSIZE) && (obj != NULL))
	{
	    DrawLine(obj);
	    obj = obj->next;
	}
    printf(" stroke } def\n");
    return(obj);
}
